var samplePageObj = {
  // 샘플 타이틀
  title: '행 높이 자동 맞춤',
  subtitle: '대용량 조회 모드에서 컬럼 size 에 맞추어 각 행들의 값이 자동으로 개행되어 맞추어지는 예제입니다.',
  // 샘플 설명
  desc: '컬럼 타입 Lines, Img, Html, Button 을 지원합니다. ',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0,
      AutoRowHeight: 1,
      HeaderMerge: 3,
      MessageWidth: 300,
      FitWidth: 1
    },
    Def: {
    },
    LeftCols: [
      {
        Type: 'Int',
        Width: 50,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: '운영기관명',
        Type: 'Lines',
        Name: 'Col1',
        Width: 180,
        Align: 'Left'
      },
      {
        Header: '상품명',
        Type: 'Lines',
        Name: 'Col2',
        Width: 190,
        Align: 'Left'
      },
      {
        Header: '운영기관\n구분',
        Type: 'Lines',
        Name: 'Col3',
        Width: 80,
        Align: 'Left'
      },
      {
        Header: '상품 구분',
        Type: 'Text',
        Name: 'Col4',
        Width: 80,
        Align: 'Center'
      },
      // {
      //   Header: '학자금\n유형구분',
      //   Type: 'Text',
      //   Name: 'Col5',
      //   Width: 100,
      //   Align: 'Left'
      // },
      {
        Header: '대학 구분',
        Type: 'Lines',
        Name: 'Col6',
        Width: 200,
        Align: 'Left'
      },
      // {
      //   Header: '학년 구분',
      //   Type: 'Text',
      //   Name: 'Col7',
      //   Width: 400,
      //   Align: 'Left'
      // },
      // {
      //   Header: '학과 구분',
      //   Type: 'Text',
      //   Name: 'Col8',
      //   Width: 400,
      //   Align: 'Left'
      // },
      // {
      //   Header: '성적기준',
      //   Type: 'Lines',
      //   Name: 'Col9',
      //   Width: 150,
      //   Align: 'Left'
      // },
      {
        Header: '소득기준',
        Type: 'Lines',
        Name: 'Col10',
        Width: 150,
        Align: 'Left'
      },
      // {
      //   Header: '지원내역',
      //   Type: 'Lines',
      //   Name: 'Col11',
      //   Width: 150,
      //   Align: 'Left'
      // },
      // {
      //   Header: '특정자격',
      //   Type: 'Text',
      //   Name: 'Col12',
      //   Width: 400,
      //   Align: 'Left'
      // },
      // {
      //   Header: '지역거주여부',
      //   Type: 'Text',
      //   Name: 'Col13',
      //   Width: 400,
      //   Align: 'Left'
      // },
      {
        Header: '신청접수일',
        Type: 'Text',
        Name: 'Col14',
        Width: 160,
        Align: 'Left'
      },
      // {
      //   Header: '선발방법',
      //   Type: 'Text',
      //   Name: 'Col15',
      //   Width: 400,
      //   Align: 'Left'
      // },
      {
        Header: '선발인원',
        Type: 'Lines',
        Name: 'Col16',
        Width: 150,
        Align: 'Left'
      },
      // {
      //   Header: '자격제한',
      //   Type: 'Text',
      //   Name: 'Col17',
      //   Width: 400,
      //   Align: 'Left'
      // },
      // {
      //   Header: '추천방법',
      //   Type: 'Text',
      //   Name: 'Col18',
      //   Width: 400,
      //   Align: 'Left'
      // },
      {
        Header: '제출서류',
        Type: 'Lines',
        Name: 'Col19',
        Width: 400,
        Align: 'Left'
      },
    ],

  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // style 추가
  internalStyles: 'a{text-decoration:none;color:#4444FF;}',

  // data
  data: [
    {
      Col1: '목포가톨릭대학교',
      Col2: '목포한사랑병원산학협력장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학7학기/대학8학기이상',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1학기 400만원(연간600만원) 복무조건으로 등록금과는 무관관',
      Col12: '2022년 간호학과 졸업예정자로 성적이 우수하고 품행이 단정한 자 지도교수의 추천을 받은 자졸업 후 본원에서 1년~2년 이상 또는 장기 근무 가능한 자',
      Col13: '해당없음',
      Col14: '2021-07-22~2021-08-06',
      Col15: '해당없음',
      Col16: '00명명',
      Col17: '해당없음',
      Col18: '지도교수님께 희망의사 표시시',
      Col19: '이력서 (자유서식)'
    },
    {
      Col1: '한국장학재단',
      Col2: '인문100년장학금',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '교육계열/사회계열/인문계열',
      Col9: ' * 계속장학생(전공확립유형)백분위 87점 이상 또는 평점 3.50/4.5만점(3.30이상/4.3만점) 최소이수학점 기준 : 직전학기 12학점 이상 * 장학생 중간 평가(2+2) 대상자계절학기 및 재수강 취득 성적을 포함하여 직전 2년간(1∼2학년) 4개 학기(5년제는 5개학기) 성적이 백분위 87점 이상 또는 평점 3.5이상/4.5만점(3.3이상/4.3만점) 성적기준 충족시 나머지 2년간 계속 지원  ※ 자세한 사항은 한국장학 홈페이지 참고',
      Col10: '해당없음',
      Col11: '등록금 : 장학생 선정 후 매학기별 등록금 전액 지원 (입학금 수업료 기성회비)생활비 : 선발된 장학생은 계속지원 충족 및 대학의 학생 자체평가 후 학기당 2000000원 지원 기초생활수급자 : 계속지원 기준을 충족하는 기초생활수급자는 학기당 2000000원 추가지원',
      Col12: ' * 대한민국 국적소지자로서 국내 4년제 대학의 인문사회계열 학과(부)에 재학중인 1학년 신입생 또는 3학년전공탐색 : 1학년 신입생전공확립 : 3학년 재학생',
      Col13: '해당없음',
      Col14: '2022-03-16~2022-04-12',
      Col15: '대학별 배정인원 범위 내에서 선발기준에 따라 대학별 자체 선발',
      Col16: ' ※ 학교마다 선발하는 인원이 상이하므로 장학부서에 확인 필수',
      Col17: '인문100년 장학금 장학생 자격 유지자 또는 기존 인문 100년장학생으로 선발된 후 영구탈락 된 학생한국장학재단에서 운영중인 타 장학금 기수혜자 또는 장학생 자격 유지자계약학과(등록금전액/일부지원) 선발제외 ※ 자세한 사항 첨부파일 참고',
      Col18: '해당없음',
      Col19: '신규장학생: 전공탐색유형/ 전공확립유형 : 학업계획서/ 전인적성장계획서 재학중 우수자: 대학자체선발 : 재단으로 직접 제출하는 서류 없음 계속장학생: 중간평가(2+2) : 중간평가서/ 학업장려비 : 진도보고서/ 교수평가서 ※ 자세한 사항은 한국장학재단 홈페이지 참고'
    },
    {
      Col1: '국립국제교육원',
      Col2: 'GKS외국인우수자비장학생',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '국내 대학 재학 전체 기간 동안 100점 만점에 평균 80점 이상직전 학기 학점이 100점 만점에 평균 80점 이상한국어 능력시험(TOLIK)4급 이상 ',
      Col10: '해당없음',
      Col11: '500만원(월 50만원) * 수혜기간 2022.3~2022.12 (10개월)',
      Col12: '2022년 3월 기준 국내 대학(전문대학 포함) 학부 과정에 재학중이고/ 2학기 이상을 이수한 외국인 자비유학생2학기 이상 이수과정이 남아 있는 자 대학에서 외국인 유학생으로 관리하고 있는 외국 국적 소유자 ',
      Col13: '해당없음',
      Col14: '2022-02-08~2022-02-23',
      Col15: '해당없음',
      Col16: '250명 대학별 추천인원 : 20명 이하 추천 가능',
      Col17: '휴학 중이거나 휴학 예정인 자/ 초과학기 포함 2학기 이수 잔여자교환학생이나 해외파견 예정자조기 졸업 예정자 ',
      Col18: '해당없음',
      Col19: '자세한 내용은 공고문 확인 바람람'
    },
    {
      Col1: '국립국제교육원',
      Col2: '국비유학생',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '제한없음',
      Col7: '대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '일반/ 꿈나래 전형은 평균성적이 만점의 80% 이상인 사람* 자세한 사항은 첨부파일 참조',
      Col10: '꿈나래 전형의 경우 수급권자·차상위계층·한부모지원대상자',
      Col11: '국가별 차이있음. 첨부자료 확인. (1년 단위로 장학금 지급)',
      Col12: '한국사능력검정시험 3급(또는 4급) 이상인 사람외국어 시험 성적(첨부파일 참고)을 충족하는 사람국내대학 졸업자/ 2021년 8월말 졸업예정자 또는 이와 같은 수준 이상의 학력이 있는 자※ 자세한 사항은 첨부파일 참조',
      Col13: '해당없음',
      Col14: '2022-05-16~2022-05-27',
      Col15: '1차 서류심사2차 면접시험',
      Col16: '일반전형 : 40명꿈나래전형 : 20명기술기능인 전형 : 4명',
      Col17: '원격대학 및 기술대학의 경우 전문학사학위를 받았거나 받을 예정인 사람은 제외남자는 군필 또는 면제자이중국적자의 경우 국비유학 전까지 외국국적을 포기해야 함자격취득과정은 지원불가',
      Col18: '해당없음',
      Col19: '제출서류 체크리스트응시원서대학졸업증명서 병적증명서대학 전 과정 성적증명서주민등록등본/ 가족관계증명서 (공고일 이후 발급분)추천서외국어 시험 성적표한국사능력검정시험 3급지원분야 관련 대외활동 실적 기술서 및 증빙서류국외수학 계획서대학원 전 과정 성적증명서(대학원 졸업자만 해당)저소득층 특별선형 응시자격 입증서류(꿈나래 전형 응시자해당)중소기업재직경력표(기술기능인 전형 응시다 해당)개인정보 제공 및 고유식별정보 처리 동의서 * 자세한 사항은 첨부자료 참고 필수'
    },
    {
      Col1: '광주남구장학회',
      Col2: '행복나눔 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 직전학기 12학점 이상 취득하고/ 성적 평균 2.75 이상인 자',
      Col10: '2021년도 기준 중위소득 150% 이하인 가구의 대학생 자녀',
      Col11: '1인당 1000000원 * 생활비 지원',
      Col12: '보호자 또는 본인이 선발 공고일 현재 주민등록상 주소지가 광주광역시 남구로 1년 이상 두고 신청 요건을 갖춘 자',
      Col13: '보호자 또는 본인이 선발 공고일 현재 주민등록상 주소지가 광주광역시 남구로 1년 이상 두고 신청 요건을 갖춘 자',
      Col14: '2021-09-27~2021-10-14',
      Col15: '1차 심사(사무국)2차 심사(심사위원회 확정)',
      Col16: '12명',
      Col17: '21년도 (재)남구장학회의 \'코로나19 특별장학생\' 중복 신청자21년도 빛고을장학재단 특별장학생 수혜자원격대학(방송통신대학/ 사이버대학)/ 기술대학/ 2년 미만 교육과정의 각종 학교/ 평생교육법에 의거 설립한 학교 재학생한 세대당 1명 지급 원칙',
      Col18: '대학교 총장(단/ 단과대학 위임시는 단과대학장)',
      Col19: '장학금 지원 신청서주민등록등본부모명의의 가족관계증명서건강보험료 납부확인서(2020년 6월~8월)성적증명서재학증명서개인(신용)정보 수집·이용·제공 및 조회 동의서신청인 서약서 * 자세한 사항은 첨부파일 참조 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '농파장학회',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 우수한 자 ',
      Col10: '가정형편이 곤란한 자',
      Col11: '4년간 등록금 전액 지급',
      Col12: '4년제 국내 국공립 대학합격자',
      Col13: '본적이 경남출신인 자',
      Col14: '2022-02-07~2022-02-11',
      Col15: '해당없음',
      Col16: '0명',
      Col17: '1. 형제 중 본 장학회에 입회된 자 또는 타 장학회 수혜자2. 휴학2회 이상자/ 성적불량자/ 장학생으로 품위가 없는 자3. 불순단체 가입자4. 중간에 대학 또는 과 바꾼 자',
      Col18: '출신 고등학교장',
      Col19: '1. 제출처(우편접수/ 방문접수 가능 / 원서접수일 마지막날까지 도착을 원칙으로 합니다. 접수 마감일에 발송할경우 원서접수 불가능)경상남도 진주시 진주대로 932(칠암동) 칠암빌딩4층 농파장학회2. 제출서류 ▷출신고등학교장의 추천서 ▷자기 소개서  ▷서약서 ▷가족관계등록부1통 (학생본인의 본적이 나와있는) ▷수능성적표 첨부 (사본가능) ▷(추천서 포함)사진2매(3cm× 4cm) ▷신입생 입학금 및 등록금 납입고지서 영수증사본 1부'
    },
    {
      Col1: '재단법인 조준장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학4학기/대학5학기',
      Col8: '특정학과',
      Col9: '전체학기 평점평균 3.8/4.3 이상',
      Col10: '5구간 이내의 가정형편이 어려운 남학생',
      Col11: '등록금 전액(결격사유 없을시 1년간 지급)',
      Col12: '군 제대 후 복학한 남학생/ 지방출신자 우선선발윤리 관련 강의 1학점 이상 이수자 ',
      Col13: '해당없음',
      Col14: '2021-12-27~2022-01-05',
      Col15: '1차 서류전형/ 2차 면접전형',
      Col16: '각 학교당 1명',
      Col17: '국비장학금을 포함 기타 다른 장학금을 받지 않는자',
      Col18: '* 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.',
      Col19: '장학생 지원 신청서지도교수 추천서자기소개서성적증명서재학증명서주민등록 등본 1부(생년월일만 나올 수 있도록 발급)부모의 재산세과세증명서 또는 바과세증명서개인정보수집동의서'
    },
    {
      Col1: '우리다문화장학재단',
      Col2: '학업장학',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '2022년 기준 중위소득 100% 이하인 가구',
      Col11: '1인당 4000000원(2회 분할지급)',
      Col12: '다문화가족 자녀국내 2/3/4년제 대학교 재학생 및 휴학생 (정규학기 12학점 이상)졸업까지 3학기 이상 남은 학생',
      Col13: '해당없음',
      Col14: '2022-05-03~2022-05-20',
      Col15: '해당없음',
      Col16: '30명',
      Col17: '외국인/ 북한이탈주민 지원불가특기장학과 중복지원 불가능',
      Col18: '소속대학 총장장 및 학과장/ 다문화 및 사회 복지기관장/ 지자체 및 주민센터장',
      Col19: '장학생 신청서자기소개서재학증명서성적증명서(신입생 제외)장학생 추천서주민등록등본 가족관계증명서다문화 학생임을 입증할 수 있는 서류 1부법정 저소득 증빙서류차상위 본인부담경감대상자 증명서(해당자)건강보험자격확인서(해당자)2022년 1월~3월 건강보험료 납부확인서(해당자)자원봉사활동 실적확인서(해당자)수상 실적 자료(해당자) * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '우리다문화장학재단',
      Col2: '특기장학',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 5000.000원',
      Col12: '특기 및 재능보유 다문화가족 자녀(8세~25세)예·체능 및 어학 특기자/ 자격·기술보유자/ 직업·진로 특기자 등최근 3년 이내에 전국 규모 이상의 대회 입상실적 또는 이에 상응하는 특기 및 재능 관련 실적자료 제출이 가능해야함',
      Col13: '해당없음',
      Col14: '2022-05-03~2022-05-20',
      Col15: '해당없음',
      Col16: '30명',
      Col17: '학업장학과 중복지원 불가외국인/ 새터민 지원 불가',
      Col18: '소속학교 총장(지도교수 및 학과장 포함)/ 특기·재능 관련 전문기관장/ 지자체 및 주민센터장/ 다문화 및 사회복지기관장',
      Col19: '장학생 신청서자기소개서서재학증명서 또는 졸업증명서 또는 재직증명서 또는 경력증명서장학생 추천서주민등록등본가족관계증명서다문화 학생임을 입증할 수 있는 서류법정 저소득 증빙서류(해당자)차상위 본인부담경감대상자 증명서(해당자)건강보험자격확인서(해당자)2021년 1월~3월 건강보험료 납부확인서(해당자)자원봉사활동 실적확인서(해당자)수상 실적 자료 또는 경력관련 포트폴리오 [필수] (수상확인서/ 상장 사본/ 관련기사 스크랩 등)'
    },
    {
      Col1: '지헌장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '예체능계열',
      Col9: '최근1년 평균성적 B+ 이상/ 3.5/4.5/ 3.3/4.3/ 3.1/4.0 이상)',
      Col10: '부모 또는 보호자의 년소득액이 5천만원 이하인자',
      Col11: '1000000원 * 생활비(학자금 및 디자인 재료비)로 타 장학금과 이중수혜 가능',
      Col12: '학업의지가 높고/ 학문적 자질이 우수한 인재4년제 대학교 3~4학년 재학생시각디자인 전공자 및 판화 전공자',
      Col13: '해당없음',
      Col14: '2022-09-01~2022-09-23',
      Col15: '1차 서류전형2차 면접전형 (필요시)',
      Col16: '44명 내외',
      Col17: '기업체 학술연수 및 입사 조건부 장학금을 받는 자장학금을 수령한 학기에는 휴학을 할 수 없으며/ 휴학의 경우 장학금을 반환해야 함',
      Col18: '학과장 추천   (1개교 2명 이내/ 단 2명 추천시 남·녀 각 1명)',
      Col19: '장학생 선발원서보호자 생활현황자기소개 및 학업계획서주민등록등본 또는 가족관계증명서부/모 또는 보호자 각각의 소득금액증명원 (2021년도 분)성적증명서입상증명서(해당자)통장사본(본인 또는 보호자)개인정보 수집/ 이용/ 제공 동의서 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '풍육장학회',
      Col2: '풍육장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적이 우수한 자.',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '풍양조씨 인 자행실이 바른 정규 4년제 대학 신입생 및 재학생해외 유학생',
      Col13: '해당없음',
      Col14: '2022-01-25~2022-02-18',
      Col15: '해당없음',
      Col16: '00명',
      Col17: ' 1세대 1자녀 원칙.타처에서 장학금을 받고 있는 학생은 신청 불가능수능성적이 없이 수시전형에 합격한 자는 신청할 수 없음.(진학한 후에 대학성적으로 신청해야함) 한번 수혜 받은 학생은 재신청 불가 전문대/대학원생 제외  * 이 외 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학금 수혜원서(본회 소정양식) 1통 * 이 장학금 수혜원서는 풍양조씨종보(제45호)에 수록된 양식 사용할 것성적증명서 (재적학교 발행) * 신입생 : 수능시험성적통지표/ 대학합격통지표 각1통 * 재학생 : 소속대학의 성적증명서/ 재학증명서 각 1통가족관계증명서 (동/ 읍/ 면사무소 발행) 1통(해당자에 한함)소속학교와 자신에 관한 소개서(해외 유학생의 경우) 1통'
    },
    {
      Col1: '하영호장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 2000000원 * 자부담 등록금 범위 내 결격사유가 없는 한 졸업 시까지 지원',
      Col12: '사각지대의 어려운 생활수준으로 장학금이 필요한 학생매월 첫째주 토요일 정기봉사에 참여할 수 있는 학생',
      Col13: '해당없음',
      Col14: '2022-08-23~2022-08-30',
      Col15: '1차 서류2차 면접( 1차 합격자에 한 함)',
      Col16: '해당없음',
      Col17: '기초수급 대상자 및 차상위계층은 제외',
      Col18: '담당교수',
      Col19: '자기소개서장학금 신청서성적증명서교수추천서주민등록등본재산세납입증명서 또는 소득확인 증빙서류재학증명서 * 자세한 사항은 각 학교 장학부서 또는 하영호장학재단 문의'
    },
    {
      Col1: '청양사랑인재육성장학회',
      Col2: '명문대입학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '명문대 입학한 자수능합 7등급 이내인자 ',
      Col10: '해당없음',
      Col11: '관내 중·고 졸업생: 10000000원관내 고교 졸업생: 5000000원',
      Col12: '군내 중학교와 고등학교를 졸업하고 명문대에 입학한 자* 명문대 범위 : 서울대/고려대/연세대/카이스트/포항공대/치의한의대/수능합 7등급 이내인 자(고려대/ 연세대는 지방캠퍼스 제외)',
      Col13: '장학생 선발 공고일 1년 전부터 부모 또는 본인이 청양군에 주소를 두고 거주한 자',
      Col14: '2022-03-02~2022-03-25',
      Col15: '재단법인 청양사랑 인재육성장학회 운영세칙\' 제6조 선발기준에 의거 (재)청양사랑인재육성장학회 장학위원회에서 선발',
      Col16: '해당없음',
      Col17: '신청일 현재 휴학생 및 당해 연도 1학기 휴학예정자 (단/ 신청접수 마감일까지 복학한 자는 예외로 한다)다른 장학금과 중복될 경우 제한될 수 있음 * 자세한 사항은 첨부파일 혹은 홈페이지 공고 참고',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보동의서중학교 졸업증명서고등학교 졸업증명서재학증명서주민등록초본(주소이력포함) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '청양사랑인재육성장학회',
      Col2: '충남도립대입학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '충남도립대학교 입학생',
      Col10: '해당없음',
      Col11: '1000000원 (생활비)',
      Col12: '관내 중학교와 고등학교를 졸업하고 충남도립대학교에 입학한 자공고일 현재 만 25세 이하',
      Col13: '장학생 선발 공고일 1년 전부터 부모 또는 본인이 청양군에 주소를 두고 거주한 자',
      Col14: '2022-03-02~2022-03-25',
      Col15: '재단법인 청양사랑 인재육성장학회 운영세칙\' 제6조 선발기준에 의거 (재)청양사랑인재육성장학회 장학위원회에서 선발',
      Col16: '해당없음',
      Col17: '신청일 현재 휴학생 및 당해 연도 1학기 휴학예정자 (단/ 신청접수 마감일까지 복학한 자는 예외로 한다)다른 장학금과 중복될 경우 제한될 수 있음공고일 현재 만 25세 이상인 자 제외',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보동의서중학교 졸업증명서고등학교 졸업증명서재학증명서주민등록초본(주소이력포함) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '청양사랑인재육성장학회',
      Col2: '성적우수장학금(대학교신입생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '군내 고등학교 1/2/3학년을 재학하고 졸업한자 중/ 직전학년 과목별 성적이 등급점수 4등급 이내인 자',
      Col10: '해당없음',
      Col11: '1500000원 (등록금)',
      Col12: '군내 고등학교 1/2/3학년을 재학하고 졸업한 자대학교 신입생',
      Col13: '장학생 선발 공고일 1년 전부터 부모 또는 본인이 청양군에 주소를 두고 거주한 자',
      Col14: '2022-03-02~2022-03-25',
      Col15: '재단법인 청양사랑 인재육성장학회 운영세칙\' 제6조 선발기준에 의거 (재)청양사랑인재육성장학회 장학위원회에서 선발.',
      Col16: '해당없음',
      Col17: '신청일 현재 휴학생 및 당해 연도 1학기 휴학예정자 (단/ 신청접수 마감일까지 복학한 자는 예외로 한다)다른 장학금과 중복될 경우 제한될 수 있음기타 장학위원회 결정에 따른다',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보동의서고등학교 졸업증명서군내 고등학교 재학증명서재학증명서성적증명서(직전학년)주민등록초본(주소이력포함) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '청양사랑인재육성장학회',
      Col2: '성적우수장학금(군내대학재학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학년 평점이 3.0 이상인자 (4.5점 만점기준)',
      Col10: '해당없음',
      Col11: '1500000원 (등록금)',
      Col12: '군내 대학 재학생군내고교 1/2/3학년 모두 재학 후 졸업한자',
      Col13: '장학생 선발 공고일 1년 전부터 부모 또는 본인이 청양군에 주소를 두고 거주한 자',
      Col14: '2022-03-02~2022-03-25',
      Col15: '재단법인 청양사랑 인재육성장학회 운영세칙\' 제6조 선발기준에 의거 (재)청양사랑인재육성장학회 장학위원회에서 선발.',
      Col16: '해당없음',
      Col17: '신청일 현재 휴학생 및 당해 연도 1학기 휴학예정자 (단/ 신청접수 마감일까지 복학한 자는 예외로 한다)다른 장학금과 중복될 경우 제한될 수 있음기타 장학위원회 결정에 따른다',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보동의서고등학교 졸업증명서군내 고등학교 재학증명서재학증명서성적증명서(직전학년)주민등록초본(주소이력포함) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '청양사랑인재육성장학회',
      Col2: '성적우수장학금(군외대학재학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학년 평점이 3.5 이상인자.(4.5점 만점기준)',
      Col10: '해당없음',
      Col11: '1500000원 (등록금)',
      Col12: '군내 고등학교 1/2/3학년 모두 재학 후 졸업한 자',
      Col13: '장학생 선발 공고일 1년 전부터 부모 또는 본인이 청양군에 주소를 두고 거주한 자',
      Col14: '2022-03-02~2022-03-25',
      Col15: '재단법인 청양사랑 인재육성장학회 운영세칙\' 제6조 선발기준에 의거 (재)청양사랑인재육성장학회 장학위원회에서 선발',
      Col16: '해당없음',
      Col17: '신청일 현재 휴학생 및 당해 연도 1학기 휴학예정자 (단/ 신청접수 마감일까지 복학한 자는 예외로 한다)다른 장학금과 중복될 경우 제한될 수 있음기타 장학위원회 결정에 따른다',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보동의서고등학교 졸업증명서군내 고등학교 재학증명서재학증명서성적증명서(직전학년)주민등록초본(주소이력포함) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '청양사랑인재육성장학회',
      Col2: '예체능장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원 (생활비)',
      Col12: '군내 초/ 중/ 고/ 대학 재학생 및 군내 초등학교나 중학교 또는 고등학교를 졸업한 군외/중/ 고/ 대학생 중 직전학년 예/ 체능부문 성적이 전국규모대회에서 3위 이상 입상한 자와 체육부문은 도 대회 1위 입상한 자',
      Col13: '장학생 선발 공고일 1년 전부터 부모 또는 본인이 청양군에 주소를 두고 거주한 자',
      Col14: '2022-03-02~2022-03-25',
      Col15: '재단법인 청양사랑 인재육성장학회 운영세칙\' 제6조 선발기준에 의거 (재)청양사랑인재육성장학회 장학위원회에서 선발',
      Col16: '해당없음',
      Col17: '신청일 현재 휴학생 및 당해 연도 1학기 휴학예정자 (단/ 신청접수 마감일까지 복학한 자는 예외로 한다)다른 장학금과 중복될 경우 제한될 수 있음기타 장학위원회 결정에 따른다',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보동의서재학증명서입상증명서류(직전학년)주민등록초본(주소이력포함)졸업증명서(군내 초·중·고 중 1개/ 군외 대학생 해당) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '봉평태기장학회',
      Col2: '일반장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학교 재학생은 前학기 평균성적이 90점(백분율 환산점수) 이상대학교 신입생은 수학능력점수 90점(백분율 환산점수) 이상',
      Col10: '해당없음',
      Col11: '전문대 : 1000000원국·사립대 : 1500000원 내외',
      Col12: '2022년 7월 30일 현재까지 보호자의 본적 또는 주소가 봉평면내에 되어 있는 대학교 재학생·신입생',
      Col13: '본적을 봉평면내에 두고 기준일 현재 주소가 봉평면낸에 3년 이상 거주하고 있는 자.단/ 본적이 타 지역인 자는 5년 이상 거주',
      Col14: '2022-08-19~2022-08-31',
      Col15: '예산범위내 성적순 선발/ 장학이사회 심의 후 개별통보 예정',
      Col16: '해당없음',
      Col17: '학자금 면제자/ 타장학금 일백만원 이상 수혜대상 확정자',
      Col18: '해당없음',
      Col19: '장학생 지원서 (소정양식/ 봉평면사무소 비치)/ (반명함사진)성적증명서 (학교장발행)장학금 미수혜확인서 (학교장 발행)가족관계등록부/ 주미등록 등·초본 각 1부 * 봉평면사무소 총무과 제출 * 자세한 사항은 첨부파일 또는 홈페이지 게시판 참고'
    },
    {
      Col1: '봉평태기장학회',
      Col2: '향토장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학교 재학생은 前학기 성적이 85점(백분율 환산점수) 이상대학교 신입생은 수학능력점수 85점(백분율 환산점수) 이상',
      Col10: '차상위계층·수급자 우선가정형편이 어려운 학생 * 보호자의 재산세(재산세 도시계획세 소방공동시설세 지방교육세) 세액 10000원 미만 및 종합토지세 5000원 이하',
      Col11: '전문대 : 1000000원국·사립대 : 1500000원 내외',
      Col12: '2022년 7월 30일 현재까지 보호자의 본적 또는 주소가 봉평면내에 되어 있는 대학교 재학생·신입생',
      Col13: '본적을 봉평면내에 두고 기준일 현재 주소가 봉평면낸에 3년 이상 거주하고 있는 자.단/ 본적이 타 지역인 자는 5년 이상 거주',
      Col14: '2022-08-19~2022-08-31',
      Col15: '예산범위내 성적순 선발/ 장학이사회 심의후 개별통보예정',
      Col16: '해당없음',
      Col17: '학자금 면제자타장학금 100만원 이상 수혜대상 확정자',
      Col18: '해당없음',
      Col19: '장학생 지원서 (소정양식/ 봉평면사무소 비치)/ (반명함사진)성적증명서(학교장발행)장학금 (미)수혜 확인서 (학교장발행)보호자의 지방세과세증명서 가족관계등록부/ 주민등록 등·초본 각 1부(주소이력 공개) * 자세한 사항은 첨부파일 또는 홈페이지 게시판 참고'
    },
    {
      Col1: '양양군인재육성장학회',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고등학교 3학년 성적이 재적학년 정원의 100분의 10이내 또는 대학수학능력시험 3개영역 언어/ 수리/ 외국어 종합등급 2등급 이내인 자 재학생 : 직전학기 성적이 평균 B학점이상인자',
      Col10: '해당없음',
      Col11: ' * 양양군인재육성장학회에서 지급하는 장학금은 생활비 명목의 장학금으로써 중복지원 범위에서 제외',
      Col12: '서울대/ 연세대/고려대/카이스트대/포스텍대 재학생',
      Col13: '양양군 관내 중/고등학교 졸업후 국내에 소재한 대학교에 진학한 학생 양양군에 주소를 두고 2년 이상 실제 거주하고 있는 주민 또는 그의 자녀 ',
      Col14: '2021-01-18~2021-02-19',
      Col15: '해당없음',
      Col16: '이사회에서 결정',
      Col17: '공무원 자녀(고등학생) 및 공공기관 등 학비전액 지원자 제외원격대학평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원 받는 특수대학',
      Col18: '해당없음',
      Col19: '장학생 신청서 1부.재학증명서(신입생은 합격증명서) 1부.졸업증명서(양양군 관내 중/ 고등학교 졸업증명서) 1부.주민등록등본 (주소변동사항 포함) 1부.성적증명서 (재학생은 직전학년/ 신입생은 고등학교 3학년 성적증명서) 1부.재산세 과세/ 미과세 증명서 1부.전/월세 계약서(해당자만 제출)1부.국민기초수급자 또는 차상위 계층 증명등 기타 심사에 필요한 증빙서류*접수처 : 양양군인재육성장학회 및 읍/면사무소'
    },
    {
      Col1: '양양군인재육성장학회',
      Col2: '우등장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고등학교 3학년 성적이 재적학년 정원의 100분의 20이내 또는 대학수학능력시험 3개영역 언어/ 수리/ 외국어 종합등급 2등급 이내인 자재학생 : 평점 평균이 B학점 이상 (단/ *서울대/연/고대/카이스트대/포스텍대 학생은 C학점 이상인 자',
      Col10: '해당없음',
      Col11: ' * 양양군인재육성장학회에서 지급하는 장학금은 생활비 명목의 장학금으로써 중복지원 범위에서 제외',
      Col12: '해당없음',
      Col13: '관내 중/고등학교 졸업후 국내에 소재한 대학교에 진학한 학생 양양군 관내 고등학교에 재학중인 학생과 양양군에 주소를 두고 2년 이상 실제 거주하고 있는 주민 또는 그 주민의 자녀 ',
      Col14: '2022-01-17~2022-02-18',
      Col15: '해당없음',
      Col16: '이사회에서 결정',
      Col17: '원격대학평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원 받는 특수대학공무원/ 회사원 등 직업소유자 ',
      Col18: '해당없음',
      Col19: '장학생 신청서 1부.재학증명서(신입생은 합격증명서) 1부.졸업증명서(양양군 관내 중/ 고등학교 졸업증명서) 1부.주민등록등본 (주소변동사항 포함) 1부.성적증명서 (재학생은 직전학년/ 신입생은 고등학교 3학년 성적증명서) 1부.세목별 과세 증명서전/월세 계약서(해당자만 제출)1부.국민기초수급자 또는 차상위 계층 증명등 기타 심사에 필요한 증빙서류*접수처 : 양양군인재육성장학회 및 읍/면사무소'
    },
    {
      Col1: '양양군인재육성장학회',
      Col2: '유공및저소득층자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고등학교 3학년 성적이 재적학년 정원의 100분의 30이내 또는 대학수학능력시럼 3개영역 언어/ 수리/ 외국어 종합등급 3등급이내인 자 재학생 : 평점 평균이 B학점 이상',
      Col10: '국가유공자 또는 저소득층(기초생활수급자 및 차상위계층)의 자녀',
      Col11: ' * (재)양양군인재육성장학회에서 지급하는 장학금은 ‘생활비’ 지원명목의 장학금으로써 이중지원 범위에서 제외됨을 알려드립니다.',
      Col12: '국가유공자 또는 저소득층(기초생활수급자 및 차상위계층)의 자녀',
      Col13: '관내 중/고등학교 졸업후 국내에 소재한 대학교에 진학한 학생',
      Col14: '2022-01-17~2022-02-18',
      Col15: '해당없음',
      Col16: '이사회에서 결정',
      Col17: '원격대학평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원 받는 특수대학공무원/ 회사원 등 직업소유자',
      Col18: '해당없음',
      Col19: '장학생 신청서 1부.재학증명서(신입생은 합격증명서) 1부.졸업증명서(양양군 관내 중/ 고등학교 졸업증명서) 1부.주민등록등본 (주소변동사항 포함) 1부.성적증명서 (재학생은 직전학년/ 신입생은 고등학교 3학년 성적증명서) 1부.재산세 과세/ 미과세 증명서 1부.전/월세 계약서(해당자만 제출)1부.국민기초수급자 또는 차상위 계층 증명등 기타 심사에 필요한 증빙서류 * 접수처 : 양양군인재육성장학회 및 읍/면사무소'
    },
    {
      Col1: '양양군인재육성장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 양양군인재육성장학회에서 지급하는 장학금은 생활비 명목의 장학금으로써 중복지원 범위에서 제외',
      Col12: '예능/ 체육/ 기능에 소질과 재능이 뛰어난 학생으로 신청일 기준 2년 이내에 도 주관이상의 대회에서 입상하여 지역의 명예를 드높인 학생',
      Col13: '양양군 관내 중/고등학교 졸업후 국내에 소재한 대학교에 진학한 학생양양군에 주소를 2년 이상 둔 주민/ 똔느 그 주민의 자녀 ',
      Col14: '2022-01-17~2022-02-18',
      Col15: '해당없음',
      Col16: '이사회에서 결정',
      Col17: '원격대학평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원 받는 특수대학공무원/ 회사원 등 직업소유자 ',
      Col18: '해당없음',
      Col19: '장학생 신청서 1부.재학증명서(신입생은 합격증명서) 1부.졸업증명서(양양군 관내 중/ 고등학교 졸업증명서) 1부.주민등록등본 (주소변동사항 포함) 1부.성적증명서 (재학생은 직전학년/ 신입생은 고등학교 3학년 성적증명서) 1부.입상증명서 1부.재산세 과세/ 미과세 증명서 1부.전/월세 계약서(해당자만 제출)1부.국민기초수급자 또는 차상위 계층 증명등 기타 심사에 필요한 증빙서류*접수처 : 양양군인재육성장학회 및 읍/면사무소'
    },
    {
      Col1: '재단법인 부여군굿뜨래장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생은 직전학기(고교)과목별 평균등급이 3등급 이내직전학기 성적이 평균 B학점(3.0)이상인 재학생 * 그 외 첨부파일 참고',
      Col10: '해당없음',
      Col11: '1인당 2000000원',
      Col12: '한국전통문화대학교 : 4명부여고/부여여고 : 각 2명부여정보고/ 한국식품마이스터고/ 부여전자고 : 각1명읍/면 : 부여4/ 규암2/ 기타면 각 1명향우회(재경/재인천/재전) 각1명 부여군중소기업협의회 : 1명  3급이상 장애인 : 3명 다자녀/다문화세대 자녀 : 9명',
      Col13: '공고일 1년 전부터 부여군에 주소를 둔 군민 또는 군민의 자녀재경/ 재인천/ 재전 향우회원 자녀관내 중소기업체 임직원 자녀3급이상 장애인/ 다자녀세대(3인 이상의 자녀를 둔 세대)자녀 등',
      Col14: '2022-01-13~2022-02-11',
      Col15: '해당없음',
      Col16: '대학생 96명(장학금 배정인원에 조건이 있으므로/ 첨부파일 참고)',
      Col17: '해당없음',
      Col18: ' * 첨부파일 참고',
      Col19: '*장학생이 되고자 하는 자는 신청서와 추천서 및 증빙서류를 추천권자에게 제출성적증명서(대학 신입생은 고등학교 3학년2학기/ 재학생은 직전학기 성적증명서)재학증명서(대학 재학생)합격증명서 또는 등록금 납부 영수증 사본(대학 신입생)장애인증명서 또는 장애인등록증 사본(장애인)주민등록등본 또는 가족관계증명서'
    },
    {
      Col1: '백암재단',
      Col2: '주거지원장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '본인의 월 평균 소득 3589957원 이하인 사람본인의 총자산과 자동차 가액 기준을 충족하는 사람',
      Col11: '보증금 및 임대료 없이 무상 지원 (공과금 관리비는 본인 부담)',
      Col12: '자기 성장과 이웃과 더불어 살기위해 구체적 실천력과 봉사정신을 가진 사람주거지원으로 인해 주거 및 통학 부담을 덜고 자기 변화와 성장에 집중하는 사람 책임감과 공동체성이 뛰어나고 타의 모범이 되며 훗날 사회에 기여하고자 하는 사람공고일 현재 무주택자인 미혼의 청년',
      Col13: '해당없음',
      Col14: '2021-12-09~2021-12-26',
      Col15: '해당없음',
      Col16: '41명 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '동해시민장학회',
      Col2: '예/체능특기생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '최근 1년이내 전국단위 이상 대회/ 경연 등 입상자',
      Col10: '해당없음',
      Col11: '1인당 1500000원',
      Col12: '해당없음',
      Col13: '공고일 현재 동해시에 2년이상 주소를 두고 있는 시민의 자녀',
      Col14: '2022-01-26~2022-02-11',
      Col15: ' * 예/체능 특기생은 전체인원의 10%이내 선발(자격미달시 전체대상 선발)',
      Col16: '84명 (기초수급권자 자녀/ 장애인학생 포함)',
      Col17: '대학원생 제외',
      Col18: '해당없음',
      Col19: ' *공통개인정보 수집이용 동의서 * 대학재학생신청서(확인서 포함)최근 두학기(20211/2학기)성적증명서입상서류 또는 총장(학장)의 표창장(해당학생) * 대학 신입생신청서(확인서 생략)2022년도 수능성적 (수능성적이 없을 경우 고등학교 전학년 내신성적)고등학교 전학년 내신성적  * 총장/학장 확인 후 학생 또는 보호자가 개별신청 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '동해시민장학회',
      Col2: '기초수급자 자녀/ 장애인 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생: 대학수학능력시험 4개영역 성적 등급의 합이 15(4~15)이하인 자  * 수능성적이 없을 경우 고등학교 전학년 내신성적 4등급(가중치 포함) 이내인자재학생:  최근 두학기 학업성적이 평균 B0 (3.0/4.5)이상인자  *두학기 평균 최소 12학점이상 취득 4.3만점은 2.87 이상',
      Col10: ' * 국민기초생활보장수급자의 자녀 장애인 대학생',
      Col11: '1인당 1500000원',
      Col12: '해당없음',
      Col13: '공고일 현재 동해시에 2년이상 주소를 두고 있는 시민의 자녀',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '84명',
      Col17: '대학원생',
      Col18: '해당없음',
      Col19: ' *공통개인정보 수집이용동의서 * 대학재학생신청서(확인서 포함)최근 두학기(20211/2학기)성적증명서입상서류 또는 총장(학장)의 표창장(해당학생) * 대학 신입생신청서(확인서 생략)2022년도 수능성적 (수능성적이 없을 경우 고등학교 전학년 내신성적) * 총장/학장 확인 후 학생 또는 보호자가 개별신청 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '함경북도장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '2021년 기준 국내 4년제 대학교 24학년 진학 예정자',
      Col13: '원적이 함경북도인 자의 자녀(손자녀 포함)',
      Col14: '2020-01-11~2021-01-15',
      Col15: '1차 서류2차 면접',
      Col16: '0명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 지급 신청서 (법인소정양식)(최근명함판사진 1매 부착)재학증명서 (당해 월 발행)성적증명서 (전 학년)가족관계증록부 (기본증명서 또는 제적등본 첨부로 원적이 함경북도확인)주민등록등본  * 서류는 직접 또는 우편접수 가능'
    },
    {
      Col1: '진주강씨중앙장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '종사에 기여한 자의 직계 손으로써 성적이 우수한 자',
      Col10: '가정사정이 어려워 학비 조달이 곤란한 자',
      Col11: '연 2000000원',
      Col12: '4년제 대학에 재학하고 있는 자로써 학업성적이 우수하고 품행이 방정한자',
      Col13: '해당없음',
      Col14: '2022-01-12~2022-01-20',
      Col15: '해당없음',
      Col16: '20명',
      Col17: '2022학년도 신입생 제외',
      Col18: '해당없음',
      Col19: '장학생 지원서 (소정양식)재학증명서성적증명서부모님 소재지 확인 할 수 있는 서류부모님 직업 및 재산 현황 확인할 수 있는 서류 * 생계곤란자로 증빙할 수 있는 서류첨부의료보험 납부 증명서)'
    },
    {
      Col1: '(재)한국로타리장학문화재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '관명장학금은 기부금의 120%까지 장학금을 지급하고 이후에는 재단 운용 수익의 50%를 누계 관리하여 인당 장학금 지급액 (200만원)에 도달할 때 추가 장학금을 지급 함. ',
      Col12: ' * 클럽의 활동회원 기부금 기준으로 장학금이 지급되며/ 정규과정의  대학생 및 대학원생 대상국내대학 수학 외국유학생 및 외국 대학 수학중인 내·외국인포함선발분야 : 개인 관명 장학금 / 클럽 장학금 / 외국인 장학금 / 개인장학연구기금 / 글로벌 장학금 ※ 자세한 사항은 기관 홈페이지 공고 참고',
      Col13: '해당없음',
      Col14: '2022-02-03~2022-03-31',
      Col15: '장학관리시스템상의 온라인 신청(이메일/ 우편신청 불가)',
      Col16: 'O명',
      Col17: '타 장학금 수혜자가 아닌 학생 (학업지원비로 신청할 경우 중복지원 가능 즉 생활비)',
      Col18: ' 클럽의 장학위원장(회장) 또는 학생의 지도교수 추천서 관명장학생은 관명인 추천서로 갈음함. ',
      Col19: ' ※ 장학관리 시스템상의 온라인 신청(이메일/ 우편신청 불가) * 신규장학생 성적증명서 재학증명서추천서자기소개서봉사활동 및 동아리 활동서수혜학생 명의의 통장사본개인정보 활용동의서 * 계속장학생성적증명서 재학증명서 수혜학생 명의의 통장사본개인정보 활용 동의서    (기존 제출자는 생략)     '
    },
    {
      Col1: '정읍시민장학재단',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 당해연도 1학기 평점평균이 백분위 환산 90점 이상인 자재학생 : 직전 2학기(전년도 2학기/ 당해연도 1학기) 평점평균이 백분위 환산 90점 이상인 자/ 최소 9학점 이상 이수한 자',
      Col10: '부모의 건강 보험납부확인서 금액으로 평가',
      Col11: '전문대 : 1800000원4년대 : 2200000원사이버대 : 500000원방통대 : 300000원',
      Col12: '공고일 현재 정읍시에 1년이상 주소를 두고 있는 부 또는 모의 자녀로 관내·외 대학교 재학생으로 성적기준 충족자(예·체능 특기자) 지역거주요건을 만족하며 공고일로부터 1년 이내로 전국대회 3위이내/ 도내대회 1위 입상자인 자',
      Col13: '공고일 현재 부 또는 모가 정읍시에 1년 이상 주소를 두고 있는 부 또는 모의 자녀로 관내·외 대학교 재학생',
      Col14: '2022-07-18~2022-07-27',
      Col15: '성적 50%/ 가정형편 50%동점자 발생시 1순위 성적/ 2순위 생활형편',
      Col16: '전문대 : 27명 (도내/ 도외 구분 없이 전국 선발)4년대 : 96명 (도내 29명/ 서울 19명/ 기타 48명)사이버대 : 5명방통대 : 5명',
      Col17: '1세대 1자녀 선발정읍시에서 지급한 타 장학금 수령 학생직업학교/ 방송대학·통신대학/ 방송통신대학 및 사이버대학 재학생',
      Col18: '해당없음',
      Col19: '정읍시민장학재단 장학생지원서성적증명서재학증명서주민등록 등본개인정보제공활용동의서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '서민금융진흥원',
      Col2: '햇살론Youth',
      Col3: '관계부처',
      Col4: '학자금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '연소득 3천 5백만원 이하',
      Col11: '대출한도 : 동일인 1인 최대 1천 2백만원 / 연간 최대 6백만 원대출금리 : 3.6% ~ 4.5% (유형별로 상이) * 특정용도자금의 구분 : 학업·취업준비자금 / 의료비 / 주거비 * 자격조건에 따른 거치기간/상환기간/보증기간등 자세한 사항은 첨부파일 및 기관 홈페이지 참조',
      Col12: '※ 만 19세 이상 ~ 만 34세 이하이면서 연소득 3천 5백만원 이하의 대학생/ 청년 등으로 크게 취업준비생과 사회초년생으로 구분(취업준비생) 대학(원)생/ 학점은행제 수강자/ 미취업청년(사회초년생) 중소기업에 1년 이상 재직 중인 자',
      Col13: '해당없음',
      Col14: '별도 모집',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '만 19세 미만인 자 또는 만 34세 초과인 자본인 소유의 재산이 과다한 경우',
      Col18: '해당없음',
      Col19: '[연령확인] 실명확인증표[재직확인] 건강보험자격득실 확인서[소득확인] 건강보험료 납부확인서유형별 필요한 증빙서류(사업자확인/군입대예정 확인/기간제/단기간 근로여부 확인/고소득 여부 확인 등..)재학증명서/휴학증명서/졸업유예증명서 택1(대학(원)생 해당자)학점은행제 수강확인서 또는 학점인정증명서(학점은행제 학습자 해당자)사회적배려 대상자 증빙서류 택1(해당자) * 자세한 사항은 첨부파일 및 기관 홈페이지 참조'
    },
    {
      Col1: '신용회복위원회',
      Col2: '새희망힐링펀드 장학사업',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: ' * 저소득가정기초생활수급자 차상위계층',
      Col11: '2000000원 * 학업보조비 성격으로 등록금 명목의 장학금 수혜자 중복수혜 가능',
      Col12: '저소득 가정의 대학생으로 신용회복위원회에서 추천을 받은 자만 34세 이하자로 재학중인자',
      Col13: '해당없음',
      Col14: '2022-05-02~2022-07-15',
      Col15: '해당없음',
      Col16: '125명',
      Col17: ' * 해당 기관으로 문의',
      Col18: '서민금융통합지원센터에서 추천을 받은 자',
      Col19: '지원 신청서개인정보 수집이용 동의서기초생활수급자 증명서/ 차상위증명서 중 택1가족관계증명서 또는 주민등록등본재학증명서채무변제계획 이행현황 확인서서 * 자세한 사항은 첨부파일 및 기관 홈페이지 공지사항 참조 '
    },
    {
      Col1: '재단법인 거창군장학회',
      Col2: '대학재학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 성적우수장학생  입학생은 3학년 내신환산등급평균3.0이상/ 또는 평균 80점 이상인 학생재학생은 직전 학년 평균 B학점 이상인 자(학기당 12학점 이상이수) * 면학장려 장학생 : 가정형편이 어려운 학생(저소득층)',
      Col10: '면학장려 장학생 : 가정형편이 어려운 학생(저소득층) * 단 면학장려장학생 접수 미달시에는 성적우수장학생으로 대체 선발한다.',
      Col11: '1인당 2000000원',
      Col12: '공고일 현재/ 관내 고등학교 졸업(예정)하고/ 대학에 입학하였거나 재학 중인 자 ',
      Col13: '공고일 현재/거창군 관내 고등학교 졸업(예정)/ 대학에 입학/재학 중인 자/ 법령에 의한 동등 이상의 학력자 부모의 거주지가 거창군인 자',
      Col14: '2022-01-07~2022-01-28',
      Col15: '서울소재 대학과 지역소재 대학은 구분하여 선발하고 비율은 20%(서울)/ 80%(서울외지역)를 원칙으로 함',
      Col16: '100명 ',
      Col17: '지원제외대학 : 원격대학(방통대/ 사이버대학)/ 기술대학/ 2년 미만의 교육과정의 각종학교(시간제/ 훈련원/ 학점은행제)/ 평생교육법에 의거 설립한 학교(전공대학/ 직업훈련원)',
      Col18: '읍면장 추천 ',
      Col19: '장학생 신청서추천서 (학교장)장학금 지급 신청서서약서주민등록 등본 1부(부모와 주소가 다를 경우 각각 모두 첨부/ 가족관계증명서 제출)대학재학 또는 입학(예정)증명서고등학교 졸업증명서해당학년 성적증명서 1부면학장려의 경우 건강보험 납부확인서 및 건강보험증 사본 저소득층의 경우 국민기초생활수급자 증명서/ 한부모가정 증명서/ 차상위계층 확인서 * 각 읍/면에 접수  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 거창군장학회',
      Col2: '수능성적우수자특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '문과는 국/영/수+탐구 1과목의 백분율 합이 280점 이상/ 영어 2등급 이내이과는 국/영/수+탐구 2과목의 백분율 합이 364점 이상/ 영어 2등급 이내',
      Col10: '해당없음',
      Col11: '1인당 1000000원',
      Col12: '해당없음',
      Col13: '거창군 소재 고등학교 졸업생(졸업예정)/ 추가합격자도 포함부모가 현재 거창에 거주/ 학생이 초/중학교 거창에서 졸업/ 예체능 등 기타 사정에 의해 타지역 고등학교로 진학하여 대학 입학시 신청 가능',
      Col14: '2022-01-07~2022-01-28',
      Col15: '문과/ 이과 구분하여 성적순으로 선발',
      Col16: '18명',
      Col17: '재수입학생 중 기 장학금 수혜자는 제외',
      Col18: '학교장 추천',
      Col19: '장학생 신청서추천서 (학교장)장학금 지급 신청서서약서주민등록 등본 1부(부모와 주소가 다를 경우 각각 모두 첨부/ 가족관계증명서 제출)고등학교 재학(졸업)증명서 및 대학입학(예정)증명서 각 1부수능성적표 사본 1부 * 신청방법 : 재학 또는 졸업 고등학교장 추천에 의하여 신청/접수'
    },
    {
      Col1: '재단법인 거창군장학회',
      Col2: '지역대학육성장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정형편이 어려운자(저소득층) 또는  학업성적이 우수하고 품행이 단정한자',
      Col11: '1500000원',
      Col12: '해당없음',
      Col13: '공고일 현재 거창군 관내 주소를 두고/ 관내 소재 대학교에 재학 중인 학생',
      Col14: '2022-01-07~2022-01-28',
      Col15: '해당없음',
      Col16: '20명 ',
      Col17: '해당없음',
      Col18: '해당대학 총장 추천 (학생본인 신청불가)',
      Col19: '장학생 신청서추천서 (학교장)장학금 지급 신청서서약서주민등록 등본 1부(부모와 주소가 다를 경우 각각 모두 첨부/ 가족관계증명서 제출)재학증명서 및 성적증명서 각 1부*해당대학 총장 추천(학생 본인 신청 불가)'
    },
    {
      Col1: '재단법인 거창군장학회',
      Col2: '출향향우자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정형편이 어려운 자',
      Col11: '1인당 1000000원',
      Col12: '공고일 현재 부모가 거창군 재경 향우회에 가입되어 있고 대학재(입)학생으로 학업성적 우수 또는 가정형편이 곤란한 자',
      Col13: '거창군 재경향우회 가입',
      Col14: '2022-01-07~2022-01-28',
      Col15: '해당없음',
      Col16: '대학생 2명(재경 향우회 대학생 자녀 2명)',
      Col17: '해당없음',
      Col18: '재경향우회장의 추천',
      Col19: '장학생 신청서추천서 (학교장)장학금 지급 신청서서약서주민등록 등본 1부(부모와 주소가 다를 경우 각각 모두 첨부/ 가족관계증명서 제출) * 재경향우회장의 추천에 의하여 신청/접수'
    },
    {
      Col1: '재단법인 거창군장학회',
      Col2: '예/체능및과학특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 1000000원',
      Col12: '2021년 예/체능 등 전국대회 3위 이내 또는 도단위 대회 1위 수상자 및 단체국가대표 및 이에 상응하는 대표로 선발된자 및 단체 ',
      Col13: '공고일 현재 거창군 소재  대학에 재학중인 학생단/ 부모가 거창에 거주하면서 예체능 등 특별한 사정에 의해 타 지역으로 진학한 학생 신청 가능',
      Col14: '2022-01-07~2022-01-28',
      Col15: '예/체능 특기장학생 심사위원회를 별도 구성하여 선발심사규정에 따라 심사',
      Col16: '24명 ',
      Col17: '2021년 거창군 청소년 유망체육선수 장려금을 받은 자는 신청 및 선발에서 제외',
      Col18: '해당없음',
      Col19: '장학생 신청서추천서 (학교장)장학금 지급 신청서서약서주민등록 등본 1부(부모와 주소가 다를 경우 각각 모두 첨부/ 가족관계증명서 제출)재학증명서2021년도 수상을 증명할수 있는 증빙서류경기실적증명서(체육분야에 한함)* 대학생 및 국가대표는 장학회에 직접 신청 접수'
    },
    {
      Col1: '재단법인 거창군장학회',
      Col2: '낙동강수계지역특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '입학생 : 내신환산등급 평균3.0이상/ 또는 고교성적 평균 80점 이상인 학생과  저소득층 자녀재학생 : 직전학년 1년간 평균 B학점 이상인 자 또는 저소득층 자녀',
      Col10: '저소득층 자녀 ',
      Col11: '1인당 2000000원',
      Col12: '단/ 학생이 관내 고등학교를 졸업해야하나 예체능 등 기타 특별한 사정(동일계진학 등)에 의해 타지역 고등학교를 졸업한 학생은 신청 가능하다',
      Col13: '공고일 현재 부모 또는 본인이 수계지역 내(거창읍/남상면/남하면/신원면/가조면) 주민등록자로/ 관내 고교 졸업(재학)자로 대학 입학/재학생. 단/ 예체능 등 기타 사정에 의해 타지역 고등학교졸업시 신청 가능',
      Col14: '2022-01-07~2022-01-28',
      Col15: '서울소재대학과 지역소재대학을 구분하여 선발하며/ 그 비율은 서울(20%)/ 서울외지역(80%)을 원칙으로 한다',
      Col16: '8명(해당 읍면별 인원배정)',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 신청서추천서 장학금 지급 신청서서약서주민등록 등본 1부(부모와 주소가 다를 경우 각각 모두 첨부/ 가족관계증명서 제출)대학재학 또는 입학(예정)증명서고등학교 졸업증명서해당학년 성적증명서면학장려의 경우 건강보험 납부확인서 및 건강보험증 사본저소득층 경우 국민기초생활수급자 증명서/ 한부모가정 증명서/ 차상위계층 확인서 * 해당 학생은 부모 또는 본인 거주 주소지의 읍/면사무소에 신청 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '횡성인재육성장학회',
      Col2: '일반주민자녀(성적우수)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(학점기준은 4.5점 만점기준)신입생 : 당해 연도 수능 응시영역별 1등급이 1개/ 2등급이 2개 이상인 자 또는 고1~3학년 1학기까지 내신평균 등급이 2등급 미만인 자 (수능 미응시자는 내신평균 2등급 미만인자 중에서 선발) 단/ 예·체능 부문의 경우 별도 성적심의를 할 수 있음재학생 : 학기별 15학점 이상 취득자로써 직전 두 학기 평균평점이 3.5 이상인 자',
      Col10: '해당없음',
      Col11: '1000000원 * 장학금 이중수혜 지원시 제한 될 수 있음',
      Col12: '대학 재학생의 경우 직전 두 학기 취득학점이 24학점 이상인 자',
      Col13: '신청일 현재 본인 또는 보호자(부모)의 주민등록 주소지가 1년 이상 계속하여 횡성군에 등록되어 있는 자',
      Col14: '2022-02-14~2022-02-28',
      Col15: '해당없음',
      Col16: '100명',
      Col17: '새마을지도자/ 의용소방대 장학금 대상자는 중복신청 불가',
      Col18: '해당없음',
      Col19: ' [공통]지원신청서 + 개인정보동의서 자기소개서주민등록등본 또는 초본  [신입생]해당년도 수능성적표 또는 고교 생활기록부합격증명서류(입학허가서 등)등록금 납부 증명서 사본  [재학생]성적증명서(재학기준 직전 2학기)재학증명서관내 초중고 졸업증명서(해당자)공인어학성적표(해당자)공인 봉사활동 증명서(해당자)한국장학재단 학자금지원구간통지서(해당자) * 자세한 사항은 첨부파일 또는 홈페이지 공고 참고'
    },
    {
      Col1: '횡성인재육성장학회',
      Col2: '일반주민자녀(예능특기)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원 * 장학금 이중수혜 지원시 제한될 수 있음',
      Col12: '최근 1년 이내 도교육감 주최 및 중앙단위(전국) 3위 이내 또는 도 단위의 1위의 입상 경력이 있는 자',
      Col13: '신청일 현재 본인 또는 보호자(부모)의 주민등록 주소지가 1년 이상 계속하여 횡성군에 등록되어 있는 자',
      Col14: '2022-02-14~2022-02-28',
      Col15: '해당없음',
      Col16: '4명',
      Col17: '새마을지도자/ 의용소방대 장학금 대상자는 중복신청 불가',
      Col18: '해당없음',
      Col19: ' [공통]지원신청서 + 개인정보동의서 자기소개서주민등록등본 또는 초본상장사본 또는 관련 증명서  [신입생]합격증명서류(입학허가서 등)등록금 납부 증명서 사본  [재학생]재학증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공고 참고'
    },
    {
      Col1: '횡성인재육성장학회',
      Col2: '희망장학부문',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '1. 저소득주민자녀신입생 : 수능성적 4등급 이내가 2개영역 이상인자 또는 고등학교 내신등급이 평균 5등급이내인 자재학생 : 직전2학기 평점이 3.0 이상인 자2. 취약계층주민자녀신입생 : 수능성적 4등급 이내가 2개영역 이상인자 또는 고등학교 내신등급이 평균 5.0 등급 미만인 자재학생 : 직전 두학기 평균평점이 3.0(4.5만점기준)이상자',
      Col10: ' * 저소득주민자녀 :기초생활수급권자 또는 차상위계층의 대학생 자녀 * 취약계층주민자녀 : 부양의무자의 합산 월 소득이 기준중위소득 52% 이하의 한부모/조부모/다문화 가정',
      Col11: '1000000원 * 장학금 이중수혜 지원시 제한될 수 있음',
      Col12: '대학 재학생의 경우 직전 두학기 취득학점이 24학점 이상인 자 * 저소득주민자녀 :기초생활수급권자 또는 차상위계층의 대학생 자녀 * 취약계층주민자녀 : 부양의무자의 합산 월 소득이 기준중위소득 52% 이하의 한부모/조부모/다문화 가정',
      Col13: '신청일 현재 본인 또는 보호자(부모)의 주민등록 주소지가 1년 이상 계속하여 횡성군에 등록되어 있는 자',
      Col14: '2022-02-07~2022-02-09',
      Col15: '해당없음',
      Col16: '저소득주민자녀 : 16명취약계층주민자녀 : 2명',
      Col17: '국민기초생활보장법등 타법에 의한 수업료 지원 대상자중 수업료 이상 초과분은 환수 조치새마을지도자/ 의용소방대 장학금 대상자는 중복신청 불가',
      Col18: '취약계층주민자녀 : 해당학교장 또는 읍/면장 추천',
      Col19: '1. 저소득주민자녀 제출서류 (공통)장학금 지원신청서자기 소개서수급자 증명서(기초수급/ 차상위 계층) *신입생 추가 제출서류주민등록표(등본 1통)수능성적표 또는 고교전학년 성적증명서합격증명서류(입학허가서등) *재학생 추가 제출서류주민등록표(등본 각 1통)재학 직전 2학기 성적증명서재학증명서2. 취약계층주민자녀 제출서류 (공통)장학금 지원신청서자기 소개서해당 읍·면장 추천서개인정보 활용 동의서 *신입생 추가 제출서류주민등록표(등본 1통)수능성적표 또는 고교전학년 성적증명서합격증명서류(입학허가서등) *재학생 추가 제출서류주민등록표(등본 각 1통)재학 직전 2학기 성적증명서재학증명서'
    },
    {
      Col1: '횡성인재육성장학회',
      Col2: '글로벌인재육성(성적우수)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '수능영어과목은 1등급 또는 2등급이며/ 국어/수학 및 탐구 2과목 표준점수 합계가 370점 이상인 자',
      Col10: '해당없음',
      Col11: '1인당 1000000원 * 4년간 균등분할 지급',
      Col12: '횡성관내고등학교 졸업예정생대학수학능력시험 성적우수자',
      Col13: '신청일 현재 신청자 본인 또는 부모가 1년 이상 계속하여 횡성에 주소를 두고 있는 자',
      Col14: '2022-02-07~2022-02-09',
      Col15: '서류심사응모자 발표 (10분이내 PPT)심층면접(질의/답변)',
      Col16: '해당없음',
      Col17: '국민기초생활보장법등 타법에 의한 수업료 지원 대상자중 수업료 이상 초과분은 환수 조치새마을지도자/ 의용소방대 장학금 대상자는 중복신청 불가',
      Col18: '해당없음',
      Col19: '(재)횡성인재육성장학회 신청서개인(가족)정보 수집/이용/제공 및 조회 동의서주민등록등본가족관계증명서대학수학능력시험 성적표고등학교 생활기록부대학교 합격증명서 (입학허가서 등)대학등록금 영수증자기소개서(PPT발표 자료 및 요약서) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '횡성인재육성장학회',
      Col2: '글로벌인재육성(예체능)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '영어 3등급 이내이며/ 국어/수학 및 탐구 2과목 표준점 합계가 360점 이상인 자 또는 예체능(술)적 재능이 뛰어나 우수대 입학하여 학교장 추천을 받은 자',
      Col10: '해당없음',
      Col11: '1인당 5000000원 * 2년간 균등분할 지급',
      Col12: '예체능(술)적 재능이 뛰어나 우수대 입학한 자성적이 우수한 자횡성관내고등학교 졸업 예정생',
      Col13: '횡성관내고등학교 졸업 예정생',
      Col14: '2022-02-07~2022-02-09',
      Col15: '서류심사심층면접',
      Col16: '해당없음',
      Col17: '국민기초생활보장법등 타법에 의한 수업료 지원 대상자중 수업료 이상 초과분은 환수 조치새마을지도자/ 의용소방대 장학금 대상자는 중복신청 불가',
      Col18: '학교장 추천',
      Col19: '(재)횡성인재육성장학회 장학금 신청서개인(가족)정보 수집/이용/제공 및 조회 동의서주민등록등본가족관계증명서대학수학능력시험 성적표고등학교 생활기록부대학교 합격증명서(입학허가서)대학등록금 영수증자기소개서(PPT발표 자료 및 요약서) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '횡성인재육성장학회',
      Col2: '일반주민자녀(체육특기)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '아래 해당하는 입상경력이 있는자 1. 전국(소년)체육대회 3위 이내 입상자 2. 종목별 전국단위 1위 이내 입상자 3. 종목별 전국동게대회 1위 이내 입상자 * 단/ 단체로 입상한 경우 장학금은 예산의 범위내에서 이사회에서 결정함',
      Col13: '신청일 현재 본인 또는 보호자(부모)의 주민등록 주소지가 1년 이상 계속하여 횡성군에 등록되어 있는 자',
      Col14: '2022-02-14~2022-02-28',
      Col15: '해당없음',
      Col16: '5명',
      Col17: '새마을지도자/ 의용소방대 장학금 대상자는 중복신청 불가',
      Col18: '해당없음',
      Col19: ' [공통]지원신청서 + 개인정보동의서 자기소개서주민등록등본 또는 초본상장사본 또는 경기실적증명서 [신입생]합격증명서류(입학허가서 등)등록금 납부 증명서 사본  [재학생]재학증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공고 참고'
    },
    {
      Col1: '횡성인재육성장학회',
      Col2: '이장자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학 재학생의 경우 직전 두학기 취득학점이 24점 이상인 자 * 성적우수 : 신청 시 성적 제한 없음 * 예체능 : 최근 1년 이내에 기능·예능·체육 분야의 도단위 이상 경연대회에서 입상한 자 ',
      Col10: '해당없음',
      Col11: '1인당 1000000원 * 지급인원과 금액은 장학생 선발 심의회 결정에 의거 변동될 수 있음',
      Col12: '신청일 현재 이장으로 재직하고 있는 자의 대학생 자녀 중 1인',
      Col13: '신청일 현재 신청자 본인 또는 부모가 1년 이상 계속하여 횡성에 주소를 두고 있는 자',
      Col14: '2022-04-25~2022-05-04',
      Col15: '장학생 선발심의위원회 심의·의결',
      Col16: '40명(고등학생 및 대학생 선발인원)',
      Col17: ' * 아래의 장학금 수혜자는 중복신청 불가2022년도 (재)횡성인재 육성장학회 장학금/ 농업인자녀장학금/ 다자녀학자금/ 새마을지도자 장학금/ 의용소방대 장학금',
      Col18: '해당 읍/ 면장이 추천',
      Col19: '지원신청서자기소개서개인정보동의서 및 장학금(생활비지원)지출계획서 1부통장사본본읍·면장 추천서주민등록초본 또는 등본(최근5년 주소변동포함)기초생활수급자(차상위)증명서 (해당자만)신입생 : 수능성적표 또는 내신성적표/ 대학합격증명서재학생 : 전체학년 성적증명서(백분위 표기) * 해당 읍·면행정복지센터 총무담당 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '횡성인재육성장학회',
      Col2: '관내대학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' [ 성적우수 ] (대학재학생)직전 두 학기 평점평균 3.0 이상인 자 (신입생)내신 : 고등학교 3학년 1학기까지 이수한 과목 중 1/2 이상이 내신 6등급이내인 자수능 : 수능 영역(언어/수리/외국어(영어)/ 기타(탐구 및 제 2외국어)중 2개 영역이상 6등급 이내인 자기타 : 내신 또는 수학능력시험 성적이 없는 경우 검정고시 합격증 제출 또는 전적대학 총 평점평균 3.0 이상인 자 [예체능]최근 1년 이내에 기능·예술·체육 분야의 중앙(전국)단위 3위이내 입상 또는 도단위 이상 경연대회에서 1위 입상 자 [만학도]연령이 만 30세 이상인 2학년 이상 재학생 중 직전 두학기 24학점 이상 취득자이며 미취득 학점이 없는 자 중 성적이 우수한 자 ※ 자세한 사항은 첨부파일 참고 필수',
      Col10: '해당없음',
      Col11: '1인당 1000000원 * 지급인원과 금액은 장학생 선발심의회 결정에 의거변동될 수 있음',
      Col12: '신청일 현재 관내대학(송호대·한국골프대)에 재학중인 자',
      Col13: '신청일 현재 신청자 본인 또는 부모가 1년 이상 계속하여 횡성에 주소를 두고 있는 자',
      Col14: '2022-04-25~2022-05-04',
      Col15: '장학생 선발심의위원회 심의·의결',
      Col16: ' * 160명 (신입생 및 재학생)112명 송호대학교48명 한국골프대',
      Col17: ' * 아래의 장학금 수혜자는 중복신청 불가2022년도 (재)횡성인재육성장학회 장학금/ 농업인자녀학자금/ 다자녀학자금/ 새마을지도자 장학금/ 의용소방대 장학금',
      Col18: '해당없음',
      Col19: '지원신청서자기소개서개인정보동의서장학금 지출계획서통장사본주민등록초본 또는 등본(최근5년 주소변동포함)기초생활수급자(차상위)증명서 (해당자만)신입생 : 수능성적표 또는 내신성적표/ 대학합격증명서재학생 : 전체학년 성적증명서 (백분위 표기) * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '횡성인재육성장학회',
      Col2: '열정키움장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '신청일 현재 본인 또는 친권자가 1년 이상 횡성군에 주소를 둔 대학재학생으로 본인의 열정과 재능을 계획서 제출 및 프레젠테이션 면접을 통해 증명할 수 있는 자',
      Col13: '신청일 현재 본인 또는 친권자가 1년 이상 횡성군에 주소를 둔 자',
      Col14: '2022-07-25~2022-08-03',
      Col15: '서류심사2차 PPT발표심층면접장학생 선발 심사위원회 선발',
      Col16: '10명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서개인(가족) 정보 수집·이용·제공 및 조회 동의서자기소개서주민등록초본재학증명서입상기록 및 열정(재능)을 증빙할 서류 혹은 동영상'
    },
    {
      Col1: '전주인재육성재단',
      Col2: '지역우수인재장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평균성적이 B+ 이상인 자 * 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: ' * 공고일 현재 전주시에 1년 이상 거주하고 있는 전주 시민의 자녀로서/ 아래 해당자성적우수자특수계층자녀(다자녀/ 다문화/ 장애인 가족)대학교 재학생',
      Col13: '공고일 현재 전주시에 1년 이상 계속 거주하고 있는 전주 시민의 자녀로서 전라북도 관내 고등학교를 졸업한 대학생 또는 고등학교 검정고시 졸업자격을 취득한 대학생',
      Col14: '2022-09-05~2022-09-16',
      Col15: '학업성적 50 + 생활정도 50 + 자원봉사실적 최대 1.5점 가점 * 자세한 사항은 첨부파일 확인 바랍니다.',
      Col16: '성적우수 5명특수계층자녀 2명일반 48명 * 자세한 사항은 첨부파일 참고',
      Col17: '전주시 풍남학사 입사생 제외 방송통신대학/ 사이버대학 재학생 제외1세대 1명 신청원칙으로 지원제한(타 사업 중복지원 불가)직전학기 기선발 대학생 * 자세한 사항은 첨부파일 참고 바랍니다.',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보제공동의 및 활용승낙서 주민등록등본건강보험납부확인서 또는 건강보험 자격득실확인서성적증명서재학증명서고등학교 졸업증명서등록금(수업료) 고지서자원봉사 활동 확인서기타서류 : 특수계층자녀의 경우 증명서류 * 자세한 사항은 첨부파일 확인 바랍니다.'
    },
    {
      Col1: '한국노총장학문화재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '해당없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '전문대생 2000000원대 학 생 3000000원',
      Col12: '직업병으로 인하여 재활교육을 받는학생근로청소년으로서 야간 정규학교에 재학중인자와 순직조합원 및 근로자의 유자녀조합원 및 일반 근로자와 그 자녀/ 형제/ 자매(조합원 및 그 형제/ 자매중 체육특기자로서 시/도 단위이상의 체육대회에서 입상한 학생)저소득 비정규직 근로자 자녀',
      Col13: '해당없음',
      Col14: '2022-04-01~2022-04-28',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '타장학금 및 학자금을 지원받고 있음이 판명될 경우 선발심사에서 제외되며 지급된 장학금은 환수조치 됨.학교장/ 회원조합위원장의 추천 직인이 없는 경우',
      Col18: '소속학교장과 회원조합 위원장이 추천저소득 비정규직 근로자 자녀로서 관련 단체 대표자가 추천',
      Col19: '1. 정규직 제출서류성적증명서 1부. (신입생은 직전학년 성적증명서)재학증명서 1부.  학생통장 사본 1부.추천서2. 비정규직 제출서류성적증명서 1부. (신입생은 직전학년 성적증명서)재학증명서 및 학생통장 사본 각1부. 추천서근로자 전년도 원천징수영수증 또는 입증 관련자료(월평균 급여 250만원 이하) 1부.'
    },
    {
      Col1: '홍산장학재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열',
      Col9: '직전학기 성적이 3.0이상(4.5만점) * 각 학교에서 학생을 추천하는 방식이므로/ 성적기준이 학교별로 상이할 수 있음',
      Col10: '경제적 사정으로 학업이 어려운 학생\'222학기 또는 직전학기 소득분위 기초/차상위 소득분위 1구간 이내인 학생 * 각 학교에서 학생을 추천하는 방식이므로 소득기준이 학교별로 상이할 수 있음',
      Col11: '2000000원(생활비) * 등록금지원 장학금과 중복수혜 가능',
      Col12: '대한민국 국적의 이공계열 및 의학 약학계열 정규학기 재학생',
      Col13: '해당없음',
      Col14: '2022-08-16~2022-08-19',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '휴학예정자/ 휴학생/ 초과학기자/ 학적유지자타 교외 장학금 수혜(예정)자',
      Col18: '지도교수의 추천서 제출',
      Col19: '* 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.본인소개서(재단양식)성적증명서가족관계증명서개인정보이용제공동의서소득분위확인서 * 자세한 사항은 각 학교 장학부서 문의'
    },
    {
      Col1: '하림장학재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '해당없음',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체평점평균이 3.5이상이고/ 직전학기 평점평균이 3.5 이상인 자자',
      Col10: '가정형편이 어려우나 사상이 건전하고 품행이 단정하며 학업성적이 우수한 학생한국장학재단 소득구간이 0~4구간인 학생(20221학기 기준)',
      Col11: '1년 2000000원 (학기당)  총 2개학기기',
      Col12: '20221학기 현재 재학생으로서/ 20222학기까지 연속으로 재학예정인 학부생 ',
      Col13: '해당없음',
      Col14: '2022-03-14~2022-03-16',
      Col15: '신청자 중 우선선발기준에 의하여 선정된 1순위',
      Col16: '1명',
      Col17: '장학수혜기간 중 학적변동(휴학/자퇴/제적)시 장학금은 환수조치됨전과 또는 타학교 편입시 장학금 환수국가장학금/ 교내장학금 외 타기관 장학금을 수혜받지 않은 자자',
      Col18: '해당없음',
      Col19: '장학금 신청서 1부추천서 1부전체 성적증명서 1부주민등록 등본 1부한국장학재단 소득구간증명서 1부개인 정보 수집.이용.제공 및 조회 동의서 1부교외장학생 서약서 1부 '
    },
    {
      Col1: '신한은행충북장학회',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적상위 학생',
      Col10: '해당없음',
      Col11: '1000000원(매학기 500000원) * 생활비성 장학금',
      Col12: '해당없음',
      Col13: '주소지가 충청북도인 자',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '각 학교마다 선발 인원이 다름. * 각 학교 장학부서 및 홈페이지 참고 바람',
      Col17: '해당없음',
      Col18: '교수 추천',
      Col19: '추천서 및 자기소개서주민등록등본(주소변동이력 포함)증빙서류(해당자)'
    },
    {
      Col1: '해석정해영선생장학문화재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원/특정대학',
      Col7: '해당없음',
      Col8: '공학계열/사회계열/인문계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '8000000원(2년 분할지급)',
      Col12: '교육부에서 인정한 현재 재학 중인 대학생 대학교 학과장의 추천서 발급대상자타 기관 장학금 수령대상자도 지원가능',
      Col13: '부산·울산·경남지역의 연고지를 둔 전국의 대학교에 재학 중인 대학생',
      Col14: '2022-07-04~2022-07-30',
      Col15: '해당없음',
      Col16: '12명',
      Col17: '4회 분할 지급으로/ 2~4회차 장학금은 재학증명서를 제출하지 못할 시 지급제외',
      Col18: '학과장 추천서 발급대상자',
      Col19: '장학금 신청서자기소개서주민등록등본 소득관련증빙서류증명사진통장사본성적증명서지도교수 또는 학과장 추천서 * 양식은 기관 홈페이지 참조'
    },
    {
      Col1: '해전장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '학기당 2000000원 내외 * 상위권 성적을 유지하는 경우 졸업할 때까지 계속하여 장학금을 지급',
      Col12: '대학교 신입생 또는 1/ 2학년 재학생 우선선발교대/ 사범대/ 의대/ 치의대/ 약대생 우대',
      Col13: '해당없음',
      Col14: '2022-02-03~2022-02-10',
      Col15: ' * 가정형편을 최우선적으로 평가하고/ 자기소개서/ 추천서/ 성적 등 참작',
      Col16: '2명 내외',
      Col17: '다른 장학금과 중복지원 불가능',
      Col18: '고등학교 담임교사(신입생)/ 지도교수(재학생)의 추천받는 경우 우대',
      Col19: '장학생선발신청서 1부 지도교수(담임교사) 추천서 1부자기소개서서약서 1부재학증명서(신입생의 경우 대학교 합격증 등 입학예정 사실을 증명할 수 있는 서류. 단/ 장학생 신청서 접수기간까지 합격자발표가 이루어지지 않은 경우 추후제출 가능)재학중인 학교의 전학년 성적증명서(대학교 신입생인 경우 고등학교 전학년 생활기록부 1부)부모님의 직전년도 건강보험료 납부확인서 1부장학생선정을 신청하는 학생의 가족관계등록부 등본 1부  * 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '문경시장학회',
      Col2: '국군체육부대자녀대학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 직전 두 개 학기 평균학점이 B학점 이상 (만점이 4.5인 경우3.0. 단/ 신입생은 수능점수 백분위 평균 80점 이상)',
      Col10: '해당없음',
      Col11: '4년제 : 1인당 3000000원2년제 : 1인당 2000000원',
      Col12: '국군체육부대원의 자녀장학금 지급일까지 대학(2년제 이상)에 재학중인 자',
      Col13: '공고일 현재 본인 또는 보호자의 주소가 문경시에 1년이상 되어있는 학생 (인사이동에 따른 근무자의 주소이력은 공고일 현재 문경시로 주소를 두어야 함)',
      Col14: '2022-03-28~2022-04-15',
      Col15: '해당없음',
      Col16: '4년제 : 3명2년제 : 2명',
      Col17: '공고일 현재 휴학 중이거나 정학/ 퇴학 등 징계 처분을 받은 자직전년도 문경시장학회 성적우수 장학금 수혜자한국장학재단 및 타기관에서 지급되는 학자금의 총액이 등록금을 초과 또는 본 장학금의 50%를 초과하는 대학생등록금 전액 면제 대학생1인당 1종류의 장학금 신청만 가능능 * 자세한 사항은 첨부자료 참고',
      Col18: '대학교장 ( 총장 또는 학장 )',
      Col19: '장학금 지원신청서 및 추천서개인정보 제공 및 수집 동의서재학증명서주민등록등본(보호자의 문경 거주이력 필요)성적증명서 (직전 2개학기)신입생 : 수능시험성적통지표재학생 : 성적증명서(직전 2개 학기)국군체육부대 재직증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '문경시장학회',
      Col2: '성적우수',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 두 개 학기 평균학점이 A학점 이상 (만점이 4.5인 경우 평점 4.0)',
      Col10: '해당없음',
      Col11: '대학생(4년제)  : 1인당 3000000원대학생(2년제)  : 1인당 2000000원',
      Col12: '대학(2년제 이상)에 재학중인 자',
      Col13: '공고일 현재 본인 또는 보호자의 주소가 문경시에 1년이상 되어있는 학생',
      Col14: '2022-03-28~2022-04-15',
      Col15: '해당없음',
      Col16: '대학생(4년제) : 30명대학생(2년제) :  2명  ',
      Col17: '공고일 현재 휴학 중이거나 정학/ 퇴학 등 징계 처분을 받은 자직전년도 문경시장학회 성적우수 장학금 수혜자한국장학재단 및 타기관에서 지급되는 학자금의 총액이 등록금을 초과 또는 본 장학금의 50%를 초과하는 대학생등록금 전액 면제 대학생1인당 1종류의 장학금 신청만 가능',
      Col18: '해당 대학교장 (총장 또는 학장)',
      Col19: '장학금 지원신청서 및 추천서개인정보 제공 및 수집 동의서재학증명서주민등록등본(보호자의 문경 거주이력 필요)신입생 : 수능시험성적통지표재학생 : 성적증명서(직전 2개 학기) * 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '문경시장학회',
      Col2: '진학우수',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '명문대학 입학생 중 수능 4개 영역 중 2개 영역에서 2등급 이상인 학생(탐구영역은 2개 과목 평균점수 반영/ 제2외국어는 제외/탐구영역 평균산출시 소수점 이하는 절사)수능 미응시 수시합격생 : 고등학교 재학중 교과 내신 평균 2등급 이상',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '명문대학 또는 우수학과 입학생장학금 지급일까지 대학(2년제 이상)에 재학중인 자',
      Col13: '장학금 지급일까지 부 또는 모(또는 보호자)가 문경시에 1년 이상 주소를 두고있으며/ 국내 소재 대학교 신입생에 한함* 자세한 내용은 첨부파일 참고',
      Col14: '2022-03-28~2022-04-15',
      Col15: '해당없음',
      Col16: '15명',
      Col17: '공고일 현재 휴학 중이거나 정학/ 퇴학 등 징계 처분을 받은 자직전년도 문경시장학회 성적우수 장학금 수혜자한국장학재단 및 타기관에서 지급되는 학자금의 총액이 등록금을 초과 또는 본 장학금의 50%를 초과하는 대학생등록금 전액 면제 대학생1인당 1종류의 장학금 신청만 가능 * 자세한 사항은 첨부자료 참고',
      Col18: '해당 대학교장 (총장 또는 학장)',
      Col19: '장학금 지원신청서 및 추천서개인정보 제공 및 수집 동의서재학증명서주민등록등본(보호자의 문경 거주이력 필요)신입생 : 수능시험성적통지표재학생 : 성적증명서(직전 2개 학기) * 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '문경시장학회',
      Col2: '다자녀생활장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 2~3년제: 2000000원대학생 4년제: 3000000원',
      Col12: '다자녀(3명이상)가족2002년 1월 1일 이후 출생자가 1명 이상 있어야함다자녀가정의 모든 자녀 지원 가능 ',
      Col13: '선발 공고일 현재 부 또는 모와 본인 포함 다자녀(3명이상)가 1년 이상 주민등록상 주소지가 문경인 자',
      Col14: '2020-10-05~2020-10-16',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '문경시장학회 기타 장학금과 중복지원 불가공고일 현재 휴학중이거나 정학/ 퇴학 등 징계처분을 받은 자사이버대학교/ 국가평생교육진흥원 등 문경시장학회에서 장학금 대상 대학교로 인정하지 않은 학교의 재학생 ',
      Col18: '해당없음',
      Col19: '장학금 지원신청서개인정보 제공 및 수집 동의서주민등록등본)재학증명서(관회학교 재학생 및 대학생)통장사본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '이동우축산장학회',
      Col2: '이동우축산장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '입학생 : 고등학교 성적이 우수한 자 재학생 : 성적이 우수한 자 ',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '관내 축산농가의 자녀로/ 장학회 총회에서 선발된 자기타 축산 발전을 위하여 인재로 육성할 필요가 있는 자',
      Col13: '관내 중학교 또는 고등학교를 졸업한 자와 장학생 선발 공고일 현재 양구군에 주소를 두고 2년 이상 계속하여 거주하고 있는 자',
      Col14: '2022-02-07~2022-02-25',
      Col15: '축산발전을 위하여 인재로 육성할 필요가 있고 총회에서 심의 선발된 자 ',
      Col16: '해당없음',
      Col17: '양록장학금/ 농어민자녀장학금/ 리장자녀장학금/ 축협황소장학금 등 타 장학금수혜자는 이동우 축산장학금 대상자에서 제외관내 타 장학금 수혜자 지급대상 제외',
      Col18: '해당없음',
      Col19: '합격통지서(입학생) 및 재학증명서(재학생)학업성적을 증명하는 서류교육비납입증명서관내 중학교 또는 고등학교 졸업증명서기타 위원회에서 요구하는 서류이동우축산장학생 지원서 및 서약서개인(신용)정보 수집/이용/제공 및 조회 동의서 * 접수처 : 양구군청(농업기술센터) 농업정책과 축산팀'
    },
    {
      Col1: '삼화지봉장학재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열',
      Col9: '직전학기 성적이 3.0(B) 이상인자',
      Col10: '학업성적은 양호하나 가정생계가 곤란한 자 (특히 가장역할을 겸하여 면학하는 자)',
      Col11: '2000000원 (등록금성 장학금)',
      Col12: '2022학년도 기준 2학년 이상 재학 중인 자* 재단에서 선정한 대학에서 학생을 추천하는 방식으로/ 추천가능여부를 각 학교 장학부서나 학과사무실에 문의해볼 것',
      Col13: '해당없음',
      Col14: '2021-12-15~2022-01-06',
      Col15: '해당없음',
      Col16: '3명 ',
      Col17: '* 타 장학금 수혜자/ 규정학기 초과자 ',
      Col18: '학과에서 추천된 자 ',
      Col19: '* 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.장학금 신청서 (본인 자필 작성 필수)성적증명서사진(반명함판)신청자 명의로된 은행통장 사본'
    },
    {
      Col1: '실로암시각장애인복지관',
      Col2: '효명장학사업',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)/전문대학원/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 4년제 정규대학15학점 이상 이수자 (단/ 졸업학기 신청자일경우 12학점 이수자도 신청 가능) * 로스쿨9학점 이상 이수자 * 석·박사 과정의 해외유학생해당 대학원 풀타임 등록 기준 학점',
      Col10: '해당없음',
      Col11: ' * 본 효명장학금은 시각장애 대학생들이 학업에 필요한 추가비용을 지원하는 것임으로 대학교에서 장학금을 지원받았더라도 중복수령이 가능함. ',
      Col12: '222학기 등록 예정자 (국내 학사 8학기/ 해외 석사 4학기/ 해외 박사 6학기까지 지원 가능)성적이 우수하고 인성과 품행이 반듯한 시각장애대학생직전학기 성적 증빙이 가능한 시각장애대학생',
      Col13: '주민등록상 서울시 거주자 또는 서울시 소재 4년제 대학 재학중인 중증시각장애인예체능/ 이공계 전공자로서 전국 소재 4년제 정규대학에 재학중인 자',
      Col14: '2022-07-11~2022-07-22',
      Col15: '(1차) 서류심사(2차) 논술심사(신규지원자 직업능력평가 실시)(3차) 면접심사',
      Col16: '해외 대학원 석·박사 및 국내 로스쿨 분야 3명 이내국내대학교 이공계 분야 3명이내국내대학교 경상계열 2명 이내국내대학교 예체능 2명 이내국내대학교 사회복지 및 인문사회분야 3명 이내국내대학교 교육분야 3명 이내국내대학교 기타분야 ○명 이내',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 1차 서류2022년 하반기 효명장학금 신청서자기소개서개인정보 수집·활용 동의서2022학년도 1학기 성적증명서주민등록등본장애인복지카드사회봉사활동/ 외국어성적/ 자격증 사본 등 증빙서류 (해당자) * 2차 서류2022년 2학기 등록금납입 영수증개인 통장 사본 ※ 자세한 사항 홈페이지 공고 참조'
    },
    {
      Col1: '홍천군무궁화장학회',
      Col2: '우수학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '해당없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 : 국어/ 영어/ 수학 영역 중 2개 과목 등급의 합이 4이내이고/ 탐구영역(한국사 포함) 중 2개 과목 등급의 합이 4이내인 사람 * 재학생(1/2학기 총25학점이상 이수/ 정규학기 이내에 한함)  2~3년제 대학생 : 직전 학년 성적 평점평균  A°(4.0/4.5) 또는 A(3.7/4.3) 학점 이상4년제 대학 재학생 :  직전 학년 성적 평점평균 B+(3.5/4.5)학점 이상',
      Col10: '해당없음',
      Col11: '대학생(신입생) : 연간 1000000원대학생(재학생)  : 연간 3000000원',
      Col12: '신입생 : 관내에서 중학교/ 고등학교를 모두 졸업하고 국내 대학에 입학한 자재학생 : 관내에서 중학교를 졸업하고 국내 대학에 재학 중인 자',
      Col13: '장학생 선발공고일 현재 부모 또는 자녀가 홍천군에 주소지를 두고 5년이상 계속 거주하여야 함.',
      Col14: '2022-02-01~2022-02-20',
      Col15: '해당없음',
      Col16: '0명(추후 운영위원회에서 결정)',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '* 신입생중·고등학교 졸업증명서합격통지서2022년도 대학수학능력시험 성적통지서전·출입 사항이 기록된 주민등록등본 * 재학생중학교 졸업증명서쟇가증명서직전년도 성적증명서전·출입 사항이 기록된 주민등록등본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '홍천군무궁화장학회',
      Col2: '예·체·기능특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생(신입생) : 연간 1000000원대학생(재학생)  : 연간 3000000원',
      Col12: '관내에서 중학교(관외 특수목적 중 포함)를 졸업하고/ 관내/외 고등학교 및 국내 대학교에 입학/재학 중인 자문화·예술·체육·기능 분야의 도단위 공인대회 1위입상 또는 전국단위 이상 공인대회 3위로 입상한 자 ',
      Col13: '장학생 선발공고일 현재 부모 또는 자녀가 홍천군에 주소지를 두고 5년이상 계속 거주하여야 함.',
      Col14: '2022-02-01~2022-02-20',
      Col15: '해당없음',
      Col16: '0명(추후 운영위원회에서 결정)',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '중학교 졸업증명서개인정보 수집/이용/제공 동의서전출입(주소이전)사항이 기록된 주민등록등본   (학생 주소가 관외일 경우 가족관계증명서 1부 추가 제출)전년도 수상실적 증명서류(상장 등)재학증명서'
    },
    {
      Col1: '홍천군무궁화장학회',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '학교별 특색 및 다양한 인재양성 지원을 위해 학교장이 추천한 자',
      Col13: '장학생 선발공고일 현재 부모 또는 자녀가 홍천군에 주소지를 두고 5년이상 계속 거주한 자',
      Col14: '2021-02-01~2021-02-20',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '출신고등학교 학교장의 추천로 선발',
      Col19: ' * 출신 고등학교 장의 추천으로 선발되는 장학금이므로/ 출신 학교 행정실로 문의'
    },
    {
      Col1: '홍천군무궁화장학회',
      Col2: '고시합격자',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '관내 중학교를 졸업하고/ 재학 중 직전년도 고등(사법/ 행정/ 외무/ 기술) 고시에 합격한 자',
      Col13: '장학생 선발공고일 현재 부모 또는 자녀가 홍천군에 주소지를 두고 5년이상 계속 거주한 자',
      Col14: '2021-02-01~2021-02-20',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '중학교 졸업증명서개인정보 수집·이용 제공 동의서전·출입(주소이전)사항이 기록된 주민등록등본고등학교 졸업증명서합격통지서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '대정농협',
      Col2: '조합원자녀장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '조합원으로서 극빈자. 경제적 어려움이 있는 조합원 자녀',
      Col11: '1인당 1500000원',
      Col12: '우리농협 조합원 본인 및 배우자 /자녀 또는 손자로서 국내대학(교)에 재학중(신입생포함)인 자장학생 선발 공고일 현재 우리농협의 조합원 자격 취득 후 2년이 경과한 자자',
      Col13: '해당없음',
      Col14: '2021-02-22~2021-03-12',
      Col15: '농협에서 정한 평가방법에 의거 점수로 평가하여 득점순으로 선발',
      Col16: '대학생 66명 ~70명 내외 ',
      Col17: '공고일 기준 최근 2년간 본 장학금 수혜를 받은타장학금 또는 이와 유사한 학비면제 혜택을 받은 조합원자녀우리농협에 상각채권을 보유한 조합원 자녀현재 재직중인 상근임원/직원/정부기관/정부투자기관/행정기관/기타 유사기관의 상근임원 및 직원의 자녀* 자세한 사항은 첨부자료 참고.',
      Col18: '해당없음',
      Col19: '조합원 및 조합원 자녀 장학생 신청서(농협비치)조합원 자녀를 확인 할 수 있는 서류 (가족관계증명서)등록금 납입증명서 또는 영수증 원본재학증명서직전학기 성적증명서(신입생인 경우 고등학교 3학년 2학기 성적증명서)기초생활수급자증명서 (해당자)농협관련 표창장 및 표창패(부/모) (해당자)농업경영체 등록확인서건강보험자격득실확인서 (부/모) 각 1통개인신용정보의 제공/이용 동의서 (부/모/자녀) (농협비치)  * 자세한 사항은 홈페이지 공지사항 참고'
    },
    {
      Col1: '금왕장학회',
      Col2: '성적 장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 수능 응시자 : 4개 영역 중 2개 영역 이상이 2등급 이내(탐구영역은 2개 과목 평균)수능 미응시자 : 고등학교 2학년(2학기) 3학년(1학기) 전 과목 석차등급 (예체능 제외)평균 2등급 이내 * 재학생 : 직전(前)학년 성적이 4.5점 만점에 4.0점 이상인 자로 하되 기초생활 수급자의 경우 4.0 이상이면 우선선발 (만점이 4.3인 학교는 4.5점으로 환산하여 성적증명서 제출) * 1순위 대학 재학자로서 직전학년 성적 3.5 이상인 자는 우선선발1순위 대학교 : 서울대/ 연세대/ 고려대/ 포항공대/ 한국과학기술원 * 편입생은 편입전 학교의 직전학년 성적/ 복학생은 휴학전의 직전학년 성적으로 심의',
      Col10: '해당없음',
      Col11: '1인당 2500000원 / 2회에 걸쳐 지급',
      Col12: '해당없음',
      Col13: '공고일 현재 1년 이상 금왕읍에 거주하고 있는 읍민 또는 읍민의 자녀 ',
      Col14: '2022-02-07~2022-02-25',
      Col15: '장학생은 심의위원회의 심의를 거쳐 이사회 의결 확정 ',
      Col16: '6명 ',
      Col17: '타 장학금 수여자 중복신청 불가22년 중 휴학예정자/ 군입대 예정자/ 졸업예정자 ',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보제공동의서주민등록등본 (부모와 주소지가 다를 경우 가족관계증명서 첨부)통장사본 (친권자 또는 본인)(해당자) 기초생활수급자 증명서신입생 (수능응시자) : 수능성적표 사본/ 고교 생활기록부 사본신입생 (수능미응시자) : 생활기록부 사본/ 수능미응시확인서재학생 : 성적증명서'
    },
    {
      Col1: '금왕장학회',
      Col2: '특기장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 2500000원',
      Col12: '공공기관 및 민간단체가 주최/주관한 전국규모 이상 대회에서 3위 이상 수상 및 국가대표로 선발된 자단체로 수상한 경우 학교장 추천을 받은 1명만 신청수상실적 : 2021.1.1~2021.12.31',
      Col13: '공고일 현재 1년 이상 금왕읍에 거주 하고있는 읍민 또는 읍민의 자녀',
      Col14: '2022-02-07~2022-02-25',
      Col15: ' * 대회규모별 수상실적 순으로 평가전국대회 < 아시아대회 < 세계대회동 < 은 < 금',
      Col16: '총 7명(성적장학생 포함)',
      Col17: '타 장학금 수여자 중복신청 불가',
      Col18: '단체 수상일 경우 학교장 추천',
      Col19: '장학생 신청서개인정보제공동의서주민등록등본 (부모와 주소지가 다를 경우 가족관계증명서)통장사본 (친권자 또는 본인)기초생활수급자 증명서 (해당자)장학생별 필요서류특기장학생 : 상장사본 및 재학증명서 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '청도농협',
      Col2: '조합원자녀장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '조합원 자녀로서 국내대학 재학생조합원가입 기준일: 2020년 12월 31일 이전 가입자에 한함청도농협 카드/콕뱅크/콕팜 가입자',
      Col13: '해당없음',
      Col14: '2022-03-07~2022-03-18',
      Col15: '이용고 점수(2021년도 실적기준 100점 이상) 80점 + 출자금 잔액(신청일 기준 300만원 이상) 20점',
      Col16: '50명',
      Col17: '방통대 및 사이버대 제외특수 채권 보유 조합원',
      Col18: '해당없음',
      Col19: '청도농협 장학생 신청서재학증명서 1부가족관계증명서 1부'
    },
    {
      Col1: '대전광역시 동구차세대인재육성장학재단',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2017년도 상반기 성적이 평균 A학점 이상인 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '해당없음',
      Col13: '1. 선발공고일 현재 동구에 주소를 두고 1년 이상 계속 거주하는 자(자녀)2. 대전광역시 소재 대학교 재학생',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '4명',
      Col17: '2017년도 타 장학금 수혜자는 제외(단/ 본 장학재단 장학금 지원액의 50%미만 수혜자는 신청 가능)2016년도 본 장학재단 장학금 수혜자 신청 가능',
      Col18: '각 학교장(총장)',
      Col19: '장학금 지원 신청서(반명함판 사진 부착)장학생 추천서학교생활기록부(고등학생)주민등록등본기타입증서류/수급자/한부모가정/국가유공자 증명서 등개인정보 제공 동의서2017년 상반기 성적증명서(대학생)'
    },
    {
      Col1: '대전광역시 동구차세대인재육성장학재단',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '최근 1년간 체육/ 문화/예술/ 과학/ 기술/ 수학 및 외국어경시/ 컴퓨터/ 기능올림픽 등 각종 특기분야 대회에서 입상한 자 * 대회기준은 전국대회 이상으로 한정함그 외 분야에서 국가 또는 대전 동구의 위상을 크게 빛낸 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '해당없음',
      Col13: '선발공고일 현재 동구에 주소를 두고 1년 이상 계속 거주하는 자(자녀)대전광역시 소재 대학교 재학생',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '2019년도 타 장학금 수혜자는 제외(단/ 본 장학재단 장학금 지원액의 50%미만 수혜자는 신청 가능)2018년도 본 장학재단 장학금 수혜자 신청 가능',
      Col18: '각 학교장(총장)',
      Col19: '장학금 지원 신청서(반명함판 사진 부착)장학생 추천서주민등록등본기타입증서류/수급자/한부모가정/국가유공자 증명서 등개인정보 제공 동의서직전(공고일) 1년간의 각종 대회 입상(수상) 증명서(상장/ 상패/ 언론 보도자료 등)    ※ 대회 요강 사본 첨부'
    },
    {
      Col1: '대선공익재단',
      Col2: '대선장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '사회계열/특정학과',
      Col9: '직전학기 평균성적이 C학점 이상이고/ 최소 12학점 이상 이수한 자 (장애학생은 성적기준 미적용)',
      Col10: '가정형편이 어려운 자',
      Col11: '1000000원 * 생활비 용도',
      Col12: '사회복지 관련 전공자가정환경이 어렵지만 면학의지가 있고 타의 모범이 되는 자',
      Col13: '부산소재 17개교울산소재 3개교경남소재 9개교 * 자세한 사항은 기관 홈페이지 참조',
      Col14: '2022-07-22~2022-07-29',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '휴/정학자 / 자퇴 예정자 / 8학기 초과자 제외 ',
      Col18: '개인별 추천 사유 기재 및 증명사진을 첨부한 학과장 추천서',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수 * 자세한 사항은 첨부자료 또는 대선공익재단 홈페이지 참고학과장 추천서재학증명서성적증명서자기소개서개인정보 활용 동의서'
    },
    {
      Col1: '최경주재단',
      Col2: 'SKT최경주장학꿈나무',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '예체능계열',
      Col9: '신규장학생(가산점 기준) 1. 신입생 : 수능성적 30% 이내 가산점 부여 2. 재학생 : 이전학기 평점 4.0(4.5만점기준)이상 우대(3.8/4.3) 3. 대학원생: 대학원 입학 직전의 대학교 평점 4.0 이상 우대 (4.5만점 기준) (3.8/4.3)기존장학생 * 장학생 기간 중 학점 3.5 미만자 탈락 (4.5만점 기준 / 1학년은 제외)',
      Col10: '기초생활수급자 차상위계층권 대상자',
      Col11: ' * 진로개발비(학업비등록금) : 연간 4000000원(학기당 2000000원씩) * 사례관리 지원금 * \'밝은세상선물\'을 통해 라식 라섹시술지원',
      Col12: '대한민국 국적 대학생 혹은 대학원 신입생으로 석사 학위 과정을 희망하는 자학업우수자/ 예체능 계열 우수재원(전국 및 도 단위 대회 입상자) * 자세한 사항은 홈페이지 공고 참고',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '서류심사가정방문최종선발',
      Col16: '해당없음',
      Col17: '국가장학금 및 교내장학금 중복지원 가능하나 유사 기관 및 기업 장학금의 중복 수령은 불가재단 자원봉사활동/ 필수재단행사 불참자의 경우 지원 제한  * 자세한 사항은 홈페이지 공고 참고',
      Col18: '해당없음',
      Col19: '장학 신청서자기소개서진로계발 계획서연간 자원봉사 활동 계획서주민등록등본가족관계증명서증명서류(재산증명 및 가정환경/ 학업증명 등)최경주재단 개인정보 제공 동의서  * 제출서류를 모두 취합하여 PDF파일을 카카오플러스 친구로 제출 ※ 자세한 사항은 홈페이지 공고 참고'
    },
    {
      Col1: '원덕읍향토장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '원덕읍향토장학회 이사회에 심의 및 의결에 의한 인원 및 금액 확정',
      Col12: '원덕읍 지역출신의 재학생(전문대생/ 대학생)',
      Col13: '공고일 기준 본인 또는 부모(친권자/ 후견인) 중 1인이상 원덕읍 관내에 3년이상 주민등록상 거주하고 있는 자원덕읍 관내 중학교 또는 고등학교 졸업자',
      Col14: '2022-08-12~2022-08-26',
      Col15: '1차서류심사 및 적격여부 검토원덕읍향토장학회 이사회에 상정심의 및 의결',
      Col16: '원덕읍향토장학회 이사회에 심의 및 의결에 의한 인원 및 금액 확정',
      Col17: '공고일 현재 휴학생원격대학(방송통신대/ 사이버대학)에 재학중인 자평생교육법에 의거 설립한 학교(직업전문학교 등) 재학중인 자',
      Col18: '해당없음',
      Col19: ' * 직접 또는 우편으로 신청장학금 신청서 및 추천서주민등록등본주민등록초본재학증명서통장사본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '삼성면장학회',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 수능 응시자 : 4개 영역 중 2개 영역 이상이 3등급 이내(탐구영역은 2개 과목 평균)수능 미응시자 : 고등학교 2학년(2학기)/ 3학년(1학기) 전 과목 석차등급(예체능 제외) 평균 3등급 이내인 자 * 재학생 : 직전학년 성적이 4.5점 만점에 3.3점 이상인 자 (장애학생인 경우 3.0이상)  * 편입생 및 복학생 : 편입 전 학교 혹은 휴학 전의 직전 학년 성적으로 심의 ※ 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '대학생(4년제) : 2500000원대학생(23년제): 1500000원',
      Col12: '해당없음',
      Col13: '공고일 현재 1년 이상 삼성면에 거주 하고 있는 면민 또는 면민의 자녀',
      Col14: '2022-02-14~2022-03-04',
      Col15: '장학생선발 심의위원회 심의',
      Col16: '9명 (특기장학생 신청 없을 경우 10명)',
      Col17: '40세 이상(1981.12.31 이전 출생한 자)방송대학/ 통신대학/ 방송통신대학 및 사이버 대학등의 원격 대학/ 대학의 계약학과/ 야간대학/ 평생교육원/ 학점은행 재학자',
      Col18: '해당없음',
      Col19: '신청서 주민등록등본(본인 또는 부모 중 주소가 삼성면인 자)통장사본(본인 또는 부모)성적증명서(계절학기 제외)신입생 : 수능성적표 사본/ 생활기록부 사본 신입생(수능미응시자) : 생활기록부 사본/ 대학합격증명서가족관계증명서(학생 주소가 음성군이 아닐 시) * 자세한 사항은 첨부파일 또는 홈페이지 게시판 참고'
    },
    {
      Col1: '삼성면장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생(4년제) : 2500000원대학생(23년제): 1500000원',
      Col12: '공공기관 및 민간단체가 주최/주관한 전국 규모 이상 대회에서 수상한 자 및 국가대표로 선발된 대학생 * 단체로 수상한 경우 학교장 추천을 받은 1명만 신청',
      Col13: '공고일 현재 1년 이상 삼성면에 거주 하고 있는 면민 또는 면민의 자녀',
      Col14: '2022-02-14~2022-03-04',
      Col15: '장학생선발 심의위원회 심의',
      Col16: '대학생 1명',
      Col17: '40세 이상(1981.12.31 이전 출생한 자)방송대학/통신대학/ 방송통신대학 및 사이버대학 등의 원격 대학/ 대학의 계약학과/ 야간대학/ 평생교육원/ 학점은행 재학자',
      Col18: '해당없음',
      Col19: '신청서주민등록등본통장사본(본인 또는 부모)상장사본가족관계증명서(학생 주소가 음성군이 아닐시)단체수상자)학교장 추천서 * 자세한 사항은 첨부파일 또는 홈페이지 게시판 참고'
    },
    {
      Col1: '성음문화재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 B학점 이상인 자',
      Col10: '경제적 사정으로 학업을 계속하기 어려운 자',
      Col11: '1000000원 (매 학기 연 2회) * 결격사유가 없는 한 졸업 시까지 계속 지급함',
      Col12: '정규대학에 재학 중 또는 신입생소행이 단정하여 타의 모범이 되는 자휴학 예정이 없는 학생',
      Col13: '해당없음',
      Col14: '2022-01-11~2022-01-23',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '학업을 태만히 하여 추천 당시의 성적 평균에 미달된 자소속 학교에서 퇴학/ 정학/ 전학/ 징계 처분을 받은 자휴학/ 군입대/ 질병 기타 사유로 학업을 중단하는 자교내장학금과 국가장학금으로 등록금 전액 장학금을 수혜한 학생221학기 기준 4학년 2학기 생',
      Col18: '추천서 제출',
      Col19: '221학기 또는 212학기 소득분위 증명서성적증명서 (212)지원서 * 기관에서 학교로 추천을 의뢰하는 장학금으로/ 소속 학교 장학팀으로 우선 문의'
    },
    {
      Col1: '울진군장학재단',
      Col2: '특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점 2.0 이상/ 12학점 이상 이수 * 최종학년 재학중인 자 6학점 이상 이수',
      Col10: '해당없음',
      Col11: '1위2500000원2위2000000원3위1500000원',
      Col12: ' * 전문대/ 4년제 재학생 또는 국내에서 학사 자격을 취득할 수 있는 해외대학 재학생21년도 대학생으로/ 재학기간 중 예·체능 도 단위이상 대회에서 3위 이상 입상한 자',
      Col13: '공고일 기준으로 부모(보호자)가 주민등록을 울진군에 2년이상 두고 실거주중 자 ※ 학생 본인만 울진군에 주소지를 두고 타지역 대학에 재학중인 학생은 제외(단독세대/ 조손가정/ 소년소녀가장 신청가능)',
      Col14: '기관 확인 필요',
      Col15: '해당없음',
      Col16: ' * 총 1/390명1차 선발 : 1/200명2차 선발 : 190명',
      Col17: '타 장학금(학자금)을 연 200만원 이상 지급받고 있는 경우에는 미지급대학원 및 정규대학교육과정을 초과하여 재학중인 자동일학년에 한해 휴학 전 울진군대학생장학금을 지급받은 복학생사이버대학/ 방송통신대학생 * 자세한 사항은 첨부파일 참고고',
      Col18: '학교장 또는 관련단체장 추천',
      Col19: '대학생 장학금 신청서재학증명서성적증명서학생 주민등록 등본학생 가족관계 증명서학자금 수혜 확인서(본인 또는 부모 재직 회사 발급)보호자 통장사본개인정보 수집·이용·제공 및 조회 동의서추가 증빙서류(해당자)장학생 추천서입상근거서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '울진군장학재단',
      Col2: '복지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평점 1.0 이상(4.5점만점)/ 12학점 이상 이수자',
      Col10: '기초생활수급자 의료급여수급자(차상위 등)',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '공고일 기준으로 부모(보호자)가 주민등록을 울진군에 2년이상 두고 실거주중인 자',
      Col14: '기관 확인 필요',
      Col15: '해당없음',
      Col16: ' * 총 1/390명1차 선발 : 1/200명 정도2차 선발 : 190명 정도',
      Col17: '타 장학금(학자금)을 연 200만원 이상 지급받고 있는 경우에는 미지급대학원 및 정규대학교육과정을 초과하여 재학중인 자동일학년에 한해 휴학 전 울진군대학생장학금을 지급받은 복학생사이버대학/ 방송통신대학생학생 본인만 울진군에 주소지를 두고 타지역 대학에 재학중인 자',
      Col18: '해당없음',
      Col19: '대학생 장학금 신청서재학증명서성적증명서학생 주민등록 등본학생 가족관계 증명서학자금 수혜 확인서(본인 또는 부모 재직 회사 발급)보호자 통장사본개인정보 수집·이용·제공 및 조회 동의서부모 또는 학생의 수급자증명서 또는 의료급여대상자 증명서추가 증빙서류(해당자)'
    },
    {
      Col1: '울진군장학재단',
      Col2: '학업우수(직장인포함)장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '22년도 1학기 성적 평점 2.0(4.5만점)이상',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '공고일 기준으로 주민등록이 계속하여 울진군 관내에 2년 이상이며 실거주중인 군민 또는 군민의 자녀',
      Col14: '기관 확인 필요',
      Col15: '성적순 선발',
      Col16: '1차 선발 : 1/200명 정도(접수인원에 따라 조정)2차 선발 :   190명 정도(복학생/ 1차 미접수자 등)',
      Col17: '타 장학금(학자금)을 연 150만원 이상 지급받고 있는 경우(단/ 대학에서 수령한 장학금 및 국가 장학금은 중복수혜로 보지 않음)대학원 및 정규대학교육과정을 초과하여 재학중인자동일학년에 한해 휴학전 울진군대학생장학금을 지급받은 복학생사이버대학/ 방송통신대학생',
      Col18: '해당없음',
      Col19: '대학생 장학금 신청서재학증명서성적증명서 학생/부모 주민등록 초본학생의 가족관계 증명서학생 및 부모가 회사 재직시에는 회사에서 발급하는 장학금 수혜 확인서보호자 통장사본개인정보 수집·이용·제공 및 조회 동의서 * 자세한 사항은 첨부파일 혹은 홈페이지 참고 필수* 자세한 사항은 첨부파일 또는 울진군장학재단 홈페이지 참고고'
    },
    {
      Col1: '순천시인재육성장학회',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 (3.5/4.5만점)이상이고/ 직전학기 이수학점이 12학점 이상',
      Col10: '해당없음',
      Col11: '방송통신대학생 : 1000000원대학생(23년제) : 2000000원대학생(4년제) : 3000000원',
      Col12: '국내 소재 대학 재학 중인 학생',
      Col13: '공고일 현재 친권자(후견인)과 학생 본인이 순천시에 주민등록을 두고 2년 이상 계속 거주 하고 있는 대학생대학생 본인의 경우 타지역 거주 인정',
      Col14: '2021-10-18~2021-10-29',
      Col15: '선정기준 : 학업성적과 소득평가를 동시 반영/ 환산점수 동점 시 성적 우선',
      Col16: ' * 총 23명방송통신대학생 1명대학생(2/3년제) 5명대학생(4년제) 17명',
      Col17: '국외소재 대학생국가 등으로부터 학비 등을 지워받는 육사/ 해사/ 공사/ 경찰대 등은 제외한다.1가구 2명 이상 지급 불가 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '순천시인재육성장학금신청서개인정보 수집·이용 및 제공·조회 동의서 주민등록 등본가족관계증명서재학증명서통장사본직전학기 성적증명서건강보험료 납부 확인서건강보험 자격확인서장학금 수혜확인서'
    },
    {
      Col1: '순천시인재육성장학회',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 2.5이상(4.5만점) 인 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '다자녀 가정의 대학교 자녀 * 다자녀 가정 : 부·모 명의 가족관계증명서에 본인을 포함한 형제자매가 3명 이상인 가구',
      Col13: '공고일 현재 친권자(후견인)과 학생 본인이 순천시에 주민등록을 두고 2년 이상 계속 거주 하고 있는 대학생대학생 본인의 경우 타지역 거주 인정',
      Col14: '2021-10-18~2021-10-29',
      Col15: '자녀수 (우선적으로 다자녀 가정 학생을 선발하고/ 동일 점수자에 대하여는 성적 우수 장학금 심사기준에 의해 선발)',
      Col16: '20명',
      Col17: '국외소재 대학생국가 등으로부터 학비 등을 지워받는 육사/ 해사/ 공사/ 경찰대 등은 제외한다.1가구 2명 이상 지급 불가 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '순천시인재육성장학금신청서개인정보 수집·이용 및 제공·조회 동의서 주민등록 등본가족관계증명서재학증명서통장사본직전학기 성적증명서건강보험료 납부 확인서건강보험 자격확인서장학금 수혜확인서부모의 가족관계증명서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '순천시인재육성장학회',
      Col2: '청향(서정현)장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '사회보호 : 3000000원지역사회봉사자 : 4000000원 ※ 학업장려금',
      Col12: '사회보호 분야 : 기초생활수급자 또는 차상위계층 본인 또는 자녀 중 대학교 재학생지역사회 봉사 분야 : 사리사욕 없이 지역사회를 위해 10년 이상 헌신/ 봉사하고 있는 지역사회봉사자의 자녀 ',
      Col13: '사회보호 : 공고일 현재 친권자(후견인)과 학생 본인이 순천시에 주민등록을 두고 2년 이상 계속 거주 하고 있는 대학생지역사회 봉사 : 공고일 현재 순천시에 주민등록이 5년이상 계속 거주하고 잇는 자',
      Col14: '2021-10-18~2021-10-29',
      Col15: '사회보호 분야 : 사회보호 배점 반영/ 동점 시 학업성적 우수자 우선 선발지역사회 봉사 분야 : 순천시인재육성장학회 이사회 또는 이사장이 심의 선발',
      Col16: '사회보호 : 1명지역사회봉사자 : 1명',
      Col17: '국외소재 대학생국가 등으로부터 학비 등을 지워받는 육사/ 해사/ 공사/ 경찰대 등은 제외한다.1가구 2명 이상 지급 불가 * 자세한 사항은 첨부파일 참조',
      Col18: '지역사회 봉사자 : 주소지 읍·면·동장의 추천',
      Col19: '순천시인재육성장학금신청서개인정보 수집·이용 및 제공·조회 동의서 주민등록 등본가족관계증명서재학증명서통장사본수급자증명서(사회보호)추천서(지역봉사)공적요약서(지역봉사)현지조사확인서(필요시/ 지역봉사) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '순천시인재육성장학회',
      Col2: '특기자장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '국제대회 : 2000000원 꿈응원 : 4000000원',
      Col12: ' * 국제대회 : 각종 국외(문학/ 과학 기술/ 예·체능 분야)로 장학생 모집 시작일 현재 1년 이내에 국제대회 3위 이내 * 꿈응원 최근 2년 이내에 예·체능·기능·문학 등의 대회에서 도돤위 이상을 대상으로 공공기관이 주최하는 각종 대회(경연)에 입상한 자로 우리시를 빛낼 미래인재국가대표 선발자각종 대회에서 신기록 수립자',
      Col13: '공고일 현재 친권자(후견인)과 학생 본인이 순천시에 주민등록을 두고 2년 이상 계속 거주 하고 있는 대학생대학생 본인의 경우 타지역 거주 인정',
      Col14: '2021-10-18~2021-10-29',
      Col15: '(국제대회)  대회 성적을 우선하여 선발/ 점수 동일시 연장자 우선 순위 (꿈응원) 순천시인재육성장학회 이사회 또는 이사장이 심의 선발',
      Col16: '국제대회 : 1명꿈응원 : 6명',
      Col17: '국외소재 대학생국가 등으로부터 학비 등을 지워받는 육사/ 해사/ 공사/ 경찰대 등은 제외한다.1가구 2명 이상 지급 불가꿈응원장학생의 경우 유사한 성격의 장학금을 지원받고 있는 자 * 자세한 사항은 첨부파일 참조',
      Col18: '꿈응원 : 관련분야의 기관 또는 협회의 추천',
      Col19: '순천시인재육성장학금신청서개인정보 수집·이용 및 제공·조회 동의서 주민등록 등본가족관계증명서재학증명서통장사본장학금 수혜확인서실적 증명서류자기소개서 및 자기계발계획서(꿈응원)추천서(꿈응원) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '순천시인재육성장학회',
      Col2: '다문화가정자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '다문화가정의 자녀 중 국내소재 대학(교)에 재학 중인 자',
      Col13: '공고일 현재 친권자(후견인)과 학생 본인이 순천시에 주민등록을 두고 2년 이상 계속 거주 하고 있는 대학생대학생 본인의 경우 타지역 거주 인정',
      Col14: '2020-10-19~2020-10-30',
      Col15: '소득을 우선으로 선발/ 동일 점수자에 대해서는 학업성저거 우수자 선발',
      Col16: '2명',
      Col17: '국외소재 대학생국가 등으로부터 학비 등을 지워받는 육사/ 해사/ 공사/ 경찰대 등은 제외한다.1가구 2명 이상 지급 불가 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '순천시인재육성장학금신청서개인정보 수집·이용 및 제공·조회 동의서 주민등록 등본가족관계증명서재학증명서통장사본직전학기 성적증명서건강보험료 납부 확인서건강보험 자격확인서장학금 수혜확인서다문화 증빙서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '순천시인재육성장학회',
      Col2: '새터민자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 2.5이상(4.5만점) 인 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '새터민(북한이탈자주민) 자녀 중 국내 대학(교)에 재학 중인 자',
      Col13: '공고일 현재 친권자(후견인)과 학생 본인이 순천시에 주민등록을 두고 2년 이상 계속 거주 하고 있는 대학생대학생 본인의 경우 타지역 거주 인정',
      Col14: '2020-10-19~2020-10-30',
      Col15: '소득을 우선으로 선발/ 동일 점수자에 대하여는 학업성적 우수자 선발',
      Col16: '2명',
      Col17: '국외소재 대학생국가 등으로부터 학비 등을 지워받는 육사/ 해사/ 공사/ 경찰대 등은 제외한다.1가구 2명 이상 지급 불가 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '순천시인재육성장학금신청서개인정보 수집·이용 및 제공·조회 동의서 주민등록 등본가족관계증명서재학증명서통장사본직전학기 성적증명서건강보험료 납부 확인서건강보험 자격확인서장학금 수혜확인서'
    },
    {
      Col1: '장흥군인재육성장학회',
      Col2: '대학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 대학입학 수능성적 변환 표준점수에 의한 백분위 평균점수가 100분의 70이상인 자 (수시/ 특차전형자도 이에 준함)재학생 : 21학년도 2학기 과목별 평균평점이 B학점 이상인 자다자녀 : 부모명의 가족관계증명서에 본인 포함 형제자매가 3명 이상인 가구 \'21학년도 2학기 과목별 평균평점이 B학점 이상인 자',
      Col10: '해당없음',
      Col11: '1000000 ~ 2500000원',
      Col12: '2022년도 대학교 신입생/ 재학생/ 다자녀/ 농수산 말 관련 대학 ',
      Col13: '신청일 현재 장흥군에 본적 또는 1년이상 계속해서 주민등록을 두고 군내 초/중/고교 중 1개교 이상을 졸업한 자',
      Col14: '2022-02-17~2022-03-10',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원생/ 유학생/ 야간대학교 재학생/ 한국방송통신대학생/사이버대학생/ 복학생중 전(前)학년도 2학기 성적을 제시할 수 없는 자',
      Col18: '읍/면장',
      Col19: '장학금 지원(추천)신청서읍/면장 확인서개인정보 수집/이용 및 제공/조회 동의서2021학년도 2학기 성적증명서2022학년도 학자금 납입증명서(한국장학재단)졸업증명서 (관내 초/중/고 모두)가족관계증명서/ 주민등록등본 각 1통 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '강원랜드사회공헌위원회',
      Col2: '하이원SOS장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '학업에 심각한 어려움을 겪고 있는 청소년',
      Col11: '최대 3000000원',
      Col12: '갑작스러운 가정/경제 위기상황(부모의 사망/ 질병 등)으로 학업에 심각한 어려움을 겪고 있는 대학생(재학생)강원 폐광지역(정선/ 태백/ 영월/ 삼척) 소재학 고교 출신(졸업생)',
      Col13: '강원 폐광지역 소재 고교를 졸업한 국내 대학생생',
      Col14: '상사모집',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '최근 3년간 하이원 장학금 지원자 신청 불가가',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '디아코니아장학위원회',
      Col2: '다음세대장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생/대학원생 : 2000000원/년',
      Col12: '다른 사람들의 모범이 되고/ 선한 영향력을 주며/ 헌신 봉사할 학생2022년 1월 현재 대학/대학원에 재학 중인 학생(입학예정자 포함)구체적인 자기 학습계획을 가지고 비전을 이루어 가는 예비대학/ 대학/ 대학원생',
      Col13: '강원도 소재 학교에서 학업 중이거나/ 강원도 출신으로 타 지역에서 학업 중인 학생',
      Col14: '2022-01-24~2022-02-18',
      Col15: '해당없음',
      Col16: '00명',
      Col17: '한 지원자는 한 분야에만 지원 가능',
      Col18: '담당(지도)교수 추천',
      Col19: '응시원서 1부추천서 및 자기소개서 각 1부성적증명서주민등록등본자원봉사활동 인증서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '디아코니아장학위원회',
      Col2: '외국인장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생/대학원생 : 200만원/년',
      Col12: '도내 대학교에서 학업이 우수한 외국인 대학생/ 대학원 생 2021년 1월 현재/ 정통교단에 속하는 교회에 출석하고 있으며 대학생/ 대학원생에 재학중인 경우우',
      Col13: '강원도 소재 학교에서 학업 중이거나/ 강원도 출신으로 타 지역에서 학업 중인 분',
      Col14: '2021-01-25~2021-02-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '한 지원자는 한 분야에만 지원 가능의무 교육의 대상이 되는 경우',
      Col18: '담당(지도)교수 추천',
      Col19: '응시원서 1부추천서 및 자기소개서 1부성적증명서 1부 주민등록등본 1부 자원봉사활동 인증서 1부교인증명서'
    },
    {
      Col1: '디아코니아장학위원회',
      Col2: '음악전공자장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '예체능계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생/대학원생 : 2000000원/년',
      Col12: '대학/대학원에 재학 중인 학생(입학예정자)교회의 예배를 위하여 피아노/ 기악과 성악 등을 전공하며 봉사하는 대학생',
      Col13: '강원도 소재 학교에서 학업 중이거나/ 강원도 출신으로 타 지역에서 학업 중인 학생',
      Col14: '2021-01-25~2021-02-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '한 지원자는 한 분야에만 지원 가능',
      Col18: '담당(지도)교수 추천',
      Col19: '응시원서 1부추천서 및 자기소개서 각 1부성적증명서 (대학신입생은 합격통지서/ 휴학생은 최근학기 성적증명서)주민등록등본 1부자원봉사활동 인증서 1부 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '디아코니아장학위원회',
      Col2: '외국인유학장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '도내 대학교에서 학업이 우수한 외국인 대학생 및 대학원생',
      Col13: '강원도 소재 대학교에서 학업 중인 자강원도 출신으로 타 지역에서 학업 중인 자',
      Col14: '2020-01-21~2020-02-07',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '1인 1분야 지원가능 ',
      Col18: '해당없음',
      Col19: '응시원서추천서 및 자기소개서성적증명서주민등록등본자원봉사활동인증서(해당자) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '강진군민장학재단',
      Col2: '성적우수분야',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '평균 \'B학점\'이상 * 자세한 사항은 홈페이지 참고',
      Col10: '재산세 50만원 이하',
      Col11: '전문대 2000000원대학교 2000000원대학원 2000000원*관내고교 졸업대학교 1000000원대학원 1000000원',
      Col12: '해당없음',
      Col13: '공고일 현재 본인 또는 보호자가 강진군 내에 1년 이상 주소를 두고 실제 거주하고 있는 자강진군 관내 고등학교 졸업자 * 관내 중학교를 졸업한 관외 고등학교 졸업자 관내중학교 졸업자분야 신청가능',
      Col14: '2022-08-11~2022-08-31',
      Col15: '성적(90)/ 생활정도(10)를 고려하여 선발',
      Col16: '총 33명 * 자세한 사항은 홈페이지 또는 첨부파일 참고',
      Col17: ' 매 학기 등록금 납부액이 50만 원 이하인 대학생(전문대 포함)국가 등으로부터 등록금/ 수업료 등을 전액 지원받는 육/해/공군사관학교/ 경찰대 등정규 학제 기간(정규 이수학기)을 초과하여 재학 중인 자 1가족당 1명만 신청 ',
      Col18: '읍/면장',
      Col19: '강민군민장학재단 장학금 신청서주민등록 등본가족관계증명서개인정보 수집.이용 및 제공.조회 동의서 1부장학금 지급 통장 사본 1부세목별 과세 증명서건강보험료 납부확인서건강보험료 자격확인서직전학기 성적증명서재학증명서학교 발급 등록금 납부확인서관내 고등학교 졸업 증명서신청인 서약서 * 자세한 사항은 첨부파일 참고 * 신청서 교부 및 접수장소 : 읍/면사무소 * 자세한 사항은 첨부자료 또는 홈페이지 참고'
    },
    {
      Col1: '강진군민장학재단',
      Col2: '특기자분야',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '분야 : 체육/ 과학/ 컴퓨터/ 문화예술/ 만화/ 기술/ 수학 및 외국어경시/ 기능올림픽 입상자직전 학기 기간 중 도 단위 협회/ 연맹 이상의 단체나 기관에서 주관한 전국대회 3위 이내 입상자(장려상 포함)/ 전라남도대회 3위 이내 입상자 또는 이와 동등한 정도의 수상자로 강진군 및 대한민국을 빛낸 자',
      Col13: '공고일 현재 본인 또는 보호자가 강진군 내에 1년 이상 주소를 두고 거주하고 있는 자 강진군 관내 고등학교 졸업자 * 관내 중학교를 졸업한 관외 고등학교 졸업자 신청가능',
      Col14: '2022-08-11~2022-08-31',
      Col15: '상위 입상자/ 수상회수 다수자 우선 선발',
      Col16: '1명',
      Col17: '1가족당 1명만 신청매 학기 등록금 납부액이 50만 원 이하인 대학생국가 등으로부터 등록금/ 수업료 등을 전액 지원받는 육/해/공군사관학교/ 경찰대 등정규 학제 기간(정규 이수학기)을 초과하여 재학 중인 자 ',
      Col18: '읍/면장',
      Col19: '강민군민장학재단 장학금 신청서주민등록 등본 (공고일 이후 발급 주민등록등본)직전학기 성적증명서관내 고등학교 졸업증명서학교발급 등록금 납입고지서 재학증명서 세목별 과세 증명서 (2021년도 부/모 각 1부씩)건강보험료 납부확인서 (2020년도 부/모 각 1부씩)통장계좌 사본 (부/모 또는 학생)관내 중학교 졸업증명서 (관외 고등학교 졸업자에 한함)신청인 서약서개인정보 수집/이용 및 제공/조회 동의서 (부/모/학생 각각)수상증서 사본경기실적증명서 등 입상증명서 * 신청서 교부 및 접수장소 : 읍/면사무소 * 자세한 사항은 첨부자료 또는 홈페이지 참고'
    },
    {
      Col1: '강진군민장학재단',
      Col2: '복지분야',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평균 C학점 이상직전학기 성적이 상위 50% 이내인 자 ',
      Col10: '보호자 전답 10000㎡ 이하이고 재산세 10만 원 이하경제적으로 어려운 자 우선 ',
      Col11: '전문대 2000000원대학교 2000000원',
      Col12: '해당없음',
      Col13: '공고일 현재 본인 또는 보호자가 강진군 내에 1년 이상 주소를 두고 거주하고 있는 자강진군 관내 고등학교 졸업하고 재학중인 자',
      Col14: '2022-08-11~2022-08-31',
      Col15: '성적 300점/ 생활정도 700점',
      Col16: ' 전문대 : 2명 / 일반대학: 4명  * 자세한 사항은 홈페이지 또는 첨부파일 참고',
      Col17: '1가족당 1명만 신청매 학기 등록금 납부액이 50만 원 이하인 대학생국가 등으로부터 등록금/ 수업료 등을 전액 지원받는 육/해/공군사관학교/ 경찰대 등정규 학제 기간(정규 이수학기)을 초과하여 재학 중인 자 ',
      Col18: '읍/면장',
      Col19: '강민군민장학재단 장학금 신청서주민등록 등본 (학생 또는 보호자 중 1인)가족 관계 증명서개인정보 수집.이용 및 제공.조회 동의서 1부장학금 지급 통장 사본 1부세목별 과세 증명서건강보험료 납부확인서건강보험료 자격확인서직전학기 성적증명서 1부 재학증명서학교발급 등록금 납부확인서관내 고등학교 졸업 증명서 신청인 서약서 * 신청서 교부 및 접수장소 : 읍/면사무소 * 자세한 사항은 첨부자료 또는 홈페이지 참고'
    },
    {
      Col1: '강진군민장학재단',
      Col2: '다자녀분야',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평균 C학점 이상직전학기 성적이 상위 50% 이내로 만 30세 이내인 자 ',
      Col10: '보호자 전답 40000㎡이하이고 재산세 50만원 이하',
      Col11: '2000000원',
      Col12: '형제자매 3인 이상 가정의 학생생',
      Col13: '공고일 현재 본인 또는 보호자가 강진군 내에 1년 이상 주소를 두고 거주하고 있는 자강진군 관내 고등학교 졸업자',
      Col14: '2022-08-11~2022-08-31',
      Col15: '성적 500점/ 생활정도 500점',
      Col16: '총 11명 ',
      Col17: '1가족당 1명만 신청매 학기 등록금 납부액이 50만 원 이하인 대학생국가 등으로부터 등록금/ 수업료 등을 전액 지원받는 육/해/공군사관학교/ 경찰대 등정규 학제 기간(정규 이수학기)을 초과하여 재학 중인 자 ',
      Col18: '읍/면장',
      Col19: '강민군민장학재단 장학금 신청서주민등록 등본가족관계증명서(자녀 3인 이상)개인정보 수집.이용 및 제공.조회 동의서 1부장학금 지급 통장 사본 1부세목별 과세 증명서건강보험료 납부확인서건강보험료 자격확인서직전학기 성적증명서 재학증명서학교발급 등록금 납부확인서관내 고등학교 졸업증명서신청인서약서  * 신청서 교부 및 접수장소 : 읍/면사무소 * 자세한 사항은 첨부자료 또는 홈페이지 참고'
    },
    {
      Col1: '강진군민장학재단',
      Col2: '명문대분야',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2100000원  * 한 학년에 1회 지급',
      Col12: '강진군 관내 고등학교 졸업생 중 서울대/ 연세대/ 고려대/ 이화여대/ 의대/ 치대/ 한의대/ 포항공대/ 전국과학기술원 재학생 및 신입생',
      Col13: '공고일 현재 본인 또는 보호자가 강진군 내에 1년 이상 주소를 두고 거주하고 있는 자강진군 관내 고등학교 졸업자',
      Col14: '2022-01-24~2022-02-16',
      Col15: '해당없음',
      Col16: '7명 ',
      Col17: '1가족당 1명만 신청매 학기 등록금 납부액이 50만 원 이하인 대학생국가 등으로부터 등록금/ 수업료 등을 전액 지원받는 육/해/공군사관학교/ 경찰대 등정규 학제 기간(정규 이수학기)을 초과하여 재학 중인 자 ',
      Col18: '읍/면장',
      Col19: '강민군민장학재단 장학금 신청서주민등록 등본 (학생 또는 보호자 중 1인)가족관계증명서개인정보 수집.이용 및 제공.조회 동의서 1부 장학금 지급 통장 사본 1부재학증명서학교 발급 등록금 납부확인서관내 고등학교 졸업증명서  * 신청서 교부 및 접수장소 : 읍/면사무소 * 자세한 사항은 첨부자료 또는 홈페이지 참고'
    },
    {
      Col1: '강진군민장학재단',
      Col2: '귀농인자녀분야',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평균 C학점 이상',
      Col10: '재산세 50만 원 이하',
      Col11: '2000000원',
      Col12: '대학생은 관외 중. 고등학교를 졸업한 학생 신청 가능. 단/ 관내 학교 졸업자 우선선',
      Col13: '공고일 현재 1년 전부터 강진군에 주소를 두고 거주하는 귀농인 자녀강진군 관내 고등학교를 졸업한 자 우선 선발/ 귀농일 기준 관외 고등학교 졸업자도 후순위로 선발 가능',
      Col14: '2022-08-11~2022-08-31',
      Col15: '성적(50)/ 생활정도(50)를 고려하여 선발',
      Col16: '총 1명',
      Col17: '1가족당 1명만 신청매 학기 등록금 납부액이 50만 원 이하인 대학생국가 등으로부터 등록금/ 수업료 등을 전액 지원받는 육/해/공군사관학교/ 경찰대 등정규 학제 기간(정규 이수학기)을 초과하여 재학 중인 자 ',
      Col18: '해당없음',
      Col19: '강민군민장학재단 장학금 신청서주민등록 등본가족 관계 증명서개인정보 수집. 이용 및 제공.조회 동의서 1부장학금 지급 통장 사본 1부세목별 과세 증명서건강보험료 납부 확인서건강보험료 자격확인서직전학기 성적증명서 1부 재학증명서학교 발급 등록금 납부 확인서관내 고등학교 졸업증명서신청인 서약서농업경영체등록확인서 * 신청서 교부 및 접수장소 : 읍/면사무소 * 자세한 사항은 첨부자료 또는 홈페이지 참고'
    },
    {
      Col1: '현마육영재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평점평균 3.5 이상인 학생',
      Col10: '가정형편이 어려운 학생',
      Col11: '장학금액 : 등록금 전액(결격사유 없는 한 졸업시까지)※ 교내 또는 국가 장학금의 이중 수혜는 불가함',
      Col12: '한국외국어대학교 학부 재학생 중 2022학년도에 2학년 진급예정자',
      Col13: '해당없음',
      Col14: '2022-01-17~2022-01-28',
      Col15: '1. 서류접수2. 면접심사',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '* 신청시 학교 장학부서에 문의 필수.현마장학생 지원서 1부(본 재단 소정양식 http://hyunmaedu.com)자기소개서 1부(A4용지 1매 정도로 자유양식)부/모의 2021년 지방세 세목별 과세(납세)증명서 각 1부(주민자치센터 발급)부/모의 2021년 건강보험료 납부 확인서 각 1부(국민건강보험공단)기타 가계곤란을 증빙할 수 있는 서류(해당자에 한해 제출)성적증명서 1부'
    },
    {
      Col1: '강상면장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 성적기준 없음재학생 : 직전학년 중 한 학기 평점 3.0 이상자',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '1999년 8월 9일 이전부터 양평군 강상면 관내에 주소를 두고 계속 거주하는 주민 및 자녀',
      Col14: '2022-02-16~2022-03-05',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '방송통신대학생/ 외국유학생/ 대학원생/ 산업체위탁교육생/ 학점은행제/ 사이버대학생한국장학재단 설립 등에 관한 법률 제50조의5(중복지원의 방지)에  의거 중복지원 학생',
      Col18: '해당없음',
      Col19: ' * 공통서류 *장학생 선발지원서장학생카드가족관계증명서개인정보 수집 이용 동의서 * 개별서류 신입생 : 재학증명서재학생: 재학증명서 및 성적증명서특기장학생: 재학증명서 및 특기증명서국민기초생활보장수급자: 재학증명서 및 국민기초생활보장수급자증명원가세빈곤자: 재학증명서 및 재산세과세증명 또는 미과세증명명 '
    },
    {
      Col1: '강상면장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '예/체능 전국대회 이상 입상 ',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '1999년 8월 9일 이전부터 양평군 강상면 관내에 주소를 두고 계속 거주하는 주민 및 자녀 ',
      Col14: '2022-02-21~2022-03-04',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '방송통신대학생/ 외국유학생/ 대학원생/ 산업체위탁교육생/ 학점은행제/ 사이버대학생한국장학재단 설립 등에 관한 법률 제50조의5(중복지원의 방지)에  의거 중복지원 학생',
      Col18: '해당없음',
      Col19: '재학증명서 및 특기증명서(예체능 전국대회 이상 입상)'
    },
    {
      Col1: '강상면장학회',
      Col2: '가계빈곤자',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정형편이 어려운자',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '1999년 8월 9일 이전부터 양평군 강상면 관내에 주소를 두고 계속 거주하는 주민 및 자녀',
      Col14: '2022-02-21~2022-03-04',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '방송통신대학생/ 외국유학생/ 대학원생/ 산업체위탁교육생/ 학점은행제/ 사이버대학생한국장학재단 설립 등에 관한 법률 제50조의5(중복지원의 방지)에  의거 중복지원 학생',
      Col18: '해당없음',
      Col19: '재학증명서재산세과세증명 또는 미과세증명 (부/모 각 1통)장학생 선발지원서장학생카드가족관계증명서(학생기준)개인정보 수집이용동의서서'
    },
    {
      Col1: '성림교회',
      Col2: '대학장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학성적 평균 B학점 이상',
      Col10: '건강보험료 지역 12만원 직장 7만원 이하인 해당학생',
      Col11: '1000000원~2000000원(1인당)',
      Col12: '관악구 거주 대학 재학생으로/ 재학성적 평균 B학점 이상이며 장학금 지급이 필요한 가정의 학생',
      Col13: '관악구 거주 대학 재학생',
      Col14: '2022-08-01~2022-08-24',
      Col15: '서류심사면접심사',
      Col16: 'O명',
      Col17: ' * 해당 기관으로 문의',
      Col18: '해당없음',
      Col19: '장학생신청서성적증명서주민등록등본재학증명서의료보험료납입증명서(영수증)가족관계증명서의사소견서(가족 중 환자 증명용) 각 1통 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '한국사회복지협의회',
      Col2: '기아드림장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학생 : 3.0/4.5 이내',
      Col10: '가구 월평균 소득이 2020년도 중위소득 기준(80%) 이내 월 건강보험료 기준 이하인 가정(직장가입자)기초생활수급자',
      Col11: '23년제 : 3000000원4년제 : 5000000원',
      Col12: '자동차 교통사고로 인하여 사망하거나 중증후유장애(1~4급)를 입은 사람의 유자녀',
      Col13: '해당없음',
      Col14: '2020-12-14~2021-01-22',
      Col15: '해당없음',
      Col16: '00명',
      Col17: '사이버대학/ 방송통신대학/ 평생교육원/ 기술학교/ 직업학교 재학중인 자/ 휴학 예정자/ 초과학기 재학생모교의 학칙 위반 및 이로 인한 퇴학/ 정학등의 징계를 받은 자학업을 중도에 포기하여는 경우 (휴학의 경우 해당학기 환수조치)기타 장학생으로서 바람직하지 못하거나 본 사업의 취지와 어긋나는 행동을 했다고 평가될 경우',
      Col18: '해당없음',
      Col19: '온라인 접수장학금 지원 신청서생꼐를 같이하는 부모명의 가족관계증명서 & 학생명의 주민등록등본교통사고사실확인원 & 장애인등록증가정환경 증빙자료재학증명서 및 대학합격 통지서추천기관 또는 장학생 통장 사본직전학기 성적증명서 '
    },
    {
      Col1: '정읍산림조합',
      Col2: '늘푸른장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 1000000원 ',
      Col12: '조합원자녀(조합원포함) 중 현재 대학교에 재학 중인 자(2년제 및 4년제 대학)조합원 가입 후 3년 이상 조합원 신분을 계속 유지(승계포함)한 자녀조합원이 직접 부양하는 자녀(※손자녀의 경우 신청제외)',
      Col13: '해당없음',
      Col14: '2022-01-10~2022-01-14',
      Col15: '성적 10& + 학년 10% + 조합원가입기간 10& + 출자금 10% + 예금 10% + 대출 20% + 유통센터이용실적 20% + 기타 10%',
      Col16: '15명',
      Col17: '정읍산림조합 조합원 가입일이 2018년 1월 1일 이후 가입했을 때공고일 현재 3개월 이상 연채채권보유 중인자기존 정읍산립조합 장학생 선발된 조합원의 가족1세대당 2명이상 신청하였을때 (상위 1인만 적용)',
      Col18: '해당없음',
      Col19: '장학생 신청서 가족관계증명서 재학증명서성적증명서  정보제공동의서 '
    },
    {
      Col1: '하이트진로홀딩스㈜',
      Col2: '하이트진로 장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 이상을 이수한 자로서 성적이 4.5점 만점 기준 3.0 이상 (※ 백분위 환산점수 적용 안됨)',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '수도권 소재 대학생(지방캠퍼스 포함) 중 2022년도 기준 2/3/4학년 (22년도 기준 1학기 이상 이수 및 잔여학기 1학기 이상인 자)로서 요식업주 및 휴·폐업 자영업자의 자녀 * 휴·폐업의 경우 20년 1월 1일 이후 휴·폐업 해당 ※ 자세한 사항은 첨부파일 참조',
      Col13: '해당없음',
      Col14: '2021-11-08~2021-12-10',
      Col15: '접수방법 : 각 대학 홈페이지 게시판 또는 하이트진로홀딩스 홈페이지에서 하이트진로 장학생 선발 안내문 숙지 후 작성양식 3종 다운로드 → 작성 후 증빙서류 첨부하여 등기우편 신청 및 접수심사기준 : 가계곤란도 40%/ 성적 30%/ 필요성 및 회사 이해도 30% ',
      Col16: '70명',
      Col17: '지원 불가능 자영업 업종업주 자녀 ( * 첨부파일 내 지원제외 대상 업종품목 참조)',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서개인정보 수집·이용 동의서장학생 선발을 위한 사전 확약서전학년 성적증명서주민등록등본 또는 가족관계증명서신청년도 건강보험료 납부 확인서사업자등록증 사본 또는 휴·폐업 증명서'
    },
    {
      Col1: '네덜란드교육진흥원',
      Col2: '홀란드장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 총 5000유로',
      Col12: '비유럽경제지역(nonEEA) 국가 국적자 네덜란드 고등교육기관의 2020년 9월 입학 정규 학사/석사과정 지원자(교환학생은 해당 안 됨)본인이 지원하는 개별 네던란드 대학(원)의 입학요건에 부합할 것네덜란드의 교육기관에서 이전에 학위를 취득한 적이 없는 자',
      Col13: '해당없음',
      Col14: '기관 문의',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 네덜란드 대학에서 장학생을 직접 선발 및 발표 하므로 선발 기준 확인 및 문의는 본인이 지원하는 네덜란드 대학정보를 참고하셔야 합니다.'
    },
    {
      Col1: '안중근의사숭모회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체 성적 평균 3.4이상 (4.3만점 기준) 4.5일 경우 3.6이상',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '국내 소재 대학의 2~3학년 재학생으로 소속대학장의 추천을 받은 자 ( *  안중근 의사 홍보활동 및 참여실적 또는 계획서 제출 가능자)',
      Col13: '해당없음',
      Col14: '2021-10-01~2021-10-12',
      Col15: '선발심사 위원회의 심의 및 면접',
      Col16: '5명',
      Col17: '휴학생 신청 불가',
      Col18: '대학교 소속대학장 추천',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.안중근 장학 신청서소속 대학 총장(대학장)의 확인을 받은 지도교수 추천서성적증명서자기소개서안중근 의사 홍보활동 및 참여실적 또는 계획서'
    },
    {
      Col1: '대산농촌재단',
      Col2: '대산농업리더장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학4학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2학년 1학기까지 누계 평균평점 3.0 이상(4.5만점 기준)인 학생2.88(4.3 만점 기준)/ 80점(100점 만점 기준)',
      Col10: '해당없음',
      Col11: '등록금 전액(졸업 시까지 총 4학기)농업리더양성 프로그램(농업 선진지 연수 및 농업 CEO 멘토링)',
      Col12: '국내 4년제 대학 2학년 2학기 재학생졸업 후 농업계에 종사하며 리더로 성장하겠다는 투철한 실천 계획을 가진 사람(영농/ 농업연구/ 유통 등 농업관련 분야 진출) * 영농기반이 있는 영농희망자 우선 선발 * 농학계열 재학생 우대',
      Col13: '해당없음',
      Col14: '2021-09-29~2021-11-16',
      Col15: '1차: 서류심사2차: 심층면접(보호자 동반) ',
      Col16: '5명',
      Col17: '정부나 타 단체 장학금 중복 수혜 불가',
      Col18: '해당없음',
      Col19: '* 1차 제출서류대산농업리더장학생 지원서계획서* 2차 제출서류(면접 시 제출/서류전형 합격자에 한함)지도교수 추천서(홈페이지에서 양식 확인)재학증명서성적증명서가족관계증명서영농현황 자료(본인 또는 보호자)영농교육 수료증명서(본인): 해당자에 한함※ 이메일 제출: dsa@dsa.or.kr'
    },
    {
      Col1: '우덕재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전학년 평점 3.0이상인 자 (4.5만점 기준)',
      Col10: '이공계열 재학생 중 가정환경이 어려운 자',
      Col11: '해당없음',
      Col12: '20222학기 기준 대학교 학부 재학생가정환경이 어렵지만/ 학업 성적이 우수한 이공계열 재학생기계/ 전기/ 화학공학/ 안전/ 환경분야 전공자',
      Col13: '해당없음',
      Col14: '2022-08-23~2022-09-01',
      Col15: '해당없음',
      Col16: ' * 학교별로 추천인원 상이',
      Col17: '타 장학재단 등록금 지원 장학금 중복수혜 불가',
      Col18: ' * 학교의 추천으로 선발되는 장학금 ',
      Col19: '* 재단이 선정한 학교의 추천 방식으로/ 신청시 각 학교 장학부서에 지원 가능여부 문의 필수. (학교별로 지원 자격이 상이하므로 반드시 확인하시기 바랍니다.)장학생 추천 및 추천서자기소개서개인정보 제공 및 활용 동의서보호자 건강보험료 납입증명서주민등록등본재학증명서성적증명서등록금 고지서 또는 등록금 고지액 명세표 * 위의 모든제출은 반드시 원본 제출'
    },
    {
      Col1: '한국여학사협회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '경제적 도움이 필요한 학생',
      Col11: '1000000원 * 등록금 범위 내 중복 수혜 가능 (교내·외 포함)',
      Col12: '2022년 현재 서울 및 수도권 소재 일반대학원 석박사 과정에 재학 중인 학업의지가 높고 경제적 지원이 필요한 여학생',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-08-01',
      Col15: '해당없음',
      Col16: '6명',
      Col17: '신입생/ 수료생/ 특수대학원 재학생/ 취업중인 자 제외',
      Col18: '전공학과 지도교수의 추천서 제출',
      Col19: '장학금신청서전공분야의 연구계획서 또는 논문계획서재학증명서/ 성적증명서 각 1부전공학과 지도교수 추천서 1부 (자유양식) * email 접수/ 자세한 사항은 한국여학사협회 홈페이지 참고'
    },
    {
      Col1: '일운과학기술재단',
      Col2: '희망장학생(우수인재장학금)',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/전문대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최고 20000000원 * 최대 3년 지원으로 3년 통합 최고 지원 금액',
      Col12: '국내 대학 석사/ 석/박사 통합과정 및 박사과정 재학생(전공제한 없음)',
      Col13: '해당없음',
      Col14: '2022-09-01~2022-09-18',
      Col15: '(1차) 서류심사(2차) AI역량검사(3차) 면접심사',
      Col16: '0명',
      Col17: '희망/ 나눔 장학생 중복지원 불가 현재 회사에 재직 중인자 불가한국장학재단장학금과 교내 장학금을 제외한 타 장학금 수혜자는 지원 불가수료자/ Post Dr. 지원불가장학재단 규정에 의거 결격사유에 해당하는 자',
      Col18: '해당없음',
      Col19: '장학생 지원서 1부재학증명서 1부성적증명서 1부지도 교수추천서 1부 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '일운과학기술재단',
      Col2: '나눔장학생(면학장학금)',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/전문대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가계형편이 어려운 자',
      Col11: '최고 20000000원 * 최대 3년 지원으로 3년 통합 최고 지원 금액',
      Col12: '국내 대학 석사/ 석/박사 통합과정 및 박사과정 재학생',
      Col13: '해당없음',
      Col14: '2022-09-01~2022-09-18',
      Col15: '(1차) 서류심사(2차) AI역량검사(3차) 면접심사',
      Col16: '0명',
      Col17: '희망/ 나눔 장학생 중복지원 불가 현재 회사에 재직 중인자 불가한국장학재단장학금과 교내 장학금을 제외한 타 장학금 수혜자는 지원 불가수료자/ Post Dr. 지원불가장학재단 규정에 의거 결격사유에 해당하는 자',
      Col18: '해당없음',
      Col19: '장학생 지원서 1부재학증명서 1부 성적증명서 1부지도 교수추천서 1부가족관계증명서 1부건강보험납입증명서 각 1부재산세과세증명 또는 미과세 증명원(직전년도) 각 1부소득금액증명원(직전년도) 각 1부 * 자세한 사항은 첨부파일 참고 * 자세한 사항은 홈페이지 게시판 참고'
    },
    {
      Col1: '녹산학술장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 10000000원',
      Col12: '대학교 1~3학년에 재학중인 자로/ 재단에서 제시하는 훈련활동에 참여가능하며 소속 학과 지도교수 또는 소속 대학 현역 교수의 추천을 받은 자훈련활동 : \' 선진한국을 만들기 위한 인간상\'을 주제로 분석하고 대안을 제시하는 보고서 제출',
      Col13: '해당없음',
      Col14: '2021-08-23~2021-10-03',
      Col15: '해당없음',
      Col16: '4명 내외',
      Col17: '타 기관 (장학재단)의 장학금을 중복으로 받는 자는 신청 불가휴학자',
      Col18: '대학의 소속 학과 지도교수 또는 소속 대학의 현역 교수의 추천',
      Col19: '보고서 (한글프로세스 파일) 제출장학금신청서추천서 (교수 날인 필수)대학재학증명서전 학년 성적증명서 (100점 만점 환산점수포함)주민등록등본 * 전 학년 성적증명서는 1학년일 경우 제출 제외 / 재단에서 대학교로 추천 요청 공문을 보내는 장학금이므로/ 자세한 사항은 교내 홈페이지 참조'
    },
    {
      Col1: '5.18기념재단',
      Col2: '5.18희망장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원 (생활비 장학금)',
      Col12: '민주화운동 및 국가폭력 희생자 (유)자녀5·18정신계승 사회공헌 대학생 (민주/인권 활동 포함)국내 대학 재학생 (4년제·전문대 무관/ 전공제한 없음)',
      Col13: '해당없음',
      Col14: '2022-09-13~2022-09-20',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '대학원생 및 휴학생징계받은 자 또는 징계 의결 중인 자장학생으로서의 품위를 손상한 자장학생 선정 이후 5.18관련 교육 미참여자자 * 자세한 사항은 첨부파일 및 홈페이지 공고문 참고',
      Col18: '해당없음',
      Col19: '민주화운동 및 국가폭력피해자 유자녀 : 부모의 민주화운동 및 국가폭력 피해사실 입증자료5.18정신계승 사회공헌 대학생 : 5.18정신계승 사회공헌 활동 내용 및 증빙자료 * 이하 공통서류장학생 지원자 정보장학생 지원서추천서(선택)개인정보동의서주민등록등본 또는 가족관계증명서재학증명서성적증명서사회봉사활동 실적 증빙사료(선택)사회배려자 증빙자료(해당자) * 자세한 사항은 첨부파일 및 홈페이지 참고 바랍니다.'
    },
    {
      Col1: '대산신용호기념사업회',
      Col2: '대산보험장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '사회계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '학기당 6000000원 * 1년 지원 (장학금은 정규학기 동안에만 지원됨)',
      Col12: '국내 정규 대학의 석사과정/ 박사과정/ 석·박사 통합과정 입학예정자 또는 재학생으로 보험학 분야를 연구하거나 보험분야 진로를 희망하는 학생',
      Col13: '해당없음',
      Col14: '2022-01-04~2022-02-04',
      Col15: '1차 서류2차 면접',
      Col16: '3~5명 ',
      Col17: '타 단체 기관으로부터 장학금을 수혜받은 자정규학기 초과자',
      Col18: '해당없음',
      Col19: '지원신청서자기소개서추천서개인정보 수집 이용 동의서대학/ 대학원 전학기 성적증명서연구논문/ 자격증/ 어학 점수 등의 증명서 (해당자)'
    },
    {
      Col1: '재단법인구례장학회',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 B학점(3.0/4.5만점/ 2.7/4.3만점) 이상인 자 ',
      Col10: '보호자의 재산세 건강보험료 납부액이 낮을수록 우선',
      Col11: '2000000원',
      Col12: '만 30세 미만의 재학중인 학생',
      Col13: '지원대상자 본인이나 그 보호자가 신청일 현재 구례군에 계속해서 주민등록을 두고 2년 이상 거주',
      Col14: '2022-08-29~2022-09-16',
      Col15: '성적이 높을수록 우선(배점 600점)보호자의 재산세/ 건강보험료 납부액이 낮을수록 우선(배점 200점) * 동점자 발생시 국가유공자 및 국민기초생활수급자를 우선',
      Col16: '25명',
      Col17: '휴학중인 학생등록금 범위 초과 불가국가 및 지방자치단체 등으로부터 등록금 수업료를 전액 지원받은 대학교의 신입·재학생실 등록금 납부 금액이 최저 지급금액(20만원)보다 적을 경우정규학제 기간을 초과하여 재학 중인 학생중복지원 대상자 * 자세한 사항은 첨부파일 참고',
      Col18: '읍·면장 추천',
      Col19: '인재육성장학금 신청서주민등록등본건강보험료납부확인서대학수능시험성적증명서(신입생·재학생)고등학교 3학년1학기 성적증명서(수능 미 응시자)2022년 2학기 등록금납부영수증재학증명서직전학기 성적증명서신청인 서약서개인정보 수집·이용 및 제공·조회 동의서학생 본인 명의의 통장사본 * 자세한 사항은 첨부파일 참고 '
    },
    {
      Col1: '재단법인구례장학회',
      Col2: '저소득층장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 C학점 이상인 자',
      Col10: '국민기초생활수급자',
      Col11: '2000000원',
      Col12: '만 30세 미만의 재학중인 학생',
      Col13: '지원대상자 본인이나 그 보호자가 신청일 현재 구례군에 계속해서 주민등록을 두고 2년 이상 거주',
      Col14: '2022-08-29~2022-09-16',
      Col15: '성적이 높을수록 우선(배점 300점)보호자의 재산세/ 건강보험료 납부액이 낮을수록 우선(배점 500점)',
      Col16: '2명',
      Col17: '휴학중인 학생등록금 범위 초과 불가국가 및 지방자치단체 등으로부터 등록금 수업료를 전액 지원받은 대학교의 신입·재학생실 등록금 납부 금액이 최저 지급금액(20만원)보다 적을 경우정규학제 기간을 초과하여 재학 중인 학생중복지원 대상자 * 자세한 사항은 첨부파일 참고',
      Col18: '읍·면장 추천',
      Col19: '인재육성장학금 신청서주민등록등본건강보험료납부확인서대학수능시험성적증명서(신입생·재학생)고등학교 3학년1학기 성적증명서(수능 미 응시자)2022년 2학기 등록금납부영수증재학증명서직전학기 성적증명서신청인 서약서개인정보 수집·이용 및 제공·조회 동의서학생 본인 명의의 통장사본 * 자세한 사항은 첨부파일 참고 '
    },
    {
      Col1: '재단법인구례장학회',
      Col2: '체육/기능/예능특기생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '2021년도 하반기 ~ 2022년도 도 단위 대회 이상 수상자로서 체육/기능·예술분야 특기생  * 체육 특기 장학생의 경우 국가대표선수 포함만 30세 미만의 재학중인 학생',
      Col13: '지원대상자 본인이나 그 보호자가 신청일 현재 구례군에 계속해서 주민등록을 두고 2년 이상 거주하는 재학중인 학생',
      Col14: '2022-08-29~2022-09-16',
      Col15: '대회 수상 성적에 의거 평가국민기초수급자/ 관내고 출신 가점 적용',
      Col16: '체육 특기생: 1명기능·예능 특기생: 1명',
      Col17: '휴학중인 학생등록금 범위 초과 불가국가 및 지방자치단체 등으로부터 등록금 수업료를 전액 지원받은 대학교의 신입·재학생실 등록금 납부 금액이 최저 지급금액(20만원)보다 적을 경우정규학제 기간을 초과하여 재학 중인 학생중복지원 대상자 * 자세한 사항은 첨부파일 참고',
      Col18: '읍·면장 추천',
      Col19: '인재육성장학금 신청서주민등록등본2022년 2학기 등록금납부영수증재학증명서신청인서약서개인정보 수집·이용 및 제공·조회 동의서학생 본인명의의 통장사본입상증빙자료(상장 등) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인구례장학회',
      Col2: '다자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '부모 명의 가족관계증명서에 본인을 포함한 형제자매가 3명 이상다자녀 가구의 자녀 중 상위학교 재학생 1명',
      Col13: '지원대상자 본인이나 그 보호자가 신청일 현재 구례군에 계속해서 주민등록을 두고 2년 이상 거주하는 만 30세 미만의 재학중인 학생',
      Col14: '2022-08-29~2022-09-16',
      Col15: '소득 평가 50%/ 자녀수 25%/ 성적평가 25%',
      Col16: '6명',
      Col17: '휴학중인 학생등록금 범위 초과 불가국가 및 지방자치단체 등으로부터 등록금 수업료를 전액 지원받은 대학교의 신입·재학생실 등록금 납부 금액이 최저 지급금액(20만원)보다 적을 경우정규학제 기간을 초과하여 재학 중인 학생중복지원 대상자 * 자세한 사항은 첨부파일 참고',
      Col18: '읍·면장 추천',
      Col19: '인재육성장학금 신청서주민등록등본건강보험료납부확인서대학수능시험성적증명서(신입생·재학생)고등학교 3학년1학기 성적증명서(수능 미 응시자)2022년 2학기 등록금납부영수증재학증명서직전학기 성적증명서신청인 서약서개인정보 수집·이용 및 제공·조회 동의서학생 본인 명의의 통장사본부모명의로 발급한 가족관계증명서(자녀 3명 이상만 해당) * 자세한 사항은 첨부파일 참고 '
    },
    {
      Col1: '재단법인구례장학회',
      Col2: '다문화장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 C학점 이상인 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '「다문화가족지원법」 제2조에 따른 다문화가족의 자녀 * 다문화가족 ',
      Col13: '지원대상자 본인이나 그 보호자가 신청일 현재 구례군에 계속해서 주민등록을 두고 2년 이상 거주',
      Col14: '2022-08-29~2022-09-16',
      Col15: '성적이 높을수록 우선(배점 400점)보호자의 재산세/ 건강보험료 납부액이 낮을수록 우선(배점 400점) * 동점자 발생시 국가유공자 및 국민기초생활수급자를 우선',
      Col16: '1명',
      Col17: '휴학중인 학생등록금 범위 초과 불가국가 및 지방자치단체 등으로부터 등록금 수업료를 전액 지원받은 대학교의 신입·재학생실 등록금 납부 금액이 최저 지급금액(20만원)보다 적을 경우정규학제 기간을 초과하여 재학 중인 학생중복지원 대상자 * 자세한 사항은 첨부파일 참고',
      Col18: '읍·면장 추천',
      Col19: '인재육성장학금 신청서주민등록등본건강보험료납부확인서대학수능시험성적증명서(신입생·재학생)고등학교 3학년1학기 성적증명서(수능 미 응시자)2022년 2학기 등록금납부영수증재학증명서직전학기 성적증명서신청인 서약서개인정보 수집·이용 및 제공·조회 동의서학생 본인 명의의 통장사본 * 자세한 사항은 첨부파일 참고 '
    },
    {
      Col1: '재단법인구례장학회',
      Col2: '자연드림씨앗재단 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 최대지원액 1000000원 * 생활비 명목',
      Col12: '구례군에 거주하는 대학교 재학생으로 성적우수 대학생',
      Col13: '지원대상자 본인이나 그 보호자가 신청일 현재 구례군에 계속해서 주민등록을 두고 2년이상 거주하는 자',
      Col14: '2022-05-09~2022-05-25',
      Col15: '한국사회적경제씨앗재단 장학금 신청자 중 구례군 인재육성장학금 평가기준에 의거 우선순위 추천',
      Col16: '20명',
      Col17: '30세 초과자22년도 상반기 구례군 및 전남 인재육성 장학금 수령자기존 (재)자연드림림씨앗재단 장학금 수령자',
      Col18: '읍·면장 추천',
      Col19: '장학금 신청서주민등록등본 또는 행정정보공동이용사전동의서직전년도 지방세세목별과세증명서21년도 건강보험납부확인서 부·모 각각 1부 대학수학능력시험성적증명서고등학교생활기록부(수능 미응시자)재학증명서 또는 입학증명서직전학기 성적증명서개인정보 수집·이용 및 제공·조회 동의서학생 명의의 통장사본 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '당진화력장학회',
      Col2: '성적장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 평균 B학점 이상인 재학생',
      Col10: '해당없음',
      Col11: 'A학점 이상 각 3000000원B학점 이상 각 2500000원',
      Col12: '성적우수자로 해당 학교장의 추천을 받은 자한국장학재단 국가장학금 Ⅰ유형 지급대상 대학 학생 * 휴학생/ 졸업생 신청 가능',
      Col13: '발전소주변지역(석문면 적지역 및 우정읍 국화도리/ 안산시 풍도동)에 5년 이상 실거주하는 주민 또는 자녀',
      Col14: '2022-09-05~2022-09-23',
      Col15: '직전학기 성적',
      Col16: '해당없음',
      Col17: '「국가공무원 수당 등에 관한 규정」 또는  「지방공무원 수당 등에 관한 규정」 제 11조의 규정에 따라 자녀의 학비보조수당을 지급받고 있는 공무원의 자녀 및 한국동서발전(주) 직원의 자녀한국장학재단 국가장학금 지급제한 대학의 재학생 * 자세한 사항은 기관으로 문의 바랍니다.',
      Col18: '소속대학 학장의 추천을 받은 학생',
      Col19: ' * 자세한 사항은 기관 홈페이지> 공지사항 내 공고문 참조 바랍니다.'
    },
    {
      Col1: '당진화력장학회',
      Col2: '복지장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '신청일 현재 기준 다문화가정/ 다나져가정(3자녀 이상)/ 기초수급자/ 차상위계층/ 장애(1~4등급)학생/ 한부모가정/ 새터민가정/ 기타(B학점 미만 대학생 중 각 마을이장이 가정형편이 어렵다고 인정한 학생) 어느 하나에 해당하는 재학생 중 해당 학교장의 추천을 받은 학생해당연도 대학 등록금을 납부한 대학교 휴학생/ 졸업생 신청 가능',
      Col13: '발전소 주변지역(석문면 전지역 및 우정읍 국화도리/ 안산시 풍도동)에 5년 이상 실거주하는 주민 또는 자녀',
      Col14: '2022-09-05~2022-09-23',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '「국가공무원 수당 등에 관한 규정」 또는 「지방공무원 수당 등에 관한 규정」 제 11조의 규정에 따라 자녀의 학비보조수당을 지급받고 있는 공무원의 자녀 및 한국동서발전(주)의 직원 및 그 자녀는 장학생 선발대상에서 제외',
      Col18: '학교장 추천',
      Col19: ' * 자세한 사항은 홈페이지 공지사항 참고바랍니다.'
    },
    {
      Col1: '청파장학회',
      Col2: '청파장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 이수학점 15학점 이상이고/ 성적이 3.5(4.3만점) 이상TOEIC 850점 이상 또는 IBT TOEFL 94점 이상 (연세대 기관토플 인정)',
      Col10: '해당없음',
      Col11: '해당학기 등록금 전액 (* 청파우수장학금은 200만원)',
      Col12: '연세대학교 미래캠퍼스 20222학기 등록 예정 학생 중 1학년 2학기 부터 4학년 1학기생 까지 지원 가능교환학생으로 외국에서 수확 중인 재학생도 지원 가능청파장학금을 2회 이상 받고 연세대학교 본 대학원에 합격한 첫 학기 대학원생학점 및 외국어 성적 기준(모두 충족해야 함)  ',
      Col13: '해당없음',
      Col14: '2022-07-18~2022-07-31',
      Col15: '서류 및 면접',
      Col16: '청파장학생 5명 이내/ 청파우수장학생 4명 이내',
      Col17: '해당 학기에 학적변동(휴학 및 자퇴) 시 선발 취소 되고 장학금 전액 반환',
      Col18: '학과장 추천서 제출',
      Col19: '장학금지원신청서TOEIC 또는 TOEFL 성적증명서 (제출시점으로부터 2년 이내의 것)교수 추천서경력개발활동기록부 교내용/ 교외용 각 1부 출력본  * 학교 경력개발시스템에 업로드할 수 없는 기타 경력 관련 서류는 별도 제출 ** 자세한 사항은 기관 홈페이지 공고 참조'
    },
    {
      Col1: '재단법인 솔벗',
      Col2: '규장각솔벗 학술연구비지원',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정',
      Col8: '인문계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '연구비 인당 10000000원',
      Col12: '한국학 중 \'어문\'/ \'역사\'/ \'철학\'을 연구하는 자국내 소재 대학교 한국학 분야의 박사학위 과정수료자 또는 박사학위 취득 후 3년이 지나지 않은 연구자연구기간 : 20220901 ~ 20230831(1년)',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2019. 2. 28 이전 박사학위 취득자 제외',
      Col18: '해당없음',
      Col19: ' ※ 홈페이지에서 신청서 다운로드/ 우편접수 원칙지원 신청서연구계획서 (10쪽 내외)'
    },
    {
      Col1: '통영시지속가능발전교육재단',
      Col2: '인재육성장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '예체능계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 10000000원 (연 1회 지급)',
      Col12: ' * 우수장학생예·체·능에 재능있는 대학(원)생으로 문학/ 예술/ 체육 등 특정분야에 재능이 우수하여 전국단위 공인대회 3위 이내 또는 도단위 공인대회 1위 이내에 입상한 사람그 밖에 특별한 사유로 장학금 지급이 불가피하다고 위원회에서 결정한 학생 * 특별장학생 : 우수장학금 기수혜자 중 신청자',
      Col13: '본인이 통영시 관할 학교를 6년 이상 재학하거나 주민등록상 6년 이상 통영시에 주소를 두고 직계존속이 공고일 현재 통영시에 주민등록이 되어있고 10년 이상 주소를 둔 자',
      Col14: '2021-10-05~2021-11-05',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '기수혜자 중 3회 초과 선발된 자',
      Col18: '해당없음',
      Col19: '지원신청서장학금 지급대상 기준 충족 증빙 서류교수추천서자기소개서지역사회 재능기부 동의서 및 근황보고서 제출 동의서실적인정 기간 이내 수상 실적표 및 상장 사본자신의 재능을 나타낼 수 있는 포트폴리오재학증명서개인정보수집활용동의 확인서 * 분야별 실적 인정기간 상이하므로/ 확인 후 제출 요망 ** 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '울릉장학회',
      Col2: '울릉장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학재학생은 최종학년 성적 B+이상입학예정자는 최종학년 성적 평균점수 80점 이상 ',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '대학교(전문대학포함)에 재학중이거나 입학예정인 자로서 부모 또는 본인이 울릉도에 거주하고 있는 자',
      Col13: '부모 또는본인이 울릉도에 거주하고 있는 자',
      Col14: '2022-02-15~2022-02-17',
      Col15: '해당없음',
      Col16: 'OO명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생지원신청서가족관계 증명서재학증명서최종학년 성적증명서  * 자세한 사항은 울릉군청 홈페이지 > 참여광장 > 자유게시판 내 공고문 참조'
    },
    {
      Col1: '무지개장학재단',
      Col2: '무지개장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 중 실납입액(최대 2500000원) * 학교 장학금 및 타 기관 장학금 등 중복지원 가능 (단 본인이 수령하는 장학금을 제외한 학비만 지원)',
      Col12: '장애인학생 및 장애인부모 가정의 자녀 * 대학교 재학생으로 학업과 기술습득에 대한 욕구를 가지고 있으나 경제적 사정으로 어려움에 처한 장애인학생 및 장애인부모의 자녀',
      Col13: '주소지가 전라북도인 자',
      Col14: '2022-07-01~2022-08-04',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '본당신부님이나 시설장의 추천을 받아 신청한다. * 추천인은 전라북도 산하 종교기관장이나 장애인 관련 기관장만 신청 가능하며/ 개인 추천 신청은 받지 않음 ※ 자세한 사항은 첨부파일 참고 혹은 기관 문의',
      Col19: '장학지원사업 신청서추천서 개인정보 수집·이용동의서성적증명서등록금 고지서장애인 증명서수급자증명서가족관계증명서본인명의 통장 사본2022년 1학기 교육비납입증명서2022년 1학기 장학금수혜증명서 * 방문접수 또는 우편접수/ 자세한 사항 첨부파일 확인'
    },
    {
      Col1: '서울법대장학재단',
      Col2: '서울법대장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 반액 지원',
      Col12: '신청년도 서울대학교 법학전문대학원 신입생신청년도 서울대학교 일반대학원(법학) 신입생 및 재학생',
      Col13: '해당없음',
      Col14: '2022-01-10~2022-01-20',
      Col15: '장학생은 재단 이사회에서 직접 심사하여 결정함.심사방법: 서류심사면접 : 서류심사 통과자 개별통보',
      Col16: '장학생 8명',
      Col17: '타 장학금을 받게 된 경우 중복 지급하지 않음.',
      Col18: '해당없음',
      Col19: '장학생 선정 신청서가족관계증명서성적증명서(학사과정)부/모 의료보험 납입확인서 각 1부부/모 근로원천징수서 각 1부부/모 지방소득세납부증명서(또는 과세사실 없음) 각 1부기타 증빙서류 등  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '공간정보산업진흥원',
      Col2: '공간정보장학생(일반장학생)',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/특정대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/사회계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '장학생 : 등록금 전액특성화 대학원 : 학교지원금 300만원  (장학생 1인 1년 지원 기준)',
      Col12: ' * 공간정보 융복합 특성화대학원의 22년도 석·박사 과정 신입생 또는 2학기 입학 희망자',
      Col13: '해당없음',
      Col14: '2022-06-29~2022-07-26',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '이중(중복)지원 제한 : 해당학교의 교내장학금을 제외한 타 장학금 수혜자는 장학생 선발 지원 불가국가/ 지방자치단체 및 공공기관의 운영에 관한 법률상 소속된자 제외',
      Col18: '해당없음',
      Col19: '공문 1부공간정보 장학생 신청서 1부연구계획서 2부(한글 파일 원본 제출)연구계획서의 증빙서류 일체 각 1부특성화대학원 사업책임자 추천서 1부산업체 대표자 추천서 1부(해당자)개인정보동의서 1부전자파일 1매 * 소속(진학 희망) 특성화대학원 학과 사무실로 제출/ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '공간정보산업진흥원',
      Col2: '공간정보장학생(산업체장학생)',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/특정대학',
      Col7: '석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '7000000원 * 등록금 지원 1년 지원기준으로 최대 2년까지 지원',
      Col12: ' * 공간정보 융복합 특성화대학원의 20년도 석·박사 과정 신입생 또는 2학기 입학희망자 중 일반/산업체 장학생 선발산업체장학생 : 근무경력이 1년 이상인 산업체 재직자로서 산업체 대표자의 추천서를 받은 자',
      Col13: '해당없음',
      Col14: '2020-07-15~2020-08-10',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '이중(중복)지원 제한 : 해당학교의 교내장학금을 제외한 타 장학금 수혜자는 장학생 선발 지원 불가국가/ 지방자치단체 및 공공기관의 운영에 관한 법률상 소속된자 제외',
      Col18: '산업체 대표자의 추천서 제출',
      Col19: '공문 1부공간정보 장학생 신청서 1부연구계획서 2부(한글 파일 원본 제출)연구계획서의 증빙서류 일체 각 1부특성화대학원 사업책임자 추천서 1부산업체 대표자 추천서 1부(해당자)개인정보동의서 1부CD 1매(상기 신청서류 일체) * 자세한 사항은 첨부자료 또는 공간정보산업진흥원 홈페이지 게시판 참고* 소속(진학 희망) 특성화대학원 학과사무실로 접수'
    },
    {
      Col1: '재단법인 마포인재육성장학재단',
      Col2: '마포장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '해당없음',
      Col13: '공고일 현재 계속하여 6개월 이상 마포구에 주민등록이 되어있는 자',
      Col14: '2022-04-29~2022-05-09',
      Col15: '성적/ 재산정도/ 마포구 거주기간 별로 점수 부여',
      Col16: '10명',
      Col17: '2022년도 상반기에 국가/ 지방자치단체/ 타 재단/ 학교 등으로부터 수업료/ 장학금 등의 학비지원을 받은 대학생은 신청 불가능선발분야 중 한가지 분야만 신청 가능능1가구당 1명 선발/ 다자녀(3인 이상)인 경우 2자녀',
      Col18: '대학교 총장(학생처장/ 학장)',
      Col19: '장학생 신청 및 추천서개인정보수집·이용·제공·조회동의서주민등록초본(학생본인 초본/ 주소변동내역 포함)가족관계증명서지방세세목별과세증명서(부/모 각 1부)확정일자 받은 임대차계약서 (자가주택이 아닌 경우에 한함)가점 증빙서류(대상자에 한함/가산점내용은 첨부파일 확인 바람) * 접수처 : 장학재단 사무국(마포중앙도서관 4층 소재)'
    },
    {
      Col1: '전남대학교동원장학재단',
      Col2: '섬김의 리더십 동원장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학5학기/대학6학기',
      Col8: '사회계열/인문계열',
      Col9: '직전학기(복학생은 휴학 직전학기)에 12학점 이상을 취득하고 그 성적 평균 평점이 3.5(실점 87.5점) 이상인 자',
      Col10: '해당없음',
      Col11: '학기당 3000000원 * 생활비 지원 자격유지 시 졸업 시 까지 지원',
      Col12: '전남대학교 3학년 1학기 학부 재학생품행이 단정하고 도전적이며 창조적인 자국가 및 사회 발전에 공헌할 수 있는 자 * 교내 장학금 수혜자도 지원 가능 (단/ 이 재단의 장학생으로 선발 되면 기 지급받은  교내장학금은 반납)',
      Col13: '해당없음',
      Col14: '2022-04-26~2022-05-04',
      Col15: '1차 서류심사 (교과성적 40 교내외 봉사활동 60)2차 면접',
      Col16: '3명',
      Col17: '징계를 받은 자 또는 징계 의결 중인 3.50(실점 87.5점) 미만인 자장학생으로서의 품위를 손상한 자(장학생선발위원회 심의)휴학자 및 6년제 특수대학 제외교내 및 타 장학재단 생활비 수혜자 제외 (단/ 1백만원 이하 수헤자는 가능)',
      Col18: '해당없음',
      Col19: ' * 교내장학금으로/ 학생이 소정의 양식을 갖추어 해당 단과대학에 신청. 자세한 사항은 첨부파일 참조장학생 지원서추천서 1부성적증명서 1부자기계발활동기록부(봉사활동 및 입상경력 등은 자기계발활동기록부 등재 자료만 인정)'
    },
    {
      Col1: '충남대학교동원장학회',
      Col2: '동원장학회장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '특정학과',
      Col9: '직전학기 성적평균 C이상직전학기 15학점이상 취득한 자국외대학 수학자 및 졸업학기 신청자의 경우 12학점 이상',
      Col10: '해당없음',
      Col11: '5000000원 / 년',
      Col12: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.사회과학대학 재학생가정형편이 극히 곤란하여 학비조달이 어려운 학생직전학기 성적평균 C이상',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '5명',
      Col17: '퇴학/ 휴학/ 징계처분/ 수업 및 등록연한 초과자/ 등록유효자교내장학금 중복 수혜자(등록금 범위 내에서 국가장학금과 중복수혜 가능)',
      Col18: '해당없음',
      Col19: '장학생지원서 1부추천서 1부  '
    },
    {
      Col1: '가톨릭대학교성심교정동문회',
      Col2: '학부장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(학부생) 전체학기 평점 3.3 이상인 자 (대학원생) 전체학기 평점 4.0 이상인 자',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: ' * 가톨릭대학교 성심교정 재학생(학부생)3학기 이수자 이상 (대학원생) 2학기 이수자 이상 학교 활동에 적극적인 자 동문회비를 납부한 자',
      Col13: '해당없음',
      Col14: '2021-07-21~2021-07-30',
      Col15: '해당없음',
      Col16: '학부생 8명대학원생 1명',
      Col17: '동문회장학금(100만원)과 타장학금의 총합이 수업료를 초과할 경우동문회장학생 선발에서 제외휴학생/ 휴학예정자/ 초과학기등록자 신청불가',
      Col18: '해당없음',
      Col19: '장학금 신청서전체학기 성적증명서부모의 최근 1년간 재산세 납세증명서 또는 지방세 세목별 과세증명서주민등록등본 또는 가족관계증명서A4 1매이상 분량의 에세이 본인 명의 통장 사본 * 코로나19의 감염 예방과 확산 방지를 위해 우편 접수 권장 * 자세한사항은 가톨릭대학교 게시판 참고'
    },
    {
      Col1: '충남대학교총동창회장학재단',
      Col2: '충남대학교총동창회장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학기 15학점이상 이수자 성적 B0이상',
      Col10: '해당없음',
      Col11: '최대 1000000원 (해당학기) * 등록금 명목의 장학금 지원이 명칙이나 신청 현황 및 내부 심사에 따라 선발 인원 중 약간 명 선정하여 생활비 지급할 수 있음',
      Col12: ' * 공고일 현재 충남대학교 재학생인자로서 대학발전을 위해 봉사정신이 투철하다고 인정되거나 경제적으로 극히 어려운 환경 속에서도 불우한 생활을 극복하며 성실히 면학에 임하는 자2022학년도 2학기 등록예정자',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-08-03',
      Col15: '서류심사를 통해 선발',
      Col16: '15명 내외',
      Col17: ' 타기관의 등록금 전액 장학금을 지원 받는 자는 제외',
      Col18: '해당 학과 교수의 추천',
      Col19: '장학금 지원 신청서장학생 추천서재학증명서성적증명서주민등록등본건강보험료 납부확인서장학금 수령할 본인 통장 사본충남대학교 총동창회 입회비 납부 영수증 사본 * 접수처 : 재단법인 충남대학교총동창회장학재단 사무처/ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '금오공과대학교총동창회장학회',
      Col2: '금오공과대학교총동창회장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정형편이 어려운 자',
      Col11: '해당없음',
      Col12: '경제사정이 어려운 자동창회 및 학생회 활동에 공로가 많은 자기타 장학재단에서 지급대상이 된다고 인정한 자',
      Col13: '해당없음',
      Col14: '2021-10-20~2021-10-29',
      Col15: '해당없음',
      Col16: '4명',
      Col17: '모교 장학금 수령자 및 직전학기 본회 장학금 수령자',
      Col18: '해당없음',
      Col19: '장학금 신청서재학증명서성적증명서추천서본인소견서등본'
    },
    {
      Col1: '심헌문화재단',
      Col2: '기초생활수급장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '추천기관 관내 고등학생으로서 내신 성적 학년 석차 상위 20% 이내인 학생 ',
      Col10: '소년 소녀가장 조부모가정 한부모 가정등 가정형편이 어려운 학생',
      Col11: '1인당 년120만원 지급 (매월 10만원 분할 지급)',
      Col12: '타 기관의 장학금 수혜(예정)대상이 아닌 학생 품행이 단정하여 지역과 국가 발전에 일익을 담당 할 수 있다고 인정되는 학생 우리 재단의 기존 기초생활수급장학생이 아닌 학생생',
      Col13: '광주/ 전남 지역 거주자',
      Col14: '2022-01-10~2022-01-28',
      Col15: '해당없음',
      Col16: '광주광역시 북구청 : 신규 선발 5명전남 보성군청 : 신규 선발 5명 ',
      Col17: '심헌문화재단의 기존 기초생활수급 장학생',
      Col18: '추천기관장의 추천(공문으로 추천)에 의해 우리 재단 장학생 선발위원회에서 심사 ',
      Col19: '장학금 신청서(재단 홈페이지에서 온라인 신청 및 출력 후 제출) 1부 학교생활기록부 원본 1부재학증명서/ 성적증명서국민기초생활보장수급자증명서 1부자기소개서 1부(A4 2장 내외/ 가정환경/ 장래희망 및 포부 등 내용 포함)'
    },
    {
      Col1: '심헌문화재단',
      Col2: '일반장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학교 내신성적 학년 석차 상위 5% 이내인 학생',
      Col10: '가정 형편이 어려운 학생',
      Col11: '해당없음',
      Col12: '품행이 단정하여 지역과 국가 발전에 일익을 담당 할 수 있다고 인정되는 학생1가구 2자녀 이상일 경우 1자녀에 한함(재단 장학심사위원회에서 결정)',
      Col13: '광주/ 전남 지역 거주자',
      Col14: '2022-01-10~2022-01-28',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '한국장학재단 등 타 기관 및 심헌문화재단의 장학금 수혜(예정)대상 학생',
      Col18: '추천기관장의 추천서(공문으로 추천)에 의해 재단 장학심사위원회에서 심사 ',
      Col19: '장학금 신청서(재단 홈페이지 온라인 신청서 작성 후 추천기관 담당자에게 제출)장학생 소감문재학증명서 원본학자금 지급증명서 원본(한국장학재단 홈페이지에서 발급) * 자세한 사항은 홈페이지 공지사항 참고'
    },
    {
      Col1: '우송장학회',
      Col2: '우송장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 1/ 2학기 15학점 이상 취득하고/ F학점 과목이 없는 자 ※ 1학년의 경우/ 15학점 이상 신청자',
      Col10: '가정 형편이 어려운 학생',
      Col11: '글로벌 해외연수 및 국내연수 지원',
      Col12: '우송대학교 1~3학년 재학생 중 성적기준을 충족하는 자성적우수자(평균 4.00이상)대외 학술활동 입상자외국어 성적 우수자 * 자세한 기준 홈페이지 참고',
      Col13: '해당없음',
      Col14: '2022-03-29~2022-04-18',
      Col15: '1차 서류심사2차 면접심사 및 질의응답',
      Col16: '0명',
      Col17: ' * 교내 장학금이므로/ 자세한 사항은 장학팀으로 문의 ',
      Col18: '해당없음',
      Col19: '우송장학생 신청서/ 자기소개서/ 에세이성적 증명서대외 학술활동 입상자 (대회요강/ 상장 사본)공인어학시험 성적표 사본 (외국어성적 우수자) * 자세한 사항은 교내 홈페이지 > 공지사항 참조'
    },
    {
      Col1: '태경장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '평균학점 3.5 이상',
      Col10: '가정 형편이 어려운 자는 우선 선발',
      Col11: '해당없음',
      Col12: '태경장학재단의 비전에 공감하며/ 차세대 크리스찬 리더가 되기를 희망하는자교역자 및 선교사 자녀',
      Col13: '해당없음',
      Col14: '2021-07-23',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 신청서자기소개서(기존장학생의 경우소감문)성적증명서(전 1년)주민등록등본교수추천서부모님 각각의 세목별 납부(과세)증명서'
    },
    {
      Col1: '서울대학교',
      Col2: '선한인재장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평균평점 2.4 이상 (재학생)',
      Col10: '학자금 지원구간 2구간 이하인 학생',
      Col11: '월 300000원 * 자세한 사항은 홈페이지 참고',
      Col12: '2022학년도 2학기 서울대학교 재학생·신입생으로 국가장학금(유형 Ⅰ/Ⅱ)를 신청하였거나 신청할 예정인 학생',
      Col13: '해당없음',
      Col14: '기관 확인 필요',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '수업연한초과자/ 휴학자/ 학사경고·유급·징계처분을 받았거나 기타 부적격 사유가 인정되는 경우',
      Col18: '성적기준 미달 시 지도교수·부학장의 추천서 제출',
      Col19: '마이스누(my.snu.ac.kr) 접속 후 신청서 작성(학사정보 → 장학 → 신청/현황 → 장학신청 목록에서 신청'
    },
    {
      Col1: '서울대학교',
      Col2: '인문대교수장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '인문계열',
      Col9: '졸업을 위해 이수해야할 학점이 9학점 이상 남은 학생 * 신청학기 최소 수강신청학점 : 9학점',
      Col10: '해당없음',
      Col11: '200000원 ~ 400000원/ 월 지급 ※ 생활비 성격',
      Col12: '신청학기 등록한 서울대학교 인문대학 학부생 중 가정 형편이 어려워 생활비 또는 학업보조비가 필요하며 졸업을 위해 이수해야할 학점이 9학점 이상 남은 학생규정학기 초과자도 지원 가능',
      Col13: '해당없음',
      Col14: '2022-04-20~2022-04-27',
      Col15: '추천서 등 서류 검토 및 학생 개별면담 진행 후 선발',
      Col16: '0명',
      Col17: '장학금 수혜기간 중 휴학 시 지원이 중단 됨타 장학금과 중복수혜 가능',
      Col18: '지도교수 추천 필요',
      Col19: '신청서추천서가계소득확인자료가족관계증명서재학증명서학생계좌 사본개인정보 수집·이용 및 제공 동의서 * 자세한 사항은 서울대학교 인문대학 홈페이지 내 공고문 참조'
    },
    {
      Col1: '서울대학교',
      Col2: '나음장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2022학년도 2학기 등록금 전액',
      Col12: '활동적이고 창의적인 사고를 가진 서울대학교 사회학과 학생',
      Col13: '해당없음',
      Col14: '2022-08-04~2022-08-26',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '나음장학금 지원 신청서통장사본 1부 * 제출서류를 구비하여 조교실 이메일로 제출 '
    },
    {
      Col1: '서울대학교',
      Col2: '덕송장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학신입생',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '500000원 * 생활비 지원 / 4개 학기 계속 지원',
      Col12: '가정형편이 어려운 학생서울대 경영대학 학부생( 1~2학년 우선 선발 )',
      Col13: '해당없음',
      Col14: '2021-09-15~2021-09-24',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '학사경고자',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 장학선정신청서성적증명서(신입생 제외)신청학기 소득분위 확인서본인 명의의 통장 사본 개인정보 수집·이용 및 제공 동의서'
    },
    {
      Col1: '재단법인 서울대학교전자전기정보장학재단',
      Col2: '권오현동문학업장려금장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/특정학과',
      Col9: '해당없음',
      Col10: '국가장학금 0~8구간 해당자자',
      Col11: '학업장려금 학기당 2500000원(* 교내외 등록금 장학금과 중복수혜 가능)',
      Col12: '서울대학교 전기정보공학부 2~4학년 중 2021 2학기 등록예정자 ',
      Col13: '해당없음',
      Col14: '2021-07-29~2021-08-02',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '규정학기 초과자외국인',
      Col18: '지도교수의 추천',
      Col19: '장학생 지원서자기소개서건강보험료 납부확인서본인/부/모 각각의 지방세 세목별 과세 증명서 개인정보수집이용제공동의서 '
    },
    {
      Col1: '서울대학교',
      Col2: '법정장학금(국가유공자/북한이탈주민)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '2022학년도 2학기 등록 대상자 중 교내장학금을 받고자 하는 학부생법정장학금 대상자(국가유공자.북한이탈주민)유학생 장학금을 받고자 하는 학부생(글로벌인재특별전형으로 입학한 외국 국적자) ',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '마이스누 학사정보장학신청/현황장학신청 목록에서 신청',
      Col16: '해당없음',
      Col17: '장학생 신청을 하지 않은 경우 선정 대상에서 제외됨신청내용이 사실과 다른 것으로 확인되는 경우 선정 취소 등의 불이익이 있을 수 있음 장학생이 해당학기 등록을 완료하지 않는 경우 선정이 취소됨장학금은 등록금을 초과하여 지원받을 수 없음규정학기 초과자가 지정된 기간내 수강신청을 하지 않는 경우 선정 대상에서 제외 될 ',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '서울대학교',
      Col2: '해외수학장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' *  최소 이수학점·과목수 준수ECTS 적용 유럽권 대학 수학자 : 학기당 최소 2과목 & 6ECTS 이상그 외 대학 : 학기당 최소 6학점 이상 ',
      Col10: '국가장학금 가계소득 8분위 이하인 학부생 ( * 소득분위 6구간 이하 전원 선발 / 7~8분위 예산범위 내 선발)',
      Col11: ' ※ 소득분위 및 수학국가에 따라 장학금액이 상이하므로 자세한 사항은 첨부파일 참조 ',
      Col12: '20222학기 국제협력본부 파견교환학생 또는 소속대학 자체 교환학생 프로그램 선발자20221학기 국가장학금을 신청하여 소득분위 확인이 가능한 학생',
      Col13: '해당없음',
      Col14: '2022-06-20~2022-06-27',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '마이스누 학사정보 → 장학 → 신청/현황 → 장학신청 목록에서 신청 * 교내장학금으로/ 자세한 사항은 첨부파일 및 서울대학교 장학게시판  참고'
    },
    {
      Col1: '서울대학교',
      Col2: '교내장학금(일반장학금)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 모든 장학금의 수혜와 학자금 대출은 당해 학기 등록금을 초과할 수 없음',
      Col12: '교내/외 장학금을 받고자 하는 학사과정 등록 대상자   (유학생/ 미등록 복학 예정자 포함)국가장학금 신청 필수',
      Col13: '해당없음',
      Col14: '2020-05-25~2020-06-12',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '규정학기 초과자가 수강신청기간 내 수강신청을 하지 않는 경우 장학금 선발에서 제외됨 (등록금액이 확정되지 않으므로 장학금액 산출도 불가함)',
      Col18: '해당없음',
      Col19: ' * 신청방법  마이스누 접속 (http://my.snu.ac.kr) 후 신청서 작성 (학사정보장학신청/현황장학신청신청가능 목록에서 선택)장학선정신청서'
    },
    {
      Col1: '서울대학교',
      Col2: '교내장학금(유학생 맞춤형 장학금)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '(소득기준) 2021년도 연간 소득이 5000만원 이하인 외국국적 학생',
      Col11: ' * 모든 장학금의 수혜와 학자금 대출은 당해 학기 등록금을 초과할 수 없음',
      Col12: '교내/외 장학금을 받고자 하는 학사과정 등록 대상자   (유학생/ 미등록 복학 예정자 포함) 중 소득기준을 충족하는 자 또는 UN참전용사 손·자녀 ',
      Col13: '해당없음',
      Col14: '2022-05-30~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '규정학기 초과자가 수강신청기간 내 수강신청을 하지 않는 경우 장학금 선발에서 제외됨 (등록금액이 확정되지 않으므로 장학금액 산출도 불가함)',
      Col18: '해당없음',
      Col19: '장학선정신청서 가족관계증명서소득증빙 서류(소득기준 해당자)병적증명서 원본제출 (최초1회/ UN참전용사 손자녀 해당자)'
    },
    {
      Col1: '서울대학교',
      Col2: '교내장학금(국가유공자 장학금)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 모든 장학금의 수혜와 학자금 대출은 당해 학기 등록금을 초과할 수 없음',
      Col12: '20222학기 등록 대상자중 교내장학금을 받고자 하는 학부생법정장학금 대상자 중 국가유공자',
      Col13: '해당없음',
      Col14: '2022-05-30~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '규정학기 초과자가 수강신청기간 내 수강신청을 하지 않는 경우 장학금 선발에서 제외됨 (등록금액이 확정되지 않으므로 장학금액 산출도 불가함)',
      Col18: '해당없음',
      Col19: '장학 선정 신청서 (국가독립유공 대상자 항목 체크)관할 보훈지청 발급 대학수업료등면제자 증명서(최초신청자) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '서울대학교',
      Col2: '교내장학금(북한이탈주민)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 모든 장학금의 수혜와 학자금 대출은 당해 학기 등록금을 초과할 수 없음',
      Col12: '20222학기 등록 대상자 중 교내장학금을 받고자 하는 학부생법정장학금 대상자(북한이탈주민)',
      Col13: '해당없음',
      Col14: '2022-05-30~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '규정학기 초과자가 수강신청기간 내 수강신청을 하지 않는 경우 장학금 선발에서 제외됨 (등록금액이 확정되지 않으므로 장학금액 산출도 불가함)',
      Col18: '해당없음',
      Col19: ' * 신청방법  마이스누 접속 (http://my.snu.ac.kr) 후 신청서 작성 (학사정보장학신청/현황장학신청신청가능 목록에서 선택)장학선정신청서 (기타사항의 “북한이탈주민대상자” 항목 체크)최초 신청자는 북한이탈주민등록확인서/ 교육지원대상자 증명서 제출 (시·군·구청 또는 주민센터 발급)'
    },
    {
      Col1: '서울대학교',
      Col2: '교내장학금(대학원과정)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '2022학년도 2학기 장학금을 받고자 하는 대학원 등록대상자(신입생/유학생/복학예정자 포함)대학원 후기신입생(예정자)은 합격자 발표 후 대학(학과)사무실로 문의',
      Col13: '해당없음',
      Col14: '2022-05-30~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '규정학기 초과자가 수강신청기간 내 수강신청을 하지 않는 경우 장학금 선발에서 제외됨 (등록금액이 확정되지 않으므로 장학금액 산출도 불가함)  * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: ' * 신청방법  마이스누 접속 (http://my.snu.ac.kr) 후 신청서 작성 (학사정보 → 장학→ 신청/현황 → 장학신청 → 신청가능 목록에서 선택)  * 소속대학/학과별로 추가 서류제출 등의 절차가 필요할 수 있으므로 기관별 공지 확인 '
    },
    {
      Col1: '서울대학교',
      Col2: '명도장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '해당없음',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '4000000원 (1년 학기 분할) * 기타 장학금과 중복 가능(생활비성 장학)',
      Col12: '서울대학교 국사학과 학부생 * 기존 장학금 신청서 제출자 우대',
      Col13: '해당없음',
      Col14: '2022-08-22~2022-08-31',
      Col15: '소득분위/ 성적/ 학과기여도 등 종합적 고려',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 선정신청서 양식 및 소득분위 증명서 * 자세한 사항은 학과 홈페이지 참고'
    },
    {
      Col1: '서울대학교',
      Col2: '억식장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '특정대학',
      Col7: '해당없음',
      Col8: '특정학과',
      Col9: '직전학기 성적 평점평균 2.7 이상',
      Col10: '저소득학생',
      Col11: '등록금 전액 (정규학기 8학기 이내 계속 지원) * 국가장학금 수혜자는 학업장려비로 전환하여 지급',
      Col12: '서울대학교 경제학부 1학년가정형편이 어려워 학업에 몰두하기 어려운 학생',
      Col13: '해당없음',
      Col14: '2022-07-12~2022-07-28',
      Col15: '해당없음',
      Col16: '2명 (남1/ 여1)',
      Col17: '성적 미달 시 사유서 및 지도교수 추천서로 1회 유예 가능',
      Col18: '해당없음',
      Col19: '장학신청서성적증명서소득증빙서류 * 자세한 사항은 학과 홈페이지 참고'
    },
    {
      Col1: '서울대학교',
      Col2: '이병서장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '석사2학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: '직전학기 성적 3.3이상/ 이수학점 6학점 이상 (신입생은 성적요건 제외) ',
      Col10: '가정형편 어려운 학생',
      Col11: '등록금 전액(신입생은 입학금 포함) * 학적변동(휴학포함) 및 결격사유(자격요건 미달 등) 미발생시 졸업시까지 지원 가능',
      Col12: '20222학기 서울대학교 경여대학 석사과정 재학예정인 자/ 신입생포함',
      Col13: '해당없음',
      Col14: '2022-08-27~2022-09-02',
      Col15: '해당없음',
      Col16: '1명 ',
      Col17: '교내 맞춤형/ TA장학금 등 등록금 명목의 교내외 타 장학 중복수혜 불가',
      Col18: '해당없음',
      Col19: '장학선정신청서성적증명서본인의 가족관계증명서2022년 1월~현재까지의 부/모 각각 건강보험료 납부확인서 각1부본인 명의의 통장 사본개인정보 수집.이용 및 제공 동의서 * 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '생명보험협회',
      Col2: '국내박사과정 생명보험사회공헌',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 : 납입고지서에 따른 실비연구활동비 : 월 300000원(연구지원 및 생활비) * 연구등록학기 기간 중에는 논문연구지원금 월 100000원 추가 지급',
      Col12: '보험관련 학문을 전공하고자 하는 국내대학원의 박사과정 재학생 및 입학확적자보험전공자(\'보험\'명칭 학과 및 전공)/ 생명보험 관련 논문 발표자/ 보험계리사 등 자격소지자 우대',
      Col13: '해당없음',
      Col14: '2022-01-24~2022-02-10',
      Col15: '  선발공고지원서 접수서류심사 (2월 중)면접 심사(2월 중)최종선발 (2월 말말)',
      Col16: '2명 예정',
      Col17: '교내/외 2년이상 전액장학 해당자타 장학금과 이중수혜하는 자 ',
      Col18: '지도교수',
      Col19: '지원서재학증명서성적증명서자격증 사본논문 등 연구활동자료 1부개인정보 수집 이용 동의서재학생: 추천서(박사과정 지도교수)입학확정자: 추천서(석사과정 지도교수)'
    },
    {
      Col1: '생명보험협회',
      Col2: '해외박사과정 생명보험사회공헌',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '해외대학',
      Col7: '박사과정',
      Col8: '사회계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '연간 최대 70000000원 (등록금 실비전액 + 월 USD2000) * 매학기 심사를 통해 지원여부 결정 * 장학금 지급기간: 최대 4년',
      Col12: '대한민국 국적자해외 주요대학의 보험전공 박사과정 재학생 및 2022년도 하반기 입학확정자/ 2023년도 입학예정자학부 및 석사과정의 성적이 우수한 자생명보험 관련 논문 발표자/ 보험계리사 자격 소지자 등 우대',
      Col13: '해당없음',
      Col14: '2022-03-24~2022-04-27',
      Col15: '해당없음',
      Col16: '2명 이내내',
      Col17: '타 장학금 수령자 신청불가',
      Col18: '재학생 : 박사과정 지도교수의 추천입학확정자/예정자 : 석사과정 지도교수의 추천',
      Col19: '지원서성적증명서 (학부/석사과정)재학증명서 (혹은 졸업증명서)자격증 사본논문 등 연구활동자료개인정보 수집 이용 동의서 * 재학생 : 박사과정 지도교수의 추천서 * 입학확정자/예정자 : 석사과정 지도교수의 추천서'
    },
    {
      Col1: '월악장학문화재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평균성적 3.5이상인 자',
      Col10: '최근학기 한국장학재단 학자금지원구간 5~8구간 이내',
      Col11: '학기당 수업료 1000000원 (1년 지원)',
      Col12: '2022학년도 2학기/ 2023학년도 1학기 정규학기 재학 예정자 ',
      Col13: '해당없음',
      Col14: '2022-08-09~2022-08-16',
      Col15: '재단 심사위원단 서류심사 결과 총평량평균/ 총이수학점/ 직전학기평량평균/ 직전학기 이수학점 높은순으로 선발',
      Col16: 'O명 * 학교 추천 장학금으로/ 각 학교마다 배정인원이 상이할 수 있음',
      Col17: '타 외부재단 장학금 수혜자',
      Col18: '해당없음',
      Col19: '장학생지원서(재단양식)1부재학증명서 1부성적증명서 1부자기소개서 1부가족관계증명서 1부개인정보제공동의서 1부 '
    },
    {
      Col1: 'KMA회남재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(재학생) 지난 학기 성적 B+ 이상/ 12학점 이상 이수',
      Col10: '한 부모가정 조손(祖孫)가정 소년소녀가정 및 국민기초생활보호대상자 혹은 차상위계층 해당자',
      Col11: '매 학기당 200만원씩 연간 400만원의 장학금을 졸업 때까지 지원 ( * 타 장학금과 중복수혜 가능한 학기에 한하여 졸업 유예 학기도 장학금 지원)',
      Col12: '대학교 입학예정자 및 재학생으로서 생활 및 학업환경이 어려운 저소득층(자녀) 중/ 성적이 우수하고 인성과 품성이 반듯하여 장래성이 큰 학생2022학년도 입학 예정자 및 재학생생',
      Col13: '해당없음',
      Col14: '2022-01-21~2022-02-04',
      Col15: '해당없음',
      Col16: '5명 내외 ',
      Col17: ' * 해당 기관으로 문의',
      Col18: '학교장 또는 기관장의 추천서 제출',
      Col19: '장학생 추천서본인 소개서 2022년도 입학예정자 (생활기록부/ 대학수학능력시험성적표)2022년도 현재 재학생(전체학년 성적이 표기된 최근 성적표)소득관련 증빙 서류가족관계 증명원원 * 재단이 선정한 학교에서 학생을 추천하는 방식이므로/ 자세한 사항은 소속 학과 또는 소속 학교 장학부서로 문의'
    },
    {
      Col1: '부영주택',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적이 평균 2.4 이상인 자 ',
      Col10: '어려운 저소득층',
      Col11: '등록금 범위 내 ',
      Col12: '능주고등학교 출신자20221학기 재학예정생인성과 품성이 반듯하여 장래성이 큰 학생',
      Col13: '능주고등학교 출신자',
      Col14: '2022-02-10~2022-02-20',
      Col15: '해당없음',
      Col16: '0명',
      Col17: '초과학기자 제외',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수장학생 신청서 1부자기소개서 1부 성적증명서 1부감사편지 1부(자유양식)'
    },
    {
      Col1: '유정장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열',
      Col9: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수 성적우수(평점 3.5이상)',
      Col10: '가정 형편이 어려운 학생(소득분위 증빙)',
      Col11: '2022년도 등록금 전액',
      Col12: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수 전국 각처의 유정장학회 지정대학교 재학생이공계 한국학생2022년도 1학기 포함 잔여 정규학기가 2학기 이상인 학생 ',
      Col13: '해당없음',
      Col14: '2022-01-26~2022-02-03',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '  * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수 국비장학금/ 타 장학회 및 기업체에서 장학금 지원을 받은자장학생 추천서 및 관련 증빙자료를 허위로 작성하여 제출한 경우휴학/ 전학/ 퇴학/ 질병 등의 이유로 학업을 계속할 수 없게 될 경우기타 장학금 지급이 부적절하다고 판단될 경우',
      Col18: ' * 학교 추천 방식으로/ 각 학교 장학부서 문의 필수담당교수의 추천',
      Col19: '신청서/ 추천서/ 자기소개서성적증명서학생 본인 명의의 가족관계증명서 또는 주민등록등본부모의 2021년 건강보험료납부확인서 및 건강보험증 사본부모의 2020 소득금액증명원부모의 2021년 납세증명서기초수급자확인서(해당자) * 자세한 학교 홈페이지 장학 공지 참고 필수 * 각 대학교 장학지원팀을 통하여 접수'
    },
    {
      Col1: '이한열기념사업회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '전국 대학 전문대/ 4년제 대학(정규 및 비정규) 재학생 우리 사회의 민주화를 위해 기여한 자의 가족사회적 약자이한열 정신을 이어받아 활동하는 자사회적 경제에 대한 구상이 있는 자',
      Col13: '해당없음',
      Col14: '2022-07-26~2022-08-04',
      Col15: '1차 서류심사2차 면접심사',
      Col16: '5명 내외',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 온라인 및 우편/직접 접수 모두 완료해야 접수 처리 ** 자세한 사항은 첨부파일 및 홈페이지 내 공고 참조신청서와 추천서재학증명서 1통(서류심사 합격자에 한함/ 면접시 제출)'
    },
    {
      Col1: '인슐레이션코리아드림재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 우수한 자 ',
      Col10: '저소득층 자녀',
      Col11: '1인당 1000000원',
      Col12: '한국에 거주하고 있는 학생대학생 또는 대학원생(박사과정 제외)학업성적이 우수한자 또는 저소득층 자녀한국의 대학에서 공부하고 있는 일본/중국/미국/영국/태국/말레이시아/이탈리아의 학생 (인슐레이션코리아와 파트너쉽을 맺고 있는 회사의 해당국가입니다)',
      Col13: '해당없음',
      Col14: '2021-11-02~2021-11-30',
      Col15: '해당없음',
      Col16: '30명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '자기소개서 (본인/ 가족사항/ 수혜사유에 대한 자세한 사항)추천서(대사관 대사/ 교수/ 교사/ 사회단체장/ 봉사기관단체장 등 또는 기타 추천자격자)성적증명서입학허가서 사본(2020 대학진학예정자)'
    },
    {
      Col1: '선현재단',
      Col2: '선현장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '예체능계열/특정학과',
      Col9: '직전학기 평균 성적이 3.0이상(4.5만점기준) 재학생',
      Col10: '경제적 여건이 어려운 학생',
      Col11: '학부생 1500000원대학원생 2000000원 ( * 고지된 등록금 범위내)',
      Col12: '국내 대학 무용/ 음악/ 연극/ 공연예술 등의 문화예술 전공자인 재학생',
      Col13: '해당없음',
      Col14: '2022-07-06~2022-07-18',
      Col15: '해당없음',
      Col16: '학교별 1~3명',
      Col17: '회화/ 미술/ 영화 등 전공자는 선발 제외',
      Col18: '교수 추천서 제출',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수(이메일접수)신청서 및 자기소개서가족관계증명서부모(보호자)의 2021년도 건강보험납입증명서 (부/모 모두)직전학기 포함 성적증명서교수 추천서기타 증빙서류(해당자) : 기초생활수급자 증명서/ 차상위계층증명서/ 장애인 증명서 등'
    },
    {
      Col1: '재일한국인본국투자협회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '경제적인 이유로 수학 또는 학교생활이 곤란한 자',
      Col11: '협회의 규정에 의해 결정',
      Col12: '대한민국 국적인 재일한국인 또는 그 자녀대한민국 소재의 4년재 대학생 또는 대학원생 학업성적이 양호하고 품행이 단정하며 당 협회 장학생  활동에 적극적으로 참여 가능한 자',
      Col13: '해당없음',
      Col14: '2022-01-03~2022-02-04',
      Col15: '1차 : 서류심사2차 : 면접 * 소득/ 학업성적/ 품행 등 모든 부분을 종합적으로 평가하여 선발',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '학교장/지도교수/담임교사(입학예정자)',
      Col19: '장학생 추천서본인소개서/ 장학생추천서성적증명서소득관련 증빙서류 기타 관련서류재학증명서가족관계증명서(일본인의 경우 주민표)학교생활기록부 사본(입학생)대학수학능력시험성적표(입학생/ 재외국민전형으로 입학할시 학교생활기록부로 대체)합격증명서(입학생)'
    },
    {
      Col1: '성균관대학교',
      Col2: '성균가족장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학부 : 직전학기 학업성적이 12학점(최종학기 직전학기 9학점) [2004 이전 학번의 경우 15학점(최종학기 직전학기 12학점)] 이상이수하고/  평균평점이 3.0이상대학원 : 직전학기 평점평균이 3.0이상신·편입생은 성적기준 제외',
      Col10: '해당없음',
      Col11: ' * 2013 이전 기존 대상자 : 등록금의 35% 수업연한동안 (입학금 제외) * 2014 이후 신규 대상자 : 1000000원 (첫 학기에 한해 1회만 지급)',
      Col12: ' * 형제자매 : 형제자매가 동시에 대학(원)에 재학 중인 경우 * 직계3대 : 직계 3대에 걸쳐 대학(원)에 신입학 또는 재학 중인 학생 * 직계2대 : 직계 2대가 동시에 본교에 재학 * 부모 모두 성대 : 부모 모두 본교 학부를 졸업한 동문의 자녀가 대학(원)에 입학하는 경우 * 부부동시재학 ※ 자세한 사항은 홈페이지 공지사항 참조',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '연구등록생 및 수료생의 경우 해당되지 않음',
      Col18: '해당없음',
      Col19: '성균가족장학금 신청서가족임을 증명할 수 있는 서류(가족관계증명서)개인정보 제공 및 이용 동의서 * 양식 다운로드는 교내 홈페이지 > 공지사항 참조'
    },
    {
      Col1: '성균관대학교',
      Col2: '공로(고시)장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 14년도 이후 1차 합격자: 직전학기 12학점 이상 이수 (7학기 9학점)/ 평점2.5  * 16년도 이후 1차 합격자: 직전학기 12학점 이상 이수 (7학기 9학점)/ 평점3.5',
      Col10: '해당없음',
      Col11: '행정고등고시 기술고등고시 입법고등고시 외교관후보자시험 합격자는 등록금 50% 1회 지급공인회계사 변리사 최종 합격자의 경우 등록금 50% 1회 지급',
      Col12: '행정고등고시/ 기술고등고시/ 입법고등고시/ 외교관후보자시험1차 합격자 및 공인회계사/ 변리사 최종합격자',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '초과학기자',
      Col18: '해당없음',
      Col19: '공로 고시 장학금 신청서본인의 1차 합격을 증빙할 수 있는 서류개인정보 수집 및 이용 동의서 * 자세한 사항은 학교 홈페이지 공고 참고'
    },
    {
      Col1: '성균관대학교',
      Col2: '은행나무장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 계속 수혜 기준  가. 2019년 2학기 이전 입학자 대상장애등급 1/2등급 : 직전학기 학업성적이 12학점(7학기 9학점)이상 이수하고/ 평점평균 2.0이상인 자장애등급 3/4등급 : 직전학기 학업성적이 12학점(7학기 9학점)이상 이수하고/ 평점평균 3.0이상인 자 나. 2019학년도 2학기 이후 입학자 계속 수혜 기준직전학기 학업성적이 12학점(7학기 9학점) 이상 이수하고 평점평균 2.0 이상인 자 ※ 신입생은 성적기준 없으며/ 2004학번 이전은 15학점(7학기 12학점)이상 이수자',
      Col10: '해당없음',
      Col11: '등록금 전액 (입학금포함)',
      Col12: ' * 성균관대학교 학부 재학생장애인복지법 제32조에 의하여 장애인 등록을 한 장애정도가 심한 중증장애인(1~3급)에 해당하는 자',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '은행나무장학금신청서 장애인 등록증 사본 1부 개인정보 이용 및 활용 동의서'
    },
    {
      Col1: '성균관대학교',
      Col2: '국가유공자(자녀)장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점평균 2.0이상 인자 (단/ 국가유공자 본인 및 신입생은 제외)',
      Col10: '해당없음',
      Col11: '장학금 지급액 : 등록금 전액(수업연한 동안) ',
      Col12: '국가유공자 본인 또는 자녀인 학부생 ',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '국가유공자 본인: 교육보호대상자증명서국가유공자 자녀 : 대학수업료등 면제대상자 증명서 및 가족관계를 확인할 수 있는 주민등록등본 개인정보 수집 및 이용 동의서(공통) * 온라인 메일접수'
    },
    {
      Col1: '성균관대학교',
      Col2: '성균이웃사랑장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 12학점(최종학기 직전학기 : 9학점)이상 이수하고 평점평균이 2.5이상',
      Col10: '국민기초생활보장법에 의한 수급자 또는 차상위계층 (소득분위 1분위 이내)',
      Col11: '등록금 전액(수업연한 8개학기 동안 )',
      Col12: '성균관이웃사랑장학금 수혜 중인 자',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '초과학기 학생2022년 1학기 휴학예정자 신청 불가',
      Col18: '해당없음',
      Col19: '공통: 개인정보 이용 및 활용 동의서  * 아래 3개 중 1개 선택 국가장학금(www.kosaf.go.kr) 신청 : 별도 서류 제출 불필요 학생 본인 명의 기초생활수급자 증명서 제출차상위계층 증명서류 제출 ※ 온라인 메일접수 또는 우편접수로/ 자세한 사항은 교내 홈페이지>공지사항 내 공고 참조'
    },
    {
      Col1: '성균관대학교',
      Col2: '63장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 학업성적이 12학점(4학년 9학점)이수하고 평점평균이 3.8이상 ',
      Col10: '국가장학금 신청자 중 소득분위 2분위(차상위) 이내인 학사과정 재학생',
      Col11: '1000000원* 교재비 지원명목 이중수혜가능',
      Col12: '교내외 장학금 중 어떤 장학금도 수혜하고 있지 않은 학생(국가 장학금 포함) * 인건비성 근로장학금은 제외외 * 장학생 의무사항 장학금 수혜 학기 중 기부자에 대한 감사의 편지 쓰기추후 수여식 참석 ',
      Col13: '해당없음',
      Col14: '2021-09-29~2021-10-08',
      Col15: '해당없음',
      Col16: '15명',
      Col17: '20212학기 현재 휴학생 및 초과등록생 ',
      Col18: '해당없음',
      Col19: '장학금 신청서 자기소개서(장학금 신청사유 포함) 자유양식 A4 1장 이내 기타 대외 활동 및 근로 경험시 선발 우대개인정보 수집 및 이용 동의서  * 교내장학금으로/ 자세한 사항은 교내 홈페이지 > 장학 공지사항 내 공고문 참조'
    },
    {
      Col1: '성균관대학교',
      Col2: '문행장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '한국장학재단 소득분위 3분위 이하 학부생',
      Col11: '문행장학금(A) : 등록금 100%문행장학금(B) : 등록금 50%문행장학금(C) : 등록금 30%',
      Col12: ' * 성균관대학교 재학생으로/ 2022학년도 1학기 국가장학금 신청자로 소득분위 3분위 이하 학생문행장학금(A) : 소득분위 0분위/ 1분위문행장학금(B) : 소득분위 2분위문행장학금(C) : 소득분위 3분위',
      Col13: '해당없음',
      Col14: '별도 모집',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '국가장학금 미 신청자재입학생/ 초과학기 학생',
      Col18: '해당없음',
      Col19: ' * 별도의 제출서류 없이/ 국가장학금 신청으로 신청 완료'
    },
    {
      Col1: '성균관대학교',
      Col2: '오거서장학금(독서장학금)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 학업성적 평점평균 2.0 이상직전학기 취득학점 12학점 이상(최종학기 직전학기는 9학점)',
      Col10: '해당없음',
      Col11: '500000원',
      Col12: '2022학년도 2학기에 재학 중인 학부생 (2023년 2월 졸업 예정자 지원 가능)독서리뷰 제출 기간 중 오거서 홈페이지에 총 12편 이상의 한글독서리뷰를 탑재한 학부생',
      Col13: '해당없음',
      Col14: '2022-02-21~2022-12-31',
      Col15: '독서리뷰 분량 : 1편당 1/600자 이상(공백포함)',
      Col16: '20명 예정',
      Col17: '2021학년도 오거서 장학생 선발자 (연속 수혜 불가)인터넷 게시물 표절/ 인용 논문 출처 미표기자 등장학금지급규정 제4조(장학금 지급제한)에 해당하는 자 * 자세한 사항은 홈페이지 공고문 참고',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '사단법인한국장애인단체총연맹',
      Col2: '장애대학생 아람코등록금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/자연계열',
      Col9: '직전학기 최소 12학점 이상 이수/ 직전학기 백분위 점수 75점 이상 취득 학생',
      Col10: '해당없음',
      Col11: '학기당 200000원 * 단 신청사유 및 필요성 등에 따라 일부 조정가능',
      Col12: '국내 4년제 대학교 이공계열에 재학 중인 등록 장애학생 * 기존 아람코 등록금(2016~2019)지원자 신청가능',
      Col13: '해당없음',
      Col14: '2020-01-20~2020-02-13',
      Col15: ' * 성적우수자/ 저소득가정 우선 고려',
      Col16: '00명 * 1학기 선정 후 일정조건에 따라 2학기 연속지원',
      Col17: '신입생 및 8월 졸업생생 제외',
      Col18: '해당없음',
      Col19: '신청서소득증명 서류 재학증명서(최근 3개월 이내 발급서류 한함)전 학기 성적증명서 (직전학기 포함)장애인등록증(복지카드) (앞/뒷면)가족관계증명서(보호자기준) * 선택서류 : 재학중인 학과의(지도)교수 추천서/ 졸업예정증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '방일영문화재단',
      Col2: '방일영장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학신입생',
      Col8: '사회계열/인문계열',
      Col9: '2021학년도 1학기 평점 평균3.4(4.3만점) 이상인자 * 재단이 선정한 학교의 학생 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수',
      Col10: '해당없음',
      Col11: '2학년 1학기부터 3년간 등록금 전액 및 월 600000원의 학업보조비 지원(휴학시 지급 유예)',
      Col12: ' * 재단이 선정한 학교의 학생 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수현재 1학년에 재학중인 학부생',
      Col13: '해당없음',
      Col14: '별도 모집',
      Col15: '해당없음',
      Col16: '4명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원 신청서학장 추천서성적증명서자기소개서수능성적표 사본개인정보 수집이용 동의서서'
    },
    {
      Col1: '방일영문화재단',
      Col2: '방일영탈북장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학신입생',
      Col8: '사회계열/인문계열',
      Col9: '1학년 1학기 현재 평점 평균이 b이상인 자 ',
      Col10: '해당없음',
      Col11: '매 월 700000원 * 12개월 지급',
      Col12: '신청년도 신입학한 인문·사회 계열 1학년 재학중인 탈북 대학생',
      Col13: '해당없음',
      Col14: '2021-10-15~2021-10-29',
      Col15: '학교 추천 → 재단 서류심사 → 재단 면접 진행 후 선발',
      Col16: '추천인원 1명 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원서재학증명서/ 성적증명서자기소개서 수능성적표 사본(해당자)※ 재단 측에서 대학교로 공문을 통해 장학생 추천을 의뢰하는 장학금으로/ 소속 대학 장학팀을 통해 선발 여부를 우선 확인 바랍니다.'
    },
    {
      Col1: '고려대학교',
      Col2: '고경(면학)장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '사회계열/특정학과',
      Col9: '해당없음',
      Col10: '가정형편이 어려운 자',
      Col11: '소득분위에 따라 차등지급 ( 수업료의 35% ~ 수업료 전액 자세한 사항은 홈페이지 내 공고 참조)',
      Col12: ' * 고려대학교 2022학년도 2학기 재학 예정자로 가정형편이 어려운자한국장학재단 국가장학금 1차 신청자 & 본교 정의장학금(면학장학금) 신청자',
      Col13: '해당없음',
      Col14: '2022-07-06~2022-07-29',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '초과학기생 제외수업료 장학금으로 등록금 전액 수혜받은 장학생',
      Col18: '해당없음',
      Col19: '학자금지원구간(분위)통지서신청서가정형편 증빙서류(택1) · 한부모 가족증명서/ 기초생활수급자증명서/ 차상위계층증명서/ 부채증명원/ 질병확인서 또는 수술확인서/ 기타 가정형편 증빙서류'
    },
    {
      Col1: '고려대학교',
      Col2: '기금장학금(백목장학회)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 학업성적이 평점평균 3.0이상',
      Col10: '가정이 빈곤하여 학비 조달이 곤란한 자자소득분위 8분위 이내',
      Col11: '1000000원 * 수업료',
      Col12: '성실하고 우수한 재능을 가진 학생국가장학금 신청 필수고려대학교 경영대학학 재학생',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-07-27',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '학업성적 미달징계처분/ 휴학학초과학기자',
      Col18: '지도교수 또는 학장 * 전공 수업 교수님 등 학생을 잘 알고 있는 교수님의 추천서 제출',
      Col19: '성적증명서학자금지원구간(소득분위)통지서 * 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '고려대학교',
      Col2: '기금장학금(최병순장학회)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 3.5이상 조건 유지',
      Col10: '소득 분위 8분위 이내 ',
      Col11: '1200000원 (수업료)',
      Col12: '20221학기 등록 예정인 정규학기 제1전공 통계학과 재학생국가장학금 신청자자',
      Col13: '해당없음',
      Col14: '2022-01-14~2022-01-17',
      Col15: '해당없음',
      Col16: '각 장학금 당 1명 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서(첨부파일)학자금 지원구간 통지서(소득분위통지서)'
    },
    {
      Col1: '고려대학교',
      Col2: '보헌장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학5학기',
      Col8: '공학계열/사회계열/예체능계열/인문계열/자연계열',
      Col9: '직전학기 성적 3.2 이상',
      Col10: '소득분위 6분위 이내 ',
      Col11: '수업료 전액(4개 학기)',
      Col12: '20221학기 등록 예정인 정규학기 제 1전공 통계학과 재학생국가장학금 신청자  3학년(5학기차) 진학 예정자 ',
      Col13: '해당없음',
      Col14: '2022-01-14~2022-01-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수 성적증명서교수추천서(자필) 자기소개서세목별 과세 증명서(부/모 모두 해당) 건강보험료 납부확인서(부/모 모두 해당)'
    },
    {
      Col1: '고려대학교',
      Col2: '석림회장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '취득학점이 17학점 이상/ 4학년은 12학점 이상 취득 자 (20212학기 기준)',
      Col10: '해당없음',
      Col11: '220만원 (수업료) 2022년 1학기 1회성 ',
      Col12: '2022학년도 1학기 재학생기타 장학금 이중수혜를 받지 않는 학생 ',
      Col13: '해당없음',
      Col14: '2022-01-24~2022-01-28',
      Col15: '해당없음',
      Col16: '1명 ',
      Col17: '초과학기 등록자 / 이중수혜자',
      Col18: '해당없음',
      Col19: '석림회 장학금 신청서성적증명서 1부소득분위증명서 1부주민등록등본 1부기타 장애증명서'
    },
    {
      Col1: '고려대학교',
      Col2: '교내장학금(KU드림장학금)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소득 8분위 이내',
      Col11: '수업료의 50%',
      Col12: '재학중인 학부생으로서 국가장학금 신청자형제자매가 4인 이상인 학부생형제자매가 3인이고 이중 2인 이상이 대학에 재학중인 학부생 (휴학·수료 미인정)부모중 1인 또는 모두 한국에 귀화한 다문화 가정 학부생 (해당 학생은 부모의 출입국관리소 발행 국적사실취득증명서 제출)',
      Col13: '해당없음',
      Col14: '2022-04-01~2022-04-29',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '수업연한 초과자',
      Col18: '해당없음',
      Col19: '장학금신청서(온라인 입력)부모명의 가족관계증명서(온라인 업로드)형제자매의 재학증명서(타대학)(20211학기/2021.04.01이후 발급분) 국적사실취득증명서 (해당자 한함/ 온라인 업로드)'
    },
    {
      Col1: '고려대학교',
      Col2: '교내장학금(고대가족장학금)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '수업료의 50% ',
      Col12: '형제자매가 동시에 본교에 재학중(대학원 포함)인 학부생 중 1인',
      Col13: '해당없음',
      Col14: '2022-04-01~2022-04-29',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '학부 및 대학원수료(수료연구생포함) 미인정형제자매의 중복 신청 불가KU드림장학금과 중복 신청 불가   ',
      Col18: '해당없음',
      Col19: '장학금신청서(온라인 입력)부모명의 가족관계증명서 (온라인업로드)장학금 신청학기 재학중인 형제자매의 학번 (온라인 입력) * 가족관계증명서 포함/ 증명서류는 최근 3개월 이내 발행분만 유효 * 교내장학금으로 자세한 사항은 고려대학교 관련부서에 문의'
    },
    {
      Col1: '고려대학교',
      Col2: '교내장학금(재해)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '피해사실확인서(행정기관 발행)에 따라 학교가 정한 금액',
      Col12: '2021학년도 2학기 기간(2021.09.01~2022.02.28)동안 발생한 자연재해(수해)나 태풍 피해 등으로 경제적 어려움을 겪고 있는 학부생/ 초과학기자 지원가능',
      Col13: '해당없음',
      Col14: '2022-04-01~2022-04-29',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '외국인수업연한초과자',
      Col18: '해당없음',
      Col19: ' * 교내장학금으로  신청시 학교 장학 담당자에게 문의 필수 * 제출서류 온라인 업로드장학금신청서(온라인 입력)장학금신청사유서(온라인 업로드)피해사실확인서서'
    },
    {
      Col1: '고려대학교',
      Col2: '정의장학금(미래로 및 면학)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 이상 이수/ 100점 만점의 80점 이상(평점 2.75)의 성적 * F학점 및 학점포기 과목 포함하여 백분위 성적산출 ** 장애학생 및 당해학기 신/편입/재입학생의 경우 성적 및 이수학점 기준 미적용 / 정규학기 마지막 학기 재학생의 경우 이수학점기준 적용 예외',
      Col10: '한국장학재단 소득분위 0~8분위 확정자',
      Col11: '소득분위(0분위) : 수업료 전액 지원 미래로생활비 : 학기별 180만원(매월 30만원씩 지급)소득분위(1분위 ~ 4분위) : 수업료 100% 지원소득분위(5분위 이상~) : 장학금 예산에 따라 차등지급',
      Col12: ' * 고려대학교 2022학년도 1학기 서울캠퍼스 재학생으로/ 2022학년도 1학기 국가장학금(Ⅰ유형) 신청자미래로장학금 : 기초생활수급자면학장학금 : 경제적 사정이 곤란한 학생',
      Col13: '해당없음',
      Col14: '2022-04-01~2022-04-29',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '20211학기 재학생 중 국가장학금(I유형)을 미신청한 학생정규학기 초과자',
      Col18: '해당없음',
      Col19: ' * 포탈사이트(kupid) → 등록/장학 → 장학금 신청에서 면학장학금 신청'
    },
    {
      Col1: '고려대학교',
      Col2: '교내장학금(소망장학금)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '수업료의 50%(입학금 포함)',
      Col12: ' 특수교육대상자 전형 입학자 또는 장애 학생 중 가계 형편이 어려운 학부생',
      Col13: '해당없음',
      Col14: '2022-04-01~2022-04-29',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '수업연한초과자외국인',
      Col18: '해당없음',
      Col19: ' * 기존 소망장학금 수혜자는 신청할 필요 없음장학금신청서 (온라인 입력)장애인증명서 (온라인 업로드)'
    },
    {
      Col1: '해동과학문화재단',
      Col2: '해동장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상/석사신입생(1학기)',
      Col8: '공학계열',
      Col9: '해당없음',
      Col10: '한국장학재단 소득 분위 0~2분위',
      Col11: '연 최대 1000만원생활지원비 : 월 70만원자기계발비: 월 10만원교재비 : 학기당 20만원 ',
      Col12: '20221학기 2.3학년 (2학기 이상 학업을 연속적으로 할 수 있는 자)',
      Col13: '해당없음',
      Col14: '2021-12-11~2022-01-10',
      Col15: '서류심사→면접→선발',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '지도교수 추천 ',
      Col19: '해동장학금 신청서전 학년 성적증명서한국장학재단 기준 소득 등급 증빙서류개인정보동의서 '
    },
    {
      Col1: '중앙대학교',
      Col2: '환주장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점이 3.5 이상인 학생',
      Col10: '가정형편이 어려운 자',
      Col11: '2000000원(학기 장학금 수혜액이 등록금 범위를 초과하지 않는 학생)',
      Col12: '중앙대학교 8차 학기 미만 학부 재학생징계 이력과 같은 장학금을 받기 위한 결격사유가 없는 학생 학비 조달이 어려운 학생학기 장학금 수혜액(근로장학금 제외)과 본 장학금액 합산 액이 등록금 범위를 초과하지 않는 학생',
      Col13: '해당없음',
      Col14: '2022-03-08~2022-03-15',
      Col15: '해당없음',
      Col16: '5명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서 1부장학금 신청사유서 1부직전 학기 성적증명서 1부개인정보 수집 및 이용 및 제3자 제공동의서 1부 * 교내장학금으로/ 자세한 사항은 중앙대학교 장학게시판 참고 '
    },
    {
      Col1: '중앙대학교',
      Col2: '중앙사랑장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '이수학점 : 직전학기 12학점 이상(단/ 졸업학기는 8학점이상)평균평점 : 직전학기 1.88점 이상 * 신/편입생은 이수학점 및 평균평점 미적용',
      Col10: '소득분위 : 0 ~ 8분위 이내',
      Col11: '성적미충족자 (1.88이상) : 지급액의 50% 범위그 외 : 등록금 범위 내 지급(200000원 ~ 1000000원) * 자세한 사항은 교내 홈페이지 내 공고 참조',
      Col12: ' * 중앙대학교 재학생으로/ 20221학기 국가장학금 거절자 중 사전장학 신청자성적조건 미 충족자국가장학금 수혜횟수 초과자이연으로 인한 거절자 중 등록학기 중앙사랑장학금 미수혜자 ',
      Col13: '해당없음',
      Col14: '별도 모집',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '초과학기 재학생 제외',
      Col18: '해당없음',
      Col19: ' * 교내장학금으로/ 신청시 각 학교 장학부서에 문의 필수'
    },
    {
      Col1: '중앙대학교',
      Col2: '일취월장장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2022학년도 1학기 12학점이상/ 평점 2.5이상 취득한 자평가균별 학업성취도 이상 향상된 자 (* 홈페이지 공고 참조)',
      Col10: '해당없음',
      Col11: '1000000원 이내(등록금 실 납부액 이내에서 지급)',
      Col12: '직전학기 성적과 당 학기 성적을 비교하여 학업성취도가 향상된 재학생교내외장학금 수혜액을 제외하고 등록금 실 납부금액이 0원 초과자',
      Col13: '해당없음',
      Col14: '2022-04-11~2022-04-29',
      Col15: '당 학기 평점과 직전학기 평점 차가 높은 순으로 장학 선발평가군 별 평가 표는 중앙대학교 게시판 참고',
      Col16: '해당없음',
      Col17: '휴학생 및 수업연한 초과자 자격제한교내·외장학금 수혜액을 제외하고 등록금액이 0원일 경우 지원불가',
      Col18: '해당없음',
      Col19: ' * 포털 통해 신청/ 자세한 사항은 중앙대학교 홈페이지 내 공고참조'
    },
    {
      Col1: '중앙대학교',
      Col2: '복지장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점평균이 1.88 이상인 자 (신입생 제외)',
      Col10: '해당없음',
      Col11: '최대 100만원 이내에서 예산규모 및 수혜인원을 고려하여 지급액 결정',
      Col12: '20221학기 중앙대학교 서울캠퍼스 재학생20221학기 등록금 실 납부금액이 0원을 초과하는 자(전액 장학생은 제외)수업연한을 초과하지 않은 자재학중 복지장학금 혜택을 받지 않은 자',
      Col13: '해당없음',
      Col14: '2022-06-13~2022-06-30',
      Col15: '수혜대상 요건 충족 여부/ 가계곤란 사항 등을 심사하여 선발 * 자세한 내용은 첨부파일 혹은 홈페이지 공고 참고',
      Col16: '00명',
      Col17: '당 학기 신입생 및 편입생휴학생 신청 불가',
      Col18: '해당없음',
      Col19: '복지장학금 신청서복지장학금 신청사유개인정보수집이용제공 동의서수혜대상 증빙서류 및 가계곤란 증빙서류  * 서류제출 유의사항 및 세부 내용은 첨부파일 참고'
    },
    {
      Col1: '중앙대학교',
      Col2: '교내장학금(보훈)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 1.88 이상',
      Col10: '해당없음',
      Col11: '입학금 및 수업료 전액(수업연한 까지)',
      Col12: '20222학기 중앙대학교 재학 예정자국가보훈법에 의한 보훈대상자 본인 및 직계손자녀 (북한이탈주민 교육보호대상자 포함) ',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-08-05',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '수업연한 초과자 제외',
      Col18: '해당없음',
      Col19: '손·자녀 : 대학수업료 면제 대상자 증명서본인 : 교육지원 대상자 증명서북한이탈주민: 교육보호대상자 증명서 및 고졸 학력인정 증빙서류 * 자세한 사항은 홈페이지 내 공고문 참조'
    },
    {
      Col1: '중앙대학교',
      Col2: '교내장학금(국가시험지원)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 이수학점 12학점(단 4학년은 8학점)/ 평점 1.88점 이상인 자',
      Col10: '해당없음',
      Col11: '수업료 전액 (단 국가공무원 5급 공개경쟁채용시험 및 입법고시 1차합격자는 2차 시험준비를 위한 수강료 실비 지원) (등록금 범위 내) * 금액/지원기간은 사항마다 상이함으로 첨부자료 참고',
      Col12: '20222학기 중앙대학교 재학 예정자재학중 국가시험 합격자대상시험 : 사법고시/ 5급 국가공무원 공개경쟁채용시험/ 외교관 후보자 선발시험/ 입법고시/공인회계사/ 변리사  ※기타 국가시험은 소속대학별 기준 참고하여 소속대학 교학지원팀으로 문의  ',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-08-05',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '수업연한 초과자 제외',
      Col18: '해당없음',
      Col19: '합격확인서국가고시반 지도교수 확인서 * 자세한 사항은 첨부자료 또는 중앙대학교 장학게시판 참고'
    },
    {
      Col1: '중앙대학교',
      Col2: '교내장학금(가족)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 이상 성적이 2.50 이상인 자',
      Col10: '해당없음',
      Col11: '수업료의 35%(단 타 장학금 수혜자는 해당학기 등록금 범위 내에서 지급)',
      Col12: '중앙대학교 20222학기 재학 예정자 친가족 2명 이상 본 대학교 학부과정에 재학 또는 휴학하고 있는 경우 재학중인 학생 1명',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-08-05',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '수업연한 초과자 제외',
      Col18: '해당없음',
      Col19: '가족관계증명서 (부 또는 모 명의 발급) * 교내장학금으로/ 자세한 사항은 교내 홈페이지 공지사항 참조'
    },
    {
      Col1: '중앙대학교',
      Col2: '요남장학회장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '기독교 학생으로서 학비조달이 어려운 재학생교내 기독교 동아리(선교단체)의 지도교수 또는 대학교회 운영위원 또는 학과장 추천을 받은 학생 * 합격자는 기부자에게 감사편지 작성과 별도의 전달식에 반드시 참석',
      Col13: '해당없음',
      Col14: '2022-09-01~2022-09-14',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '학기 장학금 수혜액과 본 장학금액 합산액이 등록금 범위를 초과하지 않는 학생 대상',
      Col18: '교내 기독교 동아리(선교단체)의 지도교수 또는 대학교회 운영위원 또는 학과장 추천',
      Col19: '장학금 신청서 및 신청사유서(단/ 기독교 신앙 생활 내용 포함)기독교 동아리(선교단체)의 지도교수 또는 대학교회 자문운영위원 또는 학과장의 추천서개인정보 수집 및 이용 동의서* 제출서류 스캔 후 이메일 접수(caufund@cau.ac.kr)'
    },
    {
      Col1: '하티켐(Heartychem)',
      Col2: '하티켐(Heartychem)장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '특정학과',
      Col9: '직전 두 학기 성적 평균 3.0 이상',
      Col10: '가정 형편이 어려운 학생',
      Col11: '등록금 전액(1년치)',
      Col12: '중앙대학교 영어영문과 학생진취적인 정신을 가지고 열심히 노력하는 학생/ 즉 의지가 확고한 학생',
      Col13: '해당없음',
      Col14: '2022-01-04~2022-01-25',
      Col15: '해당없음',
      Col16: '2명  * 1년(두 학기) 등록금 전액을 2인의 학생에게 각각 지급함 ',
      Col17: '2학기 휴학 예정인 학생국가장학이나 다른 장학금과는 중복 수혜 불가가',
      Col18: '해당없음',
      Col19: '장학금 신청서성적증명서재학증명서건강보험료납부확인서(2019년 1월~현재)가족관계증명서(부모님이름으로 제출시)학생 본인 통장사본이력서 * 자세한 사항은 중앙대학교 영어영문학과 공지사항 내 공고 참조'
    },
    {
      Col1: '연세대학교',
      Col2: '신촌지역후원회장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평량평균 3.0/4.3 이상인자',
      Col10: '가정형편이 어려운 자',
      Col11: '3000000원 (등록금 범위 내 장학금 1회 지원)',
      Col12: '20192학기 연세대학교 학부 재학생 서대문지역 주민 우선 가계곤란 요건을 최우선으로 고려 ',
      Col13: '서대문지역 주민 우선',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '장학금 전달식 필수 참석',
      Col18: '해당없음',
      Col19: '장학생 감사서신'
    },
    {
      Col1: '연세대학교',
      Col2: '신동욱해외유학장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/특정대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/사회계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '20000000원 (1년동안 매 학기별 8월 2월에 지급)',
      Col12: ' * 연세대학교 대학원 박사과정 연구등록 학기에 있는 학생 중 해외 대학 및 연구기관에서 1년 이상의 연구를 진행하고자 하는 학생대한민국 국적을 보유한 자 대한민국에서 학사 및 석사학위과정을 졸업한 자본 대학원 박사과정 연구등록학기에 있는 자',
      Col13: '해당없음',
      Col14: '2022-04-19~2022-05-06',
      Col15: '해당없음',
      Col16: '2명',
      Col17: ' * 장학생 의무사항장학금 수혜자는 장학금 수혜기간 종료 후 3개월 이내에 연구결과보고서 또는 연구논문 1편을 제출/ 학위취득 후 학위논문 제출 장학금 수혜자는 본교에서 최종 박사학위를 취득하지 못할 경우 장학금 전액(1년분)을 반환',
      Col18: '지도교수 추천',
      Col19: '신동욱 해외유학 장학생 지원서지도교수 추천서연구계획서 및 해외연구기관 동의확인서이력서자기소개서대학 및 대학원 성적증명서/ 석사학위논문각종 입상실적 및 연구실적을 증명할 수 있는 증빙서류 * 소속 대학 또는 학과사무실 제출으로 자세한 사항은 소속학과로 문의'
    },
    {
      Col1: '연세대학교',
      Col2: '주충노장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학7학기/대학8학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: '성적 우수자',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '연세대학교 생화학과 대학원 진학예정인자',
      Col13: '해당없음',
      Col14: '2022-02-03',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '교내장학금 등 타 장학금 수혜자도 지원가능하나/ 본 장학생 선정시 타 장학금을 포기해야 함',
      Col18: '해당없음',
      Col19: '지원서 1부 및 졸업 후 진로계획서 1부(사진을 반드시 부착할 것)성적증명서 1부'
    },
    {
      Col1: '연세대학교',
      Col2: '국순당배중호장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '5000000원',
      Col12: '가계 곤란하며 졸업 후 국내외 대학원 진학 또는 취업 예정인 연세대학교 생화학과 학부생',
      Col13: '해당없음',
      Col14: '2022-02-03',
      Col15: '서류제출 후 서류심사 및 면접심사 * 면접대상자와 면접일시는 개별공지 예정',
      Col16: '1명',
      Col17: ' * 교내장학금 등 타 장학금 수혜자도 지원가능하나/ 본 장학생 선정 시 타 장학금을 포기해야 함',
      Col18: '해당없음',
      Col19: ' 이력서 1부 (자유 양식)자기소개서 (자유 양식)성적증명서'
    },
    {
      Col1: '연세대학교',
      Col2: '동곡장학금(법학대학기금장학금)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '석사2학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '학기당 2000000원 내외',
      Col12: '연세대 법학전문대학원 재학생',
      Col13: '해당없음',
      Col14: '2022-08-22~2022-08-24',
      Col15: '가정형편/ 학교성적/ 품성 및 장래 바른 법조인으로서의 성장가능성을 고려하여 장학회 이사회에서 선발',
      Col16: '5명 이내',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.  동곡장학금 신청서성적증명서가계곤란 입증서류 * 법과대학 사무실에서 접수'
    },
    {
      Col1: '연세대학교',
      Col2: '김모임장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '특정학과',
      Col9: '직전 학기 성적이 우수한 학생 중 상위 5% 내외전학기 채플 수업 이수',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '연세대학교 간호대학 재학생/복학 예정생간호학과 필수교과목을 이수하고 졸업할 학생교내외 활동에서 우수한 리더십을 발휘하는 성적 우수학생',
      Col13: '해당없음',
      Col14: '2021-12-20~2022-01-16',
      Col15: '자기소개서 및 활동내용에 대한 학생지도위원 심사를 거쳐 선정정',
      Col16: '5명',
      Col17: '직전학기 채플 미이수자학기초과자졸업예정자복수전공 전형 합격자',
      Col18: '해당없음',
      Col19: '장학금신청서개인정보 이용동의서 * 연세포탈서비스→학사정보시스템→학사관리→장학에서 신청 후 신청서 출력하여 간호대학 사무팀으로 제출/ 양식 다운로드 및 자세한 사항 확인은 연세대학교 간호대학 공지사항 참조'
    },
    {
      Col1: '연세대학교',
      Col2: '상경대학일송장학금(해외유학생)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/특정대학/해외대학',
      Col7: '대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '사회계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 및 연구비 또는 생활비로 년 약 2500만원을 1년간 지급',
      Col12: '본 대학교 상경대학/ 경영대학을 졸업한 자.해외유수대학의 경제학 전공분야에 박사과정으로 입학 허가 받은 자유학 후 교수요원을 희망하는 자',
      Col13: '해당없음',
      Col14: '2022-06-09~2022-07-04',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '전액장학금을 받은 학생은 제외',
      Col18: '해당없음',
      Col19: '일송장학금 신청서자기소개서학업계획서성적증명서졸업증명서/ 입학허가서기타 선정에 도움이 된다고 판단되는 서류(해당자) * 양식 다운로드 및 자세한 사항 확인 연세대학교 상경대학 본인 소속학과 홈페이지 공고 참조'
    },
    {
      Col1: '연세대학교',
      Col2: '상경대학일송장학금(특별장학생)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '사회계열/특정학과',
      Col9: '해당없음',
      Col10: '다문화 가정 학생 가장 탈북자 고아 중국동포 등인 자가정형편이 어려운 자',
      Col11: '생활비로 년 약 6000000원을 1년간 지급',
      Col12: ' * 연세대학교 상경대학 재학중인 자다문화 가정/ 학생 가장/ 탈북자/ 고아/ 중국동포 등인 자가정형편이 어려운 자',
      Col13: '해당없음',
      Col14: '2022-06-09~2022-06-27',
      Col15: '해당없음',
      Col16: '2명(경제학과 학부생 1명/ 응용통계학과 학부생 1명)',
      Col17: ' * 교내장학금으로/ 상경대학 소속 학과 사무실로 문의',
      Col18: '해당없음',
      Col19: '일송장학금 신청서자기소개서학업계획서성적증명서재학증명서/ 사회적 배려 대상자 해당 증명서기타 선정에 도움이 된다고 판단되는 서류(각 해당자) * 양식 다운로드 및 자세한 사항 확인은 연세대학교 상경대학 홈페이지 참조'
    },
    {
      Col1: '연세대학교',
      Col2: '상경대학일송장학금(국내박사생)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/특정대학/해외대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '사회계열/특정학과',
      Col9: '학업 능력이 우수한 자',
      Col10: '가정형편이 어려운 자',
      Col11: '생활비로 년 약 1600만원을 최장 3년간 지급',
      Col12: '본 대학교 일반대학원 경제학과에 재학중인 자로 학업 능력이 우수한 자',
      Col13: '해당없음',
      Col14: '2021-07-07',
      Col15: '해당없음',
      Col16: '1명',
      Col17: ' * 교내장학금으로/ 연세대학교 상경대학 사무실로 문의',
      Col18: '해당없음',
      Col19: '일송장학금 신청서자기소개서학업계획서성적증명서재학증명서가계곤란자 해당 증명서기타 선정에 도움이 된다고 판단되는 서류개인정보 동의서 * 교내장학금으로/ 제출서류 양식 다운로드 및 자세한 사항 확인은 연세대학교 상경대학 홈페이지 공고 참조'
    },
    {
      Col1: '연세대학교',
      Col2: '사회과학대학 PF 장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '사회계열/특정학과',
      Col9: '해당없음',
      Col10: '가계곤란 학생',
      Col11: '선정위원회에서 장학금액 등록금 범위 내 결정',
      Col12: '연세대학교 사회과학대학 재학생국가장학금 지급대상자(등록금 범위 내 중복수혜 가능) 및 국가장학금을 신청한 가계곤란대상자',
      Col13: '해당없음',
      Col14: '2022-01-10~2022-02-01',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 교내 장학금으로 학과에 문의 필수.신청서(사회과학대학 및 학과 홈페이지) 작성 후 사회과학대학 행정팀으로 제출'
    },
    {
      Col1: '연세대학교',
      Col2: '연세의과학자육성장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학신입생',
      Col8: '의약계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 전액 ( * 특별 연구지원 및 연세대 의대의 전주기적 연구지원 프로그램들에 우선 참여 기회 부여)',
      Col12: '2022년 의학과 본1/ 본 2 진입예정 재학생 약간명명',
      Col13: '해당없음',
      Col14: '2021-12-13~2021-12-30',
      Col15: '해당없음',
      Col16: '3명',
      Col17: ' * 교내장학금이므로/ 자세한 사항은 의과대학 학생부 사무실로 문의',
      Col18: '해당없음',
      Col19: '지원서(해당양식)자기소개서(해당양식)연구경력서 및 증빙자료/ 기타 연구 업적물(해당양식/ 필수아님)개인정보수집동의서 '
    },
    {
      Col1: '연세대학교',
      Col2: '대학배정장학금(진리·자유)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/인문계열/자연계열',
      Col9: '직전학기 이수학점이 12학점 이상/ 학업성적이 평량평균 2.50(4.3기준) 이상인 자',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '20222학기 재학/복학 예정인 학부생',
      Col13: '해당없음',
      Col14: '2022-06-20~2022-07-17',
      Col15: '진리장학금: 성적기준을 우선 적용하되 소득기준 반영자유장학금: 소득기준 우선적용 * 두 장학금 중 한가지만 신청 가능',
      Col16: '해당없음',
      Col17: '20222학기 기준 학기초과자 휴학/ 졸업(수료)자직전학기 교환학생(진리 신청자만 해당)졸업예정자 복수전공 전형 합격자간호대학 진급자국가장학금 0~4분위 재학생 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: ' [진리장학금] 온라인 신청으로 완료되어 추가 제출 서류 없음 [자유장학금] * 신청마감일 기준 소득분위 확인자는 필수 증빙서류 없음가족관계증명서부/모의 최근 1년간 지방세 세목별 과세증명서 또는 재산세 납세증명서 부/모의 최근 1년간 소득관련 증빙서류기타 선택증빙서류(원하는 경우만 제출) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '연세대학교',
      Col2: '박정옥장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/사회계열/예체능계열/자연계열',
      Col9: ' * 자세한 사항은 소속 학과 홈페이지 참조',
      Col10: '가정형편이 어려운 자',
      Col11: '2000000원',
      Col12: '연세대학교 재학생으로 대학배정장학금을 신청한 학생품행이 단정하고 가정형편이 어려운 학생(교내장학금 지급기준) * 공과대학/ 생명시스템대학/ 신과대학/ 사회과학대학/ 음악대학',
      Col13: '해당없음',
      Col14: '2022-08-08~2022-08-16',
      Col15: '해당없음',
      Col16: '댄과대학별 1명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '성적증명서소득분위확인서(최종선발 이후) 학생의 감사편지 제출 * 자세한 사항은 소속 학과 홈페이지 참조'
    },
    {
      Col1: '연세대학교',
      Col2: '미래인재역량강화장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적 평점+(3.3) 이상',
      Col10: '해당없음',
      Col11: '취업플랜 : 1000000원역량강화플랜 : 500000원원',
      Col12: '3학년~4학년 : RC수료자(필수)4학년 : 진로취창업 교과목 수료자 우대 (커리어디자인2p/취업교과목 수강자)연세대학교 미래캠퍼스 재학생 및 휴학생(3학년이상)',
      Col13: '해당없음',
      Col14: '2021-09-01~2021-09-15',
      Col15: 'Learnus로그인학위과정yoncom연세대1번지 검색고급강좌관리등록요청',
      Col16: '30명 (선착순)',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서&자기소개서역량개발계획서증빙 서류 '
    },
    {
      Col1: '연세대학교',
      Col2: 'sw융합전공 우수장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 범위내 지급',
      Col12: 'SW융합전공 (수학과/ 정보통계학과) 재학생 [SW융합전공 부전공자 및 복수전공자 포함/ 이중전공 및 부전공 첫 학기에는 전교생 SW우수장학금을 신청할 수 있으나 SW융합전공 우수장학금과 중복 신청은 불가]직전학기에 SW교양과목 또는 SW관련 전공과목 이수[첨부된 SW교양과목 리스트/ SW관련 전공과목 리스트 참조]',
      Col13: '해당없음',
      Col14: '2022-05-26~2022-06-16',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '온라인신청 * 자세한 내용 연세대학교 SW중심대학사업단 공지사항 확인'
    },
    {
      Col1: '연세대학교',
      Col2: '서봉 이충곤 장학기금 장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '가게곤란으로 인해 학업 수행이 어려운 자',
      Col11: ' * 추후 안내 * 등록금 범위로 타장학금 중복 수혜 가능',
      Col12: '연세대학교 기계공학과 학부 재학생으로서 올바른 품행을 지닌 자투철한 국가관과 이웃을 위해 봉사할 의지와 소양을 가진 자 ',
      Col13: '해당없음',
      Col14: '2022-08-08~2022-08-12',
      Col15: '해당없음',
      Col16: '추천인원 제한 없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '성정증명서소득분위 확인서'
    },
    {
      Col1: '한국과학기술원(KAIST)',
      Col2: '김영한글로벌리더장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학사과정 : 2015학년도 입학생으로 2016 봄학기까지 취득한 학점 및 성적이 45학점 이상/ 평균평점 3.9 이상석/박사과정 : 국비학생 1년차 학생으로 2016년 봄학기 성적이 3.9 이상 * 장학금 계속 지급 요건학사 : 직전학기 12학점 이상/평균평점 3.7이상 취득석/박사 : 직전학기 9학점 이상/평균평점 3.7이상 취득 * 직전학기의 평점성적이 없는 경우 누적평점을 반영하되/ 직전학기에 ‘U’ 성적이 없어야 함',
      Col10: '해당없음',
      Col11: '400만원/년 지급(학기당 학업장려금 200만원 지급)* 학사 및 박사과정은 2년 석사과정은 1년 지원',
      Col12: '카이스트 재학생(학사/석/박사 과정 모두 해당)',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '서류심사 및 면접(필요시)',
      Col16: '학사 : 4명석사 : 2명박사 : 2명',
      Col17: '대통령과학장학금/ 삼성장학금/ 관정장학금/ 글로벌박사펠로우십을 받는 학생은 지원 불가수혜기간 중 학적변동(자퇴/ 제적/ 조기졸업) 또는 기타 징계처분을 받은 경우에는 장학금 지급 중단',
      Col18: '학사과정 : 지도교수의 추천석/박사과정 : 지도교수와 학과장 추천',
      Col19: '* 지원신청서를 작성하여 지도교수의 추천을 받아 학생이 학생복지팀에 직접 제출성적증명서신상명세서본인 소개서교내/외 활동실적지도교수 추천서학과장(전공책임교수) 추천서 (석/박사 학생만 작성)'
    },
    {
      Col1: '한국과학기술원(KAIST)',
      Col2: '인성장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '모범부문 : 우정/ 선행/ 효행/ 사회적 약자를 도와주는 등의 솔선수범과 헌신적 노력으로 타의 모범이 되는 학생봉사부문 : 총학생회/ 생활관 자치회 등 교내 공식 조직의 활동으로 봉사 공로부문 : 전공분야의 학술·연구 실적으로 국가나 국내·외 학술단체롭터 수상한 바가 있거나/ 수상실적이 없어도 탁월성을 인정받아 학교의 명예를 대외적으로 드높인 자',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '한국과학기술원(KAIST) 학사과정 재학생으로 건전한 가치관과 소양을 겸비하여 타의 모범이 되고 배려의 정신을 실천한 학생활동실적 심사 대상기간 : 2018. 7. 1. ~ 2019. 6. 30 (12개월) ※ 자세한 사항은 첨부파일 참조',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '총 20명 내외',
      Col17: '8학기 재학 초과자 및 기존 수혜자 선발 제외',
      Col18: '학부(과)장 및 부서장 추천에 의한 신청',
      Col19: '인성장학생 추천서 1부(증빙서류 첨부)'
    },
    {
      Col1: '한국과학기술원(KAIST)',
      Col2: '핵비확산연구장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상',
      Col8: '사회계열/인문계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '연구장학금: 2500000원 ',
      Col12: '국내 대학의 인문사회과학 전공 석/박사 연구생국내 대학 내 인문사회과학 분야 연구소 소속 연구원* 지원요건 : 논문 1건 작성하여 국내외 학회에 발표',
      Col13: '해당없음',
      Col14: '2020-02-10~2020-03-10',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 신청시 학교 장학 공고 확인 필수.지원 신청서(※별도 양식 참조)재학(재직) 증명서성적증명서'
    },
    {
      Col1: '인춘재단',
      Col2: '인재양성장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 두 학기 평균학점이 80점 이상인 자 (2.4/4.3)',
      Col10: '부모님 연소득 합계액이 6천만 이하',
      Col11: '등록금 전액',
      Col12: '상경계열 전공자로 (경영/경제) 미래에 대한 목표가 뚜렷하고 인성이 모범적인 자2022년 1학기 기준 2학년 진급 예정자 ',
      Col13: '해당없음',
      Col14: '2022-01-14~2022-01-19',
      Col15: '해당없음',
      Col16: '경영대학 2명 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원 신청서 (첨부파일)학업계획서 (첨부파일)지도교수 추천서( 첨부파일)성적증명서부모의 직전년도 소득증빙자료 원본 1부 '
    },
    {
      Col1: '대한교통학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '교통관련 학과 학부 3학년 학생 (2021년 12월 기준)성적이 우수하고/ 교통 전문성과 창조적 아이디어가 특출한 장학생',
      Col13: '해당없음',
      Col14: '2021-12-07~2022-02-21',
      Col15: '해당없음',
      Col16: ' * 총 8명각 대학별 교통관련 학과 학부 1명',
      Col17: '해당없음',
      Col18: '학과장 추천',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 장학금 신청서전년도 성적증명서 또는 이와 동등한 증명서교통주제 에세이(자율양식/ 5쪽 이내)'
    },
    {
      Col1: 'KAIST동문학술장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '월 500000원 X 10개월 X 3년',
      Col12: ' * KAIST 학사과정 2학년에 재학중인 학부생생활 곤란 지원 장학금 : 학업성적과 상관없이 한부모 및 조손가정의 가장 및 생활 극빈자동문회 및 학생회 기여 장학금 : KAIST 또는 총동문회 활동에 적극참여/ 학생 자치단체 일원으로 리더십과 책임감을 가진 자인재 장학금 : 뛰언나 재능과 역량을 지닌 자',
      Col13: '해당없음',
      Col14: '2022-02-01~2022-03-07',
      Col15: '2학년 우선 선발',
      Col16: '16명',
      Col17: '정규학기 초과자',
      Col18: ' * 지도교수/학과장 추천서 필수',
      Col19: '장학생 지원서성적증명서지도교수 또는 학과장 추천서생활곤란 증빙 서류기타 심사에 도움이 되는 서류'
    },
    {
      Col1: '대한국토도시계획학회',
      Col2: '학산박병주장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상',
      Col8: '공학계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원(장학금 수혜기간은 1년 간을 원칙으로 함)',
      Col12: '도시 및 지역계획 전공자로서 석사 혹은 박사과정을 2학기 이상 이수한자. 석사 또는 박사과정에 전념하고 기타 다른 장학금을 받고 있지 않은 자.',
      Col13: '해당없음',
      Col14: '2021-12-09~2022-01-21',
      Col15: '본 학회 장학생 선발위원회에서 대상자 선발',
      Col16: '해당 학교 학과단위 1명이내로 추천',
      Col17: '타장학금 수혜자',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 장학생 추천서(학회 소정 양식) (학과장 날인 필수)장학생 신청서(학회 소정 양식)연구실적목록(자유양식)성적증명서재학증명서 '
    },
    {
      Col1: '대한국토도시계획학회',
      Col2: '대한국토도시계획학회장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '각 대학교 도시공학과/ 도시 및 지역계획학과/ 기타 도시계획관련학과 학부 3/ 4학년 재학생 (2021기준)집안환경이 어려운 가운데에서도 성적이 우수하고 기타 다른 장학금을 받지 않는 자',
      Col13: '해당없음',
      Col14: '2021-12-09~2022-01-21',
      Col15: '해당없음',
      Col16: '해당 학교 학과단위 1명이내로 추천',
      Col17: '타장학금 수혜자',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 장학생 신청서(학회 소정 양식)장학생 추천서(학회 소정 양식) (학과장 날인 필수)성적증명서재학증명서 '
    },
    {
      Col1: '계룡장학재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적우수자',
      Col10: '저소득층으로 학비 조달이 어려운자(기초생활수급권 차상위계층 등)',
      Col11: '학기당 2000000원 * 장학금 지급정지 사유에 해당하지 않을시 지원(휴학 제적 자퇴 등)',
      Col12: '2022년도 대학교 입학예정자 또는 재학생',
      Col13: '해당없음',
      Col14: '2022-03-21~2022-04-04',
      Col15: '해당없음',
      Col16: '00명',
      Col17: '본 장학재단 이외(국가지원 대상자 포함)의 수혜를 받지 아니하는 자',
      Col18: '지도교수 추천',
      Col19: ' * 계룡장학재단 홈페이지 온라인 접수지도교수 추천서자기소개서성적증명서경제적 상황을 증명할 수 있는 서류(해당자)어학 능력 증명서(2020년 3월 ~ 2022년 3월 성적에 한함)주민등록등본통장사본 * 자세한 사항은 소속 학교 장학공지 참고'
    },
    {
      Col1: '한국도선사협회',
      Col2: '법학전문대학원장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '전문대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' 학기 5000000원 지급',
      Col12: '해기사(혹은 해사계열 전공) 출신의 법학전문대학원 신입생 또는 재학생해상법 과목을 수강했거나 수강예정인 학생 우대연세대학교 법학전문대학원의 추천 학생',
      Col13: '해당없음',
      Col14: '2022-07-26~2022-07-29',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '해당없음',
      Col18: '총장(학장) 추천 ',
      Col19: '장학금 신청서재학증명서성적증명서졸업증명서성적증명서이력서학업계획서주민등록등본'
    },
    {
      Col1: '대한약사회',
      Col2: '대한약사회장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원 (학기당 100만원)',
      Col12: '약학대학 학생',
      Col13: '해당없음',
      Col14: '2022-01-19~2022-01-24',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '이중 수혜 불가능과거 대한약사회 장학금 수여자는 지원 불가',
      Col18: '학(과)장 추천서',
      Col19: '신청서 서약서 성적증명서재학증명서추천서개인정보제공 동의서 * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수'
    },
    {
      Col1: '재단법인 한독제석재단',
      Col2: '약대장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학6학기',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3년 등록금 전액',
      Col12: '약대 재학생학업성적이 우수하고/ 가정형편이 어려운 학생약대 4학년 진학예정자',
      Col13: '해당없음',
      Col14: '2021-11-01~2021-12-10',
      Col15: '각 대학의 후보자 추천당 재단 장학금 운영위원회의 서류 및 면접 전형재단이사장 승인',
      Col16: '약학대 1명 (약대 4학년 진학 예정자)',
      Col17: '타 장학금 수혜자',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 자기소개서 1부장학생 추천서 1부전학년 성적증명서 1부보호자의 재산세 납부증명서 1부/소득금액증명원 1부'
    },
    {
      Col1: '재단법인 한독제석재단',
      Col2: '연구지원금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '의학 약학 각 20000000원',
      Col12: '의/약학 연구자의학/ 약학술 부문 각1편씩/ 총 2편학업성적이 우수하고/ 가정형편이 어려운 학생',
      Col13: '해당없음',
      Col14: '2021-11-01~2021-12-10',
      Col15: '전국 각 대학에서 추천 받은 후보자는 당 재단의 심사를 거친 후 최종 선발될 예정',
      Col16: '의학대(의대 본과 2학년 진학예정자)1명약학대(약대 4학년 진학 예정자)1명 ',
      Col17: '타 장학금 수혜자',
      Col18: '대한의학회/ 대한약학회의 추천',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 연구비지원 신청양식 학회 추천서'
    },
    {
      Col1: '재단법인 한독제석재단',
      Col2: '의대장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기',
      Col8: '의약계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3년 등록금 전액',
      Col12: '의대 본과 2학년 진학 예정자학업성적이 우수하고/ 가정형편이 어려운 학생',
      Col13: '해당없음',
      Col14: '2021-11-10~2021-12-10',
      Col15: '전국 각 대학에서 추천 받은 후보자는 당 재단의 심사를 거친 후 최종 선발될 예정',
      Col16: '1명',
      Col17: '타 장학금 수혜자',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 자기소개서 1부장학생 추천서 1부전학년 성적증명서 1부보호자의 재산세 납부증명서 1부/소득금액증명원 1부'
    },
    {
      Col1: '(재)관악회',
      Col2: '관악회장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점 2.7 이상인 자',
      Col10: '2학기 국가장학금 신청결과 소득6분위 이하',
      Col11: '1800000원 (생활비) * 타 등록금장학금과 중복수혜 가능 선한인재장학금과 중복수혜가능',
      Col12: '서울대학교 20222학기 학적 재학 상태인 학생',
      Col13: '해당없음',
      Col14: '2022-07-28~2022-07-29',
      Col15: '해당없음',
      Col16: '학과별 선별 인원 문의',
      Col17: '직전학기 평점 1.7미만규정학기 및 초과자/ 징계처분을 받은 경우 휴학생/ 휴학예정자 불가가',
      Col18: '해당없음',
      Col19: '국가장학소득구간확인서재학증명서성적증명서본인통장사본개인정보동의서 * 자세한 사항은 학부사무실 문의'
    },
    {
      Col1: '（재）형애장학회',
      Col2: '형애장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '해당없음',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점 3.6(4.5만점) 이상의 학생',
      Col10: '가정형편이 어렵고 모범적이며 성실한 학생한국장학재단 기준 소득분위 5~8분위 이내인 자',
      Col11: '수업료 전액',
      Col12: '타 장학금을 수혜하지 않는 자 지방출신 학생 및 저학년 학생 우선선발',
      Col13: '지방출신 대학생 우선 선발',
      Col14: '2022-08-09~2022-08-15',
      Col15: '1차 서류2차 신규 선발시 재단 방문 필요',
      Col16: '0명  * 학교별 선발인원 다름',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 재단이 선정한 학교에서 학생을 추천하는 방식으로/ 신청시 각 학교 장학부서에 문의 필수재학증명서성적증명서 신규장학생 추천서(지도교수 추천)개인정보수집등 동의서'
    },
    {
      Col1: '현대자동차그룹',
      Col2: '계약학과(산학장학생)',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원/특정대학',
      Col7: '대학7학기/대학8학기이상/석사신입생(1학기)',
      Col8: '공학계열',
      Col9: '학부 성적 B 이상',
      Col10: '해당없음',
      Col11: '석사 기간 입학금/등록금 전액 지원석사 졸업 후 연구소 입사 연계현업 연구원 멘토링산학 연구과제 연구비우수자 해외연수최신기술 세미나',
      Col12: '2023년 3월 한양대 미래모빌리티학과 석사과정 입학 가능한 졸업(예정/휴학)자타 대학 졸업(예정)자 지원가능남성의 경우 병역 필 또는 면제소프트웨어 관련 전공   * 자세한 사항은 홈페이지 참고',
      Col13: '해당없음',
      Col14: '2022-09-05~2022-09-19',
      Col15: '서류접수 >  인성검사+대학원 면접 > 회사면접 > 대학원전형 > 건강검진 및 합격자 발표',
      Col16: '해당없음',
      Col17: '해외여행에 결격사유 있는 자 제한병역특례 지원불가',
      Col18: '해당없음',
      Col19: '  * 온라인 지원(www.hyundaischolar.com) 지원하기 > 지원서 작성'
    },
    {
      Col1: '현대자동차그룹',
      Col2: '연구장학생(산학장학생)',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열',
      Col9: ' * 공통 : 학부 성적 기준 평점 \'B\' 이상',
      Col10: '해당없음',
      Col11: '졸업 후 현대자동차그룹 내 지원회사 입사장학금 (석사 135만원/월 박사 170만원/월)현업 연구원 멘토링기술과제 수행비스마트 기기 제공',
      Col12: ' * 모집하는 부서/회사마다 상이하므로 홈페이지 공고 참고 필수석사 : 1 ~ 3학기 재학생박사 : Cousework 수료 이후 2년 이내 지원 재학생 ',
      Col13: '해당없음',
      Col14: '2022-09-05~2022-09-19',
      Col15: '서류접수 > 인성검사 > 회사면접 > 건강검진 > 합격자발표',
      Col16: '00명',
      Col17: '병역필/ 면제자에 한함(병역특례 지원 안 됨)해외 여행에 결격사유가 있는 자',
      Col18: '해당없음',
      Col19: ' * 온라인 접수(www.hyundaischolarship.com) > 지원하기 > 지원서 작성지원서자기소개서역량기술서(성적증명서는 면접전형 시 제출) (석/박사 제출서류)'
    },
    {
      Col1: '현대자동차그룹',
      Col2: '트랙장학생(산학장학생)',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학5학기',
      Col8: '공학계열',
      Col9: '학부 성적 기준 평점 B 이상',
      Col10: '해당없음',
      Col11: '4개 학기 등록금 지급 (\'18.2월 장학생 선발 후 3학년 등록금 소급 지급)',
      Col12: ' * 국민대학교자동차공학과/ 자동차IT융합학과 * 울산대학교기계자동차전공 * 한동대학교기계제어공학부/ 전산전자공학부병역필/ 면제자에 한함(병역특례 지원 안됨)해외여행에 결격 사유가 없는 자',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '1차 서류2차 인적성검사3차 면접4차 건강검진',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '지원서자기소개서학업계획서'
    },
    {
      Col1: '서울특별시간호사회',
      Col2: '한마음장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/전문대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '석사 : 1000000원박사 : 1500000원 * 장학금 지급 후 1년 이내에 완성된 논문을 서울간호학술대회에서 발표',
      Col12: '2021년 보수교육이수자 혹은 2021 등록회원간호사로서 모든 분야2021년도 학위논문연구계획서를 제출한 자',
      Col13: '해당없음',
      Col14: '2021-10-26~2021-11-19',
      Col15: '해당없음',
      Col16: '석사과정 : 15명박사과정 : 5명',
      Col17: '기존 한마음장학금 수혜자는 심사대상에서 제외 ',
      Col18: '지도교수 혹은 간호부서장 추천서 ',
      Col19: '신청서 블라인드 처리된 학위논문연구계획서이력서회원증 사본지도교수 혹은 간호부서장 추천서자료제출 : sna@seoulnurse.or.kr'
    },
    {
      Col1: '대한간호협회',
      Col2: '백양이영복장학금',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/전문대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '총 3000000원',
      Col12: '대학원에서 간호학을 전공하는 자로서 아래 분야 논문의 연구계힉서를 제출한 자 * 간호행정(간호역사/ 간호철학/ 간호윤리/ 간호관리/ 간호경영/ 간호정책 포함)대한간호협회 회원',
      Col13: '해당없음',
      Col14: '2021-10-18~2021-11-04',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: ' * 자세한 사항은 선발 기관으로 문의 바랍니다.',
      Col18: '학(과)장의 추천서 제출',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 장학금 신청서논문 연구계획서간호대학(과)장 추천서회원증 사본'
    },
    {
      Col1: '창강재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '사회계열/특정학과',
      Col9: '직전학기 평점평균 3.5 이상인 자 * 재단에서 대학교로 추천을 의뢰하는 장학금으로/ 학교마다 성적기준이 상이할 수 있음',
      Col10: '222 한국장학재단 학자금지원구간 5~8구간 이내',
      Col11: '등록금 전액',
      Col12: '222학기 정규학기 재학예정자생각이 온건하고 품행이 단정한 자',
      Col13: '해당없음',
      Col14: '2022-07-18~2022-08-03',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '규정학기 초과자타 장학금 수혜자 ',
      Col18: '지도교수 또는 지도교수의 추천서 제출',
      Col19: '장학생지원서지도교수 추천서서약서장학생신상기록카드개인신용정보제공 및 활용 동의서 * 재단 양식에 따라 작성하여 제출'
    },
    {
      Col1: '재단법인 유당장학재단(서울)',
      Col2: '유당장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학년 (2개 학기) 성적 백분위 80점 이상인 자 ',
      Col10: '가정형편이 어려운 자 ',
      Col11: '선발된 학생의 성적 및 가정형편을 감안하여 차등 지급 * 등록금성 장학',
      Col12: '20222학기 기준 정규학기 재학생봉사정신이 투철한 자',
      Col13: '해당없음',
      Col14: '2022-08-11~2022-08-15',
      Col15: '해당없음',
      Col16: '25명 내외(계속 장학생 포함)',
      Col17: '해당없음',
      Col18: '소속대학 단과대 학장 이상',
      Col19: '장학금 지원 신청서자기 소개서학교추천서성적 증명서 가족관계증명서2021년도 세목별 과세 증명서(보호자)2021년도 건강보혐료 납부확인서(보호자)통장사본  * 자세한 사항은 각 학교 장학부서 문의'
    },
    {
      Col1: '청합장학회',
      Col2: '청합장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '특정대학',
      Col7: '대학2학기',
      Col8: '공학계열/인문계열/특정학과',
      Col9: '해당없음',
      Col10: '가정형편이 넉넉하지 못한 자',
      Col11: '등록금 전액(계속 지원 기준 충족시 졸업시까지 지원)',
      Col12: ' * 서울대학교 경영대/ 공대/ 인문대 1학년 재학생학교 성적이 우수하며 면학자세가 성실한 자사상이 건전하고 품행이 방정하며 타인의 모범이 되는 자가정형편이 넉넉하지 못한 자',
      Col13: '해당없음',
      Col14: '2022-07-12~2022-07-14',
      Col15: '해당없음',
      Col16: '공과대학 2명경영대학 1명인문대 1명',
      Col17: ' * 계속 지원 중지 사유대학으로부터 징계 처분을 받았을 경우.장학금을 학업과 전연 관련이 없는 용도에 사용했을 시.전액등록금에 대한 중복 장학금을 지급 받았을 경우.휴학/ 입영 또는 기타사유로 1학기 이상 학업을 계속할 수 없을 경우규정학기 초과자/ 휴학예정자',
      Col18: '총·학장 추천서 제출',
      Col19: '장학생 지원서학장추천서성적증명서가족관계증명서주민등록등본세대주 2021년 지방세 세목별 (비)과세 증명서개인정보 수집이용 및 제공동의서'
    },
    {
      Col1: '(재)부남장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 이수/ 직전학기 평점평균 3.0 이상인 자 * 재단에서 학교측으로 추천을 의뢰하는 장학금으로/ 성적기준이 학교마다 상이할 수 있음',
      Col10: '가정형편이 어려운 학생 ( 한국장학재단 소득분위 8분위 이내인자)',
      Col11: '2000000 * 등록금 보조 또는 생활비지원',
      Col12: '2022학년도 2학기 기준 재학생3학기~6학기생 * 재단에서 선정한 학교로 추천을 의뢰하는 방식으로/ 신청시 각 학교 장학부서에 문의 필수',
      Col13: '해당없음',
      Col14: '2022-07-21',
      Col15: '22학년도 1/2학기 교외/기금 장학금 미수혜자22학년도 2학기 한국장학재단 소득구간 낮은 자직전학기 성적 우수한 자직전학기 이수학점 많은 자전체학기 성적 우수한 자저학기생 우선',
      Col16: 'O명',
      Col17: '휴학생 및 휴학예정자 불가기준성적 미만자',
      Col18: '해당없음',
      Col19: ' * 재단에서 선정한 학교로 추천을 의뢰하는 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 장학금 신청서재학증명서개인정보 수집·이용 및 제공·조회 동의서소득구간 확인서반명함판 사진'
    },
    {
      Col1: '봉신장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학5학기',
      Col8: '공학계열',
      Col9: '전년도 성적평점이 3.3/4.3이상',
      Col10: '소득분위 6~8분위 학생 중',
      Col11: '등록금 전액(한 학기 지원)',
      Col12: '서울대학교 공과대학 학부 4학년 재학생',
      Col13: '해당없음',
      Col14: '2021-09-10~2021-09-14',
      Col15: '직전 학기 성적 상위자 순',
      Col16: '추천인원 2명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.  학과(부)장 추천서성적증명서주민등록등본학습계획서개인정보수집이용 및 제공동의서반명함판 또는 증명사진 1매'
    },
    {
      Col1: '현송교육문화재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기',
      Col8: '공학계열',
      Col9: '전년도 학업성적 평점 B+(3.3/4.3) 이상인 학생',
      Col10: '학비조달에 어려움을 겪는 학생 우선 선발',
      Col11: '1인당 연간 6000000원(생활비 및 학업장려금) (2분할 지급)',
      Col12: ' * 현송교육문화재단에서 추천하는 학교의 재학생각 대학별 지원 가능 학과는 홈페이지 참조',
      Col13: '해당없음',
      Col14: '2022-01-10~2022-01-18',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '주임교수 추천을 받은 자',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.  추천서장학금 신청원서성적증명서장학금수혜증명서보호자 건강보험 납입증명서보호자 재산세 납세증명서'
    },
    {
      Col1: '무진과학기술장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '석사신입생(1학기)',
      Col8: '공학계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '사립대 : 2년간 매 학기당 3500000원 씩 지급함(졸업시까지) 국립대 : 2년간 매 학기당 2500000원 씩 지급함(졸업시까지)',
      Col12: '전국 각 대학교의 이/공과 졸업생으로 2022년도 대학원 이/ 공과에 입학이 확정되고 출신학교 총장의 추천을 받은 자로 가정형편이 외부 원조를 필요로 하는 자 ',
      Col13: '해당없음',
      Col14: '2022-01-04~2022-01-31',
      Col15: '1차 : 장학회 신원단의 서류 심사2차 : 면접심사',
      Col16: ' * 각 대학교 1명만 추천',
      Col17: ' * 수혜자 의무 사항수혜학생은 매 학기 본 장학회에 직접 출두하여 장학금 지급받되 전학기의 성적증명을 제출할 것.전 학기 성적이 현저히 불량할 경우에는 후기 장학금이 취소될 수도 있음. 수혜학생은 1년에 한번씩 현재 근황을 보고할 것. ',
      Col18: '대학 총(학)장',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.  출신 또는 재적 대학총장의 추천서장학지원서자기소개서출신대학교 전학년 성적표지도교수 의견서'
    },
    {
      Col1: '성암육영회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 백분위 성적이 80점 이상인 자',
      Col10: '221학기 한국장학재단 학자금 지원구간 8구간 이내',
      Col11: '1500000원',
      Col12: '2022학년도 2학기 학부 정규등록 예정생사상이 건전하고 학업에 충실한 자품행이 방정하여 타인에게 촉망받는 자장차 국가사회에 유익하게 기여하리라고 인정되는 자',
      Col13: '해당없음',
      Col14: '2022-07-19',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '해당없음',
      Col18: '학교 추천 장학금으로/ 소속 대학 장학팀으로 문의',
      Col19: '장학금지급신청서추천서성적증명서이력서제적등본부양자 재산세 납세증명서 또는 비과세 증명서주민등록등본서약서개인정보 제공 동의서 * 자세한 사항은 학교 장학 공지 참고'
    },
    {
      Col1: '춘천지역로타리장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점 평균 3.0이상/ 직전학기 이수학점 12학점 이상',
      Col10: '기초생활수급자 (0분위)',
      Col11: '700000원',
      Col12: '학부재학생장학금 수여식에 참석 가능한 자 ',
      Col13: '춘천지역 고교출신 재학생',
      Col14: '2021-01-29~2021-02-03',
      Col15: '해당없음',
      Col16: '6명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원서 및 추천서재학증명서주민등록등본개인정보 활용 동의서 통장사본성적증명서20211학기 한국장학재단 학자금 지원구간 통지서서'
    },
    {
      Col1: '한국섬유산업연합회장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/사회계열/예체능계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '연간 6000000원(학기당 3000000원)',
      Col12: '섬유패션업계 종사자 자녀 중 섬유와 패션관련학과를 전공하는 대학 및 대학원생 2019년 현재 재학 중인 자',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '*신청서 접수장학생 신청서/ 개인정보 수집이용 동의서(메일/ 우편/ 방문접수)*장학생 후보자로 선발된 자에 한해 제출재학생(재학증명서/전학년 성적증명서/ 자기소개서)부모님(재직증명서/소속사 사업자등록증 사본/주민등록등본)'
    },
    {
      Col1: '용인시장학재단',
      Col2: '무지개 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '500000원',
      Col12: '다문화 가정 중 학생 1인 * 신청자가 많을수록 다자녀 순으로 선발 ',
      Col13: '공고일 현재/ 계속하여 2년 이상 용인시에 주민등록을 두고 거주한 시민 및 직계비속 (필요한경우 가족관계증명서 첨부)',
      Col14: '2022-03-16~2022-04-14',
      Col15: '다문화 가정 중 학생 1인신청자가 많을시 다자녀 순으로 선발 (동일 자녀수에서는 나이가 많은 순으로 선발)',
      Col16: '20명',
      Col17: '당해연도 타 장학금을 받은 자',
      Col18: '대학(총)장 또는 소속학교장',
      Col19: '장학금 지원신청서장학금 지원대상자 추천서주소이력을 포함한 주민등록 등본장학금 비수혜 확인서재학증명서개인정보수집/ 이용/ 제공 및 조회 동의서개인정보수집에 따른 법정대리인 동의서  * 경수고속도로(주)기탁금으로 지원하며 장학생의 기본정보를 경수고속도로에 제공하게 되어 동의서 필요'
    },
    {
      Col1: '용인시장학재단',
      Col2: '자립장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 장학금 지원자 선발은 최종 두개 학기 성적의 평균 평점으로 선발 함',
      Col10: '생계급여 수급자 및 차상위 계층 (한국장학재단 소득분위 3분위 이내 인 자)',
      Col11: '등록금범위 내 2500000원',
      Col12: '해당없음',
      Col13: '공고일 현재/ 계속하여 2년 이상 용인시에 주민등록을 두고 거주한 시민 및 직계존비속',
      Col14: '2022-03-16~2022-04-14',
      Col15: '신청자가 많을시 소드분위가 낮은 순으로 선발 (동일 소득분위ㅏ에서는 성적순으로 선발)',
      Col16: '40명',
      Col17: '해당없음',
      Col18: '대학(총)장',
      Col19: '장학금 지원신청서장학금 지원대상자 추천서개인정보수집/이용제공 및 조회동의서신청인 서약서주소이력 포함 주민등록 등본성적증명서장학금 비수혜(수혜) 확인서 재학증명서소득분위 3분위 이내 확인서  정보제공 동의서 * 모든 제출 서류는 공고일 이후 발급분만 인정 함'
    },
    {
      Col1: '용인시장학재단',
      Col2: '학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '기초생활 수급자 차상위계층 또는 소득분위 1~10분위 대학생',
      Col11: '2020년 발생이자 전액',
      Col12: '한국장학재단에서 학자금(일반·취업후상환 학자금/ 등록금) 및 생활비 대출을 받은 대학교 재학생',
      Col13: '공고일 현재 용인시에 주민등록을 두고 2년 이상 계속하여 거주하고 있는 시민 및 그 자녀',
      Col14: '2021-09-15~2021-10-30',
      Col15: '소득분위 순으로 선발',
      Col16: '해당없음',
      Col17: '경기도 등 기타 기관에서 2019년 학자금 대출이자를 중복해서 지원받은 자한국장학재단 이외의 학자금 대출자대학교 졸업생/ 대학원생군휴학생(일반 휴학생 신청가능)',
      Col18: '해당없음',
      Col19: '지원신청서주민등록등본 또는 초본개인정보 수집 및 이용·제공 동의서재학증명서 또는 제적증명서 또는 휴학증명서 * 자세한 사항은 기관 홈페이지 > 학자금대출이자 지원사업 안내페이지 참조'
    },
    {
      Col1: '(사)의령군장학회',
      Col2: '대학진학장학금 ',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '관내 고등학교 졸업생으로 수시전형 또는 수능 성적 일정 기준 이상을 받고 우수대학교에 진학하는 학생탐구과목이 포함된 경우에는 상위 2개 탐구과목 평균하여 등급 산출',
      Col10: '해당없음',
      Col11: '300000~5000000 원 * 내신/수능성적에 따라 지급금액 상이하므로 첨부파일 참조',
      Col12: '관내 고등학교 졸업생으로 내신성적이나 수수능성적이 일정기준 이상으로 대학에 진학한 학생',
      Col13: '신청일 현재 의령군 관내 6개월 이상 계속해서 주소를 두고 있는 군민 또는 그 자녀(학생)관내 고등학교 졸업생',
      Col14: '2021-03-08~2021-04-09',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '예체능(음악/ 미술/ 체육) 제외 ',
      Col18: '해당없음',
      Col19: ' 최종등록대학 납입고지서 내신 및 수능 성적표 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(사)의령군장학회',
      Col2: '대학생학자금이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2016. 10. 19 이후 한국장학재단에서 받은 학자금 대출금의 2021년 1월 ~ 6월까지 발생한 대출이자 지원',
      Col12: '해당없음',
      Col13: '학자금 이자지원 신청일 현재 1년이상 본인 또는 직계존속이 의령군에 주민등록을 두고 있는 대학생(대학원생)',
      Col14: '2021-05-03~2021-06-04',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서(구비서류 포함)및 개인정보 제공동의서 1부 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: 'CJ대한통운',
      Col2: 'GTrack(SCM클래스)',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학5학기/대학6학기',
      Col8: '사회계열/특정학과',
      Col9: '학점 총점 평균 3.0이상(4.5기준) * 직무별 필수언어 테스트 성적 기준TOEIC Speaking : Lv.6이상OPlc/ OPI(영어) : IM 이상',
      Col10: '해당없음',
      Col11: '4학년 1학기 ~ 4학년 2학기의 등록금 전액 지원입사 : 21년 하반기 대졸 공채로 입사',
      Col12: '연계대학 물류 관련 전공자 중 3학년 2학기 재학생(2022년 2월 내 졸업 가능자)이며 인턴쉽 진행 가능한 자직무별 필수언어 TEST 성적 1개 이상 보유자 * 모집분야 : CL(계약물류)/ 택배',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '서류 심사TEST 및 1차 면접1차 인턴십 및 2차 인턴십 진행',
      Col16: '해당없음',
      Col17: '군미필자/ 해외여행 결격사유 있는자물류 관련 미전공자인턴십 미수료 및 중도 포기 시 장학금 전액 환급 및 GTrack 이탈 처리',
      Col18: '해당없음',
      Col19: ' * CJ그룹 채용 홈페이지를 통한 온라인지원'
    },
    {
      Col1: 'CJ대한통운',
      Col2: 'GTrack(글로벌클래스)',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학4학기/대학5학기',
      Col8: '인문계열/특정학과',
      Col9: 'ㅡ학점 총점 평균 3.0 이상인 자 (4.5만점 기준) * 직무별 전공 언어 성적 기준TOEIC Speaking : Lv.6이상OPl/ OPlc : IM1 이상',
      Col10: '해당없음',
      Col11: '4학년 1학기 2학기의 등록금 전액 지원입사 : 21년 하반기 대졸 공채로 입사 ',
      Col12: '어학 관련 전공자 중 3학년 2학기 재학생(2022년 2월 내 졸업 가능자) 이며 인턴쉽 진행 가능자으로 직무별 전공 언어 성적 기준 소유자 * 모집 분야 : CL(계약물류)/ 택배 ※ 자세한 사항은 홈페이지 및 첨부파일 참조',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '서류 전형TEST 및 1차 면접1차 인텁십 및 2차 인턴십 진행',
      Col16: '해당없음',
      Col17: '군미필자 및 해외여행 결격사유 있는 자인턴십 미수료 및 중도 포기 시 장학금 전액 환급 및 GTrack 이탈 처리',
      Col18: '해당없음',
      Col19: ' * CJ그룹 채용 홈페이지를 통한 온라인지원'
    },
    {
      Col1: '강원도청',
      Col2: '탄광지역저소득층장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(재학생) 이수학점 12학점 이상/ 백분위 70점 이상(졸업학기) 백분위 70점 이상 * 교환/편입 등 직전학기 성적산출 불가능한 경우/ 성적 산출된 최근 학기 기준',
      Col10: ' * 기초생활수급·차상위계층 복지증명서 발급자국민기초생활수급자 증명서(생계 / 의료 / 주거 / 교육급여)차상위계층 증명서(한부모가족증명서 차상위 자활급여 대상자 증명서 등)',
      Col11: ' * 입학금 수업료 기성회비신입생 : 4000000원 (1학기한)재학생 : 3000000원 (학기당) ( 타 학자금이 지원되는 경우 등록금 총액 범위 내 차액 지원)',
      Col12: '폐광지역 내에 거주하는 저소득층 대학생',
      Col13: '학생 본인 또는 자녀가 학자금 신청일 기준 6개월 이전부터 폐광지역진흥지구(태백/ 삼척 도계/ 영월/ 정선) 내에 주민등록이 되어 있으면서 주민센터에서 실제 거주여부가 확인되어야 함',
      Col14: '2021-03-15~2021-04-16',
      Col15: '해당하는 주소지의 시청 홈페이지 공고 참조',
      Col16: '총 1/448명 (태백 697명/ 삼척 135명/ 영월 358명/ 정선 258명)',
      Col17: '평생교육원/ 외국소재 대학 재학생 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '학자금 신청서개인정보 동의서성적증명서입학금/등록금 납부 영수증 사본주민등록등본가족관계증명서통장 사본복지증명서 (택1) * 자세한 사항은 거주 시청 홈페이지 내 공고문 참조'
    },
    {
      Col1: '진암장학재단(매일유업)',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 총 평점 3.5/4.5(3.3/4.3) 이상인 자',
      Col10: '경제적 여건이 어려워 학비 보조를 필요로 하는 자',
      Col11: '등록금 전액액',
      Col12: '대학 재학중인자 중 품행이 단정하고 학업성적이 우수한 자',
      Col13: '해당없음',
      Col14: '2021-02-09',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '휴학예정자 및 학교를 중퇴하여 학업을 중단할 경우징계처분을 받은 경우 및 기타 부적격자로 인정된 경우',
      Col18: '해당없음',
      Col19: '진암장학생 지원서자기소개서교수추천서재학증명서성적증명서건강보험료 납부 확인서 (해당자)'
    },
    {
      Col1: '나사렛대학교',
      Col2: '학업안정장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가계경제가 곤란한 자 ※ 자세한 사항은 첨부파일 참조',
      Col11: '수업료 범위 내 최대 반액까지 지급',
      Col12: ' * 나사렛대학교 재학생으로/ 최근 6개월 이내 아래 사항 하나 이상 해당자부모님의 실직 또는 사업체 부도 / 부모가 장애인 / 직계가족의 장기 투병 / 자연재해 및 가축전염병으로 피해입은 축산업자 가정 / 최근 부모의 사망 / 다문화가정 / 다자녀 가정으로 2명 이상이 대학 재학 / 이외 경제적 곤란 상황',
      Col13: '해당없음',
      Col14: '2022-03-30~2022-04-07',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서신청자격 조건에 따른 증빙서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '중부대학교',
      Col2: '중부사랑장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '학기당 1000000원',
      Col12: '중부대학교 재학생으로 장애의 정도가 심한 장애인인 자 (기존 1급 ~ 3급인 자)',
      Col13: '해당없음',
      Col14: '2022-04-20~2022-04-26',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '휴학/ 미등록/ 8학기 초과자는 장학금 수혜 불가',
      Col18: '해당없음',
      Col19: '장학금신청서 1부개인정보동의서 1부장애인증명서 1부'
    },
    {
      Col1: '예향교회',
      Col2: '일반장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정형편을 고려하여 선발',
      Col11: '1000000원',
      Col12: '현재 세례교인 이상전문대 포함 교육부에서 인정한 대학생',
      Col13: '해당없음',
      Col14: '2022-01-23~2022-02-06',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '3회 초과 기수혜자',
      Col18: '목자와 담당부서장 혹은 다음세대 추천자의 추천서 제출',
      Col19: '지원서추천서재학증명서(재학생)합격통지서(신입생)장학금 수혜 자기 평가설문자기소개서* 예향교회 홈페이지에서 지원서/ 추천서를 다운 받아 작성할 것'
    },
    {
      Col1: '녹색교통',
      Col2: '교통사고유자녀희망장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 1500000원',
      Col12: '부모님의 교통사고로 경제적인 어려움을 겪고 있는 대학 재학생 (전문대 포함)',
      Col13: '해당없음',
      Col14: '2021-12-21~2022-01-04',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '국가장학금 및 타기관 장학금으로 등록금의 전액을 수혜 받은 학생 제외',
      Col18: '해당없음',
      Col19: '장학금 신청서/ 활용 계획서/ 개인정보 수집동의서주민등록등본소득증명서류교통사고 사실 확인 증명서류 재학증명서성적증명서등록금 납부 영수증 또는 교육비 납부 증명서장학금 수혜 및 비수혜 확인서장학생 명의 통장사본 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '요안나장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '평균 성적 B학점 이상 (80점이상)',
      Col10: '국민기초생활수급자로 선정되지 못한 자로 가정형편이 어려운 사각지대 대상자',
      Col11: '2000000원  연간 1000000원 ',
      Col12: '현재 재학중인 대학생 및 입학예정자',
      Col13: '해당없음',
      Col14: '2021-01-28~2021-02-02',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '휴학중인 자 (1학기이상)교내 봉사 이상의 징계처분을 받은 자장학생 선발과정에 허위사실이 발견된 자기타 사유로 운영위원회의 의결이 있는 자',
      Col18: '해당없음',
      Col19: '장학생 추천서자기소개서가족관게증명서생활기록부 또는 성적증명서재학증명서 또는 입학허가서장학사업 개인정보 수집이용제공 동의서 '
    },
    {
      Col1: '(재)사람사는세상노무현재단',
      Col2: '노무현장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업에 대한 의지와 열정이 높은 학생',
      Col10: '해당없음',
      Col11: '4000000원 연 2회 분할 지급(200만원x2회)',
      Col12: '노무현대통령의 정신과 삶에 대한 이해가 깊고 이를 계승하는 노력을 해왔으며 앞으로도 지속적으로 실천할 의지와 전망을 가지고 있는 학생민주주의와 진보/ 혁신/ 평화/ 통일/ 공동체 등의 가치에 대한 소신을 가지고 사회 변화를 위해 행동하며 이를 지속해 나갈 의지와 전망을 가진 학생민주주의 리더쉽을 인정 받고 미래의 꿈을 향하는 학생',
      Col13: '해당없음',
      Col14: '2021-10-21~2021-12-31',
      Col15: '서류심사 및 면접 심사',
      Col16: '24명명',
      Col17: '기선발자(장학생)의 중복 신청을 제한함 ( 2020년 이전 고등부문 선발자의 경우 대학생 지원가능)지원서 내용으로 확인된 내용과 다를 경우',
      Col18: '후원회원 (선택사항)',
      Col19: ' * 필수서류신청서자기소개서노무현 대통령 관련 콘텐츠 비평 및 감상개인정보수집이용/ 동의서필수증빙서류 * 선택사항후원회원 추천서가계곤란 중빙서류   중 어느 하나에 해당하는 학생은 관련 증빙서류 추가 제출 시 가산점을 부여함 * 면접 심사시 : 주민등록등본/ 재학증명서 혹은 연구생 증명서 제출'
    },
    {
      Col1: '박신양FUN장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '연기/극작 장학생 및 장착지원금 100만원',
      Col12: '1. 서울예술대학교 연기 / 극작 장학생2. 동국대학교 연기 장학생3. 일반 장학생(20세 이상 학교/ 전공 상관 없음)',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-17',
      Col15: '1차 오디션(동영상)2차 개별 오디션',
      Col16: '* 연기 장학생 (영화/ 연극/ 연기/ 방송연기 등)   : 2명 선발 * 극작 장학생 (극작과 및 문예창작과)   : 1명 선발 *창작지원금 (연기 / 극작)학교 학과 상관없음 : 00명 선발',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '연기 신청서 / 자기소개 및 연기 동영상(해당자)극작 신청서 / 자기소개 동영상 / 작품(해당자)신청서 양식(블로그 참조)*모든 파일명은 반드시 \'이름학교학년전공2020\'으로 작성*사진은 반드시 신청서 내에 첨부*동영상 처음에 이름학교학년전공 표시(자막 또는 종이에 써서 화면전체에 3초 이상 보이도록)*핸드폰 촬영 가능1)연기전공3분이내(자기소개 및 자유연기/ 이전 출연했던 영화/ 연극/ 드라마의 영상은 제외)2)극작전고3분 이내 자기소개'
    },
    {
      Col1: '성공회대학교',
      Col2: '복지장학금(열림)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 이수학점 12학점 이상 직전학기 평균평점 1.5이상',
      Col10: '경제적 사정이 곤란한 기초생활수급권자 차상위계층 학생',
      Col11: '1500000',
      Col12: '성공회대학교 재학생 * 신/ 편/ 재입학/ 복학생국가장학금 신청 필수(소득분위 통과자)',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: ' * 모든 학비감면장학금은 등록금 한도내에서 이중수혜 가능하나/ 분류별 장학금의 이중수혜는 불가',
      Col18: '해당없음',
      Col19: '없음(온라인 신청만으로 ‘접수완료’)'
    },
    {
      Col1: '성공회대학교',
      Col2: '복지장학금(나눔)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 이수학점 12학점 이상 직전학기 평균평점 1.5이상',
      Col10: '해당없음',
      Col11: '수업료 범위 내800000 ~ 1200000원',
      Col12: '성공회대학교 재학생 * 신/ 편/ 재입학/ 복학생경제사정이 곤란한 장애학생 본인 또는 부·모의 장애 정도에 따라 선발',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서장애인증명서가족관계증명서(또는 등본) * 제출서류는 주민등록번호(본인 및 가족)의 뒷자리가 노출되지 않은 증명서로 제출 바랍니다.  * 자세한 사항은 첨부자료 또는 성공회대학교 장학게시판 참고'
    },
    {
      Col1: '성공회대학교',
      Col2: '복지장학금(섬김)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 이수학점 12학점 이상 직전학기 평균평점 1.5이상',
      Col10: '경제적 사정이 곤란한 국가장학금 소득 1~8구간(분위)',
      Col11: '수업료 범위 내 지급',
      Col12: '성공회대학교 재학생 * 신/ 편/ 재입학/ 복학생국가장학금 신청 필수 (소득분위 통과자)',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '없음(온라인 신청만으로 ‘접수완료’)'
    },
    {
      Col1: '성공회대학교',
      Col2: '복지장학금(희망)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 이수학점 12학점 이상 직전학기 평균평점 1.5이상',
      Col10: '기타 경제사정이 곤란한 학생',
      Col11: '수업료 범위 내',
      Col12: '성공회대학교 재학생 * 신/ 편/ 재입학/ 복학생',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 온라인 신청서 제출만으로 신청완료 ** 증빙서류 제출해야할 시 오프라인으로 제출신청서(신청사유 자세히 작성)가계곤란 증빙서류(선택)'
    },
    {
      Col1: '성공회대학교',
      Col2: '특별장학금(국가유공자)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '수업료 50% 또는 100%',
      Col12: '성공회대학교 재학생 * 신·편/ 재입학/ 복학생국가유공자 및 그 배우자와 직계자녀',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서대학수업료 면제대상자 증명서(입학시 1회 제출) * 제출서류는 주민등록번호(본인 및 가족)의 뒷자리가 노출되지 않은 증명서로 제출 바랍니다.  ** 제출서류는 최초 신청시에만 제출'
    },
    {
      Col1: '성공회대학교',
      Col2: '특별장학금(가족)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 이수학점 12학점 이상 직전학기 평균평점 1.5 이상',
      Col10: '해당없음',
      Col11: '500000원',
      Col12: '성공회대학교 재학생 * 신/ 편/ 재입학/ 복학생본교에 형제자매/ 부부/ 부모자녀가 2인 이상 재학하는 경우',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서재학증명서가족관계증명서(또는 등본) * 제출서류는 주민등록번호(본인 및 가족)의 뒷자리가 노출되지 않은 증명서로 제출 바랍니다.  ** 신청서 신청사유에 재학 중인 가족의 인적사항(이름/학번/관계) 작성'
    },
    {
      Col1: '성공회대학교',
      Col2: '특별장학금(5.18유공자)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '수업료 50% 또는 100%',
      Col12: '성공회대학교 재학생 * 신/ 편/ 재입학/ 복학생5.18유공자 및 그 배우자와 직계자녀',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '8학기 초과자 제한',
      Col18: '해당없음',
      Col19: '신청서대학수업료 면제대상자 증명서(입학시 1회 제출) * 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '성공회대학교',
      Col2: '노동장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000',
      Col12: '성공회대학교 재학생 * 신/ 편/ 재입학/ 복학생노동조합상근자 및 해고자 본인 및 자녀난민 또는 인도적체류허가자 등',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 오프라인으로만 신청가능신청서상근자 또는 해고 증명서가족관계증명서(또는 등본) * 제출서류는 원본 * 제출서류는 주민등록번호(본인 및 가족)의 뒷자리가 노출되지 않은 증명서로 제출 바랍니다. '
    },
    {
      Col1: '성공회대학교',
      Col2: '특별장학금(교직원/성직자가족)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 이수학점 12학점 이상 직전학기 평균평점 1.5이상',
      Col10: '해당없음',
      Col11: '수업료 50% 또는 100%',
      Col12: '성공회대학교 재학생 * 신/ 편/ 재입학/ 복학생한국장학재단의 국가장학금 반드시 신청재직 중인 교직원 및 대한성공회 성직자 본인/ 배우자/ 직계자녀',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 온라인 신청 시 신청사유에 재직 중인 가족의 인적사항(이름/관계) 작성 필수 ** 교직원 가족 장학금은 최초 신청 시에만 재직증명서/ 가족관계증명서 제출신청서재직증명서가족관계증명서 또는 등본'
    },
    {
      Col1: '성공회대학교',
      Col2: '경진대회장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 첨부파일 참조100000원 ~ 1000000원',
      Col12: '성공회대학교 재학생진로 및 전공과 유관한 교외 경진대회의 수상실적(장학금 신청일자 기준 6개월 이내의 수상 실적)이 있는 당해학기 재학생',
      Col13: '해당없음',
      Col14: '2021-11-23~2021-12-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 오프라인으로만 신청가능 신청서대회참가 증빙서류입상 증빙서류기타 증빙서류 * 제출서류는 주민등록번호(본인 및 가족)의 뒷자리가 노출되지 않은 증명서로 제출 바랍니다. '
    },
    {
      Col1: '에몬스장학회',
      Col2: '에몬스장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 평균 평점 백분위 87점 또는 3.5/4.5 (3.3/4.3)점 이상인 자 ',
      Col10: '해당없음',
      Col11: '5000000원 (팀별)',
      Col12: '대한민국 국적 보유자로 국내 대학 재학생 및 2022년 등록 예정자 차세대 리더로서 수월성과 리더십이 입증되고 성장 가능성과 잠재성이 있는 우수한 인재 ',
      Col13: '해당없음',
      Col14: '2022-07-01~2022-07-07',
      Col15: '소득수준/ 학업성적/ 인성/ 장래성 고려 ',
      Col16: '12팀 선발 ',
      Col17: '졸업예정자/ 휴학예정자/ 신규입학자 제외',
      Col18: '학과장 추천',
      Col19: '장학생 지원서장학생 추천서대학 및 대학교 전 학년 성적증명서재학증명서가족관계증명서기타서류 * 자세한 사항은 홈페이지 참고 '
    },
    {
      Col1: 'CJ문화재단',
      Col2: 'CJ음악장학생(음악대학원 부문)',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/일반대학원/해외대학',
      Col7: '대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '예체능계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '학기당 5000달러 ( * 연간 총 10000달러 수여기간 최대 3년) ※ 장학생 자격 유지 조건 및 자세한 사항은 홈페이지 참조',
      Col12: '대한민국 국적인 자대중음악 전공인자해외소재 주요 음악대학원 석사 또는 박사 입학 예정자',
      Col13: '해당없음',
      Col14: '2021-07-07~2021-07-09',
      Col15: '서류심사 후 실연심사',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '참가신청서실연 영상 1곡 url입력 및 음원 2곡 제출(자작곡 1곡 포함)입학허가서 건강보험료 납부확인서(2021년 1월~12월)주민등록표 등본가족관계증명서추천서1부재학 혹은 졸업 대학교 전 학년 성적증명서 * 온라인 접수 및 이메일 제출으로/ 자세한 사항은 홈페이지 공고 참조'
    },
    {
      Col1: '한국여성재단',
      Col2: '봄빛기금장학사업',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 대학교 등록금 (졸업시까지 지원)1인당 1학기 각 1000000원 연간 2000000원 지급',
      Col12: '탈 성매매 여성 중 대학진학생(재학생 포함)성매매피해자 지원시설 입소자 및 성매매 피해상담소 이용자로서 자격 있는 단체 및 시설의 추천을 받은 자',
      Col13: '해당없음',
      Col14: '2022-02-01~2022-02-23',
      Col15: ' * 선발기준지원사업 목적의 적합성수학계획의 충실도학업을 통한 사회 기여도',
      Col16: '해당없음',
      Col17: '추천서에는 반드시 담당실무자가 지정되어야 함지원자 개인의 직접 신청은 불가',
      Col18: ' * 추천단체 및 시설자격성매매피해자지원시설/ 성매매피해상담소로서 장학금의 집행 관리및 결과보고 등 행정적 협력이 가능한 곳',
      Col19: '단체의 공문봄빛기금 장학사업 신청서비영리단체 등록증(또는 신고증)재학증명서2021년 2학기 등록금 고지서 또는 2021년 1학기 등록금 납부확인서 사본 1부부 * 자세한 사항은 기관 홈페이지 참조'
    },
    {
      Col1: '풀뿌리희망재단',
      Col2: '버팀목장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활보장수급자 및 그 자녀',
      Col11: '1인 1000000원',
      Col12: '2022년 3월 입학예정자 ',
      Col13: '천안시 거주하는 국민기초생활수급자 및 그 자녀',
      Col14: '2022-09-26~2022-09-30',
      Col15: '서류심사면접심사',
      Col16: '총 13명 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '지원신청서(재단 홈페이지 서식함에서 첨부파일다운로드)자기소개서 (A4용지 2장이상/ 가정환경 및 청소년기성장배경/ 대학생활계획/ 진로를 비롯한 나의 비전 등 포함)개인정보동의서가족관계증명서(본인명의)원본국민기초생활보장수급자 증명서(본인명의)고교생활기록부대학합격통지서'
    },
    {
      Col1: '재단법인 춘천시민장학복지재단',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 13학점 이상 이수/ 평균 A학점 이상',
      Col10: '해당없음',
      Col11: '최대 1000000원',
      Col12: '성적우수 대학생',
      Col13: '공고일 현재 주민등록 주소지가 1년 이상 춘천시에 등록된 시민 및 그 자녀로서 중/고등학교 및 대학(교)에 재학 중인 학생',
      Col14: '2022-09-26~2022-09-30',
      Col15: '성적 70% + 생활수준 20% + 봉사 10%',
      Col16: '전체 선발인원의 40%',
      Col17: '2자녀 이상 가구가 모두 선발되었을 경우 1명만 지급납부금·등록금 등을 전액 면제받는 경우와 휴학생은 신청대상에서 제외등록금 납부액이 100만원 이하인 경우 실제 납부액만 지급정규학기를 초과하여 등록한 경우 지원 제한분야별 중복지원 불가 * 자세한 사항 첨부파일 참조',
      Col18: '총장(학장) 추천',
      Col19: '장학금 지원 신청서 및 신청인 서약서장학금 수혜 여부 확인서 및 개인정보 수집·이용·제공 동의서장학금 지원대상자 추천서봉사활동 실적 증빙서류학생 주민등록초본(최근 5년 주소이력표시)가족관계증명서재학증명서등록금·수업료 납부고지서 또는 납부영수증성적증명서부·모의 건강보험료 납부 확인서 각 1부(최근 1년간)신청자의 보통예금계좌 * 자세한 사항은 첨부파일 참고 바랍니다. '
    },
    {
      Col1: '재단법인 춘천시민장학복지재단',
      Col2: '주소이전장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평균 B학점 이상',
      Col10: '해당없음',
      Col11: '최대 1000000 원',
      Col12: '타 지역 출신 학생으로 공고일 현재 직전학기에 춘천시로 주민등록 주소지가 이전된 관내 대학(교)에 재학 중인 자',
      Col13: '타 지역 학생으로 공고일 현재 춘천시로 주민등록 주소지가 3개월 이상 ~ 1년 미만으로로 등록된 관내 대학(교)에 재학 중인 자',
      Col14: '2022-07-01~2022-07-15',
      Col15: '성적 50% + 생활수준 40% + 봉사 10%',
      Col16: '전체 선발인원의 10%',
      Col17: '2자녀 이상 가구가 모두 선발되었을 경우 1명만 지급납부금·등록금 등을 전액 면제받는 경우와 휴학생은 신청대상에서 제외등록금 납부액이 100만원 이하인 경우 실제 납부액만 지급정규학기를 초과하여 등록한 경우 지원 제한1인 1분야 지원제한 * 자세한 사항은 첨부파일 참조',
      Col18: '총장(학장) 추천',
      Col19: '장학금 지원 신청서 및 신청인 서약서장학금 수혜 여부 확인서 및 개인정보 수집·이용·제공 동의서장학금 지원대상자 추천서봉사활동 실적 증빙서류(택1)학생 주민등록초본(최근 5년 주소이력표시)가족관계증명서재학증명서등록금·수업료 납부고지서 또는 납부영수증성적증명서부·모의 건강보험료 납부 확인서 각 1부(최근 1년간)신청자의 보통예금계좌 * 자세한 사항은 첨부파일 참고 바랍니다. '
    },
    {
      Col1: 'SPC행복한재단',
      Col2: '행복한장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당 학기 등록금의 50%지원',
      Col12: '현재 SPC 직가맹 점포에 근무중인 아르바이트 대학생경력 3개월 또는 180시간 이상 근무자(과거 근무경력 포함)',
      Col13: '해당없음',
      Col14: '2022-04-25~2022-05-11',
      Col15: '1차 재단 서류심사2차 사업부 서류심사3차 면접심사',
      Col16: '해당없음',
      Col17: '2022년 2학기 휴학예정자2022년 8월 졸업예정자SPC행복한장학금 기 수혜자점주/협력사 임직원/대리점의 직계 가족중위소득 130% 초과 및 한국장학재단 학자금지원구간 7~10구간 이내내해외대학 재학자',
      Col18: '해당없음',
      Col19: 'SPC 경력확인서한국장학재단 발급 \'학자금 지원 구간 증명서\'주민등록등본표취약계층증명서(선택) * 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '재단법인 인천동구장학재단',
      Col2: '학업우수 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 대학수학능력시험 성적 또는 고등학교 3학년 1학기 성적이 평균석차 3등급 이내인 자재학생 : 공고일 기준 직전학기 15학점 이상 이수하고 성적이 평균평점 4.5만점 기준 B+ 이상인 자 (단/ 만점 기준이 다른 대학의 경우 4.5 만점으로 환산하여 적용)',
      Col10: '해당없음',
      Col11: '3000000원 (현금 70% 지역화폐 30% 병행지급)',
      Col12: '거주조건을 만족하는 대학교 신입생 및 재학생',
      Col13: '공고일 기준 본인 또는 보호자가 인천광역시 동구에 2년 이상 주민등록을 두고 있는 대학생',
      Col14: '2022-08-08~2022-08-31',
      Col15: '자격요건을 충족하는 신청자 중 성적이 높은 순으로 선발',
      Col16: '50명',
      Col17: '방송통신대학교/ 사이버대학/ 학점은행제 대학/ 국외 대학학업우수 장학생 기수혜자(2020년~)',
      Col18: '해당없음',
      Col19: '장학금 신청서장학금 서약서개인정보 수집/이용/제공 및 조회 동의서대학교 재학증명서주민등록등본 및 초본(거주기간 확인용)직전학기 성적 증명서(재학생)고등학교 3학년 1학기 성적증명서 또는 대학수학능력시험 성적표(신입생)장학금 지급 받을 통장 사본장학생 서약서저소득층 증명서(해당자)기타 장학생 선발에 필요하다고 인정되는 기타 서류 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '국민체육진흥공단',
      Col2: '체육인대학원진학장학금',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '일반대학원',
      Col7: '석사2학기이상/석사신입생(1학기)',
      Col8: '예체능계열',
      Col9: '기존인원의 경우 직전학기 최소 성적(B0) 충족시 계속지원',
      Col10: '해당없음',
      Col11: '대학원 과정 2년(4학기) 이내 학기당 3000000원의 범위에서 입학금 및 등록금을 지원 * 당초 계획한 기간 내에 학업을 마칠 수 없는 특별한 사유가 인정되는 경우에는 총 학업기간 3년 이내 5학기까지 지원기간 연장 가능',
      Col12: '은퇴한 국가대표 선수로서 국내의 대학원에 진학하고자 하는 사람공단의 각종 지원금 미수혜자 우선',
      Col13: '해당없음',
      Col14: '2022-08-02~2022-08-08',
      Col15: ' * 신규지원 : 선정위원회 평가 등 종합점수 순위에 따라 선정 * 기존인원 : 직전학기 최소 성적(B0)충족/ 등록금 납부 증빙 등 지급 최소 사유 미해당 시 계속 지원',
      Col16: '해당없음',
      Col17: ' * 지원의 취소 또는 중지공단의 승인 없이 교육기관 또는 전공 분야 변경 (취소)서류제출 의무 위반 (취소)직전학기 평균평점이 B°(100점 환산/ 80점) 이상이 되지 않는 경우 (취소)휴학한 경우 (중지) 체육인으로서의 품위 훼손 등의 사유장학금 지원 기간과 국가대표 선수 활동 시기가 중복될 경우 * 지원금 반환허위 또는 그 밖에 부정한 방법으로 지급받은 경우장학금을 지급받은 후 지급사유가 소급하여 소멸된 경우과·오급된 경우',
      Col18: '경기단체장 추천대한(장애인)체육회장 추천',
      Col19: ' * 신규지원추천서국가대표선수 확인서재학증명서(합격통지서)등록금 영수증학업계획서통장사본(일반예금) * 기존인원등록금 영수증(직전학기/ 신청학기)직전학기 성적증명서국가대표선수 확인서 * 소속 경기단체에 서류 제출  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고 '
    },
    {
      Col1: '숭실대학교사회복지대학원',
      Col2: '동문재학생가족장학',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/특정대학',
      Col7: '석사신입생(1학기)',
      Col8: '사회계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '숭실대학교 사회복지대학원 동문/ 재학생 직계 가족 ',
      Col13: '해당없음',
      Col14: '2022-08-02~2022-08-08',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '유관기관장학\'의 경우 전체 재학기간 중 1회만 가능(입학 후 첫 학기 지급원칙)20222학기 미등록자 및 미등록 휴학자는 장학대상 제외장학금은 한 학기에 최대 2종이내에서 수혜',
      Col18: '해당없음',
      Col19: '신청서가족관계증명서재학/졸업증명서'
    },
    {
      Col1: '숭실대학교사회복지대학원',
      Col2: '장애인장학',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '일반대학원/특정대학',
      Col7: '석사신입생(1학기)',
      Col8: '사회계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '중증장애 (1~3급)숭실대학교 사회복지대학원생',
      Col13: '해당없음',
      Col14: '2022-09-07~2022-09-14',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '유관기관장학\'의 경우 전체 재학기간 중 1회만 가능(입학 후 첫 학기 지급원칙)20222학기 미등록자 및 미등록 휴학자는 장학대상 제외장학금은 한 학기에 최대 2종이내에서 수혜',
      Col18: '해당없음',
      Col19: '신청서장애인등록증 또는 복지카드'
    },
    {
      Col1: '숭실대학교사회복지대학원',
      Col2: ' 사후지급장학',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '수혜금액 20~30%',
      Col12: '신입생 또는 사전감면 장학금 대상자 중 신청을 못했던 대학생 ',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: 'Usaint 로그인학적정보 탭 클릭학적정보 조회 및 수정클릭하단에 있는 부가정보 탭에서 은행 계좌 정보에 본인 명의 계좌정보 입력 ',
      Col16: '해당없음',
      Col17: '장학금 총액이 수업료 총액을 초과할 수 없습니다유관기관장학의 경우 전체 재학기간 중 1회만 받을 주 있습니다.휴학자는 장학 대상에서 제외됩니다.선발자는 한국장학재단에 통보하므로 한국장학재단에서 대출 받은 자는 상환통보를 받을 수 있습니다. ',
      Col18: '해당없음',
      Col19: '신청서재직증명서경력증명서'
    },
    {
      Col1: '숭실대학교사회복지대학원',
      Col2: '김예진/한용외 장학',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 1000000원',
      Col12: '출연자의 뜻을 존중하여 목회자와 경제적 도움이 필요한 자에 대하여 지급한다.재학기간(4학기)내 위 3종의 장학금은 각각 1회에 한하여 수혜를 원칙으로 한다. ',
      Col13: '해당없음',
      Col14: '2021-12-20~2022-01-14',
      Col15: '서류제출 및 계좌 등록',
      Col16: '한용외: 3명 (경제적 도움이 필요한 자)김예진 :1명 (경제적 도움이 필요한 자)김예진 :2명 (목회자중 경제적 도움이 필요한 자 )일반장학 :5명 (경제적 도움이 필요한 자)',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '가족관계증명서소득확인증명서 *자세한 사항은 홈페이지 참조 '
    },
    {
      Col1: '토니모리',
      Col2: '희망열매캠페인',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '2022학년도 대학수학능력시험 응시 고3 수험생',
      Col13: '해당없음',
      Col14: '2022-06-22~2022-07-22',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '홈페이지에서 신청서 다운 작성 후 이메일 접수희망열매 장학금 신청서2022학학년도 대학수학능력시험 성적표 사본교직원 추천서 1부 / 신청사연기초생활수급자 증빙자료(해당자)(이메일 제목 : 희망열매_학교명_본인 이름)'
    },
    {
      Col1: '한경대학교',
      Col2: '대회입상장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '300000원 ~ 1200000원 * 재학 중 1회 지급 생활비성 장학금',
      Col12: '재학 중 국제 또는 전국 단위 공모전·경진대회에서 입상한 자2022.01.01 이후 대회 입상자정규학기 재학생',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: ' * 휴학상태 및 입학전 입상내역 제외/ 프로그램/학술대회 참여 중 수상 제외 * 입선으로 입상한자는 제외 * 초과학기 신청불가',
      Col18: '해당없음',
      Col19: '학생역량강화 장학금 신청서(종합정보시스템)입상 증빙서류 (대회 팜플렛/ 상장)(역량개발시스템)대회입상 수상실적 증빙서 : 입상증빙 서류 제출 불가시에만 제출'
    },
    {
      Col1: '평화3000',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인 최대 1000000원',
      Col12: '평화/ 통일 운동에 헌신하고 있는 활동가 또는 활동가의 자녀평화/ 통일 활동을 하고 있는 대학생 또는 대학원생다문화 가정 학생저소득층 학생 *외국인 지원 자격제3세계에 거주하며 공부하는 제3세계 국적의 대학생국내에서 공부하는 제3세계 유학생',
      Col13: '해당없음',
      Col14: '2022-06-30~2022-07-19',
      Col15: '장학생 선발 심사위원회의 심사 및 결정',
      Col16: '00명',
      Col17: '타 장학금 중복수혜를 받는 자',
      Col18: '해당없음',
      Col19: '신청서 및 자기소개서추천서재학증명서* 제출방법 : 구비서류를 평화삼천 사무국 메일로 발송peace3000@peace3000.net'
    },
    {
      Col1: '한국방정환재단',
      Col2: '웰컴금융그룹방정환장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적우수: 직전 두학기 평균 학업성적이 B+이상 (평점평균 4.5 만점에 3.5 이상/ 100점 만점에 85점 이상)',
      Col10: ' * 성적우수 및 복지 공통 조건 가정 경제상황의 약화 등으로 장학금이 필요한 고객 본인 및 자녀',
      Col11: '복지: 최대 1600000원까지 장학금 지원성적우수: 최대 2300000원까지 장학금 지원',
      Col12: '(복지장학금) 웰컴금융그룹 고객 본인 및 고객 자녀로서 가정 경제상황의 악화로 장학금이 필요한 대학생(성적장학금) 웰컴금융그룹 고객 본인 및 고객 자녀로서 직전년도 평균 학업성적 B+이상',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: 'OO명',
      Col17: '다자녀 가구의 경우 한 자녀만 지원 가능최대 2회까지만 선발 가능',
      Col18: '지도교수 추천',
      Col19: '장학금 신청서주민등록등본 1부개인정보제공 동의서지도교수 추천서 원본재학증명서부모의 건강보험증 사본 및 건강보험료 납부 확인서 (부모가 각각 다른 건강보험증을 소지한 경우/ 부모 모두의 건강보험증 사본과 건강보험료 납부확인서 제출)소득재산 입증서류 (해당자에 한함) (전월세임대계약서/ 정부수급자증명서류/ 특별한 경제적 위기상황을 증명할 수 있는 서류)성적증명서 (성적우수장학금 신청 학생) (직전 두학기성적증명서) * 자세한 사항은 기관 홈페이지 참조'
    },
    {
      Col1: '대추밭장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '교육계열/사회계열/인문계열',
      Col9: '석/ 박사 과정의 대학원생(석/ 박사 입학 예정자 포함)',
      Col10: '해당없음',
      Col11: '석사 과정 : 1년간 4000000원 연구비 지원( 최대 2년 8000000원 )박사 과정 : 1년간 4000000원 연구비 지원( 최대 3년 12000000원 )',
      Col12: '역사/ 유교/ 교육 등 경주 문화에 대한 인문학 연구',
      Col13: '해당없음',
      Col14: '2022-07-26~2022-08-26',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '이력서 1부(사진 포함)자필 자기소개서 1부(A4 2장 내외)연구과제 설명서 1부주민등록등본 1통학장 추천서'
    },
    {
      Col1: '재단법인 여객선안전재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적 우수자 우선 선발',
      Col10: '소득 수준 낮은 자 우선 선발',
      Col11: '2000000원',
      Col12: '(취업선원) 선발공고일 현재 내항여객선 승선경력이 1년 이상인 자(장해선원) 재해발생당시 승선경력이 1년 이상인 자로서 산업재해보상보험법시형력의 규정에 따른 장해판정을 받은 자(순직선원) 순직당시 승선경력이 1년 이상/ 순직일(실종일)로부터 20년이 경과하지 않은 자 ※ 자세한 사항 기관 홈페이지 참조',
      Col13: '해당없음',
      Col14: '2022-07-26~2022-08-26',
      Col15: ' * 선발기준학업성적해당선원의 승선ㆍ무사고 경력년수 및 근속년수서해훼리호 사고(1993년)관련 선원의 자녀동일순위의 경우 소득수준이 낮은 선원의 자녀승무원 1세대 당 1인 선발',
      Col16: '3명 이내',
      Col17: '휴학 또는 학교 징계(제적/ 정학)처분 중에 있는 경우장학생선발지원서 또는 첨부서류 등이 허위로 작성 제출되었을 경우한국장학재단 장학금 중복지원 방지시스템 사전심사에서 중복지원 또는 지원불가로 구분되었을 경우',
      Col18: ' * 아래 해당자의 추천서 제출(택1)해양수산부 연안해운과장한국해운조합 지역본부장 및 지부장여객선 사업주학교장/ 총장 또는 학장',
      Col19: '장학생선발지원서추천서개인정보 수집·이용·제공 동의서신청 선원의 주민등록등본 또는 가족관계증명서성적증명서 원본전년도 해당선원의 근로소득원천징수영수증 사본승무경력증명서재학증명서순직사실확인서(한국해운조합 발행) * 자세한 사항은 기관 홈페이지 공고 참조'
    },
    {
      Col1: '한국해운조합',
      Col2: '선원공제장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '동일 조건 시 학업성적 우수자 우선 ',
      Col10: '동일 조건 시 선원 근로소득 낮은 자 우선 선발',
      Col11: '2000000원',
      Col12: '(선원자녀) 동일선사 3년 이상 계속 근무 중 또는 총 승무경력 5년 이상이면서 동일선사 2년 이상 계속 근무중인 선원의 자녀(선원) 동일선사 1년 이상 계속 근무 중인 선원(재해선원) 최근 5년간 조합 선원공제 직무상 재해로 인하여 사망 또는 재해를 입은 선원 및 자녀',
      Col13: '해당없음',
      Col14: '2020-02-03~2020-02-28',
      Col15: '선원 근로소득선원 승무경력학업성적조합 선원공제 직무상 재해로 인하여 사망한 선원의 자녀 또는 신체장해를 입은 선원 본인 및 그 자녀과거 선원공제 및 여객선안전재단 장학금 수혜여부세대별 1명 초과/ 업체별 3명 초과 지원 여부기타 선발 심의위원회에서 정하는 기준* 선발기준 기관 홈페이지 공고 참조',
      Col16: '25명내외 (재해선원 5명 이내 선발)',
      Col17: '휴학 또는 징계중인 자선원공제 장학생과 여객선안전재단 장학생 중복지원 불가',
      Col18: '해당없음',
      Col19: ' [ 일반선원 ] 장학생선발신청서 및 지원서선원의 전년도 근로소득 원천징수영수증성적증명서재학증명서선원의 승무경력증명서선원의 주민등록등본 또는 가족관계증명서개인정보처리동의서(선원 및 자녀) [ 재해선원 ]장학생선발지원서 성적증명서재학증명서선원의 주민등록등본 또는 가족관계증명서개인정보처리동의서 * 양식 다운로드 및 자세한 사항 확인 기관 홈페이지 참고 부탁드립니다.'
    },
    {
      Col1: '한국뇌성마비복지회',
      Col2: '대학신입뇌성마비장애장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/학점은행제 대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정형편이 어려운 학생',
      Col11: '대학입학 등록금 전액   (국가장학금 등 기타 장학금 수혜자의 경우 그 차액에 한해 지급)',
      Col12: '2019학년도 대학에 입학하는 뇌성마비인 중 가정형편이 어려운 학생 (대학은 고등교육법 제2조 규정에 의한 대학/ 산업대학/ 교육대학/ 전문대학/ 한국방송통신대학교에 한함)',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 신상카드 및 자기소개서개인정보제공동의서장애인 복지카드 사본(진단서 첨부) 대학입학합격증 사본 등록금고지서 사본 학생 명의의 통장사본 주민등록등본최근 3년간 부모(보호자) 모두의 소득금액증명서    ( 근로소득자의 경우 원천징수영수증/ 소득이 없을 경우 종합소득과 근로소득이 없다는 사실증명서)최근 3년간 부모(보호자) 모두의 재산세납부증명서최근년도 부모(보호자) 모두의 의료보험료 납부증명서 * 우편 접수'
    },
    {
      Col1: '한국뇌성마비복지회',
      Col2: '지정장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '경제적으로 어려운 학생',
      Col11: '1인당 1000000원',
      Col12: '대학 재학 중인 뇌성마비장애인',
      Col13: '해당없음',
      Col14: '2020-01-29~2020-01-30',
      Col15: '구비서류 심사 및 상담조사',
      Col16: '2명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 신상카드 및 자기소개서 개인정보제공동의서장애인 복지카드 사본 (진단서 첨부) 직전학년 성적증명서 (1학년의 경우 고등학교 생활기록부 제출)학생 명의의 통장사본 주민등록등본2018년도 부모(보호자) 모두의 소득금액증명서근로소득자의 경우 원천징수영수증소득이 없을 경우 종합소득과 근로소득이 없다는 사실증명서2018년도 부모(보호자) 모두의 재산세납부증명서2018년도 부모(보호자) 모두의 의료보험료 납부증명서※ ①②양식은 첨부파일 다운로드 가능'
    },
    {
      Col1: '통진나루장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원 예정',
      Col12: '통진과 관련된 대학생(입학예정자 포함)',
      Col13: '경기도 김포시 통진읍 내 중/ 고등학교 졸업자경기도 김포시 통진읍 내 거주자경기도 김포시 통진읍에 부모가 거주하는 경우(통진 지역과 관련이 있는 학생)',
      Col14: '2021-09-01~2021-09-15',
      Col15: '서류 및 인터뷰',
      Col16: '해당없음',
      Col17: '휴학생 및 복학예정생',
      Col18: '자기추천서 : 자기가 자시늘 추천하는 형식/ 방법 방식의 제한없음/ 단 자필로 써야한다.',
      Col19: '자기 추천서고등학교 생활기록부 사본장학증서 내용(장학금을 받는다면 장학증서 들어갈 문구 작성)기타 본인을 소개할 수 있는 여러가지 자료* 접수방법 : 본인이 직접 방문(오후 2시 ~ 7시 사이)* 접수처 : 경기 김포시 통진읍 서암로 73(통진중/고총동문회 사무실)'
    },
    {
      Col1: '재단법인박승희장학재단',
      Col2: '코스모스장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '선발 공고일 현재 대한민국에 주소를 두고 거주하는 자 또는 그 자녀이 땅의 민주주의와 진보적인 사회 발전을 위하고 열사의 정신을 구현하기 위해 모범적으로 활동하는 자 또는 그 자녀',
      Col13: '해당없음',
      Col14: '2021-09-01~2021-09-15',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '2021년도에 타 장학금 또는 학비감면의 수혜를 받은 자1세대 1명 * 자세한 사항은 기관으로 문의바랍니다.',
      Col18: '해당없음',
      Col19: '코스모스 장학생 신청 및 추천서개인(신용)정보 수집·이용·제공 및 조회 동의서 및 서약서자기소개서주민등록등·초본 (최근 5년이상 주소변동사항 기재) * 가족관계등록부 1통(부모님과 주소 다른경우) * 우편접수 : 재단사무국 (광주광역시 북구 자미로 63) '
    },
    {
      Col1: '재단법인박승희장학재단',
      Col2: '복지장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '학업을 계속하기 위하여 사회적 배려가 필요한 자',
      Col11: '2000000원',
      Col12: '선발 공고일 현재 대한민국에 주소를 두고 거주하는 자 또는 그 자녀학업을 계속하기 위하여 사회적 배려가 필요한 자',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-08-05',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2021년도 타 장학금 또는 학비감면 수혜자1세대 1명 선발 * 자세한 사항은 기관으로 문의바랍니다. ',
      Col18: '해당없음',
      Col19: '복지장학금 자녀 장학생 신청 및 추천서개인(신용)정보 수집·이용·제공 및 조회 동의서 및 서약서자기소개서성적증명서(평균성적 백분율 반드시 표기)주민등록 등·초본가족관계등록부(부모님과 주소가 다른 경우)기초생활수급자 및 차상위계층의 경우 증빙서류 제출 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '토성장학회',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '공고일 현재(2022. 7. 22.) 토성면에 1년 이상 주민등록을 두고 실 거주중인 주민 또는 주민의 자녀',
      Col13: '공고일 현재(2022. 7. 22.) 토성면에 1년 이상 주민등록을 두고 실 거주중인 주민 또는 주민의 자녀',
      Col14: '2022-07-25~2022-08-25',
      Col15: '성적 및 소득',
      Col16: '4명',
      Col17: '직전년도 본회의 장학금 기수혜자 당해년도 지방자치단체의 장학금 100만원 이상 수혜자당해학기 전액 장학금 수혜자 신청 불가',
      Col18: '해당없음',
      Col19: '장학금신청서직전학기 성적증명서교육비 납입증명서 또는 등록금 고지서장학금 수혜확인서1년 거주 확인되는 주민등록등본(전입일 확인)가족관계증명서건강보험료 납부확인서(최근 6개월분) 부·모 각각 제출 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '토성장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '품행이 단정하고 문화·예술·체육·과학·기능 분야에 소질과 재능이 뛰어난 자로서 도단위 이상의 대회 및 경진대회에서 입상한 자 (* 공고일로 부터 1년 이내)',
      Col13: '공고일 현재(2022. 7. 22.) 토성면에 1년 이상 주민등록을 두고 실 거주중인 주민 또는 주민의 자녀',
      Col14: '2022-06-13~2022-07-17',
      Col15: '성적 및 소득',
      Col16: '1명',
      Col17: '직전년도 본회의 장학금 수혜자당해년도 지방자치단체의 장학금 100만원 이상 수혜자당해 학기 전액 장학금을 받는 자 신청 불가당해년도 신입생',
      Col18: '해당없음',
      Col19: '장학금 신청서직전학기 성적 증명서교육비 납입증명서 또는 등록금 고지서장학금 수혜확인1년 거주 확인되는 주민등록등본(전입일 확인)건강보험료 납부확인서(최근 6개월분) 부/모 각각 제출입상 상장 및 자격증 사본 제출 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '서울장애인자립생활센터',
      Col2: '씨알장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '에세이 내용에 자신의 꿈을 구체적으로 잘 나타낸 대학(원)생',
      Col13: '서울시 소재 학(원) 재학 중인 장애학생서울에 주소를 두고 타 지역의 대학(원)에 재학 중인 장애학생 * 전문대학 재학 중인 장애학생도 신청 가능함',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '나의 꿈에 대한 에세이와 씨알장학금 징행 계획서 서류심사서류통과자 개별면접 후 최종선정',
      Col16: '3명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금지원신청서나의 꿈에 대한 에세이씨알장학금 활용 계획서선정 후 복지카드/ 재학증명서/ 통장사본 제출필요 * Email 또는 팩스/ 우편으로 접수 * 자세한 내용은 홈페이지 공지사항 참고'
    },
    {
      Col1: '고우해커스',
      Col2: 'Hackers Alumni 장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 미화 10000달러',
      Col12: '해커스 아카데미아 동문으로 2022년도 해외대학(원)의 어드미션을 받은 분학부생/ 석박사생 모두 가능',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '제출한 서류를 토대로 지원자의 유학 목적/ 미래에 대한 포부와 학업 계획/ 해커스 웹사이트를 통한 커뮤니티 기여도 등을 종합적으로 고려',
      Col16: '2명',
      Col17: 'Hackers Alumini 전형과 Hackers Family 전형은 중복지원 가능',
      Col18: '해당없음',
      Col19: 'Hackers Alumni 장학생 지원서어드미션 통지서 사본i20사본비자사본(해당유학국가) * 미국 이외의 국가는 i20이 아닌 해당 국가의 입학허가서 형식 사본 ※ 자세한 사항은 홈페이지 공고 참고'
    },
    {
      Col1: '고우해커스',
      Col2: 'Hackers Family 장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 미화 10000달러',
      Col12: '해커스 사이트에서 정보를 함께 나누는 모든 이들 중 2022년 해외 대학(원) 어드미션을 받은 분학부생/ 석박사생 모두 지원가능',
      Col13: '해당없음',
      Col14: '2020-11-27~2020-12-18',
      Col15: '제출한 서류를 토대로 지원자의 유학 목적/ 미래에 대한 포부와 학업 계획/ 해커스 웹사이트를 통한 커뮤니티 형성의 기여도 등을 종합적으로 고려',
      Col16: '2명',
      Col17: 'Hackers Alumni 전형과 Hackers Family 전형은 중복 지원 가능',
      Col18: '해당없음',
      Col19: 'Hackers Family 지원서어드미션 통지서 사본i20사본비자사본(해당유학국가) * 미국 이외의 국가는 i20이 아닌 해당 국가의 입학허가서 형식의 사본을 제출'
    },
    {
      Col1: '한국실험동물학회',
      Col2: '실험동물연구장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '의약계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '상장 및 상금',
      Col12: '실험동물 관련 과목이 개설되어 있는 대학에 재학 중인 학사/석사/박사과정 대학생 및 대학원생지도교수 또는 본인이 3년간 회원으로서의 의무 이행그룹Ⅰ : LAR에 1편 이상의 논문을 저자로 또는 실험동물분야 SCI(E) 등재 학술지에 주저자로 논문을 개제그룹Ⅱ : 재직기관에서 실험동물관련 업무 종사하며 학업 병행',
      Col13: '해당없음',
      Col14: '2022-04-13~2022-04-22',
      Col15: '학술상위원회 심사규정 및 내부규정을 따름(적임자가 없을 경우 대상자를 선정하지 않음)',
      Col16: '약간팀',
      Col17: '그룹 Ⅰ의 경우 2회까지 중복 수상 가능하나 동일 학위 과정에서는 1회만 가능/ 재차 수상의 경우 실적은 이전 수상 이후의 실적 인정그룹 Ⅱ의 경우 수료생 불가/ 중복 수상 불가',
      Col18: '해당없음',
      Col19: ' * 이메일 접수/ 자세한 사항은 홈페이지 내 공고참조 * 그룹Ⅰ 신청시지도교수 추천서(자유양식)이력서(자유양식)재학증명서성적증명서저자로 발표한 LAR 게재 논문 또는 실험동물분야 SCI(E) 등재 학술지에 주저자로 개제한 논문 별쇄본 * 그룹Ⅱ 신청시소속기관장 또는 부서장 추천서(자유양식)이력서(자유양식)재직증명서재학증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '조천농협',
      Col2: '조합원자녀대학생장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '1순위 : 가정형편이 어려운 조합원과 동거하는 부모없는 손자녀2순위 : 가정형편이 어려운 편부 편모 조합원의 자녀3순위 : 12순위에 해당되지 않는 조합원의 자녀로 영농회별 배정인원4순위 : 기 조합원 자녀 장학금 수혜 조합원의 타자녀',
      Col11: '1000000원',
      Col12: '조합원의 자녀로 추천일 현재 국내 소재 대학에 재학 중인 자(대학/ 산업대학/ 교육대학/ 전문대학/ 방송대학/ 통신대학/ 방송통신대학/ 사이버대학/ 기술대학/ 각종학교)',
      Col13: '해당없음',
      Col14: '2022-09-05~2022-09-30',
      Col15: '자녀장학금 수혜를 받지 못한 조합원(부부 포함)초과 추천 시 고학년 우선순위 선정⇒ 대학 학과별 수업연한 기준동학년인 경우 순위선정  ① 이용고배당(부부 합산) 금액이 많은 조합원  ',
      Col16: '33명',
      Col17: '장학금을 수혜받은 조합원(부부포함)병역 및 국내ㆍ외 연수 등으로 휴학한 조합원의 자녀농ㆍ축협 상근 임원 및 정규직원(업무직 이상)의 자녀금년도 이용고배당금(21년도 사업이용실적)이 없는 조합원(부부 합산)   (16년도부터 시행 함)2021년 1월 1일 이후 조합원 가입자(양도 조합원 포함)',
      Col18: '해당없음',
      Col19: '자녀 장학금 지원 신청서가족관계 증명서재학증명서개인정보 수집/이용 동의서(조합원 및 자녀) * 자세한 사항은 홈페이지 공고 참고'
    },
    {
      Col1: '광주광역시서구장학재단',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 2개학기 (복학생의 경우 직전학기) 성적이 평균 4.0이상(4.3만점은 3.8이상) * 대학생의 성적은 12학점 이상 이수해야하며 계절학기는 제외',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '해당없음',
      Col13: '공고일 현재 광주광역시 서구 관내에 6개월 이상 주소를 둔 주민과 자녀',
      Col14: '2022-09-05~2022-09-30',
      Col15: '장학생 선발심사 배점표에 의거 고득점순 선발',
      Col16: ' * 총 38명전문대 : 10명종합대 : 28명',
      Col17: '4년제 대학생으로 8학기를 초과하여 신청한 학생신청학기에 타 기관·단체로부터 장학금을 지원받아 실제 납부해야 할 등록금이 50만원 미만인 학생신청년도 코로나19 특별장학금 수혜자직전년도 서구 장학재단 장학생으로 선발되어 장학금 지원받은 학생 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학금 지원신청서신청인 서약서장학생 추천서주민등록 등본 (변동일/ 변동사유 포함 발급/ 등본으로 6개월 이상 거주기간 확인 불가시 주민등록초본:주소변동사항 포함 제출)/ 부모와 거주지가 다를경우 가족관계증명서 제출개인정보 수집/이용/제공 및 조회 동의서재학증명서(대학생)성적증명서 (20211학기 성적) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '광주광역시서구장학재단',
      Col2: '행복(저소득)장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '일반 : 직전 2개 학기 평균이 3.0 이상(4.3만점은 2.8 이상)생활비 : 직전 2개 학기 평균이 3.5 이상(4.3만점은 3.3 이상) * 복학생의 경우 직전학기 성적 ',
      Col10: '신청자 직계가족의 6개월 평균 납입 국민건강보험료가 신청년도 기준 전국가구 중위소득 65% 이하인 가구 * 생활비지원 : 기초생활수급자 차상위 대상자 (종합대만 해당)',
      Col11: '(등록금성) 1500000원(생활비지원) 1000000원',
      Col12: '서구 관내 거주 대학생으로서/ 저소득 가정의 자녀',
      Col13: '공고일 현재 광주광역시 서구 관내에 6개월 이상 주소를 둔 주민과 자녀',
      Col14: '2022-09-05~2022-09-30',
      Col15: '해당없음',
      Col16: ' * 총 18명일반 : 전문대 3명 / 종합대 6명생활비지원 : 전문대 4명 / 종합대 5명',
      Col17: '휴학생 및 정규학기 초과자신청 학기 타 기관·단체로부터 장학금을 지원받아 실제 납부하여야 할 금액이 50만원 이하인 대학생(생활비 지원은 해당 없음)진전년도 서구 장학재단 장학금 수혜자신청년도 코로나 19 특별 장학금 수혜자1가구 1명 선발 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서개인정보 수집·이용·제공 및 조회 동의서주민등록 등본재학증명서통장사본장학생 추천서성적증명서국민건강보험료 납부 확인서가정환경·세대구성 관련 증명서'
    },
    {
      Col1: '광주광역시서구장학재단',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 2개 학기 성적이 평균 3.0 이상(4.3 이상은 2.8이상)',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '다자녀 : 4자녀 이상의 가정장애인 : 본인의 장애인 증명서를 제출할 수 있는 자봉사·효행·선행 : 사회봉사 실적이 우수하거나 선행 및 효행이 뛰어난 자다문화 : 국제가정 결혼으로 부모 중 한쪽이 한국인으로 구성된 가족',
      Col13: '공고일 현재 광주광역시 서구 관내에 6개월 이상 주소를 둔 주민과 자녀',
      Col14: '2021-09-01~2021-09-10',
      Col15: '해당없음',
      Col16: '6명',
      Col17: '신청 학기에 타 기관·단체로부터 장학금을 지원받아 실제 납부해야 할 등록금이 50만원 미만인 자직전년도 서구 장학재단 장학생으로 선발되어 장학금을 받은 자신청년도 코로나19 특별장학금 수혜자1가구 1인 선발 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서개인정보 수집·이용·제공 및 조회 동의서주민등록 등본재학증명서통장사본해당자 증빙서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '광주광역시서구장학재단',
      Col2: '특별장학생(코로나19)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/제한없음',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '2021년에 비자발적으로 실직하여 공고일 기준 공요보험 실업그병를 수령하고 있는 주민의 자녀2021년 폐업한 자영업자의 자녀로서 국세청 서류로 폐업사실 및 매출 확인이 가능한 자자',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '공고일 현재 광주광역시 서구에 주민등록 상 6개월 이상 주소를 둔 주민과 그 자녀로 유형별 요건을 갖춘 자',
      Col14: '2022-02-25',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '1가구 2인 이상이 선발대상자인 경우 1인만 선발 * 자세한 사항 첨부파일 참조',
      Col18: '해당없음',
      Col19: '주민등록등본개인정보 수집·이용·제공 및 조회 동의서통장 사본재학증명서국민건강보험료 납부확인서 * 자영업자 또는 소상공인 자녀 일 시2019년 부가가치세 과세표준증명원 ( * 면세자는 부가가치세 면세사업자 수입금액증명원)사업자등록증명원 * 무급휴직근로자 자녀일 시2020년 3월 ~ 5월 무급휴직 확인서'
    },
    {
      Col1: '광주안씨장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '수능성적이 국어/ 수학 2개과목 중 1개 과목은 3등급이내인 신입생',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '2022년도 국내 4년제 대학교 신입학 등록생으로서 수능성적이 국어/ 수학 2개과목 중 1개 과목은 3등급이내인 신입생',
      Col13: '해당없음',
      Col14: '2022-06-20~2022-07-08',
      Col15: '국어/ 수학 2개과목의 표준점수합산 고득점자 순으로 선발동점자는 국어성적 상위자/ 국어성적까지 동점자는 최연소자로 선발',
      Col16: '25명',
      Col17: '방통대/ 육해공군사관학교/ 사이버대학교/ 한국 광주 대구경북 울산과학기술대학교 등은 제외',
      Col18: '해당없음',
      Col19: '장학생 선발신청서수능성적증명서대학교신입생등록필증사본학생명의 통장사본*제출처 : 각 소속 종파의 대종회 부회장에게 제출'
    },
    {
      Col1: '광주대학교',
      Col2: '호심챌린지장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '30포인트 이내 (1포인트 당 3만원으로 2포인트 이상부터 지급) * 1회성 포상성 장학금이므로 등록금 범위를 초과해서 지급 가능',
      Col12: ' * 아래의 해당자중 호심챌린지 장학금 해당자2학기 등록을 필하고 현재 재학 중인 자정규학기 이내인 자',
      Col13: '해당없음',
      Col14: '2020-01-16~2020-02-11',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '정규학기 초과자',
      Col18: '해당없음',
      Col19: '호심챌린지 장학금 신청서(온라인 신청 후 반드시 출력)해당 증빙서류 사본  * 2022. 1. 1. 이후 발급 받은 증빙서류만 유효함 ** 이메일 제출 / 교내장학금으로/ 자세한 사항은 교내 홈페이지 장학 공지 참조'
    },
    {
      Col1: '고령박씨장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 3.5이상으로 품행이 방정한 자대학교 입학 예정자의 경우 수능성적이 우수하고 품행이 방정한 자국가공인 기술교육기관(직업학교 등)의 학생으로서 학업성적이 우수하고 품행이 방정한 자체육/ 예술 분야 특기자로서 전국대회 입상 경력이 있고 장래성이 있다고 인정되는 자',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '*고령박씨 성손의 남/여학생',
      Col13: '해당없음',
      Col14: '2022-01-10~2022-01-31',
      Col15: '서류심사 & 면접',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 신청서(네이버카페'
    },
    {
      Col1: '인수장학회',
      Col2: '인수장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '사회계열',
      Col9: '해당없음',
      Col10: '기타 조건이 유사할 시 경제적 어려움이 더 큰 학생에게 우선순위를 둠',
      Col11: '1인 단독 수상 : 500만원2인 공동 수상 : 각 300만원 ',
      Col12: '국내 대학의 석박사과정에 재학하는 학생기술 혁신/ 기술 능력/ 지식 경영 및 조직 학습 관련 분야의 학위 논문을 준비하고 있는 자학교 성적이 우수하고 생활 태도가 건전한 자향후 故김인수 교수님의 학문 분야를 계승하는 학자의 길을 걸어갈 수 있는 자',
      Col13: '해당없음',
      Col14: '2021-10-13~2021-11-03',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '인수장학생 지원서자기소개서(자유 양식)재학중인 학교의 교수 추천서(자유양식)대학 및 대학원 성적 증명서(학사/ 석사/ 박사 성적 일체 포함)연구 업적 리스트(2~3편의 대표 연구 업적 표시) 및 대표 연구 업적물'
    },
    {
      Col1: '선재학술장학재단',
      Col2: '한걸음더장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정 형편이 어려움에도 불구하고 지속적인 수험 생활을 위해 경제적 지원이 필요한 수험생',
      Col11: '1000000원 내외(선발된 인원에 따라 달라질 수 있음. 단 비재학생의 경우 제세공과금 제외 후 지급하며 죄동 선발 인원 미달 시 차기 장학생 모집으로이월됨)',
      Col12: '현재 공무원 시험을 위한 수험 생활을 하고 있는 자로서 성적과 성품이 고르게 우수하여 장래 공직 사회에 이바지할 것으로 기대되는 인재 (경찰 및 기타 직렬은 국어 과목 신청자)2022년 국가공무원 시험을 준비하고 있는 수험생(단/ 지난 시험 응시와 성적을 반드시 입증할 수 있어야 함)',
      Col13: '해당없음',
      Col14: '2021-10-05~2021-11-30',
      Col15: '서류심사',
      Col16: '50명 내외',
      Col17: '지난 선재학술장학재단 장학생으로 선발되었던 기수혜자',
      Col18: '해당없음',
      Col19: '장학생 신청서(홈페이지 내 직접입력)지원자 에세이(홈페이지 양식다운 후 작성)개인정보 수집/이용/제공 동의서주민등록등본 재학증명서기타 경제적 형편을 입증할 수 있는 서류 (선택) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '해외자원개발진흥재단',
      Col2: '글로벌자원개발석박사장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/해외대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/사회계열/자연계열',
      Col9: ' * 첨부파일 참고',
      Col10: '해당없음',
      Col11: '연간 최대 1200000원지원기간 : 최대 3년)',
      Col12: '대한민국 국적 보유자로서/ 국내 대학 졸업(예정)자 또는 국내에서 이와 동등 이상의 학력이 있다고 인정되는 자해외 유수 고등교육기관에서 전공분야의 석사 또는 박사과정 수학이 가능하고 학위취득을 위한 어학 및 전문적 소양능력을 가진 자해외여행에 결격사유가 없는 자 * 각 프로그램별로 지원자격/ 지원규모 등이 상이하므로 선발요강을 반드시 확인하시기 바랍니다.',
      Col13: '해당없음',
      Col14: '2021-06-27~2021-07-25',
      Col15: '1차 서류전형 2차 심층면접',
      Col16: 'O명 (선정기준에 부합하는 지원자가 없을 경우/ 합격자가 없을 수 있음.)',
      Col17: ' * 첨부파일 장학금 환수범위구분표 참고',
      Col18: '해당없음',
      Col19: '지원서추천서자원전공 관련 대외활동 실적 목록학업계획서(자기소개서 포함)대학졸업증명서 원본대학원졸업증명서 원본(석사학위 취득자에 한함)대학교 전과정 성적증명서 원본대학원 전과정 성적증명서 원본(석사학위 취득자에 한함)어학 시험성적 증명서 사본유학대학의 입학허가서 사본(해당자에 한함)자원전공 관련 대외활동실적 증빙서류 사본(해당자에 한함)병적증명서 또는 전역예정증명서(해당자에 한함)'
    },
    {
      Col1: '새문안교회',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 우수하고 (3.0/4.5/ 2.8/4.3 이상)',
      Col10: '학비 조달이 곤란한 자 ',
      Col11: '1000000원',
      Col12: '대학교 재학생으로서 본 교회에 등록한지 만 2년 이상 된 세례교인으로 교회 경건생활을 하며/ 구역에 편성되어 있고/ 교구 담당 목사의 추천을 받은 자본 교회 각 부서에서 봉사하고 있으며/ 그 부서장의 추천을 받은 자',
      Col13: '해당없음',
      Col14: '2020-01-09~2020-01-10',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '학교나 다른 기관으로부터 전액 장학금을 받고 있는 자',
      Col18: '소속 부서장(또는 소속 구역장)과 교역자의 추천서 제출',
      Col19: '장학금 신청서(소정양식) 1통명함판 사진 부착소속 부서장(또는 소속 구역장)과 교역자의 추천서성적증명서(직전 학기분)해당학교 2020년 2학기 장학금 수혜 또는 비수혜 증명서자기소개서1장 이내신앙간증문1장 이내 부모님(보호자) 통장 사본 기타 필요하다고 인정되는 서류'
    },
    {
      Col1: '조비경농장학재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학4학기/대학5학기',
      Col8: '자연계열',
      Col9: '4학기 이수자이며 매학기 15학점 이상을 이수한 자 2학년 전체 평점 평균 성적이 3.0 이상인 자*우선 선발 대상자총 평점 평균 4.25이상(4.5기준)보호자가 농업 종사자이거나 가계곤란자자기소개서 우수 작성자',
      Col10: ' * 우선 선발 대상자보호자가 농업 종사자이거나 가계곤란자(농촌 3년 이상 거주 및 기초생활수급자 등)',
      Col11: '2년간 등록금 전액 지급(3~4학년)',
      Col12: '조비/ 경농 장학재단이 지정한 대학 중 농업관련학과 2학년 재학중인 학생(2020년 3학년 진학예정자)농학계열/ 농업생명과학계열 전공자(해당 전공 여부를 반드시 본 재단에 확인 요망)',
      Col13: '해당없음',
      Col14: '2021-08-01~2021-08-15',
      Col15: '각 대학별 추천자 중 내부기준에 의거 서류심사 및 면접심사(필요시 전화면접)를 거쳐 최종 장학생선발*지정 대학 명단강릉원주대학교/ 강원대학교/ 건국대학교/ 경북대학교/ 경상대학교/ 고려대학교/ 서울대학교/ 순천대학교/ 안동대학교/ 전남대학교/ 전북대학교/ 제주대학교/ 충남대학교/ 충북대학교',
      Col16: '총 14명(각 대학별 추천학생 최대 3명 중 0~2명 선발)',
      Col17: '국비 장학금/ 교내외 장학금/ 기업체 학술연수 및 입사조건부 장학금을 받지 않는 자',
      Col18: '각 대학의 추천',
      Col19: '*필수 제출 서류장학생 지원서서약서재학 및 성적증명서(전 학년)자기소개서개인 정보 수집 및 활용 동의서*해당자 제출 서류보호자 농촌 거주 확인 서류(보호자 주민등록등본 등/ 주민등록번호 뒷자리 미포함으로 발급)보호자 농업 종사자 확인서류(농업인 확인서/ 영농 확인서 등)기초생활수급자 증명서(가계곤란자)외국어 성적 증명서 및 각종 자격증 사본'
    },
    {
      Col1: '선한목자교회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '심사위원회의 결정에 따른 차등 지급',
      Col12: '교육인적 자원부 인정 대학교 재학생으로 만27세 이하의 선한목자교회 등록 교인교회생활에 모범이 되며 봉사로 교회 부서를 섬기고 있는 학생으 학업을 계속하는데 경제적인 도움이 필요한 학생',
      Col13: '해당없음',
      Col14: '2022-01-24~2022-02-11',
      Col15: '해당없음',
      Col16: '45명 ( 선발분야 : 신학대학생 / 일반대학생 )',
      Col17: '대학원생타 기관 장학금 수혜자정당한 사유 없이 수여식 불참시 장학금 지급불가',
      Col18: '신청자가 섬기는 봉사 실무부서의 책임자가 작성한 추천서 제출',
      Col19: '장학금 신청서봉사 부서 실무책임자의 추천서지난 1년(두 학기)성적 증명서재학 증명서주민등록등본주민등록등본상 동거 부모님 각각 명의의 재산세 납부 증명원 및 미과세 증명원 생활보호 대상자 증명서(해당자)장학금 수령 통장 사본개인정보 활용 동의서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 심산장학문화재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정형편이 어려운 학생',
      Col11: '연간 3000000원(연 2회 분할지급)',
      Col12: '대학에 재학하고 있는 자로서/ 가정형편이 어려운 학생',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '신청정보심사자격요건확인최종선발',
      Col16: '대학교 재학생 OO명',
      Col17: '심사위원회에서 지급이 합당하지 않다고 판단되는 자',
      Col18: '해당없음',
      Col19: '장학금 신청서재학증명서직전학기(20212학기)가 표시된 성적증명서보호자의 소득 증명서류자기소개서가족관계증명서등록금고지서 사본본인명의 통장사본 * 자세한 사항은 홈페이지 내 공지사항 공고 참조'
    },
    {
      Col1: '홍천새마을금고',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '금고 이용실적이 2년 이상인 회원의 자녀(출자금 통장이 있어야 함)',
      Col13: '해당없음',
      Col14: '2021-01-01~2021-01-30',
      Col15: '새마을금고의 이용도/ 사업 참여도/ 재학중인 학교에 대한 평가/ 학년 평가 등을 기준으로 장학위원회에서 평가',
      Col16: '해당없음',
      Col17: '본 금고 장학금 기 수혜자의 동일 세대원 대상자는 공고일 기준으로 3년 이내 불가',
      Col18: '해당없음',
      Col19: '장학생 신청서 1부(홈페이지 공지사항 게시 www.hongcheonbank.co.kr) 주민등록등본 또는 가족관계증명서 1부 재학증명서 1부 학교장의 추천서 1부'
    },
    {
      Col1: '엔젤스헤이븐타조장학회',
      Col2: '타조장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '어려운 환경에 처해 있지만 배움에 대한 열정 노력 재능이 있는 자',
      Col11: '최대 1500000원 (교육비 또는 학업유지를 위한 생활비)',
      Col12: '대학교 재학생',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-07-29',
      Col15: '1차심사2차심사',
      Col16: 'O명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서 (반드시 신청자가 직접 수기로 작성)자기소개서 (반드시 신청자가 직접 수기로 작성)추천서 (컴퓨터 문서작성 가능)개인정보수집 동의서재학증명서 성적증명서 (직전 최근 년도 성적증명서 제출)주민등록등본 (세대원 포함)경제상황 증빙서류   : 기초생활수급자/ 차상위계층/ 일반 저소득층(차차상위 계층) 중 해당하는 서류 * 개인정보 보호를 위해 제출 서류에는 생년월일만 (주민등록번호 뒷자리 삭제) * 2018년 1월 1일 이후에 발급받은 서류만 인정 * 모든 제출서류 상단에 이름/ 학교명을 반드시 기재'
    },
    {
      Col1: '용문면장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 : 고등학교 전체학년 내신성적 평균등급이 4등급급 이내 * 재학생 4년제 : 직전 두학기의 평점평균 합산점수가 4.5기준 3.3이상2~3년제 : 직전 두학기의 평점평균 합산점수가 3.8이상인 학생',
      Col10: ' * 장학생 선발 우선순위 기준장학생 자격을 갖춘 학생 중 가정형편이 어려운 학생 우선 선정재산세 납부액이 적은 기준으로 함. 다만 재산세 납부액이 전무한 경우 기초수급생활자 차상위계층 순으로 한다.',
      Col11: '1000000원',
      Col12: '2015년 1월 1일 이전부터 경기도 양평군 용문면 관내에 주소를 두고 계속 거주하는 주민의 자녀로서/ 전문대·4년제 재학생이며 성적조건을 충족하는 자',
      Col13: '2015년 1월 1일 이전부터 경기도 양평군 용문면 관내에 주소를 두고 계속 거주하는 주민',
      Col14: '2022-03-01~2022-04-08',
      Col15: '장학생 자격을 갖춘 학생 중 가정형편이 어려운 학생 우선 선정',
      Col16: '4명 이내',
      Col17: '2022년도 양평군 및 양평군교육발전위원회에서 장학금의 수혜를 받은 경우공고내용 2 호에서 규정한 장학생의 자격요건에 부합하지 않을 경우',
      Col18: '해당없음',
      Col19: '장학금 선발지원서성적증명서 (단/ 신입생인 경우 고등학교 성적증명서)재학증명서장학생카드지방세 세목별 과세증명서(본인 및 부모)주민등록초본 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '광복장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 전(全)학년 평균 B학점 이상으로 품행이 단정한 자',
      Col10: '소득분위 9등급 이하 기초생활수급자(기준중위소득80%보장수준 포함)의 자녀확인원 첨부 ',
      Col11: '* (광복장학금)1인당 연간 4000000원(상하반기 분할 지급)  ※ 상반기 장학금 받고 휴학 후 복학하여 하반기 장학금 수여도 가능',
      Col12: '2022학년도 대학 재학자 중 2023학년도 졸업예정(최종학년)자로서 독립유공자 후손(1독립유공자 1후손) 증손자녀 이하(증손자녀 포함) 대학생독립유공자의 후손으로서 명예와 품위 및 올바른 역사의식으로 민족정기 선양에 모범이 되는 대학생자기소개서 첨부',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '총 10명 내외',
      Col17: '국가/ 사회복지기관 및 학교 또는 타 장학재단의 장학금 수혜자 등 중복지원 제한',
      Col18: '해당없음',
      Col19: '장학금 신청서 및 자기소개서(규정양식 제공본회 인터넷 홈페이지 첨부파일 참조)재학증명서(최근 1개월 내)성적증명서(전(全) 학년)기타 구비서류 일체(장학금 신청서 상의 구비서류 참조)  * 자세한 사항은 홈페이지 공고 참고'
    },
    {
      Col1: '한우리장학재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '한학기 성적이 3.70이상 B+ 이상자(4.5 만점 기준)4년제인 경우 1학년 성적이 3.70 이상',
      Col10: '보호자(부모님 합산)의 재산세 납부액이 300000원 이하인 자* 재산세 납부액이라 함은 재산세 과세 특려(구 도시계획세) 지역자원 시설세 교육세 등을 제외한 주택 건축물 토지에 대한 제산세 합계액을 보호자(부모님 합산) 연소득 금액이 5천만원 이하인 자(2014년도 기준)',
      Col11: '해당없음',
      Col12: '대한민국 국적 보유자로서/ 2016학년도 대학교 재학중인 자성적이 미달하지만 학과장/ 교수 및 단체장의 추천을 받은자',
      Col13: '해당없음',
      Col14: '2022-06-17~2022-07-17',
      Col15: '학교나 단체장의 추천서를 기준으로 확정* 단/ 심사후 부적격인 경우 학교나 단체에 재 추천을 요청함',
      Col16: '해당없음',
      Col17: '본 재단 외에 타 기관에서 장학금을 수혜받은 자학칙에 의한 징계 사실이 있는자',
      Col18: '각 학교별 추천',
      Col19: '장학금 지원 신청서 (소정 양식) 1부.장학생 추천서(학교/ 단체장 확인 및 날인) 1부.장학생 서약서(소정양식) 1부.성적증명서(1학년 전학기) 1부.재산세 과세 증명서 1부.보호자 소득금액증명서 (2014년도분) 1부.가족관계증명서 1부.'
    },
    {
      Col1: '한국전력전우회',
      Col2: '섬사랑장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '대학(전문대 포함) 1~4학년 재학생 또는 복학예정자 ',
      Col13: '(주)제이비씨의 66개 도서발전소가 위치하는 16개 지자체(시·군)거주자로 대상지역에 3개월 이상  본인 또는 직계비속의 주민등록 필요 * 대상지역 홈페이지 공고 또는 첨부파일 참조',
      Col14: '2022-07-12~2022-07-21',
      Col15: '지역장학생추천협의회 심사·평가한전전우회 섬사랑 장학위원회에서 선발 확정',
      Col16: '100명 (시/군별로 선발)',
      Col17: '한국전력공사 및 (주)제이비씨 직원 선발 제외',
      Col18: '해당없음',
      Col19: '장학금 신청서자기소개서개인정보의 수집·이용·제공 동의서 * 관련서류 양식은 홈페이지 참고/ 이메일 접수'
    },
    {
      Col1: '서울북노회',
      Col2: '장학생(일반학과)',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점평균 성적이 3.0 이상인 자',
      Col10: '기타 가정형편이 어려운 자(증빙할 수 있는 서류 제출)',
      Col11: '등록금의 약 1/3',
      Col12: '한신대학교 재학생으로 일반학과 재학생',
      Col13: '해당없음',
      Col14: '2021-03-10~2021-04-30',
      Col15: '해당없음',
      Col16: '3명',
      Col17: '장학금 수혜내역이 등록금액(2/3)을 초과하지 않는 자(교·내외 장학금 및 국가장학금 포함)직전학기 서울북노회장학금(일반학과) 수혜자 제외신학부/ 신학과/ 기독교교육학과 재학생학칙에 따라 징계내역이 있는 자',
      Col18: '해당없음',
      Col19: '장학금 신청서(자기소개서 포함)개인정보 활용 동의서성적증명서기타 가정형편이 어렵다는 것을 증빙할 수 있는 서류(해당자)기타활동(교내외활동/ 수상/ 사회봉사 등)을 증빙할 수 있는 서류(해당자)'
    },
    {
      Col1: '경기도노총장학문화재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '연 200만원~학기별 100만원 (1인당)',
      Col12: '비정규직 또는 저임금 근로자(월평균 급여 200만원 이하) 자녀 * 보호자 재산수준/ 소득수준/ 기업규모/ 재직기간/ 다자녀수 및 부모 부양 여부 등을 고려하여 선발함',
      Col13: '경기도내 거주 또는 경기도내 소재기업 근로자 및 근로자 직계가족',
      Col14: '2022-06-01~2022-06-30',
      Col15: '* 우선 순위노동조합운동의 유공자 자녀로서 이사회에서 인정하는 자신체장애로 인하여 재활교육을 받는 조합원 또는 근로자청소년 조합원 또는 근로자가 야간 정규학교에 재학중인 자유공/ 순직 조합원 또는 근로자의 유자녀생계에 곤란한 조합원 또는 근로자의 자녀/ 학업을 계속하기 어려운 자조합원 또는 근로자의 자녀',
      Col16: 'O명',
      Col17: '근로자/ 경기도(거주지/ 근무지) 해당사항이 없는 경우면제/ 전액 장학금 수혜 대상자 택시 장학재단/ 북부 장학재단 신청자공공기관/ 대기업/ 사업주기재사항 미 기재시/ 필요서류 미제출시 접수불가능대학원/ 유학/ 학력인정 안되는 기관은 지원 불가능 ',
      Col18: '해당없음',
      Col19: '장학금지급원서개인정보 제공 및 활용동의서재학증명서재직증명서 (해당 근로자)주민등록등본본인사진 (반명함판) 2매재산세 납부증명서 (부부합산)건강보험료 납부확인서 (부부합산)비정규직 확인서 (비정규직 장학금 신청자에 해당)근로자 전년도 원천징수영수증 (해당 근로자)통장사본 (우리/ 농협)'
    },
    {
      Col1: '범우출판문화재단',
      Col2: '범우출판장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상',
      Col8: '교육계열/사회계열/인문계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '4000000원(박사학위 논문 자료수집비 / 연구활동비 / 논문집 출판비에 한함)',
      Col12: ' 대학원 박사과정 2학차 이상을 이수하고 박사과정 재학 중인 자출판·언론·잡지·문학·역사를 전공하면서 박사학위 논문 계획(목차)이 확정된 자',
      Col13: '해당없음',
      Col14: '2022-07-08~2022-08-05',
      Col15: '서류심사 및 면접',
      Col16: 'O명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서 박사과정 전학차 성적증명서박사학위 논문 계획서장학금 이용 계획서자기소개서이력서 서약서'
    },
    {
      Col1: '청권사',
      Col2: '효령장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '최소 이수학점 10학점 이상인 자2022학년 1학기 성적 평점이 4.5점 만점의 경우 4.15점 이상/ 4.3점 만점의 경우 3.97점 이상인 자',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: ' * 효령대군 후손인 李 성씨 대학교 재학생으로 아래 해당자(하나이상 해당)기축보에 등재된 종원 또는 그 후손숭조돈종 정신이 투철하며 품행이 단정한 국내 4년이상 대학교 및 전문대학교 학생',
      Col13: '해당없음',
      Col14: '2020-08-10~2020-09-11',
      Col15: '해당없음',
      Col16: '총 300명',
      Col17: '본 장학회 기(旣) 2회 수여 학생각군 사관학교/ 경찰대/ 한국과학기술원 등 국비로 등록금을 받는 대학생신학과 학생대학원/ 방송통신대학교/ 사이버·디지털 대학교 재학생국내 대학교 재학중인 외국대학 유학학생(교환학생)1가구 1명 선발원칙',
      Col18: ' * 추천권자본사 임원/ 대의원/ 종실2·3·4세 종회장 및 문중대표는 자파 종회 또는 자파 문중 회원의 후손 학생에 대해 추천 가능',
      Col19: '효령장학금 신청 및 추천서계대기록표 (신규 신청자)재학증명서성적증명서특례자 인정 공인된 증명서 등(신규 신청자)가족관계증명서 또는 제적등본 (신규 신청자) * 서식 다운로드 및 자세한 사항은 홈페이지 참조'
    },
    {
      Col1: '서울농학교총동창회장학위원회',
      Col2: '동문장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 18학점 이상으로/ 학업 성적이 평균 3.0 이상인 자  (2학년 2학기(2년제) / 4학년 2학기(4년제)는 12학점 이상 이수)',
      Col10: '해당없음',
      Col11: '500000원',
      Col12: '서울 농학교를 졸업하고 국내외 대학에 진학한 자모교의 명예를 선양하고 학업이 우수한 자대학 재학생 중 학비 부담이 어려운 자서울농학교 총동창회 발전에 기여한 공로가 인정되고/ 학업에 전념한 자',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-07-28',
      Col15: '해당없음',
      Col16: '3명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '*접수처 : 서울특별시 강동구 성내로 22 청해빌딩 302호장학금 지원신청서장학생 추천서서약서동문회비 납부증명서재학증명서성적증명서'
    },
    {
      Col1: '바로크레디트',
      Col2: '사랑나눔장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학기 성적의 평점 평균이 3.8/4.5 이상 *만점이 4.3점의 경우 3.6/4.3점 이상',
      Col10: ' * 저소득층 대상자기초생활 수급자 또는 차상위 복지급여 수급자',
      Col11: '1000000원',
      Col12: '국내 4년제 대학교 재학생으로서 직전학기 성적의 평점평균이 3.8/4.5점 이상인 자로 저소득층 대상자',
      Col13: '해당없음',
      Col14: '2022-05-16~2022-05-25',
      Col15: '해당없음',
      Col16: 'OO명',
      Col17: '대학원생/ 사이버대학교 재학생 지원 불가초과학기 지원 불가휴학예정자 ',
      Col18: '해당없음',
      Col19: '자기소개서개인정보 수집·이용 동의서재학증명서 (복학생 : 복학관련 증명서류)성적증명서자격요건증명서 * 자세한 사항은 홈페이지 참조'
    },
    {
      Col1: '강화군산림조합',
      Col2: '조합원자녀장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '조합원 자녀 및 직계 손자손녀중 현재 고등학교/ 대학에 재학중인 자 조합원 신분을 3년 이상 보유한 조합원(2019년4월30일 이전가입)출자금(2022년 4월30일 현재) 200만원이상 납입한 조합원1가구 1자녀 지원',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '조합원 가입기간(20%)/ 조합이용실적(40%)/ 출자금 납입실적(20%)/  학생의 학교성적(20%) 항목을 심사하여 고득점자 순으로 선발',
      Col16: '27명',
      Col17: '조합원 자녀기준 총 2회에 한하여 지급하되 매년 연속지급은 불가하며 고등학교 1회/ 대학 1회 지원휴학생/ 해회유학생/ 대학원생은 선발대상에서 제외사이버대학/ 방송통신대학의 재학생은 제외 ',
      Col18: '해당없음',
      Col19: ' * 우편 또는 방문접수 (강화군산림조합 기술지도과)재학생신청서 (조합 또는 홈페이지 참고)재학증명서2021년도 성적증명서 조합원의 가족임을 증명할 수 있는 서류 (주민등록등본 또는 가족관계증명원)'
    },
    {
      Col1: '한화케미칼',
      Col2: 'R&D석박사산학장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열',
      Col9: '학부 평점 B학점 이상',
      Col10: '해당없음',
      Col11: '등록금 전액 지원 학업 보조비 지원 논문 제작비 지원(추후 학위 취득 후 입사)',
      Col12: '현재 석/ 박사 과정에 재학 중이며 2년 내 학위취득 및 한화케미칼로의 입사가 가능한 자(대전/ 판교 근무 예정)유기화학/ 유기 금속 합성/ 폴리머 합성 및 분석/ 유기합성/ 촉매/ 분리정제/ 반응공학/ 공정설계 등을 전공한 자관련 연구 경험이 있는 자졸업 후 당사 입사 희망자',
      Col13: '해당없음',
      Col14: '2022-07-01~2022-07-20',
      Col15: '서류접수면접전형',
      Col16: '해당없음',
      Col17: '타사의 장학금을 받지 않는 자해외여행에 결격사유가 없는 자',
      Col18: '해당없음',
      Col19: '*입사 지원서 작성 시 본인 사진 제출은 필수 사항이 아닙니다.*한화그룹 채용사이트 \'한화인\'에서 인터넷 접수만 가능'
    },
    {
      Col1: '인천민주화운동계승사업회',
      Col2: '민주화운동자녀 장학및생활지원',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원 이내',
      Col12: '본인 또는 본인의 부모나 형제가 민주화운동에 참가했을 것한 번 지원받은 사람(가족)도 특별한 사유가 있으면 신청 가능본 장학복지사업회 후원회원 추천을 통해서 신청 가능(추천 대상자는 한 단체나 한 노동조합에서 3인을 넘지 않는다.)',
      Col13: '지금 현재 인천에 실제 거주하는 자(인천에서 사망한 열사의 유가족의 경우는 예외)',
      Col14: '2022-04-11~2022-05-13',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '본 장학복지사업회 후원회원 추천을 통해서 신청 가능(추천 대상자는 한 단체나 한 노동조합에서 3인을 넘지 않는다.)',
      Col19: '주민등록등본수급자 증명서 혹은 의료급여증명서수급자 혹은 의료급여증명서가 없는 경우 의료보험 납입 증명서 * 첨부파일 참고'
    },
    {
      Col1: '노원교육복지재단',
      Col2: '장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 4.0(4.5만점 기준) 이상인 자 * 신입생의 경우 해당 없음',
      Col10: ' * 아래조건 모두 충족기준 중위소득 120% 이내 재산기준 : 310000000원 이하(부채 포함)',
      Col11: '2000000원',
      Col12: '만 29세 이하 4년제 대학교 재학생 * 1993년 1월 1일 이후 출생자학업에 열의가 있고 학교생활에 모범적인 대학생',
      Col13: '공고일 기준 노원구에 주민등록주소를 두고 거주하고 있는 저소득 가구 학생',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '만 29세 초과자휴학생전문대학교/ 방송통신대학교/ 사이버대학교/ 학점은행제대학교 재학생2022년도 타 기관 장학금 수혜자',
      Col18: '동주민센터/ 사회복지유관기관의 추천을 받은 자',
      Col19: '장학금 신청 공문(신청기관)장학금 신청 대상자 명단 (신청기관) 장학금 신청서자기소개서장학금 추천서 또는 생활실태조사서신청인 및 학부모 동의서개인정보 조회·제공 및 활용 동의서보건복지 통합서비스 개인정보 제공동의서통장 사본소득 증빙서(택1)대학교 재학증명서성적증명서(재학생) * 자세한 서류와 양식은 노원교육복지재단 홈페이지에서 확인'
    },
    {
      Col1: '서울시사회복지협의회',
      Col2: '사회복지종사자자녀장학',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '서울특별시 소재 사회복지현장에서 일하고 있는 사회복지종사자의 대학생 자녀사회복지 종사기간이 3년(36개월) 이상인 자의 자녀',
      Col13: '해당없음',
      Col14: '2021-08-02~2021-08-13',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '기존 동일사업을 통해 장학금을 수여받은 자실 납부금과 비교하여 수여될 장학금이 초과하는 자 ',
      Col18: '해당없음',
      Col19: '2019년 서울특별시 사회복지종사자 자녀 장학사업 신청서(첨부양식_붙임1) 1부성적증명서(직전학기) 1부종사자 재직증명서(경력있는 경우 경력증명서 첨부 필) 1부서울특별시 사회복지종사자 자녀 장학사업 기관장추천서(첨부양식_붙임2) 1부가족관계증명서 1부2018년도 원천징수영수증 종사자/ 배우자 각 1부2018년도 지방세(재산세) 세목별 과세증명서 종사자/ 배우자 각 1부(재산이 없어도 반드시 제출해야함)개인정보 수집/ 이용 제공동의서(첨부양식_붙임3) 1부※ 우편 및 방문 접수'
    },
    {
      Col1: '김천농협',
      Col2: '성적우수장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 15학점 이상 이수',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '2020. 8. 31일 이전 김천농협 가입 조합원 (손)자로서/ 고등교육법 제2조의 대학에 재학 중인 학생학업성적이 준수하고 타의 모범이 되는 학생',
      Col13: '손자녀의 경우 공고일 기준 1년 전부터 선발대상 손자녀의 조부모가 모두 김천에 주소를 두고 있어야 함 ※ 양부모 결손가정 (손)자녀의 경우 제한 없음',
      Col14: '2021-08-02~2021-08-13',
      Col15: '학교성적(50%) + 조합사업 이용실적(30%) + 조합원 경력(20%) 합산성적순',
      Col16: '112명',
      Col17: '최근 3년간 김천농협 장학금을 수혜받은 (손)자녀가 있는 조합원 제외 복수(다수)조합원의 자녀일경우/ 조합원 1자녀만 신청가능농·축협/ 품목농협/ 농협중앙회/ NH농협은행에 근무하는 직원의 자녀 및 (손)자녀 신청불가방송·통신대학/ 사이버대학/ 기술대학/ 각종학교 등은 제외 * 자세한 사항 첨부파일 참조',
      Col18: '해당없음',
      Col19: '김천농협 조합원 자녀 장학생 선발 신청서성적 및 재학을 확인할 수 있는 서류조합원 주민등로등본 또는 가족관계증명서김천농협 개설 신청인(학생) 명의의 계좌 사본 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '김천농협',
      Col2: '특기장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '2020. 8. 31. 이전 김천농협 가입 조합원 (손)자녀고등교육법 제2조의 대학/ 산업대학/ 교육대학/ 전문대학 재학생으로서 예·체능분야 도·전국단위이상 기관 및 단체가 주최한 대회 입상자',
      Col13: '해당없음',
      Col14: '2022-08-03~2022-08-29',
      Col15: '입상성적(50%) + 조합사업 이용실적(30%) + 조합원 경력(20%) 합산성적순',
      Col16: '8명',
      Col17: '최근 3년간 김천농협 장학금을 수혜받은 (손)자녀가 있는 조합원 제외 복수(다수)조합원의 자녀일경우/ 조합원 1자녀만 신청가능농·축협/ 품목농협/ 농협중앙회/ NH농협은행에 근무하는 직원의 자녀 및 (손)자녀 신청불가방송·통신대학/ 사이버대학/ 기술대학/ 각종학교 등은 제외 * 자세한 사항 첨부파일 참조',
      Col18: '해당없음',
      Col19: '김천농협 조합원 자녀 장학생 선발 신청서2019년도 예/체능계 도/전국단위 기관 및 단체 주최대회 입상증명서조합원 주민등록등본(자녀와 세대를 같이할 경우) 또는 가족관계증명서 * 손자녀의 경우 주민등록등본과 부모기준 가족관계증명서'
    },
    {
      Col1: '구세군만영장학위원회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/학점은행제 대학/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 우수한 자',
      Col10: '가정형펀이 어려운 학생생',
      Col11: '일정규모 (선발 시 세부지원규모 확정) * 타 장학금을 등록금의 50%이상 지원받는 학생의 경우 선발회의 결과에 따라 장학금 지급액에 차이가 있을 수 있음',
      Col12: '국내 및 해외 교육기관에서 정규학교로 인정하는 대학교/대학원 또는 이와 동등한 학교의 유학생 또는 입학 예정자',
      Col13: '해당없음',
      Col14: '2022-07-19~2022-08-04',
      Col15: '해당없음',
      Col16: '장학재원 규모 등에 따라 유동적',
      Col17: '학비면제자/ 무상교육자전액장학생심사에 따라 적격자가 되지 못 할 경우 제외 될 수도 있음',
      Col18: '해당없음',
      Col19: '장학생선발지원서 및 추천서재학증명서 및 성적증명서2022년 2학기 등록금 고지서주민등록등본지방세 세목 과세증명서기타(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '대한토목학회',
      Col2: '토목부문장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/자연계열/특정학과',
      Col9: '누적성적 평점이 3.3/4.0(만점) 이상인 자 ',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '토목관련학과 대학생/ 대학원생학부: 2022년 7월 기준 5학기 이상 등록한 자 대학원: 2022년 7월 기준 입학예정자 이상',
      Col13: '해당없음',
      Col14: '2020-07-10~2020-07-22',
      Col15: '심위위원 서류심사 후 장학생 선발',
      Col16: '학부생 1명 이상/ 대학원생 1명 이상',
      Col17: ' * 2022년 9월 졸업/수료예정자 제외 * 휴학생/ 타과로 전전과시 제외',
      Col18: '지도교수/ 학과장의 추천(대학 학과별로 학부생 1명/ 대학원생 1명 추천)',
      Col19: '장학금 신청서자기소개서 및 수학계획서재학증명서누적성적증명서(대학원생 신입생은 직전학기까지 성적증명서 제출)학부 성적증명서(대학원생) * 자세한사항은 첨부자료 참고'
    },
    {
      Col1: '청웅면장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학교 성적이 우수한 자',
      Col10: '가정형편이 어려운 자',
      Col11: '1000000원',
      Col12: '전북 임실군 청웅면에 거주하는 면민의 자녀로서 가정형편이 어려우며 학교 성적이 우수한 자 선발 * 자세한 사항 기관으로 문의',
      Col13: '전북 임실군 청웅면에 거주하는 면민의 자녀',
      Col14: '2021-07-19~2021-07-23',
      Col15: '해당없음',
      Col16: '3명',
      Col17: '각종 단체에서 지원되는 장학금 수혜자는 제외',
      Col18: '해당없음',
      Col19: '장학생 지원서재학증명서성적증명서주민등록등본 1통건강보험납부내역서 1통 * 지원서 양식 다운로드 및 자세한 사항 확인은 임실군 청웅면 홈페이지 > 새소식 > 이장회보에서 확인 ** 접수처 : 청웅면사무소'
    },
    {
      Col1: '농소농협',
      Col2: '농소농협 장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평균평점이 3.0이상인 일반대학생 및 전문대학 재학생',
      Col10: '해당없음',
      Col11: '4년제 이상 : 1000000원전문대 : 700000원',
      Col12: '농소농협 이용고객의 자녀 또는 조합원의 자녀',
      Col13: '해당없음',
      Col14: '2022-02-08~2022-02-15',
      Col15: '농소농협 자체 선발기준표에 의거 선발',
      Col16: '  * 총 52명조합원 자녀 : 일반대(22명)/ 전문대(4명)준·비조합원 자녀: 일반대(22명)/ 전문대(4명)',
      Col17: '농협 임직원의 자녀는 신청 불가함 (비정규직 및 비상임임원은 제외)해외유학생1세대당 1명 선발 원칙',
      Col18: '해당없음',
      Col19: '장학생 선발신청서개인(신용)정보 조회 동의서학생기준 가족관계증명서학업성적증명서총장 추천서 ※ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '연재장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체 학년 누계평점점 3.0 이상인자',
      Col10: '가정형편이 곤란한자',
      Col11: '2500000원(등록금 범위내 지원) * 등록금범위 내 타 장학금 수혜 가능',
      Col12: '2022학년도 1학기 재학 예정자품행이 방정한 자',
      Col13: '해당없음',
      Col14: '2022-01-27~2022-02-09',
      Col15: '해당없음',
      Col16: '1명   * 각 학교마다 추천인원이 다를 수 있음',
      Col17: '연재장학재단 장학금 기수혜자 제외',
      Col18: '담당 교수 또는 학과장',
      Col19: '부모의 2021년 건강보험료납부확인서 및 건강보험증 사본 각 1부개인정보동의서성적증명서재학증명서추천서 (담당교수 또는 학과장 서명 필수) * 각자 해당하는 추가서류 학교 홈페이지에서 확인.'
    },
    {
      Col1: '공익활동가사회적협동조합동행',
      Col2: '공익활동가학자금지원사업',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 1000000원',
      Col12: '동행 가입 6개월 이상 조합원본인 : 대학(원)에 재학중인 조합원자녀 : 고등/대학교에 재학 중인 조합원의 자녀',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '배분위원회 심사 후 선정 ',
      Col16: '50명 내외',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서재직증명서재학증명서 또는 입학예정증명서건강보험료 납부확인서등록금(수업료)고지서통장사본가족관계증명서 또는 주민등록등본 * 이메일 또는 온라인 접수로 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '합동신학대학원대학교',
      Col2: '합신사랑장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '본교 재학시 전학년 평균 B+이상',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '학문성이 인정되는 외국(신)학교에서 석·박사 학위 입학 허가를 받은 자TOEFL 580점 이상 취득자IELTS 6.5이상 취득자',
      Col13: '해당없음',
      Col14: '2021-01-11~2021-02-28',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '유학 장학금 신청서 (본교 소정 양식)본교 전학년 성적증명서유학하고자하는 학교의 입학 허가서 또는 유학하고있는 학교의 재학증명서TOEFL/ IELTS 및 이에 준하는 시험점수 통보서지도교수 추천서 및 성적증명서연구계획서학비조달계획서(생활비와 수업료 포함)목사추천서이력서(최근 3개월 이내 촬영한 본인사진과 가족사진 첨부/ 본교 소정 양식) '
    },
    {
      Col1: '산외면장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 우수하고 품행이 방정(方正)한 자',
      Col10: '가정형편이 어려운 학생 및 기타 장학회에서 장학금이 필요하다고 인정하는 학생',
      Col11: '1인당 800000원',
      Col12: '대학교(전문대학 포함)에 재학중이거나 2020년도 대학교 입학예정자인 학생장학회비를 3회 이상 납부한 가정의 학생 ',
      Col13: '부나 모가 산외면에 주소를 두고 추천일 현재 5년 이상 계속해서 실제 거주하고 있는 주민으로 대학교(전문대학을 포함)에 입학/ 재학 중인 학생',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '산외면장학회 사무국 직접방문 후 신청',
      Col16: '6명',
      Col17: '접수 후 신청서류 미비 및 허위 작성 시에는 탈락함상기 계획은 장학회의 사정에 따라 변경될 수 있음 ',
      Col18: '해당없음',
      Col19: '장학생 신청서 1부재학증명서 1부장학생 추천서 1부성적증명서 부 부 또는 모의 주민등록초본 1부  *자세한 내용은 홈페이지 참조바람람'
    },
    {
      Col1: '전주교육대학교교육대학원',
      Col2: '가계곤란장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/특정대학',
      Col7: '석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가계가 곤란한 자',
      Col11: '2019학년도 1학기 등록금 총액의 3%(지급단가는 총장이 결정함)',
      Col12: '2019학년도 1학기 교육대학원 신입생',
      Col13: '해당없음',
      Col14: '2022-03-07~2022-03-31',
      Col15: ' < 추천 우선순위 >부모가 국민기초생활보장법에 의한 수급자부모가 의료급여법에 의한 수급권자모/ 부자 세대(편부모 세대)가족 중 장애인이 있는자다자녀 세대인 자(3명 이상)형제/ 부부 또는 부모자녀 세대가 동시에 우리 대학에 재학중인 자기타 경제적 사정이 곤란한다고 인정되는자',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '가계곤란 장학생 추천서가족관계증명서 또는 주민등록등본기초생활보장수급자 증명서/ 차상위본임부담금경감대상자증명(해당자)한부모가족증명서(해당자)장애인 증명서(해당자)재학증명서(형제/ 부부/ 부모세대가 동시에 재학중인자)건강보험료 납부확인서(해당자)'
    },
    {
      Col1: '봉화정씨문헌공종회장학위원회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 4년제 대학교 : 직전학기 17학점 이상 이수/ 평균평점 3.3 이상 전문대학교 : 직전학기 17학점 이상 이수/ 평균평점 4.0 이상※ 계절학기 인정 불가/ 군제대 복학생은 휴학 직전의 학기 성적으로 심사',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '문헌공 문중 자제(子弟)중 국내 4년제 정규 대학생과 전문대 학생으로서 숭조 사상이 투철하고/ 국가와 사회에 기여할 동량이 될 수 있다고 인정되는 후보자',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '접수된 서류는 종회 장학위원이 본회 심사내규에 의거/ 학교·전공학과 그리고 성적 등을 심사하여 종회 2022년도 장학위원회 예산 범위 내에서 선발·결정',
      Col16: '해당없음',
      Col17: '사이버대학생/ 방송통신 대학생/ 국고보조 대학생은 제외',
      Col18: '문헌공대의원(각 공파)의 추천',
      Col19: '문헌공대의원 추천서(본회 소정양식)재학증명서직전학기 성적증명서가족관계증명서반명함판사진(추천서 부착) * 자세한 사항은 기관 카페 내 공지사항 게시판 참조'
    },
    {
      Col1: '한국외국어대학교생활협동조합',
      Col2: '생협복지장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 2.5 이상인 자.',
      Col10: '해당없음',
      Col11: '(월)300000원 * 4개월 = 1200000원',
      Col12: '본교 글로벌캠퍼스에 재학중인 학부생',
      Col13: '해당없음',
      Col14: '2022-03-07~2022-03-18',
      Col15: '※ 홈페이지 선발공고 확인 바람 * 선발 조건 및 해당사항생협 복지장학생은 선발 후 매주 2시간의 의무근로를 이행해야 함근로의무 미준수시 상담 후 장학금 지급이 중단될 수 있음.',
      Col16: '총 10명',
      Col17: ' 우리대학 생협 조합원이 아닌자직전학기 성적이 2.0 이하인 자.  1학년 1학기 및 4학년 2학기에 재학중인 자.연속해서 2회 생협 복지장학금을 수혜한 자.부모의 지방세 총액이 40만원을 초과하는 자.',
      Col18: '해당없음',
      Col19: '생협복지장학금 수혜신청서 및 개인정보이용동의서사진 필히부착재학증명서 1부직전학기 성적증명서 1부추천서 1부 (학과장 또는 전임교수)자기소개서 1부 (조합 소정양식)보호자 주민등록등본 1부  * 주민등록상 본인과 보호자의 거주지가 다를 경우 본인용 별도 1부 첨부지방세 세목별 과세 증명서 : 부모 각각 1부건강보험료 납부확인서 1부기타 가계곤란을 증명할 수 있는 각종 서류 (해당자만 제출) * 생활보호 대상자 증명서/ 수해확인 증명서/ 실직확인서 등 '
    },
    {
      Col1: '김제농협',
      Col2: '조합원자녀장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원 (납입금액이 100만원 이하인 경우에는 실 납부금액) ',
      Col12: '2019.12.31. 이전 조합원에 가입하여 2022년 1학기 자녀 대학교 등록금(수업료)을 납부한 조합원본 농협에서 기 지급한 장학금을 수혜 받지 아니한 자녀를 둔 조합원',
      Col13: '김제농협의 조합원(2019.12.31일 이전 가입자) 자녀로서 국내소재 전문대학 이상의 대학재학생',
      Col14: '2020-07-14~2020-07-24',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '방송통신대학과 평생교육법에 의해 설립된 원격대학(사이버대학)다른 장학재단/ 기관/ 기업/ 학교 등으로부터 2022학년도 1학기 등록금에 대하여 (가) 전액에 대한 장학금 수혜를 받았거나 면제 받은 자는 대상에서 제외(나) 납입한 금액이 지급 할 장학금 이하 납부자는 실 납부금액전년도 신용 및 경제사업 무거래자 ',
      Col18: '해당없음',
      Col19: '장학생 지원신청서개인신용정보 수집/이용/제공동의서2022년 1학기 등록금납입 영수증 또는 교육비 납입증명서주민등록등본 또는 가족관계증명서건강보험자격득실확인서 (학생문의) 조합원 신분증 * 조합원 또는 그 가족이 접수 * 조합원으로 등록된 본점 또는 지점에서 접수 * 자세한 사항은 홈페이지 참고 '
    },
    {
      Col1: '한국반도체산업협회',
      Col2: '반도체장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/자연계열/특정학과',
      Col9: ' ※ 우선 선발대상자 (학부)반도체관련과목 성적 우수자 및 교과목 이수자로/ 평균평점 평점 B+ 학점 이상인 자반도체관련 공모전 입상자 또는 인턴 참여 학생졸업 후 반도체 기업 입사 희망자',
      Col10: '해당없음',
      Col11: '10000000원 * 2021년도 학비 및 자기계발비',
      Col12: ' * 대한민국 국적의 대학 4학년 또는 석박사 과정 재학 예정인 반도체 관련 분야 이공계학생장학사업 Follw up 서비스 참여가 가능한 학생 * 우선 선발 대상자(대학원) : 우수 논문 발표자/ 졸업 후 반도체 기업 입사 희망자 * 우선 선발 대상자(학부) : 관련과목 성적 우수자 및 관련 공모전 입상자 또는 인턴 참여학생/ 졸업 후 반도체 기업 입사 희망자',
      Col13: '해당없음',
      Col14: '2020-12-14~2022-12-27',
      Col15: ' * 선발 절차 출연 기업 인사팀의 서류 심사 진행 → 인터뷰 대상자 임원진들과 화상 인터뷰 → 장학금 출연 및 장학증서 수여',
      Col16: '대학별 추천인원 1명',
      Col17: '동일 학기 중 타 장학금과 중복수혜 불가',
      Col18: '각 대학 총장 또는 이공과대학 학장',
      Col19: '장학금 신청서(추천서)추천학생 이력서자기소개서논문기술서개인정보 수집·이용 및 제공 동의서(재단 및 학교 각 1부) * 기관에서 학교로 추천을 의뢰하는 장학금이므로/ 재학하는 학교의 학과사무실 또는 장학부서로 문의'
    },
    {
      Col1: 'SKC&C',
      Col2: 'AI산학장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 및 연구지원금 지원',
      Col12: 'AI 관련 모든 분야의 석사 1~3학기/ 박사 coursework 수료 (예정) 이상~5학년 1학기 (석/박사 통합 동일)남자의 경우 병역 필 또는 면제자보훈대상자는 관계 법령에 의거하여 동일  ',
      Col13: '해당없음',
      Col14: '2020-08-03~2020-08-21',
      Col15: '서류지원SKCT면접최종발표',
      Col16: '해당없음',
      Col17: '해외여행에 결격사유가 있는 자ㅣ',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '수동농협',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: ' * 우리 농협(수동농협) 조합원 자녀로서 국내 재학 중인 대학생 ',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-08-10',
      Col15: '평가항목 : 조합원가입기간(15점)/ 농협거래기여도(25점)/ 학생성적(15점)/ 전년도 이용고배당 점수(30점)/ 납입출자금(15점)/ 가산점 항목들 * 자세한 사항은 첨부파일 참조',
      Col16: '15명',
      Col17: '사이버대학교 재학생 조합원 본인이 대학생인 경우특수채권(상각채권) 보유 조합원가족17년도~19년도 장학금 수혜자 및 휴학자19년도 8월 3일 이후 신규 조합원 가입자이용고 실적이 조합원 평균 실적 하위 20% 이하인 조합원 * 자세한 사항은 첨부파일 참조',
      Col18: '영농회장의 장학생 추천을 받은 자',
      Col19: '장학생지원신청서재학증명서직전학기 성적증명서가족관계 확인할 수 있는 주민등록등본 또는 가족관계증명서조합원본인 신용정보제공동의서 및 신분증 사본 * 세부 사항은 수동농협 홈페이지 참조'
    },
    {
      Col1: '재단법인민들레장학회',
      Col2: '비전장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '차상위계층 자녀 한부모(조부모) 자녀 다문화가정 자녀 다자녀 가정 (3인 이상) 고아 등',
      Col11: ' * 기관으로 문의 바랍니다.',
      Col12: '국내 대학생 재학생(대학원생 포함)장학금 지금일 기준 다음학기 복학 예정인 자자올바른 인성과 배려/ 비전을 품고 있으며 지도교수 및 단과대학장의 추천을 받은 자',
      Col13: '해당없음',
      Col14: '2022-07-25~2022-08-10',
      Col15: '서류심사',
      Col16: '해당없음',
      Col17: '타장학금과의 중복혜택 불가능',
      Col18: '지도교수 및 단과대학장의 추천을 받은 자',
      Col19: '지원신청서주민등록등본성적증명서재학증명서추천서통장사본차상위계층 증명서(해당자)어학성적/ 수상경력증명서/ 사회봉사활동 경력증명서 등 참고할 수 있는 관련서류(해당자) * 자세한 사항은 기관 홈페이지 참조'
    },
    {
      Col1: '재단법인민들레장학회',
      Col2: '드림장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적 우수자로 장학금 신청 기준 직전학기 성적이 상위 30% 이내인 자(복학예정자는 휴학 직전학기) ',
      Col10: '해당없음',
      Col11: ' * 기관으로 문의 바랍니다.',
      Col12: '대학생(대학원생 포함) 재학생장학금 지급일 기준 다음학기 복학 예정인 자본인의 계획 및 비전을 구체적으로 밝힐 수 있는 자올바른 인성과 배려/ 비전을 품고 있으며 지도교수 및 단과대학장의 추천을 받은 자',
      Col13: '해당없음',
      Col14: '2021-09-28~2021-09-30',
      Col15: '서류심사',
      Col16: '해당없음',
      Col17: '타 장학금과의 중복혜택 불가능',
      Col18: '지도교수 및 단과대학장의 추천을 받은 자',
      Col19: '지원신청서주민등록등본성적증명서재학증명서추천서통장사본소득증빙서류(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '함흥시장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업 성적이 우수한 자',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '학업성적이 우수하나/ 경제적으로 도움을 받고 싶은 자정규대학/ 전문대학 재학생(만 28세 미만/ 4학년 제외)함흥시 청년회 활동에 적극 참여할 자',
      Col13: '함경남도 함흥시 출신 손자녀',
      Col14: '2020-10-19~2020-10-30',
      Col15: '가정환경/ 향토기여도/ 학업성적',
      Col16: 'O명',
      Col17: '타 기관에서 연간 등록금 이상 장학금을 받는 자',
      Col18: '해당없음',
      Col19: '지원서가정환경조사서성적증명서재학증명서국가장학금 지급내역서(1학년부터 현재까지)사진(3*4cm/ 반명함판) 2매주민등록등본 및 가족관계증명서제적등본(함흥시 후손 확인용)*서류 교부 : email(전화 문의 요망)'
    },
    {
      Col1: '대구광역시체육회',
      Col2: 'FISU및대구체육장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '예체능계열',
      Col9: '해당없음',
      Col10: '생계곤란 선수 : 기초수급자 차상위계층 자녀',
      Col11: '1200000원',
      Col12: ' * 대구시체육회 또는 대구시 장애인 체육회에 선수로 등록을 필한 자(일반장학생) 종목별 전국규모대회 3위 이내 입상자(특별장학생) 생계곤란선수(장애학생선수) 종목별 전국규모대회 3위 이내 입상자로 장애인체육회장의 추천을 받은 자 ※ 자세한 사항은 첨부파일 참조/ 대회적용기간 : 2019.10.11 ~ 2020.10.18',
      Col13: '공고일 현재 대구시체육회 또는 대구시 장애인 체육회에 선수로 등록을 필한 자',
      Col14: '2020-11-02~2020-11-20',
      Col15: '해당없음',
      Col16: ' * 총 82명',
      Col17: '타 기관 장학금 수혜 중인 학생추천일 현재 휴학 또는 유학 중인 학생기타 품행이 올바르지 않은 학생',
      Col18: ' * 추천권자 : 총(학)장/ 회원종목단체장/ 장애인체육회장대구소재 운동부육성 학교장 : 학교별 1명대구시체육회 회원종목단체장 : 종목별 1명대구광역시장애인체육회 : 정원범위 내',
      Col19: '추천서지원신청서재학증명서경기실적증명서개인정보제공 동의서본인명의 통장 사본소득 증빙서류(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '이형만영광군향우장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업 성적이 뛰어나거나 특기 관련 공적 증빙자료를 제출할 수 있는 자',
      Col10: '해당없음',
      Col11: ' * 자세한 사항은 해당 기관으로 문의',
      Col12: '영광군민 및 재광 영광군향우회 회원 자녀 중 대학교 재학생으로 애향심이 투철하고 품행이 단정하며/ 특기 및 학업 성적 등 미래의 비전이 뛰어난 학생',
      Col13: '2019년 10월 1일 현재 영광군이나 광주광역시에 주민등록이 된 부모를 둔 학생',
      Col14: '2022-02-28~2022-03-04',
      Col15: '해당없음',
      Col16: ' * 총 24명 선발(중·고등학생 포함인원) ',
      Col17: ' * 자세한 사항은 해당 기관으로 문의',
      Col18: '영광군민의 자녀 중 영광군수가 추천한 학생학교장 또는 기관장 추천서 제출',
      Col19: '해당 기관장 또는 학교장 추천서공적 조서(해당 분야 자료 사본 첨부)가족관계증명서재학증명서성적증명서통장 사본개인정보이용동의서글쓰기 작품 1점 : 자유 * 우편 및 방문접수로 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '(재)서울대학교발전기금',
      Col2: '최혁영장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학3학기',
      Col8: '공학계열',
      Col9: '직전학기 성적 2.00이상(4.3만점)으로 학업성적이 우수한 학생',
      Col10: '가정 형편이 어려운 학생',
      Col11: '등록금에서 국가장학금을 제외한 금액 졸업 시까지 ',
      Col12: '20221학기 기준 3학기째인 정규등록 학부생국가 장학금을 제외한 타 장학금을 수혜받지 않은 학생생',
      Col13: '해당없음',
      Col14: '2022-09-05~2022-09-30',
      Col15: '해당없음',
      Col16: '1명 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '학교마다 다르므로 공지사항 참조 바람 장학금 지급 신청서 양식 1부지도교수 추천서 양식 1부 장학금 선발 면접 check list 양식 1부가계곤란 장학금 서류준비 안내 1부 '
    },
    {
      Col1: '한양대학교기술경영전문대학원',
      Col2: '사랑의실천장학금(대학원)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '전문대학원/특정대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '특정학과',
      Col9: ' 직전학기 평점 2.0이상 * 신입생의 경우 제한없음',
      Col10: '기초생활수급자 또는 차상위계층 증빙 가능 가정의 정규과정 재학생',
      Col11: '1000000원 * 학비감면 장학금이므로 기수혜 교내장학금(학비감면)과는 중복수혜불가',
      Col12: '한양대학교 기술경영전문대학원 재학생으로 기초생활수급자 증빙서류 또는 차상위계층 증빙서류를 제출할 수 있는 자',
      Col13: '해당없음',
      Col14: '2021-09-15~2021-10-01',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '재학증명서기초생활수급자 증명서 또는 차상위계층 증명서 * 소속 학과 대학 행정팀으로 접수/ 자세한 사항 첨부파일 참조'
    },
    {
      Col1: '재단법인 정암재단(성북)',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '생활환경이 어려운 학생',
      Col11: '1000000원  ( * 생활비 지원)',
      Col12: '2021년도 덕성여자대학교 재학생으로 생활환경이 어려우며 성실하고 모범이 되는 학생',
      Col13: '해당없음',
      Col14: '2021-10-25~2021-11-15',
      Col15: '해당없음',
      Col16: '20명',
      Col17: '등록금을 초과하는 타 장학금 수혜자는 제외',
      Col18: '해당없음',
      Col19: '장학금 신청서자기소개서 * 자세한 사항은 첨부파일 참고 바랍니다.'
    },
    {
      Col1: '옥한흠장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 우수한 학생',
      Col10: '재정사정이 어려운학생',
      Col11: '2000000 ~ 5000000원 ',
      Col12: '국내 외 대학원 및 대학 재학생/ 휴학생으로 학업성적이 우수한 자 아래 대상자를 우대할 수 있음.  1) 미자립교회 목회자 및 해외선교사 자녀  2) 장애인 및 장애인 가정의 자녀',
      Col13: '해당없음',
      Col14: '2022-08-11~2022-08-25',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '본 장학금 수여일을 기준으로 선정 수혜자가 다른 장학금을 받는 경우 장학금 지원 대상에서 제외2022년 9월 학기 외국대학 또는 대학원 입학 예정 학생휴학생의 경우에는 2022년 봄학기에 등록하는 경우에 한함 ',
      Col18: '지도교수 또는 총/학장의 추천기독교인의 경우 소속교회 담임목사의 추천',
      Col19: '장학금 지원서(소정양식)자기소개서 (소정양식)재학증명서 및 전(全)학년 성적증명서소속학교의 추천서가족관계증명서기독교인인 경우 소속교회 담임목사의 추천서(사랑의 교회 교인인 경우는 소속부서 또는 지역담당 교역자 추천서)미자립교회 목회자 자녀의 경우 해당교회 최근 주보 1매기타 위원회가 필요시 추가로 요구하는 서류'
    },
    {
      Col1: '대덕장학회(고양시대덕동)',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학/ 대학교(방송통신대/ 사이버대 등 제외) 학생 중 학기말 성적이 70점(백분률) 이상인 자 ',
      Col10: '기초생활수급자 소년 소녀가장',
      Col11: '4년제 : 1500000원전문대 : 1000000원',
      Col12: '기능/ 체육/ 예능 등의 보유자로 전국 규모이상 대회에서 입상한 자 ',
      Col13: '공고일 현재 3년 이상 대덕동 관내 주민등록상 및 실거주 보호자의 자녀로서 아래 사항에 충족한 자',
      Col14: '2020-09-04~2020-10-26',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '제 22회 대덕장학회(2021년 상반기) 장학금 수령자휴학생학교 및 각종 기관에서 대덕장학회 지급금액 이상의 장학금 수령자기타 수업(등록)료 전액 등 감면혜택을 받는 자 방송통신대학교/ 사이버대학교 등 유사 학교 및 해외 유학생 ',
      Col18: '해당없음',
      Col19: ' * 접수처 : 고양시 대덕동 주민센터(근무시간 내 한함)신청서주민등록등본(주소이력 3년 이상 포함)통장 거주사실확인서재학증명서성적증명서(백분율 표기)학생 통장사본2022학년도 1학기 등록금영수증 또는 고지서'
    },
    {
      Col1: '사단법인대불',
      Col2: '시곡장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '6000000원',
      Col12: '대학생 불교신자로서 학업성적이 우수하고/ 신행활동이 모범적인 학생',
      Col13: '해당없음',
      Col14: '2020-03-10~2020-03-31',
      Col15: '해당없음',
      Col16: '1명',
      Col17: ' * 자세한 사항은 선발 기관으로 문의 바랍니다.',
      Col18: '지도교수 또는 스님 추천서 제출',
      Col19: '지도교수 또는 스님 추천서자기소개서신행 및 학업 계획서재학증명서직전학기 성적증명서대불장학금 신청서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '창수면포푸라장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 기관으로 문의',
      Col12: '해당없음',
      Col13: '경기도 포천시 창수면 관내에 학생 또는 보호자가 실거주 5년 이상인 대학교 학생(전문대학 포함)',
      Col14: '2021-12-30~2022-01-18',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '만 30세 초과자 * 자세한 사항은 기관으로 문의',
      Col18: '해당없음',
      Col19: '창수면 포푸라 장학생 신청서창수면 포푸라 장학생 추천서2020년도 대학교 입학금 납입 증명서창수면 포푸라 장학생 신청인 주민등록 초본학생 또는 보호자의 금융기관 거래통장(사본)'
    },
    {
      Col1: '목암과학장학재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/의약계열/자연계열',
      Col9: '총 평점 3.5/4.5만점 기준 이상인 자',
      Col10: '한국장학재단 소득구간 최하위자 우선(상한 5분위)',
      Col11: '500000원/학기(등록금+학업보조비)',
      Col12: '전공 : 1순위(생명과학/생명공학 분야 또는 제약/화학전공)/ 2순위(이공계)잔여 정규학기 2학기 이상 남은 학부학생어려운 환경에서도 미래의 과학한국을 선도해 나갈 과학도로 성장할 학생',
      Col13: '해당없음',
      Col14: '2022-08-30~2022-09-25',
      Col15: '1차: 서류심사/ 2차: 면접심사',
      Col16: '추천인원 2명',
      Col17: '2020년도 타 기관장학금을 수혜하지 않는 학생',
      Col18: '지도교수/ 학과장장',
      Col19: '장학생 신청서부/모의 소득금액증명원 또는 근로소득원천징수영수증 각 1부가족관계증명서 1부(학생 본인과 부/모와의 관계 기재)개인정보동의서 * 학교추천 장학이므로/ 자세한 사항은 각 학교 장학부서에 문의ㅏ'
    },
    {
      Col1: '목암과학장학재단',
      Col2: '해외장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/의약계열/자연계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: 'USD 10000 * 한화로 지급시 장학금 지급일 기준 매매기준율 적용',
      Col12: '이·공·의학 분야 해외 유학생대학민국 국적으로 해외 대학의 당해년도 진학이 확정된 연구자 또는 재학 중인 연구자(학사/석사/박사/박사후 연구원)',
      Col13: '해당없음',
      Col14: '2022-05-17~2022-05-26',
      Col15: '1단계 : 사무국 서류심사 2단계 : 이사회 서류심사',
      Col16: '10명 내외',
      Col17: '인문/사회/예술/체육 등 전공 선발 제외교환학생/ 석사후 연구원/ 국내 소재 외국대학 제외 * 자세한 사항은 첨부파일 참고 바랍니다.',
      Col18: '지도교수 추천 (선택)',
      Col19: '장학생 지원신청서본인 여권 사본본인 비자 사본당해연도 해외 대학 진학 또는 재학 증명 서류재학중인 학위과정 성적증명서 사본 또는 이전 학위과정 성적증명서 사본지도교수 추천서가게형편증명서류국가유공자 확인서 * 양식 내려받기 및 자세한 사항 확인은 기관 홈페이지 방문'
    },
    {
      Col1: '일촌장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 이상 이수 및 평점평균 2.0이상',
      Col10: '기초생활수급자와 차상위계층에 해당하는 자 (다문화가정 새터민가족의 경우 우선 선발)',
      Col11: '1000000원 ( * 생활비성 장학금)',
      Col12: '2022학년 2/3학년 학부 재학생으로 성적기준을 충족하는 자차상위계층 또는 저소득층 한부모가정/ 기초생활수급자 (다문화가정/ 새터민가족의 경우 우선 선발)',
      Col13: '해당없음',
      Col14: '2022-04-25~2022-05-20',
      Col15: '재단에서 최종선발',
      Col16: 'O명',
      Col17: '타기관/재단의 생활비성 장학금과 이중수혜 불가',
      Col18: '추천서 제출',
      Col19: '장학생 신청서소속 학부장 또는 전공주임교수 추천서자기소개서지원대상 관련 증빙서류주민등록등본 가족관계증명서성적증명서재학증명서2022년도 타 장학금 수령 내역 증빙 서류 * 제출당일부터 3개월내에 발급된 것만 유효함'
    },
    {
      Col1: 'KT&G장학재단',
      Col2: '상상장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활보장법에 따른 기초생활수급자 및 차상위계층',
      Col11: '3000000원 ※ 생활비 장학금',
      Col12: '2022년도 상반기 국내 대학(4년제 및 전문대) 재학 학생(1~4학년)타 기관으로부터 생활비/학습보조비 명목의 장학금을 지원받지 않는 학생   (국가/교내 장학금 등 등록금 수혜 학생은 지원 및 중복수혜 가능)',
      Col13: '해당없음',
      Col14: '2020-12-07~2020-12-30',
      Col15: '해당없음',
      Col16: '200명 이내',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' ※ 네이버 폼(http://naver.me/xFQl3tQk) 작성 필수 * 공통신청서재학증명서통장사본경제상황 증빙서류(기초수급/ 차상위 등)가족관계증명서 : 부모(보호자) 명의로 상세 발급개인정보 수집/ 이용 및 제3자 제공 동의서 * 1학년수능 성적 증명서 (수능 미응시자 지원 불가) * 2~4학년대학 성적 증명서 (직전 학기까지의 총 평점)'
    },
    {
      Col1: '우산육영회',
      Col2: '대학원장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '년 5400000원 (월450000원)',
      Col12: '대학원 석사과정 1학년 신입생으로서 대학성적이 우수 하고 지도교수의 추천을 받은 자.  모집학과  * 인문계: 국문학/ 영문학/ 독문학/ 불문학/ 중문학/ 국사학/ 동양사학/ 서양사학/철학/노문학/서문학/언어학/ 미학 * 사회계 : 정치외교학/ 경제학/ 사회학/ 사회복지학/ 심리학/ 지리학/ 인류학/ 법학/ 경영학 * 자연계 : 수리과학/ 통계학/ 물리천문학/ 화학/ 지구환경과학/ 생명과학/ 뇌인지학',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '지원서대학성적증명서(전학년)이력서가정상황조서교수추천서연구계획서(석사과정)대학원 졸업 후의 장래진로 희망(* 졸업 후 진로에 대한 자신의 계획을 기술할 것)'
    },
    {
      Col1: '재단법인소정장학회',
      Col2: '소정장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 우수한 자',
      Col10: '*선발 기준 우선순위장애우조손가정자녀(가정형편)학업성적우수자',
      Col11: '해당없음',
      Col12: '세종시 소정초등학교 모교 졸업생 혹은 동문의 자녀 중 전문대 이상 입학생',
      Col13: '해당없음',
      Col14: '2022-06-06~2022-06-17',
      Col15: '*선발 기준 우선순위장애우조손가정자녀(가정형편)학업성적우수자',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '모교 졸업증명서(신청자 및 부/모)당해년도 보험료/ 재산세 납부 영수증(신청자 및 부/ 모)전문대 이상 재학증명서최종학교 성적 증명서장애인 증명서(대상자)'
    },
    {
      Col1: '양촌장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: ' * 2022학년도 대학교 재학생으로 아래 각호 중 하나 해당하는 자공고일 기준 양촌읍 1년 이상 거주자의 자녀양촌신협 조합원 및 조합원의 자녀양촌읍 소재 학교 재학생',
      Col13: '공고일 기준 양촌읍 1년 이상 거주자의 자녀',
      Col14: '2022-06-24~2022-07-29',
      Col15: '1차 서류심사2차 면접',
      Col16: '5명',
      Col17: '최근 2년 이내 양촌장학회 장학금을 받은 자',
      Col18: '해당없음',
      Col19: '장학생신청서주민등록등본재학증명서자기소개서과제물 개인정보제공 및 활용 동의서  * 이메일 접수/ 양식 다운로드는 홈페이지 참고'
    },
    {
      Col1: '고려대학교여교수회',
      Col2: '차세대지도자장학생',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 17학점 이상을 취득하고 전체 평균평점이 3.0이상인 자',
      Col10: '해당없음',
      Col11: '20222학기 수업료 전액(단 약학과 의학계열의 경우 공학계열 기준 수업료 지급)',
      Col12: '고려대학교 학부 3~4학년 여학생(20222학기 현재)차세대 여성지도자로 발전가능한 역량과 소양을 갖춘 자',
      Col13: '해당없음',
      Col14: '2020-12-08~2020-12-21',
      Col15: '해당없음',
      Col16: '1~2명',
      Col17: '해당없음',
      Col18: '교수 추천',
      Col19: '교수추천서장학금 지원서자기소개서성적증명서(2022년도 1학기 포함) * 교내장학이므로/ 자세한 사항은 고려대학교 장학게시판  참고'
    },
    {
      Col1: '백곡장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '친권자 또는 본인주소가 백곡면 출신 및 백곡면에 5년 이상 거주하고 있는 자 중 대학교(전문대포함) 재학생으로 장학생 추천에 적합한 자ㅣ',
      Col13: '친권자 또는 본인주소가 백곡면 출신 및 백곡면에 5년 이상 거주하고 있는 자',
      Col14: '기관 확인 필요',
      Col15: '심의위원회에서 선발',
      Col16: '5명 ※ 향후 심의회에서 인원 및 금액 변동 가능',
      Col17: '졸업예정자 및 휴학생 제외공무원/ 기업체 위탁교육생은 제외',
      Col18: '해당없음',
      Col19: '장학생 신청서추천서 (총·학장 추천)성적증명서재학증명서  장학생 신상카드타 장학금 수혜/미수혜 증명서 보호자(부모 또는 조부모 등) 재산세 납세증명서 * 자세한 사항은 홈페이지 공고 참조'
    },
    {
      Col1: '수협재단',
      Col2: '수협장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '법정사회보장대상자 중위소득 100%이내에 해당하는 가구',
      Col11: '2000000원 ( 생활비 지원 )',
      Col12: '국내 대학교에 재학 중인 가정형편이 어려운 어업인의 자녀',
      Col13: '해당없음',
      Col14: '2022-06-28~2022-08-03',
      Col15: ' * 재단의 선발기준에 따라 장학생 선발1순위 : 법정사회보상대상자2순위 : 건강보험료 납부자가 없거나 0원인 가구3순위 : 건강보험료 산정기준표상 부모의 월 건강보험료 본인부담금이 기준 소득대비 낮은 순으로 선발',
      Col16: 'OOO명',
      Col17: '방송대학/ 통신대학/ 방송통신대학 및 사이버대학수협 (상근) 임직원 (손)자녀22년도 수협장학금 수혜자 선발 제외가구당 누적수혜횟수 최대 3회 제한22년 1학기 휴학예정자 지원불가21년 입사자 중 벌점누계가 70점이상인 자 선발 제외외',
      Col18: '해당없음',
      Col19: ' * 공통 서류조합장 추천서지원서개인정보 수집·이용 동의서수협과의 특수관계 부존재 확인서조합원 증명서주민등록등본20년도 건강·장기요양보험료 납부확인서 (부/모각각)재학증명서(재학생)/ 합격증명서(신입생) 장학금 입금 통장사본 * 해당자 서류국민기초생활수급자 증명서차상위대상자 증명서한부모가족 증명서'
    },
    {
      Col1: '굿패밀리복지재단',
      Col2: '사랑나눔장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 우수하고 성실하며 타의 모범이 되는 학생',
      Col10: '가정 사정으로 인해 학비조달이 어려운 학생',
      Col11: '1000000원',
      Col12: '학업성적이 우수하고 성실하며 타의 모범이 되는 학생가정 사정으로 인해 학비조달이 어려운 학생',
      Col13: '해당없음',
      Col14: '2021-02-01~2021-02-15',
      Col15: '서류전형',
      Col16: 'OO명',
      Col17: '최근 1년 이내 기수여자',
      Col18: ' * 아래 추천인 중 택1하여 추천서 제출대원교회 담당목회자 또는 교사교회목회자학과 교수',
      Col19: '장학금 신청서자기소개서추천서 * 자세한 사항은 기관으로 문의'
    },
    {
      Col1: '무진장애인장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적 우수자 우대',
      Col10: '수급권자 우대',
      Col11: '1000000원',
      Col12: '장애인 대학(원)생(신입생 및 전문대학생/ 사이버대학교 포함)수급권자 및 학업성적 우수자 우대자기비전이 확실한 자',
      Col13: '해당없음',
      Col14: '2021-10-12~2021-11-12',
      Col15: '해당없음',
      Col16: '5명 내외외',
      Col17: '해당없음',
      Col18: '학교장 및 관련 단체장의 추천',
      Col19: '장학금 신청서(무진장학회 카페 http://cafe.daum.net/mujinsiloam \'장학생선발공고\' 다운로드)추천서(무진장학회 카페 다운로드)재학증명서(신입생은 합격통지서)성적증명서장애인등록증 사본자기소개서*신청서류는 마감시간까지 도착하여야 접수하며/ 접수된 서류는 일체 반환하지 않음.*접수처 : 광주광역시 남구 봉선로79번길 41 실로암센터* 방 법 : 우편접수(2월 24일 도착분한함)/ 방문접수*유의사항 : 제출서류 일체는 이메일 제출(mjsiloam@hanmail.net) 요망'
    },
    {
      Col1: '목포시청',
      Col2: '학자금 대출 이자지원',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2019년 이후 한국장학재단에서 대출받은 학자금의 2021년 12학기 (2021. 01. 01 ~ 12.31 발생한 본인 부담 이자 * 한국장학재단 대출 자료 추출시 대출 전액 상환자 지원 불가 * 신청 학기에 한해 지원 (매 학기별 신청) * 개인계좌로 입금되지 않음/ 한국장학재단 대출계좌로 상환 ',
      Col12: '2019년 이후 한국장학재단에서 \'취업 후 상환 학자금(등록금+생활비)\' 또는 \'일반 상환 학자금(등록금+생활비)\' 대출을 받은 대학생',
      Col13: ' 공고일 기준 부모 또는 본인이 목포시에 주민등록이 되어 있는자',
      Col14: '2021-07-02',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '재학 중인 학교에서 퇴학/ 제적된 자/ 휴학생/ 군입대자/ 대학원생허위사실 또는 타 기관 중복지원자재학증명서/ 주민등록초본등 신청구비 서류를 제출하지 않은 자재단에서 학자금대출 정보제공 시점에서 대상자가 대출원리금 전액을 상환하여 재단에 상환할 대출원금이 없는 자',
      Col18: '해당없음',
      Col19: '신청서 개인정보 수집/이용 및 제공/조회 동의 필수재학증명서학생 주민등록초본 (\'정부민원포털 민원24\'에서 무료 발급 가능) * 본인의 주소지가 목포시가 아니고/ 부모의 주소지가 목포포시인 경우  : 부 또는 모의 주민등록초본과 가족관계증명서 추가 제출) * 꼭 첨부파일을 통해 제출서류를 파악 바립니다.'
    },
    {
      Col1: '(주)GS홈쇼핑',
      Col2: 'GSSHOP소비자리더장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대학원',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '사회계열/특정학과',
      Col9: '평균 성적이 3.0이상(4.5 만점/ 직전 2학기 평균) 이상',
      Col10: '해당없음',
      Col11: '대학생 : 1500000원대학원생 : 2500000원',
      Col12: '전국 대학 소비자학 전공 대학생 및 대학원생* 부전공/ 복수 전공 포함2021년 1학기 현재 재학 중이며/ 2021년 2학기 등록 예정인 자',
      Col13: '해당없음',
      Col14: '2021-02-16~2021-02-22',
      Col15: '해당없음',
      Col16: '45명 내외(대학생 30~40명/대학원생 4~8명)',
      Col17: '기존 소비자리더 장학금 수혜자는 중복 지원 불가휴학생부정청탁 및 금품 등 수수의 금지에 관한 법률(약칭 : 청탁금지법)의 공직자(교직원) 등에 포함되는 자 * 지원 제한에 대한 기준은 스스로 확인 후 신청.추후 제한 사유에 의한 문제가 발생시 선정을 취소할 수 있음.',
      Col18: '해당없음',
      Col19: '지원서 및 자기소개서소비자 관련 활동 기술서재학증명서성적증명서증빙서류 * 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '부산광역시청',
      Col2: '저소득층장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활수급자 중 생계. 의료급여 수급자 차상위계층 대상자',
      Col11: '1인당 1000000원 ',
      Col12: '20211학기 휴학계획이 없는 자20211학기 타 장학금(생활비) 수혜(예정)자 제외',
      Col13: '주민등록등본 상 주소가 부산인 학생',
      Col14: '2021-11-01~2021-11-29',
      Col15: '2.22(월) 오전 10:00까지 이메일(wind587@dau.ac.kr)제출출',
      Col16: '11명',
      Col17: '해당없음',
      Col18: '추천서의 가사상황 및 품행/ 추천자의견은 작성하여 평생지도교수 확인받을 것것',
      Col19: '장학생 신청서 및 추천서재학증명서학생 명의 통장 사본'
    },
    {
      Col1: '부산광역시청',
      Col2: '대학생학자금대출이자지원사업',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '대출 해당학기 소득 8분위 이내자',
      Col11: '2016년 이후 학자금 대출(일반 취업 후 상환)에 대한 2021년 발생이자',
      Col12: '2016년 이후 한국장학재단 학자금 대출을 받은 자공고일 기준 부산지역 소재 대학교에 재학/ 휴학 중인 자 공고일 기준 부산지역 소재 대학/ 대학원생 및 졸업생 중 해당자 ',
      Col13: '공고일 현재 부산지역 소재 대학 ',
      Col14: '2022-03-02~2022-03-15',
      Col15: '해당없음',
      Col16: '예산 범위 내',
      Col17: '대학원생 제외학자금대출 정보 추출시점에 대출금 완제되었을 경우타 지자체 이자지원 사업과 중복지원 불가 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '학자금 이자지원 신청서 (개인정보활용동의서)'
    },
    {
      Col1: '서대문구청',
      Col2: '주민소득지원및생활안정기금융자',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 10000000원 신용대출 * 연이율 1.5% 2년 거치 2년 균등상환 * 융자일자 : 2021년 6월 말 ~ 7월 초',
      Col12: '신청일 현재 서대문구에 1년 이상 계속 거주하고 있는 자 중 본인 및 가족이 대학교에 재학 중인 자',
      Col13: '신청일 현재 서대문구에 1년 이상 계속 거주하고 있는 자 * 신청 후 심사기준에 적합해야 최종 융자대상자로 선정',
      Col14: '2022-10-06~2022-10-14',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원생 제외외이미 자립기반이 조성되어 있는 가구주민소득 및 생활안정기금 수혜가구로서 미상환 가구',
      Col18: '해당없음',
      Col19: '신청서행정정보공동이용 사전동의서신분증사본재학증명서수업료 납부 고지서개인정보 동의서 * 자세한 사항은 홈페이지 공고 참조/ 서식은 구청 구비 및 홈페이지게시'
    },
    {
      Col1: '한국소방안전원',
      Col2: '소방안전장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 상반기 최소 12학점 이상 이수자 직전학기 성적이 평균 ',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '안전원 회원가입기간이 5년 이상으로 회비를 완납한 회원 본인 또는 회원의 자녀국내의 대학 및 대학교에 재학 중인 자',
      Col13: '해당없음',
      Col14: '2022-06-07~2022-07-20',
      Col15: '심사배점 : 회원가입기간(60점)/ 학과성적(40점)',
      Col16: '200명',
      Col17: '한가구 중복 선발 불가최근 5년간 소방안전장학금 기 수혜 회원 신청 불가(회원 및 자녀 포함)',
      Col18: '해당없음',
      Col19: '소방안전장학생 신청서직전학기 성적증명서(학점 및 백점환산점수 병행 표기)회원 및 자녀 모두 등재된 주민등록등본 또는 가족관계증명서관할소방서에 선임신고 필한 자격증 사본개인정보 동의서기타 필요한 증빙서류(해당자) * 자세한 사항은 첨부파일 또는 홈페이지 참조'
    },
    {
      Col1: '울산광역시청',
      Col2: '학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2017년 이후 한국장학재단으로부터 신규대출 받은 “취업 후 상환학자금” 및 “일반상환학자금”의 2022년 상반기에 발생한 본인 부담 이자액',
      Col12: '17년도 이후 한국장학재단 신규 대출자 중 지역거주요건 충족자 * 한국장학재단 대출 : 취업후상환학자금 및 일반상환학자금 모두 해당',
      Col13: '신청공고일 기준 학생 본인 혹은 직계존속의 주민등록상 주소지가 울산이고/ 대학교에 재학(휴학) 중인 학생',
      Col14: '2022-07-08-2022-10-13',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '휴학생의 휴학기간(군복무 휴학기간은 제외)이 6학기 이하타 지자체 등 중복지원 불가한국장학재단의 지원대상 확정 전 전액 완제자는 지원대상에서 제외대학원생/ 졸업생',
      Col18: '해당없음',
      Col19: '신청서: 이자지원용 신청서 및 개인정보 제공동의서2022년 1학기 대학교 재학(휴학)증명서증빙서류: * 학생본인의 주민등록상 주소지가 울산일 경우: 본인 주민등록등본 또는 초본 * 직계존속의 주민등록상 주소지가 울산일 경우: 울산주소지 직계존속(부모)의 주민등록등본 또는 초본/ 가족관계증명서(본인 또는 부모기준) ※ 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '일반 상환 학자금대출',
      Col3: '한국장학재단',
      Col4: '학자금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생군(신입생/ 편입생/ 재입학생)해당 대학의 ',
      Col10: ' * 다자녀 가구 학생의 경우 취업후 상환 학자금 이용 가능',
      Col11: ' * 등록금 대출규모 : 등록금 대출 전액 * 대출금리 : 22년 2학기 1.7%(고정금리) * 대출자 고등교육기관에 따른 총 등록금 대출한도 적용(대출잔액 기준)  ※ 자세한 사항은 한국장학재단 홈페이지 참고',
      Col12: '국내 고등교육기관 대학생 및 대학원생(재학생 및 입학/ 복학예정자 포함)으로 대한민국 국민(주민등록상 해외이주 신고자 및 영주권자 및 재외국민 제외)대출신청일 현재 만 55세 이하* 단/ 학업을 지속하는 만 55세 초과 ~ 60세 미만자는 가능(만 55세 이전에 입학한 재학생 및 편입생 대상)',
      Col13: '해당없음',
      Col14: '2022-07-08~2022-11-17',
      Col15: '온라인 신청 후 서류심사',
      Col16: '해당없음',
      Col17: '중복지원/ 부실자료 제출/ 등록금 및 대출 차액 미상환자 등 대출 신청 및 실행 당시/ 해당 학기 이전 신용제한여부가 확인될 경우 사유 해소시까지 일반 상환 학자금대출 제한18년~21년 대학 기본역량 진단 결과에 따라 22학년도 신·편입생에 대한 학자금대출 제한 여부 결정',
      Col18: '해당사항 없음',
      Col19: ' * 재단 홈페이지에서 서류제출 생략 가능 여부를 확인 후/ \'제출서류\' 목록을 참고하여 본인에게 맞는 서류 제출'
    },
    {
      Col1: '한국장학재단',
      Col2: '일반 상환 학자금대출(생활비)',
      Col3: '한국장학재단',
      Col4: '학자금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생군(신입생/ 편입생/ 재입학생)해당 대학의 ',
      Col10: '해당없음',
      Col11: ' * 생활비 대출규모 : 학기당 10~150만원 한도 내에서 지급실행 * 대출금리 : 1.7%(고정금리) * 원금균등상환 원리금균등상환 중 선택',
      Col12: '국내 고등교육기관 대학생 및 대학원생(재학생 및 입학/ 복학예정자 포함)으로 대한민국 국민(주민등록상 해외이주 신고자 및 영주권자 제외)대출신청일 현재 만 55세 이하 * 단/ 학업을 지속하는 만 55세 초과 ~ 60세 미만자는 가능(만 55세 이전에 입학한 재학생 및 편입생 대상)',
      Col13: '해당없음',
      Col14: '2022-07-05~2022-08-09',
      Col15: '온라인 신청 후 서류심사',
      Col16: '해당없음',
      Col17: '중복지원/ 부실자료 제출/ 등록금 및 대출 차액 미상환자 등 대출 신청 및 실행 당시/ 해당 학기 이전 제한 여부가 확인될 경우 사유 해소 시까지 일반 상환 학자금대출 제한 18년~21년 대학 기본역량 진단 결과에 따라 22학년도 신·편입생에 대한 학자금대출 제한 여부 결정',
      Col18: '해당사항 없음',
      Col19: ' * 재단 홈페이지에서 서류제출 생략 가능 여부를 확인 후/ \'제출서류\' 목록을 참고하여 본인에게 맞는 서류 제출'
    },
    {
      Col1: '한국장학재단',
      Col2: '한미대학생 어학연수비 대출',
      Col3: '한국장학재단',
      Col4: '학자금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한·미 대학생 연수(WEST)프로그램 합격자의 참가비 중 어학연수비  * 단 정부지원금과 재단의 어학연수비 대출 중복지원이 불가하므로 어학연수비와 한·미 대학생 연수(WEST)프로그램 정부지원금의 차액 한도 내에서 대출 실행가능 * 대출이자 : 연 1.7% 고정금리(일반 상환 학자금대출과 동일)',
      Col12: '국내 고등교육기관에 재학(졸업생/ 졸업유예자 제외) 또는 휴학중인 대한민국 국민(주민등록상 해외이주 신고자/ 영주권자 제외)으로서 대출 제한 대상자가 아닐 것만 55세 이하의 국내 고등교육기관 대학생',
      Col13: '해당없음',
      Col14: '2022-07-08~2022-11-17',
      Col15: ' * 한국장학재단 홈페이지 참고',
      Col16: '해당없음',
      Col17: '중복지원/ 부실자료 제출/ 등록금 및 대출 차액 미상환자 등 대출 신청 및 실행 당시/ 해당 학기 이전 신용제한여부가 확인될 경우 사유 해소시까지 대출 제한 ',
      Col18: '해당없음',
      Col19: ' * 한국장학재단 홈페이지 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '취업후 상환 학자금대출',
      Col3: '한국장학재단',
      Col4: '학자금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생군(신입생/ 편입생/ 재입학생)해당 대학의  ',
      Col10: '학부생: 학자금 지원 8구간 이하대학원생: 학자금 지원 4구간 이하다자녀(3자녀이상)가구 학생은 소득분위에 관계없이 대출가능(첫째 둘째 포함)',
      Col11: '등록금  : 등록금 전액 대출가능 (부분대출 허용)대출금리 : 1.7%(변동금리)',
      Col12: '국내 고등교육기관 대학생(재학생 및 입학/ 복학예정자 포함)으로 대한민국 국민(주민등록상 해외이주 신고자 및 영주권자 제외)만 35세 이하 ※ 자세한 사항은 한국장학재단 홈페이지 참고',
      Col13: '해당없음',
      Col14: '2022-07-08~2022-11-17',
      Col15: '온라인 신청 후 서류심사',
      Col16: '해당없음',
      Col17: '등록금 전액 규모를 초과하여 다른 장학금과 학자금을 동시에 수혜 할 수 없음중복지원/ 부실자료 제출/ 등록금 및 대출 차액 미상환자 등 대출 신청 및 실행 당시/ 해당 학기 이전 신용제한여부가 확인될 경우 사유 해소시까지 일반 상환 학자금대출 제한 ',
      Col18: '해당사항 없음',
      Col19: ' *재단 홈페이지에서 서류제출 생략 가능 여부를 확인 후/ \'제출서류\' 목록을 참고하여 본인에게 맞는 서류 제출'
    },
    {
      Col1: '한국장학재단',
      Col2: '취업후 상환 학자금대출(생활비)',
      Col3: '한국장학재단',
      Col4: '학자금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생군(신입생/ 편입생/ 재입학생)해당 대학의  ',
      Col10: '학부생: 학자금 지원 8구간 이하대학원생: 학자금 지원 4구간 이하다자녀(3자녀이상)가구 학생은 소득분위에 관계없이 대출가능(첫째 둘째 포함)',
      Col11: '학기당 100000 ~ 1500000원학기당 150만원 한도 내대출금리 : 1.7%(변동금리)',
      Col12: '국내 고등교육기관 대학생(재학생 및 입학/ 복학예정자 포함)으로 대한민국 국민(주민등록상 해외이주 신고자 및 영주권자 제외)만 35세 이하 ※ 자세한 사항은 한국장학재단 홈페이지 참고',
      Col13: '해당없음',
      Col14: '2022-07-04~2022-07-22',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '등록금 전액 규모를 초과하여 다른 장학금과 학자금을 동시에 수혜 할 수 없음중복지원/ 부실자료 제출/ 등록금 및 대출 차액 미상환자 등 대출 신청 및 실행 당시/ 해당 학기 이전 신용제한여부가 확인될 경우 사유 해소시까지 일반 상환 학자금대출 제한 ※ 자세한 사항은 한국장학재단 홈페이지 참고',
      Col18: '해당없음',
      Col19: ' * 재단 홈페이지에서 서류제출 생략 가능 여부를 확인 후/ \'제출서류\' 목록을 참고하여 본인에게 맞는 서류 제출'
    },
    {
      Col1: '한국장학재단',
      Col2: '농촌출신대학생학자금융자',
      Col3: '한국장학재단',
      Col4: '학자금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생군(신입생·편입생·재입학생) : 성적 및 이수학점 기준 제외재학생 : 직전학기 소속대학 최저이수학점 또는 12학점 이상 이수/ 70점 이상(100점 만점)',
      Col10: '기초생활수급자 차상위계층 우선 선발',
      Col11: ' [융자가능 금액] 1. 등록금: * 당해 학기 대학이 통보한 등록금 전액(입학금 수업료 등) 단 기숙사비 졸업앨범비 등은 제외 * 최소 융자 가능 금액: 10만원 이상 2. 생활비: * 농촌학자금융자로는 불가. 단 취업후 상환/일반 상환 생활비대출 이용 가능 * 자세한 사항은 홈페이지 참고',
      Col12: '국내 고등교육기관에 재학/ 입학/ 복학예정인 대한민국 국적인 대학교 학부생 ',
      Col13: '농어촌지역에 주소를 두고 6개월(180일)이상 거주하고 있는 학부모의 자녀농어촌지역에 주소를 두고 6개월(180일)이상 거주하며 농어업에 종사하는 대학생 본인',
      Col14: '2022-05-24~2022-06-23',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원 및 학점은행제 교육기관/ 외국대학 지원제외융자신청/실행일 현재 농어촌융자를 포함한 한국장학재단의 학자금 대출을 연체중인 자신용회복지원/ 개인회생 및 파산자 * 자세한 사항은 홈페이지 참고',
      Col18: '해당없음',
      Col19: '농업 : 농업경영체등록증 또는 농업인 확인서어업 : 어업경영체등록증 또는 어업인 확인서 * 자세한 사항은 홈페이지>학자금대출>학자금대출 안내> 농촌출신대학생 학자금융자 참조'
    },
    {
      Col1: '한국장학재단',
      Col2: '다자녀 국가장학금',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' [신입생/편입생/재입학생] 첫 학기에 한해 성적 기준 미적용 [재학생]직전학기 12학점 이수하여 80점 이상 취득(100점 만점 기준) * 기초/차상위 : 직전학기 12학점 이수하여 70점 이상 취득 * C학점 경고제 : 기초~2분위(구간)는 직전학기 70~80점 미만이라도 2회에 한해 경고 후 수혜 가능  * 장애인 : 성적기준 미적용 * 성적은 학기별 국가장학금 대학 업무처리기준에 따라 대학이 산출 * C학점 경고제 적용여부 학생 선택 불가',
      Col10: '소득 8분위(구간) 이하 대학생 * 사회보장정보시스템을 통해 확인한 가구원 소득 재산 금융자산 부채 등을 반영하여 소득인정액을 산정하여 결정',
      Col11: ' * 소득분위별 등록금을 초과하지 않는 범위 내에서 차등지원기초생활수급권자 1분위 2분위 3분위 : 학기별 최대 260만원45678분위: 한학기 최대 225만원 * 국가장학금 1유형과 중복시 다자녀 국가장학금 우선지원(국가장학금 1 유형과 중복수혜 불가)',
      Col12: '대한민국 국적을 소지한 국내대학의 학자금 지원 8구간 이하/ 다자녀 가정의 가구원인 대학생(미혼에 한함/ 연령무관) * 다자녀 가구(자녀3명이상)의 모든 자녀에게 지원 * 사망자녀의 경우에는 신청일 기준 만 1년 이내 사망한 경우 추가 증빙서류 확인 후 자녀 수료 합산 가능',
      Col13: '해당없음',
      Col14: '2022-04-05~2022-04-15',
      Col15: '소득/ 성적을 고려하여 선발',
      Col16: '해당없음',
      Col17: '과거학기 중복지원자 지원 불가장학금(한국장학재단의 등록금 지원 장학금) 총 수혜횟수가 소속학과의 정규학기 횟수를 초과할 경우 지원 불가등록횟수가 정규학기를 초과할 경우 지원 불가국가장학금 수혜 후 등록휴학한 자는 복학 첫학기 지원 불가재학생은 1차 신청 원칙이며/ 2차 신청 재학생은 국가장학금 지원 제한',
      Col18: '해당없음',
      Col19: ' * 재단 홈페이지에서 서류제출 생략 가능 여부를 확인 후/ \'제출서류\' 목록을 참고하여 본인에게 맞는 서류 제출 * 각 해당사항마다 서류제출 다름/ 한국장학재단 홈페이지에서 구비서류 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '국가우수장학금(이공계) 재학중우수',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학신입생',
      Col8: '공학계열/자연계열',
      Col9: '직전학기 백분위 87점 이상 (평점평균 3.5/4.5 이상)직전학기 12학점 이상',
      Col10: '해당없음',
      Col11: '선발 해당학기(20221학기)를 포함하여 2년간 등록금 전액 지원',
      Col12: '대한민국 국적을 소지한 자국내 4년제 대학교 자연과학 및 공과계열 학과(부)에 3학년 재학생 중 해당대학의 추천을 받은 자',
      Col13: '해당없음',
      Col14: '기관 확인 필요',
      Col15: '성적 상위 순으로 추천예정직전학기 성적 50% 총 평점평균 50%동점자 발생 시 전공수업 성적우수자 추천 > 전공수업 취득학점이 높은 학생 추천소프트웨어전공 및 여학생 우선선발이 반영될 수 있음',
      Col16: '00명',
      Col17: '2022년 1학기 현재 한국장학재단에서 운영 중인 타 장학금 수헤자 또는 장학생자격 유지자2022년 1학기 현재까지 국가우수(이공계)장학금 지원 종료된 자로 복수전공/ 또는 미졸업 등 사유로 재학 중인 학생2022년 1학기 현재까지 국가우수(이공계) 장학금 영구탈락자등록금 전액을 지원받는 계약학과/ 면제대상자',
      Col18: '해당없음',
      Col19: '장학금 신청서성적증명서재학증명서개인정보 수집 이용 제공 조회동의서'
    },
    {
      Col1: '한국장학재단',
      Col2: '대통령과학장학금',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '해외대학',
      Col7: '대학5학기/대학6학기',
      Col8: '공학계열/의약계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 : 학부과정 정규학기 내에서 전액 지원학업장려비 : 학기당 2500000원 추가 지원생활비 : 계속지원기준을 충족하는 기초생활수급자는 학기당 250만원 추가 지원',
      Col12: '대한민국 국적을 소지한 자국내 4년제 대학(자연과학 및 공학계열 학과)재학 중인 신입생 및 3학년 또는 해외 4년제 대학에 입학 예정 및 확정인 신입생 ',
      Col13: '해당없음',
      Col14: '2022-05-24~2022-06-23',
      Col15: '신청분야 : 자연계열/ 공학계열 2개 분야 중 본인의 활동내용과 가장 연관된 분야 1개 선택서류심사 → 인·적성검사(온라인) → 심층면접의 단계별 평가 실시',
      Col16: '총 157명 내외 ',
      Col17: '이공계 이외의 분야로 전공 변경 및 졸업 후 장학금을 받은 기간만큼 이공계열에 종사하지 아니한 때에는 장학금의 지급이 중지되거나 지급된 장학금이 환수됨',
      Col18: '해당없음',
      Col19: '과학활동내역서 1부인재성장계획서 1부봉사활동기술서 1부지도교수추천서 1부재학증명서 1부성적증명서 1부기타 증빙서류 1부  * 자세한 사항은 홈페이지 또는 첨부파일 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '국가근로장학금',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 C0수준(70점/100점 만점) 이상인 학생',
      Col10: '학자금 지원 8구간 이하  * 자세한 사항은 한국장학재단 홈페이지 공고 참고',
      Col11: '시급  * 교내 : 9160원 * 교외 : 11150원 근로시간  * 1일 8시간 / 주당 학기중 20시간(방학중40시간) / 학기당 520시간 ',
      Col12: '대한민국 국적자로 국내 전체 대학 중 참여 신청 후 재단이 승인한 대학에 재학중 또는 입학예정인 자로 성적기준 및 소득기준을 충족하는 자',
      Col13: '해당없음',
      Col14: '2022-05-24~2022-06-27',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '부정근로(허위근로/ 대리근로/ 대체근로)로 참여 제한 처분을 받은 자',
      Col18: '해당없음',
      Col19: ' * 재단 홈페이지에서 서류제출 생략 가능 여부를 확인 후/ \'제출서류\' 목록을 참고하여 본인에게 맞는 서류 제출'
    },
    {
      Col1: '한국장학재단',
      Col2: '국가장학금I유형',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' [신입생/편입생/재입학생] 첫 학기에 한해 성적 기준 미적용 [재학생]직전학기 12학점 이수하여 80점 이상 취득(100점 만점 기준) * 기초/차상위 : 직전학기 12학점 이수하여 70점 이상 취득 * C학점 경고제 : 1~3구간은 직전학기 70~80점 미만이라도 2회에 한해 경고 후 수혜 가능  * 장애인 : 성적기준 미적용 * 성적은 학기별 국가장학금 대학 업무처리기준에 따라 대학이 산출 * C학점 경고제 적용여부 학생 선택 불가',
      Col10: '소득 8분위(구간) 이하 대학생 * 사회보장정보시스템을 통해 확인한 가구원 소득 재산 금융자산 부채 등을 반영하여 소득인정액을 산정하여 결정',
      Col11: ' * 소득분위별 등록금을 초과하지 않는 범위 내에서 차등지원 기초생활수급자 : 260만원1구간 차상위계층 : 260만원2구간 : 260만원3구간 : 260만원4구간 : 195만원5구간 : 184만원6구간 : 184만원7구간 : 60만원8구간 : 33.75만원',
      Col12: '대한민국 국적으로 국내 대학에 재학 중인 소득 8분위(구간) 이하 대학생 중 성적기준 충족자로 해당학기 국가장학금 신청절차(가구원 동의/ 서류제출)를 완료하여 소득수준이 파악된 학생 * 다만/ 2022년 재정지원제한 유형 Ⅱ등급 대학 신입 및 편입생 지원 제외(최초 지정 후 등급 변화가 없으면 계속하여 지원 제한)',
      Col13: '해당없음',
      Col14: '2022-05-24~2022-06-27',
      Col15: '소득/ 성적을 고려하여 선발',
      Col16: '해당없음',
      Col17: '과거학기 중복지원자 지원 불가장학금(한국장학재단의 등록금 지원 장학금) 총 수혜횟수가 소속학과의 정규학기 횟수를 초과할 경우 지원 불가등록횟수가 정규학기를 초과할 경우 지원 불가국가장학금 수혜 후 등록휴학한 자는 복학 첫학기 지원 불가재학생은 1차 신청 원칙이며/ 2차 신청 재학생은 국가장학금 지원 제한',
      Col18: '해당없음',
      Col19: ' * 재단 홈페이지에서 서류제출 생략 가능 여부를 확인 후/ \'제출서류\' 목록을 참고하여 본인에게 맞는 서류 제출 ** 각자의 해당사항마다 제출서류 다름/ 꼭 한국장학재단 홈페이지 국가장학금 제출서류를 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '국가장학금II유형',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: ' * 대학별 자체 선발기준 수립하여 선발 * 우대 지원 권고 사항장애인 대학생 자녀가 2명 이상인 가구 또는 자녀가 3명 이상인 가구의 학생긴급 경제사정 곤란자선취업후진학 학생',
      Col11: '대학 자체기준에 따라 등록금 필수경비(입학금 수업료) 범위 내에서 지원금액 결정',
      Col12: '대한민국 국적으로 국가장학금 Ⅱ유형(대학연계지원형) 참여대학에 재학 중인 대학생 중 해당 학기 국가장학금 신청절차(가구원동의/ 서류제출)를 완료하여 소득수준이 파악된 학생당해 년도 국가장학금 2유형 지원가능대학 중 2유형 참여대학',
      Col13: '해당없음',
      Col14: '2022-09-05~2022-09-29',
      Col15: '대학별 자체 선발기준 수립하여 선발',
      Col16: '해당없음',
      Col17: ' * 자세한 내용은 홈페이지 참조 바람 ',
      Col18: '해당없음',
      Col19: ' * 재단 홈페이지에서 서류제출 생략 가능 여부를 확인 후/ 제출서류 목록을 참고하여 본인에게 맞는 서류 제출 * 각 해당사항마다 구비서류가 다름/ 한국장학재단 홈페이지에서 국가장학금 서류제출 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '중소기업취업연계장학금(희망사다리l유형)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 최소 12학점 이상을 이수하고 대학 학칙에 따라 산출된 백분위 점수가 100점 만점의 70점 이상',
      Col10: '해당없음',
      Col11: ' * 등록금 : 학기당 등록금 전액 (수혜학기 중복지원 여부와 등록금액에 따라 장학금액 변공 가능) * 취·창업지원금 : 학기당 2000000원 (직무기초교육 미 이수자는 해당학기 지원금 반환 조치)',
      Col12: '대한민국 국적자로 선발학기 사업 참여대학에 재학중인 일반대 3학년/ 전문대 2학년 이상 재학생(취업지원형) 중소·중견기업 취업희망자 또는 취업자(창업지원형) 창업희망자 또는 창업자 * 학생 의무사항 등은 한국장학재단 홈페이지 참조',
      Col13: '해당없음',
      Col14: '2021-12-30~2022-01-12',
      Col15: ' * 사업참여대학의 재학생에 한해 신청 가능한 장학금으로/ 소속 학교 장학팀에 우선 문의하시기 바랍니다.대학의 참여대학 신청 → 학생의 장학금 신청(서울보증보험 가입 포함) → 대학의 추천 / 한국장학재단의 검증 후  선발',
      Col16: '해당없음',
      Col17: '계약학과 학생수혜종료자대한기본역량진단 평가 재정지원제한 Ⅱ유형 분류 대학동일학기 고졸 후 학습자 장학금 수혜자고졸 후 학습자 장학금 수혜 후 의무재직을 완료하지 못한 자 * 자세한 사항은 첨부파일 참고 바랍니다.',
      Col18: '대학 및 소속대학의 사전 추천 필요',
      Col19: ' * 대학참여신청 또는 학생개인신청신청유형별로 제출서류가 다르므로/ 한국장학재단 홈페이지 참조'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(대한LPG협회)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수※ 계속장학생 기준도 선발 성적기준과 동일',
      Col10: '해당없음',
      Col11: '학기당 2000000원 지원 (생활비 무상보조로 정액 지원)2개 학기 지원*푸른등대 기부장학금 계속 지원의 경우 별도 신청절차 없이 성적요건이 충족될 시 계속 지원',
      Col12: '국내 4년제 및 전문대학교 재학생(졸업학기 제외)택시 운전 경력이 푸른등대 기부장학금 신청시작일 기준 1년 이상인 기사 가정의 자녀',
      Col13: '해당없음',
      Col14: '2021-12-30~2022-01-12',
      Col15: '가계소득(60) + 성적(40)동점자 처리기준: 학자금 지원구간 낮은 자 > 다자녀가정> 성적상위자 > 연장자 ',
      Col16: '262명명',
      Col17: '신/편입생졸업학기자',
      Col18: '해당없음',
      Col19: '(택1 필수 제출)법인택시: (부모) 국민연금 가입자 가입 증명서 또는 재직증명서개인택시: (부모) 사업자등록증 또는 여객자동차운송사업자 면허증※ 택시기사경력(1년 이상) 및 현재 근무 여부가 확인 가능한 서류에 한함'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(한국투자공사)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신규선발(신입생)시 성적 기준 없음※ 단/ 계속장학생은 직전 정규학기 백분위 70점 이상/ 최소 12학점 이상 이수 ',
      Col10: '해당없음',
      Col11: '학기당 2500000원 지원 (생활비 무상보조로 정액 지원)2개 학기 지원',
      Col12: '국내 4년제 및 전문대학교 신입생아동복지시설 및 가정위탁 등 가정 외 보호 출신인 자',
      Col13: '해당없음',
      Col14: '2022-03-16~2022-04-12',
      Col15: '가계소득(70) + 자기소개서(30) + 가산점(5)동점자 처리 기준: 학자금 지원구간 낮은 자 > 연소자 ',
      Col16: '11명 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '자기소개서가정 외 보호사실 증명서(택1) 아동양육시설/ 공동생활가정: 입소확인서/ 재원증명서/ 출신확인서가정위탁: 가정위탁보호확인서'
    },
    {
      Col1: '한국장학재단',
      Col2: '예술체육비전장학금',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기/대학신입생',
      Col8: '예체능계열',
      Col9: ' * 신규장학생직전 2년간(1~2학년) 총 평균성적이 백분위 90점 이상 또는 평점 3.6이상/4.5만점/ 취득 이수학점이 소속대학 졸업이수학점의 40% 이상 * 일반 계속장학생백분위 87점 이상 또는 평점 3.50/4.50만점직전학기 12학점 이상 이수 * 중간평가(2+2) 대상자직전 2년간 4개 학기 성적 및 이수학점/ 중간평가서 평가를 통해 계속지원여부 결정 ※ 자세한 사항은 한국장학재단 홈페이지 참고',
      Col10: '해당없음',
      Col11: '연 등록금 및 생활비 ',
      Col12: '대한민국 국적 소지자로서/ 국내 4년제 인문/ 사회계열 학과 또는 예술/ 체육계열 학과에 재학중인 1년 신입생 및 3학년 재학생생',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '학생서류 보완기간> 재단배정> 대학추천> 계열별 신청서 제출> 배정인원 범위 내 우수학생 추천> 서류심사> 심층면접> 총괄선발위원회> 최종선정발표 ',
      Col16: '총 1/40년 내외 ',
      Col17: '예술체육비전장학생 자격 유지자 꼬는 기존 예술체육비전장학생으로 선발된 후 영구탈락 된 학생한국장학재단에서 운영중인 우수장학금 기수혜자계약학과(등록금 전액/일부지원) 선발 제외국가유공자/ 보훈대상자/ 탈북대학생 등 등록금 전액을 지원받는 면제대상자는 등록금 학생부담분 등 지원',
      Col18: '지도교수',
      Col19: ' ** 신규장학생학업계획서/ 전인적인재성장계획서 * 공통 기초생활수급자 증명 (대학추천시 복지정보연계망을 통해 수급자로 확인되지 않은 대학이 공문을 통해 제출) * 대학대학신청서 ** 계속장학생4학년진급자 : 진도보고서'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 (월곡주얼리산업재단)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '특정학과',
      Col9: '직전 정규학기 백분위 87점 이상/ 최소 12학점 이상 이수 * 계속장학생 기준도 선발 성적기준과 동일',
      Col10: '해당없음',
      Col11: '학기당 1500000원 지원 (2회)2개 학기 (2019년 1학기 ~ 2학기) ',
      Col12: '대한민국 국적의 국내 4년제 및 전문 대학교 재학생귀금속/ 주얼리(쥬얼리)/ 보석 관련 학과 전공 대학생    * 금속공예/ 금속디자인/ 금속조형/ 장신구 관련 학과 포함 ',
      Col13: '해당없음',
      Col14: '2022-06-15~2022-06-28',
      Col15: '1차 : 가계소득(50) + 성적(50) 3배수 선발2차 : 자기소개서(100)',
      Col16: '40명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생·편입생 제외졸업학기자 제외',
      Col18: '해당없음',
      Col19: '소득확인 서류제출 및 가구원 동의기부처별 추가 서류 제출 * 한국장학재단 홈페이지 온라인 신청 * 자세한 사항은 첨부파일 또는 한국장학재단 홈페이지 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(한국화웨이)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/특정학과',
      Col9: '직전 정규학기 백분위 90점 이상/ 최소 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '1500000원  * 생활비 무상보조로 정액지원(1개 학기)',
      Col12: '대한민국 국적의 국내 4년제 대학교 재학생IT/ 컴퓨터/ 전자통신/ 보안/ AI/ 데이터 관련 공학계열 전공자2022학년도 2학기 기준 3학년 이상인 재학생',
      Col13: '해당없음',
      Col14: '2021-12-30~2022-01-12',
      Col15: '(1차) 가계소득(30점) + 성적(70점)/ 2배수 선발(2차) 자기소개서(100점)동점자 처리기준 : 성적상위자 > 학자금 지원구간 낮은자 > 연장자 * 자세한 사항은 첨부파일 참고',
      Col16: '20명 ',
      Col17: '전문대학/ 전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외졸업학기자 제외신입생·편입생제외',
      Col18: '해당없음',
      Col19: 'ICT(정보통신기술)를 포함한 공학관련 대회 수상실적 증빙서류(수상경력이 있는 경우 제출)자기소개서 * 한국장학재단 온라인 신청'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(말남장학금)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '학자금 지원구간 낮은 자> 자기소개서 점수 상위자자',
      Col11: '학기당 2000000원 지원 (생활비 무상보조로 정액 지원)1개 학기 지원',
      Col12: '국내 4년제 대학교(수도권) 신입생휘경여자고등학교 졸업생',
      Col13: '해당없음',
      Col14: '2022-05-24~2022-06-23',
      Col15: '가계소득(50)+성적(50)동점자 처리기준: 학자금 지원구간 낮은 자 > 자기소개서 점수 상위자> 연소자 ',
      Col16: '10명 선발',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '자기소개서휘경여자고등학교 졸업증명서'
    },
    {
      Col1: '한국장학재단',
      Col2: '지역인재장학금',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' [신규선발]성적우수 : (일반대) 내신 또는 수능 3등급 이내 / (전문대) 내신 또는 수능 4등급 이내특성화 : 대학 자체기준으로 선발  [계속선발]221학기 신규 선발자 : 직전학기 80점(B) 이상15년도 ~ 21년도 계속지원 확정자 : 직전학기 80점(B) 이상 * 대학별로 상이할 수 있음',
      Col10: '소득 8구간(분위) 이하 ',
      Col11: ' * 지원기간 내 등록금 필수경비(입학금 수업료) 전액 지원(기초~기준중위소득 100%*) 전 학기 지원(기준중위소득 100%초과 ~ 소득 8구간) 1년 지원(2학기)',
      Col12: '비수도권 고교를 졸업하고 2022학년도 비수도권 대학에 입학한 소득 8구간(분위) 이하 신입생 중 국가장학금 신청절차(가구원동의/ 서류제출)를 완료하여 소득수준이 파악된 학생  * 단/ 2022년도 지역인재장학금 참여대학 소속 학생에 한함',
      Col13: '비수도권 고교를 졸업하고 2021년도 비수도권 대학에 입학한 학생',
      Col14: '2021-01-22~2021-02-05',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: ' * 대학에서 선발되었더라도 해당학기 국가장학금을 미신청하거나 소득구간(분위) 산정이 완료되지 않을 경우 지역인재장학금 지원불가',
      Col18: '해당없음',
      Col19: ' * 한국장학재단 홈페이지를 참고하여 본인이 필요한 서류를 확인'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(구찌코리아)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '특정학과',
      Col9: '직전 정규학기 백분위 87점 이상/ 최소 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '학기당 1500000원 지원 (생활비 무상보조로 정액 지원)2개 학기 (2020년 1학기 ~ 2020년 2학기) *푸른등대 기부장학금 계속 지원의 경우 별도 신청절차 없이 성적요건이 충족될 시 계속 지원',
      Col12: '국내 4년제 대학교 \'21년도 1학기 기준 2/ 3학년 재학생패션/ 의류/ 섬유/ 의상 관련 학과 전공자 ',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '가계소득(50) + 성적(50)동점자 처리기준: 학자금 지원구간 낮은 자> 성적상위자> 연소자',
      Col16: '34명',
      Col17: '편입생졸업학기자',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(넥슨코리아)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '학기당 등록금 전액 지원(졸업시까지)',
      Col12: '국내 4년제 및 전문 대학교 재학생세월호 피해 유가족(2014년 해양수산부/ 경기도 교육청을 통해 푸른등대 기부장학금을 신청한 자에 한함)',
      Col13: '해당없음',
      Col14: '2022-06-15~2022-06-28',
      Col15: '해당없음',
      Col16: '9명 선발',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(한국가스공사)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수',
      Col10: '소득구간 3분위 이내인 자',
      Col11: '2000000원 * 생활비 무상보조로 정액 지원 1개 학기 지원 ',
      Col12: ' 대한민국 국적의 국내 4년제 및 전문 대학교 재학생 중 소속대학 인근 주거시설을 임차하여 거주하며/ 학자금 지원구간 3구간 이내인 에너지 전공자  * 자세한 사항은 첨부파일 참고',
      Col13: '선발 지역 소재의 대학만 신청 가능  * 첨부파일 확인 바람',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: ' * 평가기준: 가계소득(50점) + 성적(50점) + 가산점(10점)/ 평가 점수 높은 순 * 동점자 처리기준: 주거시설이 월세/ 하숙집/ 고시원인 자 > 학자금 지원구간 낮은 자 > 성적상위자 > 연소자',
      Col16: '80명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생·편입생 제외',
      Col18: '해당없음',
      Col19: '주거시설 임차 증빙 서류주거지원형 기부장학금 신청서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(현대홈쇼핑)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '특정학과',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수',
      Col10: '소득구간 3구간 이내인 자',
      Col11: '2000000원 (2019년 2학기 지원) (생활비 무상보조로 정액지원)',
      Col12: '대한민국 국적의 국내 4년제 및 전문대학교 재학생방송 관련 학과(학부) 재학생공고일 현재 잔여 정규학기가 1개 학기 이상인자 * 방송관련학과(학부)는 방송/ 언론/ 광고/ 영상/ 미디어/ 문예창작/ 커뉴니케이션/ 스토리텔링의 전공명이 포함된 경우로 한정됨',
      Col13: '해당없음',
      Col14: '2022-06-15~2022-06-28',
      Col15: '1차: 가계소득(100)2차: 자기소개서(100) * 동점자 처리기준 : 소득구간> 성적 > 연장자',
      Col16: '50명 ',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생/편입생 제외',
      Col18: '해당없음',
      Col19: ' * 한국장학재단장학금기부장학금푸른등대 기부장학금 신청하기자기소개서'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 (KOSAF기부펀드 유형Ⅰ)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수 * 계속장학생 기준도 선발 성적기준과 동일',
      Col10: '학자금 지원구간 2구간 이하인 자',
      Col11: '2000000원 * 생활비 무상보조로 정액 지원(2개 학기)',
      Col12: '대한민국 국적의 국내 4년제 및 전문 대학교 재학생가정 외 보호시설 보호종결 또는 연장보호 중인자 * 자세한 사항은 첨부파일 참고',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '1차 가계소득(60점) + 성적(40점)/ 2배수 선발2차 자기소개서(100) * 동점자 처리기준 : 학자금 지원구간 낮은 순 > 성적상위자 > 연소자 * 자세한 사항은 첨부파일 참고',
      Col16: '40명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '가정 외 보호 사실 증명서자기소개서  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 (하나금융그룹)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수 * 계속장학생 기준도 선발 성적기준과 동일함',
      Col10: '소득구간 3분위 이내인자',
      Col11: '2000000원 ',
      Col12: '대한민국 국적의 국내 4년제 및 전문대학교 재학생공고일 현재 잔여 정규학기가 2개 학기 이상인자다문화가정 또는 탈북 가정의 대학생(부모 또는 그 자녀)',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: ' * 평가기준: 가계소득(100점) * 동점자 처리기준: 소득분위>성적>연장자',
      Col16: '32명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생/편입생 제외',
      Col18: '해당없음',
      Col19: '다문화 가정 확인 서류  * 한국 국적 취득 전: 외국인 부 또는 모의 외국인등록증  * 한국 국적 취득 후: 한국 국적 취득한 부 또는 모의 기본증명서/ 제적등본/ 국적취득 사실증명서 등 국적 취득 사실을 확인 할 수 있는 서류탈북 가정 확인 서류  * 북한이탈주민등록 확인서 '
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(ETS TOEFL)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 87점 이상/ 최소 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '2000000원※ 생활비성 장학금',
      Col12: '국내 4년제 및 전문 대학교 재학생1개 학기 이상 이수한 자영어활동실적이 있는 자',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '가계소득(50) + 성적(50)',
      Col16: '49명',
      Col17: '신청 제외 대학: 전공대학/ 대학원대학/ 원격대학(방송통신대학/ 사이버대학)/ 기능대학졸업학기 제외',
      Col18: '해당없음',
      Col19: '※ 한국장학재단 → 장학금 → 기부장학금 → 푸른등대 기부장학금 →  신청하기영어활동증명서(택1)  1. 공인영어성적표 : TOEFL/ TOEIC     ※ 2015년 8월 1일 이후 발급한 성적표에 한함  2. 영어교과목 수강증명서 : 대학교 성적표     ※ 과목명에 \'영어/ English/ TOEFL/ TOEIC/ TEPS/ IELTS/ GTELP/ FLEX/ OPIC\' 단어가 포함되어 있어야 함     ※ 대학교 직인 필수  3. 소속학교 해외교류 프로그램(영미권* 교환학생 및 어학연수)참여 경험 증빙     * 영미권 국가: 영국/ 아일랜드/ 미국/ 캐나다/ 뉴질랜드/ 오스트레일리아     ※ 대학교 직인 필수'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(신한카드)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '해당없음',
      Col8: '예체능계열',
      Col9: '직전 정규학기 백분위 87점 이상/ 최소 12학점 이상 이수※ 계속장학생 기준도 선발 성적기준과 동일',
      Col10: '소득분위(구간) 2분위(구간) 이내',
      Col11: '2000000원 (생활비 무상보조로 정액 지원)※2개 학기 (’18년 1학기 ~ ’18년 2학기)',
      Col12: '국내 4년제 및 전문 대학교 재학생 (신ㆍ편입생/ 졸업학기자 제외)예체능계열 전공자 (음악/ 체육/ 미술/ 공연예술 등 관련학과) * ‘18년도 대학별 학과계열 분류체계에 의함 ',
      Col13: '해당없음',
      Col14: '2022-04-08~2022-04-21',
      Col15: '가계소득(50) + 성적(50)',
      Col16: '25명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 삼성기부장학금',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '계속장학생 : 직전 정규학기(2021년도 2학기) 백분위 70점 이상신규장학생 선발 성적기준 없음',
      Col10: '대학학자금지원시스템에서 2022년 1학기 소득구간(분위) 3구간 이내로 확인이 가능한자에 한함',
      Col11: '1500000원 (생활비 무상보조)',
      Col12: '한부모가정/ 장애인/ 가정외 보호출신/ 새터민/ 학생가장 등 사회적 배려계층기초생활수급자 / 차상위계층 가정의 본인 또는 자녀주거비 지원 필요자대한민국 국적의 국내 4년제 및 전문대학교 재학생',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '1명 ',
      Col17: '2022년 1학기 푸른등대 기부장학금 장학생은 추천불가2022년 1학기가 졸업 학기인 학생은 추천 불가학사/수납 정보 미등록자',
      Col18: '학생신청 접수 및 대학별 자체적으로 수립한 추천기준에 따라 배정인원만큼 재단에 학생 추천',
      Col19: ' * 해당자 서류제출한부모가족 증명서장애인 증명서 또는 장애인등록증가정외 보호사실 증명서(아동복지시설 출신확인서/ 재원증명서)북한이탈주민 등록확인서가족관계증명서 등기초생활수급자 증명서/ 차상위계층 확인서다문화 가정 증빙서류기숙사 고지서 / 하숙집(고시원) 하숙 확인서 / 전(월)세 계약서 (주거비 지원 필요자)부모명의 주민등록 초·등본 모두(주거비 지원 필요자) * 서류제출일 기준 1개월 이내 발급된 서류만 유효 * 자세한사항은 학교 홈페이지 장학공지 또는 한국장학재단으로 문의'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 (블리자드)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 87점 이상/ 최소 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '학기당 2000000원 지원 (생활비 무상보조로 정액 지원) (2019. 2학기~ 2020. 1학기 : 2개학기 지원) * 해외탐방 비용과 역량강화 프로그램 장학금은 별도의 지원 사항임',
      Col12: '대한민국 국적의 국내 4년제 및 전문대학교 재학생게임관련분야에 관심이 있거나/ 향후 게임관련 분야로 진로를 선택예정인 자 중 해외탐방 및 역량강화 프로그램 참가가 가능한 자',
      Col13: '해당없음',
      Col14: '2021-12-30~2022-01-12',
      Col15: '1차 : 가계소득(30) + 성적(70)2차 : 자기소개서(100) + 수상실적(5) * 동점자 처리기준 : 소득구간 > 성적 > 연장자',
      Col16: '12명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생/편입생 제외/ 졸업학기자 제외',
      Col18: '해당없음',
      Col19: '자기소개서/ 여권 사본( 출국일(2019.11.01예정) 기준 유효기간 6개월 이상 남아있는 여권)수상실적 증빙서류 (선택) * 제출서류가 2개 이상인 경우 1개의 형태로 업로드 * 자세한 사항은 첨부파일 또는 홈페이지 푸른등대 게시판 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(KDB나눔재단)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 80점이상/ 최소 12학점 이상 이수 * 계속장학생 기준도 선발 성적기준과 동일함',
      Col10: '소득구간(분위) 3구간(분위) 이내 또는 사회배려 계층 대학생 * 장애인 새터민 가정외보호출신 한부모 가정 학생가장 다문화 가정',
      Col11: '학기당 2500000원 지원 (생활비 무상보조로 정액 지원)2개 학기 지원 ',
      Col12: '대한민국 국적의 국내 4년제 대학교 3학년 재학생선발분야별(일반분야/ 특기분야) 기준을 충족하는 자로 인재육성 프로그램 참가가 가능한 자 * 일반분야 : 전공제한 없음 * 특기분야 : 예체능 계열 전공자',
      Col13: '해당없음',
      Col14: '2022-06-15~2022-06-28',
      Col15: '1차 : 가계소득(50) + 성적(50)2차 : 자기소개서(100) * 동점자 처리기준 : 소득구간 > 성적 > 연장자',
      Col16: '23명 ',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생/편입생/ 졸업학기자 제외',
      Col18: '해당없음',
      Col19: '소득확인 서류제출 및 가구원 동의기부처별 추가 서류 제출 * 한국장학재단 홈페이지 온라인 신청 * 자세한 사항은 첨부파일 또는 한국장학재단 홈페이지 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(국민연금공단)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수 * 계속장학생 기준도 선발 성적기준과 동일함',
      Col10: '취약계층 국민연금 수급자 또는 수급자의 자녀 중 학자금 지원구간 3구간 이하인 자',
      Col11: '1500000원 ( * 생활비 무상보조로 정액 지원)',
      Col12: ' * 대한민국 국적의 국내 4년제 및 전문대학교 재학생취약계층 국민연금 수급자 또는 수급자의 자녀 중 학자금 지원구간 3구간 이하인 자공고일 기준 현재 잔여 정규학기가 1개 학기 이상인자',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '(1차) 가계소득(60점) + 성적(40점)(2차) 자기소개서(100점)',
      Col16: '100명 ※ 지역별 선발 인원 첨부파일 참조',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생·편입생 제외장애일시보상금/ 유족연금일시금 수령자 및 그 자녀푸른등대 국민연금공단 기부장학금 기 수혜자',
      Col18: '해당없음',
      Col19: '국민연금 지급내역 증명서 * 자세한 사항은 첨부파일 참조 ** 한국장학재단 온라인 신청'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 (안전보건공단)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수 * 계속장학생 기준도 선발 성적기준과 동일함',
      Col10: '해당없음',
      Col11: '학기당 1500000원 (생활비 무상보조로 정액지원) * 19년 2학기 20년 1학기',
      Col12: '대한민국 국적의 국내 4년제 및 전문대학교 재학생공고일 현재 잔여 정규학기가 2개 학기 이상인자산업재해 사망자 자녀 또는 장해등급 1~7급 판정 근로자 본인 또는 그 자녀',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: ' * 1차: 가계소득(60점) + 성적(40점) * 2차: <1순위> 산업재해사망자          <2순위> 산업재해 장해등급(1~7급)/ 1급부터 우선순위 적용 * 동점자 처리기준: 소득분위>성적>연장자',
      Col16: '20명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생/편입생 제외',
      Col18: '해당없음',
      Col19: '보험급여 지급확인서가족관계증명서 (산업재해 근로자 자녀일 경우)'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 (㈜에뛰드)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '예체능계열',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수',
      Col10: '소득구간 2분위 이내인 자',
      Col11: '3000000원 지원 (생활비 무상보조로 정액지원) * 18년 2학기',
      Col12: '대한민국 국적의 국내 4년제 및 전문대학교 재학생공고일 현재 잔여 정규학기가 1개 학기 이상인자음악/ 체육/ 미술/ 공연예술 등 관력학과 (18년도 대학별 학과계열 분류체계에 의함)',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: ' * 1차: 가계소득(50점) + 성적(50점) * 2차: 자기소개서(100점) * 동점자 처리기준: 소득분위>성적>연장자',
      Col16: '20명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생/편입생 제외',
      Col18: '해당없음',
      Col19: '자기소개서'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 (우리은행)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '특정학과',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수',
      Col10: '소득구간 3분위 이내인 자',
      Col11: ' 2000000원 지원 (생활비 무상보조로 정액지원) * 18년 2학기',
      Col12: '대한민국 국적의 국내 4년제 및 전문대학교 재학생공고일 현재 잔여 정규학기가 1개 학기 이상인자경영/ 경제 관련 학과(학부) 재학생   (경영/ 경제/ 금융/ 회계/ 무역/ 재무/ 세무/ 통상 단어가 포함된 경우)',
      Col13: '해당없음',
      Col14: '2020-01-30~2020-02-17',
      Col15: ' * 가계소득(50점) + 성적(50점) * 동점자 처리기준: 소득분위>성적>연장자',
      Col16: '37명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생/편입생 제외',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 (한국공항공사)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 70점 이상/ 최소 12학점 이상 이수',
      Col10: '소득구간 3분위 이내인 자',
      Col11: '학기당 1000000원 지원 (생활비 무상보조로 정액 지원)2개 학기 (2020년 1학기 ~ 2020년 2학기) *푸른등대 기부장학금 계속 지원의 경우 별도 신청절차 없이 성적요건이 충족될 시 계속 지원',
      Col12: '대한민국 국적의 국내 4년제 및 전문대학교 재학생공고일 현재 잔여 정규학기가 1개 학기 이상인자소음대책지역에 거주하는 학생',
      Col13: '선발 지역 소재의 대학만 신청 가능  * 첨부파일 확인 바람',
      Col14: '2022-06-15~2022-06-28',
      Col15: ' * 평가기준: 최근 소음대책지역 거주기간(100점) * 동점자 처리기준: 거주기간>성적상위자>소득분위>성적>연장자',
      Col16: '209명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외신입생/편입생 제외기수혜자는 선발 제외',
      Col18: '해당없음',
      Col19: '소득확인 서류제출 및 가구원 동의기부처별 추가 서류 제출 * 한국장학재단 홈페이지 온라인 신청 * 자세한 사항은 첨부파일 또는 한국장학재단 홈페이지 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(DGB사회공헌재단)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '2000000원 * 생활비 무상보조로 정액 지원(1개 학기)',
      Col12: '대한민국 국적의 국내 4년제 및 전문 대학교 재학생경북/강원 지역 산불로 경제적 어려움에 처한 특별재난지역(경북 울진/ 강원 강릉/ 동해/ 삼척)의 산불 피해 가정의 대학생  * 자세한 사항은 첨부파일 참고',
      Col13: '해당없음',
      Col14: '2022-03-03~2022-03-24',
      Col15: '가계소득(100점)  동점자 처리 기준: 학자금 지원구간 낮은 자 > 성적상위자 > 연장자  * 자세한 사항은 첨부파일 참고',
      Col16: '26명',
      Col17: '전공대학/ 대학원대학/ 방송통신대학/ 원격대학/ 사이버대학/ 기능대학은 제외   * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '피해사실확인서  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '고졸후학습자장학금(희망사다리ll유형)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 백분위 70점 이상인 자',
      Col10: '해당없음',
      Col11: '(중소·중견기업) 등록금 전액 지원(대기업 비영리기관) 등록금 50% 지원',
      Col12: '대한민국 국적자로 최종 학력이 고졸인 자2022년 1월 1일 기준 지원 대상 기업에 재직 중인 자자',
      Col13: '해당없음',
      Col14: '2021-07-12~2021-07-23',
      Col15: '선발배점 : 연령(30점)/ 출신고교(30점)/ 재직기관(30점)/ 재직기간(10점) * 자세한 사항은 한국장학재단 홈페이지 참고 바랍니다.',
      Col16: '해당없음',
      Col17: '대학 기본역량 진단평가 결과에 따른 재정지원제한 Ⅱ유형 대학부 또는 모가 대표인 기업/ 재직의무 이행 제외 업종 해당 기업 등 재직 인정 제외 기업의 경우 지원 제외해당학기 등록금을 타장학금으로 전액 수혜한 자 * 자세한 사항은 한국장학재단 홈페이지 참조 바랍니다.',
      Col18: '해당없음',
      Col19: '직업계고 고등학교 졸업 증명서일반계고 위탁과정 수료증가족관계증명서(해당자)대학졸업증명서(해당자) * 자세한 사항은 한국장학재단 홈페이지 참고 바랍니다.'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(한국남부발전)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 87점 이상/ 최소 12학점 이상 이수',
      Col10: '학자금 지원구간 3구간 이하인자',
      Col11: '1000000원 ( * 생활비 무상보조로 정액 지원)',
      Col12: '대한민국 국적의 국내 4년제 대학교 재학생부산지역 소재 대학의 3/4학년 재학생(* 4학년 이상은 모두 4학년으로 간주)코로나19로 경제적 피해를 입은 소상공인 가정의 대학생',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '가계소득 60점+ 성적 40점',
      Col16: '13명 ',
      Col17: '신입생/ 편입생/ 졸업예정자 제외',
      Col18: '해당없음',
      Col19: '소상공인확인서 또는 소상공인 정책자금 지원대상 확인서가족관계증명서기부장학금 신청서'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(한국인삼공사)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수',
      Col10: '해당없음',
      Col11: ' 학기당 2150000원 (2개 학기 19년 2학기 ~ 20년 1학기)',
      Col12: '대한민국 국적의 국내 4년제 및 전문 대학교 재학생공고일 현재 잔여 정규학기가 2개학기 이상인 자6년근 인삼경작인의 자녀  *6년근 인삼경작확인서 제출 후 한국인삼공사 최종 검증',
      Col13: '해당없음',
      Col14: '2022-03-10~2022-03-30',
      Col15: ' 1차 : 가계소득 50점 + 성적 50점 2차 : 자기소개서',
      Col16: '해당없음',
      Col17: '신입생/ 편입생/ 졸업학기자 제외',
      Col18: '해당없음',
      Col19: '자기소개서인삼경작확인서(다운로드 양식으로 작성)가족관계증명서'
    },
    {
      Col1: '한국장학재단',
      Col2: '전문기술인재장학금',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기에 12학점 이상 이수하였으며/ 직전학기까지의 총 평균성적이 백분위 점수 80점 이상인 자 (단/ 1학년 등 신입생군은 성적 및 이수학점 최소요건 기준 없음)',
      Col10: '해당없음',
      Col11: 'Ⅰ유형 지원자의 경우 등록금 전액 생활비 200만 원/1학기 Ⅱ 유형 지원자의 경우 등록금 전액 * 연 단위로 선발하여 지원',
      Col12: '대한민국 국적 소지자로서/ 사업 참여대학 재학생 중 종합적 취업 역량 개발 노력과 성취가 우수한 학생사업 참여를 신청한 전문대학의 정규과정에 재학 중인 학생',
      Col13: '해당없음',
      Col14: '2020-04-13~2020-04-27',
      Col15: '대학별 자체 선발 (취업역량개발/ 학업성적/ 경제적수준등을 대학별 기준으로 평가·선발)',
      Col16: '1/000명',
      Col17: '선발 학기 현재 졸업학기인 경우22년도 현재 전문기술인재장학생 자격 유지자 또는 기존 전문기술인재장학생으로 선발된 후 자격 상실자동일 학기에 한국장학재단에서 운영 중인 타 장학금 수혜자 또는 장학생 자격 유지자계약학과 재학생 선발 제외 * 자세한 내용은 홈페이지 공고 확인 바람람',
      Col18: '해당없음',
      Col19: '한국장학재단 홈페이지에서 신규장학생 추천대상자 온라인 신청 시 제출 (신청시 서류양식 다운로드 가능)학업계획서를 지정된 파일형식으로 제출'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(코로나19 긴급지원)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '학자금지원구간 8구간 이하',
      Col11: '1000000원 (생활금보조)',
      Col12: '소상공인 확인서 주소를 기준으로 특별재난지역(대구광역시/ 경북 경산시·청도군·봉화군)에 주소를 기준한 학자금지원구간 8구간 이하의 소상공인 가정의 대학생',
      Col13: '소상공인 확인서 주소를 기준으로 특별재난지역(대구광역시/ 경북 경산시·청도군·봉화군)에 주소를 기준한 소상공인 가정의 대학생',
      Col14: '2020-04-27~2020-08-22',
      Col15: '선발기준 : 가계소득 100점 ※ 성적기준 없음',
      Col16: '500명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '긴급지원 기부장학금 신청서소상공인확인서가족관계증명서 (신청자가 소상공인 본인이 아닌 경우) * 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '한국장학재단',
      Col2: '저금리 전환대출',
      Col3: '한국장학재단',
      Col4: '학자금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대출 금리 : 2.9%로 하향 「한국장학재단 일반상환학자금 전환대출」금리 : 고정 금리 ※ 전환대출 기간(\'20.4 ~ \'21.3) 중 일반상환 학자금의 대출 금리가 변동 되더라도 2.9%로 유지',
      Col12: ' * 20052학기 ~ 20092학기 학자금 대출자 중 대출잔액 보유자은행 정부보증학자금 대출자(\'05.2학기 ~ \'09.1학기)재단 일반상환학자금 대출자(\'09.2학기) 중 계좌의 잔액이 10만원 이상이며/ 정상 변액중인 자 ※ 자세한 사항은 홈페이지 참고',
      Col13: '해당없음',
      Col14: '2022-06-15~2022-06-28',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대출 제한대상자 제외',
      Col18: '해당없음',
      Col19: '홈페이지 신청'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(한국산업안전보건공단)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 백분위 80점 이상/ 최소 12학점 이상 이수 ※ 계속장학생 기준도 선발 성적기준과 동일',
      Col10: '해당없음',
      Col11: '1500000원 * 생활비 무상보조로 정액 지원 2개 학기 지원',
      Col12: ' * 대한민국 국적의 국내 4년제 및 전문 대학교 재학생산업재해 사망자 자녀 또는 장해등급 1~7급 판정 근로자 자녀',
      Col13: '해당없음',
      Col14: '2022-06-15~2022-06-28',
      Col15: '평가기준 : 가계소득(60점) + 성적(40점)동점자 처리기준: 산업재해사망자 > 산업재해 장해등급 고등급자(1급→7급 순) > 학자금 지원구간 낮은 자 > 성적상위자 > 연소자  * 자세한 사항은 첨부파일 참조',
      Col16: '20명',
      Col17: '전공대/ 대학원대/ 방송통신대/ 원격대/ 사이버대/ 기능대/ 평생교육원 재학생신입생·편입생/ 공고일 현재 잔여 정규학기가 2개 학기 미만인 자졸업학기자푸른등대 안전보건공단 기부장학금 기 수혜자 선발 제외',
      Col18: '해당없음',
      Col19: '보험급여 지급확인원  * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(손해보험사회공헌협의회)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '학자금 지원구간 3구간 이하인 실직자 가정의 재학생 * 상시근로자: 2020. 2. 23. 이후 실직한 자 * 일용근로자: 2021년 12월부터 2022년 5월까지 일용근무일수가 48일 이상이고 2021년 12월부터 2022년 5월까지 일용근무일수가 (21년 6월~21년 12월 대비) 24일 이상 감소한 자 ※ 자세한 사항 첨부파일 참조',
      Col11: '1000000원 ( * 생활비 무상보조로 정액 지원 2개 학기)',
      Col12: '경제적 어려움을 겪는 대한민국 국적의 국내 4년제 및 전문 대학교 재학생으로/ 학자금 지원구간 3구간 이하인 실직자 가정의 재학생 * 자세한 사항은 첨부파일 참조',
      Col13: '해당없음',
      Col14: '2022-06-15~2022-06-28',
      Col15: '평가기준 : 가계소득(60점) + 성적(40점)동점자 처리기준: 다자녀 가정 > 금융/보험전공 > 학자금 지원구간 낮은 자 > 성적상위자 > 연소자 * 자세한 사항 첨부파일 참조',
      Col16: '206명 ',
      Col17: '전공대/ 대학원대/ 방송통신대/ 원격대/ 사이버대/ 기능대/ 평생교육원 재학생신입생·편입생공고일 현재 잔여 정규학기가 2개 학기 미만인 자(졸업학기자)',
      Col18: '해당없음',
      Col19: '상시근로자: 고용보험 자격이력내역서(근로자용) 또는 건강보험 자격득실확인서일용근로자: 고용보험 일용근로내역서(근로자용) * 자세한 사항은 첨부파일 참조 ** 한국장학재단 온라인 신청'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(유지웅 기부장학금)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '예체능계열/특정학과',
      Col9: '직전 정규학기 성적 백분위 80점 이상/ 최소 12학점 이상 이수',
      Col10: '학자금 지원구간 3구간 이하인 자',
      Col11: '2000000원 * 생활비 무상보조로 정액 지원',
      Col12: '대한민국 국적의 국내 4년제 대학교 재학생으로 체육계열 전공이면서 학자금 지원구간 3구간 이하인 자 * 학과명에 체육 또는 스포츠 단어가 포함되거나 스포츠 종목이 포함된 학과명(예시 : 태권도학과)',
      Col13: '해당없음',
      Col14: '2020-07-06~2020-07-21',
      Col15: '평가기준 : 가계소득(60점) + 성적(40점)동점자 처리기준: 학자금 지원구간 낮은 자 > 성적상위자 >연소자',
      Col16: '5명',
      Col17: '전공대/ 대학원대/ 방송통신대/ 원격대/ 사이버대/ 기능대/ 평생교육원 재학생신입생·편입생공고일 현재 잔여 정규학기가 2개 학기 미만인 자(졸업학기자)',
      Col18: '해당없음',
      Col19: ' * 한국장학재단 온라인 신청으로/ 제출서류 없음'
    },
    {
      Col1: '한국장학재단',
      Col2: '푸른등대 기부장학금(KT&G)',
      Col3: '한국장학재단',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 성적 백분위 80점 이상/ 최소 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '1010000원 * 생활비 무상보조로 정액 지원',
      Col12: '대한민국 국적의 국내 4년제 및 전문 대학교 재학생으로 입학연도가 2020년이고/ 2020년 2학기 기준 1학년인 대학생',
      Col13: '해당없음',
      Col14: '2021-10-04~2021-10-13',
      Col15: '평가기준 : 가계소득(70점) + 성적(30점)',
      Col16: '20명',
      Col17: '전공대/ 대학원대/ 방송통신대/ 원격대/ 사이버대/ 기능대/ 평생교육원 재학생2020학년도 2학기 신입생·편입생',
      Col18: '해당없음',
      Col19: ' * 한국장학재단 온라인 신청으로/ 제출서류 없음'
    },
    {
      Col1: '인천국제공항공사',
      Col2: '대학생 교육봉사단',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원 임직원과의 멘토링 제공',
      Col12: ' * 인천/경기 소재의 대학교를 다니는 대학생 혹은 인천/경기 거주중인 대학생으로/ 지역아동센터 및 대안학교의 이주배경 청소년 대상으로 멘토링 활동이 가능한 자 (휴학생/ 대학원생/ 타국적 대학생 포함)활동기간 : 2021.11~2022.06 (8개월 간) ※ 자세한 사항은 첨부사항 및 기관 홈페이지 참고',
      Col13: '인천/경기 소재 대학 대학생인천/경기 거주 중인 대학생',
      Col14: '2022-07-25~2022-10-28',
      Col15: '(1차) 서류심사(2차) 면접심사',
      Col16: '100명',
      Col17: '중도에 활동을 포기하거나 불성실하게 임한 경우 장학금 지급하지 않음',
      Col18: '해당없음',
      Col19: ' * 온라인 접수로/ 기관 홈페이지 방문바람'
    },
    {
      Col1: '공무원연금공단',
      Col2: '대여학자금',
      Col3: '관계부처',
      Col4: '학자금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '당해 학기의 실제 등록금 범위 내에서 십원 단위로 신청',
      Col12: '현직공무원 본인 및 자녀의 대학교 등록금(시간제 공무원 가능)* 배우자는 대부대상에서 제외국내대학 대학교(학점은행제 교육기관 포함)해외대학 대상학교는 국내대학 대상학교 적용기준 (고등교육법)을 준용함',
      Col13: '해당없음',
      Col14: '2021-10-12~2021-10-22',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '직업훈련기관/ 기술학원/ 각종 비인가 학교 등해외유학생의 경우 유학생을 위한 어학연수 과정 등대학원대학 및 대학원과정/ 전문대학원/ 계절학기 수강중복수혜 불가 (국가장학금이 등록금의 일부일 경우 차액 대부 신청 가능)',
      Col18: '해당없음',
      Col19: '국내 대학은 인터넷으로만 신청해외대학은 인터넷 또는 수기신청 가능'
    },
    {
      Col1: '서울특별시 양천구청',
      Col2: '소음대책지역거주장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '소음대책·인근지역(소음도 70웨클 이상)에서 1년 이상 거주 중인 대학교 재학생생',
      Col13: '양천구청 내 소음대책·인근지역(소음도 70웨클 이상)에서 1년 이상 거주 중인 자 (학생 본인 주민등록초본상 주소) * (전지역 해당) 신월 1·3·4·6·7동 (일부지역 해당) 신월2·5동/ 신정1·3·7동',
      Col14: '2022-08-29~2022-09-16',
      Col15: '점수산정기준에 따라 동별 배정인원 범위 내 점수 높은 순으로 선발',
      Col16: '150명',
      Col17: '방송통신대/ 사이버대/ 원격대/ 평생교육원 등 재학생2019년 ~ 2020년도 한국공항공사(한국장학재단 푸른등대 기부장학금 포함) 또는 양천구 공항소음대책(인근)지역 장학금 수혜자1세대 1명 선발휴학생 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '신청서주민등록초본통장사본재학증명서주민등록등본 또는 가족관계증명서(부 또는 모/ 다자녀 해당자) * 자세한 사항은 첨부파일 참조 '
    },
    {
      Col1: '한국국토정보공사',
      Col2: '유자녀장학생',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 실 고지금액 (최대 1000000원)',
      Col12: '지적 분야 종사 중 사망한 자의 유자녀대학(교)에 재학 중이거나 2022년 2학기 복학 예정인 자행실이 바르고 타의 모범이 되는 자',
      Col13: '해당없음',
      Col14: '2022-08-29~2022-09-16',
      Col15: '해당없음',
      Col16: '5명',
      Col17: '정학 이상의 징계를 받은 경우학생 신분에 어긋난 행동을 하였을 경우기타 학업을 계속할 수 없는 경우등록금 실 납부금액이 50만원 미만인 경우우전액 장학금 수혜자 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 지원서재학증명서 원본2022년도 제2학기 등록금 고지서 사본본인 예금통장 사본개인정보 수집·이용·제공 및 조회 동의서지적 분야 종사 중 사망하였음을 증빙하는 서류 1부(기 제출자는 생략)제적등본 원본 * 자세한 사항은 첨부자료 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '한국국토정보공사',
      Col2: '성적우수장학생',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학중 직전학기 평점평균이 4.5만점기준 4.0 또는 4.3만점기준 3.82점 이상이고/ 당해학기 취득학점이 12학점 이상인 자 * 휴학 후 복학하는 경우 : 휴학 직전년도 (최종학기) 서적',
      Col10: '해당없음',
      Col11: '최대 1000000원',
      Col12: '지적 분야 종사자와 그 자녀대학교에 재학 중이거나 2022년도 2학기 복학 예정인 자행실이 바르고 타의 모범이 되는 자',
      Col13: '해당없음',
      Col14: '2022-01-03~2022-01-21',
      Col15: '해당없음',
      Col16: '80명',
      Col17: '정학 이상의 징계를 받은 경우학생 신분에 어긋난 행동을 하였을 경우기타 학업을 계속할 수 없는 경우등록금 실 납부금액이 50만원 미만인 경우전액 장학금 수혜자는 지원 불가 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 지원서재학증명서 원본20222학기 등록금 고지서 사본본인 예금통장 사본 1부개인정보 수집·이용·제공 및 조회 동의서직전학기 성적증명서 원본부모(본인)의 재직증명서 원본가족관계증명서 또는 주민등록등본소득분위 확인서(해당자) * 자세한사항은 첨부자료 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '한국장애인개발원',
      Col2: '쌍용곰두리장학(성적우수)',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 평균 80점 이상인 학생',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '전문대학/ 사이버대학에 재학하고 있는 장애 학생',
      Col13: '해당없음',
      Col14: '2022-01-03~2022-01-21',
      Col15: '성적/ 소득수준 등을 합산/ 지원자 상대평가 후 선발 ',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원신청서개인정보제공동의서직전 학기 성적증명서장애인 증명 서류가족관계증명서 사본가정형편을 증명할 수 있는 서류건강장기요양보험료 납부확인서 '
    },
    {
      Col1: '한국장애인개발원',
      Col2: '쌍용곰두리장학(예체능특기)',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '예체능계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '전문대학 사이버대학 학생 학기당 1000000원',
      Col12: '전문대학 및 사이버대학에 재학 중인 장애학생2019년 이후 국내외 예/체능대회에서 입상한 경력이 있는 자',
      Col13: '해당없음',
      Col14: '2022-01-03~2022-01-24',
      Col15: '성적/ 소득수준 등을 합산/ 지원자 상대평가 후 선발 ',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원신청서개인정보제공동의서직전 학기 성적증명서장애인 증명 서류가족관계증명서가정형편을 증명할 수 있는 서류   건강장기요양보험료 납부확인서각종대회 입상 증명서류 * 자세한 사항은 홈페이지 공고 참고'
    },
    {
      Col1: '한국장애인개발원',
      Col2: '쌍용곰두리장학(정보통신특기)',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기',
      Col8: '공학계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '전문대학 사이버대학 학생 학기당 1000000원일반대학 대학원 학생 학기당 1500000원원',
      Col12: ' * 공통사항 : 대학에 재학중인 장애학생정보통신 분야 전공학생으로 2018년 이후 국내외 정보통신대회에서 입상한 경력이 있는 학생 * 선발 장학생 의무사항 (미 이행 시 장학금 지급 중단)매 학기 성적증명서 제출매 학기 기준 성적 유지 : 평균 80점장학생 기록카드 제출',
      Col13: '해당없음',
      Col14: '별도 모집',
      Col15: '성적/ 소득수준 등을 합산/ 지원자 상대평가 후 선발 ',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원신청서 및 추천서개인정보제공동의서직전학기 성적증명서장애인 증명 서류가족관계증명서가정형편을 증명할 수 있는 서류 '
    },
    {
      Col1: '(재)한국지도자육성장학재단',
      Col2: '일반장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '매 정규학기 당 최소 12학점 이수한 자 전체학기 백분율 성적이 85점 이상인자(21년 동계계절학기 제외한 전체성적)',
      Col10: '소득분위 8분위(국가장학금 기준) 이하인 자',
      Col11: '등록금 전액(수업료)+학업보조비(200만원/년)/최대2년(4개학기)',
      Col12: '20221학기 기준 3학년 1학기에 등록예정인 자학칙에 의한 징계사실이 없는 자 (학사경고 포함)',
      Col13: '해당없음',
      Col14: '2021-03-08~2021-11-25',
      Col15: '1차 : 서류심사2차 : 면접심사',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.장학생 지원서추천서 자기소개서 개인정보 수집 이용 제공 및 조회 동의서장학생 의무사항 참여 동의서전 학년 성적증명서(전체학기 종합 백분위점수 기재)자기소개서 관련 증빙서류(주요 활동실적)우대조건(가산점부여)항목 증빙서류'
    },
    {
      Col1: '근로복지공단',
      Col2: '산재근로자자녀학자금',
      Col3: '관계부처',
      Col4: '학자금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '연간 총액 5000000원을 최고한도액으로 1년간 실 납부금액을 지원 ! ',
      Col12: '산업재해사망근로자 배우자 및 유자녀상병보상연금수급자 본인/ 그 배우자 및 자녀신체장애등급 1~7등급 본인 / 그 배우자 및 자녀산재 보험법에 의한 5년 이상 장기요양자 중 이황화탄소 질병 판정자 본인 / 배우자 및 자녀 ',
      Col13: '해당없음',
      Col14: '2022-01-18~2022-03-14',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생선발 신청서주민등록등본가족관계증명서 * 유족인 경우 08년 이전 사망 유족은 제적 등본'
    },
    {
      Col1: '서울특별시청',
      Col2: '서울시대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '한국장학재단 학자금 지원구간 8구간 이하',
      Col11: ' * 한국장학재단 학자금 대출에 대해 2021년 7월 ~ 12월(하반기)에 발생한 이자액을 소득분위 별로 아래와 같이 지원(기초생활수급자 소득분위 7분위 이하) 전액지원  * 일반 상환학자금만 해당(소득8분위) 소득분위별 차등지원(3자녀 이상 다자녀가구)  소득분위 상관없이 전액지원 ※ 자세한 사항은 첨부파일 참조',
      Col12: '한국장학재단에서 학자금대출(일반 상환학자금/ 취업 후 상환학자금)을 받은 서울지역 대학생',
      Col13: '주민등록상 주소가 서울이며/ 2022년 상상반기 국내 대학교 재학생 및 휴학생주민등록상 주소가 서울이며/ 대학(교) 졸업 후 5년 이내인 사람 * 자세한 사항은 첨부자료 참고',
      Col14: '2022-06-13~2022-06-24',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원생/ 대학졸업/ 수료/ 제적 등은 지원대상이 아님',
      Col18: '해당없음',
      Col19: ' * 대학 재학생 및 휴학생주민등록등본 또는 초본대학 재학증명서 * 대학 졸업생(5년 이내)주민등록등본 또는 초본대학 졸업증명서 * 다자녀가구가족관계증명서'
    },
    {
      Col1: '서울특별시 도봉구청',
      Col2: '생활안정자금 융자',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가구합산 재산세 연 20만원 이하이며 도시근로자 가구당 월평균 소득 이하인 가구 * 자세한 사항은 첨부파일 참조',
      Col11: '가구당 50000000원 이하 * 융자조건 : 2년 거치 3년 균등분할 상환 * 대출금리 : 연 2% 2022. 12. 31.까지는 한시적으로 무이자',
      Col12: '신용등급 1~6등급으로 금융기관 여신 관리규정상 여신 적격자로 직계비속에 대한 고등학교 이상의 재학생 학자금 용도 대출을 원하는 자',
      Col13: '주민등록상 주소지가 도봉구인 자',
      Col14: '2022-07-06~2022-07-20',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '소득대비 부채가 과다한 자대출예정일까지 생활안정자금 융자 외 추가 대출을 받을 경우 융자취소·제한1세대 1인 신청빚 상환 용도 대출 불가무소득자/ 신용불량자',
      Col18: '해당없음',
      Col19: '신분증주민등록등본·초본신청서사용계획서개인정보조회동의서소득 증빙서류해당자 증빙서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '서울특별시 광진구청',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '22학년도 1학기 평균학점 2.5이상 (최저이수 9학점)',
      Col10: '생활이 곤란한 학생',
      Col11: '2500000원',
      Col12: '광진구에 공고일 현재 계속해서 1년 이상 주소지를 두고 있는 대학생',
      Col13: '광진구에 공고일 현재 계속해서 1년 이상 주소지를 두고 있는 대학생',
      Col14: '2022-07-06~2022-07-20',
      Col15: '서류접수 및 추천>부적격자 조사 심사 및 선정>장학금 지급 및 수여식동장 추천 성적/ 재산소유현황/ 월 소득/ 광진구 거주기간/ 동주민센터 추천의견 등',
      Col16: '15명 ',
      Col17: '2021년 광진구 장학금 수혜자 2022년 다른 지자체/ 민간단체로 부터 장학금(학업장려금)을 받은 자 ',
      Col18: '동장 추천 ',
      Col19: '장학생 신청서 재학증명서2022년 1힉기 성적 증명서2021년 세목별 과세 증명서 주민등록 초본주민등록 등본건강보험납부확인서 개인정보제공 동의서  * 자세한 사항은 홈페이지 참조 '
    },
    {
      Col1: '서울특별시 광진구청',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '22학년도 1학기 평균평점 4.0이상',
      Col10: '해당없음',
      Col11: '2500000원',
      Col12: '추천일 현재 계속하여 1년 이상(주민등록 기준) 광진구에 주소를 두고 있는 학생 ',
      Col13: '추천일 현재 계속하여 1년이상(주민등록 기준) 광진구에 주소를 두고 있는 학생',
      Col14: '2022-08-22~2022-09-07',
      Col15: '서류 접수 및 추천>부적격자 조사 심사 및 선정>장학금 지급 및 수여식배점항목 성적/ 재산소유현황/ 월 소득/ 광진구 거주기간/ 동주민센터 추천의견 등',
      Col16: '8명',
      Col17: '2021년 광진구 장학금 수혜자 2022년 다른 지자체. 민간단체로부터 장학금(학업장려금)을 받은 자 ',
      Col18: '동장 추천 필요',
      Col19: '장학생 신청서재학증명서2022년 1학기 성적증명서2021년 세목별 과세증명서주민등록 초본 주민등록 등본건강보험납부확인서개인정보제공 동의서  * 자세한 내용은 첨부파일 참고'
    },
    {
      Col1: '재단법인 강서구장학회(서울)',
      Col2: '모범장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '평균 학점 B학점 이상(4.5점 만점 3.0이상/ 4.3만점 2.8점 이상)인 자',
      Col10: '해당없음',
      Col11: '최대 2000000원 (등록금) * 타 장학금 제외한 자부담 등록금 범위 내에서 지원',
      Col12: '품행이 단정하고 모범적인 대학교 재학생',
      Col13: '장학생 선발 공고일 현재 강서구에 1년 이상 계속 거주 * 주민등록표상 2021. 8. 1.까지 전입되어 있는 자',
      Col14: '2022-03-21~2022-04-08',
      Col15: '선발기준 : 소득> 성적> 자녀수',
      Col16: '23명',
      Col17: '국가 또는 지방자치단체/ 타 재단/ 학교 등으로부터 등록금 전액을 지원 받는 자강서구 관외 소재 학점은행제/ 방송통신대학/ 사이버(원격) 대학 재학생',
      Col18: '거주지 관할 동장 추천',
      Col19: '체크리스트장학생 신청서장학생 추천서개인정보 제공 동의서서약서자기소개서장학생 추천서 (거주지 관할 동장) 성적증명서주민등록등본부 또는 모 기준 가족관계증명서(일반)주민등록초본재학증명서2022년 2학기 등록금 납부 영수증전/월세 계약서 사본(자기가 아닌 경우에 한함)건강보험 자격확인서 및 건강보험료 납부확인서 각 1부 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 강서구장학회(서울)',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 2000000원',
      Col12: '수학/과학 / 체육 / 문화예술 / 기능 분야 전국 규모 이상의 대회에서 3위권 이내에 입상한 자 * 자세한 사항은 첨부파일 참고',
      Col13: '장학금 지급일 현재 강서구에 1년 이상 계속 거주',
      Col14: '2021-05-03~2021-05-14',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '국가 또는 지방자치단체/ 타 재단/ 학교 등으로부터 등록금 전액을 지원 받는 자강서구 관외 소재 학점은행제/ 방송통신대학/ 사이버(원격) 대학 재학생',
      Col18: '거주지 동장',
      Col19: '장학생 신청서장학생 추천서개인정보제공 동의서자기소개서건강보험료 납부확인서최근1년 성적증명서주민등록등본(동거인 포함)학생주민등록초본(주소변동 이력 포함)재학증명서 및 등록금 영수증 사본전/월세 계약서 사본(자기가 아닌 경우에 한함)특기장학생 신청자(특기를 증명하는 서류) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 강서구장학회(서울)',
      Col2: '소액장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '200000원',
      Col12: '한국장학재단에서 취급하는 일반상환학자금 대출을 받은 학생 중 타 기관으로부터 이자 지원을 받지 않은 강서구 거주 재학생(1회 제한)',
      Col13: '장학금 지급일 현재 강서구에 1년 이상 계속 거주',
      Col14: '2021-02-15~2021-02-26',
      Col15: '해당없음',
      Col16: '5명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '소액장학금 신청서개인정보제공 동의서서약서서건강보험료 납부확인서(부모의 건강보험증이 다를 경우 부모 각각의 건강보험자격확인서 및 건강보험료 납부확인서 제출)학생주민등록 초본(주소변동 이력 포함)대출입증 서류(일반상환학자금)재학증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 강서구장학회(서울)',
      Col2: '지역사회기여 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '최근 1년간 학업성적이 평균 B학점 이상/ 공고일 현재 남은 학기가 2학기 이상인 학생',
      Col10: '해당없음',
      Col11: '최대 1200000원 (시간당 1만원) * 월별 활동내역 확인 후 지급',
      Col12: '지역아동센터 등에서 소속 초/중/고 학생들의 학습/특기/예능 지도를 할 수 있는 학생최소 6개월 이상 성실히 활동 가능한 학생',
      Col13: '공고일 현재 강서구에 1년 이상 계속 거주(주민등록기준) 하고 있는 서울 및 인근 수도권 소재 대학교 재학생',
      Col14: '2021-09-13~2021-10-01',
      Col15: '1차 서류심사2차 면접심사',
      Col16: '20명이내',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '지역사회기여 장학생 지원 신청서자기소개서학생주민등록 초본(주소이력 포함)재학증명서성적증명서 (최근1년간) * 증빙서류의 주민등록번호 뒷자리를 반드시 삭제 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 강서구장학회(서울)',
      Col2: '행복장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '평점평균이 4.5만점에 2.5이상 (4.3만점에 2.3이상)단/ 복학생의 경우 휴학 직전 1학기 성적 기준',
      Col10: '코로나19 여파 등으로 가정 형편 어려워져 긴급하게 장학금 지원이 필요한 대학교 재학생',
      Col11: '최대 100만원',
      Col12: '품행이 단정하고 모범적이며 코로나19 여파 등으로 가정 형편 어려워져 긴급하게 장학금 지원이 필요한 대학교 재학생',
      Col13: '현재 강서구에 1년 이상 계속 거주',
      Col14: '2021-08-17~2021-09-03',
      Col15: '해당없음',
      Col16: '총 30명 내외외',
      Col17: '2021년 상반기 (재)강서구장학회 장학생으로 선발된 학생국가 또는 지자체/ 타 재단/ 학교 등으로부터 학비 전액을 지원 받는 대학생타 장학금을 제외한 자부담 등록금액이 50만원 이하인 대학생강서구 관외 소재 학점은행제/ 방송통신대학/ 사이버(원격0 대학 재학생',
      Col18: '거주지 동장 추천 (동 주민센터 담당직원에게 문의) → 동 주민센터 제출 또는 추천서를 받아 장학회 사무국에 제출',
      Col19: '체크리스트장학생 신청서장학생 추천서개인정보제공 동의서서약서자기소개서건강보험 자격확인서 및 건강보험료 납부확인서주민등록등본재학증명서2021년 1학기 성적증명서2021년 2학기 등록금 납부 영수증증'
    },
    {
      Col1: '서울특별시 성북구청',
      Col2: '저소득주민장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: ' * 아래 해당자국민기초생활보장법 상 수급자 또는 차상위계층서울형 기초생활보장 수급권자한부모가족지원 수급권자긴급복지지원법 제2조의 위기상황에 처하여 지원 받은 자 ',
      Col11: '최대 2000000원 (단 등록금을 초과하지 않는 범위)',
      Col12: ' * 성북구에 1년 이상 거주 중인 저소득 주민 자녀녀 또는 특기생소득기준 요건 중 하나 이상 해당자공공기관에서 주최한 이공계 분야와 예체능계 분야의 전국규모 이상 국내 경시대회와 국제대회에서 입상한 가정형편이 어려운 사람 중 해당학교장의 추천을 받은 자',
      Col13: '공고일 기준 성북구에 1년이상 거주하는 주민과 자녀',
      Col14: '2022-04-18~2022-05-13',
      Col15: '심사위원회에서 심의·의결하여 선발자 확정 후 개별통지',
      Col16: '20명 내외',
      Col17: '국가/ 지방자치단체/ 민간단체 등으로부터 전액 수혜받고 있는 자타기관으로부터 일부 수혜를 받고 있으며/ 본인 부담금이 50만원 미만인 자성북구 저소득 장학금 2천만원 이상 수혜받은 자고등교육법 제2조제5호 내지 7호에 해당하는 대학(방송통신대학/ 사이버대학/ 기술대학/ 각종학교)에 재학(입학)하는 사람',
      Col18: '해당없음',
      Col19: '저소득주민 장학계정자금 신청서저소득주민 장학계정자금 수혜대상 추천서저소득주민 장학계정자금 신청 서약서재학증명서등록금납입고지서 또는 영수증통장사본개인정보수집 이용및 제공조회 동의서'
    },
    {
      Col1: '서울특별시 성북구청',
      Col2: '고려대OpenCampus장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학신입생',
      Col8: '의약계열/자연계열',
      Col9: '해당없음',
      Col10: '가정형편이 어려운 자',
      Col11: '2년간(4학기) 등록금(입학금 포함) 전액 ',
      Col12: '성북구민의 자녀로서 2022학년도 고려대 안암캠퍼스에 입학한 자연계열* 신입생  * 세부 사항은 성북구청 홈페이지 공고 참고',
      Col13: '성북구민의 자녀부 또는 모가 성북구에 1년이상 거주(모집시작일일 기준) ',
      Col14: '2022-04-11~2022-04-24',
      Col15: '세부평점기준표 의거 선발심의위원회에서 심의 확정',
      Col16: '2명',
      Col17: '생명과학대학(식품자원경제학과/ 의대 제외)공과대학(반도체공학과 제외)보건과학대학(보건정책관리학부 제외)',
      Col18: '해당없음',
      Col19: '장학생 신청서 개인정보 수집·이용·제공 동의서자기소개서주민등록등본(모집시작일 기준 3개월이내 발급)등록금 납입증명서(또는 영수증 사본)한국장학재단 소득구간(분위)통지서국민건강보험증 사본 및 건강보험료 납부확인서전(월)세 계약서 사본 또는 무료임대확인서 * 세부 사항은 성북구청 게시판 참고'
    },
    {
      Col1: '서울특별시 성동구청',
      Col2: '저소득층장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학기 평점 B학점 이상장애학생은 직전 학기 평점 C학점 이상 ※ 2022년 입학학생은 학점 비대상 ',
      Col10: '국가장학금 지원대상자 중 기준 중위소득 72% (최저생계비 180%) 이내 저소득층',
      Col11: '최대 2000000원 이내',
      Col12: '전국 소재 2년제 이상 대학 재학중인 자 또는 사이버대/방통대에 재학 중인 24세 이하 중증장애인(1~3급)8학기 이내 신청자',
      Col13: '접수공고일을 기준으로 구에 주소를 두고 1년이상 거주한 구민의 자녀',
      Col14: '2022-04-11~2022-04-24',
      Col15: '지원자가 예산의 범위를 초과할 경우/ 가구원 수 대비 건강보험료 낮은 순으로 우선 선발 * 동순위일 경우 다자녀(3자녀이상)/ 한부모/ 장애인 가정 우선 선발',
      Col16: '해당없음',
      Col17: '추천일 현재 성동구 거주기간 1년 미만인 자국가 또는 지자체/ 학교/ 민간단체로 부터 학비 전액을 받는 자(단/ 근로장학금 및 무상교육 대상은 예외)',
      Col18: '주소지 관할 동장 추천',
      Col19: '동장추천서자기소개서개인정보제공동의서건강보험료 납부확인서(2022년 3월분)부·모 재산세과세증명서(2021년)재학증명서성적증명서(직전학기)주민등록등본 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '서울특별시 성동구청',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '제한없음/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 2000000원 이내',
      Col12: '2022년도 서울대 입학생/ 또는 전국 의대 입학생',
      Col13: '접수공고일을 기준으로 성동구에 주소를 두고 1년 이상 거주한 구민의 자녀',
      Col14: '2021-08-30~2021-09-10',
      Col15: '우선순위 없음(자격요건 해당자 전원 선발)',
      Col16: '해당없음',
      Col17: '추천일 현재 성동구 거주기간 1년 미만인 자국가 또는 지자체/ 학교/ 민간단체로 부터 학비 전액을 받는 자(단/ 근로장학금은 예외)',
      Col18: '주소지 관할 동 주민센터(동장 추천)',
      Col19: '학교장 혹은 동장 추천서자기소개서개인정보제공동의서재학증명서(필수)주민등록등본 * 자세한사항은 첨부파일 참고'
    },
    {
      Col1: '서울특별시 양천구청',
      Col2: '일반장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '2021년 2학기 한국장학재단 소득분위 4분위 (중위소득90%) 이내인 자 * 긴급 복지 지원 대상자 포함',
      Col11: '500000 ~ 1500000원',
      Col12: '2021년도 2학기 대학교 재학생으로 한국장학재단 소득분위 4분위 이내인 자',
      Col13: '공고일 기준 1년 이상 양천구에 거주하고 있는 대학생(주민등록기준)',
      Col14: '2022-05-02~2022-05-31',
      Col15: '중위소득(소득분위)/ 한부모/ 다자녀/ 양천구 거주기간 고려',
      Col16: '10명',
      Col17: '당해년도 국가 또는 타 지방자치단체/ 민간단체로부터 장학금을 받았거나 받을 예정인 자1가구 1명 선발한가지 분야 신청 가능 ',
      Col18: '주소지 관할 동주민센터의 동장 추천서 제출',
      Col19: '장학금 신청서 및 개인정보제공동의서동장 추천서학자금 중복지원방지 및 상환(반환) 서약서재학증명서소득구간(분위) 통지서등록금 납입영수증 * 주소지 관할 동주민센터로 접수'
    },
    {
      Col1: '부산광역시 기장군청',
      Col2: '기장군장학금(복지장학금)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '10학점 이상 이수하고 평점평균 2.5이상(단/ 졸업반은 이수학점 제한 없음)',
      Col10: '저소득층(생계·의료·주거·교육 수급자 및 차상위 계층에 한함) 자녀 또는 본인',
      Col11: '최대 2000000원',
      Col12: '저소득층(생계·의료·주거·교육 수급자 및 차상위 계층에 한함) 자녀 또는 본인으로서 성적기준을 충족한 대학 재학생',
      Col13: '공고일 기준/ 부모 또는 학생 본인이 주민등록상 연속하여 1년이상 부산시 기장군에 계속 거주하고 있는 자',
      Col14: '2022-05-02~2022-05-31',
      Col15: '기장군 장학기금 설치 및 운용 조례 제 17조 및 동법 시행규칙 제5조에 의거 실태조사 결과에 따라 산정한 득점순으로 선발',
      Col16: '15명',
      Col17: '방송통신대학 및 사이버대학/ 직업학교/ 학점은행제학교 등은 제외 2019~2021년 기간내 기장군 장학금을 받은 자2022년도 1학기 국가·지방자치단체/ 그 밖의 다른 기관으로부터 수업료 지원 등 장학금을 받은 자  * 수혜금액이 등록금액에 미달하는 경우 200만원 범위 내에서 차액을 지급(차액 20만원 미만일 시 선발제외)',
      Col18: '해당없음',
      Col19: '장학생 신청서(개인정보이용동의서 포함)재학증명서2021년 2학기 성적증명서2022년 1학기 교육비납입증명서2022년 1학기 장학금 수혜증명서부모 또는 본인의 통장사본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '부산광역시 기장군청',
      Col2: '기장군장학금(성적우수)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2021.2학기 평점평균 3.5이상이며 10학점 이상 이수한 대학생 ※ 졸업반 대학생만 직전학기 성적이 없는 경우 휴학당시 성적표 인정 / 졸업반은 이수학점 제한 없음',
      Col10: '해당없음',
      Col11: '등록금 실제 납부금액 (최대 2000000원)',
      Col12: '2021.2학기 평점평균 3.5이상이며 10학점 이상 이수한 대학생 ※ 졸업반 대학생만 직전학기 성적이 없는 경우 휴학당시 성적표 인정 / 졸업반은 이수학점 제한 없음',
      Col13: '공고일 기준/ 부모 또는 학생 본인이 주민등록상 연속하여 1년이상 기장군에 계속 거주하고 있는 자',
      Col14: '2022-05-02~2022-05-31',
      Col15: '기장군 장학기금 설치 및 운용 조례 제 17조 및 동법 시행규칙 제5조에 의거 실태조사 결과에 따라 산정한 득점순으로 선발',
      Col16: '87명',
      Col17: '방송통신대학 및 사이버대학/ 직업학교/ 학점은행제학교 등은 제외 2019~2021년 기간내 기장군 장학금을 받은 자2022년도 1학기 국가·지방자치단체/ 그 밖의 다른 기관으로부터 수업료 지원 등 장학금을 받은 자  * 수혜금액이 등록금액에 미달하는 경우 200만원 범위 내에서 차액을 지급(차액 20만원 미만일 시 선발제외)',
      Col18: '해당없음',
      Col19: '장학생 신청서(개인정보이용동의서 포함)재학증명서2021년 2학기 성적증명서2022년 1학기 교육비납입증명서2022년 1학기 장학금 수혜증명서부모 또는 본인의 통장사본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '부산광역시 기장군청',
      Col2: '기장군장학금(특기장학금)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 2000000원',
      Col12: '문화/ 예술/ 체육/ 과학/ 수학/ 영어/ 전산/ 기능 등 분야에서 시/도 단위 이상의 대회 및 경진대회에서 3위(단/ 전국대회 이상은 5위) 이상 입상한 학생 (2020/2021년도 수상) * 전국대회 또는 시·도단위 대회 : 대통령/ 국무총리/ 장관/ 시장/ 도지사/ 교육감 등이 주관·후원·협력하는 대회 ',
      Col13: '공고일 기준/ 부모 또는 학생 본인이 주민등록상 연속하여 1년이상 기장군에 계속 거주하고 있는 자',
      Col14: '2022-05-02~2022-05-31',
      Col15: '기장군 장학기금 설치 및 운용 조례 제 17조 및 동법 시행규칙 제5조에 의거 실태조사 결과에 따라 산정한 득점순으로 선발',
      Col16: '10명',
      Col17: '방송통신대학 및 사이버대학/ 직업학교/ 학점은행제학교 등은 제외 2019~2021년 기간내 기장군 장학금을 받은 자2022년도 1학기 국가·지방자치단체/ 그 밖의 다른 기관으로부터 수업료 지원 등 장학금을 받은 자  * 수혜금액이 등록금액에 미달하는 경우 200만원 범위 내에서 차액을 지급(차액 20만원 미만일 시 선발제외)',
      Col18: '해당없음',
      Col19: '장학생 신청서(개인정보이용동의서 포함)재학증명서2021년 2학기 성적증명서2022년 1학기 교육비납입증명서2022년 1학기 장학금 수혜증명서부모 또는 본인의 통장사본입상증명서 (상장/ 대회요강 등) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '부산광역시 기장군청',
      Col2: '기장군장학금(다자녀장학금)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 이수학점 10학점 이상 평점평균 2.5이상(단/ 졸업반은 이수학점 제한 없음)',
      Col10: '해당없음',
      Col11: '최대 2000000원',
      Col12: '셋째아이 이상이면서/ 만 28세 이하인 자(공고일 기준)로 성적자격기준을 충족하는 재학생',
      Col13: '공고일 기준/ 부모 또는 학생 본인이 주민등록상 연속하여 1년이상 기장군에 계속 거주하고 있는 자',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '기장군 장학기금 설치 및 운용 조례 제 17조 및 동법 시행규칙 제5조에 의거 실태조사 결과에 따라 산정한 득점순으로 선발',
      Col16: '15명',
      Col17: '방송통신대학 및 사이버대학/ 직업학교/ 학점은행제학교 등은 제외 2019~2021년 기간내 기장군 장학금을 받은 자2022년도 1학기 국가·지방자치단체/ 그 밖의 다른 기관으로부터 수업료 지원 등 장학금을 받은 자  * 수혜금액이 등록금액에 미달하는 경우 200만원 범위 내에서 차액을 지급(차액 20만원 미만일 시 선발제외)',
      Col18: '해당없음',
      Col19: '장학생 신청서(개인정보이용동의서 포함)재학증명서2021년 2학기 성적증명서2022년 1학기 교육비납입증명서2022년 1학기 장학금 수혜증명서부모 또는 본인의 통장사본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '부산광역시 부산진구청',
      Col2: '봉사·기능·예술·체육 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '봉사부문 대상 : 1000000원기능부문 대상 : 1000000원예술부문 대상 : 1000000원체육부문 대상 : 1000000원',
      Col12: '봉사 : 다양한 분야세서 봉사활동을 꾸준히 전개하고 있어 타의 모범이 되는 학생 * 2018. 03월 ~ 2019. 05월까지 수상자(↓)기능 : 전국 단위 기능 경디대회 분야 중 수상자예술 : 한국예술문화단체 총연합회 산하 가맹협회 10개 분야 수상 자.체육 : 대한체육회 가맹 경기단체 60개 분야 중 ',
      Col13: '세대주 (보호자)가 부산진구 관내에 주소를 두고 선발 공고일 현재 3년 이상 계속해서 거주하고 있는 구민의 자녀',
      Col14: '2022-08-29~2022-09-16',
      Col15: '해당없음',
      Col16: '각 부문 별 1명/ 총 4명',
      Col17: '해당없음',
      Col18: '각급 학교장청소년 관련 사회봉사단체종교단체 등',
      Col19: '신청서(붙임:소정양식)주민등록본재학증명서추천서(붙임 :  소정양식) * 봉사부문대상은 각 단체 등도 추천 가능하며 공적조서는 반드시 필요공적조서는 봉사부문 대상에 신청한 학생에 한함수상 등 증빙자료'
    },
    {
      Col1: '대구광역시청',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적우수자자직전학기 성적이 평균 70점 이상이거나 C학점 이상인 자',
      Col10: '2022년 가구별 기준중위소득 이하 * 첨부파일 참고',
      Col11: '대학생 최대 2000000원(타 장학금 수령액 공제) * 변동될 수 있음',
      Col12: '대학(교)에 재학 중인 학생 (대학 소재지는 상관 없음)',
      Col13: '공고일 현재대구시에 거주(주민등록 확인)',
      Col14: '2022-08-29~2022-09-16',
      Col15: '동점자 처리기준 : 성적이 우수한 자 > 재산·소득이 적은 자',
      Col16: '34명',
      Col17: '신청학기 타 장학금을 받아 학교 실 납부한 금액이 50만원 이하인 자공고일 현재 휴학생/ 학비면제자외국대학생정규학기 초과 재학생사이버대학/ 방송통신대/ 기능대/ 기술대/ 한국농수산대학/ 학점은행제 등 제외 * 자세한 사항은 첨부파일 참조',
      Col18: '구청장·군수의 추천으로 선발',
      Col19: '신청서/ 가정실태조사서/ 개인정보제공동의서통장사본재학증명서수업료 납부 확인서성적증명서2022년도 장학금 수혜(미수혜) 확인서자원봉사 실적확인서(해당자)기타 소득·재산 증빙서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '대구광역시청',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 평균 70점 이상이거나 C학점 이상인 자',
      Col10: ' * 소득인정액 2022년도 기준 기준중위소득 이하사회배려계층 : 한부모·장애인·다문화가족 및 조손가족',
      Col11: '최대 2000000원',
      Col12: '사회배려계층 : 한부모가구/ 장애인가족/ 다문화·조손가족자원봉사활동 우수자 : 자원봉사활동 30시간 이상(2022.1.1.~공고일 현재까지)',
      Col13: '공고일 현재 대구시에 거주(주민등록 확인)',
      Col14: '2022-08-29~2022-09-08',
      Col15: '경합 시 : 성적이 우수한 자 > 재산·소득이이 적은 자',
      Col16: ' * 총 12명사회적 배려계층 6명자원봉사활동 우수자 6명',
      Col17: '신청학기 타 장학금을 받아 학교 실 납부한 금액이 50만원 이하인 자공고일 현재 휴학생/ 학비면제자외국대학생정규학기 초과 재학생사이버대학/ 방송통신대/ 기능대/ 기술대/ 한국농수산대/ 학점은행제 등 제외 * 자세한 사항은 첨부파일 참조',
      Col18: '구청장·군수의 추천으로 선발',
      Col19: '신청서/ 가정실태조사서/ 개인정보제공동의서통장사본신청년도 장학금 수혜 확인서 및 서약서수업료 납부 확인서재학증명서성적증명서장학금 수혜(미수혜) 관련 서약서자원봉사 실적 확인서(해당자)기타 전·월세 계약서 등 소득·재산 증빙서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '대구광역시청',
      Col2: '중소기업근로자자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 직전학기 학업성적이 평균 70점 이상이거나 평균 C학점 이상인자',
      Col10: '전년도 도시근로자 가구당 월평균소득의 90% 이하 * 자세한 사항은 첨부파일 참고',
      Col11: '2500000원 이내',
      Col12: '공고일 기준 대구광역시에 주소를 두고 상시근로자 2인 이상의 관내 동일 사업체에서 2년 이상 재직하고 있는 상시근로자의 자녀로서 학업성적이 우수하고 품행이 단정한 자기업의 생산성 향상과 산업평화에 기여한 공로로 전년도 산업평화대상 수상자 및 유공자와 그 공로가 객관적으로 인정되고 시장 표창 이상을 받은 저소득 근로자의 자녀',
      Col13: '공고일 기준 대구광역시에 주소를 두고 있는 자 ',
      Col14: '2021-09-16~2021-10-29',
      Col15: '추천기관의 추천자 중에서 시에서 선발',
      Col16: '25명',
      Col17: '공고일 현재 퇴학/ 정학 처분자 및 휴학자/ 해외 유학생타 시/도에 재학  중인 고등학생 자녀기존 중소기업 근로자 자녀 장학생으로 선발된 자녀학교/ 기업체/ 기타 기 및 단체 등으로부터 당해연도에 장학금을 지급받았거나 학비감면을 받은 자 ',
      Col18: '해당없음',
      Col19: '장학금 지급 신청서학교장 확인서소속기업확인서서약서개인정보 제공 동의서재학증명서 및 성적증명서전년도 근로소득 원천징수 영수증주민등록등본전년도 지방세 세목별 과세증명서 통장사본  * 첨부파일 참고'
    },
    {
      Col1: '대구광역시청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '대출당시 소득분위 8분위 이하 또는 다자녀가구',
      Col11: '한국장학재단에서 대출받은 금액의 2021년도 발생이자 지원',
      Col12: '2015년 이후 한국장학재단으로부터 대출받은 일반 상환 및 취업 후 상환 학자금 대출을 받은 자',
      Col13: '신청공고일 현재 직계존속이나 학생 본인이 대구에 거주중인 자대구·경북소재 대학교 재(휴)학생 또는 2020년 이후 졸업생',
      Col14: '2021-10-12~2021-10-22',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원생',
      Col18: '해당없음',
      Col19: '이자지원신청서대학재학증명서/ 휴학증명서주민등록등본/ 가족관계증명서 * 접수방법대구시 홈페이지 첫 화면에 뜨는 배너를 클릭하여 신청서를 작성 후 제출(증명서 등 서류는 Email제출)'
    },
    {
      Col1: '대구광역시 중구청',
      Col2: '저소득주민자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '최근학기 성적이 70점 이상인 대학생 ',
      Col10: '국민기초수급자 및 법정 차상위계층층',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '대구광역시 중구 관내에 주소를 둔 자',
      Col14: '2022-02-03~2022-03-04',
      Col15: '수급자 및 저소득주민(차상위 포함)자녀 중 성적우수자 ',
      Col16: '4명',
      Col17: '재학기간 중 징계처분을 받은 학생휴학생',
      Col18: '해당없음',
      Col19: '저소득주민자녀 장학생 신청서'
    },
    {
      Col1: '인천광역시청',
      Col2: '대학생 학자금대출 이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '한국장학재단에서 산정하는 소득 10분위 중 8분위 이하에 해당 * 다자녀 가구 (3자녀 이상) 대학생은 소득제한 없음',
      Col11: '2019년 1학기부터 한국장학재단을 통해 대출받은 학자금의 2021년 상반기(1~6월) 발생이자 지원',
      Col12: '국내 대학교 재학·휴학·졸업생(졸업 후 2년 이내 미취업자)',
      Col13: '부모 또는 본인이 신청기준일 현재 1년 이상 인천광역시에 주민등록이 되어 있는 자',
      Col14: '2022-04-04~2022-04-22',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '주민등록초본 (* 최근 5년간 주소변동이력/ 전입일 포함)대학(교) 재학/휴학 증명서 또는 졸업 증명서가족관계증명서(다자녀가구 해당자)건강보험자격득실확인서(졸업생 해당자) * 공고일 이후 발급한 서류만 인정함 * 자세한 사항 첨부파일 참고 * 인천광역시청 홈페이지 회원 가입 후 온라인 신청'
    },
    {
      Col1: '계양구 인재양성장학재단',
      Col2: '학업우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학기 성적이 평점 4.0(4.5만점) 이상학기당 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '소득분위에 따라 장학금 지급 상한액 상이 * 자세한 내용은 첨부파일 참고',
      Col12: '대학교 재학생중 직전학기 성적이 평균 평점 4.5기준 4.0 이상인 2~4학년국내에 소재한 2~4년제 대학교에 재학중인 학생',
      Col13: '공고일 현재 본인 또는 학부모가 계양구에 1년이상 주민등록 주소지를 두고 거주하고 있는 대학교 재학생',
      Col14: '2021-10-12~2021-10-20',
      Col15: '생활정도 30% + 성적 60% + 장기거주 5% + 다자녀 5%',
      Col16: 'OO명',
      Col17: '학교로 부터 징계처분을 받았을 때/ 직전 학기 휴학하였을 때방송대학/ 통신대학/ 방송통신대학 및 사이버대학은 선발대상에서 제외실 납부한 등록금이 30만원 미만인 학생',
      Col18: '해당없음',
      Col19: '장학금 신청서개인(신용)정보 수집·이용·제공 및 조회 동의서신청인 서약서신청자의 주민등록등본신청자의 주민등록초본신청자 기준의 가족관계증명서재학증명서등록금 납부 내역서학자금지원 소득구간(분위)통지서성적증명서 * 자세한 사항은 첨부파일 참조 '
    },
    {
      Col1: '계양구 인재양성장학재단',
      Col2: '특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학기당 12학점 이상 이수자',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '최근 1년 이내 교육/ 문화/ 체육/ 예술/ IT분야 등 각종 시·도 규모이상 대회에서 3위이상 입상자인 대학교 재학생계양구의 명성을 떨칠 가능성이 많아 육성지원이 타당하다고 판단되는 특기 우수 장학생',
      Col13: '공고일 현재 본인 또는 학부모가 계양구에 1년이상 주민등록주소지를 두고 거주하는 군민',
      Col14: '2022-04-04~2022-04-22',
      Col15: '동점 발생 시 수상실적 > 소득 > 다자녀 > 거주기간',
      Col16: 'O명 이내 * 초·중·등학생 및 19세 이하 청소년 선발인원 포함 ',
      Col17: '방송대학/ 통신대학/ 방송통신대학 및 사이버 대학 제외직전학기 휴학생 제외(군 휴학 포함) * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보 수집·이용 제공조회 동의서주민등록등본신청자 또는 부모 주민등록초본부 또는 모 기준의 가족관계증명서재학증명서대회수상 실적서 교육/ 문화/ 체육/ 예술/ IT분야 등 각종 대회 수상실적 증명 또는 상장사본건강보험료 납부확인서건강보험자격확인서 * 자세한 사항은 첨부파일 확인'
    },
    {
      Col1: '계양구 인재양성장학재단',
      Col2: '드림장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 학업 성적이 평균 평점 3.0점 이상(4.5만점 기준)학기당 12학점 이상 이이수자',
      Col10: '소득분위 8분위 이내인 자',
      Col11: '최대 3000000원',
      Col12: '해당없음',
      Col13: '공고일 현재 본인 또는 학부모가 계양구에 1년이상 주민등록 주소지를 두고 거주하고 있는 대학교 재학생',
      Col14: '2021-09-06~2021-09-17',
      Col15: '생활정도 60% + 성적 30% + 장기거주 5% + 다자녀 5%',
      Col16: 'OO명',
      Col17: '방송대학/ 통신대학/ 방송통신대학 및 사이버 대학직전학기 휴학생 제외(군 휴학 포함) * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보 수집·이용 제공조회 동의서주민등록등본주민등록초본 신청자 기준의 가족관계증명서재학증명서등록금 납부 내역서학자금지원 소득구간(분위)통지서성적증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '부평구청',
      Col2: '저소득가정대학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '평점 3.0이상 (4.5만점기준)',
      Col10: '기초수급자법정 차상위 가정저소득 가정의 대학교 재학생 (저소득 기준 중위소득 100% 이하)',
      Col11: '1인당 1000000원',
      Col12: '해당없음',
      Col13: '부평구에 주민등록이 되어 있고/ 실제 거주하는 자',
      Col14: '2021-10-06~2021-11-24',
      Col15: '해당없음',
      Col16: '30명 (1가구당 1인)',
      Col17: '2013~2019년 기 지원자 사이버대학교/ 방송통신대학교/ 학점은행제 대학2021년 타 장학금 기 수령자 등등',
      Col18: '해당없음',
      Col19: '장학금신청서개인정보 동의서성적증명서재학증명서통장사본등본.초본'
    },
    {
      Col1: '광주광역시청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한국장학재단에서 대출받은 학자금의 21년도 하반기 발생 이자(2021년 7월 ~ 12월) * 예산 초과시 예산 범위 내에서 저소득 분위순으로 지원',
      Col12: '한국장학재단에서 취업후 상환 또는 일반상환 학자금대출을 받은 자로/ 광주광역시에 관내 대학생',
      Col13: ' * 아래 조건을 모두 충족하는 자공고일 현재 광주광역시에 주소를 두고 있는 자공고일 현재 광주광역시 소재 대학교 및 대학원 재학생 또는 휴학생',
      Col14: '2022-04-15~2022-05-13',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '한국장학재단 대출자료 추출 시 대출금 전액 상환자는 지원 제외졸업/ 수료자 제외 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '이자지원신청서주민등록초본(최근 5년간 주소이력 포함)(공고 일 이후 발급분) * 홈페이지 신청서 작성 후 우편/ 이메일/ 직접방문/ 팩스 등의 방법으로 초본 제출(주민번호 뒷자리 지우고 송부)'
    },
    {
      Col1: '대전인재육성장학재단',
      Col2: '희망장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체 학업성적이 100점 만점 기준 환산점수 70점인 대학생대1의 경우/ 고등학교 3학년 1/2학기 등급 기재된 과목들의 평균 내신등급이 1.00 ~ 6.99 이내인 학생',
      Col10: '국민기초생활보장법상 수급자 및 차상위계층(한부모 포함)의 자녀로서 면학장려를 위하여 장학금 지원이 필요하다고 학교총장이 추천한 대학생',
      Col11: '1500000원 (1인당) * 한국장학재단 학자금대출 원금상환 생활비 지원 성격)',
      Col12: '대한민국 국적 취득자한국장학재단으로부터 학자금대출(등록금/ 생활비)을 받은 국내 대학교 재학중인 대학생',
      Col13: '장학생 선발 공고일 기준 6개월 전부터 대전광역시에 주소를 두고 대전시에 소재한 대학교에 재학 중인 학생',
      Col14: '2021-09-17~2021-10-15',
      Col15: '평가기준: 전체 학업성적 60% + 가정형편 40%',
      Col16: '50명',
      Col17: '휴학생 및 수료생 제외초과학기 또는 직전학기 기준 12학점 미만 수강자학교에서 징계처분(사회봉사 15시간 이상)을 받은자본인포함 가족중 2022년 대전인재육성장학생이 있는 자',
      Col18: '학교의 장 추천',
      Col19: '지원신청서장학생 추천 및 타 장학금 수혜확인서개인정보 수집/이용/제공 및 조회 동의서주민등록등본 (2022.04.15일 이후 발급분만 유효/ 주민번호 뒷자리 가림)성적증명서경제상황 증빙(기초생활수급자/ 차상위 계층 등 해당자)본인 통장 사본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고 '
    },
    {
      Col1: '대전인재육성장학재단',
      Col2: '거주비지원장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원 (1인당)',
      Col12: '대전광역시 소재 대학교 재학생대전광역시에 주소를 두고 대전을 제외한 타 지역의 국내 대학교에 재학 중인 자가족 또는 본인 명의로 소속학교 인근 주소지에 거주계약 확인 가능한 학교의 장이 추천한 대학생',
      Col13: '선발공고일 기준 1년 이상 대전광역시에 주소를 둔 자 ',
      Col14: '2021-10-04~2021-10-29',
      Col15: '평가기준: 학자금 지원구간 60%/ 학업성적 40%선발공고/ 신청 및 접수적격검토 및 자격심사실질 검서 (선발심사위원회 심사)최종 선정대상자 선발선정결과 통보장학증서 수여 * 자세한 사항은 첨부파일 참고',
      Col16: '70명',
      Col17: '공고일 기준 휴학생 및 수료상태인 졸업예정자초과학기 또는 현재학기 기준 9학점 미만 수강자학교에서 징계처분을 받은 자원격대학/ 2년 미만 교육과정의 각종 학교/ 평생교육법에 의거 설립한 학교본인포함 가족 중 2021년 대전인재육성장학재단이 있는 자',
      Col18: '학교장',
      Col19: '거주비지원장학금 지원신청서장학생 추천 및 타 장학금 수혜확인서개인정보 수집·이용·제공 및 조회 동의서주민등록등본재학증명서/ 성적증명서학자금 지원구간 통지서경제상황 증빙부동산임대차계약서통장사본  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '대전인재육성장학재단',
      Col2: '외국인유학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점이 B 이상인 자현재학기 9학점 이상 수강자',
      Col10: '해당없음',
      Col11: '800000원',
      Col12: '대전시 소재 대학교의 정규학부과정에 재학 중인 외국인 유학생',
      Col13: '선발공고일 현재 대전시 소재 대학생',
      Col14: '기관 확인 필요',
      Col15: '평가기준: 직전학기 성적(50%) + TOPIK 성적(30%) + 추천서(20%)',
      Col16: ' * 총 20명',
      Col17: '2021학년도 1학기 전액장학금 수혜자정규학기 초과자재외한국인 휴학생 및 수료생',
      Col18: '소속 대학교 총장의 추천을 받은 자',
      Col19: '장학금 지원 신청서외국인유학생장학생 추천서개인정보 수집·이용·제공 및 조회 동의서토픽(TOPIK) 성적표 및 성적증명서본인 통장사본 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '울산광역시 울주군청',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2022년 1학기 성적기준 4.5만점 기준 3.5이상 * 최소 이수학점 12학점 이상/ 4년제 이상의 대학의 마지막 학년은 6학점 이상 이수 조건 (계절학기 제외)',
      Col10: '해당없음',
      Col11: '1인당 70만원',
      Col12: '국내 소재 정규대학(교) 재학생 ',
      Col13: '공고일(2022. 07. 21)기준으로 본인 또는 부모가 울산광역시 울주군에 현재까지 계속하여 1년 이상 거주  * 세대(가족)당 수혜자 수 제한 없음',
      Col14: '2022-08-08~2022-08-19',
      Col15: '동점자의 경우 부/모 또는 본인의 울주군 거주기간이 긴 순서로 선발4.5만점 외의 경우 4.5만점으로 환산하여 적용하며/ 환산 시 소수점 3째자리에서 반올림하여 소수점 2째 자라ㅣ까지 표기',
      Col16: '2/3년제 : 290명4년제 이상 : 681명',
      Col17: '정규대학 외의 학교에 재학중인 사람 (사이버대학/ 방송통신대 등)대학원 및 정규대학 교육과정을 초과하여 재학 중인 사람기간 내 신청서 및 구비서류 미제출한 자동일학년으로 본 장학금을 수령한 자공고일 현재 징계처분을 받은 사람2022년도 새울원자력본부 장학금 및 롯데장학금수혜자',
      Col18: '해당없음',
      Col19: ' * 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '울산광역시 울주군청',
      Col2: '복지장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '20221학기 성적기준 2.0이상 (4.5 만점기준)12학점 이상 이수자 (4년제 이상 대학의 마지막 학년은 계절학기 제외 6학점 이상 이수)',
      Col10: '기초수급자 차상위계층 한부모가족 중증장애인 * 중증장애인 : 학생본인이 1급~3급의 장애가 있는 경우',
      Col11: '1인당 150만원',
      Col12: '국내 소재 정규대학(교) 재학생 기초생활수급자/ 차상위계층/ 법정 한부모가족/ 장애인(해당 증명서 발급이 가능한 사람)',
      Col13: '공고일(2022.07.21)기준으로 본인 또는 부모가 울산광역시 울주군에 현재까지 계속하여 1년 이상 거주  * 세대(가족)당 수혜자 수 제한없음',
      Col14: '2021-12-20~2022-01-12',
      Col15: '동점자의 경우 부/모 또는 본인의 울주군 거주기간이 긴 순서로 선발4.5 만점으로 환산하여 적용',
      Col16: '80명',
      Col17: '정규대학 외의 학교에 재학중인 사람 (사이버대학/ 방송통신대 등)대학원 및 정규대학 교육과정을 초과하여 재학 중인 사람기간 내 신청서 및 구비서류 미제출한 자동일학년으로 본 장학금을 수령한 자공고일 현재 징계처분을 받은 사람2022년도 새울원자력본부 장학금 및 롯데장학금 수혜자',
      Col18: '해당없음',
      Col19: '* 자세한사항은 첨부자료 또는 울주군청 홈페이지 참고'
    },
    {
      Col1: '울산광역시 울주군청',
      Col2: '롯데 성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 3.2 이상 (4.5만점) / 3.0 이상 (4.3만점)누적 총 평점 3.5 이상 (4.5만점) / 3.1 이상 (4.3만점) * (군)휴학 등으로 직전학기 성적이 없을 경우 최종학기 성적 적용',
      Col10: '해당없음',
      Col11: '20221학기 등록금 전액 ( * 등록금 외 학생회비 등 제외)',
      Col12: '20221학기 재학 예정인 자타 장학금 수혜를 받지 않는 자 (근로장학금 제외) ',
      Col13: '울주군 출신 (부·모가 울주군에 2021. 12. 19. 이전부터 계속적으로 주민등록을두고 거주중인 자)',
      Col14: '2020-06-25~2020-07-30',
      Col15: '해당없음',
      Col16: '16명 ',
      Col17: '정규대학 외의 학교에 재학중인 자 (사이버대학 등)대학원 및 정규대학 교육과정을 초과 (9학기이상) 하여 재학중인 자기존 롯데장학금 2회이상 수혜자롯데장학생 선정 후 포기자타 장학금 이중수혜 확인 시 롯데장학금 반납 신입생',
      Col18: '해당없음',
      Col19: '전체학기 성적증명서부모기준 가족관계증명서주민등록등본신상기록 카드개인정보 동의서/서약서학생명의 통장사본수상실적 또는 자격증 사본(해당자) * 자세한 사항은 첨부파일 또는 울주군청 홈페이지 참고'
    },
    {
      Col1: '울산광역시 울주군청',
      Col2: '롯데 희망장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 또는 총 평점 3.0이상 * (군)휴학 등으로 직전학기 성적 없을 경우 최종학기성적 적용',
      Col10: '수급자 차상위 한부모가정 다문화가정 또는 한국장학재단 소득분위 8분위 이하 ',
      Col11: '20202학기 등록금 전액 ( * 등록금 외 학생회비 등 제외)',
      Col12: '20201학기 재학 예정인 자타 장학금 수혜를 받지 않는 자 (근로장학금 제외)',
      Col13: '울주군 출신 (부/모가 울주군에 2019. 12. 18일 이전부터 주민등록을 두고 거주중인 자)',
      Col14: '2022-04-18~2022-04-22',
      Col15: '해당없음',
      Col16: ' * 30명 (신규추천원칙 / 최대 2회수혜가능)성적우수장학생 : 15명 (4년제대학) 희망장학생 : 15명 (2년제 대학이상)',
      Col17: '정규대학 외에 학교에 재학중인 자 (사이버대학 등)대학원 및 정규대학 교육과정을 초과(9학기 이상)하여 재학중인 자기존 롯데장학금 2회 이상 수혜자롯데장학금 선정 후 포기자학기 중 휴학이나 자퇴 등 미 수료자 확인 시 롯데장학금 반납',
      Col18: '해당없음',
      Col19: '성적증명서 (전체학기)가족관계증명서 (부모기준)주민등록등본신상기록카드개인정보동의서 / 서약서학생명의 통장사본  * 수상실적/ 자격증 있을 시 사본 제출수급자/ 차상위/ 한부모가정/ 다문화가정 증명할 수 있는 서류/ 한국장학재단 소득 8분위 이하 중 해당서류 1개 제출 * 읍/면사무소 생활지원팀(맞춤형복지팀) 방문접수 * 본인 방문접수가 힘들시 가족 대리 방문접수 가능 * 자세한  사항은 첨부자료 또는 울주군청 홈페이지 참고'
    },
    {
      Col1: '경기도 동두천시청',
      Col2: '애향장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '해당없음',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/석사2학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생/ 관내 대학생 기준: 직전학년 평균 평점 3.0 이상이고 D또는 F학점이 없는 학생 (재학 중 또는 복학 예정인 자에 한함)신입생 : 직전학년 전과목 평균등급이 2등급 이내인 자. ',
      Col10: '해당없음',
      Col11: '전문대 : 2000000원/년일반대 : 3500000원/년',
      Col12: '신입생/재학생 : 관내 고등학교 졸업자다자녀 장학생 : 3자녀 이상 가구의 셋째아 이상인 신입생재능 장학생 : 최근 1년 이내에 광역자치단체 단위 이상의 공공기관이 주관하는 각종 대회에서 3위 이상 입상한 학생 또는 권위 있는 국제대회에 입상하거나 국가대표에 선발되는 등 지역의 명예를 드높인 학생생',
      Col13: '선발계획 공고일 현재 동두천시에 1년 이상 주소를 두고 계속 거주하는 학생',
      Col14: '2022-02-23~2022-03-18',
      Col15: '대학생 : 구비서류 지참 후 방문접수(동두천시 평생학습관)',
      Col16: '대학생 : 40명 (일반대생 30명/ 전문대생3명/ 예체능 및 관내 대학생 7명)',
      Col17: '위 선발기준에 적합하지 않은 학생2022년 1.2학기 등록금 전액을 국가/ 자치단체나 그 출연기관/ 학교 등으로 부터 지원(예정)받은 대학생 (성적 장학금 포함) 2022년 1학기 등록을 하지 않은 학생그 밖에 심의회에서 부적합하다고 판달될 경우',
      Col18: '해당없음',
      Col19: '장학생 신청서 및 개인정보이용동의서등록금 납입확인서 * 그 외 전형별 제출서류 첨부파일 참고'
    },
    {
      Col1: '경기도 가평군청',
      Col2: '으뜸장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생  군수가 지역핵심인재로 추천하여 대학에 입학 결정된 학생 * 재학생 : 직전 학년도 학업성적 평균평점 B+학점 이상',
      Col10: '해당없음',
      Col11: '1년 기준 3000000원 (년 2회/장학금의 최대 50%씩 지급)',
      Col12: '국내 대학(전문대학 포함)에 진학 또는 재학 중이거나 복학예정인 학생으로 학업성적이 우수하거나 가정환경이 어려운 학생군수가 지역핵심인재로 추천하여 대학에 입학 결정된 학생',
      Col13: '장학생 선발계획 공고일 현재 군 관내에 3년 이상 주소를 두고 계속 거주한 군민 또는 자녀관내 고등학교 졸업',
      Col14: '2022-02-23~2022-03-18',
      Col15: '학업성적 95점 + 재산상황 5점',
      Col16: '대학생 30명',
      Col17: '방송통신대학 및 사이버대학/ 직업학교/ 학점은행제 학교/ 전문학교는 제외 국가/ 지방자치단체/ 학교/ 그 밖의 다른 기관 으로부터 장학금을 받고 있는 학생은 신청 제외(단/ 타장학금액이 등록금액  보다 미달할 경우 신청가능)',
      Col18: '해당없음',
      Col19: '장학생 신청서 성적증명서복학(예정)증명서가족관계증명서(해당자)대학생의 경우 관내 학교(초/중/고 중 1개) 졸업증명서2022학년도 등록금 납부영수증 또는 고지서지방세 세목별 과세증명(부/모) 각 1부주민등록 등/초본(주소 이력 포함) 각 1부 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경기도 가평군청',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학년도 도단위 이상의 예능/체육/기능 및 문학 대회에서 3위 이내로 입상한 대학생',
      Col10: '해당없음',
      Col11: '1년 기준 3000000원 (연 2회/장학금의 최대 50%씩 지급)',
      Col12: '대학(전문대학 포함)에 진학 또는 재학 중이거나 복학예정인 학생으로 학업성적이 우수하거나 가정환경이 어려운 학생',
      Col13: '장학생 선발계획 공고일 현재 군 관내에 3년 이상 주소를 두고 계속 거주한 군민 또는 자녀관내 고등학교 졸업',
      Col14: '2022-02-23~2022-03-18',
      Col15: '입상성적 80점 + 학업성적 15점 + 재산상황 5점',
      Col16: '대학생 3명',
      Col17: '방송통신대학 및 사이버대학/ 직업학교/ 학점은행제 학교/ 전문학교는 제외 국가/ 지방자치단체/ 학교/ 그 밖의 다른 기관 으로부터 장학금을 받고 있는 학생은 신청 제외(단/ 타장학금액이 등록금액  보다 미달할 경우 신청가능)',
      Col18: '해당없음',
      Col19: '장학생신청서성적증명서복학(예정)증명서가족관계증명서(해당자)대학생의 경우 관내 학교(초/중/고 중 1개) 졸업증명서2022학년도 등록금 납부영수증 또는 고지서입상증명서지방세 세목별 과세증명(부/모) 각 1부주민등록 등/초본 (주소이력포함) 각 1부 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경기도 가평군청',
      Col2: '복지장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학생 : 직전 학년도 학업성적 평균 평점을 100점 만점으로 환산한 점수가 60점 이상인 학생',
      Col10: '기초생활보장법에 따른 수급권자와 차상위계층 소년소녀가정 한부모가정으로 책정되어 보호받고 있는 군민 또는 자녀',
      Col11: '1년 기준 3000000원 (연 2회/장학금의 최대 50%씩 지급)',
      Col12: '대학(전문대학 포함)에 진학 또는 재학 중이거나 복학예정인 학생으로 학업성적이 우수하거나 가정환경이 어려운 학생수급권자와 차상위계층/ 소년소녀가정/ 한부모가정으로 책정되어 보호 받고있는  군민 또는 자녀',
      Col13: '장학생 선발계획 공고일 현재 군 관내에 3년 이상 주소를 두고 계속 거주한 군민 또는 자녀관내 고등학교 졸업',
      Col14: '2022-02-28~2022-03-18',
      Col15: '보호대상 50점 + 학업성적 50점',
      Col16: '대학생 20명',
      Col17: '방송통신대학 및 사이버대학/ 직업학교/ 학점은행제 학교/ 전문학교는 제외 국가/ 지방자치단체/ 학교/ 그 밖의 다른 기관 으로부터 장학금을 받고 있는 학생은 신청 제외(단/ 타장학금액이 등록금액  보다 미달할 경우 신청가능)',
      Col18: '해당없음',
      Col19: '장학생신청서성적증명서복학(예정)증명서가족관계증명서(해당자)대학생의 경우 관내 학교(초/중/고 중 1개) 졸업증명서2021학년도 등록금 납부영수증 또는 고지서보호자대상자 증명서주민등록 등/초본 (주소이력포함) 각 1부 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경기도 가평군청',
      Col2: '환경장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학생 : 직전 학년도 학업성적 평균 평점을 100점 만점으로 환산한 점수가 70점 이상인 학생고등학교 : 직전 학년도 학업성적 평균 점수가 70점 이상인 학생',
      Col10: '해당없음',
      Col11: '1년 기준 3000000원 (연 2회/장학금의 최대 50%씩 지급)',
      Col12: '대학(전문대학 포함)에 진학 또는 재학 중이거나 복학예정인 학생으로 학업성적이 우수하거나 가정환경이 어려운 학생공고일 현재 상수원관리지역 내 토지 또는 건축물을 소유하거나 3년이상 주소를 두고 계속 거주한 군민 또는 그 자녀',
      Col13: '장학생 선발계획 공고일 현재 군 관내에 3년 이상 주소를 두고 계속 거주한 군민 또는 자녀관내 고등학교 졸업',
      Col14: '2020-08-03~2020-08-28',
      Col15: '상수원관리지역 거주(토지 및 건축물소유) 기간 50점 +학업성적 45점 + 재산상황 5점',
      Col16: '대학생 24명',
      Col17: '방송통신대학 및 사이버대학/ 직업학교/ 학점은행제 학교/ 전문학교는 제외 국가/ 지방자치단체/ 학교/ 그 밖의 다른 기관 으로부터 장학금을 받고 있는 학생은 신청 제외(단/ 타장학금액이 등록금액  보다 미달할 경우 신청가능)',
      Col18: '해당없음',
      Col19: '장학생신청서성적증명서복학(예정)증명서가족관계증명서(해당자)대학생의 경우 관내 학교(초/중/고 중 1개) 졸업증명서2022학년도 등록금 납부영수증 또는 고지서상수원관리지역 내 거주 도는 토지(건축물)를 소유하고 있음을 증명하는 서류지방세 세목별 과세증명(부/모) 각 1부주민등록 등/초본 (주소이력포함) 각 1부 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경기도 고양시청',
      Col2: '저소득주민 생활안정융자금 융자학자금대출',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '「국민기초생활 보장법」에 의한 수급자 및 같은 법 시행령 제3조2에 따른 차상위계층',
      Col11: '한도액 : 연 5000000원 (총 한도액 : 10000000원)이자 : 무이자(상환기간경과시 3%)상환방법 : 4년 거치 4년균등분할상환',
      Col12: '본인 및 직계비속에 대한 고등교육법 제2조에 따른 학교의 재학생 및 입학 예정자',
      Col13: '신청일 현재 초본상 고양시에 1년 이상 계속 거주한 자',
      Col14: '2021-02-01~2021-02-05',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '18세 미만인 자 70세 이상인 자채무불이행자(신용불량자)학점은행제 및 평생교육법에 의한 학교 재학생',
      Col18: '해당없음',
      Col19: '융자신청서상환계획서서약서신용정보조회서통장 사본 또는 보건복지행정 계좌번호 출력물(학생명의)등록금납입고지서 사본합격통지서(입학생) 또는 재학증명서(재학생)개인정보제공동의서한국장학재단 등 타기관 장학금 및 학자금 대출 신청 내역 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '경기도 고양시청',
      Col2: '저소득주민장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2020년 2학기 성적이 성적 3.8(B)이상2021년 1학기 복학생은 휴학 직전 학기 성적이 3.8(B)이상인 자',
      Col10: '국민기초생활보장수급자 법정차상위계층(저소득한부모가정 차상위자활 차상위장애인 등)',
      Col11: '1인당 1000000원 (상/하반기 2회지급)※학업생활지원 등의 목적으로 지급(중복수혜 가능)',
      Col12: '고등교육법 제2조에 따른 학교의 재학생',
      Col13: '고양시 관내에 1년 이상 거주자',
      Col14: '2022-07-11~2022-08-19',
      Col15: '대상 모집인원 초과시 성적우수 순으로 지급대상자 확정성적이 동점일 경우 관내 거주기간 순으로 지급대상자 확정거주기간이 동일할 경우 고연령자 순으로 지급대상자 확정기존에 저소득주민 장학생 수혜대상자는 제외',
      Col16: '10명',
      Col17: '기존 자활기금 저소득주민 장학금 수혜대상자',
      Col18: '해당없음',
      Col19: '장학생 신청서 1부 장학금 신청서 1부 수급자 또는 차상위증명서 1부주민등록원초본 1부장학금을 받고자 하는 학생의 성적증명서 1부휴학 증빙 서류 (복학생)학생 명의 통장 사본 1부'
    },
    {
      Col1: '경기도청',
      Col2: '경기도대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한국장학재단에서 2010년 2학기 이후 2022년 1학기 까지 대출받은 학자금(등록금생활비)의 2022년 상반기(1월~6월)동안 발생한 이자에 대해 지원',
      Col12: '해당없음',
      Col13: '본인 또는 직계존속 중 1명이 경기도에 주민등록상 2021.07.11 이전부터 현재까지 거주한 대학.대학원 재학(휴학)생/ 미취업 졸업 (수료)생',
      Col14: '2022-03-02~2022-03-18',
      Col15: '경기 민원 24에서 온라인 신청',
      Col16: '해당없음',
      Col17: '졸업생은 사업공고일 기준 건강보험 \'직장가입자\'인 경우 지원대상에서 제외 ',
      Col18: '해당없음',
      Col19: ' * 모든 구비서류는 반드시 주민등록번호 뒷자리 미표기로 표시하고 스캔 또는 휴대전화로 촬영 후 jpg/ pdf로 저장 후 제출!대학생/ 대학원생 : 주민등록초본/ 재학증명서졸업생/ 수료생 : 주민등록초본 및 건강보험 자격득실확인서/ 졸업증명서 * 자세한 사항은 홈페이지 게시판 참고'
    },
    {
      Col1: '재단법인 평택시 장학재단',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 1. 우수장학생대학 재학생/ 직전학기 평균성적 A이상대학 신입생은 수능 과목별 백분위 평균 80이상 또는 직전학기 과목별 등급 평균 3등급 이내 2. 희망장학생대학 재학생/ 직전학기 평균성적 C이상신입생은 수능 과목별 백분위 평균 70이상 또는 직전학기 평균 4등급 이내 3. 행복장학생대학 재학생/ 직전학기 평균성적 C이상신입생은 수능 과목별 백분위 평균70이상 또는 직전학기 평균 4등급 이내',
      Col10: '희망장학생 : 소득분위 3분위 이내',
      Col11: '1인 최대 4000000원2022년도 등록금 범위내 지급',
      Col12: '우수장학생 : 학업성적이 우수한 학생희망장학생 : 가정형편이 어려운 대학생행복장학생 : 세 자녀 이상 가구의 대학생',
      Col13: '공고일 기준 평택시에 주민등록을 두고 1년 이상 거주하고 있는 시민 또는 시민의 자녀로서 현재 재학중인 학생생',
      Col14: '2021-07-05~2021-08-06',
      Col15: '우수장학생 : 성적 100%희망장학생 : 소득 100%행복장학생 : 소득 80% + 성적 20% * 자세한 사항은 첨부파일 참고',
      Col16: '해당없음',
      Col17: '국가/ 지방자치단체/ 공공기관/ 학교 등으로부터 1학기 등록금 전액 수혜자원격대학과 학점은행제대학 재학생/ 교환학생/ 직업전문학교 재학생직전하기 취득학점이 12학점 이내인 학생2022년도 평택시 장학관 입소자이거나 입소 예정인 학생학자금 중복지원 방지제도에 따라 장학금 총액이 등록금을 초과하는자',
      Col18: '해당없음',
      Col19: '장학생 선발 신청서개인정보 수집이용제공 동의서주민등록표가족관계증명서교육비 납입 증명서 또는 등록금 고지서성적 증명서2022년도 학자금 지원구간통지서 * 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '성남시청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소득 8분위(한국장학재단의 홈페이지 고시기준) 이하',
      Col11: '한국장학재단에서 2010년 2학기 이후 2021년 1학기까지 대출받은 학자금의 2021년 상반기 동안 발생한 이자 지원',
      Col12: '대학 졸업(수료) 후 10년 / 대학원 졸업(수료) 후 4년까지 지원',
      Col13: '본인 또는 직계존속이 1년이상 성남시에 주민등록이 되어 있는 사람.',
      Col14: '2021-10-12~2021-10-29',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: ' * 지원제외대상 : 졸업생/ 대학원생/ 군복무자/ 일반학자금 대출자/ 경기도 대학생 학자금 대출이자 중복 지원자/ 한국장학재단 이외 학자금 대출자',
      Col18: '해당없음',
      Col19: '온라인신청 : 본인 또는 직계 존속 주민등록초본/ 재(휴)학 증명서우편/ 방문 : 지원 신청서/ 본인 또는 직계존속 주민등록초본/ 재(휴)학 증명서 * 직계존속 주민등록 초본 제출시 반드시 가족관계증명서 1부 추가 제출 *재(휴)증명성는 2021년 하반기 재(휴)학생임을 증명할 수 있어야함 * 홈페이지온라인 신청방법 : 성남시청 홈페이지 방문홈페이지바로가기시민참여온라인신청접수대학생 학자금대출이자 지원신청 * 우편 또는 방문신청(성남시 중원구 성남대로 997 성남시청 교육청소년과)'
    },
    {
      Col1: '수원시청',
      Col2: '대학생학자금대출이자이원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소득분위 8분위 이하 * 다자녀 가구(세자녀 이상) 학생은 소득분위에 관계없이 지원 가능  ',
      Col11: '2017년 이후 대출금의 2021년 상반기(1.1~6.30) 까지 발생한 이자 ',
      Col12: '한국장학재단에서 학자금 대출(등록금/ 생활비)을 받은 대학생',
      Col13: '공고일 현재 수원시에 주민등록이 되어 있는 대학 (재)휴학생',
      Col14: '2021-02-15~2021-03-25',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '졸업생/ 대학원생/ 타지자체 학자금 대출이자 중복지원자/ 대출완제자/ 중도상환 이자/ 2016년 이전의 학자금 대출이자는 제외',
      Col18: '해당없음',
      Col19: '학자금 대출이자 지원 신청서 (개인정보활용 및 제3자 제공동의서 포함)대학 재(휴)학 증명학생 본인 주민등록표 초본 (공고일 이후 발급받은 서류 제출)다자녀인경우/ 부 또는 모의 가족관계증명서(최근6개월 이내 발급받은 서류)'
    },
    {
      Col1: '(재)의정부시민장학회',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '제한없음',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생: 직전학년 평균학점이 C학점(2.0) 이상인 자신입생: 수능 성적 백분위 점수 합산평균 70점 이상 또는 내신 성적 고등학교 3학년 성적 상위 100분의 70 이내인 학생 ',
      Col10: '해당없음',
      Col11: '1000000원원',
      Col12: '코로나19로 인하여 급격한 소득감소로 경제난을 겪고 있는 소상공인의 자녀국내에 소재하는 학교에 재학 중이거나/ 입학한 학생으로서 분야별 선발기준에 적합한 학생 ',
      Col13: '공고일 기준 의정부시에 주민등록을 두고 1년 이상 거주한 시민 및 자녀',
      Col14: '2022-04-18~2022-04-29',
      Col15: '소득 50% + 성적 40% + 장애인/다자녀 5% + 봉사 5%',
      Col16: '600명',
      Col17: '원격 및 학점은행제/ 사이버대학/ 방송통신대/ 산업체/ 교환학생 제외 전문대생 제외 ',
      Col18: '해당없음',
      Col19: '장학생 선발신청서직전학년 성적증명서재학증명서주민등록초본2020년도 건강보험료납부내역서2020년도 자원봉사 활동확인서 (해당자만)장애인증 사본 (해당자만) ※ 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '경기도 연천군청',
      Col2: '향토장학생(우수장학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학년 성적이 평균 70점 이상인 학생  * 대학 신입생은 고등학교 최종학년 성적또는 수학능력시험 성적증명서 제출',
      Col10: '해당없음',
      Col11: '대학원생 2800000원전문대생 2600000원',
      Col12: ' 대학생(고등교육법 제 2조 제 1호~ 제 4호/ 제 7호의 대학/ 산업대학/ 교육대학/ 전문대학 등에 재학 중인 학생)',
      Col13: '공고일 현재 군 관내에 주소를 두고 1년 이상 거주하고 있는 군민 또는 그 자녀',
      Col14: '2022-04-18~2022-04-29',
      Col15: '해당없음',
      Col16: '대학생 20명전문대생 8명',
      Col17: '등록금 전액을 국가 등 자치단체/ 학교 등으로부터 장학금으로 받는 대학생원격대학생 및 교환학생 제외2022년도 경기푸른미래관(경기도장학관)/ 경기도 송파학사/ 연천군 장학관 입사생은 선발 제외2022년도 경기도민회 장학생은 선발 제외산업체 위탁교육생은 향토장학생에서 제외 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서주민등록 등본 또는 초본(1년간 주소이력포함)직전학년 성적이 기재된 성적증명서2022년도 1학기분 등록금 납부 영수증재학증명서(대학생/ 전문대생)2021년도 부·모 각각 건강보험료 납부 확인서학적부 또는 휴학증명서 (해당자) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경기도 연천군청',
      Col2: '향토장학생(일반장학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '가정형편이 어렵고 직전학년 성적이 평균 60점 이상인 학생 ',
      Col10: '가정형편이 어려운 학생',
      Col11: '대학생 2800000원 지급전문대생 2600000원 지급',
      Col12: ' 대학생(고등교육법 제 2조 제 1호~ 제 4호/ 제 7호의 대학/ 산업대학/ 교육대학/ 전문대학 등에 재학 중인 학생)',
      Col13: '공고일 현재 군 관내에 주소를 두고 1년 이상 거주하고 있는 군민 또는 그 자녀',
      Col14: '2022-04-18~2022-04-29',
      Col15: '일반 장학생은 생활정도 70%/ 학업성적(소수점 둘째자리) 20%/ 위원회 평가 10%를 합산한 점수로 선발 동점자는 자녀 수/ 보험료 납부액/ 타 장학금 수혜 정도 등 순으로 처리',
      Col16: '대학생 : 9명전문대생 : 3명',
      Col17: '등록금 전액을 국가 등 자치단체/ 학교 등으로부터 장학금으로 받는 대학생원격대학생 및 교환학생 제외2022년도 경기푸른미래관(경기도 장학관)/ 경기도 송파학사/ 연천군 장학관 입사생은 선발 제외2022년도 경기도민회 장학생은 선발 제외산업체 위탁교육생(고등교육법 제40조) 은 향토장학생에서 제외',
      Col18: '해당없음',
      Col19: '장학생 신청서(개인정보 수집/ 이용 동의서 포함)주민등록등본 또는 초본(1년간 주소이력포함)직전학년 성적이 기재된 성적증명서20221학기 등록금 납부영수증재학증명서(대학생/ 전문대생)2021년도 부·모 각각 건강보험료 납부 확인서학적부 또는 휴학증명서(해당자) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경기도 연천군청',
      Col2: '향토장학생(특기장학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 2800000원',
      Col12: '예·체능/ 과학·기술분야 등에 소질과 재능이 뛰어나 도 단위 이상 대회에서 입상한 경력이 있는 학생(2021년)',
      Col13: '공고일 현재 군 관내에 주소를 두고 1년 이상 거주하고 있는 군민 또는 그 자녀',
      Col14: '2022-04-18~2022-04-29',
      Col15: '특기 장학생은 위원회 심의로 선발동점자는 자녀 수/ 보험료 납부액/ 타 장학금 수혜 정도 등 순으로 처리 * 특기생 선발평가 기준은 첨부파일 참고',
      Col16: '대학생 1명',
      Col17: '등록금 전액을 국가 등 자치단체/ 학교 등으로부터 장학금으로 받는 대학생원격대학생 및 교환학생 제외2022년도 경기도 장학관(송파학사 포함)/ 연천군 장학관 입사생은 선발 제외2022년도 경기도민회 장학생은 선발 제외산업체 위탁교육생(고등교육법 제40조) 은 향토장학생에서 제외 * 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서(개인정보 수집/ 이용 동의서 포함)주민등록등본 또는 초본 (1년간 주소이력포함)2022년도 1학기분 등록금 납부 영수증재학증명서 (대학생/ 전문대생) (대학 신입생은 합격증명서)예능/ 체육대회 입상 상장 사본 * 자세한사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경기도 연천군청',
      Col2: '향토장학생(다자녀장학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학년 성적이 평균70점 이상인 학생',
      Col10: '해당없음',
      Col11: '전문대생 : 2600000원대학생 : 2800000원 (생활장학금)',
      Col12: '대학생(고등교육법 제 2조 제 1호~ 제 4호/ 제 7호의 대학/ 산업대학/ 교육대학/ 전문대학 등에 재학 중인 학생)다자녀가구의 셋째 이상의 대학생 자녀',
      Col13: '공고일 현재 군 관내에 주소를 두고 1년 이상 거주하고 있는 군민 또는 그 자녀',
      Col14: '2022-04-18~2022-04-29',
      Col15: '해당없음',
      Col16: '대학생 : 3명전문대생 : 1명 * 선발인원은 심의회에 따라 변경될 수 있음',
      Col17: '등록금 전액을 국가 등 자치단체/ 학교 등으로부터 장학금으로 받는 대학생원격대학생 및 교환학생 제외2022년도 경기도 장학관(송파학사 포함)/ 연천군 장학관 입사생은 선발 제외2022년도 경기도민회 장학생은 선발 제외산업체 위탁교육생(고등교육법 제40조) 은 향토장학생에서 제외 * 자세한 사항 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생신청서 (개인정보 수집/ 이용 동의서 포함)주민등록등본 또는 초본 (1년간 주소이력포함)직정학년 성적이 기재된 성적증명서2022년도 1학기분 등록금 납부영수증재학증명서2021년도 부·모 각각 건강보험료 납부확인서 (미납부자는 자격득실 확인서)부모 및 형제/ 자매가 기재된 가족관계증명서  (다자녀/ 주민등록분리자)학적부 또는 휴학증명서(해당자) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경기도 연천군청',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '관내 고등학교 졸업자로 국·내외 우수대학에 입학한 학생',
      Col13: '공고일 현재 군 관내에 주소를 두고 1년 이상 거주하고 있는 군민 또는 그 자녀',
      Col14: '2022-04-18~2022-04-29',
      Col15: '특별장학생은 학교장 추천인원 중 선발동점자는 자녀 수/ 보험료 납부액/ 타 장학금 수혜 정도 등 순으로 처리특별장학생 추천인원은 연천고 3명/ 전곡고 5명',
      Col16: '4명',
      Col17: '등록금 전액을 국가 등 자치단체/ 학교 등으로부터 장학금을 받는 대학생원격대학생 및 교환학생 제외 2022년도 경기푸른미래관(꼉기도장학관)/ 경기도 송파학사/ 연천군 장학관 입사생은 선발 제외2022년도 경기도민회 장학생은 선발 제외 * 자세한 사항은 첨부파일 참고',
      Col18: '관내 고등학교장 추천자만 해당',
      Col19: '장학생 신청서 (개인정보 수집/ 이용 동의서 포함)장학생 추천서주민등록등본 또는 초본 (1년간 주소이력포함)2022년도 1학기분 등록금 납부영수증재학증명서(대학신입생은 합격증명서)'
    },
    {
      Col1: '경기도 연천군청',
      Col2: '효행및선행장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 : 2800000원',
      Col12: '효행이나 선행으로 군 단위 이상 기관에서 표창을 받거나 언론 등에 보도된 학생',
      Col13: '공고일 현재 군 관내에 주소를 두고 1년 이상 거주하고 있는 군민 또는 그 자녀',
      Col14: '2022-09-26~2022-09-30',
      Col15: '효행장학생은 위원회 심의로 선발동점자는 자녀 수/ 보험료 납부액/ 타 장학금 수혜 정도 등 순으로 처리',
      Col16: '대학생 : 1명 * 선발인원은 심의회에 따라 변경될 수 있음',
      Col17: '등록금 전액을 국가 등 자치단체/ 학교 등으로부터 장학금으로 받는 대학생원격대학생 및 교환학생 제외2022년도 경기도 장학관(송파학사 포함)/ 연천군 장학관 입사생은 선발 제외2022년도 경기도민회 장학생은 선발 제외산업체 위탁교육생(고등교육법 제40조) 은 향토장학생에서 제외 * 자세한 사항 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학생 신청서 (개인정보 수집/ 이용 동의서 포함)주민등록등본 또는 초본 (1년간 주소이력포함)직전학기 성적이 기재된 성적증명서2022년도 1학기분 등록금 납부영수증재학증명서선행 및 효행 관련 상장 및 신문보도 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '재단법인 춘천시민장학복지재단',
      Col2: '애향장학생(통·리·반장자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평균학점이 B학점 이상',
      Col10: '해당없음',
      Col11: '최대 1000000원',
      Col12: '공고일 현재 이·통·반장으로 2년 이상 재직자의 자녀',
      Col13: '공고일 현재 주민등록 주소지가 1년 이상 춘천시에 등록된 시민 및 그 자녀로서 중/ 대학(교)에 재학 중인 학생',
      Col14: '2022-09-26~2022-09-30',
      Col15: '통리반장 경력 20% + 성적 30% + 생활수준 40% + 봉사 10%',
      Col16: '애향장학생(전체 40%) 선발인원의 30%',
      Col17: '2자녀 이상 가구가 모두 선발되었을 경우 1명만 지급납부금·등록금 등을 전액 면제받는 경우와 휴학생은 신청대상에서 제외등록금 납부액이 100만원 이하인 경우 실제 납부액만 지급정규학기를 초과하여 등록한 경우 지원 제한1인 1분야 지원제한 * 자세한 사항은 첨부파일 참조',
      Col18: '읍면동장의 추천서 제출',
      Col19: '장학금 지원 신청서 및 신청인 서약서장학금 수혜 여부 확인서 및 개인정보 수집·이용·제공 동의서장학금 지원대상자 추천서봉사활동 실적 증빙서류(택1)학생 주민등록초본(최근 5년 주소이력표시)가족관계증명서재학증명서등록금·수업료 납부고지서 또는 납부영수증성적증명서부·모의 건강보험료 납부 확인서 각 1부(최근 1년간)신청자의 보통예금계좌통리반장 재직증명서 * 자세한 사항은 첨부파일 참고 바랍니다. '
    },
    {
      Col1: '재단법인 춘천시민장학복지재단',
      Col2: '애향장학생(저소득본인/자녀(손))',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활보장법 제2조에 따른 기초생활수급자 차상위계층 한부모가족지원법 제5조 제5조의2에 따른 한부모 가족',
      Col11: '최대 1000000 원',
      Col12: '춘천시에 거주하는 대학교 재학생으로/ 기초생활수급자·차상위계층 또는 한부모가족지원법에 따른 한부모 가족의 자녀',
      Col13: '공고일 현재 주민등록 주소지가 1년 이상 춘천시에 등록된 시민 및 그 자녀로서 중/ 고등학교 및 대학(교)에 재학 중인 학생',
      Col14: '2022-09-26~2022-09-30',
      Col15: '성적 40% + 생활수준 50% + 봉사 10%',
      Col16: '애향장학금 선발인원(전체 선발인원 40%)의 50%',
      Col17: '2자녀 이상 가구가 모두 선발되었을 경우 1명만 지급납부금·등록금 등을 전액 면제받는 경우와 휴학생은 신청대상에서 제외등록금 납부액이 100만원 이하인 경우 실제 납부액만 지급정규학기를 초과하여 등록한 경우 지원 제한1인 1분야 지원제한 * 자세한 사항은 첨부파일 참조',
      Col18: '읍면동장의 추천서 제출',
      Col19: '장학금 지원 신청서 및 신청인 서약서장학금 수혜 여부 확인서 및 개인정보 수집·이용·제공 동의서장학금 지원대상자 추천서봉사활동 실적 증빙서류(택1)학생 주민등록초본(최근 5년 주소이력표시)가족관계증명서재학증명서등록금·수업료 납부고지서 또는 납부영수증성적증명서부·모의 건강보험료 납부 확인서 각 1부(최근 1년간)신청자의 보통예금계좌경제상황 증빙서류 (택1) * 자세한 사항은 첨부파일 참고 바랍니다. '
    },
    {
      Col1: '재단법인 춘천시민장학복지재단',
      Col2: '애향장학(유공자자녀또는본인)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평균학점이 B학점 이상',
      Col10: '해당없음',
      Col11: '최대 1000000 원',
      Col12: '시정유공자로 시장 또는 강원도지사와 중앙부처 장의 포상을 받은 후 공고일 현재1년이 경과하지 않은 본인 또는 자녀 * 시·도청 직원이 받는 모범직원 표창은 제외',
      Col13: '공고일 현재 주민등록 주소지가 1년 이상 춘천시에 등록된 시민 및 그 자녀로서 중/ 대학(교)에 재학 중인 학생',
      Col14: '2022-09-26~2022-09-30',
      Col15: '성적 40% + 생활수준 50% + 봉사 10%',
      Col16: '애향장학금 선발인원(전체선발인원의 40%)의 10%',
      Col17: '2자녀 이상 가구가 모두 선발되었을 경우 1명만 지급납부금·등록금 등을 전액 면제받는 경우와 휴학생은 신청대상에서 제외등록금 납부액이 100만원 이하인 경우 실제 납부액만 지급정규학기를 초과하여 등록한 경우 지원 제한1인 1분야 신청 제한 * 자세한 사항은 첨부파일 참조',
      Col18: '읍면동장의 추천서 제출',
      Col19: '장학금 지원 신청서 및 신청인 서약서장학금 수혜 여부 확인서 및 개인정보 수집·이용·제공 동의서장학금 지원대상자 추천서봉사활동 실적 증빙서류(택1)학생 주민등록초본(최근 5년 주소이력표시)가족관계증명서재학증명서등록금·수업료 납부고지서 또는 납부영수증성적증명서부·모의 건강보험료 납부 확인서 각 1부(최근 1년간)신청자의 보통예금계좌포상 증빙자료 * 자세한 사항은 첨부파일 참고 바랍니다. '
    },
    {
      Col1: '재단법인 춘천시민장학복지재단',
      Col2: '애향장학생(환경공원주변자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평균학점이 B학점 이상',
      Col10: '해당없음',
      Col11: '최대 1000000원',
      Col12: '환경공원 주변(혈동2리/ 팔미3리/ 증2리 거문간이) 거주자의 자녀 또는 본인',
      Col13: '공고일 현재 주민등록 주소지가 1년 이상 춘천시에 등록된 시민 및 그 자녀로서 중/ 대학(교)에 재학 중인 학생',
      Col14: '2022-03-21~2022-03-25',
      Col15: '성적 40% + 생활수준 50% + 봉사 10%',
      Col16: '애향장학금 선발인원(전체 40%)의 10%',
      Col17: '2자녀 이상 가구가 모두 선발되었을 경우 1명만 지급납부금·등록금 등을 전액 면제받는 경우와 휴학생은 신청대상에서 제외등록금 납부액이 100만원 이하인 경우 실제 납부액만 지급정규학기를 초과하여 등록한 경우 지원 제한분야간 중복지원 불가 * 자세한 사항은 첨부파일 참조',
      Col18: '읍면동장의 추천서 제출',
      Col19: '장학금 지원 신청서 및 신청인 서약서장학금 수혜 여부 확인서 및 개인정보 수집·이용·제공 동의서장학금 지원대상자 추천서봉사활동 실적 증빙서류(택1)학생 주민등록초본(최근 5년 주소이력표시)가족관계증명서재학증명서등록금·수업료 납부고지서 또는 납부영수증성적증명서부·모의 건강보험료 납부 확인서 각 1부(최근 1년간)신청자의 보통예금계좌 * 자세한 사항은 첨부파일 참고 바랍니다. '
    },
    {
      Col1: '강원도 춘천시청',
      Col2: '춘천시애향장학생(기타)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대상 지원자마다 상이하므로 첨부파일 확인바람성적우수장학금 대상 대학생 : 13학점 이상& A학점  ',
      Col10: '저소득자녀 ( 국민기초생활보장법 2조에 따른 기초생활수급자 차상위계층 및 한부모가족지원법에 따른 한부모가족)',
      Col11: '대학생 : 100만원',
      Col12: '근로청소년/ 이재민 본인 또는 이재민 자녀',
      Col13: '관내 1년 이상 거주',
      Col14: '2021-04-01~2021-04-23',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2자녀 이상 가구가 모두 선발되었을 경우 1명만 지급납부금. 등록금 등을 전액 면제받는 경우 신청대상에서 제외등록금 납부액이 100만원 이하인 경우 실제 납부액만 지급(대학생)정규학기를 초과하여 등록한 경우 지원 제한 직전학기 본 재단 장학생의 경우 지원불가 (저소득유형만 예외적으로 가능) /분야별 중복지원 불가 ',
      Col18: '해당없음',
      Col19: '1.접수처 : 해당 읍/면사무소/ 동 주민센터2. 제출서류춘천시 애향장학금 신청서 1부(별지1호 서식)  *사진 반명함 1매재학증명서 또는 입학증명서 1부성적증명서 1부       1. 재학생 : 前학기 성적증명서       2. 신입생 : 前학년 성적증명서등록금 납부고지서 또는 영수증 사본 1부부양의무자(부/ 모)의 2014년 재산세 납부증명서 또는 비과세증명서 1부통리반장 재직증명서(통리반장 자녀에 한함) 1부수급자 또는 차상위계층 증명(확인)서 1부   *국민기초생활 보장법에 따른 수급자/ 각 개별 지원법령에 따른 차상위계층시정유공자인 경우 상장 사본 1부환경공원주변 자녀 및 근로청소년의 경우 읍면동장 및 학교장 확인서 1부개인정보동의신청서 및 서약서 1부(별지2호 서식)통장사본 1부'
    },
    {
      Col1: '재단법인 철원장학회',
      Col2: '학력우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 서울대/ 연세대/ 고려대/ 서강대/ 성균관대/ 한양대/ 포항공대/ 카이스트/ 이화여대 또는 의예(학)과 [한의예(학)과/ 치의예(학)과 포함] 입학생재학생: 직전학년 평점평균이 3.0 이상인 자  ※ 지방캠퍼스 제외. 본교 입학생 및 재학생',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '부모와 본인이 선발공고일 현재 철원군에 1년 이상 주소를 두고 거주하는 자 중 성적기준을 충족하는 신입생 또는 재학생 ※ 대학생 본인은 주택 임대차 계약 등 주소변동의 필요성을 명백히 입증할 수 있는 경우 철원시 외 주소를 두어도 장학금 신청가능',
      Col13: '부·모(부·모 중 1인)와 본인이 선발공고일 현재 철원군에 1년 이상 주소를 두고 거주하고 있는 자관내 중학교 또는 고등학교를 졸업한 자',
      Col14: '2022-04-01~2022-05-13',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원생원격대학(사이버대학/ 방송통신대학)평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원받는 특수대학(경찰대/ 육·해·공군사관학교/3군사관학교/ 간호사관학교)',
      Col18: '해당없음',
      Col19: '신청서개인정보 수집·이용 및 제공·조회 동의서재학증명서부 또는 모의 가족관계증명서부모 중 1인과 본인의 주민등록초본(최근 5년 주소 변동사항 포함)관내 중학교 또는 고등학교 졸업증명서성적증명서 (직전학년) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 철원장학회',
      Col2: '대학생자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '첫째 : 1000000원둘째 : 1500000원셋째 : 2000000원넷째 : 3000000원 _ 다섯째 이상 : 4000000원 * 자세한 사항은 첨부파일 참고',
      Col12: '고등교육법 제2조에 따른 대학교 재학생출산 또는 입양으로 한명 이상 자녀를 양육하는 가정의 자녀 중 대학교 재학생',
      Col13: '부·모(부·모 중 1인)와 본인이 선발공고일 현재 철원군에 1년 이상 주소를 두고 거주하고 있는 자관내 중학교 또는 고등학교를 졸업한 자',
      Col14: '2022-04-01~2022-05-13',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원생원격대학(사이버대학/ 방송통신대학)평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원받는 특수대학(경찰대/ 육·해·공군사관학교/3군사관학교/ 간호사관학교)',
      Col18: '해당없음',
      Col19: '신청서개인정보 수집·이용 및 제공·조회 동의서재학증명서부 또는 모의 가족관계증명서부/모 중 1인 및 본인의 주민등록초본실질적인 보호자와 학생의 관계를 확인할 수 있는 서류학생이 관외주소자인 경우: 주택 임대차 계약서외국인의 경우: 부/모와 본인의 외국인등록 사실 증명 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 철원장학회',
      Col2: '저소득주민자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '생계급여수급자 의료급여수급자 주거급여수급자 교육급여수급자 및 저소득 차상위계층의 자녀 또는 본인으로 대학교 입학생 및 재학생',
      Col11: '3000000원',
      Col12: '지역요건을 충족하며 생계급여수급자/ 의료급여수급자/ 주거급여수급자/ 교육급여수급자 및 저소득 차상위계층의 자녀 또는 본인으로 대학교 입학생 및 재학생',
      Col13: '부·모(부·모 중 1인)와 본인이 선발공고일 현재 철원군에 1년 이상 주소를 두고 거주하고 있는 자관내 중학교 또는 고등학교를 졸업한 자',
      Col14: '2022-04-01~2022-05-13',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원생원격대학(사이버대학/ 방송통신대학)평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원받는 특수대학(경찰대/ 육·해·공군사관학교/3군사관학교/ 간호사관학교)',
      Col18: '해당없음',
      Col19: '신청서개인정보 수집·이용 및 제공·조회 동의서재학증명서부 또는 모의 가족관계증명서부모 중 1인과 본인의 주민등록초본(최근 5년 주소 변동사항 포함)관내 중학교 또는 고등학교 졸업증명서기초생활 수급자증명서 또는 차상위계층확인서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 철원장학회',
      Col2: '국가대표선발격려금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '예체능계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '국가대표 : 5000000원',
      Col12: '관내 초·중·고등학교 중 1개 이상 졸업한 자로서 국가대표로 발탁된 자 [국가대표/ 후보선수(상비군)/ 청소년/ 꿈나무]',
      Col13: '부·모(부·모 중 1인)와 본인이 선발공고일 현재 철원군에 1년 이상 주소를 두고 거주하고 있는 자관내 중학교 또는 고등학교를 졸업한 자',
      Col14: '2021-03-24~2021-04-07',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원생원격대학(사이버대학/ 방송통신대학)평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원받는 특수대학(경찰대/ 육·해·공군사관학교/3군사관학교/ 간호사관학교)',
      Col18: '해당없음',
      Col19: '신청서개인정보 수집·이용 및 제공·조회 동의서재학증명서부 또는 모의 가족관계증명서부모 중 1인과 본인의 주민등록초본(최근 5년 주소 변동사항 포함)국가대표 선발을 확인할 수 있는 서류관내 초·중·고 중 1개 학교 졸업증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '강원도 강릉시청',
      Col2: '학업성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '잔여 학기수가 2개이상인 자학기당 최소 15학점 이상 취득자(직전 두학기 기준) * 신입생 : 수능영역(국어/수학/탐구2과목)중 1등급 2개영역 이상 * 재학생 : 성적 4.2이상(4.5기준)',
      Col10: '해당없음',
      Col11: '다른 장학금과 중복지원 가능 (생활비 지원)',
      Col12: '해당없음',
      Col13: '강릉시 출신으로서 강릉시에 1년이상 주소를 두고 계속하여 거주하고 있는 사람강릉시에 10년 이상 주소를 두고 계속 거주하고 있는 부모(친권자)의 자녀',
      Col14: '2021-03-24~2021-04-07',
      Col15: '학업성적 85% + 거주기간 10% + 가정형편 5%',
      Col16: '8명재학생: 관내대학(4명)/ 관외대학(4명)',
      Col17: '1가구에 1명만 지원 가능부당 수령시 환수하고 다른 지역으로 전출 시 지원 중단',
      Col18: '해당없음',
      Col19: '인재육성기금 지원신청서재학증명서고등학교 졸업증명서직전 두 학기 성적증명서 (신입생은 수능성적표)자기소개서개인정보 제공 동의서가족관계증명서편부/모의 가정 : 가족관계등록부상의 혼인관계증명서(해당자만 제출)등본(보호자 중심 1부) (과거 주소변동 이력사항 전체 포함)초본(학생중심 1부) (과거 주소변동 이력사항 전체포함)건강보험납부확인서 또는 건강보험 자격득실확인서(2019년도분) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '강원도 강릉시청',
      Col2: '자립장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 대학수학능력시험의 응시영역별 3등급이 2개영역 이상재학생 : 직전 두 학기 학업성적이 4.5 기준에 3.0 이상인 사람 * 학기당 최소 15학점 이상 취득자(직전 두학기 기준) * 잔여 학기 수가 2개 학기 이상인자',
      Col10: '국민 기초생활수급자 및 저소득 차상위계층의 자녀 또는 본인',
      Col11: '지급금액 미기재 *다른 장학금과 중복지원 가능(생활비 지원)',
      Col12: '해당없음',
      Col13: '선발 공고일 현재 강릉시에 1년이상 주소를 두고 계속 거주하고 있는 자',
      Col14: '2021-03-24~2021-04-07',
      Col15: '가정형편50% + 학업성적30% + 거주기간20%',
      Col16: '총 6명관내 재학생 : 2명관외 재학생 : 2명신입생 : 2명',
      Col17: '1가구에 1명만 지원가능부당 수령시 환수하고 다른 지역으로 전출 시 지원 중단',
      Col18: '차상위계층 해당자는 읍ㆍ면ㆍ동장 지원 추천',
      Col19: '인재육성기금 지원신청서재학증명서고등학교 졸업증명서직전 두학기 성적증명서 (신입생인 경우 수능성적표)자기소개서개인정보 제공 동의서가족관계증명서편부/모의 가정 : 혼인관계증명서 (해당자제출)등본(보호자중심)1부 (과거 주소변동 이력사항 전체포함)초본(학생중심)1부 (과거 주소변동 이력사항 전체포함)국민기초생활수급자 증명서 차상위계층인 경우 증명서(기금지원 추천서) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '강원도 강릉시청',
      Col2: '특정분야우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '과학/ 수학/ 언어/ 예체능 등 특정분야 개인종목으로 전년도 도 단위 공인 대회에서 1위 또는 전국 단위 공인대회에서 3위 이내 입상한 사람',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '해당없음',
      Col13: '선발 공고일 현재 강릉시에 1년 이상 주소를 두고 계속 거주하고 있는 자',
      Col14: '2021-07-28~2021-08-28',
      Col15: '수상실적60% + 가정형편20% + 거주기간10% + 학업성적10%',
      Col16: '4명',
      Col17: '1가구에 1명만 지원 가능부당 수령 시 환수하고 다른 지역으로 전출 시 지원 중단',
      Col18: '해당없음',
      Col19: '인재육성기금 지원신청서재학증명서고등학교 졸업증명서직전 두 학기 성적증명서 (신입생은 수능성적표)자기소개서개인정보 제공 동의서가족관계증명서(학생)편부/모의 가정 : 가족관계등록부상의 혼인관계증명서 (해당자만 제출)등본(보호자중심) 1부 (과거주소변동 이력사항 전체포함)초본(학생중심) 1부 (과거주소변동 이력사항 전체포함)전년도 입상증명서건강보험납부확인서 또는 건강보험 자격득실확인서(2020년도분) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '강원도 강릉시청',
      Col2: '전입대학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '매년 25만원 지원 (학년별 1회)',
      Col12: '강릉으로 주소 이전한 타지역 출신 관내 대학교 재학생',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-02',
      Col15: ' 전입신고전입지원금신청재적 및 전입확인전입지원금 지급',
      Col16: '해당없음',
      Col17: '대학원생/ 외국유학생/ 휴학생(복학 시 재신청 요망)2020지급자는 재신청 불필요 ',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '경상남도 고성군청',
      Col2: '고성군체육진흥기금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '예체능계열',
      Col9: '대한체육회에 등록된 자로서 전년도 (2019년) 전국·도단위대회 이상 공인된 각종 경기에서 3위 이상 입상실적이 1회 이상인 전문체육 선수',
      Col10: '해당없음',
      Col11: '고성군체육진흥기금운용심의위원회에서 결정',
      Col12: '대한체육회 등록된 선수로서 2021년 전국도단위대회 이상 경기에서 3위 이상 입상실적 있는 자관내 전문체육 육성학교 선수',
      Col13: '주소지 또는 등록기준지를 고성군내로 둔 전문체육선수',
      Col14: '2021-10-20~2021-11-12',
      Col15: '점수 산출 방법 첨부파일 참고산출점수 동점일 시 상급학생 > 상위메달 다수자 순으로 선정',
      Col16: '고성군체육진흥기금운용심의위원회에서 결정',
      Col17: '고성향토장학생 및 농어촌청소년유망선수 장학금 지급대상자는 제외',
      Col18: '해당없음',
      Col19: '고성군체육진흥기금 장학금지급 신청서성적증명서주민등록등본 또는 기본증명서생활기록부대학체육회 가맹경기단체 등록선수 확인서통장사본*접수처 : 강원도 고성군청 경제체육과(체육진흥팀)'
    },
    {
      Col1: '강원도 홍천군청',
      Col2: '저소득주민자녀장학금 (일반)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '해당없음',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2021년 1학기 평균 평점 B 이상인 자 ',
      Col10: '[국민기초생활 보장법]에 의한 수급자로 기초생계 의료 주거 교육급여 중 하나 이상의 급여를 받는 자  ',
      Col11: '해당없음',
      Col12: '해당없음',
      Col13: '신청일 현재 부모 또는 자녀가 홍천군에 주소지를 두고 1년 이상 거주한 자 ',
      Col14: '2021-10-20~2021-11-12',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서장학생 추천서성적증명서재학증명서 '
    },
    {
      Col1: '강원도 홍천군청',
      Col2: '저소득주민자녀장학금 (특별)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2021년 1학기 성적이 평균 C+ 이상인 자 ',
      Col10: '[국민기초생활 보장법]에 의한 수급자로 기초생계 의료 주거 교육급여 중 하나 이상의 급여를 받는 자 ',
      Col11: '해당없음',
      Col12: '최근 1년이내 전국규모 예체능계 및 기능경연에서 3위이내 입상한 자 ',
      Col13: '신청일 현재 부모 또는 자녀가 홍천군에 주소지를 두고 1년 이상 거주한 사람 ',
      Col14: '2022-02-21~2022-03-18',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서장학생 추천서성적증명서재학증명서전국대회 입상증명 서류'
    },
    {
      Col1: '강원도 평창군청',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생내신점수 또는 수능성적 중 유리한 점수 선택내신점수: 고교 3학년 1학기 과목별 등급평균 6등급 이내수능성적: 국어/ 수학/ 영어/ 한국사 중 상위 1과목과 탐구영역 중 상위 1과목의 합이 12등급 이내* 재학생직전학기 평균평점이 4.5 만점 기준 2.0이상/ 4.3 만점 기준 1.8이상 * 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '등록금의 범위 내 (타 장학금 수령시 차액지원)',
      Col12: '해당없음',
      Col13: '대학교 재학생 및 신입생/ 강원도내 고등학교 재학생 및 신입생/ 평창군 관내 중학교 재학생공고일 현재 보호자가 3년 이상 계속해서 평창군에 주민등록을 두고 거주하고 있어야함',
      Col14: '2022-02-21~2022-03-18',
      Col15: '해당없음',
      Col16: '300명',
      Col17: '등록금 범위 내에서 타 장학금 외 차액지원평창장학회 장학금 내 중복 불가',
      Col18: '해당없음',
      Col19: '장학금 지원서가족관계 증명서본인/ 보호자 주민등록 초본개인정보 제공 및 수집 동의서장학금 수혜 (미수혜) 확인서재학증명서학비 납부 고지서재학생 : 직전학기 성적증명서신입생 : 고등학교 성적증명서 또는 수능성적 증명서 * 자세한 사항은 첨부파일 참고 '
    },
    {
      Col1: '강원도 평창군청',
      Col2: '자립장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생내신점수 또는 수능성적 중 유리한 점수 선택 * 재학생직전학기 평균평점이 4.5만점 기준 1.0이상/ 4.3만점 기준 0.8이상상',
      Col10: '보호자의 재산세(주택 건축물 토지) 세액 50000원이하인 자',
      Col11: '등록금의 범위 내 (타 장학금 수령시 차액지원)',
      Col12: '가정형편이 어려운 학생',
      Col13: '대학교 재학생 및 신입생공고일 현재 보호자 중 1인 이상(보호자가 없는 경우 본인)이 3년 이상 계속해서 평창군에 주민등록을 두고 거주하고 있어야 함',
      Col14: '2022-02-21~2022-03-04',
      Col15: '해당없음',
      Col16: '300명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 지원서가족관계 증명서본인/ 보호자 주민등록 초본개인정보 제공 및 수집 동의서장학금 수혜 (미수혜) 확인서재학증명서학비 납부 고지서재학생 : 직전학기 성적증명서신입생 : 고등학교 성적증명서 또는 수능성적 증명서'
    },
    {
      Col1: '강원도 영월군청',
      Col2: '이반장자녀장학금(성적우수자)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '4.5만점에 3.0이상신입생의 경우 고등학생 석차등급펑균 6등급 이내 * 계절학기 성적 포함/ P(pass)는 산출 시 제외',
      Col10: '해당없음',
      Col11: '대학생 연 1500000원',
      Col12: '영월군 내의 이/반장의 자녀 중 재학생 * 이/반장 1인 1자녀 지급',
      Col13: '영월군에 거주하고 있는 자의 자녀',
      Col14: '2022-02-21~2022-03-04',
      Col15: '성적기준에 의거 선정',
      Col16: '35명 (고등학생/ 특기생 선발자 수 모두 포함)',
      Col17: '타 장학금 수혜자는 납입금액 한도 내에서 지급',
      Col18: '해당없음',
      Col19: ' * 주소지 읍.면.동사무소에 문의 & 제출장학금 신청서성적증명서재학증명서공납금 영수증통장사본주민등록초본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '강원도 영월군청',
      Col2: '이반장자녀장학금(특기생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 연 1500000원',
      Col12: '최근 1년 이내에 기능/ 체육/ 예능 부문에서 도 단위 이상 대회에서 3위 이내에 입상한 자영월군 내의 이/반장의 자녀 중 재학생 * 이/반장 1인 1자녀 지급',
      Col13: '영월군에 거주하고 있는 자의 자녀',
      Col14: '2021-09-07~2021-09-24',
      Col15: '해당없음',
      Col16: '35명 내외외 (고등학생/ 성적우수자 선발자 수 모두 포함)',
      Col17: '타 장학금 수혜자는 납입금액 한도 내에서 지급',
      Col18: '읍면장',
      Col19: ' * 주소지 읍.면.동사무소로 제출&문의장학금 신청서재학증명서공납금 영수증특기생 증명할 수 있는 서류통장사본주민등록초본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '충청북도 충주시청',
      Col2: '장애인및자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 C학점이상인 자',
      Col10: '해당없음',
      Col11: '등록금과 타 장학금의 차액범위 내 지급',
      Col12: '공고일 현재 대학에 재학하고 있는 등록 장애인 또는 그의 자녀',
      Col13: '공고일 기준 현재 충주시에 주소를 둔 자',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '10명 내외',
      Col17: '당해연도 졸업반',
      Col18: '학교장 추천서 및 읍면동장 추천서 제출',
      Col19: '장학생신청서학교장 추천서읍면동장추천서직전학기 성적증명서재학증명서수급자증명서 / 한부모가족증명서 / 차상위증명서(해당자)통장사본직전학기 타 장학금 수혜 확인서 또는 등록금 납부확인서'
    },
    {
      Col1: '충청북도 청주시청',
      Col2: '저소득주민자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '고교졸업자(대학입학예정자)는 3학년 2학기 학업성적이 학년 상위 1%이내',
      Col10: '수급자자녀중 고등학교 3학년 학업성적이 우수한 학생의 대학(전문대학 포함) 입학생영세 농어민 자녀 : 경지면적 10000제곱미터 이하의 소유농가소형양어장(3300제곱미터 이하)경영자나 어로어업 종사가구그 밖의 저소득층 자녀 : 차상위계층',
      Col11: '1000000원',
      Col12: '고등학교 졸업한 대학(전문대)입학 예정자',
      Col13: '청주시(상당구/흥덕구/청원구/서원구)에 거주하고 있는 자의 자녀',
      Col14: '2022-02-08~2022-02-22',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '국가/ 지방자치단체 등 다른 기관으로부터 장학금을 받고있는 자',
      Col18: '해당없음',
      Col19: ' * 주소지 읍.면.동사무소로 제출&문의장학생신청서장학생추천서 (학교장직인날인)성적증명서(20182학기/. 대학입학생은 고등학교 3학년 2학기)대학입학 확인서(대학입학생에 한함)학생명의 통장사본'
    },
    {
      Col1: '재단법인괴산군민장학회',
      Col2: '명문대학교합격장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/의약계열/인문계열/자연계열',
      Col9: '직전학기 12학점 미만 수강 및 성적 백분위 환산 75점 이상',
      Col10: '해당없음',
      Col11: '관내고 졸업생 : 연 6000000원관외고 졸업 및 검정고시 합격생 : 1000000원 ~ 3000000원경찰대 육·해·공군사관학교 합격생 : 2000000원 ~ 5000000원',
      Col12: ' * 대상학교는 첨부파일 참고 *',
      Col13: '관내고 졸업생 : 장학생 선발 기간 동안 학생 또는 보호자가 관내 주소를 두고 있어야 함관외고/ 검정고시 졸업생 : 장학생 선발 기준 1년 이상 학생과 보호자가 모두 관내 주소를 두고 있어야 함 ',
      Col14: '2021-10-05~2021-11-19',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '휴학/ 제적/ 재입학 등 학적 변동 시 지급정지휴학 최대 7학기 제한/ 이후 휴학 시 장학생 자격 상실 ',
      Col18: '해당없음',
      Col19: '장학생 신청서서약서개인정보 수집·이용·제공동의서고등학교 졸업증명서대학교 1학기 등록금 납입증명서주민등록등본통장사본 '
    },
    {
      Col1: '충청남도 아산시청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2016년 2학기부터 한국장학재단에서 받은 학자금(든든학자금)의 대출이자',
      Col12: '2016년 2학기부터 한국장학재단에서취업후상환 대출을 받은 자 ',
      Col13: '공고일 현재 직계존속이 아산시 관내에 주민등록 주소를 1년이상 둔 전국대학생(단/ 직계 존속 사망 시 본인이 아산시에 1년 이상 주민등록이 되어 있는 학생)',
      Col14: '2022-01-13~2022-02-11',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '공고일 기준 현재 졸업생/ 대학원생',
      Col18: '해당없음',
      Col19: ' * 아산시청 홈페이지에서 온라인 신청 지원신청서 1부재학증명서본인 또는 직계존속의 주민등록초본 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 부여군굿뜨래장학회',
      Col2: '재능학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 2000000원',
      Col12: '예체능/ 과학/ 전산/ 수학 등 정부 또는 지방자치단체/ 각 분야 대표단체에서 개최하는 전국규모 이상의 대회에서 3위권에 입상한 자',
      Col13: '공고일 1년 전부터 부여군에 주소를 둔 군민 또는 군민의 자녀',
      Col14: '2022-01-13~2022-02-11',
      Col15: '입상성적을 포함한 선발심사 채점표에 의거 선발',
      Col16: '2명',
      Col17: '해당없음',
      Col18: '학교장 추천',
      Col19: '신청서와 추천서 및 증빙서류(입상 및 수상관련 서류)를 추천권자에게 제출'
    },
    {
      Col1: '재단법인 부여군굿뜨래장학회',
      Col2: '향토장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학3학기/대학4학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '관내 고등학교 졸업자 중 현재 한국전통문화대학교에 재학 (입학예정자 포함) 중인 학생 ',
      Col13: '본인 또는 부모(친권자포함)가 부여군에 1년 이상 주소를 두고 있는 자',
      Col14: '2022-08-31~2022-09-08',
      Col15: ' 경제적 여건 > 성적순 ',
      Col16: '2명',
      Col17: '해당없음',
      Col18: '한국전통문화대학교 총장',
      Col19: '성적증명서재학증명서주민등록등본장애인 증명서 등 * 별지의 신청서와 추천서 및 증빙서류를 추천권자에게 제출/ 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 천안사랑장학재단',
      Col2: '천안사랑장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '20221학기 12학점이상 취득자',
      Col10: '해당없음',
      Col11: '1800000원',
      Col12: '봉사부문 : 봉사시간 80시간 이상인 학생다문화 부문 : 다문화 가정의 학생다자녀 부문 : 자녀가 3인 이상인 가정의 학생새터민 부문 : 새터민 가정의 학생이거나 본인이 새터민인 학생',
      Col13: '공고일 현재 본인이나 부 또는 모/ 보호자가 천안시에 1년 이상 계속해서 주민등록을 두고 거주하는 국내 대학 재학생',
      Col14: '2022-08-31~2022-09-08',
      Col15: '1차 서류검토(천안시 거주여부/ 중복지원 여부 등)2차 이중수혜 확인3차 장학생 선발위원회4차 이사회 선발 확정 * 해당자격 50% +  생활정도(학자금지원구간) 30% + 성적 20% + 가산점(봉사시간)',
      Col16: '총 45명 * 봉사 15명/ 다문화 5명/ 다자녀 20명/ 새터민 5명',
      Col17: '재학 상태 아닌 경우 제외1세대 1명 신청 가능장학금별 중복 신청 불가',
      Col18: '해당없음',
      Col19: '천안사랑장학금 신청서주민등록 초본재학증명서222학기 장학금 (비)수혜 확인서222학기 등록금 고지서/납부확인서222학기 학자금 지원구간 통지서개인(신용)정보 수집·이용·제공 및 조회 동의서통장사본221학기 성적증명서봉사시간(가산점) 증빙서류 (해당자)가족관계증명서 (해당자)북한이탈주민 등록확인서(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 천안사랑장학재단',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점 4.5만점 기준 3.5(B+)이상인 학생12학점 이상 취득자 * 동점자 우선순위 학점>취득학점>고학년 순',
      Col10: '해당없음',
      Col11: '1800000원',
      Col12: '해당없음',
      Col13: '공고일 현재 본인이나 부 또는 모/ 보호자가 천안시에 1년 이상 계속해서 주민등록을 두고 거주하는 국내 대학 재학생',
      Col14: '2022-08-31~2022-09-08',
      Col15: '성적 80% + 생활정도 20%',
      Col16: '35명',
      Col17: '재학 상태 아닌 경우 제외1세대 1명 신청 가능장학금별 중복 신청 불가',
      Col18: '해당없음',
      Col19: '장학금 신청서 1부주민등록 초본재학증명서222학기 장학금 (비)수혜 확인서222학기 등록금 고지서/납부확인서222학기 학자금 지원구간 통지서개인(신용)정보 수집·이용·제공 및 조회 동의서통장사본221학기 성적증명서봉사시간(가산점) 증빙서류 (해당자) * 자세한 사항은 첨부파일 또는 홈페이지 게시판 참고'
    },
    {
      Col1: '재단법인 천안사랑장학재단',
      Col2: '재능장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '12학점 이상 취득자',
      Col10: '해당없음',
      Col11: '1800000원',
      Col12: ' 국제 및 전국 단위 및 도 단위 예·체능 대회 3위 이내 입상한 학생 * 20210801 ~ 20220731까지의 대회성적 * 자세한 사항은 첨부파일 참고',
      Col13: '공고일 현재 천안시에 1년 이상 계속해서 주민등록을 두고 있는 국내 대학에 재학중인 학생부/모가 천안에 1년 이상 주민등록을 두고 거주하는 국내 대학에 재학중인 학생',
      Col14: '2022-08-31~2022-09-08',
      Col15: '대회성적 80% + 생활정도 20%',
      Col16: '5명',
      Col17: '재학 상태 아닌 경우 제외1세대 1명 신청 가능장학금별 중복 신청 불가 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학금 신청서 1부주민등록 초본재학증명서222학기 장학금 (비)수혜 확인서222학기 등록금 고지서/납부확인서222학기 학자금 지원구간 통지서개인(신용)정보 수집·이용·제공 및 조회 동의서통장사본입상 관련 증빙 서류류봉사시간(가산점) 증빙서류 (해당자) * 자세한 사항은 첨부파일 또는 홈페이지 게시판 참고'
    },
    {
      Col1: '재단법인 천안사랑장학재단',
      Col2: '천안꿈장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점 4.5만점 기준 2.0(C+)이상/ 이수학점 12학점 이상 취득자 * 장애 학생의 경우/ 학점 기준 적용 안함',
      Col10: '해당없음',
      Col11: '1800000원 * 생활비 지원 명목의 장학금으로 중복 수혜 가능',
      Col12: '지역거주요건을 만족하는 저소득층 가정 또는 장애가 있는 학생',
      Col13: '공고일 현재 본인이나 부 또는 모/ 보호자가 천안시에 1년 이상 계속해서 주민등록을 두고 거주하는 국내 대학 재학생',
      Col14: '2021-10-04~2021-11-19',
      Col15: '생활정도 80% + 성적 20%',
      Col16: '35명',
      Col17: '재학 상태 아닌 경우 제외1세대 1명 신청 가능장학금별 중복 신청 불가',
      Col18: '해당없음',
      Col19: '장학금 신청서 1부주민등록 초본재학증명서222학기 학자금 지원구간 통지서개인(신용)정보 수집·이용·제공 및 조회 동의서통장사본221학기 성적증명서장애인증명서(해당자)봉사시간(가산점) 증빙서류 (해당자) * 자세한 사항은 첨부자료 또는 홈페이지 게시판 참고'
    },
    {
      Col1: '충청남도 당진시청',
      Col2: '학자금대출 이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소득분위 기준액이 8분위 이하인 학생 * 다자녀 가정 자녀의 경우 소득분위 관계없이 지원 가능',
      Col11: '한국장학재단에서 2016년 2학기 이후 대출받은 학자금의 21년도 발생이자 * 개인계좌로 지원되지 않음',
      Col12: '한국장학재단에서 2016년 2학기 이후 학자금 대출을 받은 자 (휴학생 포함)',
      Col13: '공고일 현재 본인 또는 직계존속이 당진시에 1년 이상 주민등록이 되어 있는 학생',
      Col14: '2020-10-12~2020-11-16',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '생활비 대출자 제외대학 졸업생/ 수료생/ 제적생/ 자퇴생 및 대학원생국가/ 지방자치단체/ 기업체 등 다른 기관으로부터 장학금 또는 학자금 이자 전액을 지원받고 있는 자 대출 전액 상환자',
      Col18: '해당없음',
      Col19: '신청서 및 개인정보관련 동의서재학 (휴학) 증명서주민등록초본가족관계증명서'
    },
    {
      Col1: '충청남도 예산군청',
      Col2: '대학 학자금 대출이자 지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2017년 이후 한국장학재단에서 대출받은 학자금(일반상환·취업후상환)의 2020년도 발생 대출이자 전액 * 지원기간 : 7년 (재학·졸업 : 5년 졸업 후 미취업 : 2년)',
      Col12: '공고일 기준/ 예산군에 주민등록이 되어 있고 국내 대학교 재학생 또는 졸업생(졸업 후 2년 이내 미취업자)으로서 한국 장학재단에서 학자금을 대출받은 청년',
      Col13: '공고일 기준/ 예산군에 주민등록이 되어 있는 자',
      Col14: '2022-05-16~2022-06-10',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '휴학생수료생자퇴생대학원생한국장학재단 대출정보 추출 시 대출 전액 상환 자타 장학금 또는 이장명목 중복수혜자 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '신청서개인정보제공동의서주민등록초본재학/졸업증명서졸업 후 2년 내 미취업자의 경우 건강보자격득실확인서(해당자) * 자세한 사항은 첨부파일 참조 '
    },
    {
      Col1: '부안군청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '장애인',
      Col6: '제한없음',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '부안지역 대학생',
      Col13: '부안군 학자금 대출 이자지원 공고일 현재 1년 전부터 부모 모두 연속하여 부안군에 주민등록이 되어 있는 사람부모의 사망 경우에는 학생 본인을 기준으로 1년 전부터 부안군에 주민등록이 되어 있는 사람',
      Col14: '2021-12-01~2021-12-10',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '생활비 대출 제외국가 및 다른 지방자치단체 등의 다른 기관에서부터 학자금 대출이자 명목으로 장학금 또는 학자금 대출이자 전액을 지원 받고 있는 경우 제외',
      Col18: '해당없음',
      Col19: '대학생 학자금 대출이자 지원 신청서동의서재학증명서가족관계증명서(부 또는 모)주민등록 초본(부모 모두 최근5년)'
    },
    {
      Col1: '(재)고창군장학재단',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적우수 : 직전 2개학기 (신입생의 경우 직전학기) 평점 평균 80점 이상인 자',
      Col10: '해당없음',
      Col11: '성적우수 : 1500000원특기/농생명식품 인재육성 : 심사후 확정',
      Col12: '성적우수특기(예·체·기능) : 국가/지방자치단체/공공기관/분야별협회가 주최·주관하는 도 대회 이상 대회 1~3위 이상 수상자(단체 포함)농생명식품 인재육성장학생 : 당해연도에 국가에서 인정한 농수산식품 분야 기능사 이상 자격증 취득자 / 관련분야 공인기관 주최 도단위 대회 1~3위 수상자',
      Col13: '공고일 기준 1년 전부터 본인 또는 보호자의 주민등록이 고창군으로 되어 있으면서 고창군 관내 학교의 재학생과 고창지역의 고등학교를 졸업한 대학생',
      Col14: '2022-05-09~2022-06-03',
      Col15: '심사기준은 첨부파일 참조',
      Col16: 'OO명',
      Col17: '휴학생 신청 불가사이버대학/ 폴리텍대학/ 방송통신대학 재학생1세대당 1명 선발 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보제공동의 및 활용승낙서주소확인 증빙서류 통장사본재학증명서건강보험 납부확인서 (성적우수)성적증명서 (성적우수)고등학교 졸업증명서 / 2학기 등록금 영수증 (성적우수)중복지원 방지 및 상환서약서 (성적우수)입상관련 자료 (특기)자격증 / 입상관련 자료 (농생명식품) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '전라북도 고창군청',
      Col2: '학자금대출 이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한국장학재단에서 받은 학자금 대출의 2022년도 이자발생분 * 개인별 입금조치 없음',
      Col12: '2017년 8월 1일 이후 한국장학재단에서 학자금 대출을 실행한 자',
      Col13: '대출 신청기준일 현재 부모가 2년이상 고창군에 주민등록이 되어 있는 사람부모의 사망의 경우 학생본인 또는 1명 이상의 직계존속이 2년 이상 고창군에 주민등록이 되어 있는 사람',
      Col14: '2022-06-02~2022-06-30',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '중복지원금지 * 국가/ 다른 지방자치단체/ 법인 등 다른 기관으로부터 학자금이자지원 시 지원제외 ※ 자세한 사항은 기관으로 문의',
      Col18: '해당없음',
      Col19: '지원 신청서개인정보 수집·이용 및 제3자 제공·조회 동의서재학(휴학)증명서부 또는 모의 주민등록초본본인과 부모의 관계 확인서류(주민등록등본 또는 가족관계증명서 등) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '군산시청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2016년 1학기 이후 대출금의 2022년 상반기 발생이자 지원',
      Col12: '한국장학재단으로부터 2016년 1학기 이후 학자금(생활비 제외) 대출을 받은 재학생(휴학생 포함) 중 대출 잔액이 있는 자',
      Col13: '군산시에 주민등록을 두고 있는 전국 대학생신청일 기준 관내 주민등록이 되어 있는 전국대학 재(휴)학생',
      Col14: '2021-10-27~2021-11-26',
      Col15: '심의위원회 심사를 통해 선발',
      Col16: '해당없음',
      Col17: '졸업생/ 대학원생/ 생활비 대출금 발생이자타 지자체 등으로 부터 동일 건에 대한 이자지원을 받고 있는 자한국장학재단에서 대출자료 추출 시 학자금 전액 상환자는 지원 불가',
      Col18: '해당없음',
      Col19: '신청서 1부재학증명서 1부신청인 주민등록등본 1부 * 온라인신청 : 군산시 홈페이지(http://www.gunsan.go.kr) * 온라인 신청시 구비서류의 주민등록번호 뒷자리를 보이지 않게 처리 후 스캔파일 업로드'
    },
    {
      Col1: '익산시청',
      Col2: '학자금 대출이자 지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2017년 1월 1일 이후 한국장학재단에서 대출받은 학자금의 이자지원범위 : 2021. 07.01~2021.12.31 일까지 발생이자',
      Col12: '익산시에 주민등록 주소를 둔 전국대학생 중 2017년부터 한국장학재단으로부터 학자금(등록금/ 생활비) 대출을 받은 학생',
      Col13: '공고일 현재 익산시에 주민등록 주소를 둔 전국 대학생   (전국 어느 대학에 다니든지 모두 지원 가능)',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '국가/ 지방자치단체/ 기업체 등 다른 기관으로부터 학자금 대출이자 명목으로 장학금 또는 학자금 이자 전액을 지원받고 있는 자익산시 외 지역으로 전출자고등교육기관에서 제적된 자한국장학재단 대출자료 추출시 대출 전액 상환자그 밖의 사유로 학자금 이자 지원이 부적정한 자휴학생/ 졸업생/ 대학원생 제외',
      Col18: '해당없음',
      Col19: '주민등록초본재학증명서 * 온라인 접수 (익산시 홈페이지 통합예약인터넷접수대학생 학자금 이자지원)'
    },
    {
      Col1: '진안군청',
      Col2: '관내이주용담댐수몰민자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 전체 5등급 이내',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '관내거주 수몰민 자녀 중 전문대이상대학생(신입생)',
      Col13: ' 보호자가 1991년 11월 16일 이전 수몰민으로 현재까지 진안군내에주소가 돼있으며 계속하여 거주※ 단 자녀 학교 입학으로 보호자(집계약)전출 후 6개월 이내 전입자',
      Col14: '2021-10-04~2021-11-19',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' ※ 주소지 읍.면사무소로 제출&문의주민등록 등초본 각 1통* 초본 : 관내이주 수몰민 확인(1991.11.16이전부터 2017.02.20현재까지 주소 모두 기재된 것)* 등본(또는 가족관계증명서) : 가족관계 확인용재학증명서 1통'
    },
    {
      Col1: '진안군청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '현재 재학 중인 대학교에서 대출받은 학자금 이자에 대하여 지원2016년∼2021년 2학기까지 대출받은 학자금의 이자발생액 전부',
      Col12: '진안지역 대학생',
      Col13: '학자금 대출 신청일 기준 부모가 2년 이상 진안군에 주민등록이 되어 있는 사람부모가 사망한 경우 학생 본인 또는 직계존속이 2년 이상 진안군에 주민등록이 되어 있는 사람',
      Col14: '2021-10-04~2021-11-19',
      Col15: '방문접수수',
      Col16: '해당없음',
      Col17: '대학원생/ 대학졸업/ 수료/ 제적 등국가/ 다른 지방자치단체/ 법인 등 다른 기관으로부터 학자금 이자 지원을 받고 있는 사람은 지원 대상에서 제외',
      Col18: '해당없음',
      Col19: '이자지원 신청서주민등록초본(부또는모)재학증명서개인정보 활용 동의서가족관계증명서 * 주민등록 소재지 읍·면사무소로 제출'
    },
    {
      Col1: '정읍시청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1학기 : 2021. 1. 1 ~ 6. 30일까지 발생이자2학기 : 2021. 7. 1 ~12. 31일까지 발생이자',
      Col12: '한국장학재단에서 2017년부터 대학생 학자금 대출을 받은 자 (휴학생 포함)',
      Col13: '신청일 기준 현재 정읍시에 주소지를 둔 대학생',
      Col14: '2022-06-24~2022-06-30',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '생활비 대출자 제외대학원생 및 졸업생 제외국가/ 지방자치단체/ 기업체 등 다른 기관으로부터 학자금 이자지원을 받고 있는 대학생정읍시 외 지역으로 전출자고등교육기관에서 제적된 자',
      Col18: '해당없음',
      Col19: ' * 교육체육청소년과 방문/ 이메일/ 우편접수학자금대출 이자지원 신청서개인정보제공활용동의서재학증명서 (또는 휴학증명서주민등록등본(신청일 이후에 발급분) '
    },
    {
      Col1: '전라북도 장수군청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '이자액 전액지원 * 지원기간: 대상자로 확정된 해당 학기(예산의 범위 내)',
      Col12: '2012. 1. 1일 이후 한국장학재단 학자금 대출 계정의 일반 상환 학자금/ 취업후 상환 학자금대출(등록금)을 받은 자 중 2019년 현재 학자금 대출 잔액이 있는 자  * 자세한 사항은 첨부파일 참고',
      Col13: '학자금 대출 신청공고일 현재 2년 이상 부모 중 1인 또는 학생이 전라북도 장수군에 주소를 둔 자',
      Col14: '2022-07-01~2022-08-31',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '지원대상 대학생과 부모 모두 타 시군으로 전출한 경우지원대상자로 확정된 후 주소 변경 등으로 그 요건을 상실한 경우고등교육기관에서 제적된 경우허위사실 또는 중복으로 지원받은 경우대학휴학 기간 동안은 이자지원 제외(재학중 군 입대기간은 이자지원)',
      Col18: '해당없음',
      Col19: ' [방문신청]2022년 대학생 학자금(등록금) 대출이자 지원 신청서개인(신용)정보 수집·이용 및 제공·조회 동의서주민등록등본(2년 이상 거주 확인) [온라인신청]주민등록등본 스캔 첨부 (반드시 주민번호 뒷자리 미표시로 발급) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '무주군장학재단(무주군청)',
      Col2: '학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2017년부터 한국장학재단에서 받은 학자금(등록금) 대출의 22년도 상상반기 발생이자 전액지원 * 취업 후 상환학자금 및 일반상환 학자금',
      Col12: '한국장학재단에서 학자금 대출을 받은 대학생',
      Col13: '공고일 기준 부 또는 모가 2년 이상 무주군에 주민등록이 되어 있는 대학생. 다만 부모가 모두 사망한 경우 학생 본인을 기준으로 2년 이상 무주군에 주민등록이 되어 있는 대학생',
      Col14: '2021-10-04~2021-11-19',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '국가/ 다른 지자체/ 법인 등 다른 기관으로부터 학자금 이자지원을 받고 있는 사람은 지원 대상에서 제외휴학기간(군복무로 인한 휴학기간은 제외)이 6학기를 초과하지 않은 대학생대학원생 제외',
      Col18: '해당없음',
      Col19: '신청서개인정보 수집·이용 및 제공/ 동의서주민등록등본(학생과 부모 주소가 다를 때 가족관계증명서)재학증명서 '
    },
    {
      Col1: '전라북도 남원시청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2021년 2학기 학자금 대출 이자 발생액',
      Col12: ' 2017년(1/2학기)부터 한국장학재단에서 학자금(등록금)을 대출 받은 대학 재학생 또는 복학예정자',
      Col13: '공고일 현재 부모 또는 본인이 남원시에 주민등록 되어 있는 전국 소재 대학 재학생',
      Col14: '2021-10-25~2021-11-19',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '휴학생/ 졸업생/ 대학원생 제외',
      Col18: '해당없음',
      Col19: '신청서재학증명서주민등록본개인정보 활용동의서 * 남원시청 홈페이지 접속 후 온라인 신청 혹은 남원시청 4층 교육체육과로 서류 제출/ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '전라북도 순창군청',
      Col2: '학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2012년 1학기 이후 대출금의 2021년 하반기 발생이자   (2021.7.1~2021.12.31까지 발생한 이자액)',
      Col12: '2012.1.1 이후 한국장학재단에서 학자금 대출을 받고 재학중인 대학생',
      Col13: '본인 또는 부모 중 한명이 대출신청기준일 기준 순창군에 주민등록되어 있는 대학생',
      Col14: '2022-06-02~2022-06-30',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '휴학생/ 졸업자/ 대학원생 제외',
      Col18: '해당없음',
      Col19: '신청서학생/ 부 또는 모 중 한명의 주민등록등본학생 기준의 가족관계증명서 (학생과 부모의 주소가 같지 않은 경우 해당자)신청인의 재학증명서개인정보 수집·이용 및 제공·조회 동의서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '전라북도 완주군청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2022년 1월 ~ 6월까지 발생한 이자 전액',
      Col12: '2015년 이후 한국장학재단을 통해 대출을 받은 취업후·일반상환학자금(등록금)을 지원받은 자대학에 재학중인 학생',
      Col13: '이자지원 신청일 기준 부모가 1년이상 완주군에 주민등록이 되어 있는 사람(부모 사망시 본인)',
      Col14: '2021-03-02~2021-04-02',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '다른 기관·재단·단체·개인으로부터 학자금 대출 이자 명목으로 장학금 또는 학자금 대출 이자전액을 지원받고 있는 대학생휴학생/ 졸업생/ 대학원생 제외',
      Col18: '해당없음',
      Col19: '신청서개인정보활용동의서 2부(본인/ 부모)부모님개인정보동의서(필요시) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '전라남도 곡성군청',
      Col2: '장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' *신입생정시입학생은 2021학년도 대학수능시험 결과 3등급이상 영역이 2개 이상인 자수시입학생은 고등학교 3학년 성적이 백분율 환산 평균 60점 이상인 자 *재학생직전학년 평균성적 B 학점 이상인자',
      Col10: '해당없음',
      Col11: '성적우수 장학금 : 대학생 2000000원',
      Col12: '국내에 소재하고 있는 대학교에 신입생 또는 재학생',
      Col13: '곡성군 관내에 부모(친권자)와 학생이 공고일 현재 계속해서 1년이상 곡성군에 주민등록을 두고 있는 군민 * 기숙사에 한해 타 주소 인정',
      Col14: '2021-02-24~2021-03-12',
      Col15: '대학생 성적우수 : 성적평가 70%/ 소득평가 30%입학생  *정시고등학교 3학년 성적(10%) + 대학수능시험성적(60%) + 소득평가(30%)  *수시고등학교 3학년 성적(70%)+ 소득평가(30%)재학생 : 직전 학년 1학기 성적(35%)+ 직전 학년 2학기성적(35%)+ 소득평가(30%)',
      Col16: '43명',
      Col17: '타 기관 및 장학재단/ 또는 학교에서 장학금을 수령하여 실제 납부해야 할 등록금 총액이 20만원 미만인 대학생(미래인재 제외)친권자(부모)가 직장으로부터 학비를 지원 받는 경우장학금 종류별 중복 및 1가정 2인 신청자/ 대학원생국가로부터 등록금과 수업료가 면제되거나 전액을 지원받는 육/해/공사관학교/ 간호사관학교/ 경찰대학',
      Col18: '읍면장 추천',
      Col19: ' * 공통제출서류장학생 지원신청 및 추천서 주민등록등본가족관계증명서재학증명서등록금(교육비) 납입증명서직장자녀 교육비 미수급 확인서건강보험료 납부 확인서신청인 서약서개인정보 수집 이용 및 제공 조회 동의서통장사본 * 신입생대학수능시험 성적표(정시)학교 생활기록부 * 재학생직전학년 성적증명서(1/2학기)  * 자세한 사항은 첨부자료 확인 필수'
    },
    {
      Col1: '전라남도 곡성군청',
      Col2: '이장자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원원',
      Col12: '이장 자녀 중 대학교에 입학 또는 재학중인 자 ',
      Col13: '곡성군의 이장자녀 ',
      Col14: '2021-10-18~2021-11-05',
      Col15: '학업성적 50% + 이장 경력 40% + 이장 상훈 10% * 가산점 항목 : 수급자 여부 / 다자녀 가구',
      Col16: '10명',
      Col17: ' * 지급정지 *이장에서 해임된 때장학생이 퇴학/ 정학 또는 휴학처분을 받았을 때장학생 자격 미달자대학총장 등의 지급 정지 신청이 있는 경우타 장학금과 중복하여 지급 받은 경우기타 군수가 정하는 사유에 해당하게 된 경우  * 선발제외 *실제 납부해야 할 등록금 총액이 20만원 미만',
      Col18: '해당없음',
      Col19: '장학생신청서재학증명서성적증명서가족관계증명서주민등록등본장학금지급통장사본개인정보 수집이용 및 제공조회 동의서신청인 서약서수급자 여부 증명서류 (해당자)'
    },
    {
      Col1: '전라남도 광양시청',
      Col2: '학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2016년 이후 한국장학재단에서 대출받은 학자금의 2021년도 발생한 본인부담 이자',
      Col12: '한국장학재단에서 2016년 이후 학자금 대출을 받은 대학생휴학생포함 (최대 6학기 까지 지원)',
      Col13: '공고일 현재 부모와 대상자 모두 광양시에 주민등록이 되어있는 대학생* 예외) 임대주택 세입자 권리확보 등의 이유로 학교 또는 학교 소재지로 전입 신고한 경우 거주조건 제한없음',
      Col14: '2022-09-14~2022-09-30',
      Col15: '해당없음',
      Col16: '600여명 ',
      Col17: '한국장학재단 대출자료 추출시 완제 계좌는 지원불가타 지자체와 중복지원 불가대학원생 제외',
      Col18: '해당없음',
      Col19: '(공통) 신청서/ 재학 또는 휴학증명서/ 학생 주민등록 등본(관외 거주 학생) 부 또는 모 가족관계증명서 및 관련 증빙자료 * 공고일 이후 발급분'
    },
    {
      Col1: '전라남도 함평군청',
      Col2: '함평군청인재양성기금(성적우수)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생수능 응시 합격자 : 직전 학년(고3) 전 과목 평균등급 3등급 이내이며/ 수능 평균등급 3등급 이내수능 미응시 합격자 : 고등학교 1~3학년 전 과목 평균등급 3등급 이내 * 재학생직전 학년 성적 평균 B+ 이상기초생활수급자의 경우 C+ 이상',
      Col10: '해당없음',
      Col11: '수도권 학생: 최대 3000000원비수도권 학생: 최대 2500000원',
      Col12: '품행이 단정하고 학업성적 또는 재능이 우수한 학생으로서 장학 신청 자격조건을 모두 갖춘 사람2022년 국가장학금을 신청한 사람',
      Col13: '함평군에 주민등록법상 주소를 두고 고등학교 졸업일 기준 3년 이상 계속 거주하며 군내 학교에 재학한 자',
      Col14: '2022-03-10~2022-03-31',
      Col15: '성적평가 80% + 재산정도 20% + 가산점 10%',
      Col16: '25명 ',
      Col17: '외국 소재 학교 또는 외국 학교의 국내 분교에 재학하는 학생국가 등으로부터 학비를 지원받는 학교에 재학하는 학생4년간 대학 등록금 전액 면제자정규 학제기간을 초과하여 재학 중인 대학생한국방송통신대/ 사이버대/ 학점은행제 등 유사대학 재학생올해 지원받은 장학금 총액이 등록금을 초과/ 차액이 20만원 미만인사람',
      Col18: '읍면장 추천',
      Col19: '인재양성기금 지원 신청서인재양성기금 지원대상자 추천서인재양성기금 신청자 실태조사 확인서개인정보 수집/ 이용/ 제공 및 조회 동의서서약서2021년 지방세 세목별 과세 증명서건강보험료 납부확인서국민기초생활수급자/ 차상위계층 증명서(해당자만)장애인증명서(해당자만)국가유공자 증명서(해당자만)통장사본(본인명의)성적증명서관내 초/중/고 졸업(예정)증명서재학증명서 또는 합격증명서주민등록등본/초본가족관계증명서등록금(교육비) 납입증명서(221학기)2022년 국가장학금 신청 증빙서류국가장학금 탈락사유 증빙서류  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '전라남도 함평군청',
      Col2: '함평군청인재양성기금(특기자)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '500000원',
      Col12: '문화/예술/체육/과학/농업분야에 소질과 재능이 뛰어난 자 중  도 단위 이상 공식 대회에서 입상한 경력이 있는 자',
      Col13: '공고일 현재 주민등록법상 주소를 함평군에 3년 이상 둔 대학생',
      Col14: '2022-02-07~2022-04-07',
      Col15: '직전년도 도 단위 이상 공식대회 입상실적 고득점자순',
      Col16: '8명',
      Col17: '외국 소재 학교 또는 외국 학교의 국내 분교에 재학하는 학생국가 등으로부터 학비 등을 지원받는 학교에 재학하는 학생4년간 대학 등록금 전액 면제자정규 학제기간을 초과하여 재학 중인 대학생한국방송통신대/ 사이버대/ 학점은행제 등 유사대학 재학생 * 자세한 사항은 첨부파일 참고',
      Col18: '읍면장/ 학교장 추천',
      Col19: '인재양성기금 지원신청서인재양성기금 지원대상자 추천서인재양성기금 신청자 실태조사 확인서개인정보 수집/이용/제공 및 조회 동의서서약서통장사본재학증명서 또는 합격증명서주민등록등본/초본2021년도 도 단위 이상 공식대회 입상 상장 사본관내 초/중/고 졸업(예정) 증명서 (가산점 받고자 하는 경우) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '전라남도',
      Col2: '지역중소기업 청년취업 학자금대출 상환지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학8학기이상/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '최근3개월 평균 가구소득인정액이 중위소득 150% 이하인 자',
      Col11: '최대 1200000원',
      Col12: '전라남도 소재 중소기업에 근무중인 청년으로 학자금대출금(일반/ 취업후/ 농어촌융자)을 상환하고 있는 자만 18세 이상 만 39세 이하인 자 ',
      Col13: '공고일 기준으로 본인의 주민등록상 주소지가 전라남도',
      Col14: '2022-03-29~2022-04-20',
      Col15: ' * 우선순위에 따라 대상자 선정/ 소득액 및 가구원수 고려1순위 : 산업단지 종사자 2순위 : 사회적기업 종사자3순위 : 그 외 중소기업 종사자',
      Col16: '100여명',
      Col17: '국가나 지방자치단체 등으로부터 학자금 대출상환지원을 받는 자군복무자 및 군복무 대체근무자(산업기능요원/ 사회복무요원 등)',
      Col18: '해당없음',
      Col19: '청년 취업자 학자금대출 상환 지원 신청서주민등록등본가족관계증명서학자금대출 상환 확인서중소기업 확인서중소기업 근무 확인서류통장사본건강보험료 납부확인서건강보험료 자격확인서개인정보 수집·이용 및 제3자 제공 동의서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '전라남도 영광군청',
      Col2: '영광군인재육성기금(학업우수)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생(수능응시) : 수능평균 3등급 이내신입생(수능미응시) : 예체능 과목 제외한 고교 3학년 내신 성적 평균 3등급 이내/ 검정고시 합격자의 경우 평균 득점 80점 이상재학생 : 직전학년 성적(1/2학기) 평균평점 B학점 이상 * 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '1인당 3000000원 이내',
      Col12: '고등교육법 제2조 중 국내의 대학/ 산업대학/ 교육대학 및 전문대학에서 수학하고 있는 입학생 및 재학생',
      Col13: '공고일 현재 본인이나 그 보호자(부 또는 모 등)가 영광군에 계속해서 주민등록을 두고 2년 이상 거주하는 자',
      Col14: '2022-03-29~2022-04-20',
      Col15: ' * 자세한 사항은 첨부파일 참고',
      Col16: '24명',
      Col17: '매학기 등록금 총액이 1/000천원 이하인 대학에 재학중인 학생은 제외가족당 1명만 지급. 단/ 다자녀(3명이상)의 경우 2명까지 지원 확대영광군 인재육성장학금을 2회(단/ 전문대 1회/ 치대/의대/한의대/약대 등 6년제인 경우는 3회)이상 지원받은 자 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '인재육성장학금 신청서주민등록등본장학금 지급 통장 사본가족관계증명서직전학년 성적증명서(재학생)대학수능성적증명서(수능응시자)고등학교 3학년 생활기록부 또는 검정고시 성적표(수능미응시자)재학(입학)증명서고등학교 졸업증명서(영광군 소재 고등학교 졸업한 재학생) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '전라남도 영광군청',
      Col2: '영광군인재육성기금(옥당골인재)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 대학수학능력시험 응시자 중 국어/수학/영어/탐구/한국사 영역 등 5개 영역 등급의 합이 6 이내재학생: 옥당골 인재 장학생으로 선발된 학생 중 직전학년 성적 평균 B학점 이상인 학생  * 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '고등교육법 제2조 중 국내의 대학/ 산업대학/ 교육대학 및 전문대학에서 수학하고 있는 재학생',
      Col13: '공고일 현재 본인이나 그 보호자(부 또는 모 등)가 영광군에 계속해서 주민등록을 두고 2년 이상 거주하는 자',
      Col14: '2022-03-29~2022-04-20',
      Col15: ' * 대학수학능력시험 성적(100%) ',
      Col16: '6명',
      Col17: '매학기 등록금 총액이 1/000천원 이하인 대학에 재학중인 학생은 제외가족당 1명만 지급. 단/ 다자녀(3명이상)의 경우 2명까지 지원 확대영광군 인재육성장학금을 2회(단/ 전문대 1회/ 치대/의대/한의대/약대 등 6년제인 경우는 3회)이상 지원받은 자',
      Col18: '해당없음',
      Col19: ' 인재육성장학금 신청서개인정보 수집/이용 및 제공/조회 동의서주민등록등본장학금 지급 통장 사본가족관계증명서직전학년 성적증명서(재학생)대학수능성적증명서(수능응시자)고등학교 3학년 생활기록부 또는 검정고시 성적표(수능미응시자)재학(입학)증명서'
    },
    {
      Col1: '전라남도 영광군청',
      Col2: '영광군인재육성기금(특기자)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '예체능계열/인문계열',
      Col9: '체육/문예 특기 대회 수상 : 직전학년 중 음악/ 미술/ 무용/ 체육/ 문학 등 예체능과 관련하여 국제대회/ 광역자치단체 이상의 단체나 기관에서 주관한 전국대회 또는 도 대회에서 3위 이내의 서적을 거둔 학생학교를 빛낸 인재 : 직전학년 중 다양한 분야에서 두각을 나타내 영광을 알리는데 앞장선 학생 * 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '고등교육법 제2조 중 국내의 대학/ 산업대학/ 교육대학 및 전문대학에서 수학하고 있는 입학생 및 재학생',
      Col13: '공고일 현재 본인이나 그 보호자(부 또는 모 등)가 영광군에 계속해서 주민등록을 두고 2년 이상 거주하는 자',
      Col14: '2022-03-29~2022-04-20',
      Col15: '해당없음',
      Col16: '체육특기 : 2명문예특기 : 2명',
      Col17: '매학기 등록금 총액이 1/000천원 이하인 대학에 재학중인 학생은 제외가족당 1명만 지급. 단/ 다자녀(3명이상)의 경우 2명까지 지원 확대영광군 인재육성장학금을 2회(단/ 전문대 1회/ 치대/의대/한의대/약대 등 6년제인 경우는 3회)이상 지원받은 자',
      Col18: '읍면장',
      Col19: '인재육성장학금 신청서개인정보 수집/이용 및 제공/조회 동의서주민등록등본장학금 지급 통장 사본가족관계증명서재학(입학)증명서고등학교 졸업증명서(영광군 소재 고등학교 졸업시)입상증명서(상장 등)'
    },
    {
      Col1: '전라남도 영광군청',
      Col2: '영광군인재육성기금(복지장학)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전학년 성적(1/2학기) 평균평점 C학점 이상',
      Col10: '국민기초생활수급자 또는 차상위 계층 자녀소득인정액 기준 중위소득 70% 이내의 건강보험료를 납부하는 가정',
      Col11: '3000000원',
      Col12: '해당없음',
      Col13: '공고일 현재 본인이나 그 보호자(부 또는 모 등)가 영광군에 계속해서 주민등록을 두고 2년 이상 거주하는 자',
      Col14: '2020-03-31~2020-05-22',
      Col15: '소득평가 100% 적용',
      Col16: '6명',
      Col17: '매학기 등록금 총액이 1/000천원 이하인 대학에 재학중인 학생은 제외가족당 1명만 지급. 단/ 다자녀(3명이상)의 경우 2명까지 지원 확대영광군 인재육성장학금을 2회(단/ 전문대 1회/ 치대/의대/한의대/약대 등 6년제인 경우는 3회)이상 지원받은 자',
      Col18: '해당없음',
      Col19: '인재육성장학금 신청서개인정보 수집/이용 및 제공/조회 동의서주민등록등본장학금 지급 통장 사본가족관계증명서직전학년 성적증명서(재학생)재학(입학)증명서건강보험료 납부확인서 및 건강보험 자격확인서고등학교 졸업증명서(영광군 소재 고등학교 졸업자) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '전라남도 영광군청',
      Col2: '영광군인재육성기금(복지옥당골)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 대학수학능력시험 응시자 중 국어/ 수학/ 영어/ 탐구영역 등 4개영역 등급의 합이 9이내(탐구영역은 상위 2과목 평균  등급 반영)재학생 : 옥당골인재 장학생으로 선발된 학생중 직전학년 성적 평균  B학점 이상인 학생',
      Col10: '국민기초생활수급자 차상위계층재산세(주택.토지.건물포함) 납부(부과)액 30000원이하 : 2018년도분 부 모 각각 발급 포함건강 장기요양보험료 월평균 납부(부과)액 50000원이하 : 2018년년도분 부 모 각각 발급 포함',
      Col11: '3000000원',
      Col12: '고등교육법 제2조 중 국내의 대학/ 산업대학/ 교육대학 및 전문대학에서 수학하고 있는 입학생 및 재학생',
      Col13: '공고일 현재 본인이나 그 보호자(부 또는 모 등)가 영광군에 계속해서 주민등록을 두고 2년 이상 거주하는 자',
      Col14: '2020-03-31~2020-05-22',
      Col15: '해당없음',
      Col16: '대학생 2명',
      Col17: '당해학기에 타 장학금 2/000천원(전문대 1/500천원)이상 수혜자매학기 등록금 총액이 1/000천원 이하인 대학에 재학중인 학생은 제외가족당 1명만 지급. 단/ 다자녀(3명이상)의 경우 2명까지 지원 확대영광군 인재육성장학금을 2회(단/ 전문대 1회/ 치대/의대/한의대/약대 등 6년제인 경우는 3회)이상 지원받은 자',
      Col18: '읍/면장 추천',
      Col19: '인재육성기금 지원신청서(공통)개인정보이용 동의서읍/면장 또는 학교장 추천서주민등록 등본(거주기간 확인)직전학년 성적증명서대학수능성적증명서고등학교 3개년 생활기록부(수능 미 응시자)20201학기 등록금 납입증명서(장학금 내역포함)  재학(입학)증명서지방세세목별과세증명서 (부/모 각각발급)국민기초생활수급자 또는 차상위계층 확인서건강/ 장기 요양보험료 납부확인서 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '전라남도 영광군청',
      Col2: '영광군인재육성기금(복지특기자)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 중 체육/ 문예 분야의 도단위 및 전국대회 3위 이상 입상한 자 * 체육분야는 국가대표로 선발된 자 포함',
      Col10: '국민기초생활수급자 차상위계층재산세(주택.토지.건물포함) 납부(부과)액 30000원이하 : 2018년도분 부 모 각각 발급 포함건강 장기요양보험료 월평균 납부(부과)액 50000원이하 : 2018년도분 부 모 각각 발급 포함',
      Col11: '3000000원',
      Col12: '고등교육법 제2조 중 국내의 대학/ 산업대학/ 교육대학 및 전문대학에서 수학하고 있는 입학생 및 재학생',
      Col13: '공고일 현재 본인이나 그 보호자(부 또는 모 등)가 영광군에 계속해서 주민등록을 두고 2년 이상 거주하는 자',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '당해학기에 타 장학금 2/000천원(전문대 1/500천원)이상 수혜자매학기 등록금 총액이 1/000천원 이하인 대학에 재학중인 학생은 제외가족당 1명만 지급. 단/ 다자녀(3명이상)의 경우 2명까지 지원 확대영광군 인재육성장학금을 2회(단/ 전문대 1회/ 치대/의대/한의대/약대 등 6년제인 경우는 3회)이상 지원받은 자',
      Col18: '읍/면장의 추천',
      Col19: '인재육성기금 지원신청서 (공통)읍/면장 또는 학교장 추천서주민등록 등본 (거주기간 확인)직전학년 성적증명서20201학기 등록금 납입확인서(장학금 내역포함)재학(입학)증명서지방세세목별과세증명서국민기초생활수급자 또는 차상위계층확인서건강/장기 요양보험료 납부확인서(전년도 1년분/ 부/모 각각발급) *  자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '전라남도 영광군청',
      Col2: '원전지역장학(기초수급자/장애인)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2022년 1학기 평균학점이 2.0이상(C학점)인 대학생1학기 12학점 이상 이수자(국가장학금 지급기준 반영)',
      Col10: '국민기초생활수급자 차상위계층자 한부모가족 등록장애인',
      Col11: '1000000원 * 납입금액이 1000000원 이하인 경우 해당금액(천원단위 절삭)',
      Col12: '고등교육법 제2조 제1호~제6호에 해당하는 학교 중 교육부에서 인가한 대학(교) 재학생국민기초생활수급자/ 차상위계층자/ 한부모가족/ 등록 장애인',
      Col13: '공고일 현재 한빛원전주변지역(백수/홍농/법성)에 본인이나 그 보호자(부 또는 모 등)가 주민등록을 두고 1년이상 거주하고 있는 자',
      Col14: '2022-08-01~2022-08-24',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '당해 학기 국가 및 지자체에서 수혜 받은 장학금이 등록금(납부금) 이상인 학생대학원생/ 외국소재 대학교 재학생학생당 1개 분야만 지급허위 또는 기타 부정한 방법으로 장학금을 지급 받은 자는 즉시 회수하고 향후 3년간 장학금 미지급',
      Col18: '해당없음',
      Col19: '신청서 및 통장사본개인정보 수집·이용 및 제공·조회 동의서주민등록등본(거주지 확인용)가족관계증명서(세대분리된 경우에 한해 관내 거주자 기준으로 제출)실거주확인서(마을별 이장님 서명확인)재학증명서신청 확인서  * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '전라남도 영광군청',
      Col2: '원전지역장학(특기자)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2022년 1학기 12학점 이상 이수/ 평균학점이 2.0이상(C학점) 인 학생 * 국가장학금 지급기준 반영',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '고등교육법 제2조 제1호~제6호에 해당하는 학교 중 교육부에서 인가한 대학(교) 재학생2021. 08. 31.이후 문화·음악·미술·체육·기능 등에 대한 지자체/ 교육지원청 등 정부기관에서 주관·협찬하는 대회 3위 이내 수상한 특기학생 ',
      Col13: '공고일 현재 한빛원전주변지역(백수/홍농/법성)에 본인이나 그 보호자(부 또는 모 등)가 주민등록을 두고 1년이상 거주하고 있는 자',
      Col14: '2022-08-01~2022-08-24',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '당해 학기 국가 및 지자체에서 수혜 받은 장학금이 등록금(납부금) 이상인 학생대학원생/ 외국소재 대학교 재학생1인 1분야 선발원칙허위 또는 기타 부정한 방법으로 장학금을 지급 받은 자는 즉시 회수하고 향후 3년간 장학금 미지급',
      Col18: '단체운동부는 학교장 추천을 통한 선수만 인정',
      Col19: '신청서 및 통장사본개인정보 수집·이용 및 제공·조회 동의서주민등록등본(거주지 확인용)가족관계증명서(세대분리된 경우에 한해 관내 거주자 기준으로 제출)실거주확인서(마을별 이장님 서명확인)대회입상증명서재학증명서'
    },
    {
      Col1: '전라남도 영광군청',
      Col2: '원전지역장학(성적우수)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2021년 1학기 평균학점이 2.0(C학점)인 학생12학점 이상 이수자',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '고등교육법 제2조 제1호~제6호에 해당하는 학교 중 교육부에서 인가한 대학(교) 재학생으로/ 성적 우수자',
      Col13: '공고일 현재 한빛원전주변지역(백수/홍농/법성)에 본인이나 그 보호자(부 또는 모 등)가 주민등록을 두고 1년이상 거주하고 있는 자',
      Col14: '2021-11-15~2021-11-26',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '당해 학기 국가 및 지자체에서 수혜 받은 장학금이 등록금(납부금) 이상인 학생대학원생/ 외국소재 대학교 재학생1인 1분야 선발원칙',
      Col18: '해당없음',
      Col19: '신청서 및 통장사본개인정보 수집·이용 및 제공·조회 동의서주민등록등본(거주지 확인용)가족관계증명서(본인과 보호자 세대분리된 경우 : 타지역거주자 명의 가족관계증명서 제출)실거주확인서(마을별 이장님 서명확인)성적증명서'
    },
    {
      Col1: '경상북도 봉화군청',
      Col2: '희망복지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신규신청 : 직전학기 12학점이상 이수자로 100점만점에 60점이상재신청: 직전학기 12학점 이상 이수자로 100점 만점에 70점 이상',
      Col10: '국민기초생활수급자 및 차상위계층의 자녀기타 저소득층의 자녀(기준 중위소득 60% 이하 세대건강보험료 납부액 기준) * 자세한 사항은 첨부파일 참고고',
      Col11: '2000000원( * 중복수혜 시 지원금액과의 차액만 지급)',
      Col12: '국민기초생활수급자 및 차상위계층의 자녀',
      Col13: '공고일 현재 봉화군에 주민등록을 두고 봉화군에 거주하고 있는 세대',
      Col14: '2022-05-06~2022-05-31',
      Col15: '해당없음',
      Col16: '2명 ',
      Col17: '방송통신대학/ 학사고시/ 사이버 대학 및 휴학생과 해외유학생은 지급대상에서 제외',
      Col18: '해당없음',
      Col19: ' * 각 행정시/동/읍/면/리 홈페이지에서 확인 후 문의 필수저소득주민자녀 장학생 신청 추천서 장학금 수혜여부 확인서 직전학기 성적증명서 (편입자는 최종 학기 성적증명서)신청일 기준 전월분 건강보험료 납부증명서(기타 저소득층) 주민등록등본(필요시 가족관계증명서) 신청자 통장사본(장학금 수령계좌)  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '경상북도청',
      Col2: '중소기업근로자자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '전년도 가구원별 도시근로자 월평균 소득기준 90%이하인 자산업재해 및 기타사유로 가정생활이 어려운 근로자 * 첨부파일 표 참고',
      Col11: '연 3000000원',
      Col12: '공고일 현재 근로자의 주민등록상 주소지가 경상북도 내로 되어 있고/ 자녀가 고등학생 또는 대학생인 중소기업 근로자 (공고일 현재 동일 중소기업에서 3개월 이상 재직자)의 자녀',
      Col13: '공고일 현재 근로자의 주민등록상 주소지가 경상북도 내로 되어 있고/ 자녀가 고등학생 또는 대학생인 중소기업 근로자 (공고일 현재 동일 중소기업에서 3개월 이상 재직자)',
      Col14: '2021-10-06~2021-11-19',
      Col15: '학자금 선정정 심의위원회의 심의를 거쳐 선발',
      Col16: '약 80명 정도',
      Col17: '휴학생경상북도 중소기업 근로자자녀 장학금 기 수헤자(최근 3년간)종합부동산세 납부 대상자해당연도 국가장학금 등 타기관 장학금 수혜자자',
      Col18: '추천필요 * 자세한 내용은 첨부파일 참고',
      Col19: '학자금 지급 신청서학자금 중복지원 방지 및 반환에 관한 서약서개인정보 수집/이용 및 제공/조회 동의서기타 증빙서류 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '경상북도청',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '한국장학재단에서 학자금 대출을 받고 대출당시 소득분위 8분위 이하에 해당하는 자 및 다자녀(3명 이상)가구의 대학생(소득분위 무관)',
      Col11: '2016년 1학기 이후 대출금의 2021년 1년(1월 ~ 12월)동안 발생한 이자 지원 * 학자금 대출 시 등록금과 생활비 모두 포함',
      Col12: '한국장학재단에서 학자금 대출을 받은 자경북. 대구 소재 대학 재학생 또는 졸업생대출당시 학자금 지원 8구간 이하에 해당 또는 다자녀 가구구',
      Col13: '대구/ 경북 소재 대학교의 학생으로 대학생 본인 또는 직계존속(부모/ (외)조부모)이 2020.10.06일 이전부터 공고일 현재까지 거주한 자',
      Col14: '2021-02-03~2021-02-19',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학 제적생 제외',
      Col18: '해당없음',
      Col19: '주민등록표초본(최근5년간 주소변동이력 포함하여 발급가족관계증명서  * 반드시 주민등록번호 뒷번호 7자리는 삭제 후 이미지 파일로 온라인 첨부 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경상북도 포항시청',
      Col2: '저소득한부모가족자녀대학입학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '한부모 및 조손가족 중 기준중위소득 52%이하 세대청소년한부모가족 중 기준중위소득 60%이하 세대 ',
      Col11: '2000000원',
      Col12: '대학 입학생',
      Col13: '포항시 연고자',
      Col14: '2021-04-07~2021-04-16',
      Col15: ' * 신청자가 예산범위를 넘어 신청할 경우소득인정액(가구원1인당) 낮은 순 지원장학금 또는 학비감면액이 없거나 본인 부담금이 많은 순재학자녀가 많은 순(대학교/ 고등학교/ 중학교 순)',
      Col16: '해당없음',
      Col17: '국민기초생활보장법상 생계/의료급여 수급자기타 다른법령 등에 따라 국가장학금 지원을 받는 경우기 지원받은 자녀가 자퇴 후 재입학한 경우우',
      Col18: '해당없음',
      Col19: '신청서등록금납부 영수증통장사본'
    },
    {
      Col1: '경상북도 울릉군청',
      Col2: '주민소득지원및생활안정기금대부',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 융자한도소득지원자금 : 최대 2천만원생활안정자금 : 최대 1천만원대부이율 : 무이자(2년 거치 2년 반기별 균분상환) 연체이율 : 연 5%',
      Col12: ' * 소득자금지원으로 자립기반을 구축할 수 있는 가구 * 고소득고부가가치 소득원을 개발/ 소득증대를 이룰 수 있는 가구 * 1지역 1명품으로 지정된 품목을 생산하는 가구 * 생계가 곤란한 자 중 자립의욕이 있는 자행상 및 노점 등 이에 준하는 영세 상행위를 위한 자금고등학교 이상에 재학 중인 직계비속에 대한 학자금 ',
      Col13: '해당없음',
      Col14: '2021-10-25~2021-10-29',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '본 융자금 기 대부중인 자 제외수탁금융기관 여신규정에 맞지 않는 자 (신용/ 담보대출 불가능한 자 ) 제외',
      Col18: '해당없음',
      Col19: '대부 신청서 및 동의서주민등록등본가족관계증명서 * 접수장소 : 읍/면사무소 (총무담당) * 자세한 사항은 을릉군청 공지사항 참고'
    },
    {
      Col1: '경상북도 울릉군청',
      Col2: '울릉군 지방공무원 임용후보자 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 고등학교 3년 평균 내신등급의 석차가 3할 이내인 사람',
      Col10: '해당없음',
      Col11: '대학교 1~2학년 학기별 등록금 최대 2000000원까지 지원 졸업 후 소정의 절차를 거쳐 울릉군 지방공무원으로 임용',
      Col12: '간호직렬에 한하여 2~3년제 대학과 4년제 대학교 구분 없이 간호 관련 학과 입학 예정자 ',
      Col13: '고등학교 졸업예정자로서 2021. 1. 1. 이전까지 주민등록상 주소지가 5년 이상 울릉군으로 되어 있는 사람',
      Col14: '해당없음',
      Col15: '1차 서류심사2차 필기 및 면접시험 (서류전형 합격자에 의함)',
      Col16: '간호 1명환경 (일반환경) 1명시설 (일반토목) 1명',
      Col17: '「지방공무원법」제31조의 규정에 정한 결격사유에 해당하는 자/ 기타 법령에 의하여 응시자격이 정지된 자',
      Col18: '해당없음',
      Col19: '지방공무원 임용후보자 장학생 지원서학교장 추천서성적증명서 주민등록초본재정보증서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 의성군인재육성재단',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '학기별 등록금의 1/2 범위 내 자부담액',
      Col12: '다자녀 가정의 셋째 이상인 자녀로 교육인적자원부 (광역시도 교육청 포함)가 인가한 고등학교/ 국내 대학교(전문대학 포함)에 재학 중인 자 ',
      Col13: '등록금 납부일 기준 부모(편부모의 경우 부 또는 모)와 함께 관내에 주민등록을 두고 거주하는자',
      Col14: '2021-09-01~2021-09-30',
      Col15: '해당없음',
      Col16: '70명',
      Col17: '법령 또는 다른 조례 등에 따라 행정기관으로부터 학자금을 지원 받는 경우 (단/ 지원금액이 의성군조례에서 규정하고 있는 지원금액에 미달하는 경우에 그 차액 지원 가능)자퇴 또는 퇴학 등의 사유로 학업을 중단한 경우부모와 지원대상자가 관내에 주민등록을 두고 부모가 거주 하지 않는 경우',
      Col18: '해당없음',
      Col19: '다자녀 장학금 지원신청서 주민등록등본(부모/ 지원대상자 주소 확인용)가족관계증명서(부모와 주소지를 달리할 경우 지원대상자 기준)재학증명서(신입생의 경우 합격증명서) 등록금 납입증명서지원대상자 또는 부모명의 예금통장 사본개인정보 수집·이용·제공 동의서*신청장소  :  읍면사무소/ 의성군청 총무과 ( 방문제출/ 등기우편) 주소 :  경북 의성군 의성읍 군청길 31(의성군청 총무과 평생교육계)'
    },
    {
      Col1: '경상북도 영주시청',
      Col2: '저소득주민생활안정기금융자',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활보장수급 가구 자녀로서 생계·의료급여 수급자 자녀',
      Col11: '가구당 10000000원 이하 * 상환조건 : 2년 거치 3년 원금 분할상환 * 이율 : 무이자 ',
      Col12: ' * 국민기초생활보장수급 가구 중 직계비속에 대한 고등학교 이상의 재학생 학자금자금 융자 희망 가구로서 2년제 이상 대학 재학생으로서 읍·면·동장의 추천을 받은 자기타 시장이 특별히 필요하다고 인정하는 사업자금/상행위를 위한 자금/생계자금',
      Col13: '해당없음',
      Col14: '2022-05-09~2022-05-20',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '융자대상자로 선정되었으나/ 보증인 요건이 금융기관 대출에 적절하지 않은 경우 융자 불가',
      Col18: '읍·면·동장의 추천을 받은 자',
      Col19: '생활안정기금 대부신청서사업계획서(해당자) * 자세한 사항은 첨부파일 참조 '
    },
    {
      Col1: '경상남도 창원시청',
      Col2: '중소기업노동자자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 전체성적 평균 평점 C 이상 ※ 신입생 제외',
      Col10: '월평균 소득 7631620원 이하 가구',
      Col11: '1인 1회 1000000원 이내 (상하반기 2회 지급)실제 납부한 교육비 이내 타 장학금액 공제 후 지급',
      Col12: '창원시 소재 중소기업 근로자의 자녀로써 재학중인 대학생',
      Col13: '공고일 현재 창원시에 소재 중소기업에 근무하고 관내에 주민등록이 되어 있는 노동자',
      Col14: '2022-03-02~2022-03-16',
      Col15: '해당없음',
      Col16: '30명',
      Col17: '학교/ 국가/지방자치단체/ 기업체 등으로부터 학비 전액 보조받고 있는 자2022년도 경상남도 근로자 자녀 장학금 전액 수혜자2021년도 창원시 노동자 자녀 장학금 수혜자자녀가 재학중이 아닌경우(퇴학/정학/휴학) ',
      Col18: '재직하고 있는 중소기업의 추천을 받은 자 * 노동조합이 구성된 중소기업 : 노동조합의 대표 또는 중소기업의 대표 * 노동조합이 미 구성된 중소기업 : 중소기업 대표',
      Col19: '창원시 근로자 자녀 장학생 신청(추천)서장학금 지급대상자 추천서(학교)개인(신용)정보 수집·이용 및 조회·제공 동의서주민등록등본/ 가족관계증명서 각 1부노동자 명의 통장사본 1부중소기업확인서2022년 1학기 교육비 납입증명서2022년 장학금 수헤확인서2021년도 근로소득원천징수영수증(근로자/ 배우자) 각 1부대학교 직전학년 성적증명서 (신입생 제외) * 자세한 사항은 첨부파일 참고 * 접수처 : 창원시 경제기업사랑과 또는 거주지 관할 읍/면/동 주민센터 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '경상남도 창원시청',
      Col2: '이주민자녀학비지원',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1학기분의 등록금 지급',
      Col12: '자녀가 대학교(전문대학 포함)에 재학중인 자',
      Col13: '창원국가산업단지 도시개발사업으로 주거용 건축물이 편입되어 보상금을 수령한 이주민의 자녀',
      Col14: '2022-06-20~2022-06-24',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '학비신청일 현재 창원시 미거주자대학원생/ 휴학생/ 졸업생학비지원 대상자로 기 지원 완료된 세대보상금 수령자의 손자/ 손녀국가장학금 및 창원시에서 지원하는 타 장학금 중복수령자',
      Col18: '해당없음',
      Col19: '신청서재학증명서통장사본본'
    },
    {
      Col1: '경상남도 거제시청',
      Col2: '재능나눔 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/인문계열/자연계열',
      Col9: '직전 학년 평균 성적이 4.5만점에 3.5 이상인 학생',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '시장이 정한 재능 나눔 활동을 할 수 있는 학생',
      Col13: '시 관내 중학교 또는 고등학교를 졸업한 학생 또는 이와 동등한 자격을 가진 대학교 재학생',
      Col14: '2022-01-18~예산소진시까지',
      Col15: '직전학년 평균성적 40% + 자기소개서 및 재능봉사 계획서 40% + 거제시 거주기간 10% + 우대사항 10% * 우대사항 : 사범대 재학생 또는 선발 과목 전공자/ 토익 800점/토플91점 이상',
      Col16: '30명',
      Col17: '졸업예정자',
      Col18: '해당없음',
      Col19: '거제시 장학생 신청서재능 나눔 활동 지원서재능 나눔 계획서개인정보 수집 및 이용 동의서재학증명서(발급일자: 20220613 이후)성적증명서(발급일자: 20220613 이후)주민등록 초본(주소지 변동내역 전체 포함)우대사항 조건에 해당할 경우/ 시험 성적표 * 자세한 내용은 첨부파일 참고 '
    },
    {
      Col1: '거창군청',
      Col2: '근로자자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원 이내',
      Col12: '근로기준법상 근로자 중 군내에 주민등록이 되어 있고/ 제조업·관광·레저산업을 하는 사업체/ 승강기산업체 근로자의 자녀',
      Col13: '추천마감일 기준 2개월 이상 군내에 주민등록이 되어 있는 대학생',
      Col14: '2022-07-18~2022-07-29',
      Col15: ' * 우선 선발기준영세하여 근로자 자녀 학비 지원이 곤란한 기업체근로자(가구원 포함)의 소득 및 재산 정도신규 신청자',
      Col16: '해당없음',
      Col17: '기업의 대표자 자녀근로자 자녀 장학금 기 수혜자 학교/단체/기업 또는 군의 다른 조례에 따른 타 장학금 수혜자',
      Col18: '해당없음',
      Col19: '장학생 신청서장학생 신청 확인서장학생 추천서개인정보이용 동의서근로자 재직증명서자녀 재학증명서주민등록등본세목별 과세증명서근로소득원천징수영수증'
    },
    {
      Col1: '김해시청',
      Col2: '공항소음 대책 지역 장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '학생가장 조손가정 다문화가정 북한이탈가정 한부모가정 위탁가정 위탁보호시설 출신 가산점차상위계층 장애인 등록자 기초생활수급자 가산점',
      Col11: '인당 500000원',
      Col12: '2020.07.11 이전부터 공항소음 대책지역 및 인근지역에 거주(주민등록상 거주)하는 주민 중 국내 대학 재학생 자녀를 둔 주민 (본인 이 학생인 경우 포함)',
      Col13: ' * 공항소음 대책지역 및 인근지역 거주자 ( 불암동 일부/ 활천동 일부/ 삼안동 일부/ 부원동 일부/ 회현동 일부)에 거주 (주민등록상 거주지)하는 주민',
      Col14: '2022-07-05~2022-07-22',
      Col15: '배정표에 따라 고득점자 순 선발 * 배정표 홈페이지 공고 첨부파일 참고',
      Col16: '92명',
      Col17: '휴학생 선발 제외',
      Col18: '해당없음',
      Col19: ' * 거주지역 주민센터로 접수/ 자세한 사항은 홈페이지 내 공고 참조장학금 지원신청서자녀 재학증명서자녀 직전학기 성적증명서개인정보 제공 동의서가족관계 증명서초본통장사본가점사항 증빙서류 '
    },
    {
      Col1: '경상남도청',
      Col2: '중소기업노동자자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 직전학년 학점 평균이 C 이상인 자',
      Col10: '월평균 가구소득이 2022년 4인가구 중위소득 130% 이하인 가정 ',
      Col11: '대학생 연 2000000원 이내 (1년간 수업료 + 운영비 지급)',
      Col12: '근로자의 자녀로서 대학생(신입생/편입생제외)',
      Col13: '공고일 현재 도내에 주민등록이 되어 있고/ 중소기업기본법상 중소기업에 해당하는 사업체에서 6개월 이상 근무하고 있는 근로자 및 실직근로자 포함 ',
      Col14: '2022-03-07~2022-03-25',
      Col15: '해당없음',
      Col16: '대학생 25명 이상',
      Col17: '월평균 가구소득이 중위소득보다 많은 경우노동자 자녀 장학금을 수혜받은 적이 있는 경우신청년도에 다른 장학금 또는 학비감면액이 노동자 자녀 장학금 보다 많을 경우퇴학. 정학 처분을 받았거나 휴학 중인 경우그 밖에 도지사가 장학금을 지급할 필요가 없다고 인정하였을 경우우',
      Col18: '시장 또는 군수의 추천을 받아 도지사가 정함',
      Col19: '근로자자녀 장학금 지급 신청서근로자자녀 장학금 신청 확인서(학교)근로자 자녀 장학금 신청 확인서(소속기업)개인정보 이용 동의서 기타 증빙서류 (첨부파일 참고)'
    },
    {
      Col1: '경상남도청',
      Col2: '대학입학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '22학년도 수능 3과목(국·영·수) 중 2개과목 평균 3등급이내 성적 또는 고등학교 31학기(국·영·수·사/과) 중 3개과목 평균 3등급 이내인자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '‘21년 서민자녀 교육지원사업(여민동락 교육복지카드) 지원 대상자중 성적요건을 충족하는 자',
      Col13: '도내 고교학생으로 보호자는 공고일 현재 도내에 1년 이상 거주한 자',
      Col14: '2022-07-04~2022-08-16',
      Col15: '1차 심사 : 장학회 이사/ 외부 전문가 등으로 위원회를 구성하여 심사선발2차 심사 : 신청자 중 생활정도/ 성적/ 대학/ 학과 등을 종합적으로 고려하여 선발',
      Col16: '250명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '경상남도 대학입학생 장학금 신청서개인(신용)정보 수집·이용 및 제공·조회 동의서2022학년도 대학수학능력시험 성적통지표 또는 고등학교 31학기 성적증명서대학 재학증명서자기소개서학생 명의 통장 사본* 해당자 서류보호자 확인서 (학생의 보호자가 직계존속이 아닌경우에 한함) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고 '
    },
    {
      Col1: '경상남도청',
      Col2: '대학생학자금대출이자지원사업',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소득분위 8분위 이하 가구의 학생다자녀(3명이상) 가구의 대학생',
      Col11: '2022.1.1. ~ 6.30. 발생이자 지원',
      Col12: '한국장학재단의 취업후상환학자금대출/ 일반상환학자금대출을 받은 자',
      Col13: '신청일 기준 경상남도에 주소지를 둔 소재대학(원) 재/휴학생 * 도내 28개 대학(2년제 포함) 재/휴학생에 한함',
      Col14: '2021-10-05~2021-11-19',
      Col15: '예산의 범위 내에서 저소득 순위로 선발',
      Col16: '해당없음',
      Col17: '장학재단의 지원대상 확정 전 완제자는 제외/ 타지자체와 중복지원 불가',
      Col18: '해당없음',
      Col19: '주민등록등본재·휴학증명서가족관계증명서건강보험료 납부확인서 * 자세한 사항은 첨부팡리 참고'
    },
    {
      Col1: '경상남도 통영시청',
      Col2: '대학생학자금이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한국장학재단을 통한 20132학기 이후 실행한 대출금의 2021년 01월 01일~ 2021년 12월 31일까지 발생한 이자',
      Col12: '2013년 2학기 이후 한국장학재단에서 학자금 대출을 받고 고등교육기관에 재학 또는 휴학 중인 대학생',
      Col13: '현재 본인이 1년 이상 또는 직계존속이 3년 이상 통영시 주민등록이 되어있고/ 통영시 소재 고등학교 졸업한 자현재 통영시 소재 대학에 재학/휴학생 : 1년이상 통영시에 주민등록 (1학년 : 3개월이상)',
      Col14: '2022-02-11~2022-02-25',
      Col15: '이자 지원 심의위원회에서 최종 결정',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 통영시 소재 고등학교 졸업생인 경우주민등록초본(주소변동 5년 포함)대학 재(휴)학 증명서고등학교 졸업증명서  (직계존속의 초본 제출시 학생 기준 가족관계증명서 필요) * 통영시 소재 대학교 재(휴)학생인 경우주민등록 초본 (주소변동 5년 포함)대학 재(휴)학 증명서 * 모든 서류는 2021.10.05 이후 발급한 서류만 인정 * 주민등록번호 뒷자리 미표기 또는 가려서 제출 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경상남도 통영시청',
      Col2: '저소득대학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업 성적 평균 C학점 이상(신입생은 고교 졸업성적의 상위 80% 이내)',
      Col10: '국민기초생활보장법에 따라 수급자 및 차상위 계층',
      Col11: '상한선 3000000원  ※ 최대 2회 지급 기존 2회의 장학금을 지급 받은 학생은 신청불가',
      Col12: '2022년 현재 통영시 관내 고등학교 졸업(예정)자로 대학에 진학하거나 재학 중인 학생자격조건 모두 만족',
      Col13: '2022년 공고일 현재 통영시 관할 내  학교를 6년 이상 다니고 주소를 6년 이상 둔 자',
      Col14: '2022-03-02~2022-03-31',
      Col15: '해당없음',
      Col16: '00명',
      Col17: '대학원생제적 및 휴학생',
      Col18: '해당없음',
      Col19: '신청서 1부개인정보수집활용동의확인서 등 1부첨부서류 : 신청서의 구비서류 일체 * 양식은 통영시 홈페이지 www.tongyeong.go.kr 참조나 첨부서류: '
    },
    {
      Col1: '경상남도 의령군청',
      Col2: '중소기업노동자자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 학점 평균이 C이상인 자녀(신입생/편입생 제외)',
      Col10: '월 평균 가구소득이 2022년 기준 4인가구 중위소득 130%(6657천원) 이하인 가정정',
      Col11: '1인당 연 200만원 이내 ',
      Col12: '사업장 소재지 시.군청 담당부서 방문 또는 우편접수 대상자 추천 및 선정',
      Col13: ' * 공고일 현재 도내에 주소를 두고도내 중소기업에서 6개월 이상 근무하고 있는 노동자도내 소재 사업체에서 퇴직하여 고용보험 실업급여를 받고 있는 노동자 * 자세한 사항은 첨부파일 참고',
      Col14: '2022-01-03~2022-03-25',
      Col15: '사업장 소재지 시.군청 담당부서 방문 또는 우편접수',
      Col16: '대학생 45명 정도',
      Col17: '월평균 가구소득이 중위소득보다 많은 경우노동자 자녀 장학금을 수헤 받은 적이 있는 경우신청년도에 다른 장학금 또는 학비감면액이 노동자자녀 장학금보다 많을 경우 퇴학/정학/휴학그 밖에에 도지사의 판단 * 자세한 사항은 첨부파일 참고',
      Col18: '시장.군수의 추천을 받아 도지사가 정함',
      Col19: '지급 신청서신청 확인서 각 1부 (학교/회사)개인정보이용동의서 1부기타 증빙서류'
    },
    {
      Col1: '제주특별자치도청',
      Col2: '학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2021년 하반기(2021. 7. 1. ~ 12. 31.) 발생이자 전액  * 2010년부터 한국장학재단을 통해 대출받은 취업 후 상환 학자금 일반상환학자금 생활비 대출 이자 100%지원',
      Col12: '2021년 2학기 기준준 대학교 및 대학원 재학생/ 휴학생/ 졸업(중·자퇴·수료포함) 후 10년 이내의 미취업자  취업 후 상환 학자금(든든학자금)/ 일반상환 학자금 대출받은 자 ',
      Col13: '도내 주민등록이 되어 있거나 도내 고등학교를 졸업한 사람',
      Col14: '2022-03-03~2022-03-28',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '타 시·도 및 기관에서 사전 지원을 받은 경우이자지원 전 전액 상환된 대출건',
      Col18: '해당없음',
      Col19: '  * 도내 홈페이지에서 온라인 신청/ 자세한 사항은 홈페이지 참조 [ 재학생 및 휴학생]재학(휴학) 증명서주민등록초본(도외 고등학교 졸업자) [졸업생 (수료·중퇴·자퇴) ] 졸업(수료·중퇴·자퇴) 증명서건강보험자격득실확인서주민등록초본(도외 고등학교 졸업자) * 제주도청 홈페이지 온라인 신청 또는 학자금 대출이자 지원신청 홈페이지 접속 신청청'
    },
    {
      Col1: '제주특별자치도청',
      Col2: '청소년육성기금(어려운청소년)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '경제적으로 어려운자',
      Col11: '2000000원 이내',
      Col12: '「국민기초생활 보장법」에 따른 국민기초생활 수급자인 대학생「한부모가족지원법」에 따른 한부모가족복지시설에 있는 한부모가족의 자녀인 대학생「청소년복지지원법」에 따른 청소년복지지원시설에 입소 중인 대학생',
      Col13: '본인이나 그 보호자가 제주자치도에 거주하는 사람중 붙임(별표) 선정기준에 적합한 청소년 ※ 청소년이라 함은 청소년기본법 제3조에 해당하는 자(924세)를 말함 ',
      Col14: '2022-03-03~2022-03-28',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '중복지급의 금지다른 법령이나 조례/ 그 밖에 다른 기금 또는 다른 기관 등에서 장학금 지원을 받은 자단/ 장학금 지원을 이미 받은 자가 제주특별자치도 청소년 육성 및 지원 조례 시행규칙 제16조에 따른 장학금 보다 적은 경우에는 그 차액만큼 지급할 수 있음기타 지급의 정지(시행규칙 제17조) ',
      Col18: '행정시장/ 청소년복지시설에 입소중인 대학생은 공고일 전일까지 입소중인 자로서 해당 쉼터 소장의 추천을 받은자 ',
      Col19: '국민기초생활보장수급자증명서 또는 한무보가족지원시설 입소자 증명서수업료납입영수증통장사본(부모 또는 학생본인) ※ 자세한 사항은 해당 기관 공고문 확인 요망'
    },
    {
      Col1: '제주특별자치도청',
      Col2: '청소년육성기금(의용소방자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '품행이 단정하고 입학 또는 재학 중 학과성적이 재적학년 정원의 100분의 50이내인 자품행이 단정하고 기능/ 체육/ 예능에 소질과 재능이 뛰어난 자 ',
      Col10: '중위소득 120% 이하',
      Col11: '2000000원 이내',
      Col12: '제주특별자치도 의용소방대원(여성 의용소방대원 포함)으로 3년 이상 근속한 자의자녀로서 경제적으로 어려워 대학 교육을 받기 어려운 자로서 다음 각 호의어느 하나에 해당하는 자1) 품행이 단정하고 입학 또는 재학 중 학과성적이 재적 학년 정원의 100분의 50이내인 자2) 품행이 단정하고 기능/ 체육/ 예능에 소질과 재능이 뛰어난 자',
      Col13: '공고일 기준준 제주에 주소를 둔 자 중 아래의 자 지원 가능부모 중 한명 이상이 제주도에 주소를 두고 있는 자장학금 지원 대상 본인이 제주도에 주소를 두고 있는 자',
      Col14: '2022-03-03~2022-03-28',
      Col15: '해당없음',
      Col16: '관할 대원수의 7%',
      Col17: '중복지급의 금지다른 법령이나 조례/ 그 밖에 다른 기금 또는 다른 기관 등에서 장학금 지원을 받은 자단/ 장학금 지원을 이미 받은 자가 제주특별자치도 청소년 육성 및 지원 조례 시행규칙 제16조에 따른 장학금 보다 적은 경우에는 그 차액만큼 지급할 수 있음',
      Col18: '소방서',
      Col19: '부모의 근속경력을 확인할 수 있는 서류 (소속기관/ 단체장 확인서)수업료납입영수증건강보험료 납입확인서(부/모 모두): 2월성적증명서(50/100이내 또는 5등급 이상)   또는 공공기관이 개최한 대회에서 입상을 증명하는 서류주민등록등본통장사본(부모 또는 학생본인)'
    },
    {
      Col1: '제주특별자치도청',
      Col2: '청소년육성기금(모범청소년)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '품행이 단정하고 입학 또는 재학 중 학과성적이 재적학년 정원의 100분의 20이내인 자',
      Col10: '중위소득 120% 이하',
      Col11: '2000000원 이내',
      Col12: '품행이 단정하고/ 경제적으로 어려워 고등학교나 대학 교육을 받기 어려운 학생으로서 다음 각 호의 어느 하나에 해당하는 자1) 입학 또는 재학 중 학과성적이 재적학년 정원의 100분의 20이내의 자2) 기능/ 체육/ 예능에 소질과 재능이 뛰어난 학생',
      Col13: '공고일 기준 제주에 주소를 둔 자 중 아래의 자 지원 가능부모 중 한명 이상이 제주도에 주소를 두고 있는 자장학금 지원 대상 본인이 제주도에 주소를 두고 있는 자',
      Col14: '2022-03-03~2022-03-28',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '중복지급의 금지다른 법령이나 조례/ 그 밖에 다른 기금 또는 다른 기관 등에서 장학금 지원을 받은 자단/ 장학금 지원을 이미 받은 자가 제주특별자치도 청소년 육성 및 지원 조례 시행규칙 제16조에 따른 장학금 보다 적은 경우에는 그 차액만큼 지급할 수 있음',
      Col18: '읍/면/동장대학교총(학)장',
      Col19: '수업료납입영수증건강보험료 납입확인서(부/모 모두)성적증명서(20/100이내 또는 2등급 이상)   또는 공공기관이 개최한 대회에서 입상을 증명하는 서류주민등록등본통장사본(부모 또는 학생본인)'
    },
    {
      Col1: '제주특별자치도청',
      Col2: '청소년육성기금(의사상자자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '중위소득 120% 이하하',
      Col11: '2000000원 이내',
      Col12: '제주특별자치도 의사상자 예우 및 지원에 관한 조례 제2조에서 정의한 의사상자 유족 및 가족 중 경제적으로 어려운 자의 자녀',
      Col13: '공고일 기준 제주에 주소를 둔 자 중 아래의 자 지원 가능부모 중 한명 이상이 제주도에 주소를 두고 있는 자장학금 지원 대상 본인이 제주도에 주소를 두고 있는 자',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '중복지급의 금지다른 법령이나 조례/ 그 밖에 다른 기금 또는 다른 기관 등에서 장학금 지원을 받은 자단/ 장학금 지원을 이미 받은 자가 제주특별자치도 청소년 육성 및 지원 조례 시행규칙 제16조에 따른 장학금 보다 적은 경우에는 그 차액만큼 지급할 수 있음',
      Col18: '읍/면/동장대학교총(학)장',
      Col19: '수업료납입영수증건강보험료 납입확인서(부/모 모두)주민등록등본통장사본(부모 또는 학생본인)'
    },
    {
      Col1: '제주특별자치도청',
      Col2: '청소년육성기금(장애인/다문화)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '중위소득 120% 이하',
      Col11: '2000000원',
      Col12: '장애인복지법에 의해 등록된 중증 장애인 가족(1/2급)다문화가족지원법 제2조에서 정의한 다문화가족',
      Col13: '공고일 기준 제주에 주소를 둔 자 중 아래의 자 지원 가능부모 중 한명 이상이 제주도에 주소를 두고 있는 자장학금 지원 대상 본인이 제주도에 주소를 두고 있는 자',
      Col14: '2022-03-03~2022-03-28',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '중복지급의 금지다른 법령이나 조례/ 그 밖에 다른 기금 또는 다른 기관 등에서 장학금 지원을 받은 자단/ 장학금 지원을 이미 받은 자가 제주특별자치도 청소년 육성 및 지원 조례 시행규칙 제16조에 따른 장학금 보다 적은 경우에는 그 차액만큼 지급할 수 있음',
      Col18: '읍/면/동장',
      Col19: '장애인증명서(중증장애인 가족)가족관계증명서(다문화가족)주민등록등본건강보헙료 납입확인서(부/모 모두): 2월수업료납입영수증통장사본(부모 또는 학생본인)'
    },
    {
      Col1: '제주특별자치도청',
      Col2: '청소년육성기금(방재단원자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '중위소득 120% 이하하',
      Col11: '2000000원 이내',
      Col12: '제주특별자치도 지역자율방재단원으로 3년 이상 근속한 자의 자녀로서 경제적으로어려워 대학 교육을 받기 어려운 자로서 다음 각 호의 어느 하나에 해당하는 자1) 품행이 단정하고 입학 또는 재학 중 학과성적이 재적 학년 정원의 100분의 50이내인 자2) 품행이 단정하고 기능/ 체육/ 예능에 소질과 재능이 뛰어난 자',
      Col13: '공고일 기준 제주에 주소를 둔 자 중 아래의 자 지원 가능부모 중 한명 이상이 제주도에 주소를 두고 있는 자장학금 지원 대상 본인이 제주도에 주소를 두고 있는 자',
      Col14: '2022-03-03~2022-03-28',
      Col15: '해당없음',
      Col16: '행정시 지역자율방재단원수의 7%',
      Col17: '중복지급의 금지다른 법령이나 조례/ 그 밖에 다른 기금 또는 다른 기관 등에서 장학금 지원을 받은 자단/ 장학금 지원을 이미 받은 자가 제주특별자치도 청소년 육성 및 지원 조례 시행규칙 제16조에 따른 장학금 보다 적은 경우에는 그 차액만큼 지급할 수 있음',
      Col18: '행정시지역자율방재단',
      Col19: '부모의 근속경력을 확인할 수 있는 서류(소속기관/ 단체장 확인서)수업료납입영수증건강보험료 납입확인서(부/모 모두) : 2월성적증명서(50/100이내 또는 5등급 이상)   또는 공공기관이 개최한 대회에서 입상을 증명하는 서류주민등록등본통장사본(부모 또는 학생본인)'
    },
    {
      Col1: '제주특별자치도청',
      Col2: '청소년육성기금(지도위원자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '품행이 단정하고 입학 또는 재학 중 학과성적이 재적학년 정원의 100분의 50이내인 자품행이 단정하고 기능/ 체육/ 예능에 소질과 재능이 뛰어난 자 ',
      Col10: '중위소득 120% 이하',
      Col11: '2000000원 이내',
      Col12: '청소년지도위원으로 2년 이상 활동한 현직 청소년지도위원의 자녀로 경제적으로 어려워 고등학교 및 대학교육을 받기 어려운 다음 각 호의 어느 하나에 해당하는 사람품행이 단정하고 입학 또는 재학 중 학과성적이 재적학년 정원의 100분의 50이내인 자품행이 단정하고 기능/ 체육/ 예능에 소질과 재능이 뛰어난 자',
      Col13: '공고일 기준 제주에 주소를 둔 자 중 아래의 자 지원 가능부모 중 한명 이상이 제주도에 주소를 두고 있는 자장학금 지원 대상 본인이 제주도에 주소를 두고 있는 자',
      Col14: '2022-03-03~2022-03-28',
      Col15: '해당없음',
      Col16: '행정시 협의회회원의 7%이내',
      Col17: '중복지급의 금지다른 법령이나 조례/ 그 밖에 다른 기금 또는 다른 기관 등에서 장학금 지원을 받은 자단/ 장학금 지원을 이미 받은 자가 제주특별자치도 청소년 육성 및 지원 조례 시행규칙 제16조에 따른 장학금 보다 적은 경우에는 그 차액만큼 지급할 수 있음',
      Col18: '행정시청소년지도협의회',
      Col19: '부모의 근속경력을 확인할 수 있는 서류(소속기관/ 단체장 확인서)수업료납입영수증건강보험료 납입확인서(부/모 모두) : 2월성적증명서(50/100이내 또는 5등급 이상)   또는 공공기관이 개최한 대회에서 입상을 증명하는 서류주민등록등본통장사본(부모 또는 학생본인)'
    },
    {
      Col1: '제주특별자치도청',
      Col2: '청소년육성기금(새마을지도자자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '품행이 단정하고 입학 또는 재학 중 학과성적이 재적학년 정원의 100분의 50이내인 자품행이 단정하고 기능/ 체육/ 예능에 소질과 재능이 뛰어난 자 ',
      Col10: '중위소득 120% 이하',
      Col11: '2000000원 이내',
      Col12: '새마을운동에 2년 이상 봉사한 현직 새마을지도자의 자녀로 경제적으로 어려워 고등학교 및 대학교육을 받기 어려운 다음 각 호의 어느 하나에 해당하는 자. 다만/ 다음의 제1호에 해당하는 경우 지도자의 경력을 요하지 않는다. 1) 새마을사업의 유공자인 새마을지도자의 자녀 또는 새마을 사업    수행 중 사망 또는 부상을 입은 전·현직 새마을지도자의 자녀',
      Col13: '공고일 기준 제주에 주소를 둔 자 중 아래의 자 지원 가능부모 중 한명 이상이 제주도에 주소를 두고 있는 자장학금 지원 대상 본인이 제주도에 주소를 두고 있는 자',
      Col14: '2022-01-03~2022-01-14',
      Col15: '해당없음',
      Col16: '행정시 지도자수의 7%이내',
      Col17: '중복지급의 금지다른 법령이나 조례/ 그 밖에 다른 기금 또는 다른 기관 등에서 장학금 지원을 받은 자단/ 장학금 지원을 이미 받은 자가 제주특별자치도 청소년 육성 및 지원 조례 시행규칙 제16조에 따른 장학금 보다 적은 경우에는 그 차액만큼 지급할 수 있음',
      Col18: '새마을운동 행정시지회',
      Col19: '부모의 근속경력을 확인할 수 있는 서류(소속기관/ 단체장 확인서)유공새마을지도자의 경우/ 확인할 수 있는 표창 등 사본수업료납입영수증건강보험료 납입확인서(부/모 모두) : 2월성적증명서(50/100이내 또는 5등급 이상)   또는 공공기관이 개최한 대회에서 입상을 증명하는 서류   또는 행정시장 이상의 표창 수상자임을 증명하는 서류주민등록등본통장사본(부모 또는 학생본인)'
    },
    {
      Col1: '국가보훈처',
      Col2: '제대군인대부지원(나라사랑대출)',
      Col3: '관계부처',
      Col4: '학자금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '학기당 5000000원 한도내에서 실제소요(입학금 수업료) 금액 지원※ 신청전 한국장학재단 학자금 지원사업의 내용을 확인한 후 대부지원 신청 여부 최종 선택 필요 대부지원 후 이중 수혜자로 확인될 경우 일시 상환 조치 됨※ 연 이율 2.9% / 상환기간: 5년 ',
      Col12: '국가보훈처 등록 10년이상 장기복무 제대군인본인 또는 자녀가 전문대학 이상(대학원 포함)에 입학 또는 제학 중인 자 (가구당 신청인원 제한 없음)고등교육법 제2조의 대학/ 산업대학/ 교육대학/ 전문대학/ 방송통신대학/ 사이버대학/ 기술대학/ 각종학교',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학 학자금 대부제도를 운용하고 있는 기관 또는 단체로부터 동일 학기 학자금 대부를 지원 받았거나 지원받을 예정인 자* 자세한 내용은 첨부파일 참고 필수',
      Col18: '해당없음',
      Col19: '등록금 고지서 또는 등록금 납부영수증* 전국 국민은행 영업지점/수시 신청* 신용관리 대상자의 경우 주소지 관할 보훈(지)청에서 직접 대부 실시'
    },
    {
      Col1: '국가보훈처',
      Col2: '보훈장학금(대학원장학)',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/전문대학원',
      Col7: '박사과정/석사2학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학원 석/박사과정 재학자로서 직전학기 성적이 90점 이상인 자.',
      Col10: '해당없음',
      Col11: '학기당 최고 115만원(수업료 실 납부액 범위 내 지원)',
      Col12: ' * 보훈법령에 따라 교육지원을 받는 본인 및 배우자국가유공자 본인/배우자(순직/전몰자의 배우자)고엽제후유의증환자(수당지급대상자)5.18민주유공자 본인/배우자(사망/행방불명자의 배우자)특수임무유공자 본인/배우자(사망/행방불명자의 배우자)  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: ' * 선발우선순위가 대상별로 다름/ 첨부파일 확인 바람',
      Col16: '00명',
      Col17: '대학원 정기학기 중 최초학기 (첫 학기)대학원 해당과정 수업연한 초과자 (수업연한에 포함되어 있는 논문학기경우는 지원)연구과정 및 해외유학 과정정',
      Col18: '해당없음',
      Col19: '보훈장학신청서개인정보 이용 및 제공 사전동의서직전학기 성적증명서재학증명서수업료 납입증명서선발 우선순위 증빙자료 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '국가보훈처',
      Col2: '보훈장학금(특수장학)',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적 제한 없음',
      Col10: '해당없음',
      Col11: '학기당 30만원 ',
      Col12: '보훈법령에 의한 교육지원대상자 중 「장애인 등에 대한 특수교육법」의 특수교육대상자로 특수학교 또는 일반학교에 재학 중인 자',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '직전학기 탈락자 > 직전학기 신청하지 못한 자 > 나이가 많은 자 순으로 선발 ',
      Col16: '00명 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '보훈장학 신청서개인정보 이용 및 제공 사전 동의서특수교육대상자 배치 결과통지서 * 자세한 내용은 홈페이지 확인 바람'
    },
    {
      Col1: '국가보훈처',
      Col2: '보훈가족장학금',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학생 재학자로 직전학기 성적이 70점 이상인 자 (신입생은 성적기준 제외)',
      Col10: '해당없음',
      Col11: '학기당 최고 900000원 * 보훈장학의 경우 실제 납부한 수업료가 장학금 지급액보다 적은 경우 수업료 실납부액만 지원',
      Col12: '6·25전물군경자녀의 자녀로서 대학 재학자 * 신청대상은 1953년 7월 27일 이전 및 「참전유공자예우에 관한 법률」별표에 따른 전투기간 중에 전사하거나 순직한 국가유공자의 손자녀',
      Col13: '해당없음',
      Col14: '2022-08-04~2022-08-24',
      Col15: '제출서류를 재학하고 있는 학교 소재직 관할 보훈(지)청에 제출 선발우선순위 : 생활이 어려운 자> 6.25 전몰유자녀가 대학교육 지원을 받지 못한 자> 6.25전몰유자녀가 대학교육 지원을 받은 사람  * 자세한 내용은 홈페이지 확인 바람',
      Col16: '00명 ',
      Col17: '국가유공자의 전공사상 시기가 6.25가 아닌 경우(대학교) 재학 학교 학칙에서 정한 수업연한 초과자당해 학기에 본인이 납부한 수업료가 없는 경우 (타 장학금 수령 포함)',
      Col18: '해당없음',
      Col19: '보훈가족신청서(서식)개인정보 이용 및 제공 사전동의서재학증명서직전학기 성적증명서 (백분율 환산 점수기재)(단/ 신입생은 성적증명서 제출생략)수업료 납입증명서(당해년도 당해학기)주민등록등본신청자의 통장사본(저소득자) 기초생활수급증명서/ 차상위계층 확인서 각 1부'
    },
    {
      Col1: '보건복지부',
      Col2: '공중보건장학제도',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대학원/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/석사2학기이상/석사신입생(1학기)',
      Col8: '의약계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '의과대학생 1인당 10200000원/학기간호대학생 1인당 8200000원/학기',
      Col12: '전국 의과대학(의학전문대학원) 및 간호대학(간호학과) 재학생공공보건의료 분야에 사명감과 열정을 갖춘 학생장학생을 대상으로 운영하는 각종 교육 및 멘토링 활동에 성실히 참여하고/ 졸업 후 장학금을 지원받은 기간만큼 의무적으로 해당 광역 지자체 공공보건의료기관에서 의무근무(최소 2년 ~ 최대 5년)',
      Col13: '해당없음',
      Col14: '2022-09-26~2022-10-11',
      Col15: '내·외부 전문가로 선발위원회를 구성하여 면접평가(30점)와 서류평가(70점)를 실시',
      Col16: '의과(의학전문대학원)대학 재학생 10명/ 간호대학(간호학화) 재학생 00명',
      Col17: '해당없음',
      Col18: '공중보건장학생 추천서',
      Col19: '장학생 지원서포트폴리오성적증명서(신입생은 생략가능)고등학교 졸업증명서 * 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인은평구민장학재단',
      Col2: '일반장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생: 직전학기 학업성적 평점 4.5(100점) 만점에 3.0 이상인 자신입생: 고등학교 3학년 2학기 성적 사위 40% 이내/ 검정고시 80점 이상',
      Col10: '한국장학재단 소득구간 8구간 이내(해당학기)',
      Col11: '최대 2000000원 이내 * 등록금 범위 이내 지원',
      Col12: '공고일 현재 2년 이상 거주하고 있는 대학교 재학생으로/ 성적이 우수한 자 (신입생 포함)',
      Col13: '공고일 현재 은평구에 2년 이상 계속 거주(주민등록기준)하고 있는 대학생',
      Col14: '2021-02-01~2021-02-08',
      Col15: '장학생선정심사위원회에서 선발',
      Col16: 'OO명',
      Col17: '등록금 본인 납입금액이 50만원 이하인 자기초생활수급자의 경우 학교에서 지급되는 교내 복지장학금을 우선 신청하길 바라며/ 이중 수혜시 장학금 반환분야 중복신청 불가1세대당 1명 선발정규학기 초과자 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서 및 개인정보 수집·이용·제공 및 조회 동의서주민등록등본 주민등록초본재학증명서성적증명서소득구간(분위)통지서등록금 입증서류장학금 수혜 증명서가점증빙서류통장 사본 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인은평구민장학재단',
      Col2: '지역사회기여장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 평점 4.5점 만점에 3.0이상인자',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '청소년들의 학습지도/진로상담 등 멘토링을 할 수 있는 학생최소 6개월 이상 활동 가능한 학생서울 및 인근 수도권 소재 대학교 재학생',
      Col13: '공고일 현재 은평구에  계속 거주(주민등록기준)하고 있는 서울 및 인근 수도권 소재 대학교 재학생',
      Col14: '2022-02-28~2022-03-11',
      Col15: '1차 서류심사: 지원자의 자격요건 등 소정의 기준 적합여부 서면심사2차 면접심사: 봉사정신/ 성실성/ 책임성/ 지도능력 등 활동수행에 필요한 능력 심사 ',
      Col16: '25명',
      Col17: '신청일 현재 졸업이 1학기만 남은 자는 선발에서 제외',
      Col18: '해당없음',
      Col19: '지역사회 기여 장학생 지원 신청서 개인정보동의서주민등록등본통장사본(신청학생 본인)재학증명서최근 1년간 성적증명서 1부 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 동래장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학교 신입생의 경우 수능성적을 기준으로 선발',
      Col10: '생활정도는 보호자(부모 모두)의 재산과 소득상황을 각각 반영',
      Col11: '본인부담액 등록금 범위 내(2000000원)에서 지급',
      Col12: '해당없음',
      Col13: '신청일 현재 학부모와 학생이 동래구에 1년 이상 주민등록이 되어 있으며 사실상 거주하고 있는 대학생',
      Col14: '2022-09-06~2022-10-05',
      Col15: '학업성적 60%/ 생활정도 40%를 반영하여 합산점수가 80점 이상인 자',
      Col16: '20명',
      Col17: '학생이 퇴학 또는 휴학하였을 때사회 통념상 학생의 품행이 극히 불량하다고 인정될 경우지급 목적과 다르게 사용한 경우부·모의 학자금/ 국가/ 지자체/ 해당학교/ 타 장학금으로 등록금 이상의       금액을 초과하여 수혜를 받은 경우',
      Col18: '해당없음',
      Col19: '장학금 신청서추천서주민등록등본가족관계증명서(부·모 기준)성적증명서(본교 : 2021년 기준)  대학 신입생 : 수능성적표[수능성적표가 없을 경우/ 고3성적증명서로 대체]입학금 및 학비 납부고지서(대학 신입생 및 재학생)전년도 건강보험 납부확인서 및 자격확인서  부·모 각자 가입 시 각각 제출  건강보험관리공단 발급  소득 무 : 사실증명원재산 증빙서류  주택 소유공시지가 확인서/                    주택가격확인서(공동주택가격확인서)  무료거주 인 경우 : 무료임대확인서     수급자 증명서 또는 한부모 증명서장애인증명서(본인기준)부채증명서(해당자에 한함)개인정보 수집·이용·제공 및 조회 동의서 신청인 서약서 통장사본(선발자된 자에 한함) '
    },
    {
      Col1: '(재)부산북구장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평점 B학점 이상',
      Col10: '해당없음',
      Col11: '최대 2000000원',
      Col12: '부산광역시 북구 관내 거주 대학생으로 학업성적 우수자 등',
      Col13: '신청일 현재 부산광역시 북구 관내 3년 이상 계속 거주자(세대주/ 보호자)의 자녀',
      Col14: '2021-12-20~2022-01-05',
      Col15: '해당없음',
      Col16: '22명 내외',
      Col17: '기타 타기관으로부터 전액 장학금을 받고 있는 자대학 졸업예정자(대학 최종 학기 등록자)가구(보호자 합산) 연소득 9/600만원 이상인 세대부동산 및 동산 합계액에서 부채를 제외한 합계 10억원 이상 보유 가구(보호자 합산)',
      Col18: '해당없음',
      Col19: '장학금 신청서개인정보 수집/이용/제공 및 조회 동의서건강보험료 납입증명서직장년도 근로소득원천징수영수증(해당자)임대차계약서재학증명서성적증명서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '(재)행복영도장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 3000000원',
      Col12: '학업우수 : 학년 교과목 성적이 상위 20% 이내인 학생생계곤란 : 기준에 미달하더라도 경제적 이유로 학업이 곤란한 자특기 : 문화/예술/체육/과학 기능분야에 소질과 재능이 뛰어난 학생으로서 시 단위 이상의 대회에서 1위 입상 또는 자격 취득자',
      Col13: '공고일 현재 6개월 이상 부산시 영도구 거주하는 재학생',
      Col14: '2022-03-10~2022-03-31',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '국가/ 지방자치단체/ 학교 타 기관 등으로부터 장학금을 받고 있는 학생 또는 받을 예정인 학생 ',
      Col18: '학교장/동장 추천',
      Col19: '장학생 지원 신청서성적증명서개인정보 수집·이용 동의서신청인 서약서지적전산자료이용 위임장재산세 과세내역서소득증빙서류특기자 증명서기타 증명서무주택 증명서주민등록 등본재학증명서 '
    },
    {
      Col1: '재단법인 동구교육발전장학회',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학기당 12학점 이상 이수자(계절학기 미 포함)직전학기 평점평균 4.5만점 기준 3.8점 이상인 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '국내대학에 재학 중인 자',
      Col13: '대구광역시 동구에서 출생하였거나/ 공고일 현재 계속하여 2년 이상  동구에 주민등록을 두고 거주한 자 ',
      Col14: '2022-03-10~2022-03-31',
      Col15: '동점자 발생/ 미달 분야 발생 등 선발에 관한 예기치 못한 사유 발생시 장학생 선발 심의회에서 결정',
      Col16: '해당없음',
      Col17: '대학생은 2022년도 1학기 휴학생 제외1세대 1명으로 제한',
      Col18: '총학장/ 학교장 ',
      Col19: '장학금 지원 신청서 재학증명서성적증명서주민등록초본자기소개서개인정보 수집이용제공 및 조회동의서통장사본지원 대상 추천서등록금 납입 확인서  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 동구교육발전장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '국내 대학에 재학 중인 자선발분야 : 체육/ 음악/ 미술/ 과학/ 기능신청자격 : 직전 1년간 광역시 및 도단위 이상 규모의 공공기관이  주최(주관)하는 대회에서 3위 이내의 성적으로 입상한 자',
      Col13: '대구광역시 동구에서 출생하였거나/ 공고일 현재 계속하여 2년 이상  동구에 주민등록을 두고 거주한 자 ',
      Col14: '2022-04-01~2022-04-15',
      Col15: '동점자 발생/ 미달 분야 발생 등 선발에 관한 예기치 못한 사유 발생시 장학생 선발 심의회에서 결정상위대회 (국제대회 > 전국대회 > 광역시·도 단위 대회)',
      Col16: '해당없음',
      Col17: '2022학년 1학기 휴학생 제외1세대 1명으로 제한',
      Col18: '학교장/ 총장 추천학교당 1명만 추천가능',
      Col19: '장학금 지원 신청서재학증명서성적증명서주민등록초본자기소개서개인정보 수집이용제공 및 조회동의서통장사본지원 대상 추천서대회수상 실적서입상자료 사본  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 대구광역시서구인재육성재단',
      Col2: '희망 장학생 ',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2020년 2학기 12학점 이상 이수자로서 100점 만점의 평균 70점 이상 * 1학년일 경우 2020년 2학기 이수과목의 50% 이상이 5등급 이상',
      Col10: '2021년 기준중위소득 이내재산총액이 2억원 이하 ',
      Col11: '당해학기 등록금에서 타장학금 수혜금액을 차감하고 최대150만원/1인지급',
      Col12: '신청일 현재 가구원 반 이상이 1년 이상 대구광역시 서구에 계속 거주한 자 중 기초생활보장수급자',
      Col13: '신청일 현재 가구원 반 이상이 1년 이상 대구광역시 서구에 계속 거주한 자',
      Col14: '2022-04-01~2022-04-15',
      Col15: '재산조회심의확정 : 서류심사/ 이사회 심의장학금전달',
      Col16: 'O명 (초·중·고등학생 포함 40명 내외)',
      Col17: '당해 학기 타 장학금 또는 학비 감면의 수혜를 받은 자2021년도 휴학생 또는 복학생정규학기 초과 재학생사이버대학/ 방송통신대학/ 기능대학/ 기술대학 등 제외 ',
      Col18: '해당없음',
      Col19: '장학생신청서장학생 추천서개인(신용)정보조회서 및 서약서성적증명서(직전학기) (담당자 날인)고등학교 3학년 내신성적 (신입생)  * 백분율로 환산할 것등록금 영수증 사본동장사실조사서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 대구광역시서구인재육성재단',
      Col2: '성적우수 장학생 ',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2020년도 2학기 12학점 이상 이수자로서 100점 만점의 평균 90점 이상 ',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '전문대학 및 4년제 대학 재학생',
      Col13: '신청일 현재 가구원 반 이상이 1년 이상 대구광역시 서구에 계속 거주한 자',
      Col14: '2021-10-01~2021-10-15',
      Col15: '재산조회심의확정 : 서류심사/ 이사회 심의장학금전달',
      Col16: 'OO명(초·중·고 포함인원 40명 내외)',
      Col17: '당해 학기 타 장학금 또는 학비 감면의 수혜를 받은 자 2021년도 휴학생 또는 복학생정규학기 초과 재학생사이버대학/ 방송통신대학/ 기능대학 등 제외 ',
      Col18: '대학교 총장의 추천필요',
      Col19: '성적우수 장학생 신청 및 추천서품행 및 장학금 수혜여부 확인서개인정보 수집이용제공 및 조회 도으이서2021년 1학기 교육비 납입 증명서2020년 2학기 성적증명서재학증명서대상자 주민등록 등본 1부  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 대전광역시서구인재육성장학재단',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원(1인당)',
      Col12: '대전광역시 소재 대학교 재학생예능/ 체육/ 과학/ 문학 등 분야의 국내 전국대회 및 국제대회에서 장학생 선발 공고일 기준 최근 1년 이내에 3위 이내의 성적을 득한 학생',
      Col13: '선발공고일 현재 계속하여 6개월 이상 대전광역시 서구에 거주하고 있는 학생',
      Col14: '2022-04-11~2022-05-06',
      Col15: '신청 및 접수적격검토 및 자격심사선정심사위원회 개최최종 선정대상자 확정선정결과 통보장학증서 수여',
      Col16: '3명',
      Col17: '공고일 기준 1년 이내 장학금 수혜자(종류에 관계없이)예선대회 및 비공인 단체가 주최한 대회 입상자일반적으로 대회 참가자가 소수이거나 전국 규모에 못 미치는 경우광역자치단체 이하 단위 기관 및 상위단체가 아닌 관련 단체지부 등에서 단독 주최 및 후원한 대회 입상자 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서(반명함판 사진 부착)장학생 추천서주민등록등본서약서개인정보 수집/ 이용/ 제공 및 조회 동의서통장사본재학증명서각종 대회 입상 증명서 및 대회요강 사본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)옹진군인재육성재단',
      Col2: '인재장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 대학수학 능력평가 결과 (언어/ 수리/ 외국어/ 탐구영역 중 1) 5등급 이내인자 또는 내신등급 평균 5등급 이내인 자재학생 : 직전학기 15학점 이상 이수하고 평균평점이 B(3.0/4.5만점) 이상인자 (*단 4학년은 10학점이상 이수한자)검정고시자 : 7과목 평균 80점 이상',
      Col10: '해당없음',
      Col11: '학기별 등록금 전액 (500만원 이내 지원)',
      Col12: '교육부장관이 인가한 2년제 이상 대학교의 대학생(대학원생 제외)',
      Col13: '공고일을 기준으로 본인이나 친권자가 옹진군에 주민등록을 두고 5년 이상 실거주한 자관내 소재 초/ 중/ 고 통합 3년 이상 재학 경력이 있는 자 * 자세한 사항은 첨부자료 참고 필수',
      Col14: '2022-04-11~2022-05-06',
      Col15: '서류심사(상세 평가 기준은 첨부파일 참고)',
      Col16: '00명',
      Col17: '휴학이나 유학 예정자와 유학중인 자/ 사이버대/ 학점은행제 대학 등은 제외대학원생 제외',
      Col18: '해당없음',
      Col19: '학자지원금 신청서 및 지원신청서재학증명서성적증명서 (*신입생:수능시험성적표 또는 고교 직전학기 성적증명서) (*재학생:직전학기 성적증명서 / 편입생은 편입 전 학교 성적증명서)주민등록 등본 및 초본 (주소 변동사항이 기록된 것)가족관계등록부(학생기준)실거주 확인서개인정보 수집/이용/제공 및 조회 동의서등록금 납입증명서통장사본생활기록부서약서* 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '(재)옹진군인재육성재단',
      Col2: '특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1학기 등록금 전액 (500만원 이내 지원)',
      Col12: '2년제 이상 대학교의 대학생(대학원생 제외)장학금 신청 공고일 기준 최근 1년 이내 예체능/ 문학/ 과학 등에서 능력이 뛰어나거나 국가가 인정하는 기관 또는 단체에서 주최한 전국 규모 이상의 대회에서 3위 이상의 성적으로 입상한 자또는 모범/ 효행/ 선행/ 지역발전 유공 등 분야에서 지방자치단체장 이상의 상을 받은 자',
      Col13: '공고일을 기준으로 본인이나 친권자가 옹진군에 주민등록을두고 5년 이상 실거주한 자관내 소재 초/ 중/ 고 통합 3년 이상 재학 경력이 있는 자 * 자세한 사항은 첨부자료 참고 필수',
      Col14: '2022-04-11~2022-05-06',
      Col15: '서류심사(상세 평가 기준은 첨부파일 참고)',
      Col16: '00명',
      Col17: '휴학이나 유학 예정자와 유학중인 자/ 사이버대/ 학점은행제 대학 등은 제외대학원생 제외',
      Col18: '한국과학기술원생으로 지원 시 원장의 추천 필요',
      Col19: '학자 지원금 신청서 및 지원 신청서실거주 확인서개인정보 수집이용제공 및 조회 동의서 서약서추천서 (해당자)재학증명서성적증명서 ( 신입생 : 대학수학능력시험성적표 또는 고교 직전학기 성적증명서/ 재학생 : 직전학기 성적증명서 / 편입생일 경우 편입 전 학교 성적증명서)주민등록 등본 및 초본가족관계등록부등록금납입증명서생활기록부통장사본 입상/ 공연 등 입증자료한국과학기술원생으로 원장의 추천서류국가유공증명서 및 시·군·구 단위 이상 기관 또는 단체의 표창이나 공로 인증서류효행·선행·모범 등에 공이 있는 입증자료 사본 1부 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '(재)옹진군인재육성재단',
      Col2: '복지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생: 대학수학능력평가 결과 (언어/ 수리/ 외국어/ 탐국영역 중 1) 7등급 이내인 자 또는 고등학교 내신등급 평균 7등급 이내인 자재학생: 직전학기 15학점 이상 이수 및 4.5만점 기준으로 평균 평점이 C+(2.5)학점 이상인자 (단/ 4학년은 10학점이상 이수한 자)검정고시자는 7과목 평균이 70점 이상인 자',
      Col10: '국민기초생활보장법에 의한 기초생활수급자 및 차상위 계층 장애인 복지법상 장애의 정도가 심한 장애인에 해당하는 세대의 자녀나 본인',
      Col11: '학기별 등록금 전액 (500만원 이내 지원)',
      Col12: '해당없음',
      Col13: '공고일을 기준으로 본인이나 친권자가 옹진군에 주민등록을두고5년 이상 실거주한 자관내 소재 초·중·고 통합 3년 이상 재학 경력이 있는 자 * 자세한 사항은 첨부자료 참고 필수 ',
      Col14: '2022-04-11~2022-05-06',
      Col15: '서류심사(상세 평가 기준은 첨부파일 참고)',
      Col16: '00명',
      Col17: '휴학이나 유학 예정자와 유학중인 자/ 사이버대/ 학점은행제 대학 등은 제외대학원생 제외',
      Col18: '해당없음',
      Col19: '학자지원금 신청서 및 지원신청서실거주 확인서개인정보 수집·이용·제공 및 조회 동의서서약서재학증명서성적증명서 (*신입생:수능시험성적표 또는 고교직전학기 성적증명서) (*재학생:직전학기 성적증명서 /편입생은 편입 전 학교 성적증명서)주민등록 등본 및 초본 (주소 변동사항이 기록된 것)가족관계등록부(학생기준)등록금 납입증명서생활기록부통장사본건강보험료 증명서류 (부/모 모두 제출)노동능력 증명서류(해당자)가족상황 증명서류(해당자) * 자세한 사항은 첨부파일 확인'
    },
    {
      Col1: '(재)옹진군인재육성재단',
      Col2: '지역핵심인재장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1학기 등록금 전액 (500만원 이내 지원)',
      Col12: '해외 유학생인 학생으로 세계 100대 대학에 재학 중인 자기타 특별한 사유로 이사회의 추천을 받은 자옹진군과 대학교 간 체결된 지역핵심인재육성을 위한 협약에 따른 특별전형 합격자',
      Col13: '공고일을 기준으로 본인이나 친권자가 옹진군에 주민등록을두고 5년 이상 실거주한 자관내 소재 초·중·고 통합 3년 이상 재학 경력이 있는 자 * 자세한 사항은 첨부자료 참고 필수 ',
      Col14: '2022-01-26~2022-02-16',
      Col15: '서류심사 * 자세한 사항은 서류 참고',
      Col16: '00명',
      Col17: '휴학/ 사이버대/ 학점은행제 대학 등은 제외대학원생 제외',
      Col18: '해당없음',
      Col19: ' ※ 해외유학생의 경우 반드시 한글번역문 제출학자지원금 신청서 및 지원신청서실거주 확인서개인정보 수집·이용·제공 및 조회 동의서서약서추천서(해당자)재학증명서성적증명서 (*신입생:수능시험성적표 또는 고교직전학기 성적증명서) (*재학생:직전학기 성적증명서 /편입생은 편입 전 학교 성적증명서)주민등록 등본 및 초본 (주소 변동사항이 기록된 것)가족관계등록부(학생기준)등록금 납입증명서생활기록부통장사본 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인강화군장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 4.5기준 3.8이상인 자  * 단 서울대/ 연세대/ 고려대/ ㅍ항공대/ 한국과학기술대학교 재학생은 학기별 평균평점이 4.5이상 3.5이상인자도 가능 15명은 사회적 배려 대상자로 2021년 1학기 학업성적이 4.5기준 3.0이상인 자 수급자/ 차상위계층. 한부모가정/ 다문화가정(3명 이내)',
      Col10: '해당없음',
      Col11: '3000000원 (학기당 150만원) (연 2회 분할지급) * 생활비 용도로 지원',
      Col12: '해당없음',
      Col13: '강화군 관내에 주소를 두고 장학생 선발 신청일 현재 3년 이상 거주한 자의 자녀관내 고등학교 졸업자',
      Col14: '2020-10-05~2020-11-16',
      Col15: '해당없음',
      Col16: ' 70명 / 55명은 성적우수학생 / 15명은 사회적 배려 대상 학생',
      Col17: '동일연도 강화군에서 지원하는 장학금을 받은 자 졸업예정 학생동일연도 강화군에서 지원하는 장학금을 받은 학생생',
      Col18: '소속 학장 이상의 추천',
      Col19: '장학생 선발 신청서장학생 추천서성적증명서주민등록 등/초본고등학교 졸업증명서개인정보 제공/이용 동의서'
    },
    {
      Col1: '재단법인강화군장학회',
      Col2: '학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '당해 연도 대학생 학자금대출 발생이자',
      Col12: '한국장학재단에서 2018년부터 대학생 학자금 대출(일반/취업 후 상환)을 받은 대학생(재학생 및 휴학생)으로서 아래 자격기준에 해당하는 자휴학기간(군 복무 휴학기간은 제외)은 6학기를 초과하지 않는 자',
      Col13: '지원신청일 현재 부 또는 모가 1년 이상 강화군에 주민등록이 되어있는 대학생/ 다만 부모가 모두 사망한 경우에는 학생 본인 또는 동거친족을 기준으로 1년 이상 강화군에 주민등록이 되어 있을 것',
      Col14: '2022-04-04~2022-04-15',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '고등교육기관에서 제적되거나 졸업한 경우 등국가/ 지방자치단체/ 법인/ 단체 등 다른 기관으로부터 학자금대출 이자전액을 지원받고 있는 대학생은 지원 대상에서 제외한국장학재단으로부터 학자금대출 정보 제공시점에 지원대상 대학생이 학자금 대출이자를 중도에 전액 상환하여 재단에 상환할 이자가 없는 경우 지원 제외',
      Col18: '해당없음',
      Col19: '학자금 대출이자 지원서 신청서대학교 재학 증명서주민등록초본가족관계증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '(재)인천인재평생교육진흥원',
      Col2: '재능인장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/사회계열/예체능계열/인문계열/자연계열/제한없음',
      Col9: '대학교 신입생인 경우 고등학교 3학년 2학기 내신 성적',
      Col10: '해당없음',
      Col11: '2000000원 (학업장려금 100만원 재능장려금 100만원) ※ 최초 선발시 지급하며 계속장학금 요건 충족 시 매학기별 지급으로 자세한 사항은 첨부파일 참조',
      Col12: ' * 전국단위 이상 국내/국제 대회에서 개인분야/ 단체분야로 참여하여 공고일로부터 1년 이내 입상한 실적이 있는 대학교 재학생 * 선발 분야 : 인문·사회/수학·과학/문화예술/체육/기술기능대학생인 경우 직전 정규학기 12학점(4학년 9학점) 이상 이수 ※ 자세한 사항은 첨부파일 참조',
      Col13: '보호자 또는 장학금 신청 학생의 주민등록주소지가 인천인 대학생인천 관내 고등학교 졸업생 * 자세한 사항은 첨부파일 참조 ',
      Col14: '2021-09-02~2021-10-04',
      Col15: '서류심사 기준 : 대회 수상성적(70%)/ 자기개발서(30%)/ 추가배점점 * 자세한 사항은 첨부파일 참조',
      Col16: '5명',
      Col17: '동일연도 내 재단에서 실시하는 장학금에 중복하여 선발 불가. (우선 시행 장학금 수혜시 나중에 시행하는 장학금 선발 불가)상반기 장학금 동시 지원 불가한 가구 내 2인 이상 지원 시 선신청자 1인만 판단단원격대학/ 기술대학/ 기능대학/ 2년 미만 교육과정의 각종학교 재학생초과학기생/ 휴학생/ 수료생',
      Col18: '추천권자 : 고등학교 학교장/ 대학 학과장/ 지원 분야와 관련한 유관단체장',
      Col19: '장학금 지원신청서장학생 추천서자기개발서재학증명서직전학교 졸업증명서주민등록등본대회 입상 확인 증명서 또는 상장 사본대회 개최 공고문(대회설명자료)보통예금통장 사본(신청자 또는 부모)대회 수상 실적서 * 해당자단체대회 입상자 추천서국민기초생활수급자 증명서차상위계층 증명서근로장려금 수령증한부모가정 증명서장애인증명서다문화 가정 증명서북한이탈주민 확인서  *자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '빛고을장학재단',
      Col2: '학업장려장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 학과·부(전공)별 평점 평균 3.0/4.5이상인 자',
      Col10: '중위소득 150% 이하',
      Col11: '1500000원',
      Col12: '정규 대학생으로 광주광역시 관내 소재 학교 재학 중이며/ 성적 우수한 저소득 가구 자녀 ',
      Col13: '공고일 현재 1년이상 광주광역시에 주민등록이 되어 있는 자로서 광주광역시 지역 내 소재 학교에 재학 중인 학생',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '71명 * 대학별 2~8명',
      Col17: '본 재단에 기 장학금 수혜자 제외항목간 중복 지급하지 않음 * 자세한 사항은 소속 대학으로 문의',
      Col18: '소속대학에서 대상자를 선정하여 배정인원 추천하여 선발',
      Col19: '장학금 지원 신청서재학증명서주민등록등본개인정보 수집·이용과 제공에 대한 안내 및 동의서직전학기 학업성적증명서소득수준 증빙서류 ( 국민건강보험료 납부확인서 & 건강보험 자격확인서 또는 한국장학재단 소득분위 확인서 중 택 1) * 자세한 내용은 소속 대학으로 문의'
    },
    {
      Col1: '빛고을장학재단',
      Col2: '전학년 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 학과/ 부(전공)별 성적 10%이내 or 평정 4.0이상 (4.5만점기준)',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '기존 선발 학생\' 중 성적 우수자',
      Col13: '추천일 현재 광주광역시에 주민등록이 되어 있는 자로서 광주광역시 지역 내 소재 학교에 재학중인 학생',
      Col14: '2021-09-02~2021-10-04',
      Col15: '해당없음',
      Col16: '3명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금지원 신청서 1부(별지1호)재학증명서 1부 주민등록등본 1통(공고일 이후 발급본)개인정보 수집/이용과 제공에 대한 안내 및 동의서 1통본인 명의 예금통장사본 1부직전학기 학업성적증명서 1부소득수준증빙서류(국민건강보험료납부확인서&건강보험자격확인서 또는 한국장학재단 소득분위 확인서 1부 중 택1)  * 자세한 사항은 첨부파일 참고 바람'
    },
    {
      Col1: '빛고을장학재단',
      Col2: '생계곤란 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '기초생활수급자  5.18 유공자 중 생계곤란자 ',
      Col11: '1500000원',
      Col12: '광주광역시에 거주하는 대학교 재학생으로서/ 기초생활수급자 또는 5·18 유공자 중 생계곤란자',
      Col13: '공고일 현재 1년이상 광주광역시에 주민등록이 되어 있는 자로서 광주광역시 지역 내 소재 학교에 재학 중인 학생',
      Col14: '2021-09-02~2021-10-04',
      Col15: '해당없음',
      Col16: '33명',
      Col17: '본 재단의 기 장학금 수혜자는 제외빛고을장학금 항목 간 중복 지급하지 않음 * 자세한 사항은 추천기관(자치구/ 각 추천기관 등)으로 문의',
      Col18: '자치구/ 각 추천기관의 추천으로 선발',
      Col19: '장학금 지원 신청서재학증명서주민등록등본개인정보 수집·이용과 제공에 대한 안내 및 동의서본인 명의 예금통장 사본수급자증명서/한부모가정증명서/5·18유공자 증 등 생계가 곤란함을 입증할 수 있는 기타 증빙자료 * 자세한 사항은 추천기관(자치구/ 각 추천기관 등)으로 문의'
    },
    {
      Col1: '빛고을장학재단',
      Col2: '이사장 추천 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '고용우수기업 · 광주형일자리/ 다문화 가정/ 전업미술가/ 북한이탈주민 등',
      Col13: '공고일 현재 1년이상 광주광역시에 주민등록이 되어 있는 자로서 광주광역시 지역 내 소재 학교에 재학 중인 학생',
      Col14: '2022-04-15~2022-05-13',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '본 재단의 기 장학금 수혜자는 제외빛고을 장학금 항목 간 중복 지급하지 않음 * 자세한 사항은 첨부파일 참조',
      Col18: '이사장 추천으로 선발',
      Col19: '장학금 지원 신청서재학증명서주민등록등본개인정보 수집·이용과 제공에 대한 안내 및 동의서본인 명의 예금통장 사본분야별로 추천 대상임을 증빙할 수 있는 서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '대전인재육성장학재단',
      Col2: '재능장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 미만 수강자',
      Col10: '해당없음',
      Col11: '1500000원 (등록성 장학금)',
      Col12: '수상기준 실적인정 기간 내에 인문·사회·과학·예·체능 등 분야의 국제 및 전국대회에서 3위 이내의 성적을 득했으며 학교 총장이 추천한 학생 (실적인정기간 : 20210417 ~ 20220415)',
      Col13: ' 선발공고일(2022.04.15) 기준 현재 대전시에 소재한 대학교에 재학 중이며 공고일 기준 6개월 전(2021.10.16)부터 대전광역시에 주소를 둔 학생',
      Col14: '2021-10-04~2021-10-29',
      Col15: '평가기준 : 최상위대회수상실적 1개 100%평가방법 : 대회규모별 수상실적으로 차등 배점 * 자세한 사항은 첨부자료 또는 홈페이지 게시판 참고',
      Col16: '5명',
      Col17: '휴학생/ 수료생/ 초과 학기 및 직전 학기 12학점 미만 수강자',
      Col18: '학교 총장의 추천 필요',
      Col19: '장학금 지원신청서장학생 추천 및 타 장학금 수혜 확인서재학증명서주민등록등본개인정보 수집·이용·제공 및 조회 동의서입상을 확인할 수 있는 상장 또는 증명서대회 설명자료대회 수상 내역서재능장학생 단체지원동의서(해당자)보호자 통장사본 또는 본인의 통장 사본* 자세한 내용은 첨부파일 참고'
    },
    {
      Col1: '대전인재육성장학재단',
      Col2: '성취장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '1학년 : 고32학기 종합내신성적 2등급 이상 · 검정고시 90점 이상(50%) + 대학 1학기 평점 B+ 이상(50%)2 ~ 4학년 : 직전 학기까지의 전체 평균평점 B+ 이상인 학생 *자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '장학생 선발 공고일 현재 대한민국 국적 취득자대전광역시에 소재한 대학에 재학 중인 학생',
      Col13: '선발 공고일 현재 대한민국 국적 취득자로서 공고일 기준 6개월 전부터 대전광역시에 주소를 두고/ 대전광역시에 소재한 대학에 재학 중인 자격요건을 갖춘 학생',
      Col14: '2021-10-01~2021-10-15',
      Col15: '학업성적 100% * 자세한 사항은 첨부파일 참고',
      Col16: '80명',
      Col17: '휴학생 및 수료생 현재학기 기준 9학점 미만 수강자정학 이상의 징계처분을 받은 자교육부 비인가 학교·한국방송통신대학교 재학 중인 자2021년도 전체 전액장학금 수혜자',
      Col18: '학교장 추천',
      Col19: '장학금 신청지원서 1부 장학생 추천 및 타 장학금 수혜확인서재학증명서 주민등록등본개인정보 수집/이용/제공 및 조회 동의서 1부성적증명서 1부통장사본 1부 * 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 대전광역시서구인재육성장학재단',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '공고일 기준 1년동안의 성적이 평균 B+학점 이상인 자 ',
      Col10: '해당없음',
      Col11: '1500000원 (1인당)',
      Col12: '대전광역시 소재 대학교 재학생',
      Col13: '선발공고일 현재 계속하여 6개월 이상 대전광역시 서구에 거주하고 있는 학생',
      Col14: '2022-09-07~2022-09-30',
      Col15: '신청 및 접수적격검토 및 자격심사선정심사위원회 개최최종 선정대상자 확정선정결과 통보장학증서 수여',
      Col16: '6명',
      Col17: '공고일 기준 1년 이내 장학금 수혜자(종류에 관계없이) * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서(반명함판 사진 부착)장학생 추천서주민등록등본(9월 3일 이후 발급 분)/6개월 이상 거주확인 증명서약서개인정보 수집/ 이용/ 제공 및 조회 동의서통장사본재학증명서성적증명서(1년동안 평균 등급/학점 표기) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 충청남도인재육성재단',
      Col2: '희망드림장학금(원금상환)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '학자금 지원구간 통지서 상 가장 최근 소득분위가 4분위 이하인 자대출유형 중 [일반상환]또는 [든든(취업후상환)]학자금 대출을 받았으며 상환 신청 대상 대출 잔액이 100000원 이상인 자',
      Col11: ' * 1인 장학금액 : 최대 1500000원상환신청 학기 대출상환 잔액이 150만원 미만 : 대출상환잔액 상환신청 학기 대출상환 잔액이 150만원천원 이상 : 150만원 ※ 장학금은 개인에게 지급되지 않으며 한국장학재단에서 신청학기 대출잔액 상환',
      Col12: '한국장학재단으로부터 학자금 대출(등록금/ 생활비)을 받은 대학 재학생대출유형중 \'일반상환\' 또는 \'든든(취업후상환)\' 학자금 대출을 받은 자',
      Col13: '공고일 기준 본인 또는 부모가 충청남도에 1년 이상 계속해서 주소지를 둔 학생(대전/ 세종시 제외)',
      Col14: '2022-03-21~2022-04-04',
      Col15: '소득분위(55%) + 학업성적(40%) + 봉사(5%)동점자일 경우 : 저소득층 > 학자금대출 상환잔액이 많은 학생생',
      Col16: '약 100명 ',
      Col17: '공고일 기준 현재 휴학생공고일  기준 현재 수료상태인 졸업예정자2022년 본재단 장학금 선발자 및 수혜자2022년도 상반기 타 공모제 장학사업 지원자학자금 지원구간통지서 상 가장 최근 소득분위가 4분위 초과인 자 (5~10분위) * 자세한 사항은 첨부자료 참고',
      Col18: '해당없음',
      Col19: '희망드림 장학생 신청서신청자 또는 부모의 등본재학증명서성적증명서봉사활동확인서류(해당자)주소변동이력 또는 초본/가족관계증명서(해당자) * 자세한 사항은 첨부자료 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 충청남도인재육성재단',
      Col2: '재능키움장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '4500000원(150만원 3회 분할지급)2022년 (2회) : 3000000원2023년 (1회) : 1500000원 ',
      Col12: '졸업까지 3학기 이상 잔여학기가 남은 자',
      Col13: ' * 아래중 하나에 해당하는 자공고일기준 본인 또는 부모가 충청남도에 1년 이상 계속해서 주민등록상 주소지를 둔 국내대학 재학생부모의 등록기준지(본적)가 충청남도인 자',
      Col14: '2022-09-26',
      Col15: '학업성적 30% + 서류심사 30% + 면접심사 40%',
      Col16: '40명 * 선발 적격자 부족시 선발예정 인원보다 적게 선발',
      Col17: '공고일 기준 휴학생·수료상태(졸업유예자 포함)인자재단 장학금 수혜자 제외 * 자세한 사항은 첨부파일 참고고원격대학(방송통신대학/ 통신대학/ 사이버대학)/ 기술대학. 2년 미만의 교육과정의 각종 학교(시간제/ 직업능력개발훈련/ 학점은행제)/ 평생교육법 의거 설립한 학교(직업전문 학교 등) ',
      Col18: '해당없음',
      Col19: '재능키움 장학생 신청서자기소개 및 미래계획서신청자 또는 부모의 등본재학증명서성적증명서류 * 추가서류(해당자)주소변동이력 또는 초본가족관계등록부경제상황증빙 서류 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고 '
    },
    {
      Col1: '재단법인 충청남도인재육성재단',
      Col2: '한울타리장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원 ※ 자기계발 생활비',
      Col12: '충청남도외 지역에서 전입한 도내소재 우수 대학생',
      Col13: '접수마감일 기준(2022.9.26.) 본인의 주소(주민등록주소)가 충남으로 전입된 기간이 1년 미만인 도내 소재 대학교 재학생',
      Col14: '2022-09-02~2022-09-29',
      Col15: '선발기준 : 학업성적(30%)/ 서류심사(30%: 에세이25% + 봉사활동5%)/ 면접심사(40%)',
      Col16: '20명',
      Col17: '공고일 기준 현재 휴학생·수료상태2022년도에 본 재단에서 장학수혜를 받았거나 받을 예정인 자본 재단의 2022년도 청년 커뮤니티 지원사업 수혜자2022년도 충남정착지원/ 하반기 예체능공연활동지원 장학생 지원자1가구 1인 지원   * 증서수여식 불참 시 장학금 미지급 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '한울타리 장학생 신청서충남이전 사유 및 미래계획서신청자 주민등록 초본 재학증명서성적증명서봉사활동확인서류(해당자)경제상황증빙서류(해당자) * 자세한 사항 첨부파일 참조'
    },
    {
      Col1: '재단법인 충청남도인재육성재단',
      Col2: '해외유학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '<학업성적> 대학 4년간 평균성적이 백분율 환산 80점 이상<어학능력> 첨부파일 내 어학점수 기준표 참고',
      Col10: '해당없음',
      Col11: '지원금액 : 국비유학생 국가별 장학금 지원 금액의 100% 지원기간 : 2년 * 학비와 생활비 전부 포함하는 금액 연 2회 분할지급 ※ 국가별 연간 지원금액은 첨부파일 참조',
      Col12: ' * 학위과정(석사과정/ 석·박사통합과정/ 박사과정) * 선발분야 : 이·공과계열/ 기타계열도내 소재대학 졸업(예정)자 또는 기타지역 소재국내대학 졸업(예정)자',
      Col13: ' *  도내 2년 이상 주민등록이 되어 있는 충남도민 또는 충남출향인 본인 또는 자녀도내 소재대학 졸업(예정)자기타지역 소재국내대학 졸업(예정)자 : 도내「초·중·고등학교」중 하나의 학교 졸업한 자',
      Col14: '2022-07-08~2022-08-10',
      Col15: '(1차) 서류 · 심사항목 : 대학성적(30점)/ 에세이(30점)/ 외국어능력(40점)(2차) 면접 · 심사항목 : 전공분야(50점)/ 인성분야(50점)',
      Col16: '4명',
      Col17: '국가 또는 민간단체로부터 유사 장학금을 받은 자이미 유학 입학허가서를 취득한자이미 석사과정 또는 석박사통합과정에 유학중인 자는 제외해외여행에 결격사유가 있는 자선발공고일 현재 응시하고자 하는 과정의 학위과정이거나 입학허가서를 취득한 경우 제외',
      Col18: '대학교 총장 추천서 제출',
      Col19: '해외유학 장학생 선발 지원서대학교 총장 추천서대학 재학 또는 졸업증명서성적증명서공인어학시험성적 증명서기본자격(주소지) 확인이 가능한 증빙서류에세이도내 「초·중·고등학교」 졸업증명서기초생활수급자 및 차상위 계층 증명서(해당자)개인정보 이용·수집에 대한 동의서기타 장학생 선발등과 관련하여 재단에서 요구하는 자료 ※ 양식 다운로드 및 자세한 사항 확인은 재단 홈페이지 참조'
    },
    {
      Col1: '재단법인 충청남도인재육성재단',
      Col2: '소상공인자녀지원장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '학자금지원구간통지서 상 가장 최근 소득분위가 4분위 이하인 자',
      Col11: '1000000원',
      Col12: '공고일 기준 본인 또는 부모가 충청남도 천안시에 1년이상 계속해서 주민등록상 주소지를 둔 국내대학교 재학생 또는 가족관계증명서 상 부 또는 모가 충청남도 천안시에 6개월 이상 계속해서 사업을 영위하고 있는 자',
      Col13: ' * 자세한 사항은 첨부파일 참조',
      Col14: '2022-04-04~2022-04-18',
      Col15: '경제상황(50%) + 학업성적(50%)동점자 우선순위: 저소득층 > 다자녀(3명이상)가구 > 고학년 순',
      Col16: '80명',
      Col17: '공고일 기준 현재 휴학생 또는 수료상태인 졸업예정자신청년도에 충청남도인재육성재단의 장학금을 수혜받은 자 또는 받을 예정인 자1가구 2인 지원 불가신청년도 보금자리/ 온라인 멘토링활동 장학생 지원자 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '소상공인 자녀지원 장학생 신청서신청자 또는 부모의 등본성적증명서재학증명서학자금 지원구간 통지서사업자등록증 사본소상공인확인서주소변동이력 또는 초본(해당자)가족관계증명서(해당자) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 충청남도인재육성재단',
      Col2: '충남뿌리내림장학',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인 3000000원 (2년간 2회 지급) * 충남정착을 위한 자기계발비',
      Col12: '선발공고일 기준 본인 또는 부·모가 계속해서 충남에 1년 이상 거주(주민등록상)하고 있으며 2022년 8월 졸업예정인 국내대학교 재학생 ',
      Col13: '선발공고일 기준 본인 또는 부·모가 계속해서 충남에 1년 이상 거주(주민등록상)하고 있는 자 ',
      Col14: '2022-08-22',
      Col15: '학업성적 30% + 서류심사 30% + 면접심사 40%  *자세한 내용은 첨부파일 참고',
      Col16: '25명  * 선발 적격자 부족 시 선발예정인원 보다 적게 선발',
      Col17: '공고일 기준 현재 휴학생·현재 수료상태인 졸업예정자1가구 2인 이상 지원 불가원격대학/ 2년미만의 교육과정의 각종학교/ 평생교육법 의거 설립한 학교(직업전문 학교 등)재단의 선발·수혜 장학생 * 자세한 사항 첨부파일 및 홈페이지 공고 참조',
      Col18: '해당없음',
      Col19: '충남뿌리내림 장학생 신청서충남정착사유 및 미래계획서신청자 또는 부·모의 주민등록등본재학증명서성적증명서봉사활동확인서류(해당자)경제상황증빙 서류(해당자) * 온라인접수/ 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 충청남도인재육성재단',
      Col2: '보금자리(거주비지원)장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '해당없음',
      Col10: '학자금지원구간통지서 상 가장 최근 소득분위가 4분위 이하인 자',
      Col11: '총 2000000원 ( 9월 중 12월 중 2회 분할지급)',
      Col12: '부모가 충청남도에 1년 이상 주소지를 두고/ 충남·서울·대전을 제외한 타지역 소재 대학에 재학중인 학생부동산임대차계약서 상 2022.1.1~2022.12.31 기간 중 최소 8개월 이상 * 자세한 사항은 첨부파일 참고',
      Col13: '공고일 기준 본인 또는 부모가 충남에 1년 이상 주민등록이 되어 있는 자',
      Col14: '2022-04-11~2022-04-22',
      Col15: '경제상황 50%/ 학업성적 45%/ 봉사활동 5%동점자 선발 우선순위: 저소득측>다자녀(3명이상)가수>고학년 순',
      Col16: '30명',
      Col17: '공고일 기준 현재 휴학생 또는 수료상태(졸업유예자 포함)인 자2022년도에 본 재단에서 장학수혜를 받았거나 받을 예정인 자본 재단의 2022년도 청년 커뮤니티 지언사업 수혜자2022년도 소상공인 자녀지원/ 온라인 멘토링활동 장학생 지원자1가구 1인 지원증서수여식 불참 시 장학금 미지급',
      Col18: '해당없음',
      Col19: '보금자리 장학생 신청서신청자 또는 부모의 등본부동산임대차계약서(월세계약서)사본월세 납입내역 증빙(계좌이체 내역 등 3개월 이상)가족관계증명서성적증명서재학증명서학자금 지원구간 통지서 주소변동이력 또는 초본(해당자)봉사활동확인서류(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인남양주장학재단',
      Col2: '미래장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(신입생) 최종학교 전체학년 평균성적 90점 이상(재학생) 직전 두 학기 평균평점 4.5학점 만점 3.6 이상  * 자세한 사항은 첨부파일 참고 ',
      Col10: '해당없음',
      Col11: '일반대: 3000000원방통대: 500000원',
      Col12: '해당없음',
      Col13: '공고일 현재 남양주시에 1년 이상 주민등록상 주소를 두고 계속 거주하는 대학생',
      Col14: '2022-04-11~2022-04-22',
      Col15: '학업성적 94점 + 봉사활동 시간 3점 + 거주기간 3점   * 추가 가점 부여/ 동점자 처리 및 자세한 사항은 첨부파일 참고 ',
      Col16: '일반대: 20명방통대: 8명',
      Col17: '국가 또는 학교/ 지방자치단체/ 민간단체 등에서 전액 장학금 받는 자 제외대학원생/ 사이버대학/ 평생교육원 학점은행/ 폴리텍대학 등 재학생',
      Col18: '해당없음',
      Col19: '장학생 신청서성적증명서개인정보수집 및 이용 동의서2022년 1학기 등록금 납입증명서 또는 납부확인서봉사활동 확인서 (해당자) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인남양주장학재단',
      Col2: '복지장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(신입생) 최종학교 전체학년 평균성적 70점 이상(재학생) 직전 두 학기 평균평점 4.5학점 만점 1.6 이상 * 자세한 사항은 첨부파일 참고 ',
      Col10: '대학교 재학생 중 저소득층(국민기초생활수급자 한부모가정 차상위계층 기타 생계곤란 자)',
      Col11: '3000000원',
      Col12: '해당없음',
      Col13: '남양주시 관내에 주소를 두고/ 신청 공고일 현재 만1년 이상 계속 거주한 대학생 ',
      Col14: '2021-11-01~2021-11-12',
      Col15: '읍·면·동장 추천자 60점 + 학업성적 34점 + 봉사활동시간 3점 + 거주기간 3점  * 추가 가점 부여/ 동점자 처리 및 자세한 사항은 첨부파일 참고',
      Col16: '60명',
      Col17: '대학원/ 사이버대학/ 평생교육원 학점은행/ 폴리텍대학 ',
      Col18: '행정복지센터 읍·면·동장의 추천',
      Col19: '장학생 증명서성적증명서개인정보수집 및 이용동의서2022년 1학기 등록금 납입증명서 또는 납부확인서수급증명서류봉사활동 확인서 * 자세한 사항은 첨부파일 참고 '
    },
    {
      Col1: '재단법인남양주장학재단',
      Col2: '재능장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원 ',
      Col12: ' 예술·체육·기능 등에 재능이 뛰어난 사람으로서 2020년도에 국가/ 경기도 및 경기도교육청에서 주최하는 국내 대회에서 3위 이내의 입상경력이 있는 학생 ',
      Col13: '공고일 현재 남양주시에 1년 이상 주민등록상 주소를 두고 계속 거주하는 대학생',
      Col14: '2022-08-08~2022-08-12',
      Col15: '대상: 예술‥체육·기능 특기자대회: 경기도이상 기관 주최 대회의 입상 성적 ',
      Col16: '총 66명 (재능 53명/ 복지 13명)',
      Col17: '해당없음',
      Col18: '*체육특기생 : 남양주시 체육회장*예능특기생 : 한국예총 남양주지부장(문인협회/ 영화인협회/ 미술협회/ 음악협회/ 무용협회/ 사진협회/ 국악협회 등)',
      Col19: '장학생 신청서입상증명서개인정보수집 및 이용동의서 '
    },
    {
      Col1: '재단법인 성남시장학회',
      Col2: '재단장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전학기 성적이 15학점 이상을 이수하고 4.5만점 기준 B(3.0)학점 이상인 학생',
      Col10: '* 본 재단이 정하는 저소득층의 자녀(12항목 중 1개 해당자)수급권자 직계 가족(부모형제자매) 건강보험료 합산금액이 월평균 114100원(장기요양보험제외)이하에 해당하는 세대 구성원',
      Col11: '등록금 전액 (교과서 학생회비 등 부대비용 제외)',
      Col12: '본 재단이 정하는 저소득층의 자녀',
      Col13: '신청일 현재 계속하여 2년 이상 성남시에 주민등록을 두고 거주한 자 * 학업을 위해 부득이 학교 기숙사에 주민등록을 둔 경우 인정',
      Col14: '2022-08-08~2022-08-12',
      Col15: '학업성적/ 거주기간/ 자기소개 및 진로 계획서/ 학업환경 및 경제환경을 고려 * 경제환경 우선 * 자세한 사항은 첨부파일 참고',
      Col16: '36명',
      Col17: '국가기관이나 지방자치단체/ 학교/ 기타 장학관련 단체로부터 수업료 또는 등록금을 전액 면제·지원 받고 있는 학생휴학 및 유학 예정자는 대상에서 제외정규과정 외의 초과(선택)학기는 신청 불가다중학위취득시 신청 불가 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '신청서성적증명서재학증명서학업환경 증명서류(택1)가족관계증명서주민등록초본자기소개 및 진로계획서건강보험료 납입증명서류 · 건강보험자격 확인(통보)서 · 건강보험 자격득실확인서 · 건강보험료 납부 확인서 · 의료급여증명서(해당자)개인(신용)정보 수집/ 이용/ 제공 및 조회 동의서  * 장학회 홈페이지에서 인터넷 신청으로/ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 성남시장학회',
      Col2: '성남장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 15학점 이상을 이수하고 4.5만점 기준 A(4.0)학점 이상인 학생',
      Col10: '해당없음',
      Col11: '등록금 전액 ( 교과서 학생회비 등 부대비용 제외 )',
      Col12: '해당없음',
      Col13: '신청일 현재 계속하여 2년 이상 성남시에 주민등록을 두고 거주한 자 * 학업을 위해 부득이 학교 기숙사에 주민등록을 둔 경우 인정',
      Col14: '2022-08-08~2022-08-12',
      Col15: '학업성적/ 거주기간/ 자기소개 및 진로계획서/ 경제환경 고려 * 성적 우선선 * 자세한 사항은 첨부파일 참고',
      Col16: '30명',
      Col17: '국가기관이나 지방자치단체/ 학교/ 기타 장학관련 단체로부터 수업료 또는 등록금을 전액 면제/지원 받고 있는 학생정규과정외 초과학기 신청불가/ 다중학위취득시 신청불가1세대 1명에 한하여 수혜 가능휴학 및 유학 예정자',
      Col18: '해당없음',
      Col19: '신청서 성적증명서(전체학년 성적증명서) 재학증명서가족관계증명서주민등록초본자기소개 및 진로계획서건강보험료 납입증명서류 · 건강보험자격 확인(통보)서 · 건강보험 자격득실확인서 · 건강보험료 납부 확인서 · 의료급여증명서(해당자)개인(신용)정보 수집/ 이용/ 제공 및 조회 동의서  * 장학회 홈페이지에서 인터넷 신청으로/ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 성남시장학회',
      Col2: '자립장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전학기 성적이 15학점 이상을 이수하고 4.5만점 기준 C(2.0)학점 이상 학생',
      Col10: ' * 성남시장학회에서 정하는 저소득층의 학생으로서 장애인 복지법상 장애인정을 받은 학생 (아래 하나 이상 항목 해당자)의료급여법 제3조에서 정하는 수급권자국민건강보험법에 의한 국민건강보험공단이 고지한 직계가족 건강보험료 합산금액이 가입자 세대당 월평균 114100원 이하 해당',
      Col11: '등록금 전액 ( 교과서 학생회비 등 부대비용 제외 )',
      Col12: ' * 성남시장학회에서 정하는 저소득층의 학생으로서 장애인 복지법상 장애인정을 받은 학생',
      Col13: '신청일 현재 계속하여 2년 이상 성남시에 주민등록을 두고 거주한 자 * 학업을 위해 부득이 학교 기숙사에 주민등록을 둔 경우 인정',
      Col14: '2022-08-08~2022-08-12',
      Col15: '학업성적/ 거주기간/ 자기소개 및 진로 계획서/ 장애상태/ 경제환경을 고려 * 경제환경 우선',
      Col16: '1명',
      Col17: '국가기관이나 지방자치단체/ 학교/ 기타 장학관련 단체로부터 수업료 또는 등록금을 전액 면제·지원 받고 있는 학생휴학 및 유학 예정자는 대상에서 제외1세대 1명에 한하여 수혜 가능 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '신청서재학증명서장애인증명서성적증명서가족관계증명서주민등록초본자기소개 및 진로계획서건강보험료 납입증명서류 · 건강보험자격 확인(통보)서 · 건강보험 자격득실확인서 · 건강보험료 납부 확인서 · 의료급여증명서(해당자)개인(신용)정보 수집/ 이용/ 제공 및 조회 동의서  * 장학회 홈페이지에서 인터넷 신청으로/ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 성남시장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/예체능계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 전액 ( 교과서 학생회비 등 부대비용 제외 )',
      Col12: '과학 및 예술·체육·기능 분야에 소질과 능력이 뛰어난 자직전 1년 이내 도·시(시/군)단위규모 이상의 대회에서 3위이상 성적으로 입상한 자 ( * 공연 또는 입상성적 평가 합산점수 30점 이상인 학생이며/ 대회 규모 및 수상 확인서 제출 가능자에 한함 / 동일공적 1회 인정)',
      Col13: '신청일 현재 계속하여 2년 이상 성남시에 주민등록을 두고 거주한 자 * 학업을 위해 부득이 학교 기숙사에 주민등록을 둔 경우 인정',
      Col14: '2022-02-14~2022-02-17',
      Col15: '거주기간/ 자기소개서 및 진로계획서/ 경제환경 등을 고려 * 입상 및 공연성적 우선 * 자세한 사항은 첨부파일 참고',
      Col16: '2명',
      Col17: '국가기관이나 지방자치단체/ 학교/ 기타 장학관련 단체로부터 수업료 또는 등록금을 전액 면제·지원 받고 있는 학생휴학 및 유학 예정자는 대상에서 제외1세대 1명에 한하여 수혜 가능원격대학/ 기술대학/ 2년 미만 교육과정의 각종학교/ 평생교육법에 의거 설립된 학교 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '신청서재학증명서특기생 입증(입상)관련자료 사본(원본지참)가족관계증명서주민등록초본자기소개 및 진로계획서건강보험료 납입증명서류 · 건강보험자격 확인(통보)서 · 건강보험 자격득실확인서 · 건강보험료 납부 확인서 · 의료급여증명서(해당자)개인(신용)정보 수집/ 이용/ 제공 및 조회 동의서  * 장학회 홈페이지에서 인터넷 신청으로/ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '(재)과천시 애향장학회',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년의 학업성적이 100점 기준으로 90점이상이거나 학업순위가 상위 10%이내인 학생(대학 재학생 학기별 이수학점 15학점 이상)',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '1가정 1자녀만 선정 됨 ',
      Col13: '공고일 현재 가족이 계속하여 2년이상 과천시에 거주하고 있는 시민의 직계비속인 자',
      Col14: '2022-02-14~2022-02-17',
      Col15: '해당없음',
      Col16: '35명 ',
      Col17: '국가 또는 지방자치단체나 타 기관/단체로부터 장학금 및 학비보조비/학교장학금을 받는 학생*다만 장학금 총액이 등록금보다 적을 경우에는 예외*기초생활수급자(대학생) 중 국가장학금 수혜자격 대상은 제외',
      Col18: '해당없음',
      Col19: '주민등록등본직전학년 성적증명서건강/장기요양보험료 납부 확인서건강보험증 사본 또느 건강보험 자격서가족관계 증명서재학증명서개인정보 수집이용제공 및 조회 동의서 '
    },
    {
      Col1: '(재)과천시 애향장학회',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년의 학업성적이 100점을 기준으로 60점 이상이거나 학업순위가 상위 80%이내인 학생  * 대학신입생은 입학전 고등학교 3학년 성적',
      Col10: '경제적으로 어려운 가정의 학생 우선 선발 ',
      Col11: '1 인당 3000000원 ',
      Col12: '해당없음',
      Col13: '공고일 현재 가족이 계속하여 2년 이상 과천시에 거주하고 있는 시민의 직계비속',
      Col14: '2022-02-14~2022-02-17',
      Col15: '해당없음',
      Col16: '일반/특기를 합해서 43명 ',
      Col17: '국가 또는 지방자치단체나 타 기관/단체로부터 장학금 및 학비보조비/학교장학금을 받는 학생*다만 장학금 총액이 등록금보다 적을 경우에는 예외*기초생활수급자(대학생) 중 국가장학금 수혜자격 대상은 제외',
      Col18: '해당없음',
      Col19: ' * 신청서류 장학생선정신청서주민등록등본직전학년 성적증명서(신입생의 경우 고등학교 3학년 성적확인서)재산세 세목별 납세증명서(재산세)건강/장기요양보험료 납부 확인서건강보험증 사본 또는 건강보험 자격확인서가족관계증명서재학증명서개인정보수집/이용/제공 및 조회 동의서기타 참고서류 * 신청서 교부 : 과천시 애향장학회 사무국 및 홈페이지 * 접수처 : 재단법인 과천시애향장학회 사무국(과천시 의회청사 1층) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)과천시 애향장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '일반 특기 합해서 43명 ',
      Col11: '3000000원 ',
      Col12: '과학 및 예체능 등 분야에 소질과 재능이 뛰어나 전국단위 이상 대회에서 3위 이상 입상한 학생(공고일 기준 1년 이내 입상 실적)',
      Col13: '공고일 현재 가족이 계속하여 2년 이상 과천시에 거주하고 있는 시민의 직계비속',
      Col14: '2022-02-14~2022-02-17',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '국가 또는 지방자치단체나 타 기관/단체로부터 장학금 및 학비보조비/학교장학금을 받는 학생*다만 장학금 총액이 등록금보다 적을 경우에는 예외*기초생활수급자(대학생) 중 국가장학금 수혜자격 대상은 제외',
      Col18: '해당없음',
      Col19: ' * 신청서류 장학생선정신청서주민등록등본건강/장기요양 보험료 납부확인서건강보험증 사본 또는 건강보험 자격확인서특기실적증명서가족관계증명서재학증명서개인정보 수집 이용 제공 및 조회 동의서 * 신청서 교부 : 과천시 애향장학회 사무국 및 홈페이지 * 접수처 : 재단법인 과천시애향장학회 사무국(과천시 의회청사 1층) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)과천시 애향장학회',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 3000000원 ',
      Col12: '1가구 3자녀 이상인 가정의 학생',
      Col13: '공고일 현재 가족이 계속하여 2년 이상 과천시에 거주하고 있는 시민의 직계비속',
      Col14: '2022-02-14~2022-02-17',
      Col15: '해당없음',
      Col16: '15명 ',
      Col17: '국가 또는 지방자치단체나 타 기관/단체로부터 장학금 및 학비보조비/학교장학금을 받는 학생*다만 장학금 총액이 등록금보다 적을 경우에는 예외*기초생활수급자(대학생) 중 국가장학금 수혜자격 대상은 제외',
      Col18: '해당없음',
      Col19: ' * 신청서류 장학생선정신청서주민등록등본주민등록초본직전학년 성적증명서(신입생의 경우 고등학교 3학년 성적확인서)재산세 납세증명서(세대주/ 배우자)건강보험료 납부증명서건강보험증 사본재학증명서(신입생은 합격통지서/ 복학생은 복학예정증명서)가족관계증명서개인정보 수집 이용 제공 및 조회 동의서 * 신청서 교부 : 과천시 애향장학회 사무국 및 홈페이지 * 접수처 : 재단법인 과천시애향장학회 사무국(과천시 의회청사 1층)'
    },
    {
      Col1: '(재)과천시 애향장학회',
      Col2: '장애인가정장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년의 학업성적이 100점을 기준으로 60점 이상이거나 학업순위가 상위 80%이내인 학생 ',
      Col10: '경제적으로 어려운 가정의 학생',
      Col11: '1인당 3000000원 ',
      Col12: '부모 또는 학생이 장애인이면서 경제적으로 어려운 가정의 학생',
      Col13: '공고일 현재 가족이 계속하여 2년 이상 과천시에 거주하고 있는 시민의 직계비속',
      Col14: '2022-04-11~2022-04-29',
      Col15: '해당없음',
      Col16: '5명 ',
      Col17: '국가 또는 지방자치단체나 타 기관/단체로부터 장학금 및 학비보조비/학교장학금을 받는 학생은 제외 * 다만 장학금 총액이 등록금보다 적을 경우에는 예외 * 기초생활수급자(대학생) 중 국가장학금 수혜자격 대상은 제외',
      Col18: '해당없음',
      Col19: ' * 신청서류 장학생선정신청서주민등록등본주민등록초본직전학년 성적증명서(신입생의 경우 고등학교 3학년 성적확인서)지방세 세목별 과세증명서(재산세)/부/모 명의 모두 제출건강/장기요양 보험료 납부 확인서 건강보험증 사본 또는 건강보험 자격확인서가족관계증명서재학증명서개인정보 수집/이용/제공 및 조회 동의서기타 참고서류(장애인등록증 사본/ 기초생활수급자증명서/ 기타 참고서류) * 신청서 교부 : 과천시 애향장학회 사무국 및 홈페이지 * 접수처 : 재단법인 과천시애향장학회 사무국(과천시 의회청사 1층)'
    },
    {
      Col1: '김포시민장학회',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(입학생) 대학수학능력시험 성적 백분위 점수 평균 80% 이상인 자 또는 수시 입학생은 졸업 고등학교 생활기록부 상 성적이 원점수 80점 이상인 자(재학생) 한 학년 평균성적이 백분율 80점 이상인 자(저소득층 자녀 또는 소년소녀 가장) 재학생은 학업성적 백분율 60점 이상/ 입학생은 수학능력시험 또는 고등학교 생활기록부 상 점수가 평균 60점 이상 ',
      Col10: ' * 저소득층 자녀로 지원시기초생활수급자증명서 및 차상위 계층 수급증명서가 있는 자소년소녀 가장',
      Col11: '2000000원',
      Col12: '1년 이상 관내 거주하는 김포시민의 대학교 입학생/ 재학생 자녀로서 요건을 충족하는 자',
      Col13: '장학생 선발 공고일 이전부터 1년 이상 관내 거주하는 김포시민의 자녀관내 고등학교 졸업생',
      Col14: '2022-03-21~2022-04-01',
      Col15: '해당없음',
      Col16: '300명',
      Col17: '국가 또는 기타의 기관 단체로부터 장학금을 받은 자(특기단체포함)는 등록금 범위내에서(대학생기준) 장학금 지급이 이루어지기 때문에 그 범위를 초과하는 자',
      Col18: '해당없음',
      Col19: '장학생 신청서주민등록등본 (최근 3개월 이내의 발급본에 한함/ 주민번호 전체기재)건강보험료 납입 내역서(2021년도 전체납입금액/ 부/모 각 1부씩)성적증명서(20211·2학기)등록금 납부 영수증(확인서) 사본 1부 (대학신입생 및 재학생)혼인관계 증명서(해당자)의료급여 증명서(해당자) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 부천장학재단',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2021년도 학기별 평균 평점이 4.0점 (4.5만점 기준)이상인 학생으로 성적순으로 선발 (복학생/ 편입생은 직전 학년 성적)   대학교/전문대 신입생은 고등학교 3학년 성적이 전과목별 원점수의 총점을 과목수로 나눈 평균점수가 90점 이상인 학생',
      Col10: '해당없음',
      Col11: '전문대생: 2500000원대학생: 3000000원',
      Col12: '공고일 현재 부·모 또는 본인이 1년 이상 부천시에 주민등록이 되어 있는 2자녀 이상 가구 중 부천시에 소재한 고등학교 졸업생 및 고졸 검정고시 출신으로 국내대학 재학생 중 성적기준을 충족하는 자',
      Col13: '공고일 현재 부·모 또는 본인이 1년 이상 부천시에 주민등록이 되어 있는 2자녀 이상 가구 중 부천시에 소재한 고등학교 졸업생 및 고졸 검정고시 출신으로 국내대학 재학생',
      Col14: '2022-03-21~2022-04-01',
      Col15: '같은 순위일 경우 부천시 장기 거주자 순자원봉사활동 실적 가산점 적용다자녀 가산점 적용(3자녀 이상)장애인 가산점 적용(해당자·부모)',
      Col16: '전문대생: 4명 (신입생 1명/ 재학생 3명)대학생: 14명 (신입생 2명/ 재학생 12명)',
      Col17: '가구별 1명 신청2022년에 타 기관(국가·학교·타 장학재단/기타)으로 부터 전액 장학금을 받은 학생부천장학재단 장학금을 같은 학제에서 4학기 이상 받은 학생정규과정 외 초과학기자원격·학점은행제 학생/ 사이버·디지털 대학/ 방송통신대/ 교환학생/ 휴학생/ 직업전문학교 학생 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학생선발 신청서재학증명서개인 신용정보 제공 및 조회 동의서/ 서약서 부·모 또는 본인의 주민등록 초본 (주소변동사항 포함)가족관계증명서 (부 또는 모 명의만 가능)고등학교 졸업증명서 또는 검정고시 합격증 해당학기 등록금 고지서 또는 납부영수증 2021년도 자원봉사 실적 확인서(연 40시간 이상 해당자)2021년도 1/2학기 성적증명서 (복학생/ 편입생은 직전학년)신입생인 경우 고등학교 3학년 성적증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 부천장학재단',
      Col2: '가정환경장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정환경이 어려운 저소득 가정의 학생',
      Col11: '전문대생: 2500000원대학생: 3000000원',
      Col12: '공고일 현재 부·모 또는 본인이 1년 이상 부천시에 주민등록이 되어 있는 2자녀 이상 가구 중 부천시에 소재한 고등학교 졸업생 및 고졸 검정고시 출신으로 국내대학 재학생 중 가정환경이 어려운 저소득 가정의 학생',
      Col13: '공고일 현재 부·모 또는 본인이 1년 이상 부천시에 주민등록이 되어 있는 2자녀 이상 가구 중 부천시에 소재한 고등학교 졸업생 및 고졸 검정고시 출신으로 국내대학 재학생',
      Col14: '2022-03-21~2022-04-01',
      Col15: '같은 순위일 경우 부천시 장기 거주자 순자원봉사활동 실적 가산점 적용 (2021년에 40시간 이상 행한 자원봉사활동 실적)다자녀 가산점 적용(3자녀 이상)재산 및 소득정도에 따라 저소득자 순으로 선발다문화 가정의 경우 가산점 부여',
      Col16: '전문대생: 5명대학생: 18명',
      Col17: '가구별 1명 신청2022년에 타 기관(국가·학교·타 장학재단/기타)으로 부터 전액 장학금을 받은 학생부천장학재단 장학금을 같은 학제에서 4학기 이상 받은 학생초과 및 선택학기 신청불가원격·학점은행제 학생/ 사이버·디지털 대학/ 방송통신대/ 교환학생/ 휴학생/ 직업전문학교 학생 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학생선발 신청서재학증명서개인 신용정보 제공 및 조회 동의서/ 서약서 부·모 또는 본인의 주민등록 초본 (주소변동사항 포함)가족관계증명서 (부 또는 모 명의만 가능)고등학교 졸업증명서 또는 검정고시 합격증 해당학기 등록금 고지서 또는 납부영수증 2021년도 자원봉사 실적 확인서(연 40시간 이상 해당자)2021(1~12월) 건강보험료 납부확인서2021(1~12월) 건강보험자격득실 확인서2021 세목별(재산세·자동차세) 과세증명서수급자 또는 차상위 계층 증명서(해당자에 한함)가족관계증명서(다문화 가정일 경우) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 부천장학재단',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '전문대생: 2500000원대학생: 3000000원',
      Col12: '공고일 현재 부·모 또는 본인이 1년 이상 부천시에 주민등록이 되어 있는 2자녀 이상 가구 중 부천시에 소재한 고등학교 졸업생 및 고졸 검정고시 출신으로 국내대학 재학생 중 2자녀 이상 가정',
      Col13: '공고일 현재 부·모 또는 본인이 1년 이상 부천시에 주민등록이 되어 있는 2자녀 이상 가구 중 부천시에 소재한 고등학교 졸업생 및 고졸 검정고시 출신으로 국내대학 재학생',
      Col14: '2022-03-21~2022-04-01',
      Col15: '자녀수 40점 + 학생수 30점 + 가족수 30점',
      Col16: '전문대생: 2명대학생: 11명',
      Col17: '가구별 1명 신청2022년에 타 기관(국가·학교·타 장학재단/기타)으로 부터 전액 장학금을 받은 학생부천장학재단 장학금을 같은 학제에서 4학기 이상 받은 학생초과 및 선택학기 신청불가원격·학점은행제 학생/ 사이버·디지털 대학/ 방송통신대/ 교환학생/ 휴학생/ 직업전문학교 학생 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학생선발 신청서재학증명서개인 신용정보 제공 및 조회 동의서/ 서약서 부·모 또는 본인의 주민등록 초본 (주소변동사항 포함)가족관계증명서 (부 또는 모 명의만 가능)고등학교 졸업증명서 또는 검정고시 합격증 해당학기 등록금 고지서 또는 납부영수증 2021년도 자원봉사 실적 확인서(연 40시간 이상 해당자)재학증명서(형제·자매가 대학생·전문대생일 경우)부 또는 모의 주민등록 등본 * 자세한 사항은 첨부파일 참고 '
    },
    {
      Col1: '재단법인 부천장학재단',
      Col2: '예·체능장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '전문대생: 2500000원대학생: 3000000원',
      Col12: '최근 2년이내(2020/ 2021년) 정부기관 또는 공신력 있는 기관 (단체)에서 주최한 시/도 단위 이상 대회에서 3위 이상 수상실적이 있는 학생 * 최근 2년 이내 수상실적 중 2021년도 장학생 선발은 수상실적에서 제외',
      Col13: '공고일 현재 부·모 또는 본인이 1년 이상 부천시에 주민등록이 되어 있는 2자녀 이상 가구 중 부천시에 소재한 고등학교 졸업생 및 고졸 검정고시 출신으로 국내대학 재학생 학생',
      Col14: '2022-03-18~2022-03-28',
      Col15: '입상(순위)점수 + 대회규모 점수',
      Col16: '전문대생: 1명대학생: 2명',
      Col17: '가구별 1명 신청2022년에 타 기관(국가·학교·타 장학재단/기타)으로 부터 전액 장학금을 받은 학생부천장학재단 장학금을 같은 학제에서 4학기 이상 받은 학생초과 및 선택학기 신청불가원격·학점은행제 학생/ 사이버·디지털 대학/ 방송통신대/ 교환학생/ 휴학생/ 직업전문학교 학생',
      Col18: '해당없음',
      Col19: '장학생선발 신청서재학증명서개인 신용정보 제공 및 조회 동의서/ 서약서 부·모 또는 본인의 주민등록 초본 (주소변동사항 포함)가족관계증명서 (부 또는 모 명의만 가능)고등학교 졸업증명서 또는 검정고시 합격증 해당학기 등록금 고지서 또는 납부영수증 2021년도 자원봉사 실적 확인서(연 40시간 이상 해당자)각종 대회 입상 관련자료  · 20202021 수상실적 증명 및 상장 · 대회 요강 ※ 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 수원시장학재단',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 고교 3학년 1/2학기 국어/ 수학/ 영어 과목 학업성적이 모두 본 재단이 정하는 표준화점수(S) 1.20  이상인 자.   * 재학생 20201학기 성적과 2학기 성적이 모두 평점 4.5만점 기준 A(4.0)학점 이상인 자복학생 및 교환학생은 최종직전 한 학기 성적이 평점 4.5만점 기준 A(4.0)학점 이상인 자',
      Col10: '해당없음',
      Col11: '1인당 2600000원',
      Col12: '해당없음',
      Col13: '공고일 현재 계속해서 2년이상 수원시에 주민등록을 두고 거주한 학생 (재학중인 학교에 소재한 지역에 주소를 둔 경우 부모님의 거주기간 인정) * 자세한 내용은 첨부파일 참고',
      Col14: '2022-03-18~2022-03-28',
      Col15: '해당없음',
      Col16: '100명',
      Col17: '정규학기외의 초과학기 학생조기 졸업 및 한 학기 수료 후 졸업예정자공고일 현재 휴학자 및 휴학예정자1세대 1명에 한하여 신청가능방송대학/ 통신대학/ 방송통신대학 및 사이버대학은 선발 배제',
      Col18: '해당없음',
      Col19: '우수장학금 신청서성적증명서2022년도 장학금 수혜/ 비수혜 확인서재학증명서주민등록 초본통장사본서약서개인(신용)정보 수집/ 이용/ 제공 및 조회 동의서 * 자세한 사항은 첨부자료 확인인'
    },
    {
      Col1: '재단법인 수원시장학재단',
      Col2: '희망장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생  대학수학능력시험 과목별 백분위 점수가 평균 70점 이상고등학교 3학년 1/2학기 성적 평균 70점 이상 * 재학생 20221학기 성적과 2학기 성적 모두 4.5 기준 평균 2.0 이상복학생 및 교환학생은 최종직전 한 학기 성적이 4.5 기준 2.0 이상',
      Col10: '저소득층 가정의 학생기초생활수급자 차상위계층 기준중위소득 90%이하 가정',
      Col11: '1인당 2600000원',
      Col12: '해당없음',
      Col13: '공고일 현재 계속해서 2년이상 수원시에 주민등록을 두고 거주한 학생 (재학중인 학교에 소재한 지역에 주소를 둔 경우 부모님의 거주기간 인정)',
      Col14: '2022-03-18~2022-03-28',
      Col15: '해당없음',
      Col16: '20명',
      Col17: '정규학기외의 초과학기 학생조기 졸업 및 한 학기 수료 후 졸업예정자공고일 현재 휴학자 및 휴학예정자1세대 1명에 한하여 신청가능방송대학/ 통신대학/ 방송통신대학 및 사이버대학은 선발 배제',
      Col18: '해당없음',
      Col19: '희망장학금 신청서가족관계증명서건강보험료 납부확인서2022년도 장학금 수혜·비수혜 확인서(재학 중인 학교에서 발급)통장사본서약서개인정보이용 동의서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 수원시장학재단',
      Col2: '과학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/자연계열',
      Col9: '재학생 : 2021년도 1/ 2학기 성적이 모두 평점 4.5만점 기준 3.5학점 이상인 자신입생 : 고등학교 3학년 1학기 국어/ 수학/ 영어 과목 학업성적과 2학기 국어/ 수학/ 영어과목 학업성적 모두 우리 재단이 정하는 3.5학점이상인 자고졸 검정고시 출신 신입생의 경우 국어/ 수학/ 영어 과목 성적이 모두 85점 이상인 자대학수학능력시험 과목별 백분위 점수가 평균 85점 이상',
      Col10: '해당없음',
      Col11: '1인당 2600000원',
      Col12: '해당없음',
      Col13: '공고일 현재 계속해서 2년 이상 수원시에 주민등록을 두고 거주한 학생',
      Col14: '2022-03-18~2022-03-28',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '정규학기외의 초과학기 학생조기 졸업 및 한 학기 수료 후 졸업예정자공고일 현재 휴학자 및 휴학예정자1세대 1명에 한하여 신청가능방송대학 /통신대학/방송통신대학 및 사이버대학은 선발 배제신입생',
      Col18: '해당없음',
      Col19: '과학장학금 신청서성적증명서2022년도 장학금 수혜·비수혜 확인서(재학 중인 학교에서 발급)주민등록 초본통장사본서약서개인정보이용 동의서 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '재단법인 수원시장학재단',
      Col2: '행복장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 대학수학능력시험 과목별 백분위 점수가 평균 75점 이상고등학교 3학년 1/2학기 성적 평균 75점 이상재학생 : 2021년 1/2학기 모두 12학점 이상 취득과 성적이 4.5만점 기준 평균 2.5학점 이상복학생 및 교환학생 : 최종직전 두 학기 모두 12학점 이상 취득과 성적이 4.5만점 기준 평균 2.5학점 이상상',
      Col10: '부모의 건강보험료 합산 금액장기요양보험료 제외 (*부모가 피부양자일 경우 자녀의 건강보험료로 대체)',
      Col11: '1인당 2600000원',
      Col12: '3자녀 이상 가정의 학생',
      Col13: '공고일 현재 계속해서 2년이상 수원시에 주민등록을 두고 거주한 학생',
      Col14: '2022-06-07~2022-06-17',
      Col15: '해당없음',
      Col16: '50명',
      Col17: '정규학기외의 초과학기 학생조기 졸업 및 한 학기 수료 후 졸업예정자공고일 현재 휴학자 및 휴학예정자1세대 1명에 한하여 신청가능방송대학 /통신대학/방송통신대학 및 사이버대학은 선발 배제',
      Col18: '해당없음',
      Col19: '행복장학금 신청서가족관계증명서건강보험자격확인서건강보험료 납부확인서의료급여증명서(해당자)2022년도 장학금 수혜·비수혜 확인서(재학 중인 학교에서 발급)재학증명서주민등록 초본통장사본서약서개인정보이용 동의서 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '오산교육재단',
      Col2: '우수인재장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학수학능력시험 결과 또는 고등학교 내신등급  평점이 2.5등급 이내인 자',
      Col10: '해당없음',
      Col11: '1학년 1학기 1회 지급 2000000원',
      Col12: '관내 고등학교를 졸업한 국내 소재 대학교 신입생',
      Col13: '본인 또는 부모/ 친권자 중 1명이 주민등록상 오산시에 1년 이상 계속 거주',
      Col14: '2022-06-07~2022-06-17',
      Col15: '학업성적90%/ 오산시 거주기간 5%/ 자원봉사활동실적 5%가점(실업계고등학교 졸업생 중) : 자격증 5점',
      Col16: '26명',
      Col17: '재학생 신청불가',
      Col18: '졸업한 고등학교 장 (만학도 및 검정고시 합격자 추천서 제외)',
      Col19: '장학금 지원신청서장학생 추천서주민등록초본(학생이름으로 출생부터 출력)[관내]고등학교 졸업증명서대학교 재학증명서생활기록부 (고등학교 전체)장학금 수혜(비수혜) 확인서개인정보 수집/이용/제공 및 조회 동의서대학수학능력시험 성적표(정시 입학자에 한함)소지자격증사본(실업계고 졸업생만) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '오산교육재단',
      Col2: '희망인재장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활보장수급자 저소득가정부모와 본인의 재산세 합산 부모의 건강보험료 합산 심사',
      Col11: '1학년 1학기 1회 지급 2000000원',
      Col12: '관내 고등학교 졸업한 국내 소재 대학교 신입생국민기초생활보장수급자저소득가정장애인세대(본인 또는 부모)편부모가정에 속한 학생',
      Col13: '본인 또는 부모/친권자 중 1명이 주민등록상 오산시에 1년 이상 계속 거주',
      Col14: '2022-06-07~2022-06-17',
      Col15: '학업성적 20%/ 생활정도 60% / 가족상황 10%/ 오산시 거주기간 10%가점 : 가족상황 10점/ 자원봉사활동실적 5점',
      Col16: '7명',
      Col17: '해당없음',
      Col18: '학교장 또는 거주지 동장 추천',
      Col19: '장학금 지원신청서장학생 추천서주민등록초본(학생이름으로 출생부터 출력)[관내]고등학교 졸업증명서대학교 재학증명서생활기록부(고등학교 전체)장학금 수혜(비수혜) 확인서개인정보 수집/ 이용/ 제공 및 조회 동의서대학수학능력시험 성적표(정시 입학자에 한함)장애인증명서(본인)(해당자)부동산확인서가족관계증명서 부 또는 모 앞재산세과세증명서 (본인/ 부/ 모 각각)건강보험료납부확인서 (부/ 모 각각) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '오산교육재단',
      Col2: '창의인재특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1학년 1학기 1회 지급 2000000원',
      Col12: '관내 고등학교 졸업한 대학 신입생장학생 선발 공고일 기준 최근 2년 이내에 중앙 행정기관 도는 전국대회 규모의 각급 대학 및 경기도/ 경기도교육청/ 오산시/ 화성오산교육지원청이 주최한 각종 대회에서 장려 또는 3위 이상 입상한 학생 * 자세한 내용은 첨부 파일 참고',
      Col13: '본인 또는 부모/친권자 중 1명이 주민등록상 오산시에 1년이상 계속 거주',
      Col14: '2022-06-07~2022-06-17',
      Col15: '입상 및 수상실적 90%/ 오산시 거주기간 10%가점: 국가대표 표창 5점',
      Col16: '6명',
      Col17: '해당없음',
      Col18: '졸업한 고등학교 학교장의 추천서',
      Col19: '장학금 지원신청서장학생 추천서주민등록초본(학생이름으로 출생부터 출력)[관내]고등학교 졸업증명서대학교 재학증명서생활기록부(고등학교 전체)장학금 수혜(비수혜) 확인서개인정보 수집/ 이용/ 제공 및 조회 동의서대학수학능력시험 성적표(정시 입학자에 한함)입상경력증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '오산교육재단',
      Col2: '근로자자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '내신등급 또는 대학수학능력 평가결과 영역별 평점이 5등급 이내인 학생생',
      Col10: '부모와 본인의 재산세 합산 부모의 건강보험료 합산 심사',
      Col11: '1학년 1학기 1회 지급 2000000원',
      Col12: '관내 기업에 5년 이상 근무 중인 근로자 자녀로 한국노총오산시지부장 추천을 받은 학생관내 고등학교를 졸업한 국내 소재 대학교 신입생',
      Col13: '본인 또는 부모/ 친권자 중 1명이 주민등록상 오산시에 1년 이상 계속 거주',
      Col14: '2022-06-07~2022-06-17',
      Col15: '학업성적 20%/ 생활정도 20%/ 가족상황 10%/ 오산시 거주기간 20%/ 재직기간 30%가점 : 자원봉사활동실적 5점/ 근로자의 기업체 발전기여도 (표창) 5점',
      Col16: '3명',
      Col17: '해당없음',
      Col18: '노동관련단체장 추천',
      Col19: '장학금 지원신청서장학생 추천서주민등록초본(학생이름으로 출생부터 출력)[관내]고등학교 졸업증명서대학교 재학증명서생활기록부(고등학교 전체)장학금 수혜(비수혜) 확인서개인정보 수집/ 이용/ 제공 및 조회 동의서대학수학능력시험 성적표(정시 입학자에 한함)기업체 재직증명서가족관계증명서(부 또는 모 앞)한국노총 오산시지부 장학생 추천서재산세과세증명서건강보험료납부확인서(부/ 모 각각)주민등록등본(세대주 기준) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '오산교육재단',
      Col2: '다자녀가정자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '부모와 본인의 재산세 부모의 건강보험료 합산 심사',
      Col11: '1학년 1학기 1회 지급 2000000원',
      Col12: '관내 고등학교를 졸업한 국내 소재 대학교 신입생3인 이상의 자녀를 양육하는 가정의 자녀인 학생 ',
      Col13: '본인 또는 부모/친권자 중 1명이 주민등록상 오산시에 1년 이상 계속 거주',
      Col14: '2022-06-07~2022-06-17',
      Col15: '학업성적 20%/ 생활정도 40%/ 가족상황 30%/ 오산시 거주기간 10%가점: 자원봉사활동 실적 5점',
      Col16: '7명',
      Col17: '해당없음',
      Col18: '학교장 또는 관계기관의 장 추천',
      Col19: '장학금 지원신청서장학금 추천서주민등록초본(학생이름으로 출생부터 출력)[관내]고등학교 졸업증명서대학교 재학증명서생활기록부(고등학교 전체)장학금 수혜(비수혜) 확인서개인정보 수집/ 이용/ 제공 및 조회 동의서대학수학능력시험 성적표(정시 입학자에 한함)가족관계증명서 부 또는 모 앞재산세과세증명서(본인/ 부/ 모 각각)건강보험료납부확인서(부/ 모 각각) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '오산교육재단',
      Col2: '다문화가정자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1학년 1학기 1회 지급 2000000원',
      Col12: '관내 고등학교를 졸업한 국내 소재 대학교 신입생다문화 가정의 자녀학교장 또는 관계기관장의 추천을 받은 학생',
      Col13: '본인 또는 부모/친권자 중 1명이 주민등록상 오산시에 1년 이상 계속 거주 ',
      Col14: '2022-06-07~2022-06-17',
      Col15: '성적 60%/ 오산시 거주기간 30%/ 자원봉사활동실적 10%',
      Col16: '3명',
      Col17: '해당없음',
      Col18: '학교장 또는 관계기관 장의 추천',
      Col19: '장학금 지원신청서장학금 추천서주민등록초본(학생이름으로 출생부터 출력)[관내]고등학교 졸업증명서대학교 재학증명서생활기록부(고등학교 전체)장학금 수혜(비수혜) 확인서개인정보 수집/ 이용/ 제공 및 조회 동의서서대학수학능력시험 성적표(정시 입학자에 한함)가족관계증명서 부 또는 모 앞 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '오산교육재단',
      Col2: '지역인재육성',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '일반:  관내 고등학교를 졸업한 관내 대학교 (한신대/ 오산대) 신입생만학도: 관내 5년 이상 거주하며 관내 대학교에 진학한 30세 이상의 신입생',
      Col13: '본인 또는 부모/친권자 중 1명이 주민등록상 오산시에 1년 이상 계속 거주',
      Col14: '2022-04-01~2022-04-14',
      Col15: '일반: 학업성적 70%/ 오산시 거주기간 20%/ 자원봉사활동실적 10%만학도: 학업성적 90%/ 오산시 거주기간 10%/ (가점) 자원봉사활동실적 5점 * 자세한 사항은 첨부파일 참고',
      Col16: '13명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 지원신청서장학생 추천서주민등록초본(학생이름으로 출생부터 출력)[관내]고등학교 졸업증명서대학교 재학증명서생활기록부(고등학교 전체)장학금 수혜(비수혜) 확인서개인정보 수집/ 이용/ 제공 및 조회 동의서대학수학능력시험 성적표(정시 입학자에 한함) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)의정부시민장학회',
      Col2: '인재육성장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '국내에 소재하는 대학 및 전문대학에 재학중인자로서 직전학년의 평균학점이 B학점(B0) 이상인 학생신입생의 경우 수능 성적표 합산총점 평균점수 70점 이상 또는 내신 성적 고등학교 3학년 합산총점 평균점수 70점 이상 학생검정고시 학생은 검정고시 성적표 기준 평균점수 70점 이상 학생',
      Col10: '해당없음',
      Col11: '1500000원 * 2학기 별도 선발하지 않으며 장학금은 학기별로 50%씩 지급',
      Col12: '국내에 소재하는 대학 및 전문대학에 재학중이거나/ 입학예정인 학생',
      Col13: '공고일 기준으로 의정부시에 주민등록을 두고 3년 이상 거주한 시민 및 시민의 자녀 ',
      Col14: '2020-03-03~2020-04-03',
      Col15: '성 적(40%) + 소득(50%) + 자원봉사 (5%) + 장애인 (5%)',
      Col16: '90명',
      Col17: '등록금 전액을 국가/ 자치단체와 그 출연기관/ 학교 등으로부터 지원 받은 대학생(성적 장학금 포함) * 자세한 사항은 첨부파일 참고 필수',
      Col18: '해당없음',
      Col19: '장학생 선발신청서직전학년 성적증명서재학증명서주민등록등본한국장학재단 학자금 지원구간 통지서(221학기 기준)학생 본인통장 사본2021년도 자원봉사활동 실적 확인서장애인 증명서(부모 또는 본인이 해당하는 경우)가족관계증명서(3인 이상 다자녀 가구 해당하는 경우) * 자세한 사항은 첨부파일 및 홈페이지 참고'
    },
    {
      Col1: '재)화성시인재육성재단',
      Col2: '창의지성인재(특기장학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '특기장학생들의 피아노/ 현악/ 기악/ 무용/ 국악 등 공연특기장학생들의 동양화/ 서양화/ 조소/ 공예품 등 작품 전시2019년 교육/ 문화/ 체육/ 예술/ IT분야 등 시/도 단위 이상 각종 대회에서 수상한 중/고등학교 학생',
      Col13: '공고일 기준 화성시에 2년 이상 거주하고 있는 관내 대학생(개인/ 팀)',
      Col14: '2022-01-24~2022-02-09',
      Col15: '1차 서류심사(활동내역/ 노력/ 의지/수상내역 등)2차 실기심사(창의력/작품성/발표력 등)',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '대학교 총장의 추천',
      Col19: '장학생 지원 신청서 (별지 1호 서식)장학금 수혜/ 비수혜 확인서 (별지 2호 서식)개인신용정보 등의 제공/활용 동의서 (별지 3호 서식)신청인 서약서 ( 별지 4호 서식)신청자(대학생) 또는 부모/ 친권자의 주민등록 초본 (최근 10년 주소이력 포함)신청자 (대학생) 기준의 가족관계증명서 * 편부/편모 일 경우 부 또는 모의 혼인관개증명서 상세본 제출재학증명서등록금 납부 내역서저소득층 확인서 (해당하는 자)  : 수급자 증명서/ 자활근로확인서/ 한부모 가족보호대상자확인서/ 장애인연금/ 수당/ 장애아동수급확인서 등등'
    },
    {
      Col1: '(재)영월장학회',
      Col2: '일반대학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '누적 이수학점이 평균 30학점 이상이고 직전학년 성적이 평점 3.3점 이상인 자(계절학기 포함)',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '4년제 이상 대학교 신입생 및 재학생',
      Col13: '공고일 현재 영월군에 3년 이상 주소를 두고 있는 자영월군 관내 고등학교를 졸업한 자',
      Col14: '2022-01-24~2022-02-09',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '중복수혜 제한',
      Col18: '해당없음',
      Col19: '복학(예정)증명서성적증명서고등학교 졸업증명서신청년도 2학기 등록금 고지서주민등록초본(주소이력사항 포함)개인(신용)정보 수집·이용·제공 및 조회동의서신청인 서약서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '(재)영월장학회',
      Col2: '특정대학교',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: ' * 서울대학교/Kaist/Postech/Gist/ Unist/ 수.의예과/ 한의예과/ 약대/ 치대 이상 신입생 및 재학생',
      Col13: '공고일 현재 영월군에 3년 이상 주소를 두고 있는 자영월군 관내 고등학교를 졸업한 자',
      Col14: '2022-01-24~2022-02-09',
      Col15: '해당없음',
      Col16: '전원',
      Col17: '중복수혜 제한',
      Col18: '해당없음',
      Col19: '복학(예정)증명서성적증명서고등학교 졸업증명서신청년도 등록금 납입고지서 주민등록초본(주소이력사항포함)개인(신용)정보 수집·이용·제공 및 조회동의서신청인 서약서 ※ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '(재)영월장학회',
      Col2: '예체능특기대학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생공고일 기준으로 1년 이내 도단위대회 또는 전국대회 규모이상의 대회에서 3위 이내로 입상하고/ 예체능 특기 장학생으로 입학한 경우 * 재학생공고일 현재 1년 이내 도단위대회 또는 전국대회 규모이상의 대회에서 3위 이내로 입상한 경우',
      Col10: '해당없음',
      Col11: ' * 1회 선발 2회 지급1500000원',
      Col12: '예체능 특기 대학생은 전문대 4년 과정을 포함',
      Col13: '공고일 현재 영월군에 3년 이상 주소를 두고 있는 자영월군 관내 고등학교를 졸업한 자',
      Col14: '2022-02-21~2022-03-18',
      Col15: '해당없음',
      Col16: '10명(5) * 예체능특기생 선발예정인원 대비 선발인원 미달 시 전문대 4년 과정 5명까지 선발',
      Col17: '중복수혜 제한',
      Col18: '해당없음',
      Col19: ' * 공통서류주민등록초본(주소이력사항포함)개인(신용)정보 수집이용제공 및 조회동의서 및 신청인 서약서(모두 학생 본인의 자필 서명)신청년도 등록금 납입고지서 (신청기간 중 나오지 않은 경우 추후 제출 가능) * 신입생대학합격 통지서 사본수능성적표 사본 1부 또는 성적증명서 1부 중 택1 (학생 본인에게 유리한 성적으로 제출(내신성적의 경우 3학년 1학기 수능반영 교과만 평가)고등학교 졸업예정증명서도 단위 및 전국단위 수상실적증명서 사본 1부(예체능계 지원자에 한함) * 재학생재학증명서전(前)학년 성적증명서 1부(4.3 만점인 대학 중 4.5 만점으로 환산하여 제출 가능한 학교 경우 환산된 성적 증명서 제출)고등학교 졸업증명서'
    },
    {
      Col1: '재단법인고성향토장학회',
      Col2: '주민자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생: 고등학교 성적이 평균 교과등급 4등급 이상인 자 * 재학생: 직전학년 성적이 3.0(4.5점만점)이상인 자 * 검정고시 합격자는 평균 득점이 70점(100점만점)이상인 자 * 경동대 재학생(신입생 포함):  1/ 2학기(학년) 평균 3.0(4.5점만점)이상인 자',
      Col10: '해당없음',
      Col11: '2500000원',
      Col12: '학업성적이 우수한 자',
      Col13: '친권자 또는 후견인(본인)이 장학생선발기준(공고)일로부터 1년전에 강원도 고성군에 주민등록이 등재되고/ 가족이 실제 계속 거주하는자',
      Col14: '2022-02-09~2022-02-28',
      Col15: '해당없음',
      Col16: '일반: 49명읍면장: 5명경동대: 4명다자녀: 7명희망드림 : 45명  ',
      Col17: '동일년도 1가구 1명만 지급강원도 고성군에서 지급하는 2021년도 각종 장학금 수령자2021년도 고성향토장학회 장학금 기수혜자농어민자녀 고교생학자금 수혜자당해연도 특별장학금 수혜자 * 단/ 국민기초생활수급대상 주민자녀 학자금 등 생활보조금 차원의 학자금 수혜대상자는 선발 가능대학원생 제외 ',
      Col18: '해당없음',
      Col19: '장학생 지원서힉교장 추천서신입생은 대학 재학증명서 및 최종학교 성적증명서재학생은 재 증명서 및 최종학년 성적증명서반명함판 사진2매주민등록등본 1부(친권자(후견인)또는 학생)개인(신용)정보 수집/이용/제공 및 조회 동의서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '(재)삼척향토장학재단',
      Col2: '향토장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 졸업학교 고3 평균 교과등급 성적이 4등급 이상인자 또는 검정고시 평균 70점 이상인자전년도 예체능 도단위 이상 대회 3위 이내 입상한 자 * 재학생 전(前)학년 2개 학기 평균성적이 B0학점 이상인 자 **편인샙은 전 대학 전 학년 2개 학기의 평균성적이 B0학점 이상인 자',
      Col10: '해당없음',
      Col11: '2000000원 주소전입의 경우 1000000원 ',
      Col12: '가정형편이 어려운 학생 우선 선발 (기초생활수급자/ 차상위계층 등)',
      Col13: '본인 또는 친권자의 주소가 공고일 이전부터 주민등록상 삼척시에 2년 이상 거주한 자/ 공고일 현재 만 39세 이하인 자 * 강원대 삼척(도계)캠퍼스 주소전입 대학생은 주소전입일로부터 6개월 경과한 자.',
      Col14: '2022-02-14~2022-03-11',
      Col15: '해당없음',
      Col16: '245명 ',
      Col17: '저소득층 자녀 장학금과 중복일 경우 지급 제외국가장학금 등 중복수혜여부 확인원격대학 및 기술대학/ 학점인정 등에 관한 법률에 따른 평가 인정기관/ 평생교육시설 직업훈련기관 제외대학원생 제외',
      Col18: '총장(학장) 또는 학교장 추천',
      Col19: ' * 공통서류 *장학금신청서개인정보 제공 동의서주민등록등본소득금액증명원세목별 과세증명서통장사본기타서류  * 자세한 내용은 홈페이지 참조 바람람 * 신입생 *대학합격통지서고등학교 3학년 성적증명서검정고시 성적증명서대회 입상 상장 사본 (해당자) * 재학생 *재학증명서직전학년 성적증명서 * 접수장소 : 삼척시청 총무과 / 읍면사무소 및 동주민센터 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '양록장학회',
      Col2: '학력우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 입학생 : 고등학교 3학년 재적한년 정원의 20/100 이내 또는 수능영역 합산 평균등급 3등급 이내 또는 검정고시 평균득점 80점 이상재학생 : 직전 1/2학기 학업성적 평점평균이 3.0학점 이상인 자 (4.5만점 기준)복학생: 최종 2개 학기 성적 평점평균 3.0학점 이상(4.5만점 기준) * 4.3만점은 2.84점 이상 ※ 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '대학교 입학생 또는 재학생',
      Col13: '장학생 선발 공고일 현재 학생 본인 또는 학생의 부모가 관내에 주소를 두고 1년 이상 계속하여 거주한 자  ',
      Col14: '2022-02-14~2022-03-11',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2021년 졸업예정자 제외기존 중복지원자로 등록된 학생의 경우 장학금 지급 제한에 유의원격대학·평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원받는 특수대학공무원/ 회사원 등 직업소유자 ',
      Col18: '해당없음',
      Col19: '양록장학생 지원서서약서개인정보 수집·이용 및 제3자 제공 동의서통장사본학생 본인 이나 부모의 주민등록초본 또는 등본학생 본인 및 부모의 주민등록 또는 등본 (관내 중학교 미졸업자)중학교 졸업증명서성적증명서합격통지서 (입학생)교육비 납입증명서재학증명서 (재학생)  * 자세한 사항은 양구군청 홈페이지 내 고시/공고에 올라온 제출서류목록 참고'
    },
    {
      Col1: '양록장학회',
      Col2: '예체능특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '국내외 대학교 입학생 및 재학생도 단위 공인대회 1위 입상전국단위 또는 국제단위 공인대회 3위 이내 입상 ',
      Col13: '장학생 선발 공고일 현재 학생 본인 또는 학생의 부모가 관내에 주소를 두고 1년 이상 계속하여 거주한 자 ',
      Col14: '2022-02-14~2022-03-11',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '원격대학·평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원받는 특수대학공무원/ 회사원 등 직업소유자   ',
      Col18: '해당없음',
      Col19: '양록장학생 지원서서약서개인정보 수집·이용 및 제3자 제공 동의서통장사본학생 본인 이나 부모의 주민등록초본 또는 등본학생 본인 및 부모의 주민등록 또는 등본 (관내 중학교 미졸업자)합격통지서 또는 재학증명서교육비 납입증명서성적 또는 실적을 증명하는 서류 * 자세한 사항은 양구군청 홈페이지 고시/공고에 올라온 제출서류목록 참고'
    },
    {
      Col1: '양록장학회',
      Col2: '특별장학금(저소득주민자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '입학생: 고등학교 3학년 재적학년 정원의 60/100 이내 또는 수능영역 합산 평균등급 5등급 이내재학생: 직전 1/2학기 성적 평점평균 2.5학점 이상복학생: 최종 2개 학기 성적 평점평균 2.5학점 이상',
      Col10: '국민기초생활수급자 및 저소득 차상위계층의 자녀 또는 본인',
      Col11: '2000000원',
      Col12: '국내 대학의 입학생 및 재학생',
      Col13: '장학생 선발 공고일 현재 학생 본인 또는 학생의 부모가 관내에 주소를 두고 1년 이상 계속하여 거주한 자',
      Col14: '2022-01-12~2022-02-09',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '원격대학·평생교육법에 의한 학점은행제 교육원 및 전문학교 생활비를 지원받는 특수대학공무원/ 회사원 등 직업소유자',
      Col18: '대학교 학교장의 추천을 받은 재학생(성적기준 없음) ',
      Col19: '양록장학생 지원서서약서개인정보 수집·이용 및 제3자 제공 동의서통장사본학생 본인 이나 부모의 주민등록초본 또는 등본학생 본인 및 부모의 주민등록 또는 등본 (관내 중학교 미졸업자)고등학교 3학년 성적증명서(입학생)합격통지서(입학생)성적증명서(재학생)재학증명서(재학생)교육비 납입증명서기초수급자 및 저소득 차상위계층 증명서대학교 학교장의 추천서 (성적증명서 미제출자) * 자세한 사항은 양구군청 홈페이지 고시/공고에 올라온 제출서류목록 참고'
    },
    {
      Col1: '(재)인제군장학회',
      Col2: '대학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생  성적에 관계없이 대학 진학예정자에 대해 모두 지급 * 재학생직전학년 성적이 2.5/ 4.5점 이상인 자. 다만/ 복학생의 경우 최종 2개 학기 성적이 2.5/ 4.5 이상인 자',
      Col10: '해당없음',
      Col11: '대학생 3500000원 한도 내에서 지급',
      Col12: '신청자 중 고득점자 순저소득층/ 장애인의 자녀 및 예체능 특기자 우선 선발 후 일반 대학생 성적순 선발',
      Col13: '신청일 현재 관내에 주소를 두고1년 이상 거주하고 있는 군민의 자녀 또는 본인부모 또는 보호자 중 한명 이상이 인제군 관내에 거주하면서 학업을 위하여 단독세대로 주소지를 이전한 학생',
      Col14: '2021-01-11~2021-02-03',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '중복지원제한대학원생/ 원격대학/ 야간대학/ 외국대학/ 직장인 제외평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원받는 특수대학대학졸업예정자/ 휴학예정자/ 신청학기 성적으로 기 장학금을 지급받은 이력이 있는 자 ',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록등본개인(신용)정보 수집/이용/제공 및 조회 동의서학자금이중지원반환 신청인 서약서재학증명서(신입생은 합격증명서 및 등록금 영수증 사본)성적증명서(4.5만점 기준 성적표)신입생은 고등학교 성적증명서(최종학년 1/2학기) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)인제군장학회',
      Col2: '예/체능특기자장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '예체능계열',
      Col9: '도단위 공인대회 2위 이내 또는 전국단위 공인대회 3위이내로 직전년도에 입상한 경력이 있는 자.(단체전 포함) 다만/ 1/2부로 나눠진 대회/ 학년별 대회는 제외/ 복학생의 경우 직전 학년도 또는 휴학기간 중에 입상한 경력 포함.',
      Col10: '해당없음',
      Col11: '대학생은 3000000원 한도 내에서 지급',
      Col12: '신청자 중 고득점자 순저소득층/ 장애인의 자녀  및 예체능특기자 우선 선발 후 일반 대학생 성적순 선발',
      Col13: '신청일 현재 관내에 주소를 두고 1년 이상 거주하고 있는 군민의 자녀 또는 본인부모 또는 보호자 중 한명 이상이 인제군 관내에 거주하면서 학업을 위하여 단독세대로 주소지를 이전한 학생',
      Col14: '2022-02-21~2022-03-11',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '중복지원제한대학원생/ 원격대학/ 야간대학/ 외국대학/ 직장인평생교육법에 의한 학점은행제 교육원 및 전문학교생활비를 지원받는 특수대학대학졸업예정자/ 휴학예정자/ 신청학기 성적으로 기 장학금을 지급받은 이력이 있는 자 ',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록등본개인(신용)정보 수집/이용/제공 및 조회 동의서학자금이중지원반환 신청인 서약서재학증명서성적증명서(4.5만점 기준 성적표)신입생은 고등학교성적증명서(최종학년 1/2학기)입상경력을 증명할 수 있는 서류(상장/ 증명 등) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인정선장학회',
      Col2: '일반장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원 한도 * 학자금과 거주지원금 합산 금액',
      Col12: '해당없음',
      Col13: '공고일 현재 보호자의 주소가 강원도 정선군인 전문대 이상 대학의 신입생 및 재학생 (단/ 선발요강 게시일 기준 전입 1년 이내 제외/ 전문대생은 관내 고등학교 졸업생만 선발)',
      Col14: '해당없음',
      Col15: '장학회 이사회에서  종합적으로 판단 심의 결정',
      Col16: '374명 ',
      Col17: ' 한국방송통신대학교/ 기술대학/ 각종 학교(고등교육기관)/ 원격대학(사이버대학)/ 사내대학/ 국외대학/ 대학원 제외한국장학재단에 등재된 중복수혜자휴학 등 학업중단 학생 및 장학금 수혜총액이 등록금을 초과하는 자',
      Col18: '해당없음',
      Col19: '장학금 지급 신청서1학기 등록금 납입확인서 또는 납입영수증 사본통장사본(해당자)주민등록 초본(병역사항 포함)(해당자)부동산 임대차 계약서 사본 또는 기숙사비 납부영수증증'
    },
    {
      Col1: '재단법인정선장학회',
      Col2: '특별장학금(지역핵심인재전형)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 2개 학기의 평균평점이 3.0학점(4.5만점 기준) 이상',
      Col10: '해당없음',
      Col11: '2000000원원',
      Col12: ' 2010~2013학년도에 지역핵심인재전형으로 입학(숙명여대/춘천교대)하여 재학중인 학생',
      Col13: '후견인의 주소가 강원도 정선군인 전문대 이상 대학의 재학생 (단/ 선발요강 게시일 기준 전입 1년 이내 제외)',
      Col14: '해당없음',
      Col15: '장학회 이사회에서  종합적으로 판단 심의 결정',
      Col16: '224명(모든 장학금 포함)',
      Col17: ' 한국방송통신대학교/ 기술대학/ 각종 학교(고등교육기관)/ 원격대학(사이버대학)/ 사내대학/ 국외대학/ 대학원 제외한국장학재단에 등재된 중복수혜자 및 강원학사/ 향토학사 입사자 제외1인 2회(1회는 1년)에 한하여 선발.(단/ 중복수혜자는 등록금 범위내 차액 지급)',
      Col18: '해당없음',
      Col19: '제출서류 1. 신입생장학생지원서(제1호 서식) 1부.대학합격증명서 1부.  (합격 미발표자는 3.7(금)까지 별도제출 가능)수능성적표(사본) 1부.(수능 미응시학생은 고교 성적증명서)2. 재학생장학생지원서(제1호서식) 1부.직前 2개학기 성적증명서 1부.전문대 대학생은 고교졸업증명서 1부.주민등록등본(주소이력 포함) 1부건강보험납부확인서 또는 건강보험 자격득실확인서 : 2016년도분(저소득층 자녀 신청자에 한함. 부모 모두 제출) ※ 대학생 2명 이상 가구(다자녀) 신청자는 증빙자료 제출 ※ 공고문 참조'
    },
    {
      Col1: '재단법인정선장학회',
      Col2: '아리랑관련대학진학/재학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '계속장학생: 직전 2개 학기의 평균평점이 3.0학점(4.5만점 기준) 이상인 학생',
      Col10: '해당없음',
      Col11: '전문대 대학생 1500000원4년제 대학생 2000000원',
      Col12: '관내 고교 졸업생으로서 공공기관에서 주관한 정선아리랑 관련대회에서 3위이내 입상한후 대학교 관련 학과에 입학/재학생',
      Col13: '1. 후견인의 주소가 강원도 정선군인 전문대 이상 대학의 신입생 및 재학생 (단/ 선발요강 게시일 기준 전입 1년 이내 제외/ 전문대생은 관내 고등학교 졸업생만 선발)2. 군 관내 고등학교 졸업자',
      Col14: '2020-10-19~2020-10-30',
      Col15: '장학회 이사회에서  종합적으로 판단 심의 결정',
      Col16: '해당없음',
      Col17: ' 한국방송통신대학교/ 기술대학/ 각종 학교(고등교육기관)/ 원격대학(사이버대학)/ 사내대학/ 국외대학/ 대학원 제외',
      Col18: '출신 학교장 추천',
      Col19: '1. 신입생장학생지원서(제1호 서식) 1부.대학합격증명서 1부. (합격 미발표자는 3.2.(금)까지 별도제출 가능)수능성적표(사본) 1부.장학생 추천서(제5호 서식) 및 고교성적증명서(수능 미응시 학생) 1부.주민등록등본(주소이력 포함) 1부.가족관계증명서(학생의 주소지가 정선군이 아닐 경우) 1부.검정고시 합격자의 경우 합격 성적표(사본) 1부.2. 재학생장학생지원서(제1호서식) 1부.직전 2개학기 성적증명서 1부.재학증명서 1부.주민등록등본(주소이력 포함) 1부건강보험납부확인서 또는 건강보험 자격득실확인서 : 직전년도분 (저소득층 자녀 신청자에 한함. 부모 모두 제출)※ 다자녀 신청자는 증빙자료 제출(가족관계증명서/ 재학증명서 등)장학생지원서(제1호 서식) 1부상장/ 표창장 사본 1부주민등록등본(주소이력 포함) 1부 ※ 공고문 참조'
    },
    {
      Col1: '(재)진천군장학회',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 백분율 환산점수가 80점 이상인 자최소 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '전문대생 1000000원일반대생 2000000원',
      Col12: '관내/ 관외 대학교 일반·전문대학교 재학생으로 성적우수자',
      Col13: '공고일 현재 1년 이상 진천군에 주소를 두고 계속 거주하고 있는 군민 또는 군민의 자녀',
      Col14: '2020-10-19~2020-10-30',
      Col15: '성적70%/ 소득수준 30%',
      Col16: ' * 총 76명전문대생 10명일반대생 66명',
      Col17: '졸업반 제외초과학기자 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서재학증명서주민등록등본가족관계증명서개인정보 수집·이용·제공 동의서통장사본성적증명서타 장학금 수혜·미수혜 증명서건강보험료 납부확인서 또는 자격득실확인서기초생활수급자/ 차상위계층/ 한부모가족 확인서(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '(재)진천군장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '체육·예능·기능 등에서 탁월한 능력을 발휘한 자로서 공공기관이 주최·주관한 도대회 이상 3위 이내 입상자 * 입상 인정기간 : 2020. 1. ~ 2020. 10. 장학금 신청 접수일까지',
      Col13: '공고일 현재 1년 이상 진천군에 주소를 두고(주민등록 상) 계속 거주하고 있는 군민 또는 군민의 자녀',
      Col14: '2022-08-11~2022-09-02',
      Col15: '세계대회 > 아시아대회 > 전국대회 > 도대회',
      Col16: '2명',
      Col17: '졸업반 제외(재)진천군장학회 직전년도 특기장학생 선발자 중복 신청 불가',
      Col18: '해당없음',
      Col19: '장학생 신청서재학증명서주민등록등본가족관계증명서개인정보 수집·이용·제공 동의서통장사본입상 증빙자료타 장학금 수혜·미수혜 증명서건강보험료 납부확인서 또는 자격득실확인서기초생활수급자/ 차상위계층/ 한부모가족 확인서(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 충북인재양성재단',
      Col2: '성적장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '12학점 이상 이수(패스과목 제외하고 평점산출 9학점 이상) * 수능성적 평가전형 * 고교내신 평가전형 및 기타전형(해외대학생 포함)  * 각 전형별 자세한 사항은 첨부파일 참고',
      Col10: '소득수준 30% 반영 * 소득수준은 부모의 건강보험료 납부액으로 평가',
      Col11: '2000000원',
      Col12: '공고일 현재 1년 이상 도내에 주소를 두고 계속 거주하는 도민 및 도민의 자녀로서 국내·외 대학생 중 성적우수자수능 평가전형과 고교내신 평가전형 중 선택하여 신청',
      Col13: '공고일 현재 1년 이상 도내에 주소를 두고 계속 거주하는 도민 및 도민의 자녀로서 국내·외 대학생 * 거주기간이 1년 미만일 경우 과거 5년이상 거주한 사실이 있는 도민도 신청가능',
      Col14: '2022-08-11~2022-09-02',
      Col15: '성적 70% + 소득수준 30%동점자 처리 : 소득수준/ 학교성적/ 고학년 순',
      Col16: '150명',
      Col17: '중복수혜를 금지한 기관의 장학금을 받은 자정규학기를 초과해 재학 중인 자(졸업유예자 불가)22년 2학기 휴학 예정자직전학기 12학점 미만 이수한 자장학금 수혜 연 1회 제한육사/ 해사/ 공사/ 경찰대 등 전액 국비지원을 받는 자 등학점은행제/ 평생교육원/ 전문학교 등 제외',
      Col18: '해당없음',
      Col19: ' *온라인 접수 후 1차 합격자를 대상으로 서류 제출 * 1차 합격자를 대상으로 하는 제출 서류들은 각 조건 마다 다르므로 첨부파일에서 확인 바람주민등록등본가족관계증명서통장사본건강보험료 납부확인서 또는 자격득실확인서재학증명서직전학기 백분위환산점수가 표기된 전학년 대학성적표대학수학능력시험 성적표(수능성적 평가전형)고등학교 생활기록부자기소개서 수상 및 성취실적/ 봉사활동 증빙자료'
    },
    {
      Col1: '재단법인 충북인재양성재단',
      Col2: '수도권장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' ※ 대학성적은 직전학기 12학점이상 이수/ 백분위 환산점수로 평가 * 수능성적 평가전형 * 고등학교 내신평가 전형* 전형별 자세한 사항은 첨부파일 참고',
      Col10: '소득수준 30% 반영 * 소득수준은 부모의 건강보험료 납부액으로(\'19년 7월~12월 평균금액)평가',
      Col11: '2000000원',
      Col12: '서울/ 경기/ 인천지역(학교 소재지 기준) 대학교 재학생',
      Col13: '공고일 현재 1년 이상 도내에 주소를 두고 계속 거주하는 도민 및 도민의 자녀 * 거주기간이 1년 미만일 경우 과거 5년 이상 거주한 사실이 있는 도민도 신청 가능',
      Col14: '2022-08-11~2022-09-02',
      Col15: '성적 70% + 소득 30%',
      Col16: '45명',
      Col17: '중복수혜를 금지한 기관의 장학금을 받은 자정규 학기를 초과하여 재학 중인 자(졸업유예 불가)충북학사(충북미래관) 재사생학점은행제/ 평생교육원/ 전문학교 등은 지원제외성적장학금과 중복 선정될 경우 수도권장학금 우선',
      Col18: '해당없음',
      Col19: '온라인 접수 후 합격자를 대상으로 서류 제출 * 1차 합격자를 대상으로 하는 제출 서류들은 각 조건 마다 다르므로 첨부파일에서 확인 바람 * 수도권 장학금 지원자는 자악생 온라인 지원 시 성적장학금과 중복지원 선택'
    },
    {
      Col1: '재단법인 충북인재양성재단',
      Col2: '특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '부모 건강보험료 납부액 평균금액(22.1.1 ~ 6.30) 평가',
      Col11: '2000000원 * 기능분야 : 금메달 200만원 은메달 150만원 동메달 100백만원',
      Col12: ' * 공공기관 및 민간단체가 주최/주관한 전국규모 이상 대회 3위 이상 수상자단체 수상한 경우 학교장 추천을 받은 1명만 신청체육분야 단체 수상의 경우 전국 4강~8강 실적도 신청가능세계대회의 경우 4위~8위 실적도 신청가능기능분야는 2022년 전국기능대회/ 영농학생축제/ 상업경진대회 실적',
      Col13: '공고일 현재 1년 이상 도내에 주소를 두고 계속 거주하는 도민 및 도민의 자녀 * 거주기간이 1년 미만일 경우 과거 5년 이상 거주한 사실이 있는 도민도 신청 가능',
      Col14: '2022-08-11~2022-09-02',
      Col15: '수상실적 70% + 소득수준 30%수상실적 평가기간 : 21.7.1 ~ 22.6.30각 분야별 전문평가위원회에서 대회규모/ 주최기관/ 대회의 공신력 등을 평가동점자 처리: 소득수준/ 고학년순',
      Col16: '100명(초·중·고 선발인원 포함)',
      Col17: '중복수혜를 금지한 기관의 장학금을 받은 자정규학기를 초과해 재학 중인 자22년 2학기 휴학 예정인 자장학금 수혜 연1회 제한(기초생활수급대상자는 신청 가능)육사/ 해사/ 공사/ 경찰대 등 등록금 전액 국비지원을 받는 자충북학사 서서울관/ 동서울관/ 청주관 재사생',
      Col18: '단체 수상의 경우 학교장 추천 필요',
      Col19: ' * 온라인 접수 후 합격자를 대상으로 서류 제출 * 1차 합격자를 대상으로 하는 제출 서류들은 각 조건 마다 다르므로 첨부파일에서 확인 바람주민등록등본가족관계증명서(해당자)통장 사본수상실적 증빙자료재학증명서추천서(단체 해당자)건강보험 납부확인서 또는 자격득실확인서 ※ 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 충북인재양성재단',
      Col2: '곰두리장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점이상 이수(패스과목 제외하고 평점산출 9학점 이상)2022년 2학기 복학생은 휴학 직전학기 성적 평가',
      Col10: '부모 건강보험료 납부액 평균금액(22.1.1.~6.30) 평가가',
      Col11: '2000000원',
      Col12: ' * 선발분야 : 학업/ 예술/ 체육/ 기능/ 기타분야에 뛰어난 능력을 지닌 장애학생예술·체육·기능분야 :공공기관 및 민간단체가 주최/ 주관한 도단위 이상 대회에서 입상실적이 있는 자(단체의 경우 학교장 추천을 받은 팀원 1명 추천)학업분야 : 대학교에 재학 중인 자기타분야 : 특정분야에서 뛰어난 능력을 지닌 자(발명/ 특허 등)',
      Col13: '공고일 현재 1년 이상 도내에 주소를 두고 계속 거주하는 도민 또는 도미의 자녀로서 대학교에 재학 중인 장애학생 * 거주기간이 1년 미만일 경우 과거 5년 이상 거주한 사실이 있는 도민도 신청 가능',
      Col14: '2020-08-03~2020-09-04',
      Col15: '성적·수상·성취실적 50% + 소득수준 50%',
      Col16: '30명(초·중·고·대학생 포함)',
      Col17: '중복수혜를 금지한 기관의 장학금을 받은 자정규학기 초과자장학금 수혜 연 1회 제한2022년 2학기 휴학 예정자육군/ 해사/ 공사/ 경찰대 등 등록금 전액 국비지원 받는 자충북학사 서서울관·동서울관/ 청주관 재사생직전학기 12학점 미만 이수한 자 (대학생 학업문야)',
      Col18: '해당없음',
      Col19: ' * 온라인 접수 후 합격자를 대상으로 서류 제출 * 1차 합격자를 대상으로 하는 제출 서류들은 각 조건마다 다르므로 첨부파일에서 확인 바람주민등록등본가족관계증명서(해당자)통장 사본장애인등록증 또는 장애인복지카드건강보험 납부확인서 또는 자격득실확인서분야별 서류'
    },
    {
      Col1: '재단법인 충북인재양성재단',
      Col2: '도내대학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점이상 이수',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: ' * 도내 대학 목록강동대/ 건국대(글로벌캠퍼스)/ 극동대/ 꽃동네대/ 대원대/ 서원대/ 세명대/ 영동대/ 우석대(진천캠퍼스)/ 중원대/ 청주교육대/ 청주대/ 충북대/ 충북도립대/ 충북보건과학대/ 충청대/ 한국교원대/ 한국교통대/ 한국폴리텍ⅳ대학 청주캠퍼스 (총 19개 학교)',
      Col13: '공고일 기준 1년 이상 도내에 주소를 두고 계속 거주하는 도민으로서 도내 대학에 재학 중인 자 * 과거 5년 이상 거주한 사실이 있는 도민도 신청 가능',
      Col14: '2021-05-03~2021-06-04',
      Col15: '대학별 심사 및 추천> 장학생 선발위원회 심의',
      Col16: '62명 ( * 도내 대학별 선발인원은 별첨 참조)',
      Col17: '20년도 상반기 충북인재양성재단 장학생 선발된 자정규 학제 기간 초과 재학자직전학기 12학점 미만 이수자휴학예정자충북학사 서서울관·동서울관·청주관 재사생 * 자세한 사항 첨부파일 참조',
      Col18: '대학교 총장의 추천',
      Col19: '지원신청서주민등록등본성적표재학증명서통장사본소속대학 총장 추천서*각 대학 장학부서로 신청'
    },
    {
      Col1: '재단법인 충북인재양성재단',
      Col2: '학자금대출 이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '한국장학재단으로부터 일반상환 취업 후 상환 학자금 대출을 받은 대출학기 기준 소득 8분위 이하인 대학생',
      Col11: '한국장학재단을 통해 대출받은 학자금 (등록금 및 생활비)에서  2021년 1월 1일부터 6월 30일까지 발생한 이자 전액',
      Col12: '한국장학재단으로부터 일반상환/ 취업 후 상환 학자금 대출을 받은 대출학기 기준 소득 8분위 이하인 대학생',
      Col13: '신청공고일 기준으로 등본상 본인 또는 직계존속이 계속하여 1년 이상 충북 도내에 거주하는 국내 소재 대학교에 재학중인 대학생',
      Col14: '2020-04-01~2020-04-10',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '대학원생대출이자 지원금 지급일까지 대출전액이 상환된 대학생 지원불가타 지자체와 중복지원 불가',
      Col18: '해당없음',
      Col19: ' * 충북인재양성재단 홈페이지 온라인 접수(휴대폰 본인인증 필수)지원신청서 작성 (개인정보 수집 이용 및 제공동의서 작성)주민등록등본(초본) 파일 첨부 (주민등록번호 뒷자리는 가려서 제출)  가족관계증명서 파일 첨부(해당자)재학증명서(휴학/ 재적증명서 가능)졸업증명서(해당자)겅강보험 자격득실확인서(해당자)  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 충북인재양성재단',
      Col2: '희망장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소득환산 기준(보건복지부 고시) 중위 100% 이하 (건강보험료 납부금액으로 확인)',
      Col11: '1인 500000원',
      Col12: '코로나19 피해로 전년 2~3월 대비 금년 2~3월 매출액 20% 이상 감소한 소상공인의 자녀코로나 피해 신청자 중 소득인정기준 하위순으로 시장·군수 추천',
      Col13: '공고일 기준 1년 이상 도내에 주소 및 사업장을 두고 있는 소상공인의 초·중·고·대학생 자녀',
      Col14: '2022-06-24~2022-07-11',
      Col15: '신청 및 서류 접수 (우편 및 방문 제출)충북인재양성재단 장학생 추천장학생 선발위원회의 심의 후 최종합격선발기준 : 건강보험료 30% + 매출감소율 70%',
      Col16: '200명',
      Col17: '중복수혜를 금지한 기관의 장학금을 받은 자2020년 상반기 충북인재양성재단 장학금과 중복수혜 불가충북학사 서서울관·동서울관/ 청주관 재사생육사/해사/공사/경찰대 등 전액 국비지원을 받는 자휴학생 제외 * 첨부파일 및 홈페이지 확인',
      Col18: '해당없음',
      Col19: '지원신청서 및 개인정보수집/ 이용 제공동의서주민등록등본가족관계증명서 (해당자만)재학증명서통장사본신용카드매출전표건강보험 납부확인서 또는 자격득실확인서* 첨부파일 참고바람'
    },
    {
      Col1: '재단법인 충북인재양성재단',
      Col2: '특지장학생(임광)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점 3.0 이상 ',
      Col10: '해당없음',
      Col11: '등록금 전액 ( * 의대 약대 수의대는 공대 기준)',
      Col12: '서울대학교 재학생으로 직전학기 평점 3.0 이상이며 지역거주요건을 충족하는 자',
      Col13: '공고일 현재 1년 이상 충북에 주소를 두고 계속 거주하는 도민 및 도민의 자녀 *  거주기간이 1년 미만일 경우 과거 5년 이상 거주한 사실이 있는 도민도 신청 가능',
      Col14: '2022-03-07~2022-04-01',
      Col15: ' * 충북인재양성재단은 장학금 안내·모집·제출서류 업무만 담당하며/ 최종 장학생 선발은 임광 특지장학회에서 결정',
      Col16: '10명',
      Col17: '규정학기 초과자타 장학금 수혜자',
      Col18: '해당없음',
      Col19: '임광 특지장학금 신청서주민등록등본직전학기 성적증명서재학증명서학생 명의 통장사본 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인보은군민장학회',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2021년 2학기 성적이 A+ (백분위 점수 95점) 이상인 자이수학점 12학점 이상',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '해당없음',
      Col13: '부모(보호자) 또는 본인이 보은군에 주소를 두고 장학생 선발 신청일 현재 1년 이상 계속 거주한 자',
      Col14: '2022-03-07~2022-04-01',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '장학금 중복신청 불가2022년 상반기 충북인재양성재단 장학금 수령자육사/ 해사/ 공사/ 경찰대 등 등록금 전액 국비지원 학교 재학생2022년 1학기 휴학 예정인 자이수학점 12학점 미만인 자',
      Col18: '해당없음',
      Col19: '장학생 신청서장학금 지급신청서개인정보 수집/ 이용/ 제공 동의서 주민등록등본가족관계증명서재학증명서통장 사본2021년 2학기 성적 증명서 * 자세한 사항은 홈페이지 또는 첨부파일 참고필수수'
    },
    {
      Col1: '재단법인보은군민장학회',
      Col2: '복지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '기초생활수급자 차상위계층 한부모 가족 지원대상자의 자녀',
      Col11: '1000000원',
      Col12: '대학(전문대 및 6년제 대학/ 의학전문대학원/ 법학전문대학원 포함)에 재학중인 자',
      Col13: '부모(보호자) 또는 본인이 보은군에 주소를 두고 장학생 선발 신청일 현재 1년 이상 계속 거주한 주민의 자녀',
      Col14: '2021-12-03~2021-12-20',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2022년 상반기 충북인재양성재단 장학금 수령자육사/ 해사/ 공사/ 경찰대 등 등록금 전액 국비지원 학교 재학생2022년 1학기 휴학 예정인 자',
      Col18: '해당없음',
      Col19: '장학생 신청서장학금 지급신청서개인정보 수집/이용/제공 동의서주민등록등본가족관계증명서재학증명서학생 본인 통장 사본수급자 또는 차상위 증명서2021년 2학기 성적 증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인보은군민장학회',
      Col2: '예체능및입상장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '보은군민장학회 소위원회에서 추후 결정',
      Col12: '국가기관에서 개최한 전국단위 대회에서 우수한 성적을 거둔 자/ 예체능에 뛰어난 소질이 있는 자 등 장학금 지급이 필요하다고 인정되는 대학생',
      Col13: '부모(보호자) 또는 본인이 보은군에 주소를 두고 장학생 선발 신청일 현재 1년 이상 계속 거주한 주민의 자녀',
      Col14: '2022-08-16~2022-09-07',
      Col15: '해당없음',
      Col16: '보은군민장학회 소위원회에서 추후 결정',
      Col17: '해당없음',
      Col18: '학교장 추천체육분야는 보은군체육회에서 추천',
      Col19: '장학생 신청서장학생 추천서수상실적 등을 증명할 수 있는 서류(사본 포함)학부모 주민등록등본장학금 지급신청서보호자 통장사본 '
    },
    {
      Col1: '영동군민장학회',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 백분위 환산점수가 85점이상',
      Col10: '해당없음',
      Col11: '1500000원 * 원격대학/방송통신대학 재학생은 등록금의 60% 이내',
      Col12: '대학(전문대/ 원격대학 포함)에 재학중 또는 복학한 자로서 성적요건 만족자 * 유원대학교 30% 선발 * 자세한 사항은 첨부파일 참고',
      Col13: '장학생 신청일 기준 6개월이상 계속 영동군에 거주하고 있는 군민 또는 그 자녀(조손가정 포함)',
      Col14: '2022-08-16~2022-09-07',
      Col15: '성적50%/ 건강보험료 20%/ 거주기간20%/ 가족사항10%',
      Col16: '149명 * 유원대학교 44명 (전체 인원의 30%)',
      Col17: '중복 부문 신청 불가능재학 중 2회 이상 장학금 수혜자당해연도에 도비 또는 군비로 지급하는 장학금을 받은 자국외대학 및 대학원생 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보 수집·이용동의서주민등록 등본(주소이력포함)주민등록 초본가족관계증명서건강보험납부확인서직전학기 성적증명서재학증명서 * 자세한사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '영동군민장학회',
      Col2: '난계국악장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '국악관련 전공 대학생본인의 학과가 국악계열임을 증빙할 자료제출 필수',
      Col13: '장학생 신청일 기준 6개월이상 계속 영동군에 거주하고 있는 군민 또는 그 자녀(조손가정 포함)',
      Col14: '2022-02-03~2022-02-28',
      Col15: '성적50%/ 건강보험료20%/ 거주기간20%/ 가족사항10%',
      Col16: '3명',
      Col17: '중복 부문 신청 불가능재단법인 영동군민장학회 장학생으로 재학 중 2회 이상 기수혜자 당해연도에 도비 또는 군비로 지급하는 장학금을 받은 자국외 대학 및 사이버 대학교 재학생 제외 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보 수집·이용 동의서주민등록등본주민등록초본가족관계증명서건강보험납부확인서직전학기 성적증명서전공분야가 국악임이 명시된 재학증명서 * 자세한사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '영동군민장학회',
      Col2: '향토장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원 * 생활비 지급',
      Col12: '2021년에 대학교에 입학한 재학생',
      Col13: '부 또는 모와 학생 본인이 학생의 고등학교 졸업일 이전 1년전부터 1년 후 계속해서 군내에 주민등록을 둔 24세 이하(1998.1.1이후 출생) 대학교 재학생 ',
      Col14: '2022-04-25~2022-04-29',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '향토장학금 신청서 (읍면사무소 비치)주민등록등본주민등록초본재학증명서통장사본가족관계증명서 (부모와 학생의 주소가 같지 않을 경우)'
    },
    {
      Col1: '재단법인 옥천군장학회',
      Col2: '옥천인재장학',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '백분위 환산점수 기준',
      Col10: '해당없음',
      Col11: '2~3년제 : 1500000원4년제 : 2000000원충복도립대 : 1000000원',
      Col12: '학업성적이 우수하며 품행이 단정한 대학(2·3년제 포함)교 재학생',
      Col13: '부모(보호자) 또는 본인이 옥천군에 주소를 두고 장학생 선발 공고일 현재 1년 이상 계속 거주한 자',
      Col14: '2021-10-25~2021-11-12',
      Col15: '학교성적 60% + 소득수준 40%',
      Col16: ' * 총 46명23년제 : 6명4년제 : 30명충북도립대학생 : 10명',
      Col17: '신청학기 휴학예정자 신청 불가동일인에 한하여 재학 중 1회 선발신청학기 충북인재양성재단에서 장학금을 지원 받은 자 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '직전학기 성적증명서주민등록등본건강보험 납부확인서 또는 자격득실확인서해당자 증빙서류(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 옥천군장학회',
      Col2: '졸업장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적분야 : 전 학년 합산성적 상위 20% 이내인 자',
      Col10: '복지분야 : 기초생활수급자 차상위계층 한부모가정 중 전 학년 합산성적 상위 50% 이내 학생',
      Col11: '1000000원',
      Col12: '부모(보호자) 또는 본인이 옥천군에 주소를 두고 장학생 선발 공고일 현재 1년 이상 계속 거주한 자로서 충북도립대학교 졸업예정자선발분야 : 성적분야 / 복지분야 ',
      Col13: '부모(보호자) 또는 본인이 옥천군에 주소를 두고 장학생 선발 공고일 현재 1년 이상 계속 거주한 자',
      Col14: '2022-01-26~2022-02-15',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '해당없음',
      Col18: '총장 추천',
      Col19: '졸업장학생 추천서 명단 및 추천서주민등록 등본 및 초본성적증명서수급자 또는 차상위계층/ 한부모자녀증명서 (복지분야)'
    },
    {
      Col1: '(재)음성군장학회',
      Col2: '희망(장애)장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소득수준평가 : 부모의 건강  장기요양보험료 월평균 납부액 * 평점산출식은 첨부파일을 통해 확인 ',
      Col11: '대학생 2000000원',
      Col12: '장애등록이 되어 있는 자로 타의 모범이 되는 자',
      Col13: '공고일현재 1년이상 음성군에 주소를 두고 계속 거주하고 있는 군민 또는 군민의 자녀',
      Col14: '2022-01-26~2022-02-15',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '음성장학회의 다른 장학금을 수혜 받는 자휴학예정자/ 군입대 예정자/ 졸업예정자사이버 대학교/ 계약학과/ 야간대학 재학자/ 본인 또는 배우자의 소득이 있는 자',
      Col18: '해당없음',
      Col19: '신청서주민등록등본통장사본기초생활수급자증명서읍면에서 발급하는 차상위계층임을 증명하는 서류추천서는 공문으로 대체성적증명서가족관계증명서  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)음성군장학회',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생수능 응시자 : 4개 영역 중 3개 영역 이상이 2등급 이내(탐구영역은 상위 2개 과목 평균)미응시자:고등학교 2학년(1/2학기) 3학년(1학기) 전 과목 석차등급 (예체능 제외)평균 2등급 이내인 자 * 재학생:  직전(前)학년 성적이 4.5점 만점에 4.0점 이상인 자',
      Col10: '해당없음',
      Col11: '대학생 2000000원',
      Col12: '국내 대학교 학생 대상 * 다음 대학 재학생은 조건 충족 시 우선선발(직전학년 성적이 3.7점 이상인자) : 서울대/ 연세대(신촌캠퍼스)/ 고려대(안암캠퍼스)/ 포스텍/ 카이스트 / (음성군 관내 고등학교를 졸업한 학생 중) 극동대/ 강동대',
      Col13: '공고일현재 1년이상 음성군에 주소를 두고 계속 거주하고 있는 군민 또는 군민의 자녀',
      Col14: '2021-01-26~2022-02-15',
      Col15: '신입생 : 수능 영역별 백분위 평균 점수가 높은 순으로 선발 * 동점자의 경우 국어/ 수학/ 영어 영역 백분위 점수가 높은 순으로 선발재학생 : 직전(前)학년(1~2학기) 성적이 높은 순으로 선발 * 동점자의 경우 학년이 높은 자를 선발',
      Col16: '관내 4명 / 관외 42명',
      Col17: '음성장학회의 다른 장학금을 수혜 받는 자휴학예정자/ 군입대 예정자/ 졸업예정자사이버 대학교/ 계약학과/ 야간대학 재학자/ 본인 또는 배우자의 소득이 있는 자',
      Col18: '관내 대학생 : 학교장 추천',
      Col19: '신청서주민등록등본통장사본(본인 또는 부모)대학생 성적증명서 (정규학기인 1/2학기 성적만 포함)(4.5점으로 환산)신입생 : 수능성적표사본/ 생활기록부사본수능미응시자 신입생 : 생활기록부사본/ 수능미응시확인서관내대학생 : 학교장 추천서공문으로 대체가능가족관계증명서 (학생주소가 음성군이 아니면서 주민등록이 부모와 따로되어있는 경우 제출) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)음성군장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 2000000만원 / 학기별 1/2씩 지급',
      Col12: '공공기관 및 민간단체가 주최/주관한 전국규모 이상 대회에서 3위 이상 수상한 대학생',
      Col13: '공고일현재 1년이상 음성군에 주소를 두고 계속 거주하고 있는 군민 또는 군민의 자녀',
      Col14: '2022-01-26~2022-02-15',
      Col15: '대회규모별/ 수상실적 순으로 평가 * 세계 대회 > 아시아 대회 > 전국 대회  * 1위 >  2위 > 3위',
      Col16: '1명',
      Col17: '음성장학회의 다른 장학금을 수혜 받는 자휴학예정자/ 군입대 예정자/ 졸업예정자사이버 대학교/ 계약학과/ 야간대학 재학자/ 본인 또는 배우자의 소득이 있는 자 ',
      Col18: ' * 단체로 수상한 경우 학교장 추천을 받은 1명만 신청',
      Col19: '신청서주민등록등본통장사본(본인 또는 부모)상장사본가족관계증명서 (학생주소가 음성군이 아니면서 주민등록이 부모와 따로되어있는 경우 제출)(단체수상자) 학교장 추천서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)음성군장학회',
      Col2: '해외장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 2000000원 (학기별 1/2씩 지급)',
      Col12: '세계 100대 대학 중 해외 대학에 재학중이거나/ 입학예정자※ 세계 100대 대학 : Times Higher Education에서 세계 100대 대학으로 선정한 대학',
      Col13: '공고일현재 1년이상 음성군에 주소를 두고 계속 거주하고 있는 군민 또는 군민의 자녀',
      Col14: '2022-01-26~2022-02-15',
      Col15: '신청자가 1명을 초과할 경우 부모의 2020년 겅강보험 납부액 평균이 적은 순으로 선발',
      Col16: '1명',
      Col17: '음성장학회의 다른 장학금을 수혜 받는 자휴학예정자/ 군입대 예정자/ 졸업예정자사이버 대학교/ 계약학과/ 야간대학 재학자/ 본인 또는 배우자의 소득이 있는 자',
      Col18: '해당없음',
      Col19: '신청서주민등록등본재학증명서(재학생)/ 합격증명서(입학생)통장사본(본인 또는 부모)부모의 건강보험(장기요양보험포함) 납부확인서 또는 자격득실확인서서가족관계증명서 (학생주소가 음성군이 아니면서 주민등록이 부모와 따로되어있는 경우 제출) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)음성군장학회',
      Col2: '다문화장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 2000000원',
      Col12: '다문화 가정 자녀',
      Col13: '공고일현재 1년이상 음성군에 주소를 두고 계속 거주하고 있는 군민 또는 군민의 자녀',
      Col14: '2022-01-26~2022-02-15',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '음성장학회의 다른 장학금을 수혜 받는 자휴학예정자/ 군입대 예정자/ 졸업예정자사이버 대학교/ 계약학과/ 야간대학 재학자/ 본인 또는 배우자의 소득이 있는 자',
      Col18: '해당없음',
      Col19: '신청서주민등록등본통장사본(본인 또는 부모)가족관계증명서/ 제적등본 또는 (국적취득한 부 또는 모의)기본증명서학교장추천서는 공문으로 대체대학생 성적증명서 (정규학기인 1/2학기 성적만 포함) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)음성군장학회',
      Col2: '꿈드림장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 2000000원',
      Col12: '본인 또는 부모가 기초생활수급자/ 차상위계층으로 등록되어 있는 자학교밖 청소년으로 학교밖 청소년 지원센터에 등록되어 있는 자',
      Col13: '공고일현재 1년이상 음성군에 주소를 두고 계속 거주하고 있는 군민 또는 군민의 자녀',
      Col14: '2022-03-04~2022-03-18',
      Col15: '해당없음',
      Col16: '5명',
      Col17: '공고일현재 1년이상 음성군에 주소를 두고 계속 거주하고 있는 군민 또는 군민의 자녀음성장학회의 다른 장학금을 수혜 받는 자휴학예정자/ 군입대 예정자/ 졸업예정자사이버 대학교/ 계약학과/ 야간대학 재학자/ 본인 또는 배우자의 소득이 있는 자',
      Col18: '학교밖 청소년: 학교밖지원센터장 추천',
      Col19: '신청서주민등록등본통장사본(본인 또는 부모)기초생활수급자증명서 또는 읍면에서 발급하는 차상위계층임을 증명하는 서류추천서는 공문으로 대체대학생 성적증명서(정규학기인 1학기/2학기 성적만 포함)가족관계증명서(학생주소가 음성군이 아니면서 주민등록이 부모와 따로 되어있는 경우 제출) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '제천시인재육성재단',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/인문계열/자연계열/제한없음',
      Col9: '1. 신입생 수능성적 평가전형 : 수능 4개 영역 백분위 점수 평균이 70점 이상 고교내신 평가전형 : 고교내신(3개년 전체) 전과목 평균 (원점수) 70점 이상 검정고시합격자의 경우 평균득점 70점 이상2. 재학생 백분율로 환산한 직전학년 성적(1/2학기) 평균 70점이상',
      Col10: '부모의 2021년도 건강보험료 월평균 납부액',
      Col11: '2000000원',
      Col12: '학업성적이 우수하고 모범적인 자',
      Col13: '학생 또는 보호자가 3년 이상 제천시 관내 거주자(2019.03.01일 이전부터 공고 일까지 계속하여 제천시에 거주한 자)',
      Col14: '2022-03-04~2022-03-18',
      Col15: '성적 70% + 소득 30% + 가산점 * 자세한 건 첨부파일 확인',
      Col16: '80명 ',
      Col17: '타 기관/ 장학재단 및 학교에서 받는 장학금 총액이 등록금을 초과하는 자한국장학재단 이중지원시스템의 “과거이중지원” 미해소자서울제천학사 재사생국가로부터 등록금/ 수업료등을 전액지원받는 학생휴학생/ 학점은행제/ 원격대학/ 직업학교 재학생 등',
      Col18: '해당없음',
      Col19: '장학생 신청서대학교 재학증명서성적증명서 * 신입생(수능성적 평가전형) : 대학수학능력시험성적표 * 신입생(고교 내신 평가전형) : 시험성적서 또는 생활기록부 * 재학생(수능성적 평가전형) : 대학수학능력시험성적표 * 재학생(고교 내신 평가전형) : 고교 시험성적서 또는 생활기록부건강보험 납부확인서 또는 자격득실확인서주민등록등본가족관계증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '제천시인재육성재단',
      Col2: '지역대학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 1000000원 * 생활비 지원',
      Col12: '해당없음',
      Col13: '당해연도 제천시 7개 고등학교 졸업생/ 재수생/ 제천 출신 검정고시생관내 고등학교 졸업자로 세명대학교 및 대원대학교에 입학하는 학생 전원',
      Col14: '2022-01-24~2022-01-28',
      Col15: '세명대학교 및 대원대학교 총장으로부터 지역대학 장학생대상 학생명단을 통보받아 확인 절차를 거쳐 선발',
      Col16: '410명 ',
      Col17: '해당없음',
      Col18: '총장 추천',
      Col19: '각 지역대학 총장 추천 공문검정고시생 : 최근 3년간 주소이력사항 포함한 학생 또는 부모 주민등록등본 제출(필요시 가족관계 증명서 추가 제출) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인논산시장학회',
      Col2: '우수인재대학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 두 학기의 성적평점 평균이 80점 이상(백분율 환산 점수) * (단/ 신입생은 입학점수 총점 백분율 환산점수가 80점 이상)',
      Col10: '가정 형편이 어려운 자',
      Col11: '3000000원 이내 ※ 등록비성 장학금',
      Col12: '정규대학교(2년제 포함) 재학생(신입생 제외)로 직전 두 학기의 성적평점 평균이 80점 이상(백분율 환산 점수)에 해당하는 대학생 중 가정형편이 어려운 자',
      Col13: '논산시에 1년 이상 주소를 두고 실제 거주하는 시민 또는 시민의 자녀관내 고등학교 졸업생으로 지역대학에 입학하는 학생',
      Col14: '2022-01-24~2022-01-28',
      Col15: '학업성적과 가정형편을 평가하여 고득점자 순으로 함',
      Col16: '20명',
      Col17: '등록금 전액(입학금/수업료/기성회비)를 초과하여 국가장학금/ 타 장학금 및 학자금 대출을 수혜할 수 없음 * 자세한 사항은 첨부파일 참고 ',
      Col18: '총장 추천',
      Col19: '장학생 신청서주민등록등본보호자 통장 또는 본인 통장 사본재학증명서성적증명서 : 직전 두 학기 성적증명서지방세 세목별 과세증명서건강보험료 납부확인서 또는 고지서국민기초생활보장수급자 증명서 또는 차상위계층증명서(해당자)국가유공자 증명서(해당자)'
    },
    {
      Col1: '재단법인논산시장학회',
      Col2: '학업장려대학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: ' 기초생활수급자 또는 차상위계층',
      Col11: '3000000원 이내 ※ 생활비성 장학금',
      Col12: '정규대학교(2년제포함) 신입생 또는 재학생 중 기초생활수급자 또는 차상위계층으로 성실히 학업을 수행하는 자',
      Col13: '논산시에 1년 이상 주소를 두고 실제 거주하는 시민 또는 시민읭 자녀예외 : 관내 고등학교 졸업생으로 지역대학에 입학하는 학생',
      Col14: '2022-01-24~2022-01-28',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '등록금 전액(입학금/수업료/기성회비)를 초과하여 국가장학금/ 타 장학금 및 학자금 대출을 수혜할 수 없음 * 자세한 사항은 첨부파일 참고 ',
      Col18: '자치단체장이나 학교장(총장) 추천',
      Col19: '장학생 신청서주민등록등본가족관계증명서(해당자)보호자 또는 본인의 통장 사본재학증명서 또는 입학 증명 서류국민기초생활수급자 증명서 또는 차상위계층증명서성적증명서 ( 재학생 : 직전 두 학기 성적증명서 / 신입생 : 고교 3학년 국·영·수 성적증명서 ) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인논산시장학회',
      Col2: '사회봉사활동우수대학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 3000000원 이내',
      Col12: '정규대학교 (2년제 전문대 포함) 재학생 중 직전년도부터 봉사실적이 100시간 이상인 자',
      Col13: '논산시에 1년 이상 주소를 두고 실제 거주하는 시민 또는 시민의 자녀 ※ 예외 : 관내 고등학교 졸업생으로 지역대학에 입학하는 자',
      Col14: '2022-04-01~2022-04-15',
      Col15: '해당없음',
      Col16: '00명',
      Col17: '등록금 전액(입학금/수업료/기성회비)를 초과하여 국가장학금/ 타 장학금 및 학자금 대출을 수혜할 수 없음 * 자세한 사항은 첨부파일 참고',
      Col18: '총장 추천',
      Col19: '장학생 신청서주민등록등본가족관계증명서(해당자)보호자 또는 본인의 통장 사본재학증명서봉사활동 확인서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '공주시한마음장학회',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 취득학점이 16학점 이상이면서 성적이 4.5만점 기준   4.0(A)이상인 학생',
      Col10: '해당없음',
      Col11: '1인당 2000000원 (등록금 범위내 지급)',
      Col12: '관내 소재 초/중/고등학교 중 1개교 이상 졸업자에 해당하며 성적이 우수한 관내/외 대학생',
      Col13: '관내 소재 초·중·고등학교 재학생 또는 졸업자장학생 선발 공고일 기준 장학생 또는 장학생의 보호자(부모/ 조부모/ 외조부모/ 실양육자)가 공주시에 1년 이상 계속해서 주민등록을 둔 자 ',
      Col14: '2022-04-01~2022-04-15',
      Col15: '신청인원 초과시 우선 선발기준 : 성적 > 경제적여건 > 고학년',
      Col16: '예산범위내 선발',
      Col17: '학자금 중복지원 방지제도에 따라 타기관 장학금 수혜내역이 있는 경우 등록금 범위 내 수혜금액 공제 후 지원 학기에 휴학하는 경우학교에서 징계처분을 받거나 자퇴 등으로 더 이상 학업을 수행하지 않는 경우장학금에 해당하는 학기에 휴학하는 경우추천권자 및 학교장으로부터 중지 요구가 있을 경우 분야별 중복신청 불가',
      Col18: '개별신청청',
      Col19: '장학금 신청서개인정보 보호 동의서주민등록등본(과거주소변동내역 포함 제출)재학증명서신청인 서약서관내 졸업증명서통장사본 * 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '공주시한마음장학회',
      Col2: '새마을지도자자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 C학점 미만인 과목이 전체 과목수의 80퍼센트를 초과하지 않은 학생',
      Col10: '해당없음',
      Col11: '1300000원',
      Col12: '새마을운동 관련 훈장/ 포상/ 표창을 받은 지도자 자녀 및 유공자 자녀/ 학업성적 우수학생/ 새마을운동에 2년 이상 봉사한 사람의 자녀로 일정 자격을 갖춘 학생 ',
      Col13: '관내 소재 초·중·고등학교 재학생 또는 졸업자장학생 선발 공고일 기준 장학생 또는 장학생의 보호자(부모/ 조부모/ 외조부모/ 실양육자)가 공주시에 1년 이상 계속해서 주민등록을 둔 자 ',
      Col14: '2022-04-01~2022-04-15',
      Col15: '(재)공주시한마음장학회 운영세칙의 선발기준에 의거 (재)공주시한마음장학회 이사회에서 선발장학생 선발명단은 공주시한마음장학회 홈페이지에 게시(개별통지 안함)',
      Col16: '10명',
      Col17: '학기에 휴학하는 경우학교에서 징계처분을 받거나 자퇴 등으로 더 이상 학업을 수행하지 않는 경우장학금에 해당하는 학기에 휴학하는 경우추천권자 및 학교장으로부터 중지 요구가 있을 경우 분야별 중복신청 불가',
      Col18: '공주시 주민공동체과',
      Col19: '장학금 신청서개인정보보호 동의서주민등록등본재학증명서신청인 서약서관내 졸업증명서통장사본(보호자 통장 가능)기타 추가서류 ※ 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '공주시한마음장학회',
      Col2: '장애인가정자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 2.0 이상인 학생',
      Col10: '저소득층 가정 학생생',
      Col11: '1000000원',
      Col12: '학생 또는 부모 중 한 사람이 등록장애인(기존 4등급 이상)의 저소득층 가정 학생신청인원 초과시 우선 선발기준 : 장애등급> 경제적여건> 고학년',
      Col13: '관내 소재 초·중·고등학교 재학생 또는 졸업자장학생 선발 공고일 기준 장학생 또는 장학생의 보호자(부모/ 조부모/ 외조부모/ 실양육자)가 공주시에 1년 이상 계속해서 주민등록을 둔 자 ',
      Col14: '2022-04-01~2022-04-15',
      Col15: '(재)공주시한마음장학회 운영세칙의 선발기준에 의거 (재)공주시한마음장학회 이사회에서 선발장학생 선발명단은 공주시한마음장학회 홈페이지에 게시(개별통지 안함)',
      Col16: '10명',
      Col17: '학기에 휴학하는 경우학교에서 징계처분을 받거나 자퇴 등으로 더 이상 학업을 수행하지 않는 경우장학금에 해당하는 학기에 휴학하는 경우추천권자 및 학교장으로부터 중지 요구가 있을 경우 분야별 중복신청 불가',
      Col18: '개별 신청',
      Col19: '장학금 신청서개인정보보호 동의서주민등록등본재학증명서신청인 서약서관내 졸업증명서통장사본(보호자 통장 가능)기타 추가서류 ※ 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '공주시한마음장학회',
      Col2: '희망복지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '해당없음',
      Col10: '국민기초 수급자 차상위계층 저소득층 가정의 학생',
      Col11: '1800000원',
      Col12: '효행 및 기능/예능/체육/봉사 등 타의모범이 되는 학업열의가 있는 학생신청인원 초과시 우선 선발기준 : 고학년> 취득학점(직전학기) ',
      Col13: '관내 소재 초·중·고등학교 재학생 또는 졸업자장학생 선발 공고일 기준 장학생 또는 장학생의 보호자(부모/ 조부모/ 외조부모/ 실양육자)가 공주시에 1년 이상 계속해서 주민등록을 둔 자 ',
      Col14: '2022-04-01~2022-04-15',
      Col15: '(재)공주시한마음장학회 운영세칙의 선발기준에 의거 (재)공주시한마음장학회 이사회에서 선발장학생 선발명단은 공주시한마음장학회 홈페이지에 게시(개별통지 안함)',
      Col16: '10명',
      Col17: '대학생의 경우 신청인원 초과시 타 기관 장학금 수혜내역이 있는 경우 선발 배제학기에 휴학하는 경우학교에서 징계처분을 받거나 자퇴 등으로 더 이상 학업을 수행하지 않는 경우장학금에 해당하는 학기에 휴학하는 경우추천권자 및 학교장으로부터 중지 요구가 있을 경우 분야별 중복신청 불가',
      Col18: '개별 신청',
      Col19: '장학금 신청서개인정보보호 동의서주민등록등본재학증명서신청인 서약서관내 졸업증명서통장사본(보호자 통장 가능)기타 추가서류 ※ 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '공주시한마음장학회',
      Col2: '한마음SOS장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정의 위기로 경제적 어려움에 처한 가정의 학생',
      Col11: '1000000원',
      Col12: '재난발생 및 가정의 위기 등으로 인해 지원이 필요한 일정 자격을 갖춘 학생‘21. 1. 1. ~ ‘22. 3. 29.(공고 개시 이전일) 기간 중 본인 또는 부모의 실직/ 폐업/ 휴업으로 경제사정이 곤란한 학생  ',
      Col13: '관내 소재 초·중·고등학교 재학생 또는 졸업자장학생 선발 공고일 기준 장학생 또는 장학생의 보호자(부모/ 조부모/ 외조부모/ 실양육자)가 공주시에 1년 이상 계속해서 주민등록을 둔 자 ',
      Col14: '2022-03-28~2022-04-08',
      Col15: '(재)공주시한마음장학회 운영세칙의 선발기준에 의거 (재)공주시한마음장학회 이사회에서 선발장학생 선발명단은 공주시한마음장학회 홈페이지에 게시(개별통지 안함)신청인원 초과시 우선 선발기준 : 경제적여건 > 다자녀 > 고학년',
      Col16: '10명',
      Col17: '신청인원 초과시 타 기관 장학금 수혜내역이 있는 경우 선발 배제 학기에 휴학하는 경우학교에서 징계처분을 받거나 자퇴 등으로 더 이상 학업을 수행하지 않는 경우장학금에 해당하는 학기에 휴학하는 경우추천권자 및 학교장으로부터 중지 요구가 있을 경우 분야별 중복신청 불가',
      Col18: '개별 신청',
      Col19: '장학금 신청서개인정보보호 동의서주민등록등본재학증명서신청인 서약서관내 졸업증명서통장사본(보호자 통장 가능)건강보험료 납부확인서사업주 확인서(근무했던 사업장)소상공인 확인서실직·폐업인증 확인 서류근로계약서 사본최근 1년 이내 급여입금내역 또는 통장사본 등 급여 수령을 입증할 수 있는 서류기타 추가서류 ※ 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '만세보령장학회',
      Col2: '저소득층자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년(1/2학기) 평균 3.0(4.5만점기준/ 계절학기 제외) 이상인 학생',
      Col10: '해당없음',
      Col11: '1인당 1500000원',
      Col12: '해당없음',
      Col13: '신청공고일 기준 현재 보령시에 3개월전 주민등록이 되어 있는 학생 (또는 부모의 자)',
      Col14: '2022-03-28~2022-04-08',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2022년도 타 장학재단 및 학교/ 지자체로부터 등록금을 초과해서 수업료/ 등록금/ 장학금 등을 지원받은 학생등록금 전액 지원되는 대학 재학생한 학기 수료 후 졸업예정자공고일 현재 휴학생 및 휴학예정자조기 졸업 예정자대학원/ 방송통신대학/ 사이버대학/ 평생교육원/ 학점은행 등  * 첨부파일 참고',
      Col18: '읍면동추천·학교장 추천',
      Col19: '만세보령장학금 신청/추천서개인정보 이용/정보/제공 동의서서약서성적증명서(특기를 증명할 수 있는 서류)재학증명서고교 졸업증명서장학금수혜(비수혜)확인서주민등록등본 (학생주소가 다를 경우 가족관계증명서)등록금 납부영수증(총액을 알 수 있는 고지서)국민기초생활수급자 증명서(해당자에 한함)북한이탈주민등록확인서(해당자에 한함) * 자세한 사항은 첨부자료 참고필수'
    },
    {
      Col1: '만세보령장학회',
      Col2: '학업우수자장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년(1/2학기) 평균3.5(4.5만점)이상인 학생',
      Col10: '해당없음',
      Col11: '1인당 1500000원',
      Col12: '해당없음',
      Col13: '신청공고일 기준 3개월전 보령시에 주민등록이 되어 있는 사람 (또는 부모 의 자)',
      Col14: '2022-03-28~2022-04-08',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2022년도 타 장학재단 및 학교/ 지자체로부터 등록금을 초과해서 수업료/ 등록금/ 장학금 등을 지원받은 학생등록금 전액 지원되는 대학 재학생한 학기 수료 후 졸업예정자공고일 현재 휴학생 및 휴학예정자조기 졸업 예정자대학원/ 방송통신대학/ 사이버대학/ 평생교육원/ 학점은행 등 * 첨부파일 참고',
      Col18: '학교장 추천 / 읍면동 추천',
      Col19: '만세보령장학금 신청/추천서개인정보 이용/정보/제공 동의서서약서성적증명서(특기를 증명할 수 있는 서류)재학증명서고교 졸업증명서장학금수혜(비수혜)확인서주민등록등본 (학생주소가 다를 경우 가족관계증명서)등록금 납부영수증(총액을 알 수 있는 고지서)국민기초생활수급자 증명서(해당자에 한함)북한이탈주민등록확인서(해당자에 한함) * 자세한 사항은 첨부자료 참고필수'
    },
    {
      Col1: '만세보령장학회',
      Col2: '인재육성 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '관내 고등학교 졸업자 중 『3+1체제』 수능 성적전국 평균 등급 1.5등급이내',
      Col10: '해당없음',
      Col11: '5000000원',
      Col12: '대학교 신입생관내 고등학교 졸업자',
      Col13: '신청공고일 기준 현재 보령시에 3개월전 주민등록이 되어 있는 학생 (또는 부모의 자)',
      Col14: '2020-07-06~2020-07-24',
      Col15: '해당없음',
      Col16: '대학생(신입생) : 5명',
      Col17: '해당없음',
      Col18: '졸업학교장의 추천',
      Col19: '인재육성장학금 신청/추천서개인정보 이용/정보/제공 동의서성적증명서(수능성적)재학증명서 주민등록등본(학생 주소가 다를 경우 가족관계증명서) * 자세한사항은 첨부자료와 재단홈페이지 참고'
    },
    {
      Col1: '만세보령장학회',
      Col2: '대학생학자금대출이자지원사업',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한국장학재단을 통한 대학 학자금 대출자에 한하여 2020. 7. 1. ~ 12. 31. 발생 학자금 대출 이자분 지원',
      Col12: '본인 또는 부모가 공고일 기준 1년 이상 보령시에 주민등록이 되어있는 대학 재학생으로 한국장학재단을 통한 대학 학자금 대출자(일반상환 학자금대출/취업후상환 학자금대출)',
      Col13: '본인 또는 부모가 공고일 기준 1년 이상 보령시에 주민등록이 되어있는 대학 재학생 ※ 부모가 모두 사망한 경우에는 본인 또는 직계혈족을 기준/ 1년 이상 보령시에 주민등록이 되어있는 대학 재학생',
      Col14: '2022-03-21~2022-04-01',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '지급일까지 대출금 완제한 경우 지원불가국가·타 지자체·기업체와 중복지원 불가휴학생/ 졸업자/ 대학원생 제외생활비 대출 지원제외',
      Col18: '해당없음',
      Col19: ' * 보령시청 홈페이지 접속 → \'학자금\' 검색 → 2021년 보령시 대학생 학자금 대출이자 지원 신청 안내 클릭 → 구비서류 작성/ 첨부신청서본인 또는 부모 중 1인 주민등록표 초본가족관계증명서(본인 초본 아닌경우)개인정보 수집·이용 및 제3자 제공·조회 동의서 '
    },
    {
      Col1: '서산인재육성재단',
      Col2: '학업우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '정시 입학자 : 대학수학능력 시험 성적[국어+수학+영어(등급)+탐구(2과목)영역 백분위 석차 합산]이 우수한 자수시 입학자 : 한국교육과정평가원 주관 2021년도에 실시한 2022학년도 대학수학능력 시험 6월 또는 9월 모의평가 성적[국어+수학+영어(등급)+탐구(2과목) 영역 밴분위 석차 합산]이 우수한 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '관내 고등학교 출신 대학교 신입생 중 2021년도에 실시한 『2022학년도 대학수학능력시험』성적 또는 2021년도에 실시한 『2022학년도 대학수학능력시험 6월 또는 9월 모의평가』성적이 우수한 자',
      Col13: '본인 또는 보호자가 서산시에 주소를 두고 공고일 현재 만 5년 이상 계속 거주하고 있는 시민 또는 시민의 자녀',
      Col14: '2022-03-21~2022-04-01',
      Col15: '1단계 : 서류심사 (분야별 선발 기준에 의함)2단계 : 면접(입학 후 학업 및 활동 계획을 중심으로 실시)',
      Col16: '15명',
      Col17: '등록금 전액을 면제받는 고등교육기관 재학생은 선발하지 않음.(경찰대/ 육사/ 공사/ 해사/ 카이스트/ 포스텍 등)등록금 범위를 초과한 장학금 이중수혜 혜택은 금지되어 있음',
      Col18: '해당없음',
      Col19: '장학생 신청서주민등록등본(5년간의 주소 이력 포함)대학교 재학증명서2022학년도 수능성적표(정시합격자)2021년도에 실시한 2022학년도 대학수학능력시험 6월 또는 9월 모의평가 성적표(수시합격자) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '서산인재육성재단',
      Col2: '영재장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '학술·예술·체육·기능분야에서 탁월한 능력을 발휘한 자공공기관 및 단체에서 주최·주관한 전국규모 이상 대회에서 입상한 자 또는 국가대표로 선발된 대학생수상실적 기간 : 2019.03.01 ~ 2022.02.28(3년간)',
      Col13: '본인 또는 부모(보호자)가 서산시에 주소를 두고 공고일 현재 만 5년 이상 계속 거주하고 있는 시민 또는 시민의 자녀로서 2022학년도 관내·외 대학교 신입생',
      Col14: '2022-03-21~2022-04-01',
      Col15: ' * 대회 규모별 수상 실적 순으로 평가',
      Col16: '2명',
      Col17: '등록금 전액을 면제받는 고등교육기관 재학생은 선발하지 않음.(경찰대/ 육사/ 공사/ 해사/ 카이스트/ 포스텍 등)등록금 범위를 초과한 장학금 이중수혜 혜택은 금지되어 있음',
      Col18: '해당없음',
      Col19: '장학생 신청서주민등록등본(5년간의 주소 이력포함)대학교 재학증명서수상 상장 및 실적 내용 (공통) * 자세항 사항은 첨부파일 참고'
    },
    {
      Col1: '서산인재육성재단',
      Col2: '복지장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: ' * 아래에 해당되는 학생 중 성적이 우수한 자국민기초생활보장수급자한부모 자녀차상위 자녀기타 생활형편이 곤란한 학생',
      Col11: '2000000원',
      Col12: '관내고교출신대학생경제적 생활이 어려운 학생으로서 성적이 우수한 자',
      Col13: '본인 또는 부모가 서산시에 주소를 두고 공고일 현재 만 5년이상 계속 거주하고 있는 시민/ 또는 시민의 자녀로서 2022학년도 관내 고등학교 및 관내고등학교 출신 대학교 신입생',
      Col14: '2022-05-23~2022-06-03',
      Col15: '1단계 서류심사 2단계 면접',
      Col16: '8명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 신청서주민등록등본(5년간의 주소 이력 포함) * 추가서류국민기초생활보장수급자 증명서한부모가족증명서차상위 본인부담경감대상증명서기타 생활형편이 곤란하다고 인정될 만한 증명 서류 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '아산시미래장학회',
      Col2: '희망장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '기초생활수급자 또는 차상위계층 또는 한부모 가정인 자기본중위소득 100% 이내',
      Col11: '1500000원',
      Col12: '해당없음',
      Col13: '공고일 기준 본인 또는 부모가 3년 이상 계속하여 아산시에 주민등록이 되어있고 거주하는 자',
      Col14: '2022-02-25~2022-03-04',
      Col15: '선발위원회 심사 선발  * 동점자 : 1순위 경제적 상황/ 2순위 아산시 거주기간 순',
      Col16: '40명',
      Col17: '1세대 1명만 지급휴학생 및 유학생 제외2022년 본 재단에서 장학 수혜를 받았거나 받을 예정인 자 ',
      Col18: '해당없음',
      Col19: '희망드림 장학금신청서개인 정보의 수집 동의서주민등록표 등본(5년주소변동사항 포함)학자금 지원구간 통지서재학증명서관내 고등학교의 졸업증명서건강보험 자격확인서건강보험료 납입확인서국가장학금 수혜증명서기초생활수급자증명서 또는 차상위계층증명서 또는 한부모가정증명서본인 또는 부모의 통장사본'
    },
    {
      Col1: '춘향장학재단',
      Col2: '신입생(보람)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전년도 내신평균 85점 이상',
      Col10: '가정형편(50%)',
      Col11: '1인당 100만원',
      Col12: '남원시 관내고 졸업자 중 대학 입학 예정자',
      Col13: '남원시 관내 고등학교 졸업자',
      Col14: '2022-02-25~2022-03-04',
      Col15: '전년도 내신성적 50% + 가정형편 50%',
      Col16: '5명',
      Col17: ' * 지원부문을 달리하여 중복접수 불가 * 중복지원제한 : 타기관/ 단체에서 장학금(학자금)을 지원받는 경우',
      Col18: '해당없음',
      Col19: '부·모 주민등록등본대학 합격증명서 또는 등록금 납부고지서2021년 내신 성적증명서관내 고등학교 졸업증명서'
    },
    {
      Col1: '춘향장학재단',
      Col2: '신입생(우수)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '고등학교 전체 내신 성적평균 90점 이상',
      Col10: '해당없음',
      Col11: '1인당 200만원',
      Col12: '관내고 졸업자 중 대학입학예정자(신입생)',
      Col13: '남원시 관내 고등학교 졸업자',
      Col14: '2022-02-25~2022-03-04',
      Col15: '해당없음',
      Col16: '대학생 5명',
      Col17: ' * 지원부문을 달리하여 중복접수 불가 * 중복지원제한 : 타기관/ 단체에서 장학금(학자금)을 지원받는 경우',
      Col18: '해당없음',
      Col19: '장학생 지원신청서개인정보제공동의 및 활용승낙서대학 합격증명서 또는 등록금 납부고지서고등학교 전체 내신 성적증명서관내 고등학교 졸업증명서'
    },
    {
      Col1: '춘향장학재단',
      Col2: '신입생(희망)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활수급자·차상위 계층층',
      Col11: '2000000원',
      Col12: '당해연도 관내고 졸업자 중 대학입학 예정자',
      Col13: '해당없음',
      Col14: '2022-05-16~2022-05-23',
      Col15: '해당없음',
      Col16: '5명',
      Col17: '타기관/ 단체에서 장학금을 지원받는 경우 중복지원 받은 사실 확인시 선발 제외전북장학숙/남원장학숙 입사생 장학생 선발제외',
      Col18: '해당없음',
      Col19: '부·모 주민등록등본국민기초생활보장수급자 또는 차상위계층 증명서대학 합격증명서 또는 등록금납부고지서2021년 내신 성적증명서관내 고등학교 졸업증명서'
    },
    {
      Col1: '익산사랑장학재단',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고3 1/2학기 평균점수 90점 이상 또는 수능(국영수)성적 백분위 환산 평균점수 90점 이상재학생 : 2021년도 2학기 평점평균 A학점 이상',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '현재 보호자가 익산시에 거주하거나 본인이 익산시에 거주하고 있는 대학교 재학생으로/ 성적요건 충족자',
      Col13: '부·모가 익산시에 1년이상 연속하여 주소를 두고 거주하고 있는 자녀관외 고등학교 졸업생은 현재 2년이상 거주하고 있는 시민의 자녀6개월이상 주소를 두고 관내 대학교에 재학중인 자',
      Col14: '2022-05-16~2022-05-23',
      Col15: '성적 50%/ 자녀수 30%/ 생활정도 10%/ 자원봉사 10%',
      Col16: '35명',
      Col17: '사이버대학/ 폴리텍대학/ 방송통신대학 재학생 등은 제외일반·특별장학생이 각각 선발인원의 30%를 초과하여 동일 대학교 학생이 선발될 수 없음신청·접수는 1세대당 1명에 한함장학생 신청자의 접수서류 등이 허위가 발견된 경우 선발 제외자원봉사 실적이 없는 학생은 접수제외',
      Col18: '해당없음',
      Col19: '장학생 지원서개인정보제공동의서자원봉사확인서(해당자)주민등록초본주민등록등본가족관계증명서생활정도를 확인할 수 있는 서류성적증명서재학증명서고등학교 졸업증명서기타 증빙서류(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '익산사랑장학재단',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고3 1/2학기 평균점수 80점이상 또는 수능(국영수)성적 백분위 환산 평균점수 80점이상재학생 : 직전학기 평점평균 B학점 이상',
      Col10: '건강보험료 납부확인서(2022년도 1~3월) 내 월 50000원 이하 납부자 또는 수급자 증명서 제출 가능자(생계·의료급여수급자)국민기초생활수급자차상위계층',
      Col11: '2000000원',
      Col12: '지역조건을 만족하는 대학교 재학생으로 저소득 가정 자녀',
      Col13: '부·모가 익산시에 1년이상 연속하여 주소를 두고 거주하고 있는 자녀관외 고등학교 졸업생은 현재 2년이상 거주하고 있는 시민의 자녀6개월이상 주소를 두고 관내 대학교에 재학중인 자',
      Col14: '2022-05-16~2022-05-23',
      Col15: '심사기준 : 성적 10%/ 생활정도 80%/ 자원봉사 10%',
      Col16: '15명',
      Col17: '사이버대학/ 폴리텍대학/ 방송통신대학 재학생 등은 제외일반·특별장학생이 각각 선발인원의 30%를 초과하여 동일 대학교 학생이 선발될 수 없음신청·접수는 1세대당 1명에 한함장학생 신청자의 접수서류 등이 허위가 발견된 경우 선발 제외',
      Col18: '해당없음',
      Col19: '장학생 지원서개인정보제공도의 및 활용승낙서자원봉사확인서(해당자)주민등록초본주민등록등본가족관계증명서건강보험납부확인서(부/모) 각 1부 또는 수급자 증명서성적증명서재학증명서고등학교 졸업증명서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '익산사랑장학재단',
      Col2: '예체기능 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: ' 지역거주요건을 만족하는 자로서 2021. 1. 1. ~ 2021. 12. 31. 기간 동안 전국대회/ 국제대회 1~4위 수상자(단체전 수상자 포함) * 국가/ 지방자치단체/ 공공기관/ 분야별 협회가 주최·주관하는 대회에 한함 * 전국대회/ 국제대회 1위~4위 수상자',
      Col13: '부·모가 익산시에 1년이상 연속하여 주소를 두고 거주하고 있는 자녀관외 고등학교 졸업생은 현재 2년이상 거주하고 있는 시민의 자녀6개월이상 주소를 두고 관내 대학교에 재학중인 자',
      Col14: '2022-05-16~2022-05-23',
      Col15: '수상80%/ 생활정도 10%/ 자원봉사 10%',
      Col16: '2명',
      Col17: '사이버대학/ 폴리텍대학/ 방송통신대학 재학생 등은 제외일반·특별장학생이 각각 선발인원의 30%를 초과하여 동일 대학교 학생이 선발될 수 없음신청·접수는 1세대당 1명에 한함장학생 신청자의 접수서류 등이 허위가 발견된 경우 선발 제외',
      Col18: '해당없음',
      Col19: '장학생 지원서개인정보제공도의 및 활용승낙서자원봉사확인서(해당자)주민등록초본주민등록등본가족관계증명서생활정도를 확인할 수 있는 서류재학증명서고등학교 졸업증명서입상실적 증빙서류(주최·주관 기관 연락처 제출) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '익산사랑장학재단',
      Col2: '다자녀 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '신입생 : 고3 1/2학기 평균점수 80점 이상 또는 수능(국영수)성적 백분위 환산 평균점수 80점 이상재학생 : 직전학기 평점평균 B학점 이상(해당학기 취득학점 9학점 이상)',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '지역거주요건을 만족하는 자 중 다자녀(3자녀 이상) 가구의 대학교 재학생 ',
      Col13: '부·모가 익산시에 1년이상 연속하여 주소를 두고 거주하고 있는 자녀관외 고등학교 졸업생은 현재 2년이상 거주하고 있는 시민의 자녀6개월이상 주소를 두고 관내 대학교에 재학중인 자',
      Col14: '2022-05-16~2022-05-23',
      Col15: '성적 50%/ 생활정도 40%/ 자원봉사 10%',
      Col16: '35명',
      Col17: '사이버대학/ 폴리텍대학/ 방송통신대학 재학생 등은 제외일반·특별장학생이 각각 선발인원의 30%를 초과하여 동일 대학교 학생이 선발될 수 없음신청·접수는 1세대당 1명에 한함 * 자세한 사항은 첨부파일 참고필수수',
      Col18: '해당없음',
      Col19: '장학생 지원서개인정보제공도의 및 활용승낙서자원봉사확인서(해당자)주민등록초본주민등록등본가족관계증명서생활정도를 확인할 수 있는 서류성적증명서재학증명서고등학교 졸업증명서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '익산사랑장학재단',
      Col2: '인성 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '봉사활동 50시간 이상봉사활동 인정기간 : 2021. 1. 1. ~ 2021. 12. 31. (1년간)',
      Col13: '부·모가 익산시에 1년이상 연속하여 주소를 두고 거주하고 있는 자녀관외 고등학교 졸업생은 현재 2년이상 거주하고 있는 시민의 자녀6개월이상 주소를 두고 관내 대학교에 재학중인 자',
      Col14: '2022-03-10~2022-03-18',
      Col15: '심사기준 : 자원봉사 100%',
      Col16: '2명',
      Col17: '사이버대학/ 폴리텍대학/ 방송통신대학 재학생 등은 제외일반·특별장학생이 각각 선발인원의 30%를 초과하여 동일 대학교 학생이 선발될 수 없음신청·접수는 1세대당 1명에 한함장학생 신청자의 접수서류 등이 허위가 발견된 경우 선발 제외자원봉사 실적이 없는 학생은 접수제외',
      Col18: '해당없음',
      Col19: '장학생 지원서개인정보제공도의 및 활용승낙서자원봉사확인서주민등록초본주민등록등본가족관계증명서생활정도를 확인할 수 있는 서류재학증명서고등학교 졸업증명서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인김제사랑장학재단',
      Col2: '일반장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 대학수능성적 고득점자 또는 내신성적 우수자(수능미응시자일 경우) * 재학생 대학수능성적 고득점자 또는 내신성적 우수자(수능미응시자일 경우)로서 전년도 학업성적 평점이 B학점 이상인자',
      Col10: '해당없음',
      Col11: '연 3000000원 ~ 6000000원  * 자세한 사항은 첨부파일 확인',
      Col12: '김제지역 중학교 졸업 또는 고등학교를 졸업한 자초등학교·중학교 통학구 지정으로 인근 시·군 초등학교 또는 중학교와 고등학교를 졸업한 자귀농인 또는 귀촌인의 자녀로서 김제지역 외 초등학교/ 중학교/ 고등학교를 졸업한 성적 우수 학생',
      Col13: '공고일 기준 김제시에 1년이상 주소를 두고 거주하는 김제시민의 자녀',
      Col14: '2022-03-10~2022-03-18',
      Col15: '신청자수 및 지급예산을 감안하여 김제사랑장학생 선발심의위원회에서 정함',
      Col16: '예산 범위 내',
      Col17: '타 기관으로부터 본 장학회 지급액이하의 장학금(수업료 포함)을 받을 경우에는 그 차액을 지급장학금 지급액 이상을 지급받은 경우와 학비가 전액 면제/지원되는 대학교 학생의 경우는 장학금 지급대상에서 제외보호자가 김제시 관외로 거주지를 변경한 경우장학생이 정학·휴학·퇴학 혹은 기타 사유로 학업을 중단한 경우',
      Col18: '단과대학장 또는 총장 추천',
      Col19: '장학생지원서 성적증명서  * 신입생 : 대학수학능력시험 성적표 사본 또는 고등학교 내신성적 증명서 1부  * 재학생 : 대학수학능력시험 성적표 사본 또는 고등학교 내신성적 증명서 1부/ 전년도 대학 성적증명서 1부개인정보제공 동의 및 활용승낙서(학생용/ 학부모용 각 1부)주민등록등본 1통 또는 가족관계등록부출신 초등학교/ 중학교 또는 고등학교 졸업증명서 1부통장사본(장학금 입금통장/ 신청자 모두 해당)기타 심사때 필요한 참고서류(해당자에 한함)  * 자세한 사항은 첨부파일 확인'
    },
    {
      Col1: '재단법인김제사랑장학재단',
      Col2: '특별장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '예/체/기능 소질자 : 전국단위 이상 수상 경력 등저소득층 자녀(법적비보호대상) : 대학수학능력시험 성적(수능응시자) 또는 고등학교 내신성적 내신평균등급(수능미응시자) + 전년도 대학 학업성적 +  생활정도  관내 고등학교를 졸업한 자로서/ 관내 소재 중소기업에 재직중인 대학생 : 성적+생활정도',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '천재지변 등 가정의 불행으로 장학금이 없으면 학업을 계속할 수 없는 자예·체·기능분야 : 국제 및 전국대회 3위이내 수상한 자로 생활형편이 어려운 자과학영농 개발보급 신산업육성 등 지역개발에 특별히 공이 있는 자의 자녀기타 김제사랑장학재단 장학생 선발 심의위원회에서 특별히 장학금의 지급이 필요하다고 인정되는 경우',
      Col13: '공고일 기준 김제시에 1년이상 주소를 두고 거주하는 김제시민의 자녀김제지역 중/고교를 졸업한 신입생 /재학생 및 초/중교 통학구 지정으로 인근 시/군 중/고교를 졸업한 자 ',
      Col14: '2020-03-23~2020-04-24',
      Col15: '분야별 선발방법 상이* 자세한 내용은 홈페이지 참조',
      Col16: '신청자수 및 지급예산을 감안하여 김제사랑장학생 선발심의위원회에서 정함',
      Col17: '타 기관으로부터 본 장학회 지급액이하의 장학금(수업료 포함)을 받을 경우에는 그 차액을 지급장학금 지급액 이상을 지급받은 경우와 학비가 전액 면제/지원되는 대학교 학생의 경우는 장학금 지급대상에서 제외보호자가 김제시 관외로 거주지를 변경한 경우장학생이 정학·휴학·퇴학 혹은 기타 사유로 학업을 중단한 경우',
      Col18: '읍/ 면/ 동장 추천',
      Col19: '장학생지원서 성적증명서  * 신입생 : 대학수학능력시험 성적표 사본 또는 고등학교 내신성적 증명서 1부  * 재학생 : 대학수학능력시험 성적표 사본 또는 고등학교 내신성적 증명서 1부/ 전년도 대학 성적증명서 1부개인정보제공 동의 및 활용승낙서(학생용/ 학부모용 각 1부)주민등록등본 1통 또는 가족관계등록부출신 초등학교/ 중학교 또는 고등학교 졸업증명서 1부(대학생)통장사본(장학금 입금통장/ 신청자 모두 해당)기타 심사때 필요한 참고서류(해당자에 한함)  * 자세한 사항은 첨부파일 확인'
    },
    {
      Col1: '(재)부안군근농인재육성재단',
      Col2: '희망장학금장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활보장수급자',
      Col11: '1000000원 정액지원 (생활비 보조)',
      Col12: '대학교 3학년/ 4학년 재학생',
      Col13: '부안군 지역 고등학교 졸업자 : 부/모 모두 주소 1년 이상 연속 거주그 외 지역 고등학교 졸업자/ 동등의 학력 인정 자  : 부/모 모두 주소 3년 이상 연속 거주 ',
      Col14: '2022-03-21~2022-04-24',
      Col15: ' * 신청자 중 학업성적 우수자 선발',
      Col16: '20명',
      Col17: '1980년(만40세) 이전 출생자원격대학(방송통신대학/ 사이버대학/ 학점은행제)/ 평생교육법상 설립된 대학의 재학생직전학년도에 성적우수/ 특기/ 희망장학금을 수혜 받은 학생학기에 학자금 대출 또는 국가장학금 등을 통해 등록금 범위를 초과할 경우 초과금액 반환(단/ 생활비 지원은 제외) ',
      Col18: '해당없음',
      Col19: '장학생 신청서통장사본고등학교졸업증명서대학교 재학증명서부 또는 모 가족관계증명서(상세)부모 모두의 주민등록초본 (최근5년)개인정보제공동의 및 활용승낙서성적증명서(직전학년 1/2학기 평균 성적증명서)국민기초생활보장수급자 증명서)'
    },
    {
      Col1: '(재)부안군근농인재육성재단',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '개인 1000000원 단체 2000000원 정액지원 (생활비 보조) ',
      Col12: '중앙 및 지방의 행정기관/ 공신력 있는 기관이 주최한 예술/ 체육/ 문학/ 과학 등 기능분야에서 도단위 이상 대회 1위 입상한 자  * 자세한 사항은 첨부파일 참고',
      Col13: '부안군 지역 고등학교 졸업자 : 부/모 모두 주소 1년 이상 연속 거주그 외 지역 고등학교 졸업자/ 동등의 학력 인정 자  : 부/모 모두 주소 3년 이상 연속 거주 ',
      Col14: '2022-09-05~2022-09-30',
      Col15: '해당없음',
      Col16: '30명',
      Col17: '1982년(만40세) 이전 출생자학점은행제 재학생평생교육법상 설립된 기관의 재학생직전 학년(2021년) 특기장학금 수혜자1학기 휴학생',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보제공동의 및 활용승낙서장학금 지급신청서 통장사본고등학교 졸업증명서대학교 재학증명서부 또는 모 가족관계증명서(상세)부/모 모두의 주민등록초본(최근 5년)2021년도 입상 관련 자료 사본 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '(재)부안군근농인재육성재단',
      Col2: '반값등록금장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 최대 3000000원 이내 지원 * 대학교 1학기 등록금 중 국가장학금 등 타 장학금을 제외한 본인부담금의 반값 지원 ',
      Col12: '2022년 대학교 1~6학년 재학생 (휴학생 제외)',
      Col13: '부안군 지역 고등학교 졸업자 : 부/모 모두 주소 1년 이상 연속 거주그 외 지역 고등학교 졸업자/ 동등의 학력 인정 자  : 부/모 모두 주소 3년 이상 연속 거주',
      Col14: '2020-03-23~2020-04-24',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '1982년(만40세)이전 출생자학점은행제 재학생평생교육법상 설립된 기관의 재학생직전학년(2021년) 특기장학금 수혜자1학기 휴학생',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보제공동의 및 활용승낙서장학금 지급신청서통장사본고등학교 졸업증명서대학교 재학증명서부 또는 모 가족관계증명서(상세)부/모 모두의 주민등록초본(최근 5년)등록금 납입 영수증학자금지급증명서 또는 장학수혜확인서학자금중복지원방지 및 상환(반환)서약서학자금 지원구간 통지서 * 자세한 사항은 첨부자료 및 부안군홈페이지 참고'
    },
    {
      Col1: '(재)부안군근농인재육성재단',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생으로 직전학년 학업성적 평균이 B학점(80점) 이상인자 (*2.7(4.3)/ 3.0(4.5))',
      Col10: '해당없음',
      Col11: '1000000원 정액지원 (생활비 보조)',
      Col12: '2020년 대학교 3학년/ 4학년 재학생',
      Col13: '부안군 지역 고등학교 졸업자 : 부모 모두 주소 1년 이상 연속 거주그 외 지역 고등학교 졸업자/ 동등의 학력 인정 자  : 부/모 모두 주소 3년 이상 연속 거주 ',
      Col14: '2022-03-21~2022-04-22',
      Col15: ' * 학업성적 80%/ 생활정도 20% (종합평점으로 선발) 학업성적 2점씩 배점(4.3기준 0.08점 간격구분/ 4.5기준 0.075점 간격구분)가정형편 1점씩 배점(2017년 월평균 건강보험료 납입액/ 부모 합산)',
      Col16: '103명',
      Col17: '1980년(만40세) 이전 출생자원격대학(방송통신대학/ 사이버대학/ 학점은행제) / 평생교육법상 설립된 대학의 재학생직전학년도에 성적우수/ 특기/ 희망장학금을 수혜 받은 학생',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '장수군애향교육진흥재단',
      Col2: '신입생 반값등록금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 4000000원 (대학교 등록금 중 국가장학금 등 타 장학금을 제외한 본인 부담금의 반값 지원)',
      Col12: '대학교 1학년 신입생',
      Col13: '보호자의 주민등록상 주소가 공고일 현재 2년 이상 계속하여 장수군에되어 있는 자 (보호자 1명 이상 해당)',
      Col14: '2022-03-21~2022-04-22',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '원격대학(방송통신대학/ 사이버대학/ 학점은행제) 재학생퇴학 또는 정학 처분을 받았을 때휴학을 하였을 때학생의 본분을 벗어난 행동으로 사회적 물의를 야기 하였을 때  * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서재학증명서보호자 주민등록 초본가족관계증명서개인정보 수집 및 조회 동의서등록금 납입 영수증서약서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '장수군애향교육진흥재단',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 학업성적이 B+학점 이상인 자',
      Col10: '해당없음',
      Col11: '등록금 1000000원',
      Col12: '대학교 재학생(2~4학년)으로 지역거주여부 및 성적기준을 충족하는 자',
      Col13: '보호자(부모중 1명)가 장수군 관내에 주소를 두고 공고일 이전 2년이상 계속 거주주',
      Col14: '2022-03-21~2022-04-22',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '원격대학(방송통신대/ 사이버대학/ 학점은행제) 재학생퇴학 또는 정학 처분을 받았을 때휴학을 하였을 때학생의 본분을 벗어난 행동으로 사회적 물의를 야기 하였을 때 ',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서재학증명서보호자 주민등록 초본(2년)가족관계증명서(부 또는 모)개인정보 수집 및 조회 동의서직전학년 성적증명서서약서건강보험료 납부확인서(부모 모두 제출) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '장수군애향교육진흥재단',
      Col2: '희망장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활보장수급 가정의 자녀',
      Col11: '생활비 500000원',
      Col12: '대학교(2~4학년)재학생국민기초생활보장수급 가정의 자녀',
      Col13: '보호자의 주민등록상 주소가 공고일 현재 2년 이상 계속하여 장수군에되어 있는 자 (보호자 1명 이상 해당)',
      Col14: '2022-02-07~2022-03-25',
      Col15: '해당없음',
      Col16: '00명',
      Col17: '원격대학(방송통신대학/ 사이버대학/ 학점은행제) 재학생퇴학 또는 정학 처분을 받았을 때휴학을 하였을 때학생의 본분을 벗어난 행동으로 사회적 물의를 야기 하였을 때 ',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서재학증명서보호자 주민등록 초본(2년)가족관계증명서(부 또는 모)개인정보 수집 및 조회 동의서국민기초생활보장 수급자 증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '진안사랑장학재단',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생(2년제 이상) : 대학수학능력시험 백분위 평균 70점 이상인 자수능 미 응시자: 고등학교 3학년 내신 평균성적이 70점 이상인 자     (수능 미 응시 확인서 학교장 확인필 제출)재학생(2년제 이상 ): 2021년 평균성적이 B학점 이상  * 복학생의 경우 휴학 전 학년도 성적',
      Col10: '해당없음',
      Col11: '1인당 최대 2000000원',
      Col12: '해당없음',
      Col13: '2021. 01. 01.부터 현재까지 진안군에 1년 이상 주민등록이 되어 있는 진안군민 또는 그 자녀 ',
      Col14: '2022-02-07~2022-03-25',
      Col15: '성적 배점기준표/ 경제상황 배점기준표/ 가산점에 의해 순위 결정 후 재단이사회에서 장학생 선정동점자 우선순위 결정: 최근 2년간 재단장학금을 받지 아니한 자 > 성적 배점 우위자 > 경제상활 배점 우위자 > 성적 점수 우위자 > 건강보험료 고지금액이 적은 자 수 ',
      Col16: '해당없음',
      Col17: '일반장학생과 특별장학생은 중복신청은 가능/ 하나만 최종 선발  방송대학/통신대학/ 방송통신대학 및 사이버대학 재학생 제외중복지원 제한 (등록금 전액 규모를 초과하여 타 장학금 및 학자금 대출 수혜 불가)',
      Col18: '학장 또는 총장 날인(신입생은 합격통지서 사본 첨부)',
      Col19: '장학생 지원서 학생 주민등록초본부 또는 모 주민등록초본가족관계등록부재학증명서성적증명서건강보험 납부확인서 또는 건강보험 자격득실확인서개인정보 수집·이용·제공 및 조회 동의서신청인 서약서 *해당자*관내 학교 학적 보유자 (초·중·고 각각의 졸업증명서)다자녀인 경우 (부 또는 모 가족관계증명서)자원봉사활동 실적 확인서 (2020년도 봉사 증빙서류)* 접수처 : 관내 학교 소재지의 관할 읍/면사무소 '
    },
    {
      Col1: '진안사랑장학재단',
      Col2: '복지및특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 최대 2000000원',
      Col12: ' *복지 장학생국민기초수급/ 차상위 계층/ 소년소녀가장/ 모부자가정/ 보호시설출신자/ 장애인 자녀/ 다문화 가정 자녀 등 *특기 장학생음악/미술/체육/무용 등 예체능 분야에서 재능을 보이는자/ 재능분야에 맞는 학교에 진학한 자',
      Col13: '2021. 01. 01부터 현재 진안군에 1년 이상 주민등록이 되어 있는 진안군민 또는 그 자녀',
      Col14: '2020-01-20~2020-03-13',
      Col15: '별도 구분 접수하고 성적 배점기준표/ 경제상활 배점기준표/ 가산점에 의해 순위 결정 후 재단 이사회에서 선정 ',
      Col16: '해당없음',
      Col17: '1가족에서 2명 이상 장학금 지원 신청 가능/ 심사 후 1명만 최종 선발일반장학생과 특별장학생은 중복신청은 가능/ 하나만 최종 선발  방송대학/통신대학/ 방송통신대학 및 사이버대학 재학생 제외중복지원 제한 (등록금 전액 규모를 초과하여 타 장학금 및 학자금 대출 수혜 불가)',
      Col18: '학장 또는 총장 날인(신입생은 합격통지서 사본 첨부)',
      Col19: '장학생 지원서주민등록등본(가족관계등록부) 및 주민등록초본재학증명서(신입생은 등록금 납부영수증/ 합격통지서 함께 제출)2021년도 건강보험료 납부확인서 또는 자격득실확인서개인정보 수집/이용/제공 및 조회 동의서신청인 서약서특기실적증명서(특기장학생: 각종 대회 수상실적 증명 및 상장/ 상패 사본) * 해당자 제출서류국민기초생활수급대상자/ 차상위계층지정자국가보훈대상자 증명서(부모 또는 학생)2020년도 자원봉사활동 실적확인서 * 접수처 : 주소지 읍/ 면 장학금 담당 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '진안사랑장학재단',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '서울대 연세대 고려대 카이스트의대 치대 한의대 : 3000000원',
      Col12: '서울 소재 4년제 대학과 우수 지방소재대학교 신입생 (첨부된 자료의 특별장학금 지급 대상 대학교 참고)관내고등학교 졸업자',
      Col13: '2019. 01. 01. 현재 진안군에 1년 이상 주민등록이 되어 있는 진안군민 또는 그 자녀관내고등학교 졸업자',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '1가족에서 2명 이상 장학금 지원 신청 가능/ 심사 후 1명만 최종 선발일반장학생과 특별장학생은 중복신청은 가능/ 하나만 최종 선발  방송대학/통신대학/ 방송통신대학 및 사이버대학 재학생 제외중복지원 제한 (등록금 전액 규모를 초과하여 타 장학금 및 학자금 대출 수혜 불가)',
      Col18: '학장 또는 총장 날인(신입생은 합격통지서 사본 첨부)',
      Col19: '장학생 지원서주민등록등본(가족관계등록부) 및 주민등록초본재학증명서(신입생은 등록금 납부영수증/ 합격통지서 함께 제출)   * 관내학교 졸업생의 경우 졸업증명서/ 재학증명서 제출성적증명서   1. 대학교 신입생 : 대학합격통지서/ 수능성적증명서/ 고등학교 전학년(3년간) 성적증명서   2. 수능미응시자 : 고등학교 3학년 성적증명서 (수능 미응시 확인서 필히 제출)   3. 대학교 재학생 : 이전학년 성적증명서2019년도 건강보험료 납부확인서/ 자격득실확인서개인정보 수집/이용/제공 및 조회 동의서신청인 서약서 * 해당자 제출서류국민기초생활수급대상자/ 차상위계층지정자국가보훈대상자 증명서(부모 또는 학생)2019년도 자원봉사활동 실적확인서* 접수처 : 주소지 읍/ 면 장학금 담당'
    },
    {
      Col1: '진안사랑장학재단',
      Col2: '해외유학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학부 성적이 B학점 이상',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '어려운 형편에서도 학업을 열심히 하여 해외에 위치한 대학교에 입학하여 타의 모범이 되는 자',
      Col13: '2018. 01. 01. 현재 진안군에 1년 이상 주민등록이 되어 있는 진안군민 또는 그 자녀',
      Col14: '2020-11-18~2020-12-14',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '국외대학교 타 장학금을 받지 않는 자',
      Col18: '지도교수의 추천을 받은 자',
      Col19: '장학생 지원서주민등록등본(가족관계등록부) 및 주민등록초본재학증명서(신입생은 등록금 납부영수증/ 합격통지서 함께 제출)타장학금 수혜(비수혜)확인서 공문(국외)관내학교 졸업생의 경우 졸업증명서/ 재학증명서 제출성적증명서   1. 대학교 신입생 : 대학합격통지서/ 수능성적증명서/ 고등학교 전학년(3년간) 성적증명서   2. 수능미응시자 : 고등학교 3학년 성적증명서 (수능 미응시 확인서 필히 제출)   3. 대학교 재학생 : 이전학년 성적증명서해외장학생 서류 : 첨부파일 참고2018년도 건강보험료 납부확인서 또는 자격득실확인서개인정보 수집/이용/제공 및 조회 동의서신청인 서약서 * 해당자 제출서류국민기초생활수급대상자/ 차상위계층지정자국가보훈대상자 증명서(부모 또는 학생)2018년도 자원봉사활동 실적확인서* 자세한 사항은 첨부파일 참고필수'
    },
    {
      Col1: '진안사랑장학재단',
      Col2: '고향사랑장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '진안군 관내 중·고등학교를 모두 졸업하고 현재 대학교에 재학 중인 자 2년제 이상 대학생',
      Col13: '2019.01.01부터 공고일 현재까지 진안군에 주민등록을 계속하여 유지하고 있는 진안군민 또는 그 자녀 ',
      Col14: '2020-09-28~2020-10-16',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '방송대학/통신대학/ 방송통신대학 및 사이버대학 재학생 ',
      Col18: '해당없음',
      Col19: '장학생 지원서부·모 또는 학생 주민등록초본부 또는 모 가족관계등록부관내 중·고 졸업 증명서대학교 성적증명서대학교 재학증명서개인정보제공동의 및 활용승낙서신청인 서약서통장 사본 '
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생(택1):  · 대학수학능력시험 성적 평균 80점 이상 · 고등학교 3학년 2학기 성적 평균 80점 이상 · 검정고시 출신자는 검정고시 성적 평균 80점 이상재학생: · 직전학기 성적 평균 80점 이상(재학생 B학점 이상) * 편입생 및 재입학생은 이전에 다녔던 대학의 직전학기 성적 * 복학생은 휴학 직전학기 성적',
      Col10: '동점의 경우 저소득계층 우선',
      Col11: '1인당 1500000원 * 대학생은 중복지원 방지를 위해 타 기관 장학금을 받은 경우에는 그 총액과 등록금의 차액이 20만원 이상인 경우에 한해 차액을 지급',
      Col12: '시·군 자체 심사 및 추천/ 장학위원회 심사 결정',
      Col13: '공고일 현재 보호자와 학생 본인이 1년 이상 전라남도에 주소를 두고 있는 대학생 ( 타 지역 주소자도 가능)',
      Col14: '2021-10-21~2021-11-10',
      Col15: '선발은 서류심사 후(신청요건/ 선정기준 등) 재단 장학위원회 선발성적70%/ 소득 30%',
      Col16: '155명 (일반대학 118명/ 전문대학 37명)',
      Col17: ' * 지원제외 항목 상세한내용은 첨부자료 참고 필수  장학금지원은 매년 1회로 제한/ 이중·허위 수혜자는 3년간 지원제외사이버대학(원격대학)/ 사내대학국가 등으로부터 학비 등을 지원받는 학교정규 학제 기간을 초과하여 재학중인 대학생대학원생',
      Col18: '시·군 자체 심사 및 추천',
      Col19: '인재육성장학금신청서주민등록 등본(본인과 부모의 주소지가 다를 경우 각각 제출)가족관계증명서(공통/ 미혼 : 부모 명의 발급/ 기혼 : 본인 또는 배우자 명의 발급)재학증명서개인정보 수집·이용 및 제공·조회 동의서장학금 지급통장 사본(부/모 통장제출 금지/ 본인 통장 제출)직전학기 성적증명서건강보험료 납부확인서 및 건강보험 자격확인서 각각 1부신청인 서약서 * 주민등록 뒷자리가 노출되지 않도록 가린 후 제출 * 접수처 : 부모(친권자) 주소지 시·군 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고고'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '미래인재장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2014년 ~ 2019년 선발된 장학생 중 직전학기 성적 ',
      Col10: '해당없음',
      Col11: '1인당 2000000원 * 정규학제 기간 동안 지원(휴학기간 제외) * 학업장려금으로 이중수혜 가능',
      Col12: '기선정자 28명 (2014년 ~ 2019년 선발된 미래인재 장학생)',
      Col13: '공고일 현재 보호자와 학생 본인이 1년 이상 전라남도에 주소를 두고 있는 대학생 ( 타 지역 주소자도 가능)',
      Col14: '2021-08-19~2021-09-07',
      Col15: '일몰제 도입으로 신규 선발하지 않고 기선정자에 대한 자격요건 심사',
      Col16: '25명',
      Col17: '장학금지원은 매년 1회로 제한/ 이중·허위 수혜자는 3년간 지원제외사이버대학(원격대학)/ 사내대학국가 등으로부터 학비 등을 지원받는 학교정규 학제 기간을 초과하여 재학중인 대학생대학원생',
      Col18: '해당없음',
      Col19: '인재육성장학금신청서주민등록 등본(본인과 부모의 주소지가 다를 경우 각각 제출)가족관계증명서재학증명서개인정보 수집·이용 및 제공·조회 동의서장학금 지급통장 사본(부·모 통장제출 금지/ 본인 통장 제출)직전학기 성적증명서 * 주민등록 뒷자리가 노출되지 않도록 가린 후 제출 * 접수처 : 부모(친권자) 주소지 시·군 * 자세한사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '특별 장학생(힘내라! 희망전남)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '600000원 ( * 취업준비 장학금으로 학자금 이중수혜 금지 예외)',
      Col12: '도내 소재 대학의 졸업학년도 재학생으로 지역거주요건을 충족하는 자',
      Col13: '도내 소재 대학의 졸업학년도 재학생보호자 또는 본인의 주민등록상 주소가 도내에 1년 이상 소재한 경우',
      Col14: '2022-05-02~2022-06-24',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '정규학기 초과자 지원불가',
      Col18: '해당없음',
      Col19: ' * 소속 대학교로 접수/ 자세한 사항은 첨부파일 참조장학금 지원신청서재학증명서주민등록등본개인정보 수집·이용·제공 동의서보통예금 통장(본인) 사본'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '으뜸 인재 발굴대회 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '사회적 배려대상 선발인원 20% 선발 ',
      Col11: '6000000원 * 2년제 최대 2년 4년제 최대 4년간 지원',
      Col12: ' * 모집분야 : (미래리더) 예체능을 제외한 전 분야 /  (예체능리더) 음악/미술/무용/체육/기타(유형Ⅰ) 최근 2년 전국/도 단위 이상 수상실적 있는 자(유형Ⅱ) 수상실적이 없어도 해당분야에서 핵심인재로 성장할 충분한 잠재력과 성실성이 인정된 자(유형Ⅲ) 직전년도 스타200인 선발자로 고등학교 졸업한 자 ※ 첨부파일 참조',
      Col13: '공고일 기준 부·모 또는 본인이 전라북도에 주민등록을 두고 거주도 소재 초/중/고등학교 중 1개교 이상 졸업하거나 현재 도내 소재 대학 재학',
      Col14: '2022-09-05~2022-10-04',
      Col15: '서류심사 → 면접심사',
      Col16: '해당없음',
      Col17: '졸업학년(2년제 2학년/ 4년제 4학년)휴학생전공분야 재능꼐발 포기시 지급중지 진흥원 장학금 이중수혜시 지원금 회수 * 자세한 사항은 첨부파일 참조 바랍니다.',
      Col18: ' * 유형Ⅱ 지원자 추천 필수',
      Col19: '지원신청서자기소개서 자기계발계획서개인정보 수집·이용·제공 동의서주민등록초본가족관계증명서심사자료(활동실적) 제출재학증명서실적증명서(택1/ 유형Ⅰ 지원자)추천서(유형Ⅱ 지원자)경제상황 증빙서류(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '5.18민주유공자자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '경제적으로 어려운 저소득 계층을 우선적으로 선정',
      Col11: '1인당 1500000원 * 학업장려금으로 이중수혜 가능',
      Col12: '5.18민주유공자예우에 관한 법률 제4조/ 제5조/ 제7조 해당 자',
      Col13: '본인 및 친권자가 공고일 현재 전라남도에 1년 이상 주소를 둔 학생(대학생의 경우 학생 본인에 한하여 타 지역 주소 인정)부모의 이혼/ 사망 및 이와 동등하다고 인정(서류로확인) 되는경우 예외',
      Col14: '2021-10-21~2021-11-10',
      Col15: '5.18구속부상자회 추천/ 장학위원회 심사결정',
      Col16: '대학생 22명',
      Col17: '진흥원에서 추진하는 사업에 선정되어 지원금을 받고 있는 경우진흥원 장학금 동시 지원 불가한 가구 내 선신청자 1인만을 지원 적격자로 판단휴학생/ 수료생/ 초과학기 재학생 등계속 장학생으로 선정 된 후 자퇴 및 퇴학 등으로 더 이상 학업을 수행하지 않는 경우',
      Col18: '5.18단체 추천',
      Col19: '장학금 신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장 사본 해당 증명서 * 주민등록번호 뒷자리가 노출되지 않도록 가린 후 제출 ** 자세한 사항은 홈페이지 및 첨부파일 참고'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 1500000원',
      Col12: '다자녀 가구의 자녀 중 1명',
      Col13: '공고일 현재 친권자(또는 후견인)와 학생 본인이 1년 이상 전라남도에 주소를 두고 있는 대학생 (대학생은 타 지역 주소자도 가능)부모의 이혼/ 사망 및 이와 동등하다고 인정(서류로 확인)되는 경우 예외',
      Col14: '2022-04-01~2022-04-29',
      Col15: '시·군 자체 심사 및 추천/ 장학위원회 심사 결정 * 자녀수 50%/ 소득 평가 50%(동점일 경우 다자녀 가정 우선 선발)',
      Col16: '40명',
      Col17: '최근 2년간 수혜가정 제외장학금지원은 매년 1회로 제한/ 이중·허위 수혜자는 3년간 지원제외사이버대학(원격대학)/ 사내대학국가 등으로부터 학비 등을 지원받는 학교정규 학제 기간을 초과하여 재학중인 대학생대학원생',
      Col18: '해당없음',
      Col19: '인재육성장학금신청서주민등록 등본(본인과 부모의 주소지가 다를 경우 각각 제출)가족관계증명서(공통/ 미혼 : 부모 명의 발급/ 기혼 : 본인 또는 배우자 명의 발급)재학증명서개인정보 수집·이용 및 제공·조회 동의서장학금 지급통장 사본(부·모 통장제출 금지/ 본인 통장 제출)직전학기 성적증명서건강보험료 납부확인서 및 건강보험 자격확인서 각각 1부신청인 서약서 * 주민등록 뒷자리가 노출되지 않도록 가린 후 제출 * 접수처 : 부·모(친권자) 주소지 읍·면·동 주민센터 * 자세한사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '율촌현대장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전학기 성적 평균 80점 이상(대학생은 “B학점” 이상) 재학생 ※ 장애인/ 기초생활수급자 및 차상위계층은 70점(',
      Col10: '해당없음',
      Col11: '1인당 1500000원',
      Col12: '해당없음',
      Col13: '본인 및 친권자가 공고일 현재 전라남도에 1년 이상 주소를 둔 학생',
      Col14: '2022-09-05~2022-10-04',
      Col15: '시·군 자체 심사 및 추천/ 장학위원회 심사 결정 * 소득평가 100% 적용(동점의 경우 저소득계층 우선)',
      Col16: '9명 (대학생 6명/ 전문대학생 3명)',
      Col17: '장학금신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장사본* 자세한 내용은 첨부파일 참고 필수',
      Col18: '시장·군수',
      Col19: '장학금신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장사본직전학기 성적증명서건강보험료 납부확인서신청인 서약서서* 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '전남학숙장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/석사2학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 ',
      Col10: '소득분야 : 소득인정액 기준 중위소득 150% 이내의 가정',
      Col11: ' * 소득분야 : 인당 700000원 ( 기초생활수급자 : 1000000원) * 성적분야 : 인당 500000원 ( 평점 85점 이상 1000000원 )',
      Col12: '공고일 현재 학숙생활 3개월 이상인 전남학숙 재사생 중 성적기준 또는 소득기준을 충족한 재학생',
      Col13: '공고일 현재 보호자와 학생 본인이 1년 이상 전라남도에 주소를 두고 있는 대학생',
      Col14: '2022-07-04~2022-07-29',
      Col15: '선발은 서류심사 후(신청요건/ 선정기준 등) 재단 장학위원회 선발 * 소득분야 :소득평가90%/ 학숙생활 성적10% * 성적분야 : 학교성적 60%/ 학숙생활 성적 40%/ 가점 6점을 합산한 평점이 70점 이상',
      Col16: '55명',
      Col17: '장학금 중복 지원 및 선발 불가동시 지원 시 선접수된 지원서만 심사한 가구 내 신청자 1인만 심사휴학생/ 수료생/ 초과학기 재학생자퇴/ 퇴학/ 장학금 받고 휴학 시 지원 중단되며 반납해야함* 자세한 내용은 첨부파일 참고',
      Col18: '전남학숙 추천',
      Col19: '장학금신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장사본해당 증명서류* 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '대학생학자금대출이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한국장학재단 학자금(등록금 생활비)대출 이자 전액 ＊일반상환 학자금대출 + 취업후 상환 학자금 대출2022년 1월~6월에 발생한 대출이자',
      Col12: '국내 대학 재학(휴학)생/ 졸업 후 2년 이내 미취업자 ＊졸업(수료)일자가 2020년 7월 이후',
      Col13: '공고일 기준 본인 또는 직계존속이 1년이상 도내 주민등록이 되어 있는 자',
      Col14: '2022-04-01~2022-04-29',
      Col15: '전남인재평생교육진흥원 홈페이지에서 온라인 신청',
      Col16: '해당없음',
      Col17: '이자 조회 및 지급 장시 대출금이 전액 상환된 경우',
      Col18: '해당없음',
      Col19: '주민등록초본대학교 재학(휴학)증명서 1부대학교 졸업(수료)증명서 1부건강보험자격득실확인서 1부가족관계증명서'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '해양에너지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전 학기 성적 ',
      Col10: '해당없음',
      Col11: '1인당 1500000원',
      Col12: '해당없음',
      Col13: '본인 및 친권자가 공고일 현재 전라남도에 1년 이상 주소를 둔 학생',
      Col14: '2022-04-01~2022-04-29',
      Col15: '소득평가 100%동점일 경우 저소득계층 우선',
      Col16: '20명 (일반대학 10명/ 전문대학 10명)',
      Col17: '장학금 중복 지원 및 선발 불가동시 지원 시 선접수된 지원서만 심사한 가구 내 신청자 1인만 심사휴학생/ 수료생/ 초과학기 재학생자퇴/ 퇴학/ 장학금 받고 휴학 시 지원 중단되며 반납해야함* 자세한 내용은 첨부파일 참고',
      Col18: '시장 또는 군수',
      Col19: '장학금신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장사본직전학기 성적증명서건강보험료 납부확인서신청인 서약서* 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '긴급지원장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원 ~ 5000000원 * 학업장려금(생활비 재능개발비 등 등록금 이외의 교육비)으로 이중수혜 가능',
      Col12: '「긴급복지지원법」 제2조에 따른 위기상황이 발생한 가정의 대학생',
      Col13: '본인 및 친권자가 공고일 현재 전라남도에 1년 이상 주소를 둔 학생',
      Col14: '2022-09-05~2022-10-04',
      Col15: '도/시/군 자체 심사 및 추천',
      Col16: '40명',
      Col17: '장학금 중복 지원 및 선발 불가동시 지원 시 선접수된 지원서만 심사한 가구 내 신청자 1인만 심사휴학생/ 수료생/ 초과학기 재학생자퇴/ 퇴학/ 장학금 받고 휴학 시 지원 중단되며 반납해야함* 자세한 내용은 첨부파일 참고',
      Col18: '시장/군수 추천',
      Col19: '장학금신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장사본추천공문* 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '고향정착희망장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/의약계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 500000원',
      Col12: '산학협력 취업패키지 과정에 참여하고 있는 재학생',
      Col13: '본인 및 친권자가 공고일 현재 전라남도에 1년 이상 주소를 둔 학생(대학생의 경우 학생 본인에 한하여 타 지역 주소 인정)부모의 이혼/ 사망 및 이와 동등하다고 인정(서류로확인) 되는경우 예외',
      Col14: '2022-04-01~2022-04-29',
      Col15: '해당없음',
      Col16: '273명 ',
      Col17: '국가장학금(한국장학재단)/ 정부/ 지자체/ 대학/ 민간장학재단 등에서 동일 학기에 지원받은 장학금 총액이 등록금을 초과하거나 그 차액이 20만원 미만인 대학생정규학제 기간을 초과하여 재학중인 대학생',
      Col18: '대학 총장 추천',
      Col19: '인재육성장학금신청서학자금 지급증명서(한국장학재단 발급)주민등록등본 (본인과 부모의 주소지가 다를경우 각각 제출)가족관계증명서재학증명서신청인 서약서개인정보 수집/이용 및 제공/조회 동의서통장사본(본인명의제출)출석증명서추천공문 * 주민등록 뒷자리가 노출되지 않도록 가린 후 제출 * 접수처 : 해당대학교'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: 'SK E&S전남도시가스장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학신입생(택1) : · 대학수학능력시험 성적 평균 80점 이상 · 고등학교 3학년 2학기 성적 평균 80점 이상 · 검정고시 출신자는 검정고시 성적 평균 80점 이상대학 재학생 : 직전학기 성적 평균 80점(대학생',
      Col10: '소득인정액 기준 중위소득 150% 이내의 가정',
      Col11: '1인당 1500000원',
      Col12: '해당없음',
      Col13: '공고일 현재 보호자와 학생 본인이 1년 이상 전라남도에 주소를 두고 있는 대학생',
      Col14: '2022-09-05~2022-10-04',
      Col15: '시·군 자체 심사 및 추천/ 장학위원회 심사 결정 * 성적분야 : 성적평가 70%/ 소득 평가 30%(동점의 경우 저소득계층 우선)',
      Col16: '10명',
      Col17: '장학금 중복 지원 및 선발 불가동시 지원 시 선접수된 지원서만 심사한 가구 내 신청자 1인만 심사휴학생/ 수료생/ 초과학기 재학생자퇴/ 퇴학/ 장학금 받고 휴학 시 지원 중단되며 반납해야함* 자세한 내용은 첨부파일 참고',
      Col18: '시/군 추천',
      Col19: '장학금신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장사본직전학기 성적증명서건강보험료 납부확인서신청인 서약서서* 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '중소기업근로자자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평균 70점(대학생 C+학점) 재학생 * 대학 편입생 및 재입학생은 이전에 다녔던 대학의 직전학기 성적 * 복학생은 휴학 직전학기 성적',
      Col10: '해당없음',
      Col11: '1500000원 ',
      Col12: '상시근로자 수 5명 이상 관내 중소기업/ 동일 사업장에 1년 이상 재직한 근로자의 자녀',
      Col13: '본인 및 친권자가 공고일 현재 전라남도에 1년 이상 주소를 둔 학생',
      Col14: '2022-04-01~2022-04-29',
      Col15: '수상실적 30% / 소득평가 50%/ 자녀수 20% * 소득 평가는 가구원의 건강보험료 납부액으로 평가 * 한국/민주노총 자체 심사 및 추천/ 장학위원회 심사 결정',
      Col16: '10명',
      Col17: '타 장학금을 받았거나 2분의 1이상의 학비감면을 받은 자진흥원에서 추진하는 사업에 선정되어 지원금을 받고 있는 경우진흥원 장학금 동시 지원 불가한 가구 내 선신청자 1인만을 지원 적격자로 판단휴학생/ 수료생/ 초과학기 재학생 등',
      Col18: '해당없음',
      Col19: '장학금신청서주민등록 등본(본인과 부모의 주소지가 다를 경우 각각 제출)가족관계증명서재학증명서건강보험료 납부확인서건강보험 자격확인서신청인서약서개인정보 수집/이용 및 제공/조회 동의서수상증명(상장)추천서 * 자세한사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '황경자 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '인당 500000원 * 학업장려금(생활비 재능개발비 등 등록금 이외의 교육비)으로 이중수혜 가능',
      Col12: '공고일 현재 소방공무원 근무경력 3년 이상인 사람으로서 순천소방서에서 1년 이상 근무하고 있는 사람의 자녀성실하고 창의적인 자세로 솔선수범하고 타의 모범이 된 사람의 자녀각종 평가에 우수한 성적으로 소방발전에 기여한 사람의 자녀화재/ 구조/ 구급 등 현장 활동을 통한 도민생명보호에 공헌한 사람의 자녀',
      Col13: '공고일 현재 친권자(또는 후견인)와 학생 본인이 1년 이상 전라남도에 주소를 두고 있는 대학생',
      Col14: '2022-09-05~2022-10-04',
      Col15: '순천소방서 추천 후 재단 장학위원회 심사사',
      Col16: '1명',
      Col17: '장학금 중복 지원 및 선발 불가동시 지원 시 선접수된 지원서만 심사한 가구 내 신청자 1인만 심사휴학생/ 수료생/ 초과학기 재학생자퇴/ 퇴학/ 장학금 받고 휴학 시 지원 중단되며 반납해야함* 자세한 내용은 첨부파일 참고',
      Col18: '순천소방서 자체 심사 추천',
      Col19: '장학금신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장사본해당 증명서류* 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '녹색에너지(소득)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활수급자 차상위계층 및 다문화가정의 자녀',
      Col11: '인당 1500000원',
      Col12: '국민기초생활수급자/ 차상위계층 및 다문화가정의 자녀',
      Col13: '공고일 현재 보호자와 학생 본인이 1년 이상 전라남도에 주소를 두고 있는 대학생',
      Col14: '2022-09-05~2022-10-04',
      Col15: '시·군 자체 심사 및 추천/ 장학위원회 심사결정소득평가 100%동점의 경우 저소득계층 우선',
      Col16: '32명',
      Col17: '장학금 중복 지원 및 선발 불가동시 지원 시 선접수된 지원서만 심사한 가구 내 신청자 1인만 심사휴학생/ 수료생/ 초과학기 재학생자퇴/ 퇴학/ 장학금 받고 휴학 시 지원 중단되며 반납해야함* 자세한 내용은 첨부파일 참고',
      Col18: '시장·군수 추천',
      Col19: '장학금신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장사본건강보험료 납부확인서신청인 서약서* 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 전남인재평생교육진흥원',
      Col2: '녹색에너지(성적)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '신입생(택1) · 대학수학능력시험 성적 평균 80점 이상 · 고등학교 3학년 2학기 성적 평균 80점 이상 · 검정고시 출신자는 검정고시 성적 평균 80점 이상재학생 : 직전학기 성적 평균 80점 이상(대학생은 “B학점” 이상) 재학생 ※ 장애인/ 기초생활수급자 및 차상위계층은 70점(',
      Col10: '해당없음',
      Col11: '인당 1500000원',
      Col12: '해당없음',
      Col13: '공고일 현재 보호자와 학생 본인이 1년 이상 전라남도에 주소를 두고 있는 대학생',
      Col14: '2022-02-21~2022-03-04',
      Col15: '성적평가 70%/ 소득평가 30%  * 동점의 경우 저소득계층 우선',
      Col16: '16명',
      Col17: '장학금 중복 지원 및 선발 불가동시 지원 시 선접수된 지원서만 심사한 가구 내 신청자 1인만 심사휴학생/ 수료생/ 초과학기 재학생자퇴/ 퇴학/ 장학금 받고 휴학 시 지원 중단되며 반납해야함* 자세한 내용은 첨부파일 참고',
      Col18: '시장·군수',
      Col19: '장학금신청서주민등록등본가족관계증명서재학증명서개인정보 수집이용 및 제공조회 동의서장학금 지급 통장사본직전학기 성적증명서건강보험료 납부확인서신청인 서약서서* 자세한 내용은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 화순장학회',
      Col2: '성적우수',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전학기 성적이 평균 B+학점 이상인 자 (직전학기 10학점 이하 이수자는 그  이전학기 성적까지 합산)신입생 : 신입생은 수능 응시자의 경우 수능성적 평균 3등급이내/ 수능 미응시자의 경우 직전학기 성적 평균등급이 3등급 이내 ',
      Col10: '해당없음',
      Col11: '2000000원(상/하반기 균등 분할 지급)',
      Col12: '고등교육법에 따른 국내 4년제 이상 정규 대학교에 재학중인 자',
      Col13: '본인과 부모(친권자) 모두 공고일 현재 화순군에 1년 이상 계속하여 주민등록을 둔자(대학생 본인은 타 지역 주소자도 가능)',
      Col14: '2022-02-21~2022-03-04',
      Col15: ' * 선발기준 : 성적60%+소득40% * 가점(최대5점) 관내 고등 학교 졸업생 : 3점다자녀(셋째이상) 가구 : 2점다문화 가구 : 2점장애인 가구 : 2점',
      Col16: '수도권(서울/경기/인천 소재) : 신입생(3명)/ 재학생(10명)기타지역 : 신입생(3명)/ 재학생(11명)',
      Col17: '학기당 실등록금 납부금액이 100만원 미만인 자',
      Col18: '해당없음',
      Col19: '화순장학금신청서주민등록등본 (접수개시일 이후 발급)부와 모가 주소지가 다를 경우 부/ 모의 주민등록등본 각각 1부가족관계증명서 (부모 명의로 발급)당해학기 등록금 납입영수증   (등록금 총액/ 장학금 수혜액/ 본인 납부액이 모두 명시되어 있어야 함)재학증명서고등학교 졸업증명서 (고등학교 출신 지역 확인용)개인(신용)정보 수집이용제공 및 조회 동의서통장 사본 (본인 또는 법정대리인 명의)직전학기 성적증명서 (신입생은 수능시험 성적표(미응시자는 고교 생활기록부)2021년 건강보험료 납부확인서(최근 3개월/ 부/모 각각 발급)건강보험료를 납부하지 않는 경우 미가입자(피부양자) 건강보험 자격득실확인서 제출국민기초생활보장수급자/ 차상위계층은 관련 증빙자료 제출시 생략 가능 (수급자 증명서/ 차상위계층 확인서 제출)장애인 증명서 (가점대상자)'
    },
    {
      Col1: '재단법인 화순장학회',
      Col2: '특기',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원 (상/하반기 균등 분할 지급)',
      Col12: '고등교육법에 따른 국내 4년제 이상 정규 대학교에 재학중인 자수상증서 표기일 기준 2021. 03. 06 이후 개최된 도단위 이상 대회에서 기능/ 체육/ 예능 분야에서 입상한 자(3위 이내)',
      Col13: '본인과 부모(친권자) 모두 공고일 현재 화순군에 1년 이상 계속하여 주민등록을 둔자(대학생 본인은 타 지역 주소 인정)',
      Col14: '2022-02-21~2022-03-04',
      Col15: ' * 선발기준 : 대회 규모별 입상(수상) 횟수도대회 3점/ 전국대회 6점/ 세계대회 9점 (횟수에 따라 합산) * 가점(최대5점) 대회별 최고입상자는 가점1점부여개인종목 입상자는 가점1점부여 (1회에 한함)관내 고등학교 졸업생 3점다자녀(셋째이상)가구2점다문화가구 2점장애인 가구 2점',
      Col16: '5명',
      Col17: '학기당 실등록금 납부금액이 100만원 미만인 자',
      Col18: '해당없음',
      Col19: '화순장학금신청서주민등록등본 (접수개시일 이후 발급)부와 모가 주소지가 다를 경우 부/ 모의 주민등록등본 각각 1부가족관계증명서 (부모 명의로 발급)당해학기 등록금 납입영수증   (등록금 총액/ 장학금 수혜액/ 본인 납부액이 모두 명시되어 있어야 함)재학증명서고등학교 졸업증명서 (고등학교 출신 지역 확인용)개인(신용)정보 수집이용제공 및 조회 동의서통장 사본 (본인 또는 법정대리인 명의)수상증서 사본(원본대조필)장애인 증명서 (장애인 가구 해당자)'
    },
    {
      Col1: '재단법인 화순장학회',
      Col2: '복지',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 평균 D학점 이상',
      Col10: '소득인정액 기준 중위소득100%이내의 건강 보험료를 납부하는 가정의 자녀 * 중위소득 : 총 가구 중 소득 순으로 순위를 매긴 다음 정확히 가운데를 차지한 가구의 소득중위소득 50% 미만 : 빈곤층 / 중위소득 50 ~ 150% : 중산층 /  중위소득 150% 초과 : 상류층',
      Col11: '2000000원(상/하반기 균등 분할 지급)',
      Col12: '고등교육법에 따른 국내 4년제 이상 정규 대학교에 재학중인 자',
      Col13: '본인과 부모(친권자) 모두 공고일 현재 화순군에 1년 이상 계속하여 주민등록을 둔자(대학생 본인은 타 지역 주소자도 가능)',
      Col14: '2022-05-03~2022-05-11',
      Col15: ' * 선발기준 : 소득 100% * 가점(최대5점) 관내 고등 학교 졸업생 : 3점다자녀(셋째이상) 가구 : 2점다문화 가구 : 2점장애인 가구 : 2점',
      Col16: '38명',
      Col17: '학기당 실등록금 납부금액이 100만원 미만인 자',
      Col18: '해당없음',
      Col19: '화순장학금신청서주민등록등본 (접수개시일 이후 발급)부와 모가 주소지가 다를 경우 부/ 모의 주민등록등본 각각 1부가족관계증명서 (부모 명의로 발급)당해학기 등록금 납입영수증   (등록금 총액/ 장학금 수혜액/ 본인 납부액이 모두 명시되어 있어야 함)재학증명서고등학교 졸업증명서 (고등학교 출신 지역 확인용)개인(신용)정보 수집이용제공 및 조회 동의서통장 사본 (본인 또는 법정대리인 명의)직전학기 성적증명서 (신입생은 수능시험 성적표(미응시자는 고교 생활기록부))2020년 건강보험료 납부확인서(최근 3개월/ 부모 각각 발급)건강보험료를 납부하지 않는 경우 미가입자(피부양자) 건강보험 자격득실확인서 제출국민기초생활보장수급자/ 차상위계층은 관련 증빙자료 제출시 생략 가능 (수급자 증명서/ 차상위계층 확인서 제출)장애인 증명서 (가점대상자)'
    },
    {
      Col1: '재단법인금하장학회',
      Col2: '대학장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 1000000원(등록금액 범위 내 중복수혜 허용)',
      Col12: '학비 조달이 곤란한 자 중에서 학업에 성실한 자외부활동 실적이 우수하여 본교 발전에 기여한 자',
      Col13: '전라남도 나주지역 출신 학생 우대 (주소지가 나주로 되어있는 경우 또는 나주지역 고교를 졸업한 경우)',
      Col14: '2022-03-15~2022-03-25',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 기존 장학금 수혜자 장학생신상카드 1부 전학년 성적증명서 1부 * 신규 장학금 신청시전학년 성적증명서 1부(신입생의 경우/ 생활기록부 사본 1부) 재학증명서 1부 (신입생의 경우/ 입학허가서 또는 합격증으로 대체) 주민등록등본 1부 기타 증빙서류 각 1부(기초생활수급대상자/ 장애인증명서/ 한부모가정 증명서 등등 자신의 가정형편을 나타낼 수 있는 서류) * 복학생 장학금 신청시(휴학 전 장학금 수혜학생의 경우)장학생 신상카드 1부(자료실) 휴학전까지의 전학년 성적증명서 1부 재학증명서 1부 (등록전의 경우/ 제적증명서를 보내고/ 등록 후 재학증명서 재송부) * 자세한 사항은 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인장성장학회',
      Col2: '성적우수',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학교 재학생 중 직전학기 학업성적이 평균 B학점 이상인 자',
      Col10: '학업성적은 우수하나 경제적 이유로 수학이 곤란한 자',
      Col11: '2000000원 이내',
      Col12: '장성군 군민 또는 자녀로서 성적요건을 만족하는 대학교 재학생',
      Col13: '장성군에 주소를 6개월 이상 계속 두고 있는 군민 또는 그 자녀로서 대학교(전문대포함) 재학생/ 진학예정자 중 분야별 자격요건을 충족하는 자',
      Col14: '2022-03-15~2022-03-25',
      Col15: '선발기준 : 출신학교 10점/ 소득정도 30점/ 성적 60점',
      Col16: '해당없음',
      Col17: '타 장학금으로 등록금 전액이상의 수혜를 받고 있는 자1세대 1명 선발  * 자세한 사항은 홈페이지 참조',
      Col18: '대학 신입생의 경우 최종학교장 추천서 제출  ',
      Col19: '장학금 신청서주민등록등본가족관계증명서재학증명서건강보험료납부확인서건강보험자격확인서지방세세목별과세증명서개인정보 수집·이용 및 제3자 제공 동의서고교졸업증명서성적우수 : 성적증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인장성장학회',
      Col2: '예능특기장학',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원 이내',
      Col12: '체육·예술·기능 분야에 재능이 뛰어나 도 단위 이상의 대회에서 입상한 실적이 있는 자',
      Col13: '장성군에 주소를 6개월 이상 계속 두고 있는 군민 또는 그 자녀로서 대학교(전문대포함) 재학생/ 진학예정자 중 분야별 자격요건을 충족하는 자',
      Col14: '2022-03-15~2022-03-25',
      Col15: '출신학교 10점/ 소득정도 40점/ 입상내역 50점',
      Col16: '4명',
      Col17: '타 장학금으로 등록금 전액이상의 수혜를 받고 있는 자1세대 1자녀 지급 * 자세한 사항은 기관으로 문의 바랍니다.',
      Col18: '해당없음',
      Col19: '장학금 신청서주민등록등본가족관계증명서재학증명서건강보험료납부확인서건강보험자격확인서지방세세목별과세증명서개인정보 수집·이용 및 제3자 제공 동의서고교졸업증명서예체능 : 특기자 증명서 ( 도 단위 이상의 대회에서 입상한 실적 등) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인장성장학회',
      Col2: '복지장학',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '생활형편이 어려운 가정의 자녀',
      Col11: '2000000원 이내 ',
      Col12: '장성군에 주소를 둔 자 또는 그 자녀로서/ 생활형편이 어려운 가정의 자녀',
      Col13: '장성군에 주소를 6개월 이상 계속 두고 있는 군민 또는 그 자녀로서 대학교(전문대포함) 재학생/ 진학예정자 중 분야별 자격요건을 충족하는 자',
      Col14: '2022-03-15~2022-03-25',
      Col15: '출신학교 30점/ 소득득정도 90점/ 가점 10점',
      Col16: '해당없음',
      Col17: '타 장학금으로 등록금 전액이상의 수혜를 받고 있는 자1세대 1자녀 선발 * 자세한 사항은 기관으로 문의 바랍니다.',
      Col18: '해당없음',
      Col19: '장학금 신청서주민등록등본가족관계증명서재학증명서건강보험료납부확인서건강보험자격확인서지방세세목별과세증명서개인정보 수집·이용 및 제3자 제공 동의서고교졸업증명서복지 : 저소득 증명서류(택1) · 국민기초생활수급자증명서/ 차상위증명서/ 한부모증명서/ 장애인증명서/ 다문화 증명서 중 택1 제출 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인장성장학회',
      Col2: '다자녀장학',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원 이내',
      Col12: '자녀수가 3명 이상인 다자녀 가정의 자녀(단/ 상위학교 재학생 1명에 대해서만 지급)',
      Col13: '장성군에 주소를 6개월 이상 계속 두고 있는 군민 또는 그 자녀로서 대학교(전문대포함) 재학생/ 진학예정자 중 분야별 자격요건을 충족하는 자',
      Col14: '2022-02-22~2022-03-11',
      Col15: '출신학교 10점/ 소득정도 50점/ 자녀수 40점',
      Col16: '해당없음',
      Col17: '타 장학금으로 등록금 전액이상의 수혜를 받고 있는 자1세대 1자녀 지급(상위학교 재학생 한 명 지급) * 자세한 사항은 첨부파일 참고 바랍니다.',
      Col18: '해당없음',
      Col19: '장학금 신청서주민등록등본가족관계증명서재학증명서건강보험료납부확인서건강보험자격확인서지방세세목별과세증명서개인정보 수집·이용 및 제3자 제공 동의서고교졸업증명서 * 다자녀 : 형제자매의 휴학증명서 및 졸업증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인나주교육진흥재단',
      Col2: '대학신입생인재장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '성적선발 대학생: 1500000원관내 아동양육시설입소 학생 중 대학 진학생: 1000000원다자녀가구 대학생: 1000000원저소득가정 대학생: 1000000원  * 자세한 사항은 첨부파일 참고',
      Col12: '관내 일반계 및 특성화 고교 출신으로 대학에 진학한 신입생으로 대학에서 추천한 학생관내 중학교와 관내 특목고를 졸업하고 대학에 진학한 신입생으로 대학에서 추천한 학생관내 아동양육시설 입소자 중 관내 고등학교를 졸업하고 대학에 진학한 신입생으로 대학에서 추천한 학생  * 자세한 사항은 첨부파일 참고',
      Col13: '나주시 관내 고등학교 졸업',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '성적선발: 10명아동양육시설 입소학생 전원다자녀가구: 3명저소득가정: 3명',
      Col17: '해당없음',
      Col18: '특정자격1 : 학교장 추천특정자격2 : 대학추천',
      Col19: '장학금 지급 신청서학생 명의의 통장사본(부모 명의의 통장인 경우 가족관계증명서 첨부)고등학교 졸업증명서대학교 재학 증명서  * 성적선발 대학생/ 아동양육시설 입소 학생/ 다자녀가구 대학생/ 저소득가정 대학생 별로 추가 제출 서류 상이하므로 첨부파일 참고 필수  '
    },
    {
      Col1: '재단법인 담양장학회',
      Col2: '담양장학생(일반/저소득/다자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생정시모집 합격자 : 고등학교 3학년 1학기 교과목(전과목) 평균등급 ‘5등급’ 이상 또는 수능성적 (언어/수리/외국어/사회/과학탐구 영역) 4과목 평균등급 ‘5등급’ 이상수시/특별 전형합격자 : 고등학교 3학년 1학기 교과목(전과목) 평균등급 ‘5등급’ 이상 * 재학생최종학기(직전학기) 환산평균 C학점 이상',
      Col10: '다자녀장학생 : 4 명이상',
      Col11: '4년제 2~3년제 공통 1500000원(학기당)* 1학기 성적(C학점이상)이 기준에 미달한 경우 미지급',
      Col12: '해당없음',
      Col13: '본인 및 친권자가 공고일 현재 담양군에 3년이상 주소 또는 등록기준지를 두고 있는 대학생 (대학생 본인은 타 지역 주소 인정)',
      Col14: '2022-02-03~2022-02-18',
      Col15: '학업성적 30%/ 재산정도 70%(재산세/ 건강보험료) 등 배점 기준에 의거 (재)담양장학회 이사회에서 심의 후 결정',
      Col16: '2~3년제 : 5명4년제 : 41명',
      Col17: '등록금 전액 수혜자 제외2개분야 중복신청 및 1가정 2인 신청의 경우질병/ 입영/ 취업 등을 위해 휴학한 경우40세미만 ',
      Col18: '해당없음',
      Col19: '장학생 선발 신청서읍/면장 확인서개인(신용)정보 동의서서약서주민등록등본 (학생과 보호자의 주민등록지가 다를 경우 부/모 각각 1부)가족관계증명서 (부모명의로 발급)건강보험 납부확인서 건강보험자격 확인서지방세 세목별 과세증명서성적증명서 (신입생 : 수능성적표 또는 최종학기 1학기 전교과목 성정표 중 택1) (재학생/대학원생 : 직전학기 성적증명서)재학증명서 (신입생 : 대학지원수험표/ 합격증명서/ 등록금 영수증 중 택1) (재학생 : 재학증명서/ 재적(휴학)증명서 중 택 1)등록금 납부영수증통장사본 (학생본인 명의/ 부모통장 제출금지) * 해당자 추가서류국민기초생활수급자 증명서차상위계층 확인서'
    },
    {
      Col1: '재단법인 담양장학회',
      Col2: '등불장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생정시모집 합격자 : 고등학교 3학년 1학기 교과목(전과목) 평균등급 ‘5등급’ 이상 또는 수능성적 (언어/수리/외국어/사회/과학탐구 영역) 4과목 평균등급 ‘5등급’ 이상수시/특별 전형합격자 : 고등학교 3학년 1학기 교과목(전과목) 평균등급 ‘5등급’ 이상 * 재학생최종학기(직전학기) 환산평균 C학점 이상',
      Col10: '해당없음',
      Col11: '4년제 2000000원 (연1회 2~3년제/4년제 공통) * 1학기 성적(C학점이상)이 기준에 미달한 경우 미지급',
      Col12: '공고일 현재 담양군 의용소방대원 중 3년이상 근무한 대원의 자녀',
      Col13: '본인 및 친권자가 공고일 현재 담양군에 3년 이상 주소 또는 등록기준지를 두고 있는 대학생 (대학생 본인은 타 지역 주소 인정)',
      Col14: '2022-03-14~2022-03-28',
      Col15: '학업성적(30%)/ 재산정도(70%) 등 배점 기준에 의거 (재)담양장학회 이사회에서 심의 후 선정',
      Col16: '기존 4명 신규 1명',
      Col17: '등록금 전액 수혜자 제외2개분야 중복신청 및 1가정 2인 신청의 경우질병/ 입영/ 취업 등을 위해 휴학한 경우40세미만',
      Col18: '해당없음',
      Col19: '장학생 선발 신청서읍/면장 확인서개인(신용)정보 동의서서약서주민등록등본 (학생과 보호자의 주민등록지가 다를 경우 부/모 각각 1부)가족관계증명서 (부모명의로 발급)건강보험 납부확인서 건강보험자격 확인서지방세 세목별 과세증명서 성적증명서 (신입생 : 수능성적표 또는 최종학기 1학기 전교과목 성정표 중 택1) (재학생/대학원생 : 직전학기 성적증명서)재학증명서 (신입생 : 대학지원수험표/ 합격증명서/ 등록금 영수증 중 택1) (재학생 : 재학증명서/ 재적(휴학)증명서 중 택 1)등록금 납부영수증통장사본 (학생본인 명의/ 부모통장 제출금지) * 해당자 추가서류국민기초생활수급자 증명서차상위계층 확인서'
    },
    {
      Col1: '재단법인 목포장학재단',
      Col2: '저소득장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학교 직전 학기 평균학점 2.0학점 이상신입생은 고등학교 3학년 2학기 성적 평균 70점 이상',
      Col10: '건강보험료 25만원 이내 납부 가정 자녀',
      Col11: '2000000원',
      Col12: '목포시 소재 고등학교 졸업 후 국내 소재 대학 재학생',
      Col13: '공고일 기준 부모님 및 본인 중 1명 이상이 목포시에 1년 이상 주소를 둔 자',
      Col14: '2022-08-18~2022-09-14',
      Col15: '해당없음',
      Col16: '25명',
      Col17: '부모의 직장 학자금지원 및 타 장학금으로 전액을 수혜받은 경우본인이 소득자(직장/ 사업자)인 경우(단/ 파트타임 제외)공무원 자녀이중/허위 수혜자 적발시 장학금 회수 및 3년간 장학금 지원 제외매학기 등록금 총액이 30만원 이하인 대학교 재학생',
      Col18: '해당없음',
      Col19: '목포장학재단 장학금 신청서신청인 서약서개인정보수집·이용 및 제공·조회 동의서통장사본건강보험료 납부확인서 부/모 각 1부건강보험자격확인서 부/모 각 1부가족관계증명서주민등록초본 또는 등본고등학교 졸업 증명서직전 학기 성적 증명서재학증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '(재)무안군승달장학회',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기(2022년 1학기) 평균 성적이 B학점 이상인 자 * 특정대학 B학점이 2.7 기준인 대학은 신청서 접수 시 유의바람',
      Col10: '해당없음',
      Col11: '1인당 1500000원',
      Col12: '대학에 입학하였거나 재학 중인 자',
      Col13: '공고일 현재 부모 모두 무안군에 주소를 두고 1년 이상 계속 거주하거나/ 부모 중 한 사람이 무안군에 주소를 두고 5년 이상 계속 거주한 군민의 자녀 * 보호자(부/ 모)가 사망한 경우 학생 본인의 주소 확인',
      Col14: '2022-08-18~2022-09-14',
      Col15: '성적 70%/ 재산 30% 권역별 고득점자 순으로 선발 (단/ 동점자 발생시 성적우수자 우선 선발)',
      Col16: 'OO명 * 첨부파일 참고',
      Col17: '1세대 1명 선발2021년도 하반기 또는 2022년도 상반기 승달장학금 수혜자 및 무안군에서 추천한 장학금 수혜자학생 보인이 소득자인 경우(파트타임 제외)방송통신대/ 사이버대학 등 원격대학 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '승달장학금 지원신청서개인정보 수집이용 및 제3자 제공·조회 동의서주민등록등·초본가족관계증명서건강보험료납부확인서(2022.1.~6.)건강보험자격확인(통보)서 또는 자격득실확인서지방세세목별과세증명서(2021.7.~2022.6.)등록금 납입증명서(2022년 2학기)성적증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)무안군승달장학회',
      Col2: '저소득장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기(2022년 1학기) 평균성적 D학점 이상',
      Col10: '국민기초생활수급권자 장애연금·장애수당 수급자 한부모가족 차상위 본인부담 경감대상자',
      Col11: '1인당 1500000원',
      Col12: '재학생·복학생',
      Col13: '공고일 현재 부모 모두 무안군에 주소를 두고 1년 이상 계속 거주하거나/ 부모 중 한 사람이 무안군에 주소를 두고 5년 이상 계속 거주한 군민의 자녀 * 보호자(부/ 모)가 사망한 경우 학생 본인의 주소 확인',
      Col14: '2022-08-18~2022-09-14',
      Col15: '성적 70%/ 재산 30% 권역별 고득점자 순으로 선발 (단/ 동점자 발생시 성적우수자 우선 선발)',
      Col16: ' * 첨부파일 참고*',
      Col17: '1세대 1명 선발2021년도 하반기 또는 2022년도 상반기 승달장학금 수혜자 및 무안군에서 추천한 장학금 수혜자학생 보인이 소득자인 경우(파트타임 제외)방송통신대/ 사이버대학 등 원격대학 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '승달장학금 지원신청서개인정보 수집이용 및 제3자 제공·조회 동의서주민등록등·초본(주소이력 포함)가족관계증명서건강보험료납부확인서(2022.1.~6.)건강보험료자격확인(통보)서 또는 자격득실확인서지방세세목별과세증명서(2021.7.~2022.6.)등록금 납입증명서(2022년 2학기)성적증명서저소득 증명서류 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)무안군승달장학회',
      Col2: '예체능장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 1500000원',
      Col12: '예체능(미술/ 음악/ 체육/ 기타) 분야에 소질과 재능이 뛰어난 자 중 도 단위이상 대회에서 입상한 자 (* 2019년 이후 전국대회 및 전남대회 3위 이내 입상자 또는는 이와 동등한 요건의 수상자)',
      Col13: '공고일 현재 부모 모두 무안군에 주소를 두고 1년 이상 계속 거주하거나/ 부모 중 한 사람이 무안군에 주소를 두고 5년 이상 계속 거주한 군민의 자녀 * 보호자(부/ 모)가 사망한 경우 학생 본인의 주소 확인',
      Col14: '2022-08-18~2022-09-14',
      Col15: '해당없음',
      Col16: ' * 첨부파일 참고*',
      Col17: '1세대 1명 선발2021년도 하반기 또는 2022년도 상반기 승달장학금 수혜자 및 무안군에서 추천한 장학금 수혜자학생 보인이 소득자인 경우(파트타임 제외)방송통신대/ 사이버대학 등 원격대학 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '승달장학금 지원신청서개인정보 수집이용 및 제3자 제공·조회 동의서주민등록등·초본(주소이력 포함)가족관계증명서건강보험료납부확인서(2022.1.~6.)건강보험료자격확인(통보)서 또는 자격득실확인서지방세세목별과세증명서(2021.7.~2022.6.)등록금 납입증명서(2022년 2학기)성적증명서특기자 실적 증명 서류 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)무안군승달장학회',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '부모 명의 가족관계증명서에 본인 포함 형제·자매 3명 이상',
      Col11: '1인당 1500000원',
      Col12: '대학교에 재학 중인 자로서 다자녀 가구(3자녀 이상)의 자녀 ',
      Col13: '공고일 현재 부모 모두 무안군에 주소를 두고 1년 이상 계속 거주하거나/ 부모 중 한 사람이 무안군에 주소를 두고 5년 이상 계속 거주한 군민의 자녀 * 보호자(부/ 모)가 사망한 경우 학생 본인의 주소 확인',
      Col14: '2021-10-11~2021-10-22',
      Col15: '자녀수 50%/ 생활정도 50% * 동점시 다자녀수/ 건강보험료 납부액(소득) 순으로 순위 결정',
      Col16: '10명',
      Col17: '지원분야에 상관없이 1세대에 1명만 선발 (신청서 제출은 제한없음) 방송통신대 및 사이버 대학에 재학중인 학생은 제외학생의 연령이 30세 이상인 자는 제외최근 1년간 수혜가정 제외',
      Col18: '해당없음',
      Col19: '승달장학금 지원신청서개인정보 수집이용 및 제3자 제공·조회 동의서주민등록등·초본(주소이력 포함)가족관계증명서건강보험료납부확인서(2022.1.~6.)건강보험료자격확인(통보)서 또는 자격득실확인서지방세세목별과세증명서(2021.7.~2022.6.)등록금 납입증명서(2022년 2학기) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)여수시인재육성장학회',
      Col2: '학업성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 직전학기 학업성적이 “총 평점평점 3.5/4.5',
      Col10: '해당없음',
      Col11: '1인당 최대 1500000원.',
      Col12: '여수지역 및 전국 2년제 이상 대학 재학생 중 성적요건 충족자',
      Col13: '공고일 현재 여수시에 6개월이상 주소를 둔 시민 또는 시민의 자녀여수지역 및 전국 전국 2년제 이상 대학 신입생 및 재학생',
      Col14: '2021-10-11~2021-10-22',
      Col15: '성적 80%/ 생활정도 20%',
      Col16: '30명',
      Col17: '본 장학회 직전학기 장학금 수혜자 제외',
      Col18: '해당없음',
      Col19: '장학금신청서정보제공동의서직전학기성적증명서재학증명서주민등록등본학자금지원 소득구간 산정표통장사본(본인 또는 보호자) 장애인 증명서(해당자)가족관계증명서(해당자) ※ 우편접수만 받으며/ 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '(재)여수시인재육성장학회',
      Col2: '특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국가장학금 소득분위 내에 한하여 접수가능',
      Col11: '1500000원',
      Col12: '여수지역 및 전국 2년제 이상 대학 신입생과 재학생. 품행이 단정하고 문화·예술·체육·과학·기능 분야에 소질과 재능이 뛰어난 자로서 도단위 이상 대회 및 경진대회에서 3위내 입상 또는 동등자격 취득자',
      Col13: '공고일 현재 여수시에 6개월이상 주소를 둔 시민 또는 시민의 자녀여수 지역 및 전국 2년제 이상 대학 신입생 및 재학생',
      Col14: '2021-10-11~2021-10-22',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '본 장학회 직전학기 장학금 수혜 받은자 제외',
      Col18: '해당없음',
      Col19: '장학금신청서정보제공동의서직전학기성적증명서재학증명서주민등록등본학자금지원 소득구간 산정표통장사본(본인 또는 보호자)입상경력증명 또는 수상실적증명서 (상장가능)출전자 명단 (단체전 입상자)장애인증명서(해당자)가족관계증명서(해당자) ※ 우편제출만 가능하며/ 자세한 사항은 첨부파일 및 홈페이지 참고'
    },
    {
      Col1: '(재)여수시인재육성장학회',
      Col2: '저소득자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '경제적 이유로 학업이 곤란한 자',
      Col13: '공고일 현재 여수시에 6개월이상 주소를 둔 시민 또는 시민의 자녀여수지역 및 전국 2년제 이상 대학 재학생',
      Col14: '2022-04-18~2022-05-13',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '본 장학회 직전학기 장학금 수혜자는 지원불가가',
      Col18: '해당없음',
      Col19: '장학금신청서정보제공동의서직전학기성적증명서재학증명서주민등록등본학자금지원 소득구간 산정표통장사본(본인 또는 보호자)장애인증명서(해당자)가족관계증명서(다자녀·다문화 해당자) ※ 서류제출만 가능하며/ 자세한 사항은 홈페이지 및 첨부파일 참고'
    },
    {
      Col1: '(재)영암군민장학회',
      Col2: '기능/문화예술/체육진흥장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '우수체육선수/예능학생 : 도교육청 또는 교육부 장관이 주최한 경시대회에서 최우수상(금상)수상자/ 도 대회이상(전라남도지사/전라남도교육감 이상)예체능(체육/ 음악/ 미술/ 문예 등)대회에서 3위 이내의 성적을 거둔 학생 * 자세한 사항은 첨부파일 참고',
      Col13: '부모 또는 본인이 대학 입학 당시 3년 이상 영암군에 주소를 두고 현재 거주하고 있는 자',
      Col14: '2022-04-18~2022-05-13',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '질병/ 입영/ 취업 등을 위해 휴학한 경우국가 또는 지방자치단체/ 공공단체 및 민간단체의 장학금/ 직장 학자금 등 타장학금을 받은 자는 제외함   (단/ 본 장학회 지급 기준액 이하를 받은 자는 이사회 의결에 의해 자격을 득할 수 있으며 차액을 지급함)이중허위 수혜자 적발 시 장학금 회수 및 장학금 지원 제외각 학교 교칙에 의하여 징계 전력이 있는 자는 지원 제외',
      Col18: '해당없음',
      Col19: '장학금 신청서개인정보 수집/ 이용 동의서신청인 서약서통장계좌 사본(장학금 입금계좌)학교장(총장)추천서주민등록 초본등록금 납입영수증 및 재학증명서고등학교 졸업증명서수상증서/ 자격증'
    },
    {
      Col1: '(재)영암군민장학회',
      Col2: '모범학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '사회봉사 활동 우수자/ 웃어른 공경 및 효행 실천자 등 모범학생',
      Col13: '관내 고등학교를 졸업하고 관내 대학교에 진학(재학)한 학생(학교별 2명)',
      Col14: '2022-04-18~2022-05-13',
      Col15: '선발 심사는 서류심사 원칙(분야별 심사요건/ 선정기준 등)으로 함지원대상자 선발은 (재)영암군민장학회 이사회 심의를 거쳐 최종 결정후 확정함',
      Col16: '2명 (학교별)',
      Col17: '질병/ 입영/ 취업 등을 위해 휴학한 경우국가 또는 지방자치단체/ 공공단체 및 민간단체의 장학금/ 직장 학자금 등 타장학금을 받은 자는 제외함   (단/ 본 장학회 지급 기준액 이하를 받은 자는 이사회 의결에 의해 자격을 득할 수 있으며 차액을 지급함)각 학교 교칙에 의하여 징계 전력이 있는 자는 지원 제외',
      Col18: '대학총장',
      Col19: '장학금 신청서개인정보 수집/ 이용 동의서신청인 서약서통장계좌 사본(장학금 입금계좌)학교장(총장) 추천서등록금 납입영수증 및 재학증명서고등학교 졸업증명서'
    },
    {
      Col1: '(재)영암군민장학회',
      Col2: '고향사랑장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 성적이 B+ 이상인 자',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '4년제 대학교 입학(재학)생',
      Col13: '영암 출신 향우자녀',
      Col14: '2021-09-27~2021-10-15',
      Col15: '해당없음',
      Col16: '7명',
      Col17: '질병/ 입영/ 취업 등을 위해 휴학한 경우국가 또는 지방자치단체/ 공공단체 및 민간단체의 장학금/ 직장 학자금 등 타장학금을 받은 자는 제외함   (단/ 본 장학회 지급 기준액 이하를 받은 자는 이사회 의결에 의해 자격을 득할 수 있으며 차액을 지급함)이중허위 수혜자 적발 시 장학금 회수 및 장학금 지원 제외각 학교 교칙에 의하여 징계 전력이 있는 자는 지원 제외',
      Col18: '향우회장',
      Col19: '장학금 신청서개인정보 수집/ 이용 동의서신청인 서약서통장계좌 사본(장학금 입금 계좌)향우회장 추천서가족관계증명서(해당 학생 기준)성적증명서등록금 납입영수증(장학금 내역 포함) 및 재학증명서'
    },
    {
      Col1: '재단법인 진도군인재육성장학회',
      Col2: '학업성적장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당 학기 성적이 평균 B학점 이상인 자단/ 서울대학교/ 연세대학교/ 고려대학교/ 포항공과대학교/ KAIST/ 이화여자대학교/ 성균관대학교에 재학중인 자는 해당 학기 성적이 평균 C+ 이상인 자',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '관내 중학교 및 고등학교 졸업자로서 해당 학기 성적 우수자',
      Col13: '장학생 신청 및 추천일 현재 진도군에 주민 등록을 두고 있는 군민 또는 그 자녀',
      Col14: '2021-09-27~2021-10-15',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2021년도 상반기 입학성적 장학금 수혜자 또는 전남인재육성장학금 상반기 수혜자 제외',
      Col18: '해당없음',
      Col19: '인재육성장학금 신청서주민등록등본재학증명서직전학기 성적증명서개인정보 수집·이용 및 제공·조회 동의서장학금 지급 통장 사본대학수학능력시험 성적증명서중학교 또는 고등학교 졸업증명서등록금 납입 영수증 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 진도군인재육성장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '문화·예술·체육·과학기술 분야 둥에 뛰어난 관내 대학생으로 시/군 이상의 자치단체나 기관에서 주관한 국제대회/ 전국대회/ 전라남도 대회(도단위 기관)에서 3위 이내의 성적을 거둔 학생 또는 각급 학교의 특기자 전형에서 선발된 자  * 수상실적인정기간 : 2020학년도 1학기부터 2021학년도 1학기',
      Col13: '장학생 신청 및 추천일 현재 진도군에 주민 등록을 두고 있는 군민 또는 그 자녀녀',
      Col14: '2022-03-17~2022-03-31',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2021년도 상반기 입학성적 장학금 수혜자 또는 전남인재육성장학금 상반기 수혜자 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '인재육성장학금 신청서주민등록등본재학증명서직전학기 성적증명서개인정보 수집·이용 및 제공·조회 동의서장학금 지급 통장 사본대학수학능력시험 성적증명서중학교 또는 고등학교 졸업증명서등록금 납입 영수증 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 진도군인재육성장학회',
      Col2: '입학성적장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '해당없음',
      Col13: '장학생 신청 및 추천일 현재 진도군에 주민등록을 두고 있는 군민 또는 그 자녀관내 중학교 또는 고등학교 출신',
      Col14: '2022-03-17~2022-03-31',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '명문고장학생/ 전남인재장학생/ 복지장학생 수혜자 제외',
      Col18: '해당없음',
      Col19: '장학생 신청서정보제공동의서재학증명서주민등록등본통장계좌 사본(제출한 등본으로 확인가능한 부모명의 통장)가족관계증명서(해당자)등록금 납입영수증고등학교 3학년 성적증명서대학수학능력시험성적 증명서(정시 해당자)대학 합격증명서(해당자) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 진도군인재육성장학회',
      Col2: '보배사랑장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '한부모 가정/조손·위탁 가정 / 다문화 및 새터민 가정 / 장애 가정 / 저소득 가정 / 다자녀 가정 / 소년 소녀 가장',
      Col11: '해당없음',
      Col12: ' * 진도군에 3년 이상 거주한 대학교 재학생으로/ 아래 하나 이상 해당자한부모 가정조손 위탁 가정다문화 및 새터민 가정장애 가정 저소득 가정다자녀 가정소년 소녀 가장위탁가정 * 자세한 조건은 첨부파일 확인 바람',
      Col13: '공고일 현재 진도군에 3년이상 주소를 두고 있으며 관내 중·고등학교를 졸업하고 관내 대학에 입학한 자',
      Col14: '2022-09-01~2022-09-30',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '22년도 상반기 입학성적 장학금 수혜자전남인재육성장학금 상반기 수혜자 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '인재육성장학금 신청서주민등록등본재학증명서직전학기 성적증명서개인정보 수집·이용 및 제공·조회 동의서장학금 지급 통장 사본경제상황 증빙서류(해당 택1) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 상주시장학회',
      Col2: '나래장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 총평점이 B+ 학점(3.5) 이상인 자 * 4.5 만점 3.5 이상/ 4.3 만점 3.3 이상',
      Col10: '해당없음',
      Col11: '2000000원 * 생활장학금',
      Col12: '대학(2년제 이상)에 재학 중인 자',
      Col13: '장학생 선발 공고일 현재 1년이상 상주시 관내 거주자(부모 또는 학생)',
      Col14: '2022-09-01~2022-09-30',
      Col15: '성적이 높은 순으로 선발동점자의 경우 : 타 장학금 수령액이 적은자 > 고학년 순 선발',
      Col16: '55명 * 다자녀(3인) 5명 포함',
      Col17: '방송대/ 통신대/ 방송통신대/ 사이버대학 재학생 제외 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학금(비)수혜확인서재학증명서성적증명서주민등록등본(주소지 변동 포함)가족관계증명서(다자녀가구 또는 보호자와 주소지가 다른 경우) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 상주시장학회',
      Col2: '희망장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 총평점이 B0학점 이상인 자',
      Col10: '가정형편이 어려운(국민기초생활대상자 차상위 계층 또는 한부모가족) 학생',
      Col11: '2000000원 * 생활장학금',
      Col12: '대학(2년제 이상)에 재학 중인 자',
      Col13: '장학생 선발 공고일 현재 1년이상 상주시 관내 거주자(부모 또는 학생)',
      Col14: '2022-03-21~2022-04-15',
      Col15: '직전학기 성적(백분위환산점수)이 높은 순으로 선발',
      Col16: '10명',
      Col17: '방송대/ 통신대/ 방송통신대/ 사이버대학 재학생 제외 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학생 지원신청서개인정보제공·이용 동의서재학증명서성적증명서주민등록등본(주소지 변동 포함)가족관계증명서(보호자와 주소지가 다를 경우)기타 해당 증빙 서류* 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 영주시인재육성장학회',
      Col2: '신입장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2022학년도 수능 4개 영역의 표준점수 총합이 500점 이상고등학교 3학년 1학기 내신 또는 검정고시 성적이 1~3등급을 취득한 자',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '해당없음',
      Col13: '영주시 관내 고등학교 출신 대학생공고일 현재 부모가 주민등록상 영주시에 1년 이상 거주하고 있는 자 또는 본인이 고등학교 재학 기간 동안 주민등록상 영주시에 1년 이상 거주한 자',
      Col14: '2022-03-21~2022-04-15',
      Col15: ' * 인원 초과 시 대학신입장학생 선발 방법에 의한 선발',
      Col16: '대학생 20명',
      Col17: '등록금 범위이상(이중수혜자) 장학금을 받는 자등록금이 연간 100만원 미만의 대학교 재학생신청일 현재 휴학생 및 당해연도 1학기 휴학예정자 등록금 4년간 전액면제 학생만 30세 이상영주시 인재육성 장학금 2회 초과 수혜자 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '해당없음',
      Col19: '대학교 장학생 추천서고등학교 졸업증명서대학입학증명서 또는 대학재학증명서건강보험료 납부확인서 (부/모/본인)건강보험 자격확인서 (부/모/ 본인)주민등록등본가족관계증명서(부모기준으로 발급)서약서재능기부 참여 확약서개인정보제공 및 수집 동의서타 장학금 수혜확인서장학금 신청 관련 확약서등록금 납부 확인서타 장학금 수혜확인서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 영주시인재육성장학회',
      Col2: '우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 직전 1개학기(학기 15학점 이상 이수/ 계절학기 제외/ 평균평점 4.5점 만점 기준)의 성적이 다음 각 호에 해당되는 자대학교 : 3.6점 이상전문대학교 : 3.8점 이상 * 자세한 사항은 첨부자료 확인 필수',
      Col10: '해당없음',
      Col11: '전문대 : 2000000원대학교 : 3000000원',
      Col12: '해당없음',
      Col13: '영주시 관내 고등학교 및 검정고시 출신 대학생신청일 현재 부모가 주민등록상 영주시에 1년 이상 거주하고 있는 자 본인이 고등학교 재학 기간 동안 주민등록상 영주시에 1년 이상 거주한 자',
      Col14: '2022-03-21~2022-04-15',
      Col15: '해당없음',
      Col16: '32명(전문대 12명/ 대학교 20명)',
      Col17: '등록금 범위이상(이중수혜자) 장학금을 받는 자등록금이 연간 100만원 미만의 대학교 재학생신청일 현재 휴학생 및 당해연도 1학기 휴학예정자 등록금 4년간 전액면제 학생만 30세 이상영주시 인재육성장학금 2회 수혜자 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '해당없음',
      Col19: '대학교 장학생 추천서주민등록초본 또는 등본가족관계증명서검정고시 합격증명서(해당자)대학입학증명서 또는 재학증명서건강보험료 납부확인서대학등록금 납부확인서서약서타 장학금 (비)수혜확인서 * 자세한 내용은 첨부자료 참고'
    },
    {
      Col1: '재단법인 영주시인재육성장학회',
      Col2: '지역대학우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전 1개학기(15학점 이상 이수/ 계절학기 제외/ 평점 4.5점 만점 기준)이 다음 각 호에 해당되는 자 * 대학교 : 3.6점 이상 * 전문대학교 : 3.8점 이상',
      Col10: '해당없음',
      Col11: '경북전문대 : 2000000원동양대 : 3000000원',
      Col12: '경북전문대학교 또는 한국폴리텍대학교 또는 동양대학교 재학하는 학생',
      Col13: '영주시 관내 고등학교 출신 대학생신청일 현재 부모가 주민등록상 영주시에 1년 이상 거주하고 있는 자 (보호자 없을 시 본인이 고등학교 재학기간동안 주민등록상 영주시에 1년이상 거주한 자) ',
      Col14: '2022-03-21~2022-04-15',
      Col15: '해당없음',
      Col16: '5명경북전문대: 2명동양대: 3명',
      Col17: '등록금 범위이상(이중수혜자) 장학금을 받는 자등록금이 연간 100만원 미만의 대학교 재학생신청일 현재 휴학생 및 당해연도 1학기 휴학예정자 등록금 4년간 전액면제 학생만 30세 이상영주시 인재육성장학금 2회 수혜자 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '대학총장추천',
      Col19: '고등학교 졸업증명서대학총장 장학생 추천서대학재학증명서성적증명서(직전 1개학기)주민등록등본서약서개인정보제공 및 수집 동의서타 장학금 수혜확인서장학금 신청관련 확약서등록금 납부확인서(납부액 표기)장학금 수혜확인서(소속학교 발급)'
    },
    {
      Col1: '재단법인 영주시인재육성장학회',
      Col2: '저소득장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '직전 1개 학기(15학점 이상 이수/ 계절학기 제외) 4.5만점 기준 (전문대학교 3.2학점/ 대학교 3.0학점)이상인 자',
      Col10: '기초생활수급자차상위계층 자녀생계 또는 의료 급여 수급자',
      Col11: '전문대 : 2000000원대학교 : 3000000원',
      Col12: '해당없음',
      Col13: '영주시 관내 고등학교 출신 대학생신청일 현재 부모가 주민등록상 영주시에 1년 이상 거주하고 있는 자 (보호자 없을 시 본인이 고등학교 재학기간동안 주민등록상 영주시에 1년이상 거주한 자) ',
      Col14: '2022-03-21~2022-04-15',
      Col15: '해당없음',
      Col16: '10명전문대 4명/ 대학교 6명',
      Col17: '등록금 범위이상(이중수혜자) 장학금을 받는 자등록금이 연간 100만원 미만의 대학교 재학생신청일 현재 휴학생 및 당해연도 1학기 휴학예정자 등록금 4년간 전액면제 학생만 30세 이상영주시 인재육성장학금 2회 수혜자 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '해당없음',
      Col19: '고등학교 졸업증명서대학총장 장학생 추천서저소득및 특기 장학생 지원신청서대학재학증명서성적증명서(직전 1개학기)건강보험료 납부확인서 및 자격확인서 (부/모/ 본인)주민등록등본가족관계증명서 (부모기준으로 발급)서약서재능기부참여 확약서개인정보 제공 및 수집 동의서타 장학금 수혜확인서장학금 신청 관련 확약서등록금 납부확인서(납부액 표기)장학금 수혜확인서(소속학교 발급) *자세한 사항은 첨부자료 확인 필수'
    },
    {
      Col1: '재단법인 영주시인재육성장학회',
      Col2: '지역대학재학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(한국폴리텍대학)신입생 : 입학성적의 10%이내재학생 : 직전 1개 학기(15학점 이상 이수) 평균 평점 4.5만점 기준 3.0학점 이상',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '영주시에 주소를 둔 학생경북전문대학교/ 동양대학교/ 한국폴리텍Ⅳ대학 재학 중인 학생',
      Col13: '영주시 관내 고등학교 출신 대학생신청일 현재 부모가 주민등록상 영주시에 1년 이상 거주하고 있는 자 (보호자 없을 시 본인이 고등학교 재학기간동안 주민등록상 영주시에 1년이상 거주한 자) ',
      Col14: '2022-03-21~2022-04-15',
      Col15: '해당없음',
      Col16: '44명경북전문대 : 27명동양대 : 19명한국폴리텍VI : 5명',
      Col17: '등록금 범위이상(이중수혜자) 장학금을 받는 자등록금이 연간 100만원 미만의 대학교 재학생신청일 현재 휴학생 및 당해연도 1학기 휴학예정자 등록금 4년간 전액면제 학생만 30세 이상영주시 인재육성장학금 2회 수혜자 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '대학총장의 추천',
      Col19: '대학총장 장학생 추천서대학재학증명서성적증명서(직전 1개학기)주민등록등본서약서개인정보제공 및 수집 동의서타 장학금 수혜확인서장학금 신청관련 확약서등록금 납부확인서(납부액 표기)장학금 수혜확인서  * 자세한 내용은 첨부파일 확인 바람'
    },
    {
      Col1: '재단법인 영주시인재육성장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '예체능계열',
      Col9: '직전 1개 학기 (15학점 이상 이수/ 계절학기 제외) 4.5만점기준 3.0학점 이상',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '예체능 등을 전공한 대학교 재학생',
      Col13: '영주시 관내 고등학교 출신 대학생신청일 현재 부모가 주민등록상 영주시에 1년 이상 거주하고 있는 자 (보호자 없을 시 본인이 고등학교 재학기간동안 주민등록상 영주시에 1년이상 거주한 자) ',
      Col14: '2022-03-21~2022-04-15',
      Col15: '해당없음',
      Col16: '7명',
      Col17: '등록금 범위이상(이중수혜자) 장학금을 받는 자등록금이 연간 100만원 미만의 대학교 재학생신청일 현재 휴학생 및 당해연도 1학기 휴학예정자 등록금 4년간 전액면제 학생만 30세 이상영주시 인재육성장학금 2회 수혜자 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '해당없음',
      Col19: '고등학교 졸업증명서대학총장 장학생 추천서저소득 및 특기장학생 지원신청서대학재학증명서성적증명서(직전1개학기)건강보험료 납부확인서 / 자격확인서주민등록등본가족관계증명서(부모기준으로 발급)서약서개인정보제공 및 수집동의서타 장학금 수혜확인서장학금 신청관련 확약서등록금 납부확인서(납부액 표기)장학금수혜확인서(소속학교발급) * 자세한 내용은 첨부파일 확인 바람'
    },
    {
      Col1: '재단법인 영주시인재육성장학회',
      Col2: '지역대학신입장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '관내 고등학교를 졸업한 학생 중 2021년도 동양대학교와 경북전문대학교에 입학한 학생  ',
      Col13: '영주시 관내 고등학교 출신 대학생신청일 현재 부모가 주민등록상 영주시에 1년 이상 거주하고 있는 자 (보호자 없을 시 본인이 고등학교 재학기간동안 주민등록상 영주시에 1년이상 거주한 자) ',
      Col14: '2021-10-05~2021-10-29(',
      Col15: '해당없음',
      Col16: '54명  * 경북전문대 : 27명  * 동양대 : 27명',
      Col17: '등록금 범위이상(이중수혜자) 장학금을 받는 자등록금이 연간 100만원 미만의 대학교 재학생신청일 현재 휴학생 및 당해연도 1학기 휴학예정자 등록금 4년간 전액면제 학생만 30세 이상영주시 인재육성장학금 2회 수혜자 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '출신 고등학교장의 추천',
      Col19: '출신고등학교장 장학생 추천서고등학교 졸업증명서대학입학증명서 또는 대학재학증명서주민등록등본서약서개인정보제공 및 수집 동의서등록금납부 확인서(납부액표기) * 자세한 내용은 첨부파일 확인 바람'
    },
    {
      Col1: '경상북도 영주시청',
      Col2: '학자금대출 이자지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2018년 하반기부터 한국장학재단에서 대출받은(2021.10.29까지) 학자금의 2021년 상반기부터 2021년 하반기 발생이자',
      Col12: '한국장학재단에서 대출받은 자시 소재 고등교육기관에 다니면서 시에 주민등록을 두고 있는 대(휴)학생',
      Col13: '공고일 현재 본인 또는 직계존속이 영주시에 주민등록주소를 둔 대(휴)학생',
      Col14: '2021-10-04~2021-11-19',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '졸업생과 대학원생은 제외',
      Col18: '해당없음',
      Col19: '영주시 대학생 학자금대출 이자지원 신청서 1부개인정보 수집 이용 및 제공 동의서 작성주민등록본 본인의 주소지가 영주시인 경우 본인의 등본 제출부모의 주소지가 영주시인 경우 부모의 등본 제출재학 증명서가족관계증명서 * 구비서류는 2020년 10월 05일 이후 발급된 것을 인정함 * 자세한 사항은 첨부파일 또는 홈페이지 참고'
    },
    {
      Col1: '재단법인 안동시장학회',
      Col2: '대학생 학자금 이자 지원',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한국장학재단을 통해 2017년 1학기 이후 대출받은 학자금의 2021.1.1부터 12.31.까지 발생하는 이자',
      Col12: '한국장학재단을 통해 학자금 대출을 받은 대학생 ',
      Col13: '공고일 직전년도부터 신청일 현재까지 안동시에 주민등록이 되어 있는 국내 대학생',
      Col14: '2022-04-11~2022-04-22',
      Col15: '안동시청 온라인 신청',
      Col16: '해당없음',
      Col17: '타 기관과의 중복지원 불가대학 졸업(수료)자/ 제적자/ 대출금 전액 상환자/ 외국인 제외휴학생은 최대 6학기까지 지원',
      Col18: '해당없음',
      Col19: '대학교 재(휴)학 증명서신청자 주민등록초본(주소변동 2년 포함)'
    },
    {
      Col1: '재단법인 구미시장학재단',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 중 직전 2개 학기(연간 30학점 이상/ 계절학기 제외) 평균학점 4.0이상(4.5기준)',
      Col10: '해당없음',
      Col11: '2000000원 이내',
      Col12: '국내 4년제 대학 성적 우수자',
      Col13: '장학금은 공고일 현재(2022.3.21) 본인 또는 그 보호자가 구미시에 1년 이상 주소를 두고 있는 시민의 자녀 중 관내 고등학교를 졸업한 대학생 (고졸학력 검정고시 합격자 포함)',
      Col14: '2022-04-11~2022-04-22',
      Col15: '(재)구미시 장학재단 장학위원회 심사 선발학업 70점 + 생활정도 30점 (동점일 경우 학업우수자 선발)',
      Col16: '45명',
      Col17: '1인당 1종류의 장학금 신청만 가능 육군/해군/공군사관학교/ 경찰대학교 등 학비 또는 생활비가 국비로 지원되는 (대)학교 신입/재학생 제외타기관 등에서 장학생에 선발된 경우 제외',
      Col18: '해당없음',
      Col19: '장학금 지원서개인정보 제공및 수집이용 동의서신청인 서약서장학금 수혜(비수혜) 확인서재학증명서대학교 성적증명서(직전 2개학기)관내 고등학교 졸업증명서교육비(등록금) 납입증명서고등학교 졸업학력 검정고시 합격증명서(해당자)주민등록등본(보호자의 구미 거주이력 필요/ 5년간 주소변동 사항 포함)수능성적통지서(신입생)건강보험료 납부확인서 (부/모 건강보험료 합산/ 각각 1장씩 제출) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고고'
    },
    {
      Col1: '재단법인 구미시장학재단',
      Col2: '기회균등장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 2개 학기 성적평점 평균이 3.0이상인 자(30학점 이상 이수/ 계절학기 제외)',
      Col10: '1순위 : 국민기초생활보장 수급자2순위 : 차상위 계층 수급자',
      Col11: '2000000원 (학업장려금 지급 중복지원 가능)',
      Col12: '국내 4년제 대학교 2~4학년 재학생',
      Col13: '장학금은 공고일 현재(2022. 3. 21) 본인 또는 그 보호자가 구미시에 1년 이상 주소를 두고 있는 시민의 자녀 중 관내 고등학교를 졸업한 대학생 (고졸학력 검정고시 합격자 포함)',
      Col14: '2022-04-11~2022-04-22',
      Col15: '(재)구미시 장학재단 장학위원회 심사 선발선발인원을 초과할 경우 학업우수자 우선 선발',
      Col16: '10명',
      Col17: '1인당 1종류의 장학금 신청만 가능 육군/해군/공군사관학교/ 경찰대학교 등 학비 또는 생활비가 국비로 지원되는 (대)학교 신입/재학생 제외타기관 등에서 장학생에 선발된 경우 제외',
      Col18: '해당없음',
      Col19: '장학금 지원신청서개인정보 제공 및 수집 동의서재학증명서대학교 성적증명서(직전 2개학기)관내 고등학교 졸업증명서고등학교 졸업학력 검정고시 합격증명서(해당자)주민등록등본(보호자의 구미 거주이력필요/ 5년간 주소변동 사항 포함)수능성적통지서(신입생)국민기초생활 및 차상위계층 증명서  * 자세항 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 구미시장학재단',
      Col2: '대학교예체능특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '2022년도 국내 4년제 대학교 신입생예체능 전국단위 이상 대회 3위 이상 개인 입상자 * 입상실적은 고등학교 재학중 실적만 인정 ',
      Col13: '장학금은 공고일 현재(2022. 3. 21) 본인 또는 그 보호자가 구미시에 1년 이상 주소를 두고 있는 시민의 자녀 중 관내 고등학교를 졸업한 대학생 (고졸학력 검정고시 합격자 포함)',
      Col14: '2022-03-28~2022-04-15',
      Col15: '(재)구미시 장학재단 장학위원회 심사 선발상위대회 입상자 우선(공공기관>해당단체>기타)동률일 경우 대회규모 및 입상횟수 등 고려하려 선발',
      Col16: '5명',
      Col17: '1인당 1종류의 장학금 신청만 가능 육군/해군/공군사관학교/ 경찰대학교 등 학비 또는 생활비가 국비로 지원되는 (대)학교 신입/재학생 제외타기관 등에서 장학생에 선발된 경우 제외',
      Col18: '해당없음',
      Col19: '장학금 지원신청서개인정보 제공 및 수집 동의서재학증명서관내 고등학교 졸업증명서고등학교 졸업학력 검정고시 합격증명서(해당자)주민등록등본(보호자의 구미 거주이력필요/ 5년간 주소변동 사항 포함)예체능 전국단위(대회)입상 실적증명서 * 자세항 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '김천시인재양성재단',
      Col2: '진학우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '서울대/연·고대/카이스트/포스텍 및 의학계열 입학생 또는 대학수학능력시험 국수탐 개인 표준점수 390점 이상',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '관내(관외) 고등학교를 졸업한 대학생으로서 학업성적이 우수한 자 ※ 김천혁신도시 이전공공기관 임직원(자녀)의 경우 거주기간 상관없이 장학금 수혜대상자 및 보호자가 김천시 관내에 주민등록이 되있는 자',
      Col13: '수혜대상자 및 보호자가 공고일 현재 1년 이상 김천시에 주소를 둔 자관내(관외) 고등학교를 졸업한 대학생으로서 학업성적이 우수한 자',
      Col14: '2022-03-28~2022-04-15',
      Col15: '재단 선발',
      Col16: '15명',
      Col17: '장학금 수혜 연도에 국가 또는 기타기관 및 민간단체로부터 본 인재양성재단에서 지급하는 장학금의 200%이상을 받는 자는 제외등록금 4년간 전액면제 학생금고이상의 형을 받은 사실이 있는 자공고일 현재 휴학생',
      Col18: '대학총장이 추천한 자',
      Col19: '장학생 신청서장학생 추천서장학금 비수혜확인서개인정보 제공·이용 동의서주민등록등본(주소변동 포함)재학증명서고교 졸업증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '김천시인재양성재단',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '우수대학 재학생중 직전년도 2개학기(각 학기 15학점 이상 이수/ 계절학기 제외) 평균평점이 B+ (3.5)이상인 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '지역요건을 충족하며 성적이 우수한 재학생※ 김천혁신도시 이전공공기관 임직원(자녀)의 경우 거주기간 상관없이 장학금 수혜대상자 및 보호자가 김천시 관내에 주민등록이 되있는 자',
      Col13: '수혜대상자 및 보호자가 공고일 현재 1년 이상 김천시에 주소를 둔 자관내(관외) 고등학교를 졸업한 대학생으로서 학업성적이 우수한 자',
      Col14: '2022-03-28~2022-04-15',
      Col15: '재단 선발',
      Col16: '95명(지역대학육성 장학생 포함 35명)',
      Col17: '장학금 수혜 연도에 국가 또는 기타기관 및 민간단체로부터 본 인재양성재단에서 지급하는 장학금의 200%이상을 받는 자는 제외등록금 4년간 전액면제 학생금고이상의 형을 받은 사실이 있는 자공고일 현재 휴학생신입생 제외',
      Col18: '대학교 총장 추천',
      Col19: '장학생 신청서장학생 추천서장학금 비수혜확인서개인정보 제공·이용 동의서주민등록등본(주소변동 포함)재학증명서고교 졸업증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '김천시인재양성재단',
      Col2: '특기장학',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '예체능계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '대학 재학생으로서 2020년도 예체능분야야 전국단위이상 기관 및 단체에서 주최한 대회 입상자로 대학총장이 추천한 자※ 김천혁신도시 이전공공기관 임직원(자녀)의 경우 거주기간 상관없이 장학금 수혜대상자 및 보호자가 김천시 관내에 주민등록이 되있는 자',
      Col13: '수혜대상자 및 보호자가 공고일 현재 1년 이상 김천시에 주소를 둔 자',
      Col14: '2022-03-28~2022-0415',
      Col15: '재단 선발',
      Col16: '20명 (중/고/대학생 포함)',
      Col17: '장학금 수혜 연도에 국가 또는 기타기관 및 민간단체로부터 본 인재양성재단에서 지급하는 장학금의 200%이상을 받는 자는 제외등록금 4년간 전액면제 학생금고이상의 형을 받은 사실이 있는 자공고일 현재 휴학생',
      Col18: '대학교 총장 추천',
      Col19: '장학생 신청서장학생 추천서장학금 비수혜확인서개인정보 제공·이용 동의서주민등록등본(주소변동 포함)재학증명서고교 졸업증명서예·체능 특기실적증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '김천시인재양성재단',
      Col2: '행복나눔장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '학업성적이 우수한 자',
      Col10: '국민기초생활보장 생계 의료 주거 교육급여수급자 차상위계층 기타 일반세대의 자녀',
      Col11: '2000000원',
      Col12: '학업성적이 우수하고 품행이 올바른 대학생으로 읍면동장이 추천한 자 ※ 김천혁신도시 이전공공기관 임직원(자녀)의 경우 거주기간 상관없이 장학금 수혜대상자 및 보호자가 김천시 관내에 주민등록이 되있는 자',
      Col13: '수혜대상자 및 보호자가 공고일 현재 1년 이상 김천시에 주소를 둔 자관내(관외) 고등학교를 졸업한 대학생으로서 학업성적이 우수한 자',
      Col14: '2022-02-14~2022-03-04',
      Col15: '학업성적 50% + 생활정도 50% ',
      Col16: '25명',
      Col17: '해당없음',
      Col18: '읍면동장 추천',
      Col19: '장학생 신청서장학생 추천서장학금 비수혜확인서개인정보 제공/이용 동의서주민등록등본(주소변동 포함)재학증명서 고교졸업증명서행복나눔장학생 실태조사표  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 양산시인재육성장학재단',
      Col2: '양산사랑우수대학진학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '부모 모두의 건강보험료 합산금액이 520만원 미만인 학생',
      Col11: '매학기별 1인 2000000원(4년간)',
      Col12: '2022학년도에 서울대학교/ 연세대학교/ 고려대학교/ 포항공대/ 카이스트/ 각 대학교 의대/치대/한의대/ 부산대학교/ 이화여자대학교에 합격하여 등록을 한 학생 (지방캠퍼스 제외)',
      Col13: ' 학부모와 학생이 5년 이상 양산시에 주소가 되어 있고/ 2021년 초에 관내 고등학교 졸업예정자 또는 졸업자',
      Col14: '2022-02-14~2022-03-04',
      Col15: '양산사랑장학생으로서 장학재단이 인정하는 우수대학교 진학자 전원 추천',
      Col16: '50명 이내',
      Col17: '해당없음',
      Col18: '해당 고등학교장',
      Col19: '* 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.장학금신청서 1부장학금지급 신청서 1부장학금 서약서 1부고등학교장(대학총장) 추천서 1부고등학교 졸업증명서 및 대학합격 증서 각1부등록금납입증명서등 1부저소득가정 대학교 진학생의 경우 기초생활수급자 증빙서 1부주민등록등본/ 초본 각 1부모 모두의 건강보험료 납입증명서 (2019년도 12개월분)개인정보 수집/이용 및 미성년자 법정대리인 동의서'
    },
    {
      Col1: '재단법인 양산시인재육성장학재단',
      Col2: '우수대학교진학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '부모 모두의 건강보험료 합산금액이 520만원 미만인 학생생',
      Col11: '1인 2000000원',
      Col12: '2022학년도에 서울대학교/ 연세대학교/ 고려대학교/ 포항공대/ 카이스트/ 각대학교 치/의대/ 한의대에 합격하여 등록을 한 학생 (단/ 지방 캠퍼스 제외)',
      Col13: '학부모와 학생이 3년 이상 양산시에 주소가 되어 있고/ 2022년 2월에 관내 고등학교 졸업예정자 또는 졸업자',
      Col14: '2022-02-03~2022-03-08',
      Col15: '해당없음',
      Col16: '30명이내',
      Col17: '해당없음',
      Col18: '해당 고등학교장',
      Col19: '* 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.장학금신청서 1부장학금지급 신청서 1부장학금 서약서 1부고등학교장(대학총장) 추천서 1부고등학교 졸업증명서 및 대학합격 증서 각1부등록금납입증명서등 1부저소득가정 대학교 진학생의 경우 기초생활수급자 증빙서 1부주민등록초본(주소변동이력 1년이상 포함된 초본)주민등록등본(주소변동이력 1년이상 포함된 등본)부모 모두의 건강보험료 납입증명서(2020년도 12개월분)개인정보 수집 이용 및 미성년자 법정대리인 동의서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 양산시인재육성장학재단',
      Col2: '지역대학진학우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인 1000000원',
      Col12: '양산시 소재 2개 대학진학 신입생중 성적우수자 (동원과학기술대학교/ 영산대학교) ',
      Col13: '학부모와 학생이 3년 이상 양산시에 주소가 되어 있고/ 2019년 2월에 관내 고등학교 졸업예정자 또는 졸업자',
      Col14: '2022-02-03~2022-03-08',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당 대학 총장 ',
      Col19: '* 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.장학금신청서 1부장학금지급 신청서 1부장학금 서약서 1부고등학교장(대학총장) 추천서 1부고등학교 졸업증명서 및 대학합격 증서 각1부등록금납입증명서등 1부저소득가정 대학교 진학생의 경우 기초생활수급자 증빙서 1부주민등록초본(주소변동이력 1년이상 포함된 초본)주민등록등본(주소변동이력 1년이상 포함된 등본)부모 모두의 건강보험료 납입증명서(2020년도 12개월분)개인정보 수집 이용 및 미성년자 법정대리인 동의서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 양산시인재육성장학재단',
      Col2: '푸른꿈대학교진학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '기초생활수급자',
      Col11: '입학시 1인당 1000000원',
      Col12: '4년제 대학 진학자',
      Col13: '학부모와 학생이 3년 이상 양산시에 주소가 되어 있고/ 2021년 초에 관내 고등학교 졸업예정자 또는 졸업자',
      Col14: '2022-03-02~2022-03-24',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당 고등학교장',
      Col19: '* 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.장학금신청서 1부장학금지급 신청서 1부장학금 서약서 1부고등학교장(대학총장) 추천서 1부고등학교 졸업증명서 및 대학합격 증서 각1부등록금납입증명서등 1부저소득가정 대학교 진학생의 경우 기초생활수급자 증빙서 1부주민등록초본(주소변동이력 1년이상 포함된 초본)주민등록등본(주소변동이력 1년이상 포함된 등본)개인정보 수집 이용 및 미성년자 법정대리인 동의서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '창녕군인재육성장학재단',
      Col2: '우수대학(일반대학)진학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대입 수능성적 4개 영역(국어/ 수학/ 영어/ 탐구영역) 중 3개 영역이 평균 3등급 이내인 학생고등학교 3학년 내신성적 4개 영역(국어/ 수학/ 영어/ 탐구영역) 중 3개 영역이 평균 4등급 이내인 학생 * (단/ 탐구영역 반영시 2과목 등급을 평균하여 적용) ※ 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '1인당 3000000원',
      Col12: '관내 고등학교를 졸업한 2022학년도 입학생',
      Col13: '학부모와 학생이 당해 연도 공고일로부터 계속해서 창녕군내 1년 이상 주소를 두고 사실상 거주하는 자',
      Col14: '2022-03-02~2022-03-24',
      Col15: '해당없음',
      Col16: '일반대학 및 입학사정관제(수시)진학생 80명',
      Col17: '해당없음',
      Col18: '출신 학교장 추천',
      Col19: '장학금 지급 신청서개인정보 수집·이용 동의서학교장 추천서주민등록초본(주소변동이력포함)장학금 수납통장(보호자 또는 학생)대학수학능력시험 통지표 사본대학재학증명서  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '창녕군인재육성장학재단',
      Col2: '입학사정관제(수시)진학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대입 수능성적 4개 영역(국어/ 수학/ 영어/ 탐구영역) 중 3개 영역이 평균 3등급 이내인 학생고등학교 3학년 내신성적 4개 영역(국어/ 수학/ 영어/ 탐구영역) 중 3개 영역이 평균 4등급 이내인 학생 * (단/ 탐구영역 반영시 2과목 등급을 평균하여 적용) ※ 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '관내 고등학교를 졸업한 2022학년도 입학생',
      Col13: '학부모와 학생이 당해 연도 공고일로부터 계속해서 창녕군내 1년 이상 주소를 두고 사실상 거주하는 자',
      Col14: '2022-03-02~2022-03-24',
      Col15: '해당없음',
      Col16: '일반대학 및 입학사정관제(수시)진학생 80명',
      Col17: '해당없음',
      Col18: '출신 학교장의 추천',
      Col19: '장학금 지급 신청서개인정보 수집·이용 동의서학교장 추천서주민등록초본(주소변동이력포함)장학금 수납통장(보호자 또는 학생)대학수학능력시험 통지표 사본대학재학증명서3학년 1학기 내신성적증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '창녕군인재육성장학재단',
      Col2: '저소득가정장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '관내 고등학교 졸업자자 중 대학진학생으로서 가정형편으로 인하여 학업수행이 어려운 자 * 소년/소녀가정 국민기초생활보장수급자 한부모가정 학생 선발',
      Col11: '1인당 2000000원',
      Col12: '저소득가정장학생 : 당해 연도 졸업생 중 대학진학생으로서 가정형편으로 인하여 학업수행이 어려운 자',
      Col13: ' 학부모와 학생이 당해 연도 공고일로부터 계속해서 창녕군내 1년 이상 주소를 두고 사실상 거주하는 자',
      Col14: '2021-12-24~2022-01-21',
      Col15: '지원자는 장학금 지급신청사와 구비서류를 첨부하여 학교장에게 제출학교장은 추천서를 첨부하여 창년군인재육성장학재단에 신청',
      Col16: '20명',
      Col17: '해당없음',
      Col18: '학교장 추천',
      Col19: '장학금 지급 신청서개인정보 수집·이용 동의서학교장 추천서주민등록초본(주소변동이력포함)장학금 수납통장(보호자 또는 학생)대학수학능력시험 통지표 사본저소득가정증빙서류(국민기초생활수급자증명서/ 한부모가정증명서)대학재학증명서대학수학능력 시험 통지표 사본 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '사단법인남해군향토장학회',
      Col2: '관외대학교진학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당 고등학교 자체 심사기준에 의거 성적우수자 및 가정형편이 어려운자(소년소녀가장 한부모가정 등)를 해당 학교장이 선정하여 추천',
      Col11: '2000000원',
      Col12: '관내에 소재한 고등학교 3학년 학생으로 대학교(전문대 포함) 진학이 확정된 학생',
      Col13: '당해연도 남해군향토 장학회 장학생 선발공고일 현재 부모(보호자)가 남해군에 주소를 두고 있는 학생',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '21명',
      Col17: '해당없음',
      Col18: '학교장 추천 ',
      Col19: '장학생신청서고등학교 생활기록부(성적증명서포함)대학합격 증빙서류주민등록 등본통장사본'
    },
    {
      Col1: '사단법인남해군향토장학회',
      Col2: '경남도립남해대학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '600000 ~ 1200000원',
      Col12: '진학생 : 관내에 소재학 고등학교 3학년 학생으로 경남도립남해대학 진학이 확정된 학생재학생 : 경남도립남해대학에 재학중인 학생',
      Col13: '재학생 : 당해연도 남해군향토 장학회 장학생 선발공고일 현재 부모(보호자)가 남해군에 주소를 두고 있는 학생진학생 : 관내에 소재한 고등학교 졸업(예정)자로 경남도립남해대학에 진학확정자',
      Col14: '2021-12-24~2022-01-21',
      Col15: '선발기준 : 경남도립남해대학 자체 심사기준에 의거 성적우수자 및 가정형편이 어려운자(소년소녀가장/ 한부모가정 등)를 남해대학 총장이 선정하여 추천',
      Col16: '2022년도 진학생 14명진학 : 8명향우자녀 : 6명재학생4명 ',
      Col17: '해당없음',
      Col18: '남해대학총장 추천',
      Col19: '장학생 신청서고등학교 생활기록부대학합격 증빙서류주민등록 등본통장사본 '
    },
    {
      Col1: '사단법인남해군향토장학회',
      Col2: '관외대학재학생(전문대포함)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 평균 학점 3.0/4.5이상인 자(12학점 이상 이수)',
      Col10: '부모의 건강보험료 납부액(2021. 01월~12월)평균금액으로 평가',
      Col11: '2000000원',
      Col12: '관외 전문대/대학교 재학생',
      Col13: '당해연도 남해군향토 장학회 장학생 선발공고일 현재 부모(보호자)가 남해군에 주소를 두고 있는 학생',
      Col14: '2020-12-23~2020-12-30',
      Col15: '성적80% + 생활정도 10% + 가산점 10%',
      Col16: '관외 대학교(전문대 포함) 30명 ',
      Col17: '해당없음',
      Col18: '총(학)장의 추천',
      Col19: '장학생신청서직전학기 성적증명서(4.5점 만점)재학증명서주민등록 등본통장사본건강보험 납부확인서 또는 자격득실확인서특별사항 해당서류   *장애인가정(장애 1~3등급) 해당 증빙자료/ 다자녀/ 다문화 가정 해당 증빙자료/ 12만원이상 향토장학회에 기탁한 가정 : 연말정산 자료 또는 기부금 영수증'
    },
    {
      Col1: '사단법인남해군향토장학회',
      Col2: '4년장학생(대학재학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학진학 후 매년년 평균학점이 3.6이상을 유지한 학생',
      Col10: '해당없음',
      Col11: '4000000원',
      Col12: '학교장이 대상학생을 학교별 1명이내 추천',
      Col13: '선발공고일 현재 남해군에 주소를 두고 있는 학생관내 초/중학교를 졸업하고/ 관내 고등학교 졸업 예정 학생',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '4명 ',
      Col17: '2021년 2월 졸업예정자 및 휴학자 제외 ',
      Col18: '학교장 추천',
      Col19: '장학생 신청서직전년도 성적증명서재학증명서주민등록 등본통장사본 '
    },
    {
      Col1: '사단법인남해군향토장학회',
      Col2: '특기생(진학생/재학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '700000원 ~ 1000000원원',
      Col12: '개인 및 단체/ 4년제 이상 대학진학이 확정된 학생(국가대표는 전체학생을 대상)당해연도 전국규모 대회 3위 이내 및 경상남도대회 1위 입상자 및 국가대표와 그에 상응하는 대표로 선발된자 및 단체',
      Col13: '당해연도 남해군향토 장학회 장학생 선발공고일 현재 부모(보호자)가 남해군에 주소를 두고 있는 학생',
      Col14: '2021-12-24~2022-01-21',
      Col15: '해당없음',
      Col16: '자세한 사항은 첨부파일 참고 ',
      Col17: '해당없음',
      Col18: '학교장 추천 ',
      Col19: '장학생신청서고등학교 생활기록부(진학생)대학합격 증빙서류 또는 재학증명서특기생 증빙서류(상장사본/언론보도/발간자료 등)주민등록 등본통장사본'
    },
    {
      Col1: '사단법인남해군향토장학회',
      Col2: '나눔장학금(다자녀대학진학생)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/제한없음',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '500000원',
      Col12: '대학 진학이 확정된 다자녀(셋째자녀이상) 학생 (다자녀 가구당 1명)',
      Col13: '선발공고일 현재 부모가 남해군에 주소를 두고 있는 학생 ',
      Col14: '2022-02-01~2022-02-23',
      Col15: '해당없음',
      Col16: '관내·외 대학교 (전문대 포함) 진학생전 대상자 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 신청서고등학교 생활기록부대학합격 증빙서류다자녀 증빙서류주민등록 등본통장사본 '
    },
    {
      Col1: '밀양시민장학재단',
      Col2: '대학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 학교성적 및 수학능력 시험의 우수한 성적으로 대학교에 입학한 자  ',
      Col10: '해당없음',
      Col11: '등록금 범위 내 최대 100만원 지원 * 단 중복지원 방지를 위해 타 기관 장학금을 받는 경우에는 장학금 총액과 등록금 납부액의 차액을 지급',
      Col12: '2022학년도 대학교 신입생',
      Col13: '본인 및 부모 모두가 공고일 현재 밀양시에 주소를 두고 있는 자',
      Col14: '2022-02-01~2022-02-23',
      Col15: '서류심사 후 재단 이사회 최종선발',
      Col16: '00명',
      Col17: '외국대학 및 평생교육법에 따른 원격대학/ 사내대학/ 대학원 제외',
      Col18: '해당없음',
      Col19: ' * 신입생장학생 지원신청서대학교 합격통지서 사본초등학교/ 중학교 졸업증명서주민등록등본수능학능력시험 성적확인서 사본(학교장 확인)개인정보 수집/활용/제공 동의서등록금 납부확인서 * 자세한 사항은 첨부파일 참고 필수수'
    },
    {
      Col1: '밀양시민장학재단',
      Col2: '특기생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전국규모대회에서 우수한 성적 또는 시/도대회 1등의 성적을 거둔 자 중 상급 학교에 진학한 자(예능/ 체능 등)',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '2022학년도 대학교 신입생',
      Col13: '밀양지역 출신',
      Col14: '2022-04-01~2022-04-29',
      Col15: '서류심사 후 재단 이사회 최종선발',
      Col16: '00명',
      Col17: '여타 장학금과 합산하여 등록금을 초과할 경우 본 재단의 장학금 지급이 제한될 수 있음등록금을 초과하여 수령하였을 경우에는 사후 반납하여야 할 의무 있음',
      Col18: '해당없음',
      Col19: '장학생 지원서(소정양식) 1부대학교 합격통지서 사본 1부초/ 중/ 고등학교 졸업증명서 각 1통주민등록 등본 1부개인정보 수집/활용/제공 동의서등록금 납부확인서예체능 해당분야 성적증명서(상장 등 근거서류)출신학교 생활기록부 사본(학교장 확인) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '사단법인산청군향토장학회',
      Col2: '대학교입학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' [신입생]수능능성적 2등급이내 2개영역 이상고등학교 내신평균등급 2등급 이내',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '서민자녀 (국민기초생활보장수급자/ 한부모가족/ 차상위계층 가구의 자녀)세자녀이상 가정 학생 (셋째자녀부터 지원)',
      Col13: '공고일 현재 산청군에 1년 이상 계속하여 거주하고 있는 군민 또는 그의 자녀관내 소재한 고등학교를 졸업한 대학교(전문대포함) 입학생 및 재학생 중 성적우수자',
      Col14: '2022-04-01~2022-04-29',
      Col15: '성적우수자서민자녀다자녀 가정 학생 * 자세한 내용은 첨부파일 참고 필수',
      Col16: '38명',
      Col17: '휴학생 제외',
      Col18: '성적우수: 출신고등학교장 추천서민자녀/ 다자녀가정 학생: 읍면장 추천',
      Col19: '보호자의 주민등록 초본(주소변동사항 포함)개인(신용)정보 수집·이용·제공 및 조회 동의서장학생 신청(추천)서대학입학(재학)증명서고교졸업증명서* 전형별 제출서류 상이하므로 첨부파일 확인'
    },
    {
      Col1: '사단법인산청군향토장학회',
      Col2: '대학교재학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' [재학생]일반대학교 재학생 중 평균 성적우수자(직전2개 학기 평균 평점 3.5이상/4.5 기준)전문대학 재학생 중 평균 성적우수자 (직전 2개학기 평균 평점 3.7이상/4.5 기준)',
      Col10: '가정형편이 어려운 서민자녀(차상위계층 기초생활수급자 한부모가족) 가구의 자녀',
      Col11: '3000000원',
      Col12: '산청군에 1년 이상 계속하여 거주하고 있는 군민또는 그의 자녀로서 관내 소재한 고등학교를 졸업한 대학교(전문대포함) 입학생 및 재학생 중 성적우수자 또는 서민자녀',
      Col13: '공고일 기준 산청군에 1년 이상 계속하여 거주하고 있는 군민또는 그의 자녀관내 소재한 고등학교를 졸업한 대학교(전문대포함) 입학생 및 재학생 중 성적우수자',
      Col14: '2022-01-06~2022-01-13',
      Col15: '해당없음',
      Col16: '79명',
      Col17: '중복수혜 불가휴학생 제외',
      Col18: '읍면장 추천',
      Col19: '보호자의 주민등록 초본(주소변동사항 포함)개인(신용)정보 수집·이용·제공 및 조회 동의서장학생 신청서대학재학증명서성적증명서(직전 2개학기) * 자세한 사항은 첨부파일 참고 필수'
    },
    {
      Col1: '재단법인 함안군장학재단',
      Col2: '진학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전국 수능 국어/ 수학/ 영어 3개영역의 합이 4등급 이내로 대학에 입학한 자(관내 고등학교 졸업자)전국 수능 국어/ 수학/ 영어 3개영역의 합이 3등급인 자(부모 함안군 거주자)',
      Col10: '해당없음',
      Col11: '합 3등급 이내 (2500000원)합 4등급 이내 (1000000원)',
      Col12: '해당없음',
      Col13: '관내 고등학교를 졸업한 자(예정자 포함)부모가 함안군에 주소를 두고 계속 거주하고/ 관내 초중학교를 모두 졸업한 자',
      Col14: '2022-01-06~2022-01-13',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '타 장학금과 합해서 학비(등록금)를 초과하지 않는 범위 내에서 지급본 장학재단 내 중복 신청 불가',
      Col18: '소속 학교장 추천',
      Col19: '등록금납부 증명서주민등록 등본 1통(신청기간기준)※학생의 부모만 함안에 주소가 되어 있을 때 : 가족관계증명서와 부모 주민등록등본 각 1통관내고등학교 졸업(예정) 증명서보호자 통장사본개인정보 수집 및 활용 동의서추천서대학수학능력시험 성적증명서추천장학생 성적 연 명부(학년별/ 지원종류별)'
    },
    {
      Col1: '재단법인 함안군장학재단',
      Col2: '진학장학금(특별장학금)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전국 수능 국어/수학/영어 3개영역의 합이 3등급인 자',
      Col10: '해당없음',
      Col11: '3000000원(1회 지급)',
      Col12: '해당없음',
      Col13: '부모가 함안군에 주소를 두고 계속 거주하고/ 관내 초/중학교를 모두 졸업한 자',
      Col14: '2022-07-13~2022-07-20',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '타 장학금과 합해서 학비(등록금)를 초과하지 않는 범위 내에서 지급본 장학재단 내 중복 신청 불가',
      Col18: '소속 학교장 추천',
      Col19: '등록금납부 증명서주민등록 등본 1통(신청기간기준)※학생의 부모만 함안에 주소가 되어 있을 때 : 가족관계증명서와 부모 주민등록등본 각 1통관내고등학교 졸업 증명서보호자 통장사본개인정보 수집 및 활용 동의서추천서대학수학능력시험 성적증명서추천장학생 성적 연 명부(학년별/ 지원종류별)'
    },
    {
      Col1: '재단법인 함안군장학재단',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(18년 이전 입학생) A급 진학 장학금을 받은 학생 중 직전학기의 성적 평점이 3.5/4.5 이상 또는 3.3/4.3 이상인 자(18년 이후 장학생) 수능 국어/수학/영어 3개 영역의 합이 4등급 이내로 대학에 입학한 자중 직전학기의 성적평점이 3/5/4.5이상 또는 3.3/4.5 이상인 자',
      Col10: '해당없음',
      Col11: ' * 18년 이전 입학생 : 2500000원 * 18년 이후 입학생  A급 합 3등급 : 2500000원 B급 합 4등급 : 1000000원',
      Col12: '(18년 이전 입학생) A급 진학 장학금을 받은 학생 중 직전학기의 성적 평점이 3.5/4.5 이상 또는 3.3/4.3 이상인 자(18년 이후 장학생) 수능 국어/수학/영어 3개 영역의 합이 4등급 이내로 대학에 입학한 자중 직전학기의 성적평점이 3/5/4.5이상 또는 3.3/4.5 이상인 자',
      Col13: '관내 고등학교 출신 졸업생으로서 신청일 현재 함안군민의 자녀로(한 부모 이상 함안군에 주소를 둔 자) 신청기준의 자격을 갖춘 자 * 단 결손가정이나 소년소녀가정은 예외)',
      Col14: '2022-07-15~2022-07-21',
      Col15: '서류심사 후 함안군장학재단 이사회의 심의를 거쳐 대상자 최종확정',
      Col16: '해당없음',
      Col17: '타 장학재단과 이중으로 지급받은 자본 장학재단 내 중복 신청 불가',
      Col18: '해당없음',
      Col19: '신청서고등학교 졸업증명서대학수학능력시험 성적증명서직전학기 성적증명서등록금 납부증명서주민등록 등본가족관계증명서(해당자)보호자 통장사본개인정보 수집 및 활용 동의서기타심의에 필요한 서류 * 본인이 재단 사무국에 직접 신청 및 우편신청 * 추천서 및 서식은 함안군 장학재단 홈페이지 참고'
    },
    {
      Col1: '재단법인 함안군장학재단',
      Col2: '관악회남호(조필제)특지장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 3.5 이상 ',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '함암군 관내 고등학교 졸업생 중 함안군민의 자녀로/ 서울대학교 신입생 및 재학생장학금 수여식에 참석할 수 있는 학생만 추천',
      Col13: '함안관내 고등학교 졸업생 중 함안군민의 자녀',
      Col14: '2022-07-13~2022-07-20',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '타 장학금을 지급받는 자 제외 * 자세한 사항 기관으로 문의',
      Col18: '해당없음',
      Col19: '장학생 추천서성적증명서학생기록카드재학증명서본인명의 통장사본주민등록등본(학생의 부모만 함안에 주소가 되어있을 때는 가족관계증명서) * 제출서류 양식은 함안군장학재단단 홈페이지 게시판 참고'
    },
    {
      Col1: '재단법인 함안군장학재단',
      Col2: '기숙사비(주거비)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '수능3개영역(국어/수학/영어)이 3등급 이내로 대학에 진학한 자 (직전 학기의 성적 평점이 3.5/4.5(3.3/4.3)이상인 학생)',
      Col10: '해당없음',
      Col11: '800000원 * 2018년도 대학 신입생부터 기숙사비 지원없음.',
      Col12: '해당없음',
      Col13: '관내 고등학교 출신 졸업생으로서 신청일 현재 함안군민의 자녀* 단 결손가정이나 소년소녀가정은 예외/ 대학 재학생은 대학 진학시 본 재단에서 장학금을 받은 수능성적 우수자여야 함)',
      Col14: '2021-09-13~2021-10-08',
      Col15: '서류심사 후 함안군장학재단 이사회의 심의를 거쳐 대상자 최종확정',
      Col16: '해당없음',
      Col17: ' * 2018년도 대학 신입생부터 기숙사비 지원없음',
      Col18: '해당없음',
      Col19: '신청서고등학교 졸업증명서대학수학능력시험 성적증명서직전학기 성적증명서등록금 납부증명서주민등록 등본 1통(신청기간 기준) (학생의 부모만 함안에 주소가 되어 있을 때 : 가족관계증명서와 부모 주민등록등본 각 1통)보호자 통장사본개인정보 수집 및 활용동의서기타 심의에 필요한 서류 * 본인이 재단 사무국에 직접 신청 및 우편신청 * 추천서 및 서식은 함안군 장학재단 홈페이지 참고'
    },
    {
      Col1: '사단법인 함양군 장학회',
      Col2: '근로자자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학생 : 직전학기 평균평점이 C+이상인 자',
      Col10: '월 평균 가고소득이 2021년 기준 4인 가구 중위소득 130% 이하인 가정정',
      Col11: '2000000원',
      Col12: '가정형편이 어려운 근로자의 자녀중 학업성적이 우수한 자 산업평화에 기여한 공로로 군수 이상의 표창을 받은 자',
      Col13: '함양군내에 소재하고 있는 중소기업체에 근무하고/ 군내에 주민등록이 되어 있는 자',
      Col14: '2022-03-04~2022-03-21',
      Col15: '해당없음',
      Col16: '3명',
      Col17: '학교/ 타재단/ 사업장 등으로부터 학자금 또는 장학금을 지급받는 자로서/ 본인 납부금액 10만원 이하인 자',
      Col18: '해당없음',
      Col19: '장학금 신청서장학금 지급대상자 추천서 (장학금 수혜내역 첨부)장학금 지급대상자 추천서개인정보이용 동의서재직증명서재학증명서직전학기 성적증명서주민등록등본직전년도 근로소득 원천징수 영수증 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '사단법인합천군교육발전위원회',
      Col2: '예체능특기자장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '예체능계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '예체능특기자전형진학 : 2000000원전국적인 공인대회 3위 이내 : 1500000원',
      Col12: '예체능 특기자 전형 진학 대학생전국적인 공인대회 3위 이내관내 고등학교 출신 대학교(전문대학 포함)재학생',
      Col13: '신청일 현재 합천군 관내 2년 이상 계속해서 주소를 두고 있는 학생 및 학부모관내 고등학교 출신 대학교 재학생은 보호자도 합천에 주소를 두고 있어야 함',
      Col14: '2021-02-26~2021-03-12',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '예체능 장학금은 모든 출전 대회 입상 성적 중 최상위 부문 *장학생생 선발 이후 다음 사유 발생 시 장학금 지급 정지품행이 극히 불량하고 학업성적이 자격수준 이하로 떨어졌을 때퇴학 또는 정학 이상의 징계처분을 받거나 기타 사유로 학업을 중단하였을 경우타 시군으로 전학하였거나 전출하였을 경우',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록등본통장사본본대학진학 : 최종등록대학 납입고지서/ 합격증명서/ 관내중학교졸업증명서대회입상 : 대회입상 성적증명서/ 대학재학증명서/ 관내중학교 졸업증명서 '
    },
    {
      Col1: '사단법인합천군교육발전위원회',
      Col2: '우수대학진학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '수능성적 1등급 3개영역 이상 : 7000000원고려대 연세대 포항공대 KAIST : 3000000원수능성적 1등급 2개 영역 이상 : 3000000원수능성적 1등급 1개 영역 포함 2등급 2개 영역 이상 : 2백만원수능등급 1등급 1개 영역 이상  수능등급 2등급 2개 영역 이상 : 1백만원',
      Col12: '수시전형 또는 수능 성적 일정 기준 이상을받고 우수대학교에 진학하는 학생서울대/ 고려대(안암캠퍼스)/ 연세대(신촌 국제캠퍼스)/ 포항공대/ KAIST',
      Col13: '신청일 현재 합천군 관내 2년 이상 계속해서 주소를 두고 있는 학생 및 학부모관내 고등학교 졸업생',
      Col14: '2022-03-04~2022-03-21',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2개 부문 이상 장학금 선발대상에 해당하는 경우 1개 부문만 지급 *장학생생 선발 이후 다음 사유 발생 시 장학금 지급 정지품행이 극히 불량하고 학업성적이 자격수준 이하로 떨어졌을 때퇴학 또는 정학 이상의 징계처분을 받거나 기타 사유로 학업을 중단하였을 경우타 시군으로 전학하였거나 전출하였을 경우',
      Col18: '해당없음',
      Col19: '*장학금 신청서 및 증빙서류를 합천군 교육발전위원회로 제출(전화팩스접수 불가)장학생 지원서주민등록등본(보호자 포함/ 최근 2년이상 주소변동내역 포함)기타 사실을 증명 할 수 있는 서류통장사본최종등록대학 납입고지서대입수학능력시험 성적표관내고교졸업증명서 '
    },
    {
      Col1: '사단법인합천군교육발전위원회',
      Col2: '대학생성적우수자장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 2개학기 학점 평균 4.0/4.5이상기초생활수급자는 3.0/4.5 이상직전학기 취득학점 15학점 이상',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '관내 고교 출신 대학 재학생',
      Col13: '관내 고등학교 출신 대학교 재학생은 보호자도 합천에 주소를 두고 있어야 함신청청일 현재 합천군 관내 2년 이상 계속해서 주소를 두고 있는 학생 및 학부모',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2개 부문 이상 장학금 선발대상에 해당하는 경우 1개 부문만 지급 *장학생 선발 이후 다음 사유 발생 시 장학금 지급 정지품행이 극히 불량하고 학업성적이 자격수준 이하로 떨어졌을 때퇴학 또는 정학 이상의 징계처분을 받거나 기타 사유로 학업을 중단하였을 경우타 시군으로 전학하였거나 전출하였을 경우',
      Col18: '해당없음',
      Col19: '*장학금 신청서 및 증빙서류를 합천군 교육발전위원회로 제출(전화팩스접수 불가)장학생 지원서주민등록등본(보호자 포함/ 최근 2년이상 주소변동내역 포함)기타 사실을 증명 할 수 있는 서류통장사본직전 2개 학기 성적증명서(4.5변환기준)대학 재학증명서관내고교 졸업증명서(기초생활수급자의 경우)수급자증명서'
    },
    {
      Col1: '(재단법인)아산사회복지재단',
      Col2: '아산나래장학생(다문화/조손가정)',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체 평점이 3.0/4.5 이상인 학생',
      Col10: '경제적으로 어려운 다문화가정 및 조손가정 자녀',
      Col11: '등록금 전액 + 학기당 1200000원 생활비 * 결격사유 없을 시 최대 6학기 지원',
      Col12: '경제적으로 어려운 다문화가정 및 조손가정 학생전국의 4년제 대학에 재학 중으로 2021년 신규학기에 2~4학년 재학중이며 성적요건을 충족하는 자',
      Col13: '해당없음',
      Col14: '2020-11-30~2020-12-20',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '사이버대학/ 사내대학/ 방송통신대학타 장학금 수혜 대상자',
      Col18: '해당없음',
      Col19: ' * 아산재단 지원신청서비스 접속 후 개별신청소득분위 확인서(한국장학재단 신청학기)부모 모두의 직전년도 지방세 세목별 과세 증명서(해당자)부모 모두의 직전년도 소득증명서류(해당자)부모 중 한 분 명의의 가족관계증명서/ 주민등록등본학교추천서성적증명서개인정보 수집·이용 및 제3자 제공 동의서  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재단법인)아산사회복지재단',
      Col2: '아산나래장학생(SOS장학생)',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체평점이 3.5/4.5 이상인 학생',
      Col10: '갑작스런 경제적 어려움(부모의 사업실패 질병 재해 등) 으로 인한 학업중단 위기 학생',
      Col11: '등록금 전액 + 학기당 1200000원 생활비 * 생활비 연 2400000원 지급 ** 결격사유 없을 시 최대 6학기 지원',
      Col12: '부모의 사업실패·질병·재해 등 갑작스러운 경제적 어려움으로 학업중단 위기에 놓인 학생전국의 4년제 대학에 재학 중으로 21년도 신규학기에 2~4학년 재학생이며 성적요건을 충족하는 자',
      Col13: '해당없음',
      Col14: '2020-10-19~2020-11-08',
      Col15: '과정 : 온라인 지원 → 서류심사 → 면접심사 → 합격자 발표',
      Col16: '해당없음',
      Col17: '사이버대학/ 사내대학/ 방송통신대학신청학기에 타 기관 장학금 수혜 대상이 아닌 학생휴학생 * 자세한 사항은 첨부파일 참조',
      Col18: '학과 교수의 추천',
      Col19: '신청학기 한국장학재단 소득분위 확인서부모 중 한 분 명의의 가족관계증명서학교 추천서성적증명서개인정보 수집·이용 및 제3자 제공 동의서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '(재단법인)아산사회복지재단',
      Col2: '아산다솜장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체 평점이 3.0/4.5 이상인 학생',
      Col10: '해당없음',
      Col11: '등록금 전액 + 학기당 1200000원 생활비 * 연 2400000원 생활비 지급 ** 결격사유 없을시 최대 6학기 지원',
      Col12: '경제적으로 어려운 장애인 대학생전국의 4년제 대학 2~4학년 재학생',
      Col13: '해당없음',
      Col14: '2020-10-19~2020-11-08',
      Col15: '온라인 지원 → 서류심사 → 면접심사 → 합격자 발표 ',
      Col16: '해당없음',
      Col17: '사이버대학/ 사내대학/ 방송통신대 재학생신규학기 타 기관 장학금 수혜 대상자 * 자세한 사항은 첨부파일 참조',
      Col18: '학과 교수의 추천',
      Col19: '신청학기 한국장학재단 소득분위 확인서부모 중 한 분 명의의 가족관계증명서학교추천서성적증명서 장애인 증명서개인정보 수집·이용 및 제3자 제공 동의서   * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재단법인)아산사회복지재단',
      Col2: '아산나래장학생(복지시설장학생)',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체 평점이 3.0/4.5 이상인 학생',
      Col10: '해당없음',
      Col11: '등록금 전액 + 학기당 1200000원 생활비 지원 * 연간 2400000원 생활비 지원 ** 결격사유 없을 시 최대 6학기 지원',
      Col12: '아동생활시설에서 성장한 청소년으로 전국의 4년제 대학 재학생',
      Col13: '해당없음',
      Col14: '2021-11-16~2021-12-24',
      Col15: '온라인 지원 → 서류심사 → 면접심사 → 합격자발표',
      Col16: '해당없음',
      Col17: '신청학기에 타 기관 장학금 수혜 대상자사이버대학/ 사내대학/ 방송통신대학 재학생  * 자세한 사항은 첨부파일 참조',
      Col18: '복지시설장의 추천',
      Col19: ' * 복지시설 제출 서류추천공문복지시설장의 추천서 * 학생 제출 서류성적증명서주민등록등본개인정보 수집·이용 및 제3자 제공 동의서 ※ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '(재단법인)아산사회복지재단',
      Col2: '아산MIU자녀장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' [사회배려대상자]: \'21년도까지 전체학년 누적 성적 총 평점 3.5/4.5 이상자 [성적우수자]: \'21년도 까지 전체학년 누적 성적 총 평점 4.3/4.5 이상자',
      Col10: '해당없음',
      Col11: '1인당 3000000원',
      Col12: '국내 대학·전문대학 재학 중 정규학기에 등록한 재학생사회배려대상자: 공상자/ 장애가정/ 한무보가정/ 다자녀가정',
      Col13: '해당없음',
      Col14: '2020-10-19~2020-11-08',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '제적/ 정학/ 징계처분/ 군입대/ 학업중단/ 휴학 등에 해당하는 자는 제외고등교육법 제2조에 포함되지 않는 교육기관 재학생 ',
      Col18: '해당없음',
      Col19: 'MIU 장학금 신청서 [별지1] (원본)전체 누적 재학증명서 (원본)장학생 카드 (원본) [아산재단 서식1]자기소개서 (원본) [아산재단 서식2]복학/ 편입생 관련 증명서류(학적부) (사본가능)가족관계증명서 (가족 모두 표식/ 3개월 이내 발급) (원본)신청자녀 명의의 입출금식통장 (사본)장애(부모/형재/자매)/ 공상자(부모) 증명 서류(사본) * 장애 증명서/ 공상자(공무상병인증서/ 전공상심의의결서 등) 서류개인정보제공 동의서 (원본) [별지2/ 아산재단 서식3]'
    },
    {
      Col1: '(재단법인)아산사회복지재단',
      Col2: '아산재능나눔장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체평점이 3.0/4.5 이상인 학생',
      Col10: '해당없음',
      Col11: '등록금 전액 + 학기당 봉사활동비 최대 500000원 * 결격사유 없을 시 졸업 시까지 최대 6학기 지원',
      Col12: '자신의 전공지식 또는 재능을 어려운 이웃에게 나누면서 연 150시간 동안 성실히 본사황동을 수행하는 학생전국의 4년제 대학에 재학중인 학생2021년 신규학기에 2/3학년인 학생 * 봉사활동 수행기간 : 2021. 3. 1 ~ 2021. 12. 31',
      Col13: '해당없음',
      Col14: '2021-10-12~2021-10-29',
      Col15: '온라인 지원 → 서류심사 → 면접심사 → 합격자발표',
      Col16: '해당없음',
      Col17: '타 기관 장학금 수혜 대상자사이버대학/ 사내대학/ 방송통신대학 재학생 * 자세한 사항은 첨부파일 참조',
      Col18: '학과 교수의 추천',
      Col19: '학교추천서(서류합격대상자 제출)성적증명서과거 봉사활동 증명서기관 방문확인서개인정보 수집·이용 및 제3자 제공 동의서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '(재단법인)아산사회복지재단',
      Col2: '의생명과학분야대학원장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원/전문대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '의약계열',
      Col9: '성적 평점이 4.0/4.5 이상인 학생 ( 4.3 만점 기준 3.82 이상) * 입학예정자: 입학 전 최종학력 성적평점 / 재학생: 직전학기 포함 성적평점',
      Col10: '해당없음',
      Col11: '연 20000000원 정액지원 * 등록금 학술활동비 등으로 사용가능하며 학기별 학교로 송금 * 교내장학금 및 조교장학금(FA TA RA) 중복수혜 가능 * 석사과정 박사과정: 최대 2년 / 석박사통합과정: 최대 4년',
      Col12: '국내대학의 석사과정/ 박사과정/ 석박사통합과정 입학 예정자 또는 재학생의과학/ 생명과학 등 의생명과학 분야를 연구하는 대학원생   (소속 전공학과/ 연령/ 성별 제한 없음)대한민국 국적 보유자국내 대학(대학원) 학위 취득자 또는 취득 예정자SCI(E)급 제1저자 발표자 또는 석사학위 논문 보유자타기관 장학금 수혜 대상이 아닌 학생',
      Col13: '해당없음',
      Col14: '2021-10-04~2021-10-22',
      Col15: '해당없음',
      Col16: '20명',
      Col17: '해외 영주권자 및 이중국적자 제외취업 활동 금지 및 전일제(Fulltime) 학생 자격 유지교내징계 (제적/ 정학 등)학업중단계속장학생 자격 심사에서 탈락한 학생',
      Col18: '지도교수 추천',
      Col19: ' * 필수 제출지원서학업계획서개인정보 수집 및 활용동의서지도교수 추천서(대학원 과정의 지도교수 작성 권장)재학증명서 또는 입학 예정증명서졸업(예정)증명서전 과정 성적증명서대표 연구 논문 초록 * 선택제출어학능력증명서 (TOEIC/ TOEFL 등 공인어학증명서 모두 가능/ 유효기간 무관)경력/ 자격/ 수상실적/ 특허 등 증빙 서류수급권자/ 차상위계층 증명 서류  * 모든 서류는 순서대로 PDF 1개 파일로 병합하여 제출 단/ 지도교수 추천서는 지도교수가 직접 이메일 제출'
    },
    {
      Col1: '(재단법인)아산사회복지재단',
      Col2: '해외의생명과학분야대학원장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원/전문대학원/해외대학',
      Col7: '대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적 평점이 3.82/4.3 (4.0만점 3.55이상) 인 자 * 입학예정자 : 입학 전 최종학력 성적평점ㅇ',
      Col10: '해당없음',
      Col11: '연 40000000원 * 지원기간 : 석사과정 최대 2년 / 박사과정 최대 3년 / 석·박사통합과정 최대 5년',
      Col12: '외국대학의 석사과정/ 박사과정/ 석·박사 통합과정 입학 예정자 또는 재학생의학/ 생명과학 등 의생명과학 분야를 연구하는 대학원생국내 대학(원) 학위 취득자 또는 취득예정자로 대한민국 국적보유자SCI(E)/ KCI 저널 등재 논문 또는 석사학위 이상 졸업논문 보유자 * 전공학과/ 유학 국가/ 연령/ 성별 제한 없음',
      Col13: '해당없음',
      Col14: '2021-04-06~2021-04-12',
      Col15: '서류심사 → 면접 심사(해외 체류자는 화상면접 대체) → 합격 발표',
      Col16: '해당없음',
      Col17: '해외 영주권자 및 이중국적자타 기관 장학금 수혜 대상자 (단/ 교내장학금 및 조교장학금은 중복 수혜 가능)입학예정자의 경우 진학을 목표했던 학교에 최종 불합격시 지원 취소',
      Col18: '지도교수의 추천서 제출',
      Col19: '지도교수 추천서재학증명서졸업(예정)증명서성적증명서대표 연구 논문 초록개인정보 수집·이용 및 제3자 제공 동의서선택제출서류 (해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: 'KSD나눔재단',
      Col2: '꿈이룸장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '사회계열/인문계열',
      Col9: '최근 2개 학기 학점 평균 4.5점 만점 기준 3.6점 이상 * 4.3만점 기준 3.44점 이상상',
      Col10: '소득분위 7분위 (중위소득 150%) 이내 ',
      Col11: '한 학기당  최대 200만원 한도 내 지원 (연간 최대 400만원)학기당 200만원 한도 내 등록금',
      Col12: '전국 4년제 대학교 상경 및 인문 사회계열 학과(부) 2학년~3학년 재학생',
      Col13: '해당없음',
      Col14: '2020-01-28~2020-02-05',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '교내 및 국가장학금 외 타 기관 장학금 수혜자는 제외이공계/ 예체능 학과는 제외장학생 선정 이후 1학기 휴학은 인정하되/ 2개학기 연속 휴학 시 지원 종료됨 (군 휴학 동일)장학생으로서의 품위를 손상한 자 징계받은 자 또는 징계 의결 중인 자  ',
      Col18: '해당없음',
      Col19: '장학생 신청서추천서학업계획서성적증빙서류: 성적증명서 및 수상증빙서류소득증빙서류: 기초생활수급자 증명서/ 차상위계층 확인서/ 건강보험납부확인서 및 주민등록등본개인정보활용동의서학교제출서류: 고유번호증 또는 사업자등록증장학생 선정 시 등록금고지서 및 통장사본(학교명의) * 자세한 사항은 첨부파일 참고 * 제출서류일체 지원자 1명당 1개의 PDF파일로 만들어서 담당자 이메일 제출 (재학학교를 통해서만 신청가능/ 개인신청 불가)'
    },
    {
      Col1: '재단법인 농협재단',
      Col2: '농대 장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '자연계열/특정학과',
      Col9: '재학생 : 직전학기 성적 70점 이상',
      Col10: '해당없음',
      Col11: '(농업계열 일반대학) 2000000원(등록금 전액 국비지원) 1000000원 * 학업장려금 성격의 장학금으로 연 2회 지원',
      Col12: ' * 국내소재 대학의 2020년도 입학예정자 및 재학생으로/ 졸업시 까지 이수할 정규학기 2개 이상 남은 자(농업계열일반대학) 영농의지가 뚜렷한 농업계열 전공자 또는 농업계열전공자 중 농업관련 기관종사 예정자(등록금 전액 국비지원) 영농의지가 뚜렷한 농업계열 전공자이며/ 정규수업연한 동안 등록금 전액 국비지원 수혜자ㅣ',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '가정형편/ 지원신청서 및 자기소개서 등을 종합평가하여 평가',
      Col16: '해당없음',
      Col17: '정규학기연한 초과자농협장학관 입사생으로 합격한 경우 입주 중인 해당학기 장학금지원 불가농협 상임임원 및 정규직원 자녀고소득(연봉 5/000만원 이상) 계약직 직원 자녀 제외방송대학·통신대학·방송통신대학 및 사이버대학 재학생휴학예정자',
      Col18: '재학중인 학교의 학과장 추천서 제출',
      Col19: '지원 신청서자기소개서 및 확약서개인정보 수집·이용 동의서가족관계증명서주민등록등본2019년 1~12월 건강보험료 납부확인서(부)2019년 1~12월 건강보험료 납부확인서(모)재학증명서 또는 복학증명서(재학생)전(全)학년 성적증명서(재학생)재학중인 대학장 학과장 추천서(재학생) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 농협재단',
      Col2: '미래농촌정주장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 농업계열일반대학1학기당 2000000원 (연간400만원) * 등록금 전액 국비지원1학기당 1000000원(연간200만원) * 계속 지급기준 직전학기 성적 70점 이상 성적 유지시 정규수업연한 동안 지원 * 정액지원 (학업장려금 성격의 장학금)',
      Col12: '농협중앙회/ 경제(금융)지주/ 농협은행/ 농·축협 등 농협이 출자 지배하고 있는 관계회사(계열사)의 상임임원과 정규직원 및 그 자녀에 적용 * 농업계열 일반대학 (재학생/ 신입생)국내 소재 대학의 2019년도 입학예정자 및 재학생으로 영농의지가 뚜렷한 농업계열 전공자 * 그외 자세한 사항은 홈페이지 참고',
      Col13: '해당없음',
      Col14: '2022-06-21~2022-07-07',
      Col15: '가정형편 100% 반영 * 동점자 처리 기준학과장추천서 및 자기소개서를 통해 영농의지 평가',
      Col16: 'O 명',
      Col17: '방송대학·통신대학·방송통신대학 및 사이버대학 학생은 지원불가농협 상임임원 및 정규직원 자녀 제외고소득(연봉 5/000만원 이상) 계약직 직원 자녀 제외',
      Col18: '재학중인 대학교 학과장 추천',
      Col19: '지원 신청서 (자기소개서 포함)/ (內 작성 후 저장)개인정보 수집·이용 동의서건강·장기요양보험료 납부확인서(부)/ (2019년도12개월 내역)건강·장기요양보험료 납부확인서(모)/ (2019년도12개월 내역)재학증명서 또는 복학증명서전(全)학년 성적증명서 (졸업시까지 남은 학기 확인시 필요)재학중인 대학교 학과장 추천서 (학과장 확인 필수) * 합격자 서류 (필요서류를 제출하지 않는 자는 불합격 처리)2020학년도 대학 합격통지서(‘20년도 신입생)대학 등록금 납입서(공통)장학금 입금계좌 사본(공통)'
    },
    {
      Col1: '재단법인케이알에이와함께하는농어촌희망재단',
      Col2: '농식품인재장학금',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '자연계열/특정학과',
      Col9: '직전학기 성적 백분율 80점 이상/ 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '학기당 2500000원 범위내에서 등록금 전액 ',
      Col12: '농업계때학 농식품계열학과 및 비농업계대학 재학생으로 일반대 3학년 이상(진학예정자 포함)/ 전문대 1학년 2학기 이상 및 전공심화과정 재학생 포함 * 지원대상 대학·학과는 선발안내서 참고',
      Col13: '해당없음',
      Col14: '2022-06-21~2022-07-07',
      Col15: '신청 → 대학교 추천 → 서류심사 → 보증보험가입 → 최종선발',
      Col16: '해당없음',
      Col17: '전문대 제외/ 복수전공자 제외정규학기만 지원타 장학금과 중복수혜 불가능만 40세 초과자',
      Col18: '학교 추천 필요',
      Col19: '농업인 증명서(해당자/ 본인 또는 부모의 농업인 증빙서류 원본)부모정보제공동의서(해당자)가족관계증명서소득분위증명서진로계획서(신규 신청자에 한함)매학기 영농활동 실적보고서(선발 이후 제출)영농실적보고서(해당자)영농계획서(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인케이알에이와함께하는농어촌희망재단',
      Col2: '수산후계장학생',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '특정학과',
      Col9: '직전학기 평점 80점 이상(정규학기 기준/ F학점 포함 성적)/ 12학점 이상 이수자 * 단/ 정규학기 졸업예정자(4학년)의 경우 3학점 이상 이수자 * 편입자는 편입된 학교의 이수학점 및 성적이 있는 경우에만 신청가능 * 복학예정자의 경우 마지막 성적 및 이수학점 적용',
      Col10: '해당없음',
      Col11: '한 학기당 2500000원',
      Col12: '해양수산계열 대학이 있는 해양수산계열 학과 재학생(첨부파일 참조) * 부모 또는 본인의 어업종사 여부와 관계 없이 신청 가능하나 우대 * 복학예정자 신청가능(단/ 마지막 학기 장학금 미수혜자(등록금 미등록자)에 한해 복학예정일이 명시된 재적증명서 제출 시 신청 가능)',
      Col13: '해당없음',
      Col14: '2022-06-21~2022-07-07',
      Col15: '정량지표와 계획서 평가 고등점자 우선순위로 선발',
      Col16: '해당없음',
      Col17: '타학과 소속 해양수산계열 복수전공자정규학기 초과자/ 전액장학생',
      Col18: '해당없음',
      Col19: ' * 신규신청자재학증명서 원본   * 선택서류부모(또는 본인) 어업인 증빙서류 원본가족관계증명서 원본성적 증명서  * 기존신청자재학증명서 원본 * 자세한 사항은 홈페이지 참고 필수수'
    },
    {
      Col1: '재단법인케이알에이와함께하는농어촌희망재단',
      Col2: '농업인자녀장학금',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 백분율 80점 이상/ 12학점 이상 이수자 (정규학기 기준/ F학점 포함 성적) * 단/ 정규학기 졸업예정자(4학년)의 경우 3학점 이상 이수자 * 소득분위 기초~3분위 대상자는 신규장학생으로 선발된 학기 포함 누적 2개 학기까지 백분위기준 70점 이상 신청가능',
      Col10: '소득분위 기초(0분위)~6분위만 신청가능',
      Col11: '1인당 학기별 학자금 지원구간에 따라 차등 지급',
      Col12: '농어업인의 자녀로서 부모의 농업인 증빙서류를 발행 가능한 대학생',
      Col13: '해당없음',
      Col14: '2022-06-21~2022-07-07',
      Col15: '학교별 배정인원 범위 내에서 정량지표 고득점자 우선순위로 선발',
      Col16: '학기당 1/300명 내외',
      Col17: '정규학기 초과자·전액장학생장학금 지원배정 제외대학 제외기혼자 선발제외중복수혜자 교내/외 장학금과 재단 장학금 합계가 등록금을 초과한 경우 반납본인이 농업인 신청불가소득분위 없는 경우 탈락 처리',
      Col18: '해당없음',
      Col19: '부모 농업인 증빙서류 원본 1부가족관계증명서 원본 1부소득분위 통지서 원본 1부개인정보 수집·이용 및 제3자 제공 동의서(부모) * 자세한 사항은 홈페이지 참조'
    },
    {
      Col1: '재단법인케이알에이와함께하는농어촌희망재단',
      Col2: '청년창업농육성장학금',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 70점 이상/ 12학점 이상 이수자 * 졸업학기 학생은 직전학기 최소 이수학점 적용 예외 인정/ 그 외 자세한 사항은 홈페이지 참고고',
      Col10: '해당없음',
      Col11: '등록금 전액 + 학업장려금 2500000원( * 타 장학금을 이미 수혜받은 경우 등록금 범위 내에서 그 금액을 제외하고 지원) ※선발된 학생 중 우수장학생 대상 연수 지원',
      Col12: ' * 일반대 3학년 이상/ 전문대 1학년 2학기 이상인 자(농과대) 농업계 대학 중 농식품계열 학과(비농과대) 농과대를 제외한 나머지 대학 재학생지원조건: 졸업 후 장학금 혜택을 받은 횟수에 해당하는 기간만큼 영농 및 농림축산식품 분야에 취업 똔느 창업하여 의무종사 ',
      Col13: '해당없음',
      Col14: '2022-03-25~2022-04-07',
      Col15: '정량평가 및 정성평가 점수를 종합하여 고득점자 순으로 선발발',
      Col16: '100명 내외 ',
      Col17: '타 장학금 받은 경우 등록금 범위 내에서 제외하고 지원만 40세 이상인 자제적/ 자퇴/ 편입/ 징계/ 미등록 등으로 학적이 변동된 경우 자격상실',
      Col18: '해당없음',
      Col19: '(농업활동실적) 영농활동 및 인턴십 등 농업 관련 경험 증빙 서류/ 농업 관련 보유 자격증 사본(영농기반 여부) 부모 또는 본인 농업인 증빙 서류개인 정보 수집·이용 및 제3자 제공 동의서(부모)(해당자)(소득분위) 소득분위 통지서취창업계획서(인터넷 작성) * 재단 홈페이지에서 신청으로 자세한 사항은 홈페이지 참조'
    },
    {
      Col1: '서울장학재단',
      Col2: '청춘Start장학금',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '기초생활수급자 차상위계층 혹은 시설(보육원 쉼터 그룹홈)생활 학생으로서 주민센터 및 복지시설에서 증빙서류 발급이 가능한 자',
      Col11: '1학년 3000000원 지급 후 2학년 진학 시 2000000원 지속지원 검토  ※ 학업장려금 (타 장학금과 중복수혜 가능)',
      Col12: ' * 아래 항목을 모두 충족해야 함대한민국 국적자로 21년도 12월~ 22년도 2월 고교 졸업 후 서울소재 대학교 신입생2022년 서울소재대학 1학년 1학기 신입생소득요건 만족',
      Col13: '해당없음',
      Col14: '2022-03-14~2022-03-24',
      Col15: '1차 적격심사2차 서류심사3차 면접심사4차 장학생선정위원회의 종합심의 * 심사항목은 첨부파일 참고',
      Col16: '20명',
      Col17: ' * 자세한 사항은 홈페이지 및 첨부파일 공고문 참조',
      Col18: '고교시설 지도교사/ 복지시설교사 추천서',
      Col19: '온라인 신청서 출력본신청자 체크리스트자기소개서/서약서추천서고교졸업증명서대학 재학증명서가족관계증명서(해당자) * 선택서류(가정형편증빙서류)기초생활수급자 확인서자활근로확인서장애수당 대상자 확인서의료급여대상자법정한부모가족확인서우선돌봄차상위확인서차상위본인부담경감대상자증명서시설거주(이력)확인서※ 자세한 사항 홈페이지 및 첨부파일 확인 바람'
    },
    {
      Col1: '서울장학재단',
      Col2: '서울희망 공익인재 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원/학기 (학업장려금)',
      Col12: '서울지역 4년제 대학교 및 전문대학의 정규학기 학부생(방송통신대/ 사이버대/ 기능대/ 기술대 제외)최근 3년이내 사회공익공야에 지속해서 참여한 경험이 있는 학생공익적 이슈 주제로 1년 간 장학생과 프로젝트를 직접 기획/ 실행하며 사회문제를 공동으로 해결하고 사회적 가치를 확산하려는 열정과 도전정신을 지닌 학생',
      Col13: '대한민국 국적자로서 서울소재대학교 또는 서울시민의 자녀 이면서 타 시도에 소재하는 대학교의 학생',
      Col14: '2021-11-08~2021-11-16',
      Col15: '서류심사> 면접심사> 장학생 선정위원회',
      Col16: '총 60명 ',
      Col17: '이중지원제한 대상 장학금으로/ 등록금 초과하여 수혜불가21년 1학기 기준 신입생/ 정규학기 마지막 학기/ 초과학기 학생 제외(단 / 휴학생은 20년 프로젝트 참여가 가능한 경우 신청 가능) * 자세한 사항은 공고문 및 첨부자료 참고',
      Col18: '해당없음',
      Col19: ' * 필수서류온라인 신청서신청자 체크리스트공익활동 실적/ 자기소개서재학 또는 재적(휴학)증명서/ 성적증명서공익활동 증빙서류(택1)   * 추가서류(해당자)기초생활수급자 / 법정 차상위계층 증명서 가족관계증명서  * 자세한 사항은 첨부자료 또는 서울장학재단 장학게시판 참고 ** 재단홈페이지에서 신청'
    },
    {
      Col1: '서울장학재단',
      Col2: '유영아학업장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' 최근 두학기(정규학기)간 백분위 점수 향상자 * 두학기 모두 P/F학점을 제외하고 12학점 이상 이수한 자 * 전체학기 백분위 점수 75점 이상인 자 * 직직전학기의 백분위 점수 75점 이상인 자',
      Col10: '기초생활수급자 법정차상위계층인 학생  (주민센터에서 확인서를 발급하여 증빙서류 제출이 가능한자)',
      Col11: '2000000원씩 2회지급 ',
      Col12: '2021년 2학기 서울소재 4년제 대학 재학생성적증명서상 최근 두학기(정규학기)간 백분위 점수 향상자',
      Col13: '해당없음',
      Col14: '2022-04-29~2022-05-11',
      Col15: '해당없음',
      Col16: '12명',
      Col17: ' * 장학금 수혜기간 중 자퇴/ 퇴학 등 학적변동 발생 시 장학금 지급 중단 * 현재 1학년/ 졸업예정자/ 휴학생/ 정규학기 초과자 신청 불가',
      Col18: '해당없음',
      Col19: '* 공통 제출서류온라인 신청서 출력본 신청자 체크리스트 신청서&자기소개서재학증명서성적증명서* 해당자 선택 제출서류기초생활수급자 확인서자활근로확인서장애연금/ 수당/ 장애아동수급자 확인서한부모가족확인서차상위계층 확인서*온라인 접수 후 서류 우편접수 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '서울장학재단',
      Col2: '서울희망대학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: ' * 아래 사항중 하나에 해당하는 자기초생활수급자법정차상위계층20221학기 한국장학재단 소득 0~4분위',
      Col11: '학기당 500000원 / 1000000원 / 1500000원 (등록금 범위 내 정액 지원)',
      Col12: ' * 대한민국 국적자로서 아래 항목 모두 충족하는 자서울소재 대학교 정규학기 재학생 또는 서울 시민 중 비서울 소재 대학교 정기학기 재학생기초생활수급자 또는 법정차상위계층 또는 한국장학재단 소득분위 4분위 이하20221학기 등록금 실납입액이 50만원 이상인 자',
      Col13: ' * 아래사항에 해당하는 자서울소재 대학교 재학생서울시민중 비서울 소재 대학교 정규학기 재학생',
      Col14: '2021-05-17~2021-05-18',
      Col15: '1차 재단 심사2차 장학생 선정위원회 심사 ※ 심사기준 및 결격사유는 첨부파일 참고',
      Col16: '1/486명 내외',
      Col17: '비지원 대상 학교 재학생 및 대학원생휴학/ 제적/ 자퇴 또는 초과학기생(21년 2학기 기준)',
      Col18: '해당없음',
      Col19: '온라인 신청서소득증빙서류주민등록등본가족관계증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '서울장학재단',
      Col2: '소상공인 디딤돌장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열',
      Col9: '해당없음',
      Col10: '기초생활수급자법정차상위계층소득금액증명원상 소상공인의 19년도 소득이 35백만원 이하인 자',
      Col11: '1000000원',
      Col12: ' * 서울 시민 또는 서울 시민의 자녀로 소상공인 가정의 대학생으로 아래 해당자재기 희망 소상공인 가정폐업 위기 소상공인 가정저소득 소상공인 가정 * 자세한 사항은 첨부파일 참조',
      Col13: '공고일 현재 기준으로 서울시에 거주하는 자',
      Col14: '2022-03-21~2022-04-01',
      Col15: '기초생활수급자/ 차상위계층/ 소득금액 35백만원 이하 중 저소득 순으로 우선선발',
      Col16: '150명',
      Col17: '선발연도 서울장학재단 긴급학자금 중복수혜 불가(서울희망SOS장학금)한 가정 내 한 자녀만 지원 가능',
      Col18: '해당없음',
      Col19: '신청서주민등록등본가족관계증명서재학 또는 휴학 증명서소득 증빙서류(수급자증명서/ 차상위계층 확인서 / 소득금액 증명원 ) * 서울신용보증재단 자영업지원센터 사업기획팀 우편 또는 방문 접수/ 자세한 사항은 첨부파일 참조 '
    },
    {
      Col1: '서울장학재단',
      Col2: '서울 우수인재 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적증명서상 전체학기 평점평균의 백분위 성적이 87점 이상인 자',
      Col10: '기초생활수급자 또는 법정차상위계층',
      Col11: '연간 4000000원 (2000000원 2회 지급)',
      Col12: '전공 분야에 재능과 학업 의지를 가진 저소득 가정의 학생대한민국 국적자로/ 2022년 1학기 현재 서울 소재 4년제 대학교 3/4학년 재학생본업의 전공 분야에 대한 학업 의지가 강하며/ 소속 학과 교수(전임교원)의 추천을 받은 자선발 후 장학생 프로그램에 적극적으로 참여할 수 있는 자',
      Col13: '대한민국 국적자로/ 2022년 1학기 현재 서울 소재 4년제 대학교 3/4학년 재학생',
      Col14: '2022-05-02~2022-05-20',
      Col15: '1단계 분야별 신청 비율에 따라 선발인원 배분2단계 성적심사 (고득점자순)3단계 서류심사 (전공 역량 개발 의지(30) / 진로목표 및 계획의 적정성(30)/ 장학금 사용계획의 타당성(20) / 미래성장가능성(20))4단계 선정위원회의 검토 후 최종선발 * 장학생 OT 필참. 자세한 내용 첨부파일 참조',
      Col16: '100명 (변경될 수 있음)',
      Col17: '2022년 1학기 현재 마지막 정규학기(8학기) 재학생·초과학기생·휴학생 및 타 대학에서 편입하여 현재 대학에서의 정규학기 성적이 없는 학생은 신청 불가2022년도 서울장학재단의 타 학업장려금 지원사업의 장학생으로 선정된 자2021년도 서울장학재단의 타 학업장려금 지원사업의 장학생으로 선정되어 2022년까지 계속 지원을 받는 자',
      Col18: '소속 학과 교수(전임교원)의 추천 필요',
      Col19: '온라인 신청서신청자 체크리스트신청인 서약서 & 자기소개서소속 학과 교수 추천서재학증명서성적증명서경제상황증빙서류 (첨부파일 및 홈페이지에서 확인)가족관계 증명서 ( 경제상황 증빙서류를 가족 명의의 서류로 제출한 경우만 제출 )'
    },
    {
      Col1: '서울장학재단',
      Col2: '서울희망SOS장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '보건복지부 긴급복지지원대상 가구의 자녀 / 서울형 긴급복지지원 가구의 자녀기초생활수급자 가구의 자녀법정차상위계층 가구의 자녀복지사각지대 가구의 자녀',
      Col11: '1000000원 (일회성)  학업장려금',
      Col12: '경제 상황이 어려운 가정의 자녀로서/ 소속 자치구의 추천을 받은 자  * 첨부된 파일 또는 홈페이지 참고',
      Col13: '서울시민 또는 서울시민의 자녀로 대학교 재학·휴학·재적 중인 자',
      Col14: '2022-04-29~2022-05-11',
      Col15: ' * 장학생 선정위원회 심의기준신청유형 > 취약가정 > 자녀수 > 선정위원회 심의신청유형 : 유형1(보건복지부>서울형) > 유형2(수급자>차상위) > 유형3(복지사각지대)자녀수 : 자녀수가 많은 가구',
      Col16: '총 102명 (자치구별 추천인원 4명/ 후보인원 2명)',
      Col17: '중·고·대학교 미소속자 지원 불가(제적/ 자퇴/ 졸업 등)보다 많은 긴급위기가구 지원을 위해 한 가구당 연1회로 지원 제한선발연도 내 서울장학재단의 긴급학자금 중복 수혜 불가가 * 자세한 사항은 첨부파일 참조',
      Col18: '소속 자치구의 추천으로 선발되는 장학금',
      Col19: '신청서주민등록등본가족관계증명서재학 혹은 휴학증명서개인정보활용동의서긴급복지지원자 대상 증빙서류 또는 경제상황 증빙서류추천서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '서울장학재단',
      Col2: '독립유공자 후손 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '연간 3000000원(1500000원/학기 분할지급) * 등록금 장학금 중복수혜 가능',
      Col12: '독립유공자의 중손자녀 이하(4대~6대) 후손인 서울소재 대학 재학생 또는 서울시민(의 자녀)인 비서울대학 재학생생',
      Col13: '서울소재 대학 재학생이거나 서울 시민 또는 서울시민의 자녀인 비서울대학 재학생',
      Col14: '2021-03-08~2021-03-19',
      Col15: '1단계 적격검사2단계 서류심사3단계 장학생 선정위원회의 종합 심의 후 최종 발표',
      Col16: '총 100명',
      Col17: '정규학기 재학생만 가능',
      Col18: '해당없음',
      Col19: '온라인 신청내역신청자 체크리스트재학(재적)증명서독립유공자 유족확인원 가족관계 증명서자기소개서성적증명서 (2~4학년 학생만 제출)경제상황증빙서류 택 1(수급자 증명서 또는 소득구간 확인서)제적등본 (유족확인원과 가족관계증명서를 통해 가족임이 확인 어려울 시)주민등록등본(비서울 대학 지원자 필수) * 자세한 사항 홈페이지 및 첨부파일 참고 필수'
    },
    {
      Col1: '서울장학재단',
      Col2: '희망플러스 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학4학기/대학6학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체학기 평점 평균의 백분위(백분율) 성적 80점 이상인 자',
      Col10: '기초생활수급자 또는 법정차상위계층으로 증빙서류 발급이 가능한 자',
      Col11: '1500000원 (2회 분할 지원) * 학업장려금',
      Col12: '서울 소재 대학교 학부생 또는 서울 시민(의 자녀)이면서 비서울 소재 대학교 학부생 중 2021년 1학기 기준 마지막 정규학기 재학생으로서 기초생활수급자/ 법정차상위계층인 자',
      Col13: ' * 대한민국 국적자로서 아래 해당자서울 소재 대학교 재학생서울 시민 중 비서울 소재 대학교 재학생',
      Col14: '2020-10-01~2020-10-31',
      Col15: '해당없음',
      Col16: '285명',
      Col17: '정규학기 초과자신청년도 서울장학재단의 타 학업장려금 지원사업의 장학생 선정자직전년도 서울장학재단의 타 학업장려금 지원사업의 장학생으로 선정되어 신청년도까지 계속 지원을 받는 자대학원생  * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '온라인 신청서신청자 체크리스트성적증명서(학교 직인 필수)경제상황 증빙서류주민등록등본(비서울 소재 대학교 학생만 제출) 가족관계증명서(해당자) * 양식 다운로드 및 자세한 사항은 첨부파일 또는 기관 홈페이지 참조'
    },
    {
      Col1: '대전광역시청',
      Col2: '학자금대출 이자지원 사업',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소득분위 상관없음',
      Col11: '20년도 발생 본인부담 이자 * 개인별 은행계좌로 입금하지 않음',
      Col12: '2017년 ~ 2019년 재학(휴학)기간 중 한국장학재단에서 학자금 대출을 받은 관내·외 대학 재학(휴학)생',
      Col13: '신청일 현재 대전광역시에 주민등록이 되어있고 대전광역시 소재 대학 재학생신청일 현재 직계존속이 1년 이상 대전광역시에 주민등록이 되어있고 대전광역시 외에 소재한 대학 재학(휴학)생',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '예산 초과시 다자녀 가구 > 저소득 분위 > 고학년 순으로 지원',
      Col16: '해당없음',
      Col17: '졸업생대학원생한국장학재단 대출자료 추출일 기준 완제자 지원불가타 지자체와 중복신청 불가 * 자세한 사항은 기관으로 문의 ',
      Col18: '해당없음',
      Col19: '재학(휴학)증명서본인 또는 부모의 주민등록초본가족관계증명서 * 온라인 신청/ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '대전기독교종합사회복지관',
      Col2: '라애시덕장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적우수자자',
      Col10: '저소득층',
      Col11: '500000원',
      Col12: '대전소재 대학교 또는 대학원에 재학생 중 외국인 유학생 또는 선교사 자녀',
      Col13: '공고일 현재기준으로 대전에 주소를 두고 있는 자',
      Col14: '2022-07-04~2022-07-08',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서자기 추천서서재학증명서 1부성적증명서 1부관련 단체장 및 학과장 추천서 1부(해당자에 한함)'
    },
    {
      Col1: '(재)남정장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 B+ 이상인 자  ※ 4.5점 만점 기준 3.5 이상',
      Col10: '해당없음',
      Col11: '2500000원(매학기)',
      Col12: '대한민국 국적을 가진 자로 2022년도 2학기 등록 예정 대학생국비 또는 타 장학금을 받고 있지 않거나 학비 면제자가 아닌 자',
      Col13: '해당없음',
      Col14: '2022-01-01~2022-01-14',
      Col15: '* 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 신청서 (남정장학재단 홈페이지 다운로드 가능)장학생 추천서 (남정장학재단 홈페이지 다운로드 가능)전 학년 성적증명서자기소개서주민등록등본 (부모님과 거주지가 다른경우 본인 및 부모님 각 1통씩)개인정보 수집 이용 동의서서약서가계 곤란 증명서류(해당자)기타서류(해당자) * 이 외에 자세한 내용은 한국외대 장학 공지 참고'
    },
    {
      Col1: '재단법인 케이알엑스국민행복재단',
      Col2: 'KRX드림장학생',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 정규학기 12학점 이상 이수 및 전체학기 성적 평균 백분위 70점 이상 (단/ 신입생은 첫 학기에 한해 성적 및 이수학점 기준 미적용)',
      Col10: '기초생활수급자 가정 학생소득구간 1~3분위 이하 ',
      Col11: ' * 지원금액학기당 1500000원 장학금(생활비)지원  * 지원기간2년 이내졸업까지 잔여학기 동안 지원(정규학기 내) * 지원시기학기별 분할 지급(3월/9월)2018년 신규선발 장학생은 19.3월부터 지원',
      Col12: '서울소재 대학 또는 전문대학에 재학 중인 1~3학년생 (전문대학은 졸업까지 잔여학기 2학기 이상)타 기관 장학금을 받지 않는 학생(장학금 중복수혜 금지)  (국가장학금 및 교내장학금(성적/ 근로장학금 등) 중복 수혜 가능)',
      Col13: '해당없음',
      Col14: '2022-08-25~2022-09-14',
      Col15: '1차 서류2차 면접최종합격자 ',
      Col16: '총40명 (서울 20명/ 부산 20명)',
      Col17: '방송대학/ 통신대학/ 방송통신대학 및 사이버대학은 제외 ',
      Col18: '담당교수 또는 학과장',
      Col19: ' * 공통서류장학생 지원서장학생 추천서(지도교수 또는 학과장)장학금 비수혜 확인서개인정보 수집 이용 동의서재학증명서 및 전체학기 성적증명서기초생활수급자증명서 1부(본인 또는 부모) * 우대사항해당자다문화 또는 다자녀가정 학생 : 가족관계증명서 1부아동보호시설 학생 : 시설수급증명서 1부 * 그 외 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '숭실대 동문장학회',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 3.0 이상 직전학기 15학점 이상 (최종직전학기 12학점 이상 이수)인 학생',
      Col10: '해당없음',
      Col11: ' * 장학재단 장학생 1유형 : 20222학기 수업료 반액 이내2유형 : 100만원 * 124시간 선물 장학금 : 125만원',
      Col12: '숭실대학교 재학생학교생활이 활동적이고 모범적이면서 리더십 있는 자숭실을 사랑하며 재학 중 및 졸업 후 총동문회 활동을 적극적으로 할 수 있는 자현재 사회봉사활동을 하고 있거나 사회봉사활동 경력이 있는 자20222학기 3/4학년 재학생',
      Col13: '해당없음',
      Col14: '2022-07-01~2022-07-18',
      Col15: '1차 : 서류심사2차 : 면접',
      Col16: '총 35명 내외',
      Col17: '해당없음',
      Col18: '학과장 또는 지도교수 추천서',
      Col19: '장학생 지원서 자기소개서학과장 또는 지도교수 추천서성적증명서봉사활동 및 사회활동 증명서 (해당자) * 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '양천장학회',
      Col2: '일반장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전(全) 학년 각 학기 수강학점 16학점 이상평점학점 3.8 이상 (4.5만점)인 자',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '2학년 이상 재학 중인 자',
      Col13: '해당없음',
      Col14: '2022-07-01~2022-07-18',
      Col15: ' * 각 학교에서 학생추천 후 장학회에서 선발1차 : 서류심사2차 : 면접(서류심사 합격자에 한 함)',
      Col16: '해당없음',
      Col17: '장학금 수혜 2회 이상인 경우 1회 성적 미달 시 경고/ 2회 성적 미달 시 수혜 대상에서 제외군입대/ 휴학 및 유학예정자',
      Col18: ' * 학교 추천방식으로/ 각 대학 장학부서나 학생팀에 문의 필수',
      Col19: ' * 학교 추천방식으로/ 각 대학 장학부서나 학생팀에 문의 필수장학회 선발원서자기소개서학교장 또는 학장 추천서전학년 성적증명서재학증명서학업계획서전학기 등록금 영수증 사본타 장학회 장학금 수혜증서 또는 장학금 수혜확인서근로소득 원천징수 영수증가족관계 증명서 * 자세한 사항은 학교 홈페이지 공고 확인'
    },
    {
      Col1: '양천장학회',
      Col2: '면학장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전(全) 학년 각 학기 수강학점 16학점 이상평점학점 3.0 이상 (4.5만점)',
      Col10: '소득분위 등급 3분위 이하인 자에 한함',
      Col11: '해당없음',
      Col12: '2학년 이상 재학 중인 자',
      Col13: '해당없음',
      Col14: '2021-12-28~2022-01-11',
      Col15: ' * 각 학교에서 학생추천 후 장학회에서 선발1차 : 서류심사2차 : 면접(서류심사 합격자에 한 함)',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: ' * 학교 추천방식으로/ 각 학교 장학부서/ 학생팀에 문의 필수',
      Col19: '장학회 선발원서자기소개서학교장 또는 학장 추천서전학년 성적증명서재학증명서학업계획서전학기 등록금 영수증 사본타 장학회 장학금 수혜증서 또는 장학금 수혜확인서근로소득 원천징수 영수증가족관계 증명서  * 자세한 사항은 학교 홈페이지 공고 참고'
    },
    {
      Col1: '재단법인 성혜장학회',
      Col2: '학업우수장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적이 우수한 자',
      Col10: '해당없음',
      Col11: '생활비 지원 ',
      Col12: '전문대학이상의 대학에 재학 또는 입학예정인 학생학업 성적이 우수하고 품행이 타의 모범이 되는 학생 등록금을 전액 면제.지원받고 있지 않은 학생 ',
      Col13: '해당없음',
      Col14: '2021-12-28~2022-01-11',
      Col15: '(온라인)신청서 및 자기소개서 작성 /증빙서류 제출선발심사 및 결과통보면접최종합격자 선정',
      Col16: '00명 내외',
      Col17: '국가기관이나 지방자치단체/ 학교/ 기타 장학관련 단체로부터 명시적인 장학금으로 수업료 또는 등록금을 전액 면제/지원받고 있는 학생',
      Col18: '담당교수 이상 추천',
      Col19: '신청서 및 자기소개서 1부 및 개인정보수집동의서성적증명서재학증명서추천서(담당교수 이상)주민등록등본(반드시 주민번호 성별구분번호 제외한 나머지 삭제 후 제출)가족관계증명서세목별 과세(납세)증명서소득금액증명원건강보험료 납부확인서주택임대차계약서 사본(자가주택 이외) * 기타(해당자에 한함)국민기초생활수급자 증명서장애인증명서한부모가정증명서기타 * 자세한 사항은 홈페이지 공지사항 참고고'
    },
    {
      Col1: '재단법인 성혜장학회',
      Col2: '사랑복지장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정형편이 어려운 저소득층의 학생',
      Col11: '생활비 지원',
      Col12: '전문대학이상의 대학에 재학 또는 입학예정인 학생품행이 타의 모범이 되고 가정형편이 어려운 저소득층의 학생 ',
      Col13: '해당없음',
      Col14: '2021-02-23~2021-02-25',
      Col15: '선발심사면접심사',
      Col16: '00명',
      Col17: '국가기관이나 지방자치단체/ 학교/ 기타 장학관련 단체로부터 명시적인 장학금으로 수업료 또는 등록금을 전액 면제/지원받고 있는 학생',
      Col18: '담당교수 이상의 추천',
      Col19: '신청서 및 자기소개서 1부 (홈페이지)개인정보수집동의서성적증명서 1부재학증명서 1부추천서 1부담당교수 이상(교회 추천시 출석교회 담임목사님)주민등록등본 1부 (주의 : 제출할 경우 반드시 주민번호 뒷자리 성별구분 번호인 1/2를 제외한 나머지 번호 삭제 하여 제출 하시기 바랍니다)가족관계증명서 1부 (6번과 동일하게 제출 바랍니다) 세목별 과세(납세)증명서 (본인/부/모 각 1부) 소득금액증명원 1부건강보험료 납부확인서 1부 (기간 2015년~현재)주택임대차계약서 사본 1부(자가주택 이외) * 기타 제출 서류 (해당자에 한함) 국민기초생활보장 수급자 증명서 1부/ 장애인 증명서 1부/ 한부모가정증명서 1부/ 주택임대차계약서 사본 1부 (자가 주택 이외)/ 기타서류'
    },
    {
      Col1: '(재)성보장학회(서울)',
      Col2: '성보장학회장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 3.0이상(취득학점 12학점 이상)인 자',
      Col10: '경제적 사정이 어려워 학비보조가 필요한 자',
      Col11: '장학생 선발 후 별도 안내 * 본 장학금은 생활비지원명목',
      Col12: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.사회적취약층인 다문화 가정/탈북자 등 우대대학교 학부생(3~4학년)/ 대학원생(석사과정)20221학기 재학생 ',
      Col13: '해당없음',
      Col14: '2022-05-02~2022-05-13',
      Col15: '1차: 학교추천2차: 재단선발',
      Col16: '2명',
      Col17: '전액장학생 제외다른 장학금 또는 이와 유사한 학비감면 혜택 또는 보호자가 자녀학비보조 혜택을 받고 있는 자휴학/ 부분등록자 불가',
      Col18: '학교총(학)장 추천',
      Col19: '장학금수혜지원서(사진부착) 학장 추천서성적증명서(직전학기 포함)(세대원)재산세과세증명서 또는 바과세증명서가족관계증명서 * 학교추천방식으로/ 각 학교 장학부서에 문의 '
    },
    {
      Col1: '재단법인 신안군장학재단',
      Col2: '일반(저소득)장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활수급자 및 차상위계층의 자녀한부모 가정의 자녀새터민(북한이탈주민) 가정의 자녀장애인 또는 장애인가정의 자녀소득인정액 기준 중위소득 100% 이내의 건강보험료를 납부하는 가정의사상자의 자녀시설입소자 및 산업체 근로청소년조손가정의 자녀',
      Col11: '최대 1500000원 * 학업장려금 성격',
      Col12: '저소득 가정의 자녀',
      Col13: '본인 및 친권자가 공고일 현재 신안군에 1년 이상 주소를 두고 실제 거주하고 있는 자 (단/ 대학생은 학생 주소에 제한 없음음)',
      Col14: '2022-05-02~2022-05-13',
      Col15: '서류심사 후 (신청요건/ 선정기준 등) 재단 이사회 심의소득 평가 100%(경제적으로 어려운 저소득 계층을 우선적으로 선정)',
      Col16: '5명',
      Col17: '국가 등으로부터 학비 등을 지원받는 육사/ 해사/ 공사/ 경찰대생매학기 등록금 총액이 50만원 이하인 대학생정규 학제 기간을 초과해 재학중인자본 장학재단 내 종류별 중복 신청자/ 대학원생 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '해당없음',
      Col19: '장학금 신청서신청인 서약서개인정보 수집·이용 및 제공·조회 동의서주민등록 등본(본인/ 부/모 거주확인)재학증명서가족관계증명서통장사본(본인 또는 부/모)해당하는증명서 첨부(예시 : 기초생활수급증명서) * 해당증명서류 없는 경우건강보험납부확인서(부/모 모두)/ 건강보험득실확인서 제출 * 증명서류는 주민등록번호 뒷자리가 노출되지 않도록 제출 * 자세한 사항은 첨부자료 참고 * 접수처 : 읍/면 사무소'
    },
    {
      Col1: '재단법인 신안군장학재단',
      Col2: '다문화가정장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소득 평가 100%(경제적으로 어려운 저소득 계층을 우선적으로 선정)기준은 첨부파일 참고',
      Col11: '최대 3000000원',
      Col12: '다문화 가정의 자녀',
      Col13: '본인 및 친권자가 공고일 현재 신안군에 1년 이상 주소를 두고 실제 거주하고 있는 자 (단/ 대학생은 학생 주소에 제한 없음)',
      Col14: '2022-05-02~2022-05-13',
      Col15: '소득 평가 100%(경제적으로 어려운 저소득 계층을 우선적으로 선정)',
      Col16: '20명 (초/중/고/대 총합)',
      Col17: '국가 등으로부터 학비 등을 지원받는 육사/ 해사/ 공사/ 경찰대생매학기 등록금 총액이 50만원 이하인 대학생정규 학제 기간을 초과해 재학중인자본 장학재단 내 종류별 중복 신청자/ 대학원생 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '해당없음',
      Col19: '장학금 신청서신청인 서약서개인정보 수집·이용 및 제공·조회 동의서(본인/ 부/모)주민등록 등본 또는 가족관계증명서(본인/ 부/모 거주확인)가족관계증명서재학증명서통장사본 (본인 또는 부/모)혼인관계증명서(상세)건강보험납부확인서(부/모 모두/ 최근 3개월)건강보험득실확인서 * 증명서류는 본인 및 가족의 주민등록번호 뒷자리가 노출되지 않도록 가린 후 제출 * 접수처 : 읍·면사무소'
    },
    {
      Col1: '재단법인 신안군장학재단',
      Col2: '위기가정 긴급지원사업',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원 (이사장 결정 후 수시로 지급)',
      Col12: '군에서 위기가정 긴급지원 대상으로 확정한 가정 (「긴급복지지원법」제2조에 따른 위기상황이 발생한 가정)',
      Col13: '본인 및 친권자가 공고일 현재 신안군에 1년 이상 주소를 두고 실제 거주하고 있는 자 (단/ 대학생은 학생 주소에 제한 없음)',
      Col14: '2022-08-17',
      Col15: '군에서 위기가정 긴급지원 대상으로 확정한 가정에 한해 지원',
      Col16: '해당자 (선발인원은 예산범위내 탄력운영)',
      Col17: '국가 등으로부터 학비 등을 지원받는 육사/ 해사/ 공사/ 경찰대생매학기 등록금 총액이 50만원 이하인 대학생정규 학제 기간을 초과해 재학중인자본 장학재단 내 종류별 중복 신청자/ 대학원생 * 그 외 자세한 사항은 첨부자료 확인 필수',
      Col18: '해당없음',
      Col19: '장학금 신청서신청인 서약서개인정보 수집/ 이용 및 제공/ 조회 동의서주민등록 등본(본인/ 부/모 거주확인)재학증명서가족관계증명서서통장사본(본인 또는 부/모)위기가정 긴급지원 대상 증빙자료 * 증명서류는 주민번호 뒷자리를 노출되지 않도도록 제출 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '재단법인연당장학회',
      Col2: '연당장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '특정학과',
      Col9: '전체 및 직전 학기 성적 3.75이상',
      Col10: '가정형편이 어려운 학생 (한국장학재단 2022학년 2학기 소득분위 8분위 이내)',
      Col11: '2000000원',
      Col12: '2022학년도 2학기 재학 예정 학부생경영대학 학부생학업성적이 우수하고 모범적인 학생2022학년도 2학기 타 외부장학 미수혜자',
      Col13: '해당없음',
      Col14: '2022-02-23~2022-03-04',
      Col15: '해당없음',
      Col16: '00명',
      Col17: '해당없음',
      Col18: '학과장 추천',
      Col19: '장학생추천서자기소개서(자유서식)성적증명서개인정보 수집/ 이용/ 제공 동의서 * 각 학교 장학부서 공지 참고 필수'
    },
    {
      Col1: '(재)문봉장학회',
      Col2: '문봉장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학8학기이상',
      Col8: '의약계열/특정학과',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 전액/1년',
      Col12: '6학년 재학 예정인 이화여자대학교 약학대 학부 정규등록생성적우수자 가계곤란자',
      Col13: '해당없음',
      Col14: '2022-01-14~2022-02-10',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '타 장학금 수혜자 지원불가',
      Col18: '해당없음',
      Col19: '장학금 지급신청서지도교수 추천서주민등록등본 원본2021년 지방세 세목별(토지/주택/건물) 과세증명서 부·모 각1부건강보험증 사본 및 2021년 1~12월 건강보험료 납부확인서타 장학금 신청내역서 성적증명서재학증명서 * 자세한 사항은 이화여자대학교 약학대학 학과홈페이지 내 공고 참조'
    },
    {
      Col1: '숭덕육영회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 70% 이상인자',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '기숙사 공동생활 가능자정원의 10%(3명) 이내로 서울에 주소지가 있는 학생도 본 법인의 정신과 함께 할 수 있는 학생',
      Col13: '지방 출신 남학생으로 서울 소재 대학교에 재학 중인 학부생 또는 대학원생',
      Col14: '2022-03-02~2022-03-25',
      Col15: '해당없음',
      Col16: '남 35명 (기숙사 생활)',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '(재)제주평생교육장학진흥원',
      Col2: '재능장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 최대 1500000원',
      Col12: '국내/외 2년제이상 대학교의 학생으로 재학중인 자전국단위 이상의 문화/예술/체육/과학 등의 최근 3년(해당연도 포함) 이내 대회에서 3위 이내 입상자(중앙행정기관 또는 권위있는 기관 주최 행사)',
      Col13: '장학금 공고일 현재 신청인(본인) 또는 부모 중 한명이 제주도에 1년 이상 주소를 둔 자현재 학생 또는 그 보호자가 제주도내 주민등록이 되어 있는 자',
      Col14: '2022-03-02~2022-03-25',
      Col15: '대회규모(또는 권위) > 순위 > 수상 회수 순 * 장학생선발심사위원회에서 심의선발하여 결정',
      Col16: '35명 내외 (초/중/고생 및 대학생 포함한 인원)',
      Col17: '2021년도 인재육성장학금을 지원 받은 자2022년도 타 장학금 지원받은 자 및 타 법령에 따른 등록금을 지원 받은 자정학이상의 징계처분을 받았거나 휴학/ 그 밖의 사유로 1학기 이상 학업을 계속하지 아니한 자자격 및 선발기준에 미달하거나 위배되는 자그 밖에 지원을 하지 아니하는 것이 타당하다고 인정되는 자',
      Col18: '해당없음',
      Col19: '대회 입상 실적 1부 *공통장학금 신청서추천서 (교장 또는 학과장 필수 날인)재학증명서 및 등록금 납부 영수증주소이력이 포함된 본인과 부 또는 모의 주민등록초본 각 1부(총2부)가족관계증명서본인(또는 보호자) 명의의 통장사본성적증명서 1부개인정보 수집·이용·제3자 제공동의서 1부'
    },
    {
      Col1: '(재)제주평생교육장학진흥원',
      Col2: '특별장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 1명 최대 2000000원 (등록금 범위 내)',
      Col12: '농어촌(읍면)지역 고교 졸업생으로 대학교 입학 신입생',
      Col13: '장학금 공고일 현재 신청인(본인) 또는 부모 중 한명이 제주도에 1년 이상 주소를 둔 자',
      Col14: '2022-09-13~2022-09-27',
      Col15: '위원회에서 심의된 자 ',
      Col16: '10명 (대학신입생)',
      Col17: '2021년도 인재육성장학금을 지원 받은 자2022년도 타 장학금 지원받은 자 및 타 법령에 따른 등록금을 지원 받은 자정학이상의 징계처분을 받았거나 휴학/ 그 밖의 사유로 1학기 이상 학업을 계속하지 아니한 자자격 및 선발기준에 미달하거나 위배되는 자그 밖에 지원을 하지 아니하는 것이 타당하다고 인정되는 자',
      Col18: '제주특별자치도교육청(소속 학교장) 추천',
      Col19: '제주인재육성장학금 신청서제주인재육성장학생 추천서개인정보 수집·이용·제3자 제공 동의서학생 주민등록초본부 또는 모 주민등록초본재학증명서성적증명서가족관계증명서통장사본  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 경주시장학회',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점 3.6점 (2·3년제 대학 3.8점)이상 인 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '현재 대학 재학생으로 학장 또는 학과장이 추천한 자',
      Col13: '공고일 현재 1년 이상 경주시 관내 거주자(부모 또는 학생)',
      Col14: '2022-09-13~2022-09-27',
      Col15: '성적 50% + 생활정도 35%(재산세 본세) + 경주시 거주기간 15% * 자세한 사항은 첨부파일 참고',
      Col16: '423명',
      Col17: '정규 학제 기간을 초과하여 재학 중인 자공고일 현재 휴학 중 또는 예정이거나 / 정학/ 퇴학 등 징계처분 받은 자1세대 1명 신청 * 자세한 사항은 첨부파일 참조',
      Col18: '총장(단과대학장) 또는 읍면동장이 추천한 자 ( * 학부장/ 학과장 추천은 해당안됨)',
      Col19: '장학금 지원신청서개인(신용)정보 수집·이용·제공 및 조회 동의서재학증명서직전학기 성적증명서가족관계증명서주민등록초본재산세 (미)과세 증명서추가 증빙서류(해당자) * 자세한 사항은 첨부파일 참조 '
    },
    {
      Col1: '재단법인 경주시장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '과학 문화 예술/ 기능 분야에 뛰어난 재능을 발휘하여 최근 1년 이내 도 단위 이상 규모 대회에서 3위 이내 수상(입상)한 자 (2021.08.24. ~ 공고일 현재 기준 수상실적에 한함)체육분야 장학생은 경주시 체육회장이 추천한 자',
      Col13: '공고일 현재 1년이상 경주시 관내 거주자(부모 또는 자녀대학생)',
      Col14: '2021-09-27~2021-09-30',
      Col15: '대회 입상 선발기준(공공기관 > 해당단체 > 기타)동점일 경우 입상횟수/ 생활정도(재산세) 순',
      Col16: '총 27명 * 과학 문화 예술/ 기능 분야 18명 이내 * 체육분야 9명 이내',
      Col17: '정규 학제 기간을 초과하여 재학 중인 자공고일 현재 휴학 중 또는 예정이거나/ 정학/ 퇴학 등 징계처분 받은 자1세대 1인 신청',
      Col18: '총장(학장)이 추천한 자(학부장/ 학과장 추천은 해당안됨)체육분야 장학생 : 경주시 체육회장이 추천한 자',
      Col19: '장학금 지원신청서개인(신용)정보 수집·이용·제공 및 조회 동의서재학증명서가족관계증명서주민등록초본재산세 (미)과세 증명서각종 대회 입상 관련자료 (학교장/ 총학장/ 경주시체육회장 확인) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '금강장학회',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 1학기 학업성적 평균 B학점 (3.0이상 4.5만점 기준)이상',
      Col10: '부/모(또는 부양의무자) 연소득 금액 6천만원 이하인 학생부/모(또는 부양의무자) 연 재산세 납부액 1백만원 이하 인 학생',
      Col11: '3000000원(년)',
      Col12: '4년제 정규대학 2/3학년 재학생다른 장학재단에서 장학금을 받지 않는 학생',
      Col13: '부/모(또는 본인)의 원(본)적이나 주민등록지가 강원도인 학생',
      Col14: '2022-04-04~2022-04-15',
      Col15: '1차 서류심사2차 면접심사',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '재경시/군민회장 지역도민회장 강원도내시장/군수 중 1인 추천',
      Col19: '추천서(재경시/군민회장 지역도민회장 강원도내시장/군수 중 1인)가족관계증명서주민등록등본(부모 및 본인)중학교 또는 고등학교 졸업증명서대학 재학증명서성적증명서부/모(또는 부양의무자) 재산세 세목별과세(납세)증명서부/모(또는 부양의무자) 소득금약증명본인(환경)소개서아르바이트를 한 학생은 아르바이트증명서'
    },
    {
      Col1: '(재)충주시장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 : 수학능력 점수를 기준으로 상위득점자 * 재학생 : 직전학년 1/2학기 성적이 평균 3.5 학점 이상인 자로서 타 장학금을 받지 않은자',
      Col10: '해당없음',
      Col11: '일반대학생: 3000000원전문대학생: 2500000원',
      Col12: '해당없음',
      Col13: '관내 고등학교 졸업후 부모가 충주시 관내거주자로서 대학교(2년제포함)에 재학중인 학생 * 고등학교가 관내가 아닌 특목고교등일 경우 관내 중학교 출신도 가능',
      Col14: '2022-04-12~2022-05-03',
      Col15: '첨부파일 참조',
      Col16: '60명',
      Col17: '2021년도 본 장학회 장학금 수혜자충북인재양성재단 선정자(당해)사이버대학생해외 학교 재학중 및 교환학생휴학생 및 2022년 2학기 휴학예정자. 대학원생국적이 외국인 학생한국방송통신대학생/ 만학도육사/ 해사/ 공사/ 경찰대등에 재학중인 전액 국비지원을 받는자',
      Col18: '해당학교 총장 또는 단과(학부)대학장의 추천서(직인)',
      Col19: '장학생 추천서 (개인정보 수집·이용 동의서 포함)성적증명서 1부 (2·3·4학년 재학생)수학능력성적증명서 1부(1학년 신입생)재학증명서 1부장학금수혜증명서 (학교/한국장학재단) : 2020. 2학기 ~ 2021. 1학기 포함 1부주민등록 등본 1부 (부모와 거주지 다를 시 가족관계증명서 첨부)건강보험 납부확인서(미납부자는 자격득실확인서 제출) : 2020년도 부/모 각1부기초생활수급자/ 보훈가족/ 장애인(1/2급)자는 해당증명서 1부(대상자에 한함) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '현대차 정몽구 재단',
      Col2: '미래산업 인재 학부 장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/자연계열',
      Col9: '전체 학기 평점 3.7/4.5학점/ 3.5/4.3이상 ',
      Col10: '가구 중위소득 150%이하 (한국장학재단 소득구간: 7구간 이하)',
      Col11: '등록금 전액 및 학습지원비 1800000원(학기)국제 학술대회 장학금해외 진출 장학생 장학금온드림 글로벌 우수 장학금재단 장학생 네트워킹 프로그램',
      Col12: '선발일 기준 대한민국 국적 보유자로서 재단 지정 대학 2/3학년 재학생 및 2022년 2학기 복학 예정자 (재단 지정 대학은 첨부파일 또는 홈페이지 참조)선발분야 : 지능정보 기술 / 바이오헬스 / 에너지신산업',
      Col13: '해당없음',
      Col14: '2022-05-23~2022-06-22',
      Col15: '서류심사온라인 인적성 검사전공 면접인성 면접',
      Col16: '해당없음',
      Col17: '장학생 선발 이후 국가 장학금 및 타 기관의 학자금 대출 및 등록금 감면 형태의 모든 장학금 중복수혜 불가',
      Col18: '해당없음',
      Col19: '지원서/자기소개서가족관계증명서소득수준 심사 증빙서류성적증명서실적 증빙 자료 ＊자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '김제시청',
      Col2: '대학생학자금대출이자',
      Col3: '지자체',
      Col4: '학자금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2016년 이후 한국장학재단에서 받은 등록금 대출금액2022년 상반기분 발생이자 ※ 취업후상환 및 일반상환 학자금 / 생활비 대출 제외',
      Col12: '2016년부터 한국장학재단에서 취업후상환학자금 및 일반상환학자금 등록금을 대출받은 자',
      Col13: '공고일 기준 현재 부모 또는 학생이 김제시에 주민등록이 되어 있는 재학 대학생',
      Col14: '해당없음',
      Col15: '온라인 신청',
      Col16: '해당없음',
      Col17: '생활비 대출은 지원 불가다른 기관으로부터 학자금 대출이자 명목으로 장학금 또는 학자금 이자 전액을 지원받는 경우고등교육기관에서 제적된 경우지원 대학생이 대학교를 졸업한 경우대학원생/ 외국대학 재학생',
      Col18: '해당없음',
      Col19: '대학생 학자금 대출이자 지원신청서부모 또는 본인 주민등록 등본 또는 초본가족관계증명서개인정보 수집/ 이용 및 제3자 제공 조회 동의서 * 등/초본 제출시 주민등록번호 뒷자리는 보이지 않게 반드시 지우고 첨부 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '중원대학교',
      Col2: '고시장학금(A/B)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 계속수혜요건직전학기 12학점 이상 이수직전학기 성적이 과락(F)없이 2.75/4.5이상',
      Col10: '해당없음',
      Col11: 'A : 수업료 전액면제 (2년)B : 수업료 전액면제 (1년)',
      Col12: ' * 중원대학교 재학생 중 아래에 해당하는 시험에 최종 또는 1차 합격한 자(A) 최종합격 /  공무원 시험 7급 합격(B) 1차 합격 / 공무원 시험 9급 합격 · 국가고시(행정.입법.기술.지방고 등 · 공인회계사/ 군법무관/ 변리사/ 감정평가사/ 세무사/ 관세사',
      Col13: '해당없음',
      Col14: '2022-07-01~2022-07-29',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2회 이상 유지조건을 미충족할 경우 자격요건 상실한국장학재단 소득분위 확인할 수 없는 자',
      Col18: '해당없음',
      Col19: ' * 교내 장학금으로/ 자세한 사항 교내 홈페이지 참조교내장학금 신청서개인정보 활용동의서자격증 사본경찰공무원 [합격자명단/ 수험표/ 기타증명서(경찰학교 재학증명서)/ 재직증명서]/ 재직증명서 중 택 1]'
    },
    {
      Col1: '중원대학교',
      Col2: '교직원자녀장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '수업료 전액면제(4년) ( * 단 편입생은 2년간 수업료 전액 면제)※ 매 학기 신청 필요',
      Col12: ' * 중원대학교 재학생 및 복학생 ※ 1학기 신입생은 재학생으로 신청학교법인 대진교육재단 산하기관 임직원 및 교직원의 가족 ( * 가족범위 : 직계혈족/ 임직운 또는 교직원의 형제자매 및 그 자녀/ 임직원 또는 교직원의 배우자/ 배우자의 형제자매 또는 그 자녀)',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 교내 장학금으로/ 자세한 사항은 교내 홈페이지 참조교내장학금 신청서개인정보활용동의서 본인 및 학부모 각 1부재직증명서가족관계증명서'
    },
    {
      Col1: '중원대학교',
      Col2: '교내장학금(보훈/새터민)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 계속 수혜 요건직전학기 성적이 백분율 기준 70점 이상',
      Col10: '해당없음',
      Col11: '공통 : 등록금 전액면제(4년)',
      Col12: ' * 중원대학교 복학생·재학생으로 아래 해당자 (신규신청)보훈 : 국가보훈대상자 본인 및 자녀새터민 : 북한이탈주민 본인 및 자녀',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '국가장학금과 중복수혜 불가새터민 : 본인일 경우 연속 2회 성적기준 미달 시 자격요건 상실',
      Col18: '해당없음',
      Col19: ' * 교내 장학금으로/ 자세한 사항은 교내 홈페이지 참조교내장학금 신청서개인정보활용동의서교육지원대상자 증명서 또는 대학수업료 등 면제 대상자 증명서'
    },
    {
      Col1: '중원대학교',
      Col2: '한마음장학금(A/B)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 이상 이수/ 성적 2.75/4.5이상누적생활관 벌점 15점 미만',
      Col10: '해당없음',
      Col11: '수업료 30%감면(4년) (사후지급)※ 해당자는 매 학기 신청 필요',
      Col12: ' * 중원대학교 재학생/복학생 중 아래 해당자가족 2인 이상 재학 중인 자중 연소자 1인 : A가족 3인 이상 재학 중인 자중 연소자 2인 : B ( *가족인정범위 : 친형제/ 친자매/ 친남매/ 부자/ 모자/ 부녀/ 모녀/ 부부에 한함. )',
      Col13: '해당없음',
      Col14: '2021-01-04~2021-01-29',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2회 이상 유지조건을 미충족할 경우 자격요건 상실수업료 범위내에서 중복수혜가능정규학기 초과자한국장학재단 소득분위 미산정자',
      Col18: '해당없음',
      Col19: ' * 교내 장학금으로/ 자세한 사항은 교내 홈페이지 참조교내장학금 신청서개인정보 수집·이용 및 제공·조회 동의서 각 1부가족관계증명서 각1부'
    },
    {
      Col1: '중원대학교',
      Col2: '새희망장학금',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '15학점 이상 이수/ 과락(F)없이 성적이수 3.0/4.5이상',
      Col10: '기초생활수급자 또는 차상위계층 본인 또는 자녀',
      Col11: '입학금 전액 국가장학금을 제외한 잔여 수업료 전액 지급',
      Col12: ' * 중원대학교 재학생/복학생으로 기초생활수급자 또는 차상위계층 본인 또는 자녀',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '수업료 범위내에서 중복수혜가능. 단/ 나눔 장학금과 중복수혜 불가국가장학금 소득분위 미 산정자',
      Col18: '해당없음',
      Col19: '  * 교내 장학금으로/ 자세한 사항은 교내 홈페이지 참조.교내장학금 신청서개인정보활용동의서 본인 및 한 부모 각 1부기초생활수급자증명서 또는 차상위계층대상자 증명서'
    },
    {
      Col1: '중원대학교',
      Col2: '대진문화장학금(A/B)',
      Col3: '대학교',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' *계속수혜요건15학점이상 이수과락(F)없이3.0/4.5이상',
      Col10: '해당없음',
      Col11: '(A) : 수업료 30%감면(4년)(B) : 입학금 전액감면 및 수업료 100%감면(4년간)',
      Col12: ' * 중원대학교 재학생 및 복학생으로 아래 해당자(A) : 종단산하고등학교 졸업(예정)자(B) : 종단 도인 및 도인 자녀 ',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '2회 이상 유지조건을 미충족할 경우 자격 요건 상실글로벌인재육성장학금과 중복수혜 가능한국장학재단 소득분위 미산정자',
      Col18: '해당없음',
      Col19: ' * 교내 장학금으로/ 자세한 사항은 교내 홈페이지 참조교내장학금 신청서개인정보활용동의서 각 1부종단 산하 고등학교 졸업증명서 또는 종단 추천서'
    },
    {
      Col1: '충남대학교의학전문대학원',
      Col2: '충남대학교병원장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '의약계열',
      Col9: '성적(본인의 전 학년 성적)/ 수학계획 등을 종합적으로 반영',
      Col10: '해당없음',
      Col11: '3000000~5000000원 내외',
      Col12: '의과대학 및 의학전문대학원 재학생(졸업예정자 우대) 중 졸업 후 충남대학교병원 전공의 과정 또는 기초의학수련 과정에 지원하려는 학생기존 장학금 수혜자도 지원 가능하나/ 학기당 장학금은 당해 2학기 등록금 범위내에서 지급(등록금을 초과하여 지급하지 아니함)',
      Col13: '해당없음',
      Col14: '2022-05-19~2022-06-10',
      Col15: '신청기준에 적합한 학생 중 충남대학교 의학전문대학원 장학위원회의 심의를 거쳐 선발성적(본인의 전학년 성적)/ 수학계획 등을 종합적으로 반영',
      Col16: 'O명',
      Col17: '해당없음',
      Col18: '지도교수 또는 학년 담임교수 추천',
      Col19: '장학금 신청서지도교수 또는 학년 담임교수 추천서 (추천서는 밀봉하여 제출)개인정보활용동의서통장사본'
    },
    {
      Col1: '강북구청',
      Col2: '복지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: ' * 기초수급자 법정차상위계층 일반 저소득층의 자녀국민기초생활 보장 수급자법정차상위계층 : 법정 한부모가족 포함일반저소득층 : 가구 총 재산 5억원 이하이면서 기준중위소득 120%이하',
      Col11: '2000000원 (연 2회 분할지급)',
      Col12: ' * 공고일을 기준으로 강북구 관내에 계속하여 1년 이상 주민등록 주소지를 두고 있는 주민의 자녀로서 지원자격을 갖춘 자전국 소재 2년제 이상 대학 재학생학기당 본인 부담 등록금 100만원 이상인 자',
      Col13: '부/ 모/ 신청 학생 중 1명이 공고일을 기준으로 강북구 관내에 계속하여 1년 이상 주민등록 주소지를 두고 있어야 함',
      Col14: '2022-02-03~2022-02-18',
      Col15: '소득재산(50점)/ 성적(30점)/ 거주기간(10점)/ 가족 수(6점)/ 자녀 수(4점)',
      Col16: '21명',
      Col17: '휴학/ 제적/ 자퇴/ 졸업 등 학기 미동록자 지원 불가정규학기를 초과하여 등록하는 자 지원 불가 * 자세한 사항 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서재학증명서주민등록등본주민등록초본개인정보 수집·이용 및 제3자 제공 동의서[수급자/ 법정차상위계층] 해당 증명서[일반 저소득층] 재산소득증빙서류[재학생] 직전 학기 성적증명서[입학생] 고등학교 3학년 2학기 성적증명서학생통장사본[3인 이상 다자녀] 가족관계증명서 * 자세한 사항은 홈페이지새소식선발 공고 참고'
    },
    {
      Col1: '(재)논공효천장학회',
      Col2: '대학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학교 재학생 : 직전학기 성적이 C학점 이상 또는 총점의 70% 이상대학교 입학생 : 고등학교 최종학기 성적이 총점의 70% 이상 또는 전 학년 석차의 50% 이내이며/ 대학수학능력시험에 응시했을 경우 수학능력시험 점수가 5등급 이내 ',
      Col10: '경제적 이유로 수학이 곤란한 자',
      Col11: '대학교(4년제) : 3000000원대학교(2~3년제) : 2000000원',
      Col12: '해당없음',
      Col13: '달성군 농공읍에 주소를 3년 이상 계속 두고 거주하고 있거나/ 농공읍에 등록기준지를 두고 있는 읍민 또는 그의 자녀',
      Col14: '2022-02-03~2022-02-18',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '공고문 안내 확인 '
    },
    {
      Col1: '(재)논공효천장학회',
      Col2: '예/체능특기자',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '시도단위 대회에서 우승자나 전국 대회에서의 3위 이내의 입상자 또는 국가대표선수로 선발된 실적이 있는자',
      Col10: '해당없음',
      Col11: '대학교(4년제) : 3000000원대학교(2~3년제) : 2000000원',
      Col12: '해당없음',
      Col13: '선발 공고일 현재 대구시 달성군 논공읍에 등록기준지를 3년 이상 두고 있는 자 또는 논공읍에 주소를 3년 이상 계속 두고 있는 읍민과 그의 자녀',
      Col14: '2022-06-13~2022-07-11',
      Col15: '해당없음',
      Col16: '7명 내 선발 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '공고문 안내 확인 '
    },
    {
      Col1: '(재)한국고등교육재단',
      Col2: '해외유학장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/해외대학',
      Col7: '대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/사회계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '유학후보장학금 지급재단에서 운영하는 다양한 연수 프로그램 교육비 전액 지원해외유학 혹은 중국유학 장학생으로 전환 시 최대 5년간 유학 장학금 지원',
      Col12: '대한민국 국적 보유자(영주권자/ 이중국적자 지원 가능)국내외 4년제 대학 기 졸업자 및 졸업예정자국내외 대학원 재학생 및 기 졸업자2023년 9월 박사과정 입학 희망자재단 선발전형 일정 전체 참석 가능한 자선발된 후 1년간 재단 필수 연수 참여가 가능한 자선발분야: 사회·자연과학/인문/정보통신',
      Col13: '해당없음',
      Col14: '2020-02-18~2020-03-09',
      Col15: '(1차) 서류심사(2차) 선발시험(3차) 면접평가',
      Col16: '해당없음',
      Col17: '재단 장학상품 선발전형 중/ 부정행위로 시험자격이 정지 또는 무효로 된 날로부터 5년이 지나지 않은 사람해외여행에 결격사유가 있는 사람재단 해외유학후보 기 수혜자국가장학금 및 국내 타 장학재단으로부터 장학금 수혜를 받는 자',
      Col18: '지도교수 추천서 제출 필수',
      Col19: '추천서기본사항 및 학력사항외국어 능력경력사항학업계획 * 홈페이지 온라인 접수로/ 자세한 사항은 홈페이지 참조'
    },
    {
      Col1: '(재)한국고등교육재단',
      Col2: '동양학연구장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '사회계열/인문계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금과 생활비를 포함하는 전액장학금박사과정 수료 시까지',
      Col12: '대한민국 국민으로 국내대학원에 재학 중이거나 3월 입학 예정자로 국내 박사학위를 취득하려는 자학부 이상 과정에서 해외 유학 경험이 없는 자 (교환학생 경험자는 지원가능)인문과학/ 사회과학분야 중 동양학 관련 분야 ',
      Col13: '해당없음',
      Col14: '2020-02-18~2020-03-09',
      Col15: '1차 : 필기(영어/ 한문)2차 : 면접 필기시험 합격자에 한함',
      Col16: '해당없음',
      Col17: '외국국적보유자/ 외국시민권자 및 영주권자는 지원불가',
      Col18: '지도교수 추천 * 지도교수가 아직 정해지지 않았거나 본인을 잘 알지 못하는 상황일 때에는 본인을 가장 잘 아는 교수에게 받을 수 있음.',
      Col19: '지원서 : 홈페이지 접수교수추천서 : 홈페이지 접수증빙서류온라인 지원서 (인터넷으로 지원서 최종제출 후 출력)학부 및 대학원 성적증명서 원본  * 대학원 성적증명서는 해당자만 제출  * 편입생의 경우/ 모든 전적대학 성적증명서를 제출해야 함  * 교환학생 성적의 경우 본 학교 성적표에 기 표기시 제출하지 않아도 됨저서 및 연구논문 (해당자만)  * 단행본/ 학술지 등 출판된 연구논문의 표지부분만 제출 (저자/ 제목 및 학술지명/ 초록)  * 단/ 학사 및 석사 학위논문은 제출대상 아님'
    },
    {
      Col1: '(재)한국고등교육재단',
      Col2: '정보통신대학원장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금과 생활비를 포함하는 전액장학금박사과정 수료 시까지',
      Col12: '대한민국 국민으로 국내 4년제 대학 2학년 또는 3학년 1학기에 재학중인 자(3월 기준)학부 이상 과정에서 해외 유학 경험이 없는 자 (교환학생 경험자는 지원가능)전기전자전파공학/ 컴퓨터공학',
      Col13: '해당없음',
      Col14: '2020-02-18~2020-03-09',
      Col15: ' 1차 : 필기(영어/ 전공)2차 : 면접 필기시험 합격자에 한함',
      Col16: '해당없음',
      Col17: '외국국적보유자/ 외국시민권자 및 영주권자는 지원불가',
      Col18: '지도교수 추천 * 지도교수가 아직 정해지지 않았거나 본인을 잘 알지 못하는 상황일 때에는 본인을 가장 잘 아는 교수에게 받을 수 있음.',
      Col19: '지원서 : 홈페이지 접수교수추천서 : 홈페이지 접수증빙서류온라인 지원서 (인터넷으로 지원서 최종제출 후 출력)학부 및 대학원 성적증명서 원본  * 대학원 성적증명서는 해당자만 제출  * 편입생의 경우/ 모든 전적대학 성적증명서를 제출해야 함  * 교환학생 성적의 경우 본 학교 성적표에 기 표기시 제출하지 않아도 됨저서 및 연구논문 (해당자만)  * 단행본/ 학술지 등 출판된 연구논문의 표지부분만 제출 (저자/ 제목 및 학술지명/ 초록)  * 단/ 학사 및 석사 학위논문은 제출대상 아님'
    },
    {
      Col1: '(재)한국고등교육재단',
      Col2: '대학특별장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기',
      Col8: '공학계열/사회계열/인문계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '재단에서 실시하는 영어 전공 등의 연수를 지원대학 졸업 시까지 매월 소정의 장학금을 지급',
      Col12: '대한민국 국민으로 국내 4년제 대학 2학년 또는 3학년 1학기에 재학중인 자(3월 기준)학부 이상 과정에서 해외 유학 경험이 없는 자 (교환학생 경험자는 지원가능) * 사회과학분야 경제학/ 경영학/ 행정학/ 정치외교학/ 신문방송(언론정보)학/ 심리학/ 인류학/ 사회복지학/ 법학/ 사회학/ 교육학/ 지리학  * 자연과학분야물리학/ 수학/ 화학/ 생명과학/ 통계학 * 정보통신분야전기전자전파공학/ 컴퓨터공학 * 인문과학분야사학/ 철학',
      Col13: '해당없음',
      Col14: '2020-02-18~2020-03-09',
      Col15: '1차 : 필기(영어/ 전공/ 수학)2차 : 면접필기시험 합격자에 한함',
      Col16: '해당없음',
      Col17: '외국국적보유자/ 외국시민권자 및 영주권자는 지원불가',
      Col18: '지도교수 추천 * 지도교수가 아직 정해지지 않았거나 본인을 잘 알지 못하는 상황일 때에는 본인을 가장 잘 아는 교수에게 받을 수 있음.',
      Col19: '지원서 : 홈페이지 접수교수추천서 : 홈페이지 접수증빙서류온라인 지원서 (인터넷으로 지원서 최종제출 후 출력)학부 성적증명서 원본   * 편입생의 경우/ 모든 전적대학 성적증명서를 제출해야 함  * 교환학생 성적의 경우 본 학교 성적표에 기 표기시 제출하지 않아도 됨사회봉사활동 확인서 (대학교 입학 이후의 봉사활동 내역만 제출)'
    },
    {
      Col1: '(재)한국고등교육재단',
      Col2: '한학연수장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기',
      Col8: '사회계열/인문계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한학연수 장학생은 매주 3일 이내 사서삼경을 주요과목으로 하는 3년 과정의 한학 교육을 이수하고연수기간 약 3년 동안 매월 소정의 장학금을 지급받는다.',
      Col12: '대한민국 국민으로 국내대학원에 재학 중이거나 3월 입학 예정자로 국내 박사학위를 취득하려는 자학부 이상 과정에서 해외 유학 경험이 없는 자 (교환학생 경험자는 지원가능)인문과학/ 사회과학분야 중 동양학 관련 분야 ',
      Col13: '해당없음',
      Col14: '2022-06-13~2022-07-11',
      Col15: '1. 1차 : 필기(영어/ 논술/ 한문)2. 2차 : 면접(필기시험 합격자에 한함)',
      Col16: '해당없음',
      Col17: '외국국적보유자/ 외국시민권자 및 영주권자는 지원불가',
      Col18: '지도교수 추천 * 지도교수가 아직 정해지지 않았거나 본인을 잘 알지 못하는 상황일 때에는 본인을 가장 잘 아는 교수에게 받을 수 있음.',
      Col19: '1.지원서 : 홈페이지 접수2.교수추천서 : 홈페이지 접수3.증빙서류온라인 지원서 (인터넷으로 지원서 최종제출 후 출력)학부 성적증명서 원본   * 편입생의 경우/ 모든 전적대학 성적증명서를 제출해야 함  * 교환학생 성적의 경우 본 학교 성적표에 기 표기시 제출하지 않아도 됨사회봉사활동 확인서 (대학교 입학 이후의 봉사활동 내역만 제출)'
    },
    {
      Col1: '(재)한국고등교육재단',
      Col2: '중국유학장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '사회계열/인문계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '유학후보장학금 지급재단에서 운영하는 다양한 연수프로그램 교육비 전액 지원중국유학 장학생으로 전환 기회 부여중국유학 장학생으로 전환 시 최대 5년간 유학 장학금 지원 ',
      Col12: '대한민국 국적보유자(영주권자/ 이중국적자 지원 가능)국내외 4년제 대학 기 졸업자 및 졸업예정자국내외 대학원 재학생 및 기 졸업자2023년 9월 박사과정 입학 희망자재단 선발전형 일정 전체 참석 가능한 자선발된 후 1년간 재단 필수 연수 참여 가능한 자선발분야: 사회과학/ 인문 ',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '(1차) 서류심사(2차) 필기시험(3차) 면접평가',
      Col16: '해당없음',
      Col17: '재단 장학상품 선발전형 중/ 부정행위로 시험자격이 정지 또는 무효로 된 날로부터 5년이 지나지 않은 사람해외여행에 결격사유가 있는 사람재단 해외유학후보 기 수혜자국가장학금 및 국내 타 장학재단으로부터 장학금 수혜를 받는 자',
      Col18: '지도교수의 추천서 제출 필수',
      Col19: '추천서기본사항 및 학력사항외국어 능력경력사항학업계획 * 홈페이지 온라인 접수로/ 자세한 사항은 기관 홈페이지 참조'
    },
    {
      Col1: '(재)한국고등교육재단',
      Col2: '한학/중국어심화연수장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '新 HSK 4급 이상 취득 혹은 이에 준하는 중국어 능력을 갖춘자 우대',
      Col10: '해당없음',
      Col11: '월 3000000원 / 연수기간 1년 간',
      Col12: '학사학위 소지자(졸업예정자 포함) 혹은 대학 2학년 이상 학부생연수기간 프로그램에만 전념 가능한자 대학(원)생의 경우 연수기간 휴학 가능한 자(복학·군입대 등 불가)대한민국 국적자해외여행 결격사유가 없는 자',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '1차: 서류 전형2차: 필기 시험 (한문/ 영어/ 논술/ 중국어)3차: 심층면접',
      Col16: '5명 내외 ※ 적격자가 없는 경우 선발하지 않을 수 있음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '응시원서(사진 포함)자기소개서대학 및 대학원 전 학년 성적증명서대학 및 대학원 재학증명서 혹은 졸업증명서외국어 시험성적(해당자 선택사항: TOEFL/ TOEIC/ TEPS/ HSK 등) * 홈페이지에서 양식 다운로드'
    },
    {
      Col1: '(재)관정이종환교육재단',
      Col2: '국내장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2022학년도 1학기에 5학기 진학(3학년 1학기)을 예정하고 있는 자 학부 1~3학기 총 평균평점이 4.0(4.5만점)/3.8(4.3만점) 이상인 자  ',
      Col10: '해당없음',
      Col11: '1. 지원금액 : 학기당 550만원(연간 최대 2200만원)2. 지원기간  대학 2학년 말에 선발한 학부 장학생 및 신규 입학한 대학원     장학생 모두 2년간(4회) 조기 졸업 시는 졸업학기까지 지급',
      Col12: '대한민국 국적 보유자로서 대한민국에서 고등학교를 졸업한 자 연령제한 : 만 24세 이하 (2022년 기준/ 1998.1.1 이후 출생)',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '대학별 선발 인원은 재단규정에 따름 자연이공계열 80%/ 인문사회계열(예능계 포함) 20%',
      Col17: '편입생은 지원대상에서 제외 됨 ',
      Col18: ' 재단이 지원하는 대학총장의 추천을 받은 자 ',
      Col19: '지원서(지원서 원본 1부 및 사본 2부)서식은 재단 홈페이지 참고자기소개서 1부서식은 재단 홈페이지 참고  (A4 2~3매 분량/ 폰트 바탕/크기 11/ 줄 간격 160%) 지도교수 추천서 1부서식은 재단 홈페이지 참고고등학교 전과정 학교생활세부사항기록부 사본 1부소속대학 1/2학년 성적증명서 원본 1부소속대학 재학증명서 원본 1부 *검정고시 합격자의 경우 합격증 사본/ 그 전까지의 고교성적/검정고시 과정을 택하게 된 사유서7. 어학능력증명서 사본 1부8. 각종 활동 및 자격에 대한 증빙서류 각 1부(장학금수혜내역/ 수학능력/자격사항/ 교내외각종활동/수상내역 등)9.주민등록 등본 1부10. 가족관계증명서 1부11. 개인정보 수집 이용동의서 1부(재단 홈페이지 참고)***각 대학에서 서류 취합 후 우편 송부'
    },
    {
      Col1: '(재)관정이종환교육재단',
      Col2: '학부장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학신입생',
      Col8: '공학계열/사회계열/의약계열/인문계열/자연계열',
      Col9: '학부 1~3학기 평균 평점이 4.0(4.5만점)이상인 자',
      Col10: '해당없음',
      Col11: '학기당 5500000원(총 4학기 지원)  * 조기 졸업 시는 졸업학기까지 지급',
      Col12: '2022년도 제 1학기에 5학기 진학을 예정한 자만 24세 이하',
      Col13: '해당없음',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '재단에서 서류 전형 면접 심사 및 확정',
      Col16: '대학별 선발 인원은 재단규정에 따름 자연이공계열 80%/ 인문사회계열 20%',
      Col17: '편입생은 지원대상에서 제외',
      Col18: '대학 총장 추천',
      Col19: '지원서 원본 1부 및 사본 2부자기소개서 1부지도교수 추천서 1부학업관련 증빙서류어학능력증명서 사본각종활동 및 자격에 대한 증빙서류주민등록 등본가족관계증명서개인정보 수집/이용 동의서 **각 대학에서 서류 취합 후 우편 송부'
    },
    {
      Col1: '(재)관정이종환교육재단',
      Col2: '대학원장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원',
      Col7: '박사과정/석사신입생(1학기)',
      Col8: '공학계열/사회계열/의약계열/인문계열/자연계열',
      Col9: ' * 前과정 평균평점이 4.0(4.5만점) 이상인 자석사 및 석박통합과정 진학자 : 학부과정박사과정 진학자 : 학부과정 및 석사과정',
      Col10: '해당없음',
      Col11: '5500000원/ 최대 4학기 ',
      Col12: '대한민국 국적 보유자로서 대한민국에서 고등학교를 졸업한 자재단이 지원하는 대학 총장의 추천을 받은 자2022학년도 제1학기에 일반대학원 석사/ 석박사/ 박사과정에 입학 하는 자자연/이공계열/ 인문/사회계열',
      Col13: '해당없음',
      Col14: '2022-04-12~2022-04-26',
      Col15: '1차 서류2차 면접',
      Col16: '선발 인원은 재단규정에 따름자연이공계열 80%/ 인문사회계열 20%',
      Col17: '일반대학원 이외의 대학원(MBA 과정/ 전문대학원/ 특수대학원/ 기타대학원등)은 지원대상에서 제외파트타임 과정/ 야간과정지원대상에서 제외석사·석박사통합과정 진학자 : 만 30세 초과(1988.1.1이전 출생)박사과정 진학자: 만 32세 초과 (1986.1.1. 이전 출생)',
      Col18: '대학 총장 추천',
      Col19: '지원서(지원서 원본 1부 및 사본 2부)서식은 재단 홈페이지 참고자기소개서 1부서식은 재단 홈페이지 참고  (A4 2~3매 분량/ 폰트 바탕/크기 11/ 줄 간격 160%)지도교수 추천서 1부서식은 재단 홈페이지 참고고등학교 전과정 학교생활세부사항 기록부 사본 1부학부과정(전학년) 및 석사과정 성적증명서 원본 1부학부과정 및 석사과정 졸업증명서 원본 *검정고시 합격자의 경우 합격증 사본/ 그 전까지의 고교성적/검정고시 과정을 택하게 된 사유서어학능력증명서 사본 1부각종 활동 및 자격에 대한 증빙서류 각 1부(장학금수혜내역/ 수학능력/자격사항/ 교내외각종활동/수상내역 등)주민등록 등본 1부가족관계증명서 1부개인정보 수집 이용동의서 1부(재단 홈페이지 참고)    ***각 대학에서 서류 취합 후 우편 송부'
    },
    {
      Col1: '(재)관정이종환교육재단',
      Col2: '국외유학장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/원격대학/일반대학원/전문대(2~3년제)/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '나라 과정별 상이* 자세한 내용은 첨부파일 확인 필수',
      Col12: '유학대상국 :  미국/ 중국/ 일본/ 싱가폴/ 홍콩/ 영국/ 독일/ 프랑스/ 이탈리아/ 호주/ 캐나다/ 러시아/ 스위스/ 네덜란드 총 14개국「국외유학장학생선발규정시행규칙」우수대학/ 우수전공에 해당하는 자 (*첨부파일 참조)공학/ 어학/ 인문사회 및 예체능 계열 학생자세한 사항은 첨부파일 참조',
      Col13: '대한민국 국적 보유자로서 대한민국에서 고등학교를 졸업한 자  (* 영주권자/ 이중국적자 지원불가) (* 단/ 주재원파견 등 학부모 국외근무로 부득이 국외에서고등학교 과정을 수학한 경우 예외) ',
      Col14: '2022-07-01~2022-07-15',
      Col15: '온라인 지원접수 후 합격자 서류심사전문심사면접전형',
      Col16: '이공계 80%/ 인문사회 및 예체능 계열 20%그 중 학부는 10%/ 석사 20%/ (석)박사 70% 비율로 선발',
      Col17: 'MBA/ JD/ LLM/ MD/ DNP/ PHARM.D 과정 제외국비장학금 및 기타장학재단 장학금 이중수혜 금지학부 만 24세/ 석사 만 30세/ 박사 만 32세로 지원연령 제한영주권자/ 이중국적자 지원불가',
      Col18: '지도교수 추천서(부득이한 경우 지도교수 외의 추천서 제출가능/ 다만 추천서 내용 중 대체추천 사유가 포함되어야 함)',
      Col19: '1차 온라인 지원시 별도의 제출서류 없음 * 온라인합격자 제출서류 목록인터넷지원서 출력본입학허가서 사본지도교수 추천서대학 및 대학원 졸업 증명서국내 소재 고등학교 생활기록부/ 대학 및 대학원성적증명서  * 그외 선택 제출서류 외 참고사항은 홈페이지 내 게시판 공고 참고바람'
    },
    {
      Col1: '포스코청암재단',
      Col2: '포스코비전장학',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '저소득 가정의 자녀기초생활수급자 및 차상위 계층 소득5분위 이내',
      Col11: '대학생: 연간 5000000원 의 학비보조금으 졸업시까지 지급 ',
      Col12: '저소득 가정자녀로서/ 당해년도 대학에 입학예정인 학생기초생활수급자 및 차상위 계층/ 소득5분위 이내',
      Col13: '포항/ 광양 소재 고등학교 졸업자로서 2022년 대학 신입생',
      Col14: '해당없음',
      Col15: '재단 홈페이지 온라인 신청 후 재단에서 서류심사와 면접을 거쳐 선발',
      Col16: '50명 내외',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '생활기록부 사본가족관계증명서자기소개서 (홈페이지 다운로드)수급자 증명서고등학교 생활기록부소득구간(분위)통지서 : 한국장학재단[소득구간 통지서 발급하기]'
    },
    {
      Col1: '포스코청암재단',
      Col2: '아시아지역전문가양성',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '해외대학',
      Col7: '박사과정/석사2학기이상',
      Col8: '사회계열/인문계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '지원금액학비 및 생활비 : 등록금 연US$15000 한도 내 (학비는 한도 내Tuition Fee 실비지급) 현지 생활비 월 US$800 (분기별 지급) 지원기간8학기 이내 (석·박사 통합과정 10학기 이내)',
      Col12: '1. 대한민국 국적 보유자2. 국내외 대학 석사학위 소지자(2018.8.31일 이전 졸업예정자)3. 2학의 학위소지자로서 선발된 후 1년 이내에 아시아국가 박사 학위과정에 입학가능자',
      Col13: '* 아시아 국가 (상주대사관 설치국가 우대)',
      Col14: '2022-06-01~2022-06-30',
      Col15: '1차 서류전형2차 면접(서류 합격자에 한 함)',
      Col16: '해당없음',
      Col17: 'MBA/ 이공계열/ 자연계열/ 예체능계열국내의 타 유학장학금을 받고 있지 않으며/ 해외 출국에 결격사유가 없는 자 (유학국가의 국가장학금 수혜로 학비 면제자는 재단에서 현지 생활비만 지원)',
      Col18: '해당없음',
      Col19: '장학생 지원서 1부 (온라인지원신청)자기소개서 1부 (양식 작성/ A4 기준 2매 이내 작성)성장과정/ 지원동기/ 주요 관심분야/ 미래설계를 중심으로 작성학위과정 중 연구계획서 각 1부 (양식 작성/ A4 기준 2매 이내 작성)연구 분야 및 방법/ 현지 활동 계획을 중심으로 작성라. 대학 및 대학원 전 학년 성적증명서 각 1부  *성적증명서의 성적은 100점 만점의 환산점수를 별도 기재  *편입생의 경우 이전 학교의 성적증명서도 함께 제출TOEFL/ IELTS/ TEPS/ TOEIC 등 영어능력 증명 1부유학예정국가 현지언어능력 증명 1부  *증명서 발급이 불가한 경우 현지언어연수/ 현지체류 등 관련 서류 대체사. 기타 각종 연구경력/ 연구실적 등을 증명할 수 있는 증빙서류 각 1부  *증빙서류만 제출하고 논문/ 서적 등은 제출할 필요 없음'
    },
    {
      Col1: '포스코청암재단',
      Col2: '포스코사이언스펠로십',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/해외대학',
      Col7: '대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/자연계열',
      Col9: ' * Postdoc 펠로국내 및 해외 대학에서 1년 이내 박사학위 취득예정자로서 국내 대학이나 대학부설 연구소/ 국책연구소에서 2023년 3월 이내 Postdoc 연수 예정자선발공고일 기준 국내대학이나 대학부설연구소/ 국책연구소에서 기 연수중인 Postdoc 연구원 * 신진교수 펠로선발공고일 현재 임용 36개월 이내(해외대학 경력 제외)의 국내 대학 신진교수 또는 1년 이내에 국내 대학 신진교수로 임용 예정자',
      Col10: '해당없음',
      Col11: ' * Postdoc 펠로십인당 매년 3천 5백만원의 펠로십을 2년간 지원 * 신진교수 펠로십인당 매년 5천만원의 펠로십을 2년간 지원',
      Col12: ' * 학문분야수학/ 물리학/ 화학/ 생명과학 분야(4개 기초과학 분야)금속/ 신소재/ 에너지소재(3개 응용과학 분야) * 박사과정 / Postdoc 펠로 / 신진교수 펠로 * 자세한 사항은 홈페이지 공고문 참조',
      Col13: '해당없음',
      Col14: '2022-04-29~2022-05-13',
      Col15: '전문위원회 서류심사과학자 평가의견서 요청선발위원회 면접심사',
      Col16: 'Postdoc펠로 : 10명 내외신진교수 펠로 : 20명 내외',
      Col17: ' * 자세한 사항은 해당 기관으로 문의',
      Col18: '해당없음',
      Col19: 'Postdoc 펠로 지원자 · 온라인 지원서 · 연구 및 논문실적 · 연구계획서 · 과학자 1인의 추천서신진교수 펠로 지원자 · 온라인 지원서 · 연구 및 논문실적 · 연구계획서 * 포스코청암재단 홈페이지 온라인 지원서 제출 * 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '(재)서암윤세영재단',
      Col2: '국내 박사과정 연구지원사업',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '해당없음',
      Col8: '공학계열/사회계열/인문계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '지원금액 : 최대 9천 7백만원  * 코스웍을 마칠 때까지의 등록금 전액과 월 100만원의 연구지원금 (* 지원기간 : 석박사통합과정 최대 5.5년 / 박사과정 최대 4.5년 / 석사과정 최대 2.5년 ※ 2년 지원 후 중간평가를 거쳐 지원 계속 여부를 결정)',
      Col12: '국내대학원에서 석사/박사 통합/ 박사학위 과정 중인 자  (휴학중인 자 제외)지도교수 등의 추천을 받은 분타 재단이나 단체/ 기관으로부터 지원을 받고 있지 않은 분 * 위 세가지 기준을 \'모두\' 충족해야 합니다.',
      Col13: '해당없음',
      Col14: '2022-07-05~2022-07-19',
      Col15: '1차 : 서류심사 * 접수된 서류 미반환2차 : 별도 구성되는 심사위원회에서 심의·선발',
      Col16: '0명 (이·공/ 인문·사회 구분 없음)',
      Col17: '타 재단이나 단체/ 기관으로 부터 지원을 받는 자지원기간 중 학위를 취득하거나 중도 포기할 경우 지원 종료',
      Col18: '소속대학교(원)의 총장이나 원장 또는 학장의 추천을 받은 자',
      Col19: '지원신청서자기소개서연구계획서학부/ 대학원 직전까지의 전체 성적증명서경력/ 수상실적 등을 증명할 수 있는 증빙서류 사본논문 및 연구실적(특허 포함)을 증명할 수 있는 증빙서류 사본  * 논문은 표제지와 초록/ 특허는 특허등록/ 출원증 사본 등 제출)지도교수 등의 추천서 1부 (자유양식/ 분량 제한 없음) * 양식은 홈페이지에서 다운받을 것/ 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '(재)서암윤세영재단',
      Col2: '대학장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학2학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기(1학년 1학기) 성적 4.0(4.5만점) 이상인 학생 ※ 참가국 5개국 이상인 국제 공인 공모전 또는 공인 대회에서 입상하거나 중앙행정기관이나 공신력있는 국내 기관이 주최하는 전국 규모의 공모전 또는 대회에서 1위 입상한 경력이 있는 경우 학점 무관',
      Col10: '한국장학재단 산정 학자금 지원구간 5구간 이하',
      Col11: '등록금 전액 (졸업 시까지 7학기)매 월 봉사 활동비 지원(월 500000원 이내)교환학생 체재비 지원(1학기에 한해 총 700만원) * 모범 장학생에 대한 해외 인문학 탐방 기회',
      Col12: '첨부파일 참고장학생 의무 사항 : 재단 행사 참여 및 매 학기 성적증명서 제출 및 매 학기 종료 후 봉사활동보고서 및 다음 학기 봉사활동계획서 제출',
      Col13: '해당없음',
      Col14: '2021-09-23~2021-10-07',
      Col15: '온라인 응모 서류 접수서류 심사면접 심사',
      Col16: '해당없음',
      Col17: '2학기 휴학 예정자전 학기 성적이 평점 평균 3.5 미만일 경우 지급 중단타 재단이나 단체로부터 중복 수혜일 경우 ',
      Col18: '지도교수수 추천',
      Col19: '자기소개서봉사활동계획서1학년 1학기 성적표주민등록등본한국장학재단 발급 학자금 지원구간 통지서수상내역 증빙서류지도교수 추천서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인 DB김준기문화재단',
      Col2: '장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기',
      Col8: '공학계열',
      Col9: '전학기 평균성적 3.0이상 ',
      Col10: '한국장학재단 소득분위 기준 8분위 이하학업열의가 높으나 가정형편이 곤란하여 학업에 어려움을 겪는 자 ',
      Col11: '1인당 1800000원 ',
      Col12: '20212학기 기준 3학년~4학년 재학생경영.경제대학/ 공과대학 소속 2021학년도 2학기 정규학기 재학생',
      Col13: '해당없음',
      Col14: '2022-06-03~2022-06-04',
      Col15: '서류심사',
      Col16: '3명 ',
      Col17: '해당없음',
      Col18: '학교 추천 필요 * 학교 장학과에서 배부받은 인증번호 필요',
      Col19: '서류전형 : 장학금 지원서 제출(재단 홈페이지)면접전형 : 장학생 서약서/ 성적증명서/ 소득분위 증명자료최종합격 : 등록금명세서/ 교수추천서  * 자세한사항은 재단홈페이지 참고'
    },
    {
      Col1: '롯데장학재단',
      Col2: '멘토링장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 3.2/4.5(3.0/4.3) 이상 또는 총(평균)평점 3.5/4.5(3.3/4.3) 이상 이수학점 12학점 이상 * 기준학기: 2021년 2학기',
      Col10: '소득분위 8분위 이내',
      Col11: '등록금(수업료)전액 또는 생활비(학습보조비) 300만원 중 택1멘토링 활동비: 월 15만원 * 자세한 내용은 소속대학 장학공지 참고',
      Col12: '센터 인근 4년제 대학생으로서 초/중/고등학생 학습지도 가능한자20222학기 기준 대학교 2학년 재학생',
      Col13: '해당없음',
      Col14: '2021-12-22~2022-01-17',
      Col15: '대학 추천> 재단심사> 멘토링 프로그램 수료> 장학금 지급 및 멘토링 활동동',
      Col16: '해당없음',
      Col17: '실습/ 교환/인턴/연수/ 군입대/ ROTC/ 휴학 등의 사유로 지속적인 멘토링 활동이 어려운 자',
      Col18: '해당없음',
      Col19: '해당없음'
    },
    {
      Col1: '롯데장학재단',
      Col2: '국학우수인재 장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원/전문대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학기 단위 심사 진행 (성적 및 학위 논문)직전학기 성적 4.0/ 4.5 or 3.5/4.0이상 유지',
      Col10: '해당없음',
      Col11: '학기당 7500000원 한도 내 등록금 우선지원 (차액분 학습보조비 지원)정규 등록과정 내 연구기간으로 전환된 박사는 학기당 생활비 명목 5000000원 지급급',
      Col12: '해당없음',
      Col13: '해당없음',
      Col14: '2022-05-02~2022-05-11',
      Col15: '해당없음',
      Col16: '00명',
      Col17: '국학우수인재수혜자는 등록금 명목의 타 장학금 중복 수혜 불가',
      Col18: '해당없음',
      Col19: '합격증명서 및 직전학력 최종 성적(신입생)재학증명서/성적증명서 (필수)커리큘럼연구 논문 등의 기존 연구성과물(선택)교수 추천서수상실적 증빙자료 (선택)   * 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '롯데장학재단',
      Col2: '취업준비생 특별 장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '총 (평균)평점 기준 3.2/4.5(3.0/4.3) 이상',
      Col10: '한국장학재단 소득분위 증명가능한 자0분위 ~ 1분위~10분위 모두 가능',
      Col11: '1000000원 * 1회성',
      Col12: ' * 국내 4년제 대학교 재학생(대한민국 국적 소지자)4년제 : 정규과정 6학기 이상 수료자 / 6년제 : 정규과정 10학기 이상 수료자',
      Col13: '해당없음',
      Col14: '2022-02-28~2022-03-18',
      Col15: '서류합격 > 자기소개서 첨삭 진행 > 장학금 지급',
      Col16: '1/000명 ',
      Col17: '졸업생 및 취준생 1~3기 장학생 지원불가생계유지/ 대학원 진학 및 유학 등 취업과 무관할 경우 지원 불가가',
      Col18: '해당없음',
      Col19: ' * 기관 홈페이지에서 온라인 지원신청서 작성 / 자세한 내용은 롯데장학재단 홈페이지에서 확인성적증명서학자금 지원구간 통지서(소득분위확인서)어학성적 증빙서류재학증명서 / 휴학증명서 / 졸업예정증명서 '
    },
    {
      Col1: '(재)일주학술문화재단',
      Col2: '국내학사',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 전액 또는 생활비 장학금(최대 5학기)멘토링 보조금우수멘토 시상 ',
      Col12: '국내 4년제 대학교 2학년 1학기 재학생평점 3.0/4.5이상(예체능 전공자 포함)멘토링 봉사활동 가능자 (학기당 30시간)',
      Col13: '해당없음',
      Col14: '2022-04-05~2022-04-22',
      Col15: '서류심사면접심사',
      Col16: 'OO명',
      Col17: ' * 타 장학금 중복수혜자 및 예정자 제외(근로장학금 제외) * 졸업예정자 및 입학예정자 제외',
      Col18: '해당없음',
      Col19: '재학증명서 (필수)성적증명서 (필수)멘토링 계획서 (필수)해당 내용 작성 시 제출서류 (해당자) : 봉사활동확인서 / 대외활동 증빙서류 / 수상내역 증빙서해당자 소득 증빙서류 (해당자) : 보호시설 거주 또는 퇴소자 증빙서류 / 수급자 증명서(생계·의료·보장) / 차상위계층 제증명서'
    },
    {
      Col1: '(재)일주학술문화재단',
      Col2: '해외박사',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '총 USD 120000 (4년기준)입학 출국 졸업 귀국 시 항공료 총 2회 지원 * 박사과정/통합과정 기간 동일 교내 지원금에 따른 감액규정 없음',
      Col12: '해외 우수 대학원 박사과정(Phd) 입학허가를 받은 신입생 (입학확정 허가를 의미하며/ 조건부 입학은 인정되지 않음)대한민국 국적 보유자국내대학 학사학위 취득자 * 위의 3가지 요건 모두 충족시 지원가능',
      Col13: '해당없음',
      Col14: '2021-12-07~2021-12-10',
      Col15: '서류 및 학술연구심사 후 면접',
      Col16: '10명 내외',
      Col17: '국외 영주권자나 이중국적 보유자는 제외',
      Col18: '해당없음',
      Col19: '온라인 지원서 : 홈페이지 작성 * 자세한 사항은 홈페이지 선발공고 참고'
    },
    {
      Col1: '대상문화재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '1학년 평점평균 4.0(4.5만점) 이상인 자',
      Col10: '해당없음',
      Col11: '사립대학교 년간 9000000원   * 학기별 2회 분할지급단 장학생으로 선발된 자에게는 3년간 장학금을 지급(결격사유 발생즉시 장학금 지급 중단첨부파일 참조)',
      Col12: '대학 2학년 진학 예정인 재학생국내 대학교 및 대학원 재학생(해외유학생 제외)성적이 우수하고 장래가 크게 기대되나 경제적 여건이 어려워 학비보조를 필요로 하는자',
      Col13: '해당없음',
      Col14: '2022-06-24~2022-07-11',
      Col15: '추천의뢰 (재단에서 학교를 선정하여 장학과를 통해 장학생을 추천 받음) 대상자 추천 및 서류접수(대학→지원자→재단) 서류심사 및 개별면접 ',
      Col16: '해당없음',
      Col17: '성적 3.0미달타장학금 이중 수혜자',
      Col18: '대학총장 추천 필요(개별신청 없음)소속대학 장학복지과 경유 ',
      Col19: '***각 대학의 장학부서/학생처를 통해 문의 필수(개별신청 불가)***장학원서(재단 소정양식)총장 추천서학업성적증명서(1학년)장학금수령을 위한 학교 명의의 금융기관 통장사본학업수행 및 사회봉사계획서(작성요령은 첨부파일 참고)과외활동 및 수상경력/ 연구실적/ 자격증/ 봉사활동 경력 자료 등보호자의 소득 관련 자료개인정보의 수집 및 이용에 대한 동의서 1부 * 자세한 사항은 첨부파일 참고 * 재단에서 각 학교에 추천을 의뢰하여 선발함/ 개별신청은 불가'
    },
    {
      Col1: '고촌재단(종근당)',
      Col2: '국내장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학6학기/대학7학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '이수학기 총 평점이 B+(85점) 이상인 자(3.5/4.5기준 이상)',
      Col10: '해당없음',
      Col11: '등록금 전액(학기별 연 2회 지급)*(단 감면 또는 공제금액이 있을 경우에는 차감 후 지급)* 선발 후 졸업시까지 (단 직전학기 성적증명서 확인 후 지급)',
      Col12: '재단이 선정한 대학에서 학생을 추천하는 방식이므로 추천 가능 여부를 각 학과사무실이나 장학팀에 문의 할 것대학원/ 학부생',
      Col13: '해당없음',
      Col14: '2021-12-14~2022-01-21',
      Col15: '학교추천(각학교장학과)서류심사면접',
      Col16: '해당없음',
      Col17: '국내 기관(학교포함)/ 기업/ 단체 등에서 별도로 장학금을 지원 받는 자 정규대학 졸업 후 재입학 또는 편입학생',
      Col18: '해당없음',
      Col19: '* 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.응시원서 : 장학금 지원신청서/ 신청자 이력사항/ 자기소개서 각 1부서약서 1부가족관계증명서개인정보수집이용동의서학업계획서 1부총(학)장 추천서 1부성적증명서 1통세목별과세증명서(부모님/ 본인) 1통증명사진 2매(최근 3개월 이내 촬영분)'
    },
    {
      Col1: '고촌재단(종근당)',
      Col2: '생활비장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학3학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '당해연도 소득분위 2분위 이하인 자',
      Col11: '연 6000000원(월 500000원) * 월별 멘토링 활동 이수시간 확인 후 지급',
      Col12: '2022학년도 2학년 1학기 진학 예정자 ',
      Col13: '해당없음',
      Col14: '2022-06-20~2022-07-21',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '타 기관으로부터 생활비를 지원받는 자 제외',
      Col18: '해당없음',
      Col19: '가족관계증명서성적증명서총/학장 추천서장학생 서약서소득구간(분위)통지서증명사진(반명함판) * 추가서류(해당자)장학금 수혜증명서봉사활동 확인서기타 증빙서류 * 모든 제출서류는 온라인 접수시 PDF파일로 업로드 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '고촌재단(종근당)',
      Col2: '무상기숙사장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '이수학기 총 평점이 80점 이상인자(3.0/4.5기준 이상)',
      Col10: '해당없음',
      Col11: '주거비 전액지원 (기숙사비 관리비 공과금 무료)',
      Col12: '서울 소재 4년제 대학교2학년 이상에 재학중인 자 멘토링 봉사활동이 가능한 자 (주 1회/ 2시간)',
      Col13: '보호자의 현 주소지가 서울 수도권 외 지역인 자 ',
      Col14: '2021-11-08~2021-11-19',
      Col15: '선발 심사기준에 따라 합산점수가 높은 자 순으로 선발함동점자 발생시 학년이 높은 자를 우선 배정함 ',
      Col16: '해당없음',
      Col17: '4학년(7학기 이상)에 재학중인 자재학중 퇴학.정학 등 징계처분을 받았거나 휴학중인 자 전염성 질환 및 정신질환 또는 품행불량 등으로 공동생활에 부적합한 자 ',
      Col18: '해당없음',
      Col19: '주민등록등본가족관계증명서성적증명서소득분위확인서증명사잔차상위계층 증명서류장애등급 확인서국가유공자(자녀) 증명서봉사활동확인서(2021년 기준)'
    },
    {
      Col1: '재단법인 STX장학재단',
      Col2: '국내장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학4학기',
      Col8: '공학계열/교육계열/사회계열/인문계열/자연계열/제한없음',
      Col9: '학점평균이 B+이상인 학생 (3.3/4.3 이상 또는 3.5/4.5 이상)2학년 1학기까지 평점평균 (3학년 1학기 복학예정자는 2학년 2학기까지) ',
      Col10: '해당없음',
      Col11: '학기당 등록금 3000000원 한도 + 학업보조금 월 500000원 * 최대 2년까지',
      Col12: '국내 국립/종합 4년제 대학교 3학년 1학기 진급예정자(4학기 재학생 혹은 4학기 이수한 복학예정자)',
      Col13: '해당없음',
      Col14: '2022-09-07~2022-09-27',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '학부 : 3학년 1학기 진급 예정자에 한함예체능/의예/ 한의학/ 약학/ 간호대/ 사범대 등 특수/전문계열 제외타 재단의 장학금을 중복 수혜 불가 (국가/ 교내장학금은 중복 수혜 가능. 단/ 등록금은 등록금 금액 이내 가능)',
      Col18: '해당없음',
      Col19: ' * 온라인 접수 : www.stxfoundation.or.kr(11월 10일부터 접수 가능) * 구비서류 제출 : 서류전형 합격자에 한해 원본 우편제출(개별 공지)주민등록등본 1부성적증명서(전 학년 수강내역) 1부 * 재학중인 경우 \'20년도 1학기 성적까지 반영된 성적증명서 제출\'(휴학중인 경우는 이수한 4학기 성적까지 모두 반영되어 있어야함)인턴/대외활동증명서(지원서 기재항목)VMS/ 1365기관에서 발급한 봉사활동 증명서(지원서 기재항목)2020년 2학기 기준 소득분위 결정통지서  * 자세한 사항은 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)고속도로장학재단',
      Col2: '장학금',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '기초·차상위 계층 : 5000000원일반 : 3000000원',
      Col12: '고속도로 교통사고로 사망한 자의 자녀장애의 정도가 심한 장애인으로 구분된 자 또는 그의 자녀',
      Col13: '해당없음',
      Col14: '2021-12-08~2022-01-16',
      Col15: '해당없음',
      Col16: 'OOO명 * 고등학생 선발인원 포함',
      Col17: '음주 및 불법으로 인한 교통사고의 원인제공자 및 그의 자녀 제외1가구 1자녀 신청원칙(기초수급·차상위 제외) * 자세한 사항은 기관으로 문의 바랍니다.',
      Col18: '해당없음',
      Col19: '장학금 수혜대상자 조사표국민기초생활보장법에 의한 수급자 증명서 등 생활형편증명서류교통사고사실확인원사고자와의 관계 증명 서류재학증명서신청자 본인 통장 사본장애인복지카드 사본재직증명서 및 1학기 등록금 납입 영수증졸업예정증명서 * 자세한 사항은 첨부파일 또는 기관 홈페이지 참고 바랍니다.'
    },
    {
      Col1: '교보생명교육문화재단',
      Col2: '희망다솜장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '수급자 차상위계층 한부모.조손가정 소년소녀가정 위탁가정 청소년에 해당하는 자 ',
      Col11: '학기당 2000000원  * 기준 충족시 대학 입학부터 졸업시(8학기)까지 장학금 지원최대 1600 만원 ',
      Col12: '[특수계층] 기초수급자/ 차상위계층/ 한부모가정/ 조부모가정/ 학생가장/ 가정외보호시설출신/ 기타',
      Col13: '해당없음',
      Col14: '2022-01-26~2022-02-09',
      Col15: '1차 서류심사2차 면접심사',
      Col16: '총 20명 이내',
      Col17: '타기관의 후원 또는 장학금을 받지 않은 장학생 우선 지원',
      Col18: '시설장 또는 관련 단체장의 추천 * 시설 또는 단체장의 추천서를 받을 수 없을 경우 사회복지사 또는 담임선생님의 추천',
      Col19: '지원신청서추천서개인정보 수집이용 동의서학교생활기록부  * 자세한 사항은 홈페이지 참고 '
    },
    {
      Col1: '신라문화장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '32학점 이상 이수하고 평균평점 3.0이상',
      Col10: '2021년도 양친 지방세 세목별 과세증명서 건물·토지분 재산세 합계액 100만원 이하 ',
      Col11: '졸업까지 등록금 전액 ',
      Col12: '서울·경기 캠퍼스2022년도 2학년 예정자/ 5년제는 3학년/ 6년제는 본과 2학년',
      Col13: '해당없음',
      Col14: '2022-09-30~2022-10-07',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 공개선발 지원서개인정보동의서자기소개서학업 및 자기발전 계획서전체 학년 성적증명서주민등록등본2021년도 양친 지방세 세목별 과세 증명서 '
    },
    {
      Col1: '사회복지법인미래에셋박현주재단',
      Col2: '해외교환장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기와 총평점이 모두 3.3/4.5만점(3.1/4.3만점) 이상인 자 (동시충족) **자세한 사항은 첨부자료 참고',
      Col10: '한국장학재단 소득분위 1~8분위 / 기초수급자 / 차상위계층 * 자세한 사항은 첨부자료 참고',
      Col11: '미주/유럽/기타지역 : 7000000원아시아지역 : 5000000원 ',
      Col12: '대한민국 국적4년제 정규대학에 재학중인 이공/ 상경/ 인문사회 계열 학부생 (정규학기 초과자/ 휴학생도 지원 가능)파견기간 동안 모교의 재학 상태를 유지하고/ 파견교에서 이수한 학기와 학점을 모교에서 인정받을 수 있는 자 (파견국가 제한 없음) * 자세한 사항은 첨부파일 참고',
      Col13: '해당없음',
      Col14: '2021-12-10-2022-01-07',
      Col15: '1차 온라인 서류접수/ 2차 온라인 AI 면접',
      Col16: '300명  (지원계열별 선발 비중 : 이공계열 60%/ 상경계열 30%/ 인문사회계열 10%)',
      Col17: '교환학생 명목으로 지원되는 타 기업 또는 재단의 장학금과 중복수혜 불가능외국인(또는 외국국적 소지자)/ 대학원생신입생 지원 불가편입생/ 편입 이전 대학에서 해외 파견 경험 있거나 소속 대학 1학기 이수하지 않은 경우 지원 불가예체능/ 의학 계열 불가 * 자세한 사항은 첨부자료 참고',
      Col18: '해당없음',
      Col19: ' * 공통서류지원서 및 자기소개서 대외제출용 성적증명서한국장학재단 소득분위통지서  * 가산점해당자본인/ 부모가 기초수급자 또는 차상위계층인 경우본인/부모가 장애인인 경우본인이 국가유공자(유족)자녀의 경우* 기타 서류 및 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 신한장학재단',
      Col2: '신규장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '수능성적 4개 영역(국어/수학/영어/탐구)중 3개 영역이상 4등급 이내* 탐구영역은 2과목 평균이 3등급 이내일 경우에 한해서 3등급 이내로 인정.* 한국사/ 제2 외국어/한문 영역은 평가에서 제외.* 검정고시생인 경우 수능응시 전과목 성적으로 내신성적을 대용 산정',
      Col10: '기초생활수급자 또는 차상위계층기타 생활 및 학업 여건이 어려운 학생월 건강보험료 106100원 이하',
      Col11: '입학금 : 전액등록금 : 전액',
      Col12: '2022년도 대학교 입학예정자',
      Col13: '해당없음',
      Col14: '2022-02-16~2022-03-15',
      Col15: '해당없음',
      Col16: '100명 내외 (진월율 등의 요인에 따라 선발인원 변동 가능)',
      Col17: '한국장학재단의 국가장학금 수혜금액 이외의 타 재단의 장학금을 수령하는 경우 장학생 선발에서 제외',
      Col18: '해당없음',
      Col19: '장학생 신청서 장학생 추천서고등학교 생활기록부 사본대학수학능력시험 성적표소득관련 증빙서류주민등록등본가족관계증명서장애인 증명서(해당시)개인(신용)정보 수집/이용/제공 동의서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인청송군인재육성장학회',
      Col2: '우수대학재학특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음/특정학과',
      Col9: '학기별 최고성적 4.5 기준 시 3.0이상인 자',
      Col10: '해당없음',
      Col11: '서울대 연세대 고려대 포항공대에 재학 중인 자: 4년 등록금 전액 지원전국 의과대 한의대 치과대에 재학 중인 자: 2년 등록금 전액 지원 * 등록금 지원 목적',
      Col12: '서울대/ 연세대/ 고려대/ 포항공대/ 의과대/ 한의대/ 치과대에 재학 중인 학생생관내 고등학교 졸업자 중 우수대학교에 재학 중인 학생',
      Col13: '공고일 현재 부모 또는 보호자(부모가 없을 경우)의 주민등록이 청송군내에 있고 * 신입생: 관내 고등학교 졸업자 * 재학생: 관내 중학교 또는 고등학교 졸업자',
      Col14: '2022-02-16~2022-03-15',
      Col15: '적격자에 한해 이사회에서 심의 의결',
      Col16: '해당없음',
      Col17: '부모(부모가 없을 시 보호자)가 청송군 관외로 거주지를 이전하였을 때장학생 신청서 내용과 첨부서류가 허위로 작성 제출되었을 때  보호자 또는 장학생이 주민으로부터 지탄을 받을만한 불미스러운 행위를 하였을 때장학생이 퇴학하였거나 정학 이상의 징계 처분을 받았을 때군에 입대하거나 질병 등의 사유로 학업을 계속하기 곤란할 때학교장의 정지신청이 있을 때기타 이사장이 장학금의 지급을 정지할 필요가 있다고 인정할 때',
      Col18: '해당없음',
      Col19: '장학생지원(성적/ 특기/ 저소득 등) 신청서성적증명서 (신입생: 관내 고등학교 최종 내신 성적 / 재학생: 직전 학년(1학기/ 2학기) 성적)장학생추천서 (고등학생 및 대학교 신입생/ 저소득 4년제 대학생/ 경제적 어려움에 한함)특기성적증명서 (예/체능 특기자에 한함)장학금 지급 신청서관내 중학교 또는 고등학교 졸업증명서재학증명서장학금 (비)수혜 증명서 (대학교 신입생/재학생만 해당)주민등록등본주민등록초본(다자녀 가정 특별장학생에 한함)가족관계증명서   1) 주민등록등본 상 학생과 부모(보호자)가 따로 등재된 경우   2) 다자녀 가정 특별장학생의 경우 주민등록 주소 상이여부와 관계없이 부 또는 모(또는 보호자)의 기준으로 발급받아 제출 (다자녀 증빙이 가능한 가족관계증명서)합격통지서 사본국민기초생활보장수급자증명서 및 차상위계층증명서 (해당자)'
    },
    {
      Col1: '재단법인청송군인재육성장학회',
      Col2: '우수대학입학특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '1학기: 우수대학교에 입학한 학생 전원 신청 가능2학기: 학기별 최고 성적 4.5기준 3.0 이상인 자',
      Col10: '해당없음',
      Col11: '서울대 연세대 고려대 포항공대에 입학한 자: 4년 등록금 전액 지원의과대 한의대 치과대에 입학한 자: 2년 등록금 전액 지원 * 등록금 지원 목적',
      Col12: '관내 고등학교 졸업자 중 우수대학교에 입학한 학생서울대/ 연세대/ 고려대/ 포항공대/ 의과대/ 한의대/ 치과대에 입학한자',
      Col13: '공고일 현재 부모 또는 보호자(부모가 없을 경우)의 주민등록이 청송군내에 있고 * 신입생: 관내 고등학교 졸업자 * 재학생: 관내 중학교 또는 고등학교 졸업자',
      Col14: '2022-02-16~2022-03-15',
      Col15: '적격자에 한해 이사회에서 심의 의결',
      Col16: '해당없음',
      Col17: '부모(부모가 없을 시 보호자)가 청송군 관외로 거주지를 이전하였을 때장학생 신청서 내용과 첨부서류가 허위로 작성 제출되었을 때  보호자 또는 장학생이 주민으로부터 지탄을 받을만한 불미스러운 행위를 하였을 때장학생이 퇴학하였거나 정학 이상의 징계 처분을 받았을 때군에 입대하거나 질병 등의 사유로 학업을 계속하기 곤란할 때학교장의 정지신청이 있을 때기타 이사장이 장학금의 지급을 정지할 필요가 있다고 인정할 때',
      Col18: '관내 졸업 고등학교 학교장 추천',
      Col19: '장학생지원(성적/ 특기/ 저소득 등) 신청서성적증명서 (신입생: 관내 고등학교 최종 내신 성적 / 재학생: 직전 학년(1학기/ 2학기) 성적)장학생추천서 (고등학생 및 대학교 신입생/ 저소득 4년제 대학생/ 경제적 어려움에 한함)특기성적증명서 (예/체능 특기자에 한함)장학금 지급 신청서관내 중학교 또는 고등학교 졸업증명서재학증명서장학금 (비)수혜 증명서 (대학교 신입생/재학생만 해당)주민등록등본주민등록초본(다자녀 가정 특별장학생에 한함)가족관계증명서   1) 주민등록등본 상 학생과 부모(보호자)가 따로 등재된 경우   2) 다자녀 가정 특별장학생의 경우 주민등록 주소 상이여부와 관계없이 부 또는 모(또는 보호자)의 기준으로 발급받아 제출 (다자녀 증빙이 가능한 가족관계증명서)합격통지서 사본국민기초생활보장수급자증명서 및 차상위계층증명서 (해당자)'
    },
    {
      Col1: '재단법인청송군인재육성장학회',
      Col2: '저소득층자녀장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생: 관내 고등학교 최종 내신 성적이 100분의 30 이내인 자재학생: 직전 학년 평점이 4.5기준 시 3.0 이상인 자',
      Col10: '국민기초생활보장수급 및 차상위 자녀',
      Col11: '관내고등학교졸업자:2000000원관내중학교졸업자:1500000원 * 생활비 지원 목적',
      Col12: '국민기초생활보장수급 및 차상위 자녀 중 기타 인재육성장학회 등의 장학금 지급대상이 아닌 자',
      Col13: '공고일 현재 부모 또는 보호자(부모가 없을 경우)의 주민등록이 청송군내에 있고 * 신입생: 관내 고등학교 졸업자 * 재학생: 관내 중학교 또는 고등학교 졸업자',
      Col14: '2022-02-16~2022-03-15',
      Col15: '적격자에 한해 이사회에서 결정',
      Col16: '해당없음',
      Col17: '부모(부모가 없을 시 보호자)가 청송군 관외로 거주지를 이전하였을 때장학생 신청서 내용과 첨부서류가 허위로 작성 제출되었을 때  보호자 또는 장학생이 주민으로부터 지탄을 받을만한 불미스러운 행위를 하였을 때장학생이 퇴학하였거나 정학 이상의 징계 처분을 받았을 때군에 입대하거나 질병 등의 사유로 학업을 계속하기 곤란할 때학교장의 정지신청이 있을 때기타 이사장이 장학금의 지급을 정지할 필요가 있다고 인정할 때',
      Col18: '신입생: 관내 졸업고등학교 학교장 추천',
      Col19: '장학생지원(성적/ 특기/ 저소득 등) 신청서성적증명서 (신입생: 관내 고등학교 최종 내신 성적 / 재학생: 직전 학년(1학기/ 2학기) 성적)장학생추천서 (고등학생 및 대학교 신입생/ 저소득 3년제이상 대학생/ 경제적 어려움에 한함)특기성적증명서 (예/체능 특기자에 한함)장학금 지급 신청서관내 중학교 또는 고등학교 졸업증명서재학증명서장학금 (비)수혜 증명서 (대학교 신입생/재학생만 해당)주민등록등본주민등록초본(다자녀 가정 특별장학생에 한함)가족관계증명서   1) 주민등록등본 상 학생과 부모(보호자)가 따로 등재된 경우   2) 다자녀 가정 특별장학생의 경우 주민등록 주소 상이여부와 관계없이 부 또는 모(또는 보호자)의 기준으로 발급받아 제출 (다자녀 증빙이 가능한 가족관계증명서)합격통지서 사본국민기초생활보장수급자증명서 및 차상위계층증명서 (해당자)'
    },
    {
      Col1: '재단법인청송군인재육성장학회',
      Col2: '일반성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생: 고등학교 최종 내신 성적이 100분의 10 이내인 자재학생: 직전 학년 평점이 4.5기준 시 3.7 이상인 자',
      Col10: '국가 또는 지방자치단체 공공단체 및 민간단체로부터 본 장학회에서 지급하는 장학금의 300%이상을 받은 자는 제외',
      Col11: '관내고등학교졸업자:2000000원관내중학교졸업자:1500000원 * 생활비 지원 목적',
      Col12: '관내 중 또는 고등학교를 졸업하고 3년제 이상 국내대학교에 입학·재학 중인 학생 ',
      Col13: '공고일 현재 부모 또는 보호자(부모가 없을 경우)의 주민등록이 청송군내에 있고 * 신입생: 관내 고등학교 졸업자 * 재학생: 관내 중학교 또는 고등학교 졸업자',
      Col14: '2022-02-16~2022-03-15',
      Col15: '적격자에 한해 이사회에서 심의 의결',
      Col16: '해당없음',
      Col17: '부모(부모가 없을 시 보호자)가 청송군 관외로 거주지를 이전하였을 때장학생 신청서 내용과 첨부서류가 허위로 작성 제출되었을 때  보호자 또는 장학생이 주민으로부터 지탄을 받을만한 불미스러운 행위를 하였을 때장학생이 퇴학하였거나 정학 이상의 징계 처분을 받았을 때군에 입대하거나 질병 등의 사유로 학업을 계속하기 곤란할 때학교장의 정지신청이 있을 때기타 이사장이 장학금의 지급을 정지할 필요가 있다고 인정할 때',
      Col18: '신입생(1학년): 관내 졸업고등학교 학교장 추천',
      Col19: '장학생지원(성적/ 특기/ 저소득 등) 신청서성적증명서 (신입생: 관내 고등학교 최종 내신 성적 / 재학생: 직전 학년(1학기/ 2학기) 성적)장학생추천서 (고등학생 및 대학교 신입생/ 저소득 4년제 대학생/ 경제적 어려움에 한함)특기성적증명서(예/체능 특기자에 한함)장학금 지급 신청서관내 중학교 또는 고등학교 졸업증명서재학증명서장학금 (비)수혜 증명서 (대학교 신입생/재학생만 해당)주민등록등본주민등록초본(다자녀 가정 특별장학생에 한함)가족관계증명서   1) 주민등록등본 상 학생과 부모(보호자)가 따로 등재된 경우   2) 다자녀 가정 특별장학생의 경우 주민등록 주소 상이여부와 관계없이 부 또는 모(또는 보호자)의 기준으로 발급받아 제출 (다자녀 증빙이 가능한 가족관계증명서)합격통지서 사본국민기초생활보장수급자증명서 및 차상위계층증명서 (해당자)'
    },
    {
      Col1: '재단법인청송군인재육성장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '국가대표 선발: 3000000원전국 1위:2000000원전국 2위:1500000원                 전국 3위 및 도단위 1위:1000000원 * 생활비 지원 목적',
      Col12: '대학교 예체능(미술/음악/체육/기타 기능) 특기 소유 학생전년도 도 단위 1위/ 전국대회 3위 이상 입상한 자관내 학교에 재학 또는 졸업하지 않은 특기소유 학생 중 전국대회 1위 입상 또는 국가대표 선발자(국가대표 후보 선발자는 제외)',
      Col13: '공고일 현재 부모 또는 보호자(부모가 없을 경우)의 주민등록이 청송군내에 있고 * 신입생: 관내 고등학교 졸업자 * 재학생: 관내 중학교 또는 고등학교 졸업자',
      Col14: '2022-02-16~2022-03-15',
      Col15: '적격자에 한해 이사회에서 심의 의결',
      Col16: '해당없음',
      Col17: '부모(부모가 없을 시 보호자)가 청송군 관외로 거주지를 이전하였을 때장학생 신청서 내용과 첨부서류가 허위로 작성 제출되었을 때  보호자 또는 장학생이 주민으로부터 지탄을 받을만한 불미스러운 행위를 하였을 때장학생이 퇴학하였거나 정학 이상의 징계 처분을 받았을 때군에 입대하거나 질병 등의 사유로 학업을 계속하기 곤란할 때학교장의 정지신청이 있을 때기타 이사장이 장학금의 지급을 정지할 필요가 있다고 인정할 때',
      Col18: '신입생: 관내 졸업고등학교 학교장 추천',
      Col19: '장학생지원(성적/ 특기/ 저소득 등) 신청서성적증명서 (신입생: 관내 고등학교 최종 내신 성적 / 재학생: 직전 학년(1학기/ 2학기) 성적)장학생추천서 (고등학생 및 대학교 신입생/ 저소득 4년제 대학생/ 경제적 어려움에 한함)특기성적증명서 (예/체능 특기자에 한함)장학금 지급 신청서관내 중학교 또는 고등학교 졸업증명서재학증명서장학금 (비)수혜 증명서 (대학교 신입생/재학생만 해당)주민등록등본주민등록초본(다자녀 가정 특별장학생에 한함)가족관계증명서   1) 주민등록등본 상 학생과 부모(보호자)가 따로 등재된 경우   2) 다자녀 가정 특별장학생의 경우 주민등록 주소 상이여부와 관계없이 부 또는 모(또는 보호자)의 기준으로 발급받아 제출 (다자녀 증빙이 가능한 가족관계증명서)합격통지서 사본국민기초생활보장수급자증명서 및 차상위계층증명서 (해당자)'
    },
    {
      Col1: '재단법인청송군인재육성장학회',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생: 관내 고등학교 최종 내신 성적이 100분의 30 이내인 자재학생: 직전 학년 평점이 4.5기준 시 3.0 이상인 자',
      Col10: '해당없음',
      Col11: '관내 고등학교 졸업자: 2000000원관내 중학교 졸업자: 1500000원  * 인재육성장학회에서 지원하는 성적우수자 중복지원 가능',
      Col12: '가정 내 가족(부모(보호자)/ 형제/자매) 중 중증질병/ 상해(교통사고 등) 또는 편부모 발생 등으로 경제적 어려움을 겪고 있는 가정의 자녀가 학업을 지속하기 어려운 경우',
      Col13: '공고일 현재 부모 또는 보호자(부모가 없을 경우)의 주민등록이 청송군내에 있고 * 신입생: 관내 고등학교 졸업자 * 재학생: 관내 중학교 또는 고등학교 졸업자',
      Col14: '2022-02-16~2022-03-15',
      Col15: '적격자에 한해 이사회에서 심의 의결',
      Col16: '해당없음',
      Col17: '부모(부모가 없을 시 보호자)가 청송군 관외로 거주지를 이전하였을 때장학생 신청서 내용과 첨부서류가 허위로 작성 제출되었을 때  보호자 또는 장학생이 주민으로부터 지탄을 받을만한 불미스러운 행위를 하였을 때장학생이 퇴학하였거나 정학 이상의 징계 처분을 받았을 때군에 입대하거나 질병 등의 사유로 학업을 계속하기 곤란할 때학교장의 정지신청이 있을 때기타 이사장이 장학금의 지급을 정지할 필요가 있다고 인정할 때',
      Col18: '사회복지과장의 추천',
      Col19: '장학생지원(성적/ 특기/ 저소득 등) 신청서성적증명서 (신입생: 관내 고등학교 최종 내신 성적 / 재학생: 직전 학년(1학기/ 2학기) 성적)장학생추천서 (고등학생 및 대학교 신입생/ 저소득 3년제이상 대학생/ 경제적 어려움에 한함)특기성적증명서 (예/체능 특기자에 한함)장학금 지급 신청서관내 중학교 또는 고등학교 졸업증명서재학증명서장학금 (비)수혜 증명서 (대학교 신입생/재학생만 해당)주민등록등본주민등록초본(다자녀 가정 특별장학생에 한함)가족관계증명서   1) 주민등록등본 상 학생과 부모(보호자)가 따로 등재된 경우   2) 다자녀 가정 특별장학생의 경우 주민등록 주소 상이여부와 관계없이 부 또는 모(또는 보호자)의 기준으로 발급받아 제출 (다자녀 증빙이 가능한 가족관계증명서)합격통지서 사본국민기초생활보장수급자증명서 및 차상위계층증명서 (해당자)'
    },
    {
      Col1: '재단법인청송군인재육성장학회',
      Col2: '다자녀가정특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '국민기초생활보장수급 및 차상위 자녀',
      Col11: '5000000원 ',
      Col12: '세 자녀 이상을 둔 가정의 셋째 자녀부터 신청가능',
      Col13: '공고일 현재 부모 또는 보호자(부모가 없을 경우)의 주민등록이 청송군내에 있고 * 신입생: 관내 고등학교 졸업자 * 재학생: 관내 중학교 또는 고등학교 졸업자',
      Col14: '2022-03-10~2022-03-24',
      Col15: '적격자에 한해 이사회에서 심의 의결',
      Col16: '해당없음',
      Col17: '부모(부모가 없을 시 보호자)가 청송군 관외로 거주지를 이전하였을 때장학생 신청서 내용과 첨부서류가 허위로 작성 제출되었을 때  보호자 또는 장학생이 주민으로부터 지탄을 받을만한 불미스러운 행위를 하였을 때장학생이 퇴학하였거나 정학 이상의 징계 처분을 받았을 때군에 입대하거나 질병 등의 사유로 학업을 계속하기 곤란할 때학교장의 정지신청이 있을 때기타 이사장이 장학금의 지급을 정지할 필요가 있다고 인정할 때',
      Col18: '신입생: 관내 졸업고등학교 학교장 추천',
      Col19: '장학생지원(성적/ 특기/ 저소득 등) 신청서성적증명서 (신입생: 관내 고등학교 최종 내신 성적 / 재학생: 직전 학년(1학기/ 2학기) 성적)장학생추천서 (고등학생 및 대학교 신입생/ 저소득 3년제 이상상대학생/ 경제적 어려움에 한함)특기성적증명서 (예/체능 특기자에 한함)장학금 지급 신청서관내 중학교 또는 고등학교 졸업증명서재학증명서장학금 (비)수혜 증명서 (대학교 신입생/재학생만 해당)주민등록등본주민등록초본(다자녀 가정 특별장학생에 한함)가족관계증명서   1) 주민등록등본 상 학생과 부모(보호자)가 따로 등재된 경우   2) 다자녀 가정 특별장학생의 경우 주민등록 주소 상이여부와 관계없이 부 또는 모(또는 보호자)의 기준으로 발급받아 제출 (다자녀 증빙이 가능한 가족관계증명서)합격통지서 사본국민기초생활보장수급자증명서 및 차상위계층증명서 (해당자)'
    },
    {
      Col1: '재단법인 당진장학회',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '고교 3학년 1학기까지(5개 학기)의 전 과목 평균등급(단위수 적용)이 2.0이내인 학생대학수학능력시험성적의 4개영역(국어/ 수학/ 영어/ 탐구영역 상위 2과목) 표준점수의 합계가 270점 이상이며/ 영어는 2등급 이내',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '관내 고등학교 졸업하고 대학에 진학한 학생',
      Col13: '공고일 현재 학생 또는 보호자가 당진시에 주민등록을 두고 1년 이상 계속하여 당진에 거주하고 있는 자관내 고등학교 졸업',
      Col14: '2022-03-10~2022-03-24',
      Col15: '접수(신청/추천서)심의위원회 심의이사회 확정',
      Col16: '35명',
      Col17: '휴학생/ 유학생/ 사이버대학생은 제외국가장학금 및 지방자치단체 장학금( 이장자녀장학금/ 새마을지도자 자녀장학금등)중복수혜자 제외',
      Col18: '지역핵심인재전형 학생 : 당진시장 추천',
      Col19: '신청서주민등록등본/초본 (반드시 주소변경등록사항 포함)재학증명서2021학년도 수능성적통지표 사본(원본대조필)(해당자만 제출)지방세 완납증명서(미과세 증명서) 부/모 각 1부기타 신청자격 증빙서류 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '재단법인 당진장학회',
      Col2: '우수장학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2학년이상 재학생으로 직전학년 두 학기 성적이 전과 목 백분율 90점 ㅇ이상인 학생',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '2년이상 재학생',
      Col13: '공고일 현재 학생 또는 보호자가 당진시에 주민등록을 두고 1년 이상 계속하여 당진에 거주하고 있는 자',
      Col14: '2022-03-10~2022-03-24',
      Col15: '접수(신청/추천서)심의위원회 심의이사회 확정',
      Col16: '40명',
      Col17: '휴학생/ 유학생/ 사이버대학생은 제외국가장학금 및 지방자치단체 장학금( 이장자녀장학금/ 새마을지도자 자녀장학금등)중복수혜자 제외',
      Col18: '해당없음',
      Col19: '신청서주민등록등본/초본 (반드시 주소변경등록사항 포함)재학증명서대학성적증명서지방세 완납증명서(미과세 증명서) 부/모 각 1부기타 신청자격 증빙서류통장사분 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '재단법인 당진장학회',
      Col2: '복지장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고등학교 3학년 1학기까지(5개 학기) 전 과목 내신 평균 6등급이내인 학생재학생 : 직전학년 두 학기 성적이 전과목 평균 백분율 70점 이상인 학생(인원초과시 성적순으로 선발)',
      Col10: ' * 아래에 어느 하나에라도 해당하는 자저소득가정 학생 중증장애(1~3등급)학생 및 의료보험공단에 중증환자로 등록된 학생 본인다자녀가정 학생 (3자녀 이상)다문화가정 학생새터민가정 학생',
      Col11: '2000000원 (생활비 명목)',
      Col12: '해당없음',
      Col13: '공고일 현재 학생 또는 보호자가 당진시에 주민등록을 두고 1년 이상 계속하여 당진에 거주하고 있는 자',
      Col14: '2022-07-18~2022-07-19',
      Col15: '접수(신청/추천서)심의위원회 심의이사회 확정',
      Col16: '대학교 : 40명',
      Col17: '휴학생/ 유학생/ 사이버대학생은 제외',
      Col18: '대학 총장 추천 ',
      Col19: '신청서개인정보이용동의서주민등록등본/초본 (반드시 주소변경등록사항 포함)재학증명서대학성적증명서2021년 건강보험료 납부확인서 부모 각 1부지방세 완납증명서 (미과세 증명서)부/모 각각 제출기타 신청자격 증빙서류통장사본 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '재단법인 윤송 조창석 문화재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/사회계열',
      Col9: '전년도 학기별 12학점 이상 이수자로 평점 3.5이상인자',
      Col10: '가정형편이 곤란하여 학업에 지장이 있는 학생(소득분위 고려)',
      Col11: '등록금전액(한국장학재단 지원금 공제한 최종 등록금액)',
      Col12: '2022년 2학기 기준 2학년 진학 예정자 * 각 학교 장학부서에 문의하여 재단으로 추천이 가능한지 문의교외장학금을 비롯한 학비감면 혜택을 받고 있지 않은 자 (국가장학금 제외)부모의 직장에서 자녀 장학금 지원혜택을 받고 있지 않은 자 금고 이상의 형 및 학교에서 징계처분을 받은 사실이 없는 자 ',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '타 기관 혹은 교내에서 장학금 및 이와 유사한 학비감면 등의 혜택  을 받고 있을 경우 자격제한(한국장학재단 제외)금고이상의 형 및 학교에서 징계처분 등을 받은 경우 자격제한',
      Col18: '학과장 또는 지도교수 추천',
      Col19: ' * 제출 전 각 학교 장학부서에 문의하여 추천 가능여부 확인 필수장학생지원서 성적증명서주민등록등본학과장 또는 지도교수 추천서자기소개서 및 학습계획서부양자 건강보험료납부확인서(2021)개인정보수집이용 및 제공 동의서 '
    },
    {
      Col1: '경기도민회장학회',
      Col2: '성적/소득장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전학기 12학점 이상 이수/ 평점평균 B이상신입생 : 수능성적 또는 고교 32학기 내신성적 전과목 평균 80점이상 (상위 100분의 20이내)',
      Col10: '2020년도 부모 연간 건강보험료 고지 합산금액이 400만원 이하 ',
      Col11: '대학생 : 4000000원전문대생 : 3000000원 * 장학금 지급기간 1년(휴학퇴학타장학금 등록금초과자  제외) * 2학기에는 별도 선발하지 않으며 장학금은 학기별로 50%씩 지급',
      Col12: '국내에 소재 학교에 재학중 이거나/ 신입(편입) 또는 복학 예정인 학생 ',
      Col13: '경기도내 연속 거주 3년 이상 (2019.02.19 이후)',
      Col14: '2022-02-07~2022-02-18',
      Col15: ' * 평가기준성적(30)+소득수준(60)+자원봉사(5)+다자녀(3이상)(5)장애인 가정 가점 : 5점(등급별 차등 배점)',
      Col16: '대학생 : 314명전문대생 : 90명',
      Col17: '해당없음',
      Col18: '시장/ 군수(시/ 군민화장)의 추천',
      Col19: '신청서주민등록표 등본교육비 납입증명서21년 2학기 성적즈염ㅇ서21년 건강보험료납부확인서 및 건강보험자격득실확인서서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '경기도민회장학회',
      Col2: '예능체육특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '예/체능 특기생 : 2021년도 전국 및 광역 시/도 단위 이상 대회에서 수상한 실적이 있는 학생* 예능 범위 : 사진/ 국악/ 음악/ 무용/ 미술/ 문학/ 연예/ 연극/ 건축/ 영화',
      Col10: '해당없음',
      Col11: '예/체능 특기 장학생 : 1000000원 * 2학기에는 별도선발 하지 않음 (학기별로 50%씩 지급)',
      Col12: '국내에 소재 학교에 재학중 이거나/ 신입(편입) 또는 복학 예정인 학생2021년도 전국 및 광역시/ 도단위 이상 대회 수상한 실적이 반드시 있는 학생 ',
      Col13: '2019년 2월 19일 부터 현재 주민등록상 부/모 (기혼자는 본인)가 3년이상 연속하여 경기도내에서 거주하고 있는 경기도민의 자녀(관외거주) 경기도민회 가입 3년 이상된 회원의 자녀',
      Col14: '2022-02-28~2022-03-14',
      Col15: '대회 규모/ 주최/ 시상내역/ 참가방식 등을 고려하여 선발 * 자세한 기준표는 첨부파일 참고고',
      Col16: '체육특기생:26명예능특기생:24명',
      Col17: '학기중 휴학/ 조기졸업/ 퇴학등의 사유로 학업을 중단하는 경우',
      Col18: '경기도 체육회장/ 예총경기도 연합회장의 추천',
      Col19: '장학생 선발 신청서주민등록표 등본예능/체육대회 입상 상장 사본재학증명서(신입생은 등록금 납부 영수증등 입증 서류) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '장보고장학회(완도군청)',
      Col2: '대학신입장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '고등학교 성적증명서 제출자 : 3학년 1학기 교과목 등급 ‘5등급’이상(단/ 조기졸업자는 최종학기 교과목 등급 ‘5등급’이상)',
      Col10: '해당없음',
      Col11: '1인당 2000000원',
      Col12: '2022학년도 대학교 신입생',
      Col13: '완도군 소재 고등학교 졸업하고 2022학년도 대학생 신입생인 자공고일 기준 1년이상 보호자 또는 본인이 완도군에 주민등록을 둔 자',
      Col14: '2022-05-09~2022-05-20',
      Col15: '학업성적(90) + 생활정도(10)',
      Col16: '일반대학교(2년제이상) : 30명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '대학신입생 장학금 신청서주민등록 등본(거주확인) (부/모/학생의 주소가 다를 경우 : 부/모 주민등록등본 1부/ 가족관계증명서 1부/ 한부모 가정의 경우 : 혼인관계증명서 등 증명서류 추가등록금납부확인서성적증명서(3학년 1학기 성적증명서 : 생활기록부) 2021 지방세 세목별 과세증명서(주택/토지/건물포함) 1부   * 부/모 각각 1부(과세내역이 없는 경우는 미과세증명서 각각 1부)건강보험납부확인서(최근 3개월)   * 부/모 각각 1부(1인이 납부할 경우 건강보험증 사본 1부 추가)국민기초생활수급자증명서(해당자) * 제출처 : 읍/면사무소 총무담당(보호자의 주민등록지 관할 읍면)'
    },
    {
      Col1: '장보고장학회(완도군청)',
      Col2: '성적우수자',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학기 성적 환산점수 평균 80점 이상인 자 (대학생 평균학점 “B학점”이상)',
      Col10: '재산세(지방세 기준) 20만원 이하 전답 20000㎡이하',
      Col11: '실납부액에 따라 차등지급 ( 1000000원 ~ 2000000원 전문대생은 최대 100만원 )',
      Col12: '2년제 이상 대학생은 완도군 관내지역 고교 졸업자',
      Col13: '학생본인 및 보호자가 공고일 기준 완도군에 1년이상 완도군 거주자로서 완도군 관내지역 고교 졸업자  * 단/ 2년제 이상 대학생의 경우 학생 본인에 한하여 타 지역 주소 인정',
      Col14: '2022-05-09~2022-05-20',
      Col15: '선발기준 : 성적 80%/ 소득 20%',
      Col16: '00명',
      Col17: '만 30세 이상2021년 하하반기 장보고장학회 장학금 수혜자대학교 신입생장학금 종류별 중복 신청 및 1가정 2인 선발의 경우 1인 지원질병/ 입영/ 취업 등을 위해 휴학한 경우',
      Col18: '해당없음',
      Col19: '장학금 지원신청서주민등록등본등록금납부확인서성적증명서재학증명서졸업증명서2021년도도 지방세세목별과세증명서건강보험납부확인서(최근 3개월)통장사본 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '장보고장학회(완도군청)',
      Col2: '저소득자녀',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학기 성적 환산점수 평균 60점 이상인 자(대학생 평균학점 “C학점”이상)',
      Col10: '보호자 전답 5000㎡ 이하 재산세(지방세 기준) 10만원 이하인 자',
      Col11: '실납부액에 따라 차등지급 * 자세한 사항은 첨부파일 참고',
      Col12: '완도군 관내 고등학교 출신 대학교 재학생으로서/ 경제 사정이 어려운 자',
      Col13: '학생본인 및 친권자가 공고일 기준 완도군에 1년이상 거주자로서 관내 고등학교 졸업자  * 단/ 2년제 이상 대학생의 경우 학생 본인에 한하여 타 지역 주소 인정',
      Col14: '2022-03-07~2022-03-18',
      Col15: '성적 20% + 소득 80%',
      Col16: '00명',
      Col17: '2021년 하하반기 장보고장학회 장학금 수혜자대학교 신입생인 경우장학금 종류별 중복 신청 및 1가정 2인 선발의 경우 1인 지원질병/ 입영/ 취업 등을 위해 휴학한 경우',
      Col18: '해당없음',
      Col19: '장학금 지원신청서주민등록등본등록금 납부확인서성적증명서재학증명서졸업증명서직전년도 지방세세목별과세증명서건강보험 납부확인서(최근 3개월)해당자 증빙서류(해당자) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '장보고장학회(완도군청)',
      Col2: '다자녀가정',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '완도 거주 대학생으로 다자녀 가구의 자녀 중 1명',
      Col13: '학생본인 및 친권자가 1년 이상 완도군에 주소를 두고 거주하고 있는 대학생2년제 이상 대학생의 경우 완도군 관내지역 고교 졸업생',
      Col14: '2021-10-18~2021-11-12',
      Col15: '선발기준 : 자녀수 50%/ 소득 평가 50% * 세부사항은 첨부파일 참조',
      Col16: 'OO명',
      Col17: '최근 2년간 수혜가정 제외국가 등으로부터 등록금/ 수업료 등을 전액 지원받는 육사/ 해사/ 공사/ 경찰대 등과 매학기 등록금 총액이 1/200천원 이하인 대학생타 기관으로부터 받은 장학금 총액이 등록금 범위를 초과하거나 그 차액이 20만원 미만인 대학생질병/ 입영/ 취업 등을 위해 휴학한 자상반기 기수혜자',
      Col18: '해당없음',
      Col19: '장학금 지원신청서등록금납부확인서주민등록등본가족관계증명서재학증명서졸업증명서건강보험료 납부확인서(최근 3개월)국민기초생활수급자 또는 차상위계층 증명서(해당자) * 자세한 사항은 첨부파일 참조 주민등록지 관할 읍·면사무소 총무팀 또는 복지팀으로 접수'
    },
    {
      Col1: '(재)두산연강재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체 학기 성적 3.0/4.5이상',
      Col10: '신청학기 기준 한국장학재단 소득분위 6분위 이내인 자',
      Col11: '졸업시까지 등록금 전액 지원장학생 워크숍 및 소모임 참여 제공 * 재단 내부 기준 충족시 계속 지원',
      Col12: '2022년도 기준 국내 4년제 대학교 2학년 진학 예정자로서/ 재단 주최 행사에 지속적으로 참여가능자  * 장학금 계속 지원 요건 : 직전 2개 학기 성적 3.0/4.5 이상 / 재단 행사 참여 / 기타 재단 내부 기준 충족자',
      Col13: '해당없음',
      Col14: '2021-10-27~2021-11-12',
      Col15: '1차 서류2차 면접',
      Col16: '00명',
      Col17: '타 장학금 수혜(예정)자',
      Col18: '해당없음',
      Col19: '추천서 (재단 양식)재학(휴학)증명서성적 증명서신청학기 한국장학재단 소득분위 화면 캡쳐본가계곤란 증빙서류 (해당자)가족관계증명서  * 모든 서류의 주민등록번호 뒷자리는 삭제후 제출'
    },
    {
      Col1: '(재)미래인재육성재단',
      Col2: '우수장학금 ',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '백분위 85/100점 이상',
      Col10: '한국장학재단 소득분위 4~8분위 대상자',
      Col11: '졸업시까지 생활비성 학업장려금 3000000원 ※ 학기당 정액지원',
      Col12: '2022년도 2학년 1학기 등록(복학)예정자이공/ 상경/ 언론/ 법학분야 우대 ',
      Col13: '해당없음',
      Col14: '2022-09-01~2022-09-27',
      Col15: '해당없음',
      Col16: '각 학교별 선발인원 및 조건이 상이하므로 학교 장학 홈페이지 참고',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '학교장 추천서장학생 신청서자기소개서개인정보수집이용동의서성적증명서소득분위 확인서서'
    },
    {
      Col1: '(재)앨트웰민초장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '총 15학점 이상 이수하고/ 평점 A(4.0/4.5/ 3.7/4.3만점)  이상인 자 (계절학기 학점 제외)',
      Col10: '해당없음',
      Col11: '등록금 전액 + 면학보조금(매월 350000원)  * 2023년 1학기 부터 총 6개 학기 지급',
      Col12: '2022년 9월 현재 국내 4년제 대학교 1학년 2학기에 재학 중인 자공직/언론/연구 및 기타 전문직 진출 희망자',
      Col13: '해당없음',
      Col14: '2022-09-01~2022-10-14',
      Col15: '1차 서류전형2차 면접',
      Col16: '30명 예정',
      Col17: '의료계열(의/약/간호학 등) 제외국가유공자 등 법령 등에 의하여 등록금 전액을 면제받는 자타 장학금 수혜(예정)자',
      Col18: '해당없음',
      Col19: '장학생 지원서자기소개서대학교 성적증명서 원본수능 성적표 원본 또는 사본(정시 합격자)수능 성적표 또는 고등학교 성적증명서 원본 또는 사본(수시 합격자)학자금 지원구간 통지서(2022년도분 전체) * 양식 다운로드 및 자세한 사항 확인은 기관 홈페이지 참조'
    },
    {
      Col1: '(재)수림재단',
      Col2: '동교인재 장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학7학기/대학8학기이상',
      Col8: '공학계열/자연계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '(대상) 5000000원(금상) 3000000원(은상) 1000000원 ※ 1회성 포상 장학금',
      Col12: '국내 4년제 이상 대학의 최종 학년 재학생(휴학생 포함)으로서 재학 중에 성취한 탁월한 공적으로 타의 모범이 되고/ 대학의 명예 선양과 발전에 크게 기여한 개인 또는 단체 * 단체의 경우 지원하는 팀의 대표가 최종 학년에 해당하면 지원 가능',
      Col13: '해당없음',
      Col14: '2022-02-28~2022-03-18',
      Col15: '1차: 서류전형2차: 면접',
      Col16: '20명(팀) 이내',
      Col17: ' * 자세한 사항은 기관으로 문의 바랍니다.',
      Col18: '서류 전형 합격시 추천서 제출',
      Col19: '지원 신청서공적 자술서공적 증빙서류 및 관련 보도자료재학 또는 휴학 증명서개인정보 수집·이용 및 제공에 관한 동의서추천서 및 추천인의 개인정보 수집·이용에 관한 동의서 (서류합격 합격자 대상) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '사단법인 서천사랑장학회',
      Col2: '열정장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생(우선선발관내 고교 졸업자) : 고교 내신성적의 합이 1.5이내/ 수능성적 2개 영역 중 등급의 합이 3이내인자신입생(일반선발관내 고교 졸업자) : 고교 내신성적의 합이 2.0이내이거나 수능성적 2개 영역 중 등급 합이 5이내인 자신입생(일반선발관내 초/중 졸업자) : 고교 내신성적의 합이 2.0이내이거나  수능성적 2개영역 중 1등급이 3개 영역 이상인 자재학생(선발대상 전원) : 대학교 입학시 우선선발 열정장학생으로 선발된 자로서/ 직전학년 성적이 평균 3.5 이상인 자재학생 : 관내 중학교 또는 고등학교 졸업하고 대학 재학 중 직전학년 성적이 평균 3.8이상인 자(가군) / 평균  4.0이상인 자(나군)',
      Col10: '해당없음',
      Col11: '대학교 1학년 : 우선 5000000원/일반선발 2000000원 대학교 24학년 : 2000000원',
      Col12: '해당없음',
      Col13: ' * 현재 본인 또는 부모가 서천군 내 주소지를 둔 자신입생(우선) : 관내 고교 졸업신입생(일반) : 관내 초교와 중학교를 졸업한 자 / 관내 고교 졸업생재학생 : 관내 중학교 또는 고교 졸업',
      Col14: '2022-02-28~2022-03-18',
      Col15: '해당없음',
      Col16: '대학교 1학년(우선선발) : 전원대학교 1학년(일반선발관내 고교 졸업자) : 12명 신입생(일반선발관내 초/중 졸업자) : 6명재학생(계속) : 전원재학생 : 가군 10명/ 나군 20명  * 가군/ 나군 자격은 첨부파일 확인 요망',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 신입생장학금지급신청서내신성적 산출프로그램 백분율 산출대상(출신고등학교장)재학증명서(등록금 납입영수증)관내 고교졸업증명서자기소개서주민등록등본서약서개인정보제공동의서 * 재학생장학금지급신청서 직전학년 성적증명서재학증명서 주민등록등본자기소개서서약서개인정보 제공동의서 * 그외 자세한 사항은 홈페이지 참고 필수'
    },
    {
      Col1: '사단법인 서천사랑장학회',
      Col2: '드림장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '가정형편이 어려운 자',
      Col11: '2000000원',
      Col12: '관내 중학교 또는 고등학교 졸업생 중 가정형편이 어렵고 타의 모범이 되는자 (4년중 2회에 한함)',
      Col13: '공고일 현재 본인 또는 본인의 부모가 서천군 내 주소지를 둔 자관내 중학교 또는 고등학교 졸업생',
      Col14: '2022-02-28~2022-03-18',
      Col15: '서류 심사 및 사실 조사',
      Col16: '15명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 지급신청서직전학년성적증명서재학증명서 최종학교 졸업증명서자기소개서주민등록 등본 서약서건강보험료 납부확인서 (2020년도분)건강보험증 사본세목별과세증명서개인정보제공동의서 * 수급자증명서 첨부할 경우 건강보험 관련 서류 미첨부 * 자세한 사항은 홈페이지 게시판 참고 필수'
    },
    {
      Col1: '사단법인 서천사랑장학회',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '국가대표 향우회 자녀: 1000000원근로자 자녀: 500000원',
      Col12: '관내 초중고등학교 재학생 및 졸업생(대학생) 중 꿈나무 대표선수 및 국가대표 선수로 선발된 자서천군 내 초·중학교를 졸업하였거나 지역에 연고가 있는 출향 인사의 자녀 / 향우회 자녀40세 이상인자가 고졸검정고시에 합격한 후 대학교에 입학한 자 * 자세한 내용은 첨부파일 참고',
      Col13: '서천군 내 초·중학교를 졸업하였거나 지역에 연고가 있는 출향 인사의 자녀 / 향우회 자녀',
      Col14: '2022-02-28~2022-03-18',
      Col15: '해당없음',
      Col16: '자세한 사항은 첨부파일 참고 ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금추천서주민등록등본최종학교 졸업증명서재학증명서서약서서관련증빙자료(2020년도 성적증명서 및 상장 등)개인정보제공동의서'
    },
    {
      Col1: '사단법인 서천사랑장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1위:1000000원/단체 2000000원2위:700000원/단체 1500000원3위:500000원/단체 1000000원',
      Col12: '관내 초/중/고등학교 재학생/ 졸업생전국규모 체육·기능대회 3위내 입상자대상범위 : 전국(장애인)체전/ 전국기능경기대회/ 전국소년(장애인학생)체전/ 충남도민체육대회/ 충남소년체육대회 * 자세한 사항은 첨부파일 참고',
      Col13: '공고일 현재 본인 또는 본인의 부모가 서천군 내 주소지를 둔 자관내 초/중/고등학교 재학생/ 졸업생생',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '선발 대상 전원',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서입상증명서 대회요강자료주민등록등본서약서관내최종학교졸업증명서(대학생인 경우만)개인정보제공동의서 * 자세한 사항은 홈페이지 게시판 참고 필수'
    },
    {
      Col1: '(재)송원문화재단',
      Col2: '송원장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '등록금 전액 * 2년간(4학기 연속지급)',
      Col12: '부산대/ 동아대/ 경북대/ 영남대/ 충남대/ 충북대/ 인천대/ 인하대에 재학중인 금속재료/ 기계/ 전기 계열전공학생2학년 2학기 과정을 수료한 학생(2022년도 2월 기준/ 3학년 1학기 과정 진학예정자)선발 후 4학기 이내 졸업 가능자(2024년 2월 졸업)',
      Col13: '해당없음',
      Col14: '2022-03-02~2022-03-16',
      Col15: '1차 서류/ 2차 면접',
      Col16: '해당없음',
      Col17: '휴학/ 성적 미달 등 지급불가 사유시 지급 중단',
      Col18: '해당없음',
      Col19: '지원서성적증명서 사본 (전채 학기 평점이 표기) * 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '영양군인재육성장학회',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학수학능력시험 중 언어영역/ 수리영역/ 외국어영역 3개 과목 중 등급성적이 1등급 1개 과목/ 2등급 2개 과목 그 이상의 성적으로 대학에 입학한 신입생',
      Col10: '해당없음',
      Col11: '관내고등학교 졸업 신입생 : 3000000원 (1회에 한함)관외고등학교 졸업한 신입생: 1000000원 ',
      Col12: '해당없음',
      Col13: '선발신청일(2022. 03. 2일 기준) 현재 부모 또는 보호자(부모가 없는 1경우)의 주민등록이 영양군 관내에 3년 이상 주소를 두고 있는 군민의 자녀 ',
      Col14: '2022-03-02~2022-03-16',
      Col15: '장학재단 정관 및 운영규정에 의하여 영양군인재육성장학회 장학심의위원회에서 심의',
      Col16: '5명(대학수능시험 우수 신입생)',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원신청서장학생 지급신청서서약서장학생 주민등록초본부 또는 모 기준 가족관계증명서수능성적증명서사본고교졸업증명서대학교 재학증명서전년도 건강보험료 납부확인서(또는 국민기초생활보장수급증명서)부모 또는 보호자 주민등록초본'
    },
    {
      Col1: '영양군인재육성장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '500000원 (전국대회 1위 100만원 2위 50만원 3위 30만원)',
      Col12: '공인된 기관단체/ 협회에서 주최한 예/체능(미술/ 음악/ 체육/ 기타기능) 도단위 대회 1위/ 전국단위 대회에서 3위 이상 입상한 자 중 영양교육지원청 또는 해당 기관단체/협회장의 추천을 받은 자예능/ 체육/ 기능에 소질과 재능이 뛰어난 학생으로 신청일 기준 2년 이내에 도 주관이상의 대회에서 입상하여 지역의 명예를 드높인 학생',
      Col13: '선발신청일(2022.3.2.기준) 현재 부모 또는 보호자(부모가 없는 경우)의 주민등록이 영양군 관내에 3년 이상 주소를 두고 있는 군민의 자녀',
      Col14: '2022-01-03~2022-02-06',
      Col15: '장학재단 정관 및 운영규정에 의하여 영양군인재육성장학회 장학심의위원회에서 심의',
      Col16: '5명(중/고/대학생 및 일반인) ',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원신청서장학생 지급신청서서약서장학생 주민등록초본부 또는 모 기준 가족관계증명서특기장학생 추천서재학증명서전년도 건강보험료 납부확인서 (또는 국민기초생활보장수급자증명서)입상 증명 서류부모 또는 보호자 주민등록초본* 입상 성적이 다수라도 상위 성적 1회로 한정함함'
    },
    {
      Col1: '호반장학재단',
      Col2: '호반장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '3개 영역이상 3등급 이상(한국사는 별도 1개 영역으로 인정)',
      Col10: '중위소득 150%이하 재산세(주택토지건물)합산',
      Col11: '대학교 4년간 매학기 장학금 지원(총 8학기) * 학기당 3000000원',
      Col12: '2022년 대학교 입학예정자상경(경영/회계 등)/ 인문(자율전공/ 행정 등)/ 공학(건축/토목 등) 계열전공진학자(우재)',
      Col13: '해당없음',
      Col14: '2022-04-25~2022-05-06',
      Col15: '1차 서류전형2차 면접심사최종선정',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '개인정보이용동의서 (온라인으로 사전동의)대학합격 증명서수학능력시험 성적표(수학능력시험 응시자에 한함) 경제적 상황 증빙서류 * 자세한 사항은 호반장학재단 홈페이지 공지사항 참고'
    },
    {
      Col1: '양평군교육발전위원회',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(신입생)수능성적의 영역별 평균등급 3등급 이내 또는 고등학교 전체학년 내신성적 평균등급 3등급 이내내(재학생)4년제 대학 : 평점3.8점(4.5만점)이상 / 평점3.6이상(4.3만점) / 평점 3.4 (4.0만점)이상 2~3년제 대학 : 평점 4.0이상 /평점3.8(4.3만점) / 평점3.6이상(4.0만점)',
      Col10: '제한없음',
      Col11: '1인당 1500000원',
      Col12: '해당없음',
      Col13: '2022. 03. 02일 현재 주민등록상 부 또는 모(기혼자는 본인)가 3년이상 양평군에 거주하고/ 양평군 관내 고등학교를 졸업한 대학생관외 고등학교 졸업 시 부 또는 모가 양평균에 7년 이상 거주',
      Col14: '2022-04-25~2022-05-06',
      Col15: '해당없음',
      Col16: '유자격자 전원',
      Col17: '휴학생/  대학원생/ 외국유학생/ 방송통신대학생/ 산업체 위탁교육생/ 원격대학과 학점은행제 대학생/ 교환학생/ 직업전문학교 재학생은 제외 (단/ 학위인정 직업전문학교생 예외)만 35세 이상 제외학생이 직장인/ 자영업 등 개인 소득 있는 경우 제외외',
      Col18: '* 가정형편이 어려운 학생은 읍/면별 인구수에 비례하여 읍/면에서 선정위원회를 구성 심사하여 읍/면장이 추천',
      Col19: '성적우수 장학생 신청서 및 구비서류 * 신청서는 홈페이지 공지사항 참고'
    },
    {
      Col1: '양평군교육발전위원회',
      Col2: '예/체능특기생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '체육측기생 : 2021년도 국제대회/ 전국체육대회/ 전국대회 3위 이상 수상예능특기생 : 2021년도 국제대회/ 전국대회 3위 이상 수상',
      Col10: '제한 없음',
      Col11: '1인당 1500000원',
      Col12: '해당없음',
      Col13: '2022. 03. 02일 현재 주민등록상 부 또는 모(기혼자는 본인)가 3년이상 양평군에 거주하고/ 양평군 관내 고등학교를 졸업한 대학생국내 소재 대학교에 재학중 이거나/ 신입(편입) 또는 복학예정인 대학생',
      Col14: '2022-04-25~2022-05-06',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '광역시/도 단위 및 자치단체(시/군)단위 이하 대회/ 기업체/ 대학/ 공기업/ 개인이 주최하는 대회/ 생활체육대회 등은 제외만 35세 이상 지우너 불가',
      Col18: '해당없음',
      Col19: '예체능특기 장학생 신청서 및 구비서류 * 신청서는 홈페이지 공지사항 참고'
    },
    {
      Col1: '양평군교육발전위원회',
      Col2: '다자녀가정장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년(2개학기) 24학점 이상 이수/ 평균평점 2.8이상 (4.5만점)/    2.6이상 (4.3만점) / 2.4이상 (4.0만점)대학신입생 : 수능성적의 과목별 백분위 점수 60점 이상/ 또는 전체학년(1~3학년) 내신성적 과목별 원점수의 과목펼 평균 60점 이상',
      Col10: '해당없음',
      Col11: '1인당 1500000원',
      Col12: '3자녀 이상 : 가족관계증명서상 자녀로 등재 * 3자녀 이상가정이면 첫째/ 둘째 자녀도 신청 가능함함',
      Col13: '2022. 03. 02일 현재 주민등록상 부 또는 모(기혼자는 본인)가 3년이상 양평군에 거주하고/ 양평군 관내 고등학교를 졸업한 대학생관외 고등학교 졸업 시 부 또는 모 7년 이상 거주',
      Col14: '2021-12-20~2022-01-14',
      Col15: '다자녀 여부/ 소득/ 성적 등을 고려',
      Col16: '해당없음',
      Col17: '휴학생/  대학원생/ 외국유학생/ 방송통신대학생/ 산업체 위탁교육생/ 원격대학과 학점은행제 대학생/ 교환학생/ 직업전문학교 재학생은 제외 (단/ 학위인정 직업전문학교생 예외)만 35세 이상 제외',
      Col18: '해당없음',
      Col19: '다자녀가정 장학생 신청서 및 구비서류 * 신청서는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 우양',
      Col2: '복지시설출신대학생장학(다솜)',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학5학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 2.5/4.5 이상인 학생. ',
      Col10: '해당없음',
      Col11: '한 학기당 1000000원 * 최대 4학기 지급(졸업학기까지)',
      Col12: ' 보육시설 또는 생활보호시설에서 자란 우수하고/ 사회환원 의식이 투철한 학생서울/ 경인지역 4년제 대학생의 경우 새학기에 3학년(5학기) 과정 등록 예정인 자 / 서울/ 경인지역 전문대학생의 경우 새학기에 2학년(3학기) 등록예정인 학생',
      Col13: '서울/ 경인지역',
      Col14: '2021-12-20~2022-01-14',
      Col15: '1차 서류 전형2차 면접',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 신청시 재단 홈페이지 공고 확인 필수'
    },
    {
      Col1: '재단법인 우양',
      Col2: '탈북대학생장학금(나래)',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 2.5(4.5) 이상인 학생',
      Col10: '해당없음',
      Col11: '매 학기 1000000원의 학업장려금이 졸업시 까지 지원 * 이중수혜 가능',
      Col12: '북한이탈주민으로 정규 4년제 대학에 재학중인 학생북한이탈주민 중 인성이 바르고 우수하며/ 사회환원 의식이 투철한 학생',
      Col13: '해당없음',
      Col14: '2022-03-18~2022-04-01',
      Col15: '1차 서류전형2차 면접 ',
      Col16: '해당없음',
      Col17: '사이버대/방송통신대 제외',
      Col18: '해당없음',
      Col19: ' * 신청시 재단 홈페이지 공고 확인 필수 * 우편 접수: 서울시 마포구 월드컵북로 5길 59 우양빌딩 2층 프로그램2팀 '
    },
    {
      Col1: '재단법인 우양',
      Col2: '농어촌목회자자녀및신학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '지난 학기 평점이 3.0/4.5 이상',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '감리교 홀사모의 자녀나 농어촌(읍/면/리)에 위치한 감리교 목회자의 자녀 중 2학년 1학기(3학기)이상인 학생',
      Col13: '해당없음',
      Col14: '2022-03-18~2022-04-01',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서자기소개서성적증명서가족관계증명서건강보험료납부확인서교회 통계표 사본(전년도 감리사 도장 찍힌 것 앞/ 뒤 모두)부채증명서 * 등기 우편접수만 가능 : 서울 마포구 월드컵북로5길 59/ 2층 프로그램 1팀. 자세한 사항은 홈페이지 참고 필수'
    },
    {
      Col1: '재단법인 우양',
      Col2: '대학원장학금(늘품)',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원',
      Col7: '석사2학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '국내 정규 대학원에서 한 학기 이상 수료한 자로/ 직전학기 성적이 B+ 이상인 학생 ',
      Col10: '해당없음',
      Col11: '1000000원 * 학업장려금으로 최대 2학기 지원',
      Col12: ' * 아래 두 조건중 하나 충족하는 국내 정규 대학원 한 학기 이상 수료자로/ 직전학기 성적이 B+ 이상인 학생우양재단에서 장학금을 수혜 받았던 대학 졸업생우양재단에서 진행하는 프로그램을 참가했던 탈북민',
      Col13: '해당없음',
      Col14: '2022-03-16~2022-04-01',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: ' * 자세한 사항은 선발 기관으로 문의 바랍니다.',
      Col18: '소속학과 교수의 추천서 제출',
      Col19: '대학원석사과정 장학금 신청서해당학과 교수 추천서대학졸업 증명서성적증명서 (직전학기)북한이탈주민등록확인서(해당자) * 자세한 사항은 기관 홈페이지 내 공고문 참조'
    },
    {
      Col1: '재단법인 우양',
      Col2: '자매애청년장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 3.0/4.5(4.3만점일 경우 3.3) 이상',
      Col10: '가정형편이 어려운 학생(수급자 차상위 한부모증명서 학자금지원구간확인서(4분위 이하)중 해당되는 서류 1부',
      Col11: '한 학기 1000000원 ※ 학업장려금 1년 2회 지원',
      Col12: '모자가정 여성가장의 딸로서 현재 서울/경인/충청/강원 지역 정규 4년제 대학의 4학년 1학기 재학중인 학생가정형편이 어렵지만 학업성적이 우수하고 사회환원 의식이 투철한 학생',
      Col13: '서울/경인/충청/강원 지역 4년제 대학교',
      Col14: '2022-03-18~2022-04-01',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '신청서자기소개서(A4 3장이내)가족관계증명서주민등록등본대학교 재학증명서성적증명서경제형편서류 ※ 등기우편접수만 가능. 자세한 사항은 홈페이지 참고 필수.'
    },
    {
      Col1: '재단법인 우양',
      Col2: '남진순청년장학생(독립유공자후손)',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '4년제 대학에 재학 중인 4학년(7/8학기) 학생으로 직전학기 성적 3.0이상의 학생',
      Col10: '경제적 어려움을 겪는 학생',
      Col11: '연 최대 2000000원원 ※ 학업장려금 1년 지원',
      Col12: '국가 독립유공자의 후손서울/경인/충청지역 정규 4년제 대학에 재학 중인 4학년 학생학업성적이 우수하고/ 사회환원 의식이 투철한 학생',
      Col13: '서울/경인/충청지역 정규 4년제 대학',
      Col14: '2022-03-18~2022-04-01',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '휴학 시 장학생 탈락',
      Col18: '해당없음',
      Col19: '신청서자기소개서(A4 3장  이내)독립유공자 가정 증명서(독립유공자 카드 사본)주민등록등본성적증명서신분증 사본/ 통장사본(본인명의) ※ 등기우편접수로만 가능/ 자세한 사항은 홈페이지 참고 필수'
    },
    {
      Col1: '재단법인 우양',
      Col2: '북평고졸업대학장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평점 3.0 이상(신입생은 해당없음)',
      Col10: '해당없음',
      Col11: '연 최대 2000000원 * 이중수혜 가능',
      Col12: '북평고등학교(강원도 동해시 소재) 졸업자 중 국내 4년제 대학(서울권 대학학 및 지방 국립대) 재학중인 자',
      Col13: '해당없음',
      Col14: '2021-12-20~2022-01-14',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금신청서가족관계증명서자기소개서신분증/ 통장사본고등학교 졸업증명서(신규 신청자)재학증명서(신규 신청자)성적증명서(기존) ※ 등기우편 제출/ 자세한 사항은 홈페이지 공고 참고'
    },
    {
      Col1: '재단법인 우양',
      Col2: '드림장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학5학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 학점 평점이 3.0/4.5(4.3)이상',
      Col10: '해당없음',
      Col11: '3.0이상: 1학기 3000000원 한도 내에서 등록금 지급4.0이상: 전액장학금 * 중복수혜 불가능',
      Col12: '학업성적이 우수하고/ 가정형편은 어렵지만 봉사활동에 투철한 관심이 있는 대학생4년제 서울대/ 연세대/ 고려대/ 이화여대/ 서강대(서울소재)에만 재학중인 대학생2022년 선발시 3학년(5학기) 진학예정자',
      Col13: '해당없음',
      Col14: '2022-09-01~2022-10-05',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '이중수혜자',
      Col18: '해당없음',
      Col19: '장학금 신청서자기소개서가족관계증명서성적증명서재학증명서가정경제형편 증명 서류기타(수상/ 입상/ 표창/ 봉사활동 등 증빙서류 첨부시 기재) * 우편접수: 서울시 마포구 월드컵북로 5길 59 우양빌딩 2층 프로그램2팀 '
    },
    {
      Col1: '재단법인 두을장학재단',
      Col2: '두을장학재단장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '1학기 총 15학점 이상을 이수하고/ 성적이 3.5이상(4.5만점)인 자   (단/ 4.3만점인 학교는 3.34이상 / 계절학기 성적은 포함되지 않음)',
      Col10: '생활환경이 어려운 자 우대',
      Col11: '2학년 1학기~졸업시까지 등록금 전액(학점 및 활동평가)매학기 자기계발비 지원(학기당 60만원)',
      Col12: '두을장학재단의 비전에 공감하며/ 차세대 여성지도자가 되기를 희망하는 자22학번 1학년 2학기 재학 중인 여학생대한민국 국적자이공계 학생 우대 * 대상학교 : 강원대/ 경북대/ 고려대/ 부산대/ 서강대/ 서울대/ 성균관대/ 숙명여대/ 연세대/ 이화여대/ 전남대/ 전북대/ 제주대/ 충남대/ 충북대/ 한양대',
      Col13: '해당없음',
      Col14: '2022-03-07~2022-03-18',
      Col15: '1차 서류전형2차 면접',
      Col16: '30명',
      Col17: '1998년 3월 1일 이후 출생자/ 대한민국 국적을 가진 자에 한함함',
      Col18: '해당학부 지도교수 추천',
      Col19: '온라인 신청서 및 접수표 출력본대학교 성적증명서에세이 1부가족관계증명서 또는 등본직전년도 및 당해년도 보호자 지방세 세목별 과세(비과세) 증명서당해년도 건강·장기요양보험료 납부확인서건강보험증 사본 또는 건강보험자격확인서기타 해당자 증빙서류(해당자) * 자세한 사항 첨부파일 참조'
    },
    {
      Col1: '태안군사랑장학회',
      Col2: '복지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전학기 평점 4.5만점 2.5(C+) 이상이며 직적학기 이수학점이 18학점 이상인 자',
      Col10: '입학생 : 기초수급자 차상위계층 한부모가정 공동생활가정재학생 : 3개월간 건강보험료 평균 납부금액이 중위소득 기준 50% 이하에 해당는 자',
      Col11: '4000000원',
      Col12: '입학생 : 관내 고등학교 졸업자 중 2021년도 대학에 합격한 자로/ 어려운 가정형편에도 성실히 학업을 수행하는 자재학생 : 소득기준 및 성적요건을 만족하는 자',
      Col13: '선발 공고일 3년전부터 계속하여 보호자 또는 본인이 태안군에 주소를 두고 거주하면서 장학금 신청자격을 갖춘자',
      Col14: '2022-03-07~2022-03-18',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '1인당 1회 지급 원칙으로/ 기 선발자는 선발인원 미달 시 선발',
      Col18: '입학생의 경우 출신 고등학교장 추천',
      Col19: '장학금 지원신청서개인정보 수집 제공 동의서서약서주민등록 등본(과거주소변동사항 포함)최종학교 졸업증명서직전학기 성적증명서대학교 등록금 납부 영수증소득 증빙서류(최근 3개월) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '태안군사랑장학회',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 입학생 학교생활기록부 교과성적 중 예체능과목 제외 5과목 평균(3학년 1학기까지) 등급 2.0이내 [학교장 추천]수능 : 응시영역 중(한국사/ 제2외국어 제외/탐구영역 2과목 평균) 2등급 이내 과목이 2개 이상이면서 상위 3개영역 등급평균 3.5 이내내신 : 학교생활기록부 교과성적 중예체능과목 제외 5학기 평균 등급 상위자  * 재학생 : 직전학기 이수학점이 18학점 이상이면서 평균 평점 4.5만점 4.0 이상인 자',
      Col10: '해당없음',
      Col11: '4000000원',
      Col12: '입학생 : 관내 고등학교를 졸업하고 우수한 성적(정시 또는 수시)로 2022년도 대학에 합격한 자재학생 : 직전학기 이수학점이 18학점 이상이면서 평균 평점 4.5만점 4.0 이상인 자',
      Col13: '선발 공고일 3년전부터 계속하여 보호자 또는 본인이 태안군에 주소를 두고 거주하면서 장학금 신청자격을 갖춘자',
      Col14: '2022-03-07~2022-03-18',
      Col15: ' * 재학생 선발 우선 순위 : 학점 > 취득학점 > 고학년 순 * 입학생은 학교장 추천 또는 개인 신청으로 자세한 사항은 첨부파일 참고 ',
      Col16: '해당없음',
      Col17: '졸업예정자휴학생복학생1인당 1회 지급 원칙으로/ 기 선발자는 선발인원 미달 시 지급',
      Col18: '입학생의 경우 내신성적으로 지원 시 출신 고등학교장 추천 선발',
      Col19: '장학금 지원신청서개인정보 수집 제공 동의서서약서주민등록 등본(과거주소변동사항포함)최종학교 졸업증명서직전학기 성적증명서(재학생)2022년 수능성적증명서 또는 1~3학년 1학기 생활기록부(입학생)대학교 합격통지서(입학생)대학교 등록금 납부 영수증(입학생) * 학교장 또는 개인 신청 * 자세항 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '태안군사랑장학회',
      Col2: '명문대진학 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '기존 장학생으로 직전학기 평점이 B이상인 자',
      Col10: '해당없음',
      Col11: '4000000원',
      Col12: '기선발 장학생 * 이번장학금은 기존 장학생으로만 선정 / 신입생 선발하지 않음',
      Col13: '선발 공고일 3년전부터 계속하여 보호자 또는 본인이 태안군에 주소를 두고 거주한 자',
      Col14: '2022-03-07~2022-03-18',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '직전학기 성적증명서대학교등록금 납부영수증 '
    },
    {
      Col1: '태안군사랑장학회',
      Col2: '특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원 ~ 3000000원 ( *  전국 1위 3백만원 전국 2위 2백만원 전국 3위 1백만원 도1 1위 1백만원)',
      Col12: '2021년도 관내 고등학교에 재학 중 체육/ 예술/ 기술/ 수학/ 외국어 경시/ 컴퓨터/ 기능 올림픽 등 각종 특기분야 중앙부처 주관대회/ 전국(소년)체전 전국 3위 이내 또는 충남도 및 도교육청 주관대회 도내1위 개인전 입상자2022년도 대학교 입학생',
      Col13: '선발 공고일 3년전부터 계속하여 보호자 또는 본인이 태안군에 주소를 두고 거주하면서 장학금 신청자격을 갖춘자',
      Col14: '2022-05-02~2022-05-13',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 지원신청서개인정보 수집 제공동의서서약서주민등록 등본(과거주소변동사항포함)수상증빙서류(상장 등) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 신안군장학재단',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고등학교 3학년 2학기기 전 과목 성적 70점 이상 (체육/예술 교과군의 과목은 평가에서 제외)재학생 : 직전학기 성적 C학점 이상 (2.0/4.3만점/ 1.8/4.5만점)',
      Col10: '해당없음',
      Col11: '1인당 3000000원  (* 조건마다 지원금액이 상이함으로 첨부자료 확인) ',
      Col12: '본인 및 친권자가 공고일 현재 신안군에 1년 이상 주소를 두고 실제 거주하고 있는 자로서 성적우수자',
      Col13: '본인 및 친권자가 공고일 현재 신안군에 1년 이상 주소를 두고 실제 거주하고 있는 자 (단/ 대학생은 학생 주소에 제한 없음)',
      Col14: '2022-08-01~2022-08-31',
      Col15: '성적 평가 100%서류심사 후 재단 이사회 심의(성적평가 100%)',
      Col16: 'OO명',
      Col17: '타 기관에서 지원받은 장학금 총액이 등록금을 초과 또는 장학금과 등록금과의 차액이 20만원 미만국가 등으로부터 학비 등을 지원받는 육사·해사·공사·경찰대생매학기 등록금 총액이 50만원 이하인 대학생정규 학제 기간을 초과해 재학중인자본 장학재단 내 중복 신청자/ 대학원생 * 자세한 사항은 첨부자료 확인 필수',
      Col18: '해당없음',
      Col19: '장학금신청서신청인 서약서개인정보 수집/이용 및 제공/ 조회동의서주민등록 등본(본인/ 부/모 거주확인)재학증명서통장사본(본인 또는 부/모)직전학기 성적증명서 (대학신입생:고교생활기록부) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '백운장학회(광양)',
      Col2: '일반선발 장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(대학생) 직전학기 성적이 평점 B학점 이상인 자로서/ 직전학기 12학점 이상 이수자 (대학원생) 직전 두 학기 9학점 이상 이수한 자/ 신입생은 6학점 이상 이수자',
      Col10: '해당없음',
      Col11: '1인당 최대 2500000원',
      Col12: '고등학교 졸업자 또는 고졸 검정고시 합격자 중에서 국내 전문대/ 대학교/ 대학원에 재학 중인 자복학신청을 하고 2학기 등록금을 납부한 경우 신청 가능',
      Col13: '공고일 현재 부·모 또는 보호자가 광양시에 1년이상 주소를 둔 자본인에 한하여 관외 거주 인정',
      Col14: '2022-08-01~2022-08-31',
      Col15: '성적 우수 : 최종학기 성적 50% + 수능성적 50% (1학년)                    최종학기 성적 100% (2~4학년)학업 지원 : 학자금 지원구간 환산점수 * 자세한 사항은 첨부파일 참고',
      Col16: ' * 총 140명성적 우수 장학생 84명학업 지원 장학생 56명',
      Col17: '학점은행제 대학은 신청 불가 신청 학생이 개인소득자인 경우장학금 신청자와 그 부모가 지방세를 체납 중인 경우장학금의 이중/허위 수혜 등 기타 부정행위가 적발된 경우등록금과 수업료가 면제되거나 전액을 지원받는 육/해/공군사관학교/ 간호사관학교/ 경찰대학 등의 학생',
      Col18: '해당없음',
      Col19: '장학금 신청서주민등록등본가족관계증명서대학수학능력시험 성적증명서 또는 고등학교 3학년 1학기 성적 증명서대학교 전학년 성적증명서2022년 1학기 학자금지원구간통지서기초생활수급자/ 차상위가정/ 한부모가정/ 장애인 증명서(해당자)등록금 납입 증명서장학금 수혜 확인서 학자금 수혜 확인서개인정보 수집·이용 및 제공·조회 동의서신청인 서약서통장 사본  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '백운장학회(광양)',
      Col2: '우선선발 장학생(이공계/전문대)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 이상 이수/ 평균 평점 B학점 이상인 학생',
      Col10: '해당없음',
      Col11: '일반 대학생 500000 ~ 2500000원전문대생 500000 ~ 1500000원 * 타 기관 장학금 및 학자금 수혜금액이 있을 경우 등록금 범위 내에서 차액을 지급',
      Col12: '고등학교 졸업자 또는 고졸 검정고시 합격자 중에서 국내 전문대/ 대학교/ 대학원에 재학중인 자복학신청을 하고 2학기 등록금을 납부한 경우 신청 가능관내 대학교 장학생일 경우 광양보건대학교 재학생',
      Col13: '공고일 현재 부모 또는 보호자가 광양시에 1년 이상 주소를 둔 자본인에 한하여 관외 거주 인정',
      Col14: '2022-08-01~2022-08-31',
      Col15: '서류심사를 원칙으로 함백운장학생 선발 위원회 심사 및 (재)백운장학회 이사회 승인 후 최종결정성적 50% + 소득 50% * 자세한 사항은 첨부파일 참고',
      Col16: '이공계전공 : 4명전문대 : 3명',
      Col17: '학점은행제 대학은 신청 불가신청 학생이 개인소득자인 경우장학금 신청자와 그 부모가 지방세를 체납 중인 경우장학금의 이중/허위 수혜 등 기타 부정행위가 적발된 경우등록금과 수업료가 면제되거나 전액을 지원받는 육/해/공군사관학교/ 간호사관학교/ 경찰대학 등의 학생',
      Col18: '해당없음',
      Col19: '장학금 신청서주민등록등본가족관계증명서대학수학능력시험 성적증명서 또는 고등학교 3학년 1학기 성적 증명서대학교 전학년 성적증명서재학증명서2022년 학자금지원구간통지서기초생활수급자/ 차상위가정/ 한부모가정/ 장애인 증명서(해당자)등록금 납입 증명서장학금 수혜 확인서 학자금 수혜 확인서개인정보 수집·이용 및 제공·조회 동의서신청인 서약서통장 사본 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '백운장학회(광양)',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 평점 B학점 이상인 학생직전학기 12학점 이상 이수한 자대학원생인 경우 직전 두 학기 9학점 이상을 이수한 자/ 단 신입생은 6학점 이상 이수자',
      Col10: '해당없음',
      Col11: '1500000원 * 포상금으로 이중수혜 가능',
      Col12: '고등학교 졸업자 또는 고졸 검정고시 합격자 중에서 국내 전문대/ 대학교/ 대학원에 재학하는 자 복학신청을 하고 2학기 등록금을 납부한 경우 신청 가능공고일로부터 1년 이내(2021.8.1 ~ 2022.7.31)기간 중 학술/ 기능/예·체능 등과 관련하여 도 단위 또는 전국 단위 대회에서 3위 이내 입상자* 첨부파일 참고',
      Col13: '공고일 현재 부·모 또는 보호자가 광양시에 1년이상 주소를 둔 자본인에 한하여 관외 거주를 인정',
      Col14: '2022-08-01~2022-08-31',
      Col15: '수상 실적에 따른 고득점자 순으로 선발동점일 경우 상위 입상자/ 수상 횟수/ 연장자 순으로 선발체육 분야는 단체보다 개인 성적 우선 선발발',
      Col16: '10명',
      Col17: '학점은행제 대학은 신청 불가대학원은 박사과정 제외신청 학생이 개인소득자인 경우장학금 신청자와 그 부모가 지방세를 체납 중인 경우장학금의 이중/허위 수혜 등 기타 부정행위가 적발된 경우등록금과 수업료가 면제되거나 전액을 지원받는 육/해/공군사관학교/ 간호사관학교/ 경찰대학 등의 학생',
      Col18: '해당없음',
      Col19: '장학금 신청서주민등록등본가족관계증명서재학증명서개인정보 수집·이용 및 제공·조회 동의서통장 사본 입상실적 증명서 또는 상장 * 자세한 사항 첨부파일 확인'
    },
    {
      Col1: '백운장학회(광양)',
      Col2: '유학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2500000원 ',
      Col12: '국외 전문대/ 대학/ 대학원(석사과정)에 재학 중인 자',
      Col13: '공고일 현재 부·모 또는 보호자가 광양시에 1년이상 주소를 둔 자본인에 한하여 관외 거주 인정',
      Col14: '2022-08-01~2022-08-31',
      Col15: ' ※ 성적 50% + 소득 50%성적 평가: 최종학기 성적소득 평가: 기준중위소득 환산점수',
      Col16: '2명',
      Col17: '신청 학생이 개인소득자인 경우장학금 신청자와 그 부모가 지방세를 체납 중인 경우장학금의 이중/허위 수혜 등 기타 부정행위가 적발된 경우등록금과 수업료가 면제되거나 전액을 지원받는 육/해/공군사관학교/ 간호사관학교/ 경찰대학 등의 학생',
      Col18: '해당없음',
      Col19: '장학금 신청서주민등록등본가족관계증명서대학교 전학년 성적증명서재학증명서2021년도 1년간 부모 건강보험료 납부확인서 및 건강보험자격확인서2021년도 부모 지방세 세목별 과세증명서기초생활수급자/ 차상위가정/ 한부모가정/ 장애인증명서(해당자)등록금 납입 증명서개인정보 수집/이용 및 제공/조회 동의서신청인서약서통장 사본이력서  ※ 외국어 서류는 번역본 포함 제출로/ 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '백운장학회(광양)',
      Col2: '우선선발 장학생(다자녀/장애인)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학기 성적이 평점 B학점 이상인 자직전학기 12학점 이상 이수한 자대학원은 직전 두 학기 9학점 이상을 이수한 자',
      Col10: '해당없음',
      Col11: '다자녀가정 : 500000원 ~ 2500000원등록장애인 : 2500000원 이하 전액',
      Col12: '고등학교 졸업자 또는 고졸 검정고시 합격자 중에서 국내 전문대/ 대학교/ 대학원에 재학하는 자복학신청을 하고 2학기 등록금을 납부한 경우 신청 가능능다자녀 : 3자녀 이상 대학(원) 재학생 * 1가구당 1명만 수혜가능/ 전남인재육성재단 다자녀 장학금 수혜자 지원제외등록 장애인 : 장애인으로 등록된 자',
      Col13: '공고일 현재 부모 또는 보호자가 광양시에 1년이상 주소를 둔 자본인에 한하여 관외 거주 인정',
      Col14: '2022-08-01~2022-08-31',
      Col15: '다자녀 선정기준 : 자녀수 50% + 소득 50%등록 장애인 선정기준 : 소득 50% + 장애정도 50% * 자세한 사항은 첨부파일 참고',
      Col16: '다자녀 : 25명등록장애인 : 2명',
      Col17: '학점은행제 대학은 신청 불가 신청 학생이 개인소득자인 경우장학금 신청자와 그 부모가 지방세를 체납 중인 경우장학금의 이중/허위 수혜 등 기타 부정행위가 적발된 경우등록금과 수업료가 면제되거나 전액을 지원받는 육/해/공군사관학교/ 간호사관학교/ 경찰대학 등의 학생',
      Col18: '해당없음',
      Col19: '장학금 신청서주민등록등본가족관계증명서재학증명서전년도 부·모 건강보험료 납부확인서소득증빙서류(기초생활수급자/차상위 해당자)장애인 증빙서류(해당자)개인정보 수집·이용 및 제공·조회 동의서장학금 지급 통장 사본 ※ 자세한 사항 첨부파일 참조'
    },
    {
      Col1: '백운장학회(광양)',
      Col2: '지정기탁장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기에 12학점 이상을 이수하고/ 평균학점이 B학점 이상인 자',
      Col10: '해당없음',
      Col11: ' * 선발 인원과 1명당 지원액은 자율적으로 조정 가능광양경찰서 10000000원 / 7명광양소방서 8000000원 / 5명 ※ 생활비 지원으로 이중수혜 가능',
      Col12: '광양경찰서/ 광양소방서 재직자의 자녀로서 광양경찰서장 또는 광양소방서장의 추천을 받은 자',
      Col13: '공고일 현재 광양시에 1년 이상 주소를 두고 있는 광양경찰서/ 광양소방서 재직자의 자녀',
      Col14: '2022-04-18~2022-04-29',
      Col15: '해당없음',
      Col16: '6명 (고등학생 포함 12명)',
      Col17: '신청 학생이 개인소득자인 경우장학금 신청자와 그 부모가 지방세를 체납 중인 경우장학금의 이중/허위 수혜 등 기타 부정행위가 적발된 경우등록금과 수업료가 면제되거나 전액을 지원받는 육/해/공군사관학교/ 간호사관학교/ 경찰대학 등의 학생',
      Col18: '광양경찰서장과 광양소방서장이 추천한 자',
      Col19: '장학금 신청서주민등록등본가족관계증명서재학증명서개인정보 수집·이용 및 제공·조회 동의서장학금 지급 통장 사본추천서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '이천시민장학회(이천시청)',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '이천시 관내고등학교 졸업생으로 대학교에 입학한 학생중에서 수학능력고사 및 내신 성적 우수 득점학생을 선발 * 재수생은 선발제외',
      Col10: '해당없음',
      Col11: '4000000원',
      Col12: '해당없음',
      Col13: '학생 및 보호자(학부모)가 3년 이상(2021년 12월 31일 기준) 이천시에 계속 거주 하는 자로 선발 한다.거주기간은 주민등록등본으로 확인.(필요시 가족관계증명서 확인)',
      Col14: '2022-04-18~2022-04-29',
      Col15: '이사회 심의 * 장학생 선발 방법/ 인원 및 장학금 지급 금액은 (재)이천시민장학회 사정에 따라 변경될 수 있다.',
      Col16: '10명',
      Col17: '직전 학기 성적이 평균 B학점(80점) 이하인 경우에는 장학금 지급을 중단하고/ 다음 학기에 성적이 평균 B학점(80점) 이상으로 회복될 경우에는 장학금을 지급한다.',
      Col18: '학생의 출신 고등학교 학교장 추천',
      Col19: '장학금신청서재학증명서생활기록부주민등록등본통장사본개인정보 수집이용제공 동의서서약서대학수학능력평가성적표'
    },
    {
      Col1: '이천시민장학회(이천시청)',
      Col2: '복지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '이천시 관내에 거주하는 생계곤란 학생',
      Col11: '2000000원',
      Col12: '해당없음',
      Col13: '학생 및 보호자(학부모)가 3년 이상(2021년 12월 31일 기준) 이천시에 계속 거주 하는 자로 선발 한다.거주기간은 주민등록등본으로 확인.(필요시 가족관계증명서 첨부) ',
      Col14: '2022-03-16~2022-04-14',
      Col15: '해당없음',
      Col16: '28명',
      Col17: '해당없음',
      Col18: '학생이 거주하는 읍·면·동 지부장의 추천',
      Col19: '장학생원서(사진첨부)재학증명서개인정보수집.이용/제공/조회동의서학생본인명의 보통예금 통장 사본생활기록부(성적증명서)주민등록등본(주소이력포함)재산세 납부 증명서세대구성원중 성인)이장·읍·면·동장 확인서 학교장 임원추천서 * 인편 또는 우편 접수  * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '용인시장학재단',
      Col2: '진학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '수능성적 입학생: 해당연도 대입수학능력시험성적 한국사+국어+수학+영어+탐구(2)영역 등급 합 12 이내 인자내신성적 입학생: 해당연도 내신성적 상위 10% 이내 인 자 * 탐구영역(1)은 제2외국어로 대체 가능 * 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '2500000원(타장학금 수혜자의 경우 차액 지급)',
      Col12: '대학 및 대학교 수능성적 입학생대학 및 대학교 내신성적 입학생',
      Col13: '공고일 현재/ 계속하여 2년 이상 용인시에 주민등록을 두고 거주한 시민 및 직계비속',
      Col14: '2022-03-16~2022-04-14',
      Col15: '해당없음',
      Col16: '수능 : 32명  내신 : 8명',
      Col17: '장학금 이중지원 제한에 따라/ 타 장학금과 합산한 장학금액이 등록금 범위를 초과하는 경우/ 장학금 지급 중지 또는 장학금액 변경장학금 수령 후 타 장학금 중복수혜 사유 발생 시 장학금 반납  * 등록금 범위 초과 시 한국장학재단이나 학교 또는 당 장학재단과 사전협의',
      Col18: ' 대학(총)장 또는 소속학교장',
      Col19: '장학금 지원신청서장학금 지원대상자 추천서개인정보수집/ 이용/ 제공 및 조회동의서신청인 서약서 1부주소이력을 포함한 주민등록 등본 또는 초본 2022년대학수학능력 성적표 (한국교육과정평가원 발급) 또는 2021년 고등학교 내신성적표장학금 비수혜(수혜) 확인서재학증명서(대학교)'
    },
    {
      Col1: '용인시장학재단',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당연도 매학기 12학점 이상 취득과 성적이 B+(평점 표시) 이상 인 자복학생의 경우 휴학 직전학기와 그전학기 각 12학점 이상 취득과 성적이 B+(평점 표시) 이상인 자',
      Col10: '해당없음',
      Col11: '2500000원(타장학금 수혜자의 경우 차액 지급)',
      Col12: '해당없음',
      Col13: '공고일 현재/ 계속하여 2년 이상 용인시에 주민등록을 두고 거주한 시민 및 직계비속',
      Col14: '2022-03-16~2022-04-14',
      Col15: '해당없음',
      Col16: '대학생: 76명전문대생: 8명',
      Col17: '해당없음',
      Col18: '대학(총)장 또는 소속학교장',
      Col19: '장학금 지원신청서 장학금 지원대상자 추천서개인정보수집/ 이용/ 제공 및 조회동의서신청인 서약서주소이력을 포함한 주민등록 등본 또는 초본 성적증명서 (4.5 만점 환산 평점 성적)  장학금 비수혜(수혜) 확인서 1통 재학증명서 1통  * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '용인시장학재단',
      Col2: '효행장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '500000원',
      Col12: '국내 대학 재학생 품행이 바르고 공경을 몸소 실천함으로서 그의 행실이 타의 귀감이 되는 학생',
      Col13: '공고일 현재/ 계속하여 2년 이상 용인시에 주민등록을 두고 거주한 시민 및 직계존비속',
      Col14: '2022-03-16~2022-04-14',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '당해연도 타 장학금을 받지 아니한 자',
      Col18: '해당학교장의 추천을 받아 읍/면/동장이 추천',
      Col19: '장학금 지원신청서장학금 지원대상자 추천서 주소이력을 포함한 주민등록 등본 읍/면/동장의 공적조서  장학금 비수혜 확인서 (대학생은 수혜확인서 가능)재학증명서 개인정보수집/이용/제공 및 조회동의서 신청인 서약서 '
    },
    {
      Col1: '용인시장학재단',
      Col2: '향토장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당연도 매학기 12학점 이상 취득과 성적이 B+(평점 표시) 이상 인 자',
      Col10: '해당없음',
      Col11: '2500000원 (타장학금 수혜자의 경우 차액 지급)',
      Col12: '해당없음',
      Col13: '용인시에 30년 이상 계속해서 거주하고 있는 가구 중 학생 1인 ',
      Col14: '2022-03-16~2022-04-14',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '장학금 이중지원 제한에 따라/ 타 장학금과 합산한 장학금액이 등록금 범위를 초과하는 경우/ 장학금 지급 중지 또는 장학금액 변경장학금 수령 후 타 장학금 중복수혜 사유 발생 시 장학금 반납 * 등록금 범위 초과 시 한국장학재단이나 학교 또는 당 장학재단과 사전협의 ',
      Col18: '대학(총)장',
      Col19: '장학금 지원신청서장학금 지원대상자 추천서주소이력을 포함한 주민등록 등본 성적증명서 장학금 비수혜(수혜) 확인서 재학증명서 개인정보수집/이용/제공 및 조회동의서신청인 서약서 * 30년 이상 용인에 계속 거주하고 있는 가구 중 학생 1인만 신청 가능 '
    },
    {
      Col1: '용인시장학재단',
      Col2: '기능장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '도 단위 이상 각종 공인대회에서 3위 이내 입상한 자',
      Col10: '해당없음',
      Col11: '500000원',
      Col12: '해당없음',
      Col13: '공고일 현재/ 계속하여 2년 이상 용인시에 주민등록을 두고 거주한 시민 및 직계존비속',
      Col14: '2021-03-15~2021-04-14',
      Col15: '해당없음',
      Col16: '8명',
      Col17: '장학금 이중지원 제한에 따라/ 타 장학금과 합산한 장학금액이 등록금 범위를 초과하는 경우/ 장학금 지급 중지 또는 장학금액 변경장학금 수령 후 타 장학금 중복수혜 사유 발생 시 장학금 반납 * 등록금 범위 초과 시 한국장학재단이나 학교 또는 당 장학재단과 사전협의 ',
      Col18: '소속학교장',
      Col19: '장학금 지원신청서장학금 지원대상자 추천서주소이력을 포함한 주민등록 등본 또는 초본교육/문화/체육/예술/ IT분야 등 2021년도 각종대회 수상실적 증명 또는 상장 사본 (원본대조 필)장학금 비수혜 확인서 (대학생은 수혜확인서 가능)재학증명서개인정보수집/이용/제공 및 조회동의서신청인 서약서* 학교별 제한 인원 없음/ 수상실적 모두 제출* 예능 엔터테인먼트 분야 꿈나무 장학생은 학교장 추천서 제출'
    },
    {
      Col1: '용인시장학재단',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '5자녀 이상 다자녀 가구 중 미혼 학생 1인',
      Col13: '공고일 현재/ 계속하여 2년 이상 용인시에 주민등록을 두고 거주한 시민 및 직계존비속',
      Col14: '2021-12-23~2022-01-19',
      Col15: '심의위원회에서 심의 의결로 정함',
      Col16: '4명(고등학생 포함)',
      Col17: '장학금 이중지원 제한에 따라/ 타 장학금과 합산한 장학금액이 등록금 범위를 초과하는 경우/ 장학금 지급 중지 또는 장학금액 변경장학금 수령 후 타 장학금 중복수혜 사유 발생 시 장학금 반납 * 등록금 범위 초과 시 한국장학재단이나 학교 또는 당 장학재단과 사전협의 ',
      Col18: '소속학교 장',
      Col19: '장학금 지원신청서 1부. [별지1]장학금 지원대상자 추천서 1부. [별지2] 주소이력을 포함한 주민등록 등본 1통2020학년도 성적증명서 1부장학금 비수혜 확인서 1통(대학생은 수혜확인서 가능)재학증명서 1통개인정보수집/이용/제공 및 조회동의서 1부. [별지6] → (대학생만 해당됨)신청인 서약서 1부. [별지7] → (대학생만 해당됨)* 5자녀 이상 다자녀 가구 당 미혼 학생 1인만 신청 가능'
    },
    {
      Col1: '하동군장학재단(하동군청)',
      Col2: '학업성적우수자',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 학업성적 평균 3.5이상인자(성적 60% + 학교 가산점 40%)',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '하동군내에 직계존속과 학생이 신청일 현재 1년 이상 주민등록을 두고 있는자군내 고등학교를 졸업한 대학생',
      Col14: '2021-12-23~2022-01-19',
      Col15: '해당없음',
      Col16: '50명 ',
      Col17: '졸업 예정자 및 정규 학제 기간 초과자휴학 또는 예정/ 정학/ 퇴학 등 징계처분 받은 자대학원/ 사이버대/ 평생교육원 제외',
      Col18: '해당없음',
      Col19: '장학생 추천서재학 증명서고등학교 졸업 증명서성적증명서학생 및 직계존속 주민등록초본 (최근 1년)'
    },
    {
      Col1: '하동군장학재단(하동군청)',
      Col2: '등록금장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 학업성적 평균 3.0 (4.5만점) 이상인 자 ',
      Col10: '해당없음',
      Col11: '등록금실납부액',
      Col12: '4년 지원 : 5개 대학(서울대/ 연세대/ 고려대/ 포항공대/ 카이스트대) 진학이 확정된 자와 재학생(직전학기 학업성적 평균 3.0(4.5만점)이상',
      Col13: '하동군내에 직계존속과 학생이 신청일 현재 1년 이상 주민등록을 두고 있는자군내 고등학교를 졸업한 대학생',
      Col14: '2021-12-23~2022-01-19',
      Col15: '해당 학생 공문발송> 본인신청> 이사회 심의 ',
      Col16: '10명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서재학증명서 및 성적증명서등록금 납입통지서 및 납입영수증증'
    },
    {
      Col1: '하동군장학재단(하동군청)',
      Col2: '자립장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 학업성적 평균 3.0(4.5만점) 이상인 자',
      Col10: '생활환경이 어려운 학생(기초생활보장수급자 장애인가정 다자녀 다문화 등)',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '하동군내에 직계존속과 학생이 신청일 현재 1년 이상 주민등록을 두고 있는자군내 고등학교를 졸업한 대학생',
      Col14: '2021-12-23~2022-01-19',
      Col15: '학교장 추천 및 본인 신청> 이사회 심의 ',
      Col16: '30명',
      Col17: '해당없음',
      Col18: '학교장 추천',
      Col19: '장학생 추천서재학증명서고등학교 졸업증명서성적증명서주민등록초본(본인 및 부모)수급자 또는 차상의 증명서'
    },
    {
      Col1: '하동군장학재단(하동군청)',
      Col2: '특기입학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '예체능계열',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '이사회 심의',
      Col12: '관내 고등학교를 졸업하여 특기생으로 우수대학에 입학한 학생',
      Col13: '해당없음',
      Col14: '2022-09-06~2022-09-08',
      Col15: '해당없음',
      Col16: '이사회 심의',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 추천서대학합격 통지서학생 및 직계존속 주민등록초본'
    },
    {
      Col1: '(재)삼송장학회',
      Col2: '장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/자연계열',
      Col9: '직전학기 성적이 3.0이상인 자직전학기 F학점 없을 것',
      Col10: '가정형편이 어려운 학생 우선 선발',
      Col11: '2000000원 (등록금성 장학)',
      Col12: '전기/전자/기계/신소재 계열 재학생(초과학기 제외)',
      Col13: '해당없음',
      Col14: '2022-02-07~2022-02-11',
      Col15: '해당없음',
      Col16: ' * 학교 추천 방식으로/ 각 학교 장학부서에 문의 필수. 각 1명',
      Col17: '장학생 추천 기준에 해당되지 않는 자금고 이상의 형을 받은 자타 장학금을 받고 있거나 이와 유사한 학비감면을 혜택을 받고 있는 자부모님 직장에서 장학금 지원을 받는 자녀소속 학교에서 징계처분을 받은 사실이 있는 자 초과학기자신입생 및 타장학금 수헤자',
      Col18: ' * 학교 추천 방식으로/ 각 학교 장학부서에 문의 필수.',
      Col19: ' * 학교 추천 방식으로/ 각 학교 장학부서에 문의 필수장학생 추천서학습계획서재학증명서성적증명서거래금융기관계좌확인서'
    },
    {
      Col1: '사천시인재육성장학재단',
      Col2: '한국폴리텍항공대입학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '1. 수시 입학생고교 내신 성적 1위 2. 정시 입학생입학 성적 1위',
      Col10: '해당없음',
      Col11: '수시입학생 고교내신성적 1위 : 1000000원 지급정시입학생 입학성적 1위 : 1000000원 지급',
      Col12: '한국폴리텍대학 항공캠퍼스 입학생',
      Col13: '당해연도 관내 고등학교 출신',
      Col14: '2022-02-07~2022-02-11',
      Col15: '서류심사 후 이사회의 최종 심의의결',
      Col16: '해당없음',
      Col17: '국가/ 또는 지방자치단체 및 공익법인으로부터 명시적인 장학금을 지급받는 사람',
      Col18: '한국폴리텍대학항공캠퍼스 학장추천',
      Col19: '* 다음 각 호의 서류를 첨부하여 학교장이 사천시 인재육성장학재단 이사장에게로 학교별 일괄 제출 장학금 추천서 및 장학금 서약서학교장이 발행학 입학성적(등수) 확인서'
    },
    {
      Col1: '사천시인재육성장학재단',
      Col2: '관외대학(교)입학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '3개 평가영역 이상이 1등급인 경우2개 평가영역이 1등급인 경우1개 평가영역이 1등급이거나 3개 평가영역 이상이 2등급인 경우 * 제2외국어 영역은 제외됨 * 탐구영역은 2개 과목 1등급을 받아야 1등급 인정하고/ 2개 과목 2등급 이상을 받아야 2등급 인정함.',
      Col10: '해당없음',
      Col11: '3개 평가영역 이상이 1등급인 경우 : 2000000원2개 평가영역이 1등급인 경우 : 1000000원1개 평가영역이 1등급이거나 3개 평가영역 이상이 2등급인 경우 : 500000원',
      Col12: '해당없음',
      Col13: '당해연도 관내 고등학교 출신',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: ' 서류심사 후 이사회의 최종 심의의결',
      Col16: '해당없음',
      Col17: '국가/ 또는 지방자치단체 및 공익법인으로부터 명시적인 장학금을 지급받는 사람',
      Col18: '재학 중인 고등학교장의 추천 필요',
      Col19: '* 학교장이 사천시 인재육성장학재단 이사장에게로 학교별 일괄 제출장학금 추천서 및 장학생 서약서수능성적표/ 대학합격증명서'
    },
    {
      Col1: '사천시인재육성장학재단',
      Col2: '해외문화탐방장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: ' * 탐방비용 80% 10000000원 한도 내 지원',
      Col12: '대학교 재학생(휴학생 포함)',
      Col13: '사천시 관내 고등학교를 졸업한 대학교 재학생(휴학생 포함)모집 공고일 기준 학생의 부/모의 주민등록이 사천시 1년이상 계속하여 등록된 자 * 위 두 요건을 모두 만족한자',
      Col14: '2022-02-07~2022-02-28',
      Col15: '탐방계획안 심사 40점 + 심층면접 심사 60점',
      Col16: '4팀(팀별구성/ 팀당3~5명 구성/ 남녀 동일비율 구성 불가)',
      Col17: '해외여행에 결격사유가 있는 자 장기치료 중이거나 건강상 이유 등으로 정상적인 탐방활동이 어렵다고 판단되는 자',
      Col18: '해당없음',
      Col19: '지도교수 추천서대학생 그룹 해외탐방 신청서 : 팀원 전원 제출대학생 그룹 해외탐방 계획서 : 팀별 제출개인정보제공동의 및 활용승낙서 : 팀원 전원 제출주민등록등본(본인/ 부 또는 모) 각 1부 : 팀원 전원 제출고등학교 졸업증명서 : 팀원 전원 제출재학증명서 또는 휴학증명서(최근3개월 이내 발급)각 1부 : 팀원 전원 제출대학생 그룹 해외탐방 지원서 체크리스트 : 팀별제출 * 자세한 사항은 첨부파일 또는 장학운영기관의 홈페이지 공지사항 참고'
    },
    {
      Col1: '태백시민향토장학회',
      Col2: '향토장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 관내고교 출신으로 수능미응시자의 경우 졸업학교 최종학년 평균등급이 3등급 이내이거나/ 대학수학능력시험 과목 중 국어/ 수학/ 영어/ 한국사/ 탐구영역을 합산한 평균등급이 3등급 이내인 자.재학생 : 수능성적과 대학 직전학년(1/2학기) 성적을 합산하여 선발 / 직전학년 평균 B학점(4.5 만점에 3.0)이상',
      Col10: '가정형편이 극히 어려워 학비조달의 능력이 없어 학교장이 특별히 추천한 자로서 동장이 불우가정으로 인정한 자',
      Col11: '한 학기당 2000000원이내 * 등록금 지원',
      Col12: '4년제 대학 학생',
      Col13: '공고일 현재 태백시에 2년 이상 현재까지 주소를 두고 있는 시민(부모 및 친권자)의 자녀',
      Col14: '2022-02-07~2022-02-28',
      Col15: '해당없음',
      Col16: '60명 (전체장학생)',
      Col17: '국가 또는 타기관/ 단체로부터 등록금 전액 및 초과하여 지급 받는 자공무원/ 회사원등 직업소유자(신청자 본인일 경우)사이버 대학교 및 전문대학교 재학생',
      Col18: '학교장 추천',
      Col19: '장학생지원서(소정양식)친권자(보호자)주민등록등본 (주소변동사항 포함)개인정보제공동의서부모또는 본인명의 통장사본기타 장학회에서 요구하는   서류(필요시)*신입생 : 수능성적표/ 합격통지서/ 고등학교성적증명서(3학년)*재학생 : 직전학년(1/2학기) 성적증명서*수능미응시자 (고등학교 성적증명서 (3학년))'
    },
    {
      Col1: '태백시민향토장학회',
      Col2: '생활장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고등학교 3학년 평균등급이 4등급 이내재학생 : 직전(直傳)학년 평균 C학점(4.5만점에 2.5) 이상 * 대학교에서 성적우수 전액장학금 수혜자  ',
      Col10: '소득구간 3구간(분위)이내',
      Col11: '한학기당 1000000원  * 생활비 지원',
      Col12: '4년제 대학 학생',
      Col13: '공고일 현재 태백시에 2년 이상 현재까지 주소를 두고 있는 시민(부모 및 친권자)의 자녀',
      Col14: '2022-08-18~2022-08-25',
      Col15: '※ 개별접수는 받지 않고 각 학교를 통하여 명단 제출받음.',
      Col16: '60명 (전체 장학생)',
      Col17: '국가 또는 타기관/ 단체로부터 등록금 전액 및 초과하여 지급 받는 자공무원/ 회사원등 직업소유자(신청자 본인일 경우)사이버 대학교 및 전문대학교 재학생',
      Col18: '학교장 추천',
      Col19: '장학생지원서(소정양식)친권자(보호자)주민등록등본   (주소변동사항 포함)개인정보제공동의서부모또는 본인명의 통장사본기타 장학회에서 요구하는   서류(필요시) * 신입생 : 수능성적표/ 합격통지서/ 고등학교성적증명서(3학년) * 수능미응시자 (고등학교 성적증명서 (3학년)) ※ 개별접수는 받지 않고 각 학교를 통하여 명단 제출받음.'
    },
    {
      Col1: '대림수암장학문화재단',
      Col2: '장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 12학점 이상 이수자 ',
      Col10: '부/모 연소득 합산 6000만원 이하이면서 부/모 연간 순수 재산세 주택(또는 토지건물) 합산 60만원 이하인 자',
      Col11: '234학년 6개학기 동안 등록금 및 교재비 지급',
      Col12: ' 대학교 2학년 학생(1학년 1/ 2학기 이수 완료) * 조건 모두 충족',
      Col13: '해당없음',
      Col14: '2022-07-05~2022-07-20',
      Col15: '서류심사면접심사',
      Col16: '해당없음',
      Col17: '국내 타기관 장학금과 중복 수혜 원칙적 불가',
      Col18: '해당없음',
      Col19: '장학생 지원서자기소개서학업계획서담당교수 추천서성적증명서가족관계증명서 원본 1부부/모의 직전연도 소득 증빙자료 각 1부 :근로소득원천징수영수증 또는 소득금액증명원부/모의 직전연도 지방세 세목별과세증명서 각 1부 * 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '부운장학회',
      Col2: '부운장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '효행자 선행자 소년소녀가장으로 생계가 극히 곤란한 학생의 경우는 별도 선정가능',
      Col11: '등록금 범위 내 예산 범위 내에서 지급',
      Col12: '부운장학금의 신청대상자는 공적으로 발행되는 가족증명서에 반드시 본관이 기계유씨(杞溪兪氏)라고 표기되어 있는 사람이어야 함학업성적이 우수하고 품행이 방정하며 학비 보조를 필요로 하는 학생',
      Col13: '해당없음',
      Col14: '2022-07-05~2022-07-20',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '반명함판 사진재학증명서성적증명서가족관계증명서주민등록등본자기소개서생활계획서기계유씨 족보등재 여부 확인서류기타 필요로 하는 서류(해당자)부운고 구독 여부 확인주소본인이름으로 된 통장 사본 * 지세한 사항은 기관 홈페이지 참조'
    },
    {
      Col1: '부운장학회',
      Col2: '특별장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정',
      Col8: '공학계열/인문계열/특정학과',
      Col9: ' * 교양과목 이수를 마친 3~4학년 학부생일 시 아래 해당자학업성적 : B+ 이상토익점수 : 800점 이상한자검정시험 : 2급 이상봉사활동/리더활동 : 국가·사회단체·학교 인증 가능자',
      Col10: '해당없음',
      Col11: '특별장학생의 수와 장학금액은 이사회에서 결정',
      Col12: '부운장학금의 신청대상자는 공적으로 발행되는 가족증명서에 반드시 본관이 기계유씨(杞溪兪氏)라고 표기되어 있는 사람이어야 함바른 국가관과 숭조사상이 탁월한 사람교양 과목이수를 마친 3∼4학년 학부생대학원 박사과정 이상의 한문학/ 역사학/ 컴퓨터공학 분야자',
      Col13: '해당없음',
      Col14: '2021-11-15~2021-11-17',
      Col15: '(1차) 서류평가(2차) 면접평가',
      Col16: '특별장학생의 수와 장학금액은 이사회에서 결정',
      Col17: '사전 상담 없는 신청은 접수 받지 않으므로 사전 상담 필수',
      Col18: '해당없음',
      Col19: '성적증명서어학성적 증명서봉사활동 및 리더활동 증명서'
    },
    {
      Col1: '송원김영환장학재단',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체 학기 성적 평점이 3.0/4.5 이상인 자 ',
      Col10: '소득분위 3분위 이하 ( 소득분위에는 반영되지 않았지만 동급으로 가정형편이 곤란한 자 )',
      Col11: '5000000원 (등록금 및 학업장려금 재단 요건 충족 시 정규학기 계속 지원 가능)지방출신 장학생을 위한 기숙사 무상제공장학생 회원 커뮤니티 활동',
      Col12: '2022년 1학기 기준 경영대학 경영학부 2학년 또는 3학년 진학 예정인 학부 정규 등록생재단 공식 행사 및 회원 친목 도모활동에 적극 참여할 수 있는 자  ',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '대학추천 및 면접',
      Col16: 'O명',
      Col17: '해당없음',
      Col18: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수.',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수'
    },
    {
      Col1: '천일장학회',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '3000000원',
      Col12: '새터민(탈북자)으로서 재학생서울시 소재 4년제 정규대학자만(사이버대/ 해외대학/ 평생교육원 제외)',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '사이버대학및 해외대학 제외/평생교육원 제외 /교육청 인가를 받지않은 학교 제외 과목중에 한가지라도 F학점이 있는 학생학년이 중복된 학생 (예: 2015년도 1학년생이 2016년도 중복 1학년인 학생)휴학중인 학생 2016년도 기준 총 중복수혜 금액이 7백만원을 초과하는자2016년도 2학기 기준 해외 연수학생',
      Col18: '해당없음',
      Col19: '재학증명서 원본 1부 (2016년9월10일 이후 날짜로 날인된 제학증명서만 유효)성적증명서 원본 1부    1) 1학년 ; 2016년 1학기 성적기준   2) 2학년이상 : 2015년 2학기와 2016년 1학기 성적기준(두 학기의 평균성적으로 기준함)   3) 편입생 : 4년제 정규대학 편입후 전체 학기 성정증명서 요망)하나원 수료증(사본)또는 북한이탈 주민 등록 확인서 (개명시 개명증빙서류 동봉요망성적증명서 및 재학증명서와 주민등록증에 이름이 틀린경우)신상기재서 : 주민등록번호/연락처/이메일주소 꼭 기입 (서식없으며 빈 용지에 기입하고 정확히 알아볼수 있게 지재요망)봉사활동 2~3시간(봉사활동 확인서 발급)*제출서류 주소지 : 서울시 강남구 도산대로 67길 19 501호 천일장학회'
    },
    {
      Col1: '서산장학재단',
      Col2: '성적우수장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생학과 또는 계열의 학업성적이 총 평점평균 3.0 이상인 학생(신입생은 고등학교 3학년 우수장학생 기준에준함)',
      Col10: '해당없음',
      Col11: '대학생 : 1000000원   * 단 특별장학생은 이사(간담)회의 의결 후 차등 지급할 수 있음',
      Col12: '해당없음',
      Col13: '부모님이 서산.태안에 거주하는 자의 학생  (참고로/ 지역 출신으로 타지역 대학교에 입학또는 재학중인 학생에 한함)',
      Col14: '별도 모집',
      Col15: '부운영위원회에 서류 제출지부운영위원회 1차 심사이사(간담회) 심의 후 확정',
      Col16: '우수장학생 30%특별·특기·선행·효행·영재 장학생 70%',
      Col17: '타기관 및 단체로부터 수업료의 50%이상 장학금을 받고 있지 않는 자',
      Col18: '해당없음',
      Col19: '장학금 신청(추천)서 1부주민등록등본 1부가족관계증명원1부성적증명서 및 생활기록부 사본 각 1부재학증명서(대학생일 경우만) 1부'
    },
    {
      Col1: '서산장학재단',
      Col2: '특별장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '국가유공자 자녀의 경우 총 평점 2.5 이상이 되는 학생결(조)손가정/ 장애인 등 생활이 어려운가정 등은 성적요건 없음',
      Col10: '국민기초생활보장제도대상자',
      Col11: '대학생 : 1000000원   * 단 특별장학생은 이사(간담)회의 의결 후 차등 지급할 수 있음',
      Col12: '결(조)손가정 및 / 장애인 등 생활이 어려운 가정‘국가유공자예우에 관한 법률’ 제22조의 보훈 가족의 자녀',
      Col13: '부모님이 서산.태안에 거주하는 자의 학생   (참고로/ 지역 출신으로 타지역 대학교에 입학또는 재학중인 학생에 한함)',
      Col14: '별도 모집',
      Col15: '지부운영위원회에 서류 제출지부운영위원회 1차 심사이사(간담회) 심의 후 확정',
      Col16: '우수장학생 30%특별·특기·선행·효행·영재 장학생 70%',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청(추천)서 1부주민등록등본 1부가족관계증명원1부성적증명서 및 생활기록부 사본 각 1부재학증명서(대학생일 경우만) 1부국민기초생활 보장제도 대상자 증명서 및 확인서장애인 가정일 경우 장애인 증명서 또는 수첩사본국민기초생활 보장제도 대상자가 아닌 경우에는 지역의 통장이나       단체장의 ‘확인서’ 첨부'
    },
    {
      Col1: '서산장학재단',
      Col2: '특기장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '예/체능에 뛰어난 소질을 갖고 있어 도단위 이상의 대회에서 입상한 경력이 있는 학생',
      Col10: '해당없음',
      Col11: '대학생 : 1000000원 * 단 해외장학생과 특별장학생은 이사(간담)회의 의결 후 차등 지급할 수 있음',
      Col12: '해당없음',
      Col13: '부모님이 서산.태안에 거주하는 자의 학생 (참고로/ 지역 출신으로 타지역 대학교에 입학또는 재학중인  학생에 한함)',
      Col14: '해당없음',
      Col15: '지부운영위원회에 서류 제출지부운영위원회 1차 심사이사(간담회) 심의 후 확정',
      Col16: '우수장학생 30%특별·특기·선행·효행·영재 장학생 70%',
      Col17: '타기관 및 단체로부터 수업료의 50%이상 장학금을 받고 있지 않는 자',
      Col18: '학교장 추천 필요',
      Col19: '장학금 신청(추천)서 1부주민등록등본 1부가족관계증명원1부성적증명서 및 생활기록부 사본 각 1부재학증명서(대학생일 경우만) 1부도단위 이상의 대회에서 입상한 상장 사본   (단/ 추천인의 ‘원본 대조필’ 확인날인이 있어야 함)'
    },
    {
      Col1: '서산장학재단',
      Col2: '선행/효행장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학교장 및 단체장으로부터 선행·효행 사실을 인정받아 추천 받은 학생',
      Col10: '해당없음',
      Col11: '대학생 : 1000000원   * 단 해외장학생과 특별장학생은 이사(간담)회의 의결 후      차등 지급할 수 있음',
      Col12: '해당없음',
      Col13: '부모님이 서산.태안에 거주하는 자의 학생 (참고로/ 지역 출신으로 타지역 대학교에 입학또는 재학중인 학생에 한함)',
      Col14: '2022-01-03~2022-01-14',
      Col15: '지부운영위원회에 서류 제출지부운영위원회 1차 심사이사(간담회) 심의 후 확정',
      Col16: ' 우수장학생 30%특별·특기·선행·효행·영재 장학생 70%',
      Col17: ' 타기관 및 단체로부터 수업료의 50%이상 장학금을 받고 있지 않는 자',
      Col18: '지역의 통장이나 이장/ 반장 등의 확인서',
      Col19: '장학금 신청(추천)서 1부주민등록등본 1부가족관계증명원1부성적증명서 및 생활기록부 사본 각 1부재학증명서(대학생일 경우만) 1부학교장 또는 단체장 이상의 선행·효행 상장 사본   (생활기록부‘수상경력’ 확인)선행·효행 학생임을 확인하는 ‘확인서’ 첨부'
    },
    {
      Col1: '성옥문화재단',
      Col2: '성옥장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학5학기/대학6학기',
      Col8: '사회계열/인문계열',
      Col9: '직전학년 성적 평균B학점 이상 (백분율 환산 80점이상)',
      Col10: '건강보험료 월평균 35만원 이하 납부 (2021년도 부모 통합기준)',
      Col11: ' * 등록금 전액 1년 지원 (1학기 성적에 따라 2학기 자격상실)3학년 장학생은 4학년 진학시 계속장학생으로 우선추천 혜택',
      Col12: '건국대학교/ 경희대학교/고려대학교/ 광주대학교/ 동국대학교/목포가톨릭대학교/ 목포대학교/ 서강대학교/ 서울대학교/ 세한대학교/ 성균관대학교/ 숙명여자대학교/ 순천대학교/ 연세대학교/ 원광대학교/ 이화여자대학교/ 전북대학교/전남대학교/ 조선대학교/ 중앙대학교/ 초당대학교/ 한국외국어대대학교/ 한양대학교',
      Col13: '전라남도 및 광주광역시 (본적 또는 현재5년이상 부/모 거주기준)',
      Col14: '2020-11-18~2020-12-18',
      Col15: '장학복지과 방문 제출 또는 원본서류 등기 제출출',
      Col16: '해당없음',
      Col17: '성옥장학생으로 선정된 이후 휴학 및 자퇴 할 경우 장학금은 재단으로 반환처리 됨2021학년도 2학기 성적이 평균B학점 미만시 2학기 자격상실국가장학금 및 교내외 장학금 이중수혜자',
      Col18: '학교추천',
      Col19: '총장추천서 1부재학증명서 1부성적증명서 1부2021년도 건강/장기요양보험료 납부확인서 1부건강보험증 사본 1부추가서류 자기소개서성옥장학생 신상카드 1부 '
    },
    {
      Col1: '창암장학문화재단',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '저소득층',
      Col11: '1000000원',
      Col12: '사회 경제적 요인에 의한 계층: 소년소녀가장/ 국제결혼가정자녀지역적 특성에 의한 교육소외집단: 저소득층/ 저소득 밀집지역/ 농/산/어촌사회봉사활동 및 학업성적 우수자/ 예/체능 특기자',
      Col13: '해당없음',
      Col14: '2022-03-14~2022-03-18',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '해당없음',
      Col18: '학교장(대학의 경우 학과장 이상)의 추천 필요',
      Col19: '장학지원 안내서 1부(재단 서식)추천서 1부자기소개서 반명함판 사진 1매(추천서 좌측상단에 부착)계좌사본 1부(장학생 본인계좌 또는 부모계좌)'
    },
    {
      Col1: '세아해암학술장학재단',
      Col2: '장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학5학기/대학6학기',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 2개 학기 합산 평점 3.0/4.5 이상/ 금학기 포함 매학기 12학점 이상 수강계획인 자',
      Col10: '국가장학금 소득산정 기준 8분위이하 (9~10분위 신청불가)',
      Col11: '2년 동안 4개 학기 장학금 연 1천만원 범위 내 지속 지원교내·국가장학금 수혜자는 국공립대학교 한 학기 평균등록금의 50% 범위 내에서 생활비 추가 지원(등록금 초과지원 가능)',
      Col12: '대한민국 국적자로 아래 사항을 모두 만족학년 기준 : 국내 4년제 대학교 2학년 또는 3학년 재학기초과학 포함 공학계열 전공자 70% 이상 선발',
      Col13: '해당없음',
      Col14: '2021-12-22~2022-02-11',
      Col15: '1차 서류심사2차 면접심사최종합격',
      Col16: '00명기초과학 및 공학계열 전공자 70% 이상 선발',
      Col17: '20221학기 등록금 전액 고지감면 받아 본인 납부액이 없는 경우기업 또는 민간에서 선발한 장학생 자격을 유지하고 있는 경우휴학했거나 휴학 계획이 있는 경우우 ',
      Col18: '해당없음',
      Col19: '홈페이지 참고'
    },
    {
      Col1: '용운장학재단',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '수능 점수 각 영역별 3등급 이상 또는 학교 내신 성적 20% 이내',
      Col10: '경제적 도움이 필요한 학생 ',
      Col11: '학기당 3500000원 (4년간 지급) * 단 장학회 심의위원회에서 매 학기 소정의 심사를 통해 장학금 계속 지급여부 결정',
      Col12: '봉사정신이 충만하며 장차 국가와 사회의 지도자로 성장할 수 있는 유능한 학생2022학년도 4년제 정규대학에 합격하여 1학기 등록을 필한 학생',
      Col13: '해당없음',
      Col14: '2022-04-08~2022-05-31',
      Col15: '재단사무국에 서류 제출본 장학회 심의위원회의 서류심사(동영상 포함함)로 1차 선발1차 선발자 대상으로 장학회 심의위원회에서 개별 인터뷰 실시(일정 및 장소 별도공지)',
      Col16: '40명',
      Col17: '타기관의 장학금 수혜 대상이 아닌 학생(이중수혜방지)',
      Col18: '해당없음',
      Col19: '용운장학생 신청서고등학교 생활기록부수학능력시험 성적서자기소개서 및 나의성공담주민등록등본2021년 건강보험료 납부확인서2021년 지방세 세목별 과세증명서증명사진자기소개 동영상 CD 또는 USB'
    },
    {
      Col1: '용운장학재단',
      Col2: '해외유학(박사과정) 장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원/해외대학',
      Col7: '박사과정',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학(원) 성적이 3.6/4.3 또는 3.8/4.5 이상인 학생',
      Col10: '해당없음',
      Col11: 'USD 25000',
      Col12: '2022년 해외 대학 박사 과정에 합격하여 유학 예정인 학생봉사정신이 충만하며 장차 국가와 사회의 지도자로 성장할 수 있는 유능한 학생 중 경제적 도움이 필요한 학생',
      Col13: '해당없음',
      Col14: '2022-08-09~2022-08-12',
      Col15: '본 장학재단 장학심의위원회 서류심사로 1차 선발1차 선발자 대상으로 장학재단 심의위원회에서 개별 인터뷰',
      Col16: '해당없음',
      Col17: '홈페이지 참고',
      Col18: '해당없음',
      Col19: '용운장학생 신청서자기소개서지도교수추천서박사과정 대학교 입학허가서성적증명서 (학사/ 석사 각각)학업계획서 또는 연구계획서논문 또는 연구실적 또는 경력증명서주민등록등본개인정보수집이용제공동의서증명사진(3x4사이즈) ※ 양식다운로드는 홈페이지 내 장학생 제출서류 참고'
    },
    {
      Col1: '운봉장학문화재단',
      Col2: '운봉장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/특정학과',
      Col9: '직전학기 백분율 80점 이상자',
      Col10: '소득분위 1 ~ 8분위인 학생',
      Col11: '등록금 범위 내 지급',
      Col12: '2022학년도 1~3학년 중 1/ 2학기 등록예정 재학생',
      Col13: '해당없음',
      Col14: '2022-08-16~2022-08-31',
      Col15: ' * 공개모집이 아니라 대학교 내 추천 방식. 각 대학 장학 담당자께 문의',
      Col16: '0명',
      Col17: '타 장학금 수혜자는 선발에서 제외됨',
      Col18: '해당없음',
      Col19: '* 공개모집이 아니라 대학교 내 추천 방식. 각 대학 장학 담당자께 문의추천서식장학생지원서자기소개서 및 학업계획서장학생추천서개이정보 수집제공 및 조회동의서성적증명서 및 재학증명서고등학교 생확기록부언어(외국어 등)능력 시험 성적표수상 & 자격 경력서 사본봉사 및 사회활동 내역서20221학기 소득분위 확인서 또는 부모님 소득금액 증명서주민등록등본본인명의의 통장사본\'Pay it forward\' 영화를 보고 독후감 1부 자필로 별도 제출 * 자세한 사항은 각 대학 장학팀 문의'
    },
    {
      Col1: '재단법인 의성군인재육성재단',
      Col2: '재학성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평균학점이 B+이상 인 자',
      Col10: '해당없음',
      Col11: '1인당 최대 2500000원 * 단 타 장학금 수혜 시 공제',
      Col12: '관내 고등학교를 졸업한 대학교 재학생 중 직전학기 성적 평균학점이 우수한 자',
      Col13: '의성군 관내 고등학교 졸업한 자부/ 모 모두 관내 주민등록을 둔 경우 : 가산점수 1점부/ 모 중 1명이 관외 주민등록을 둔 자가 있는 경우 : 가산점수 0.5',
      Col14: '2022-03-02~2022-03-11',
      Col15: '평균학점/ 가산점수 합산하여 우선순위 선정 * 자세한 사항은 첨부파일 참고',
      Col16: '전문대학 : 10명4년제 대학 : 20명',
      Col17: '만학도 지원대상 아님 * 자세한 사항은 기관으로 문의 바랍니다.',
      Col18: '해당없음',
      Col19: '장학생 지원신청서장학생 지급신청서각서개인정보제공동의서고등학교 졸업증명서대학교 재학증명서직전학기 성적증명서(4.5점 만점 기준 환산 성적표)2학기 등록금 납부 고지서(또는 납부증명서)주민등록등본가족관계증명서(해당자)기타 제출 서류(총무과 요청시) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '재단법인단양장학회',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '관내고(신입.재학생) : 195000000원 (총65명 지급)관외고(신입생) : 22500000원(총 15명 지급)* 생활안정자금',
      Col12: '직전학기 12학점 이상 이수',
      Col13: '선발신청일 기준으로 부모와 대상자 모두 단양군 관내에 1년 이상 거주(주민등록)하고 있는 자',
      Col14: '2022-03-02~2022-03-11',
      Col15: '신입생: 고3 성적 40%/ 학교순위 60%재학생: 전년도 성적 50%/ 학교순위 50%',
      Col16: '관내고 : 65명관외고 : 7명',
      Col17: '휴학생정규학기 초과자졸업유예자',
      Col18: '해당없음',
      Col19: '장학금 신청서성적증명서고등학교 졸업증명서 (대학교 신입생·재학생)재학증명서 (대학교 신입생/ 재학생)주민등록등본 (부모와 본인의 주소지가 다를 경우 본인 및 부모 각각 제출)   주민등록등본 발급시 최근 1년간 주소이력을 포함하여 제출   주민등록등본 발급 인정기간: 공고일 1개월 이전까지만 인정가족관계증명서 (한부모 가정일 경우/ 부모와 본인의 주소지가 다를 경우 제출)기초생활수급대상자는 관련증명서류 (부모/ 해당자)전세금 확정일자 관련 증빙서류 (해당자)'
    },
    {
      Col1: '재단법인단양장학회',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '경제곤란자(기초생활수급자 자녀 등)를 대상으로 선발',
      Col11: '관내고 : 연1회 1500000원관외고 : 연1회 1000000원',
      Col12: '해당없음',
      Col13: '선발신청일 기준으로 부모와 대상자 모두 단양군 관내에 1년 이상 거주(주민등록)하고 있는 자',
      Col14: '2022-05-09~2022-05-17',
      Col15: '신입생 : 고3 성적 40% + 학교순위 60%재학생 : 전년 성적 50% + 학교순위 50%',
      Col16: '관내고 : 15명관외고 : 3명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 신청서성적증명서고등학교 졸업증명서 (대학교 신입생·재학생)재학증명서 (대학교 신입생/ 재학생)주민등록등본 (부모와 본인의 주소지가 다를 경우 본인 및 부모 각각 제출)   주민등록등본 발급시 최근 1년간 주소이력을 포함하여 제출   주민등록등본 발급 인정기간: 공고일 1개월 이전까지만 인정가족관계증명서 (한부모 가정일 경우/ 부모와 본인의 주소지가 다를 경우 제출)기초생활수급대상자는 관련증명서류 (부모/ 해당자)전세금 확정일자 관련 증빙서류 (해당자)'
    },
    {
      Col1: '군포사랑장학회',
      Col2: '자립지원장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생: 고등학교 3학년 등급평점(예체능 제외) 5.5등급 이내의 성적을 취득한 자재학생: 직전년도 평점평균 4.5만점 기준 C(2.0)학점 이상인 자/ 직전년도 30학점 이상 이수 자(계절학기 비 포함)',
      Col10: '재산평가기준 및 소득평가기준에 해당하는 자 * 자세한 사항은 첨부파일 혹은 홈페이지 공고 참조',
      Col11: '2000000원',
      Col12: '국내대학에 재학 중인 자',
      Col13: '공고일 현재 군포시에 계속하여 1년이상 주소를 두고 거주하는 자',
      Col14: '2022-05-09~2022-05-17',
      Col15: '타 기관으로부터 장학금을 70%미만으로 지원 받은 경우 신청자격은 주어지나 수혜율에 따라 차등점수(감정) 부여함(최고2점)',
      Col16: '27명 (신입생 8명/ 재학생 19명)',
      Col17: '타 기관으로부터 수업료를 포함한 상반기 등록금 전액(신입생의 경우 입학금 제외)의 70% 이상을 장학금 명목으로 지원받은 자본 재단 장학생으로 고/대학별 2회 이상 수혜 받은 자8학기 이수 후 졸업 예정자점수산정 기간 성적표에 D학점 있을경우 지원불가  * 자세한 사항은 첨부파일 혹은 홈페이지 공고 참고',
      Col18: '해당없음',
      Col19: '장학금지원신청서가족사항이 기록된 주민등록등본 (분리세대일 경우 가족관계 증명서 첨부)거주지 변동 사항이 기록된 신청자 본인의 초본 (주민등록 등본 발급시 주민번호 뒷자리 보이지 않게/ 개인 초본 발급시 주민번호 뒷자리 보이게 발급)2021년도 건강보험료 납부확인서(세대구성원전원) 및 건강보험 자격 확인서부동산확인서개인(신용)정보 수집 이용 제공 및 조회 동의서지급받을 통장 사본장애인증명서(본인) (해당자)등록금 납입증명서(또는 납부확인서)재학증명서성적증명서관내 고등학교 졸업증명서 (해당자)2021년도 자원봉사 활동 확인서 (해당자)'
    },
    {
      Col1: '군포사랑장학회',
      Col2: '면학장려장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고등학교 3학년 등급평점(예체능 제외) 5.5등급 이내재학생 : 직전년도 30학점이상 이수 및 4.5만점 기준 평점평균 2.0학점 이상인 자 (계절학기 비포함)',
      Col10: '국가기관으로부터 복지급여를 수혜받고 있는 세대',
      Col11: '2000000원',
      Col12: '국가기관으로부터 복지급여를 수혜 받고 있는 자국내대학에 재학 중인 자',
      Col13: '공고일 현재 군포시에 계속하여 1년이상 주소를 두고 거주하는 자',
      Col14: '2022-05-09~2022-05-17',
      Col15: '해당없음',
      Col16: '23명 (신입생 6명/ 재학생 17명)',
      Col17: '타 기관으로부터 수업료를 포함한 상반기 등록금 전액(신입생의 경우 입학금 제외)의 70% 이상을 장학금 명목으로 지원받은 자본 재단 장학생으로 2회 이상 수혜 받은 자8학기 이수 후 계절학기 또는 한학기 수료 후 졸업 예정자점수산정 기간 성적표에 D학점 있을경우 * 자세한 사항은 첨부파일 혹은 홈페이지 참고',
      Col18: '해당없음',
      Col19: '장학금지원신청서       가족사항이 기록된 주민등록등본(분리세대일 경우 가족관계 증명서 첨부)거주지 변동 사항이 기록된 신청자 본인의 초본   (주민등록 등본 발급시 주민번호 뒷자리 보이지 않게/ 개인 초본 발급시 주민번호 뒷자리 보이게 발급) 복지급여수혜증명서 (국민기초생활수급자/ 차상위계층/ 무한돌봄긴급지원/ 한부모 대상자등)개인(신용)정보 수집 이용 제공 및 조회 동의서지급받을 통장 사본장애인증명서(세대구성원 전부) (해당자)재학증명서등록금 납입증명서(또는 납부확인서)성적증명서 관내 고등학교 졸업증명서 (해당자)   2021년도 자원봉사 활동 확인서 (해당자)'
    },
    {
      Col1: '군포사랑장학회',
      Col2: '특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '공고일 기준 직전 1년 이내 과학/ 예/체능 및 기능분야에서 시/군단위 이상을 대상으로 공공기관이 주최(주관)하는 각종대회(경연)에서 3위이내의 성적으로 입상한 자  * 국가대표/ 경기도대표/ 군포시대표 우대(가점 적용)국내대학에 재학 중인 자',
      Col13: '공고일 현재 군포시에 계속하여 1년이상 주소를 두고 거주하는 자',
      Col14: '2022-05-09~2022-05-17',
      Col15: '해당없음',
      Col16: '15명(신입생 4명/ 재학생 11명)',
      Col17: '타 기관으로부터 수업료를 포함한 상반기 등록금 전액(신입생의 경우 입학금 제외)의 70% 이상을 장학금 명목으로 지원받은 자본 재단 장학생으로 고/대학별 2회 이상 수혜 받은 자8학기 이수 후 계절학기 또는 한학기 수료 후 졸업 예정자점수산정 기간 성적표에 D학점 있을경우 지원불가 * 자세한 사항은 필독사항 확인',
      Col18: '학교장(대학생의 경우 학과장 포함) 추천',
      Col19: '장학금지원신청서 재학증명서/ 등록금 납입증명서(또는 납부확인서)입상자료 사본(3위이내 성적 입증자료) (입상자료 사본 제출 시 주최 측에서 제공하는 최고성적 등위 표(행사 팜플렛) 반드시 포함)가족사항이 기록된 주민등록등본(분리세대일 경우 가족관계 증명서 첨부)거주지 변동 사항이 기록된 신청자 본인의 초본 (주민등록 등본 발급시 주민번호 뒷자리 보이지 않게/ 개인 초본 발급시 주민번호 뒷자리 보이게 발급)장학생추천서개인(신용)정보 수집 이용 제공 및 조회 동의서지급받을 통장 사본시/ 도/ 국가 대표일 경우 증명서 필히 첨부관내 고등학교 졸업증명서 (해당자)'
    },
    {
      Col1: '군포사랑장학회',
      Col2: '근로자장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 고등학교 3학년 등급평점(예체능 제외) 5.5등급 이내재학생 : 직전년도 30학점이상 이수 및 4.5만점 기준 평점평균 C(2.0)학점 이상인 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '국내대학에 재학 중인 자공고일 현재 4대 보험이 적용되는 국내에 소재한 기업 또는 사업장에 공고일 기준 6개월 이상 계속 근로 중인 대학생',
      Col13: '공고일 현재 군포시에 계속하여 1년이상 주소를 두고 거주하는 자',
      Col14: '2022-05-09~2022-05-17',
      Col15: '해당없음',
      Col16: '9명(신입생 3명/ 재학생 6명)',
      Col17: '개인사업자 제외타 기관으로부터 수업료를 포함한 상반기 등록금 전액(신입생의 경우 입학금 제외)의 70% 이상을 장학금 명목으로 지원받은 자본 재단 장학생으로 고/대학별 2회 이상 수혜 받은 자8학기 이수 후 계절학기 또는 한학기 수료 후 졸업 예정자점수산정 기간 성적표에 D학점 있을경우 지원불가 * 자세한 사항은 필독사항 확인',
      Col18: '해당없음',
      Col19: '장학금지원신청서      재학증명서등록금 납입증명서(또는 납부확인서)성적증명서    재직증명서(공고일 현재 6개월이상 관내 사업장근무)    재직자의 사업장 사업자등록증      가족사항이 기록된 주민등록등본(분리세대일 경우 가족관계 증명서 첨부)거주지 변동 사항이 기록된 신청자 본인의 초본 (주민등록 등본 발급시 주민번호 뒷자리 보이지 않게/ 개인 초본 발급시 주민번호 뒷자리 보이게 발급) 2021년도 건강보험료 납부확인서(본인)개인(신용)정보 수집 이용 제공 및 조회 동의서지급받을 통장 사본관내 고등학교 졸업증명서 (해당자)    장애인증명서(본인) (해당자)2021년도 자원봉사 활동 확인서 (해당자) '
    },
    {
      Col1: '군포사랑장학회',
      Col2: '농업인장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 :고등학교 3학년 등급평점(예체능제외) 3.5등급 이내의 성적 취득한 자재학생 : 직전년도 30학점이상 이수 및 4.5만점 기준 평점평균(3.0)학점 이상인 자',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '국내대학에 재학 중인 자군포시에 거주하면서 농업에 종사하는 농업인의 자녀 및 본인',
      Col13: '공고일 현재 군포시에 계속하여 1년이상 주소를 두고 거주하는 자',
      Col14: '2022-05-09~2022-05-17',
      Col15: '해당없음',
      Col16: '7명(신입생 2명/ 재학생 5명)',
      Col17: '타 기관으로부터 수업료를 포함한 상반기 등록금 전액(신입생의 경우 입학금 제외)의 70% 이상을 장학금 명목으로 지원받은 자본 재단 장학생으로 고/대학별 2회 이상 수혜 받은 자8학기 이수 후 졸업 예정자점수산정 기간 성적표에 D학점 있을경우 지원불가대학원/ 사이버대학/ 방송통신대학/ 평생교육원 학점은행 등 제외',
      Col18: '해당없음',
      Col19: '장학금지원신청서   재학증명서  등록금 납입증명서(또는 납부확인서)  성적증명서 가족사항이 기록된 주민등록등본(분리세대일 경우 가족관계 증명서 첨부)거주지 변동 사항이 기록된 신청자 본인의 초본 (주민등록 등본 발급시 주민번호 뒷자리 보이지 않게/ 개인 초본 발급시 주민번호 뒷자리 보이게 발급)농업인임을 증명할 수 있는 농지원부(관외농지 포함) 재산세 과세증명서세대 전원(※ 미과세일 경우 임대차 계약서 첨부)개인(신용)정보 수집 이용 제공 및 조회 동의서지급받을 통장 사본관내 고등학교 졸업증명서 (해당자)    장애인증명서(본인) (해당자)2021년도 자원봉사 활동 확인서 (해당자)'
    },
    {
      Col1: '군포사랑장학회',
      Col2: '성적우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생: 고등학교 3학년 등급평점(예체능제외) 2.5등급 이내의 성적을 취득한 자재학생: 직전년도 평점평균 4.5만점 기준 B+(3.5)학점 이상인 자/ 직전년도 30학점 이상 이수 자 (계절학기 비 포함)',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '국내대학에 재학 중인 자',
      Col13: '공고일 현재 군포시에 계속하여 1년이상 주소를 두고 거주하는 자',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '총 38명 (신입생 10명 / 재학생 28명)',
      Col17: '타 기관으로부터 수업료를 포함한 상반기 등록금 전체 금액의 70% 이상을 장학금 명목으로 지원받은 자본 재단 장학생으로 2회 이상 수혜 받은 자 점수산정기간 성적표에 D학점 있을경우 지원불가대학원/ 해외유학생/ 평생교육원/ 학점은행 등 제외 * 자세한 사항은 첨부파일 혹은 홈페이지 공고 참고',
      Col18: '해당없음',
      Col19: '장학금지원신청서                              가족사항이 기록된 주민등록등본(분리세대일 경우 가족관계 증명서 첨부)거주지 변동 사항이 기록된 신청자 본인의 초본 (주민등록 등본 발급시 주민번호 뒷자리 보이지 않게/ 개인 초본 발급시 주민번호 뒷자리 보이게 발급)개인(신용)정보 수집 이용 제공 및 조회 동의서지급받을 통장 사본장애인증명서(본인) (해당자)등록금 납입증명서(또는 납부확인서) 재학증명서    성적증명서   관내 고등학교 졸업증명서 (해당자)2021년도 자원봉사 활동(기간:2021. 2. 22.~ 2022. 4. 24일까지) 확인서 (해당자)'
    },
    {
      Col1: '포항시장학회',
      Col2: '포항시민장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 2개 학기 성적 3.6점 이상인자(전문대학 3.8점 이상)인 자로 학교장의 추천을 받은 자(*1학년은 직전 1개 학기 성적 반영)',
      Col10: '건강보험료 직전 3개월(6월~8월) 월평균 납부액(부모 모두 반영) 고려',
      Col11: '1인당 2000000원(등록금 실 납부액 범위 내 지원)',
      Col12: '해당없음',
      Col13: '본인 또는 보호자가 선발 공고일 현재1년 이상 계속하여 포항시에 주민등록이 되어 있는 자',
      Col14: '2022-08-24~2022-09-20',
      Col15: '성적 30% + 건강보험료 70% + 가산점(장애인/ 다자녀/ 다문화/ 기부자/ 포항시 거주일수)',
      Col16: '대학교(191명)전문대학교(65명)',
      Col17: '공고일 현재 휴학 중 이거나 정학/ 퇴학/ 등 징계 처분을 받은 자 부모가 직장으로부터 학비를 지원 받는 경우등록금 실 납부 금액이 최저 지급금액(50만원)미만인 경우 포항학사 입사생학점은행제/ 원격대학(방송통신대학교/ 사이버대학 등)/ 직업학교 재학생 ',
      Col18: '대학총장 추천',
      Col19: '장학생 신청서(재단홈페이지 입력 후 출력 제출)재학증명서직전 2개 학기 성적증명서(4.5점 만점)/ (1학년은 직전 학기 성적증명서)주민등록 등본(포항시 거주자) 10년간 주소변동 사항 포함  ※ 부모와 주소지가 다를 경우 가족관계증명서 제출건강보험료 납부확인서(장기요양보험 제외) 최근 3개월/ 부/모 각1부   ※ 국민기초생활수급자는 기초생활수급자 증명서로 제출신청인 서약서개인정보 수집이용 및 제공조회 동의서(본인과 부/모) ※ 한부모 가정 추가 서류  1. 부 또는 모 사망학생 기준 가족관계증명서 2. 부모 이혼부 또는 모 기준 가족관계증명서'
    },
    {
      Col1: '포항시장학회',
      Col2: '문화·예술·기능 특기생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '2022년도 2학기 한국장학재단 학자금 지원구간 통지를 받은 자 * 아래 해당자 가산점국민기초생활수급자 및 그 자녀 한부모 가정 장애가정 다자녀 가정 다문화 가정 재난피해 가구 ※ 자세한 사항은 첨부파일 참조',
      Col11: '2000000원 ( * 등록금성 장학금으로 등록금 실 납부금액 내 지급)',
      Col12: ' * 최근 2년 이내(2020.08.24.이후) 아래 해당자(문화·예술특기생) 전국 4년제 대학교 주최 전국규모 실기대회 또는 언론사 및 관련 협회 주최(주관) 전국규모 실기대회 3위 이내 입상자(기능특기생) 도 단위 이상 규모의 기관에서 주관한 전국대회 또는 도 대회 3위 이내 입상자',
      Col13: '선발 공고일 현재를 기준으로 본인 또는 그 보호자가 1년 이상 계속하여 포상시에 주민등록이 되어 있는 자',
      Col14: '2022-08-24~2022-09-20',
      Col15: '입상실적 + 한국장학재단 학자금 지원구간 + 가산점',
      Col16: '5명',
      Col17: '휴학 및 퇴학 등 징계 처분을 받은 자부모가 직장으로부터 학비(등록금 전액)을 지원 받는 경우2학기 등록금 전액 면제자 및 본인 부담금 50만원 미만인 자서울 포항학사 입사생학점은행제/ 직업학교 재학생1인당 1종류/ 1세대 1명 지원 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학생 신청서재학증명서주민등록등본소득증빙서류(택1)대회수상실적서 또는 상장  * 자세한 사항은 첨부파일 참조 바랍니다.'
    },
    {
      Col1: '포항시장학회',
      Col2: '체육특기생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '2022년도 2학기 한국장학재단 학자금 지원구간 통지를 받은 자',
      Col11: '1인당 2000000원',
      Col12: '최근 2년 이내(2020.08.24. 이후 입상) 도 단위 이상 규모의 기관에서 주관한 전국 대회 또는 도 대회 3위 이내 입상자',
      Col13: '선발 공고일 현재를 기준으로 본인 또는 그 보호자가 1년 이상 계속하여 포상시에 주민등록이 되어 있는 자',
      Col14: '2022-08-24~2022-09-20',
      Col15: '포항시체육회추천',
      Col16: '5명',
      Col17: '휴학 및 퇴학 등 징계 처분을 받은 자부모가 직장으로부터 학비(등록금 전액)을 지원 받는 경우2학기 등록금 전액 면제자 및 본인 부담금 50만원 미만인 자서울 포항학사 입사생학점은행제/ 직업학교 재학생1인당 1종류/ 1세대 1명 지원 * 자세한 사항은 첨부파일 참고',
      Col18: ' 포항시체육회장 추천',
      Col19: '장학생 신청서재학증명서주민등록등본추천서대회수상실적증명서(입상자료 사본) * 개별신청불가 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '포항시장학회',
      Col2: '곰두리장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '장애인',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '2022년도 2학기 한국장학재단 학자금 지원구간 통지를 받은 자 * 저소득계층으로 아래 해당자 가산점국민기초생활수급자 및 그 자녀 한부모 가정 장애가정 다자녀 가정 다문화 가정 재난피해 가구 ※ 자세한 사항은 첨부파일 참조',
      Col11: '2000000원 * 등록금 실 납부액 범위 내 지급',
      Col12: '본인의 장애 정도가 심한 대학교 재학생',
      Col13: '선발 공고일 현재를 기준으로 본인 또는 그 보호자가 1년 이상 계속하여 포상시에 주민등록이 되어 있는 자',
      Col14: '2022-08-24~2022-09-20',
      Col15: '한국장학재단 학자금 지원구간(소득구간) 100% + 가산점',
      Col16: '5명',
      Col17: '휴학 및 퇴학 등 징계 처분을 받은 자부모가 직장으로부터 학비(등록금 전액)을 지원 받는 경우2학기 등록금 전액 면제자 및 본인 부담금 50만원 미만인 자서울 포항학사 입사생학점은행제/ 직업학교 재학생1인당 1종류/ 1세대 1명 지원 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학생 신청서재학증명서주민등록등본소득증빙서류(택1)장애인 증명서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '포항시장학회',
      Col2: '인재육성장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 B학점 이상인 자 (3.0/4.5만점/ 2.7/4.3만점) ',
      Col10: ' * 저소득계층으로 아래 해당자 가산점국민기초생활수급자 및 그 자녀 한부모 가정 장애가정 다자녀 가정 다문화 가정 재난피해 가구 ※ 자세한 사항은 첨부파일 참조',
      Col11: '2000000원 * 등록금성 장학금',
      Col12: '2022년도 2학기 한국장학재단 학자금 지원구간 통지를 받은 자',
      Col13: '선발 공고일 현재를 기준으로 본인 또는 그 보호자가 1년 이상 계속하여 포항시에 주민등록이 되어 있는 자',
      Col14: '2021-08-18~2021-09-15',
      Col15: '성적 30% + 한국장학재단 학자금 지원구간(소득구간) 70% + 가산점 * 자세한 사항은 첨부파일 참고',
      Col16: ' * 120명대학교 95명전문대학 25명',
      Col17: '휴학 및 퇴학 등 징계 처분을 받은 자부모가 직장으로부터 학비(등록금 전액)을 지원 받는 경우2학기 등록금 전액 면제자 및 본인 부담금 50만원 미만인 자서울 포항학사 입사생학점은행제/ 직업학교 재학생1인당 1종류/ 1세대 1명 지원 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학생 신청서재학증명서성적증명서주민등록등본소득증빙서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '포항시장학회',
      Col2: '해양·물류·관광 특성화 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '특정학과',
      Col9: '직전학기 성적 3.6/4.5점/ 3.35/4.3점 이상인 자',
      Col10: ' * 저소득계층으로 아래 해당자 가산점국민기초생활수급자 및 그 자녀 한부모 가정 장애가정 다자녀 가정 다문화 가정 재난피해 가구 ※ 자세한 사항은 첨부파일 참조',
      Col11: '2000000원 ( * 등록금 실 납부금액 내 지급 )',
      Col12: '4년제 대학교의 해양학과/ 항만물류학과/ 관광학과 재학생',
      Col13: '본인 또는 보호자가 선발 공고일 현재 1년 이상 계속하여 포항시에 주민등록이 되어 있는 자',
      Col14: '2022-08-24~2022-09-20',
      Col15: '성적70% + 한국장학재단 학자금 지원구간(소득구간) 30% + 가산점',
      Col16: '3명',
      Col17: '휴학 및 퇴학 등 징계 처분을 받은 자부모가 직장으로부터 학비(등록금 전액)을 제공받은 경우등록금 전액 면제자 및 본인 부담금 50만원 미만인 자서울 포항학사 입사생 학점은행제/ 원격대학(방송통신대학/ 사이버대학 등)/ 직업학교 재학생1인당 1종류/ 1세대 1명 지원 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '장학생 신청서재학증명서성적증명서주민등록등본소득증빙서류(택1) * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '포항시장학회',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 3.0/4.5점/ 2.7/4.3점 이상인 자',
      Col10: ' * 아래 해당자 가산점국민기초생활수급자 및 그 자녀 한부모 가정 장애가정 다자녀 가정 다문화 가정 재난피해 가구 ※ 자세한 사항은 첨부파일 참조',
      Col11: '2000000원 * 등록금성 장학금으로 등록금 실 납부액 범위 내 지급',
      Col12: '다자녀(3명 이상)가정의 자녀녀2022년도 2학기 한국장학재단 학자금 지원구간 통지를 받은 자',
      Col13: '선발 공고일 현재를 기준으로 본인 또는 그 보호자가 1년 이상 계속하여 포상시에 주민등록이 되어 있는 자',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '선발기준 : 성적 30% + 한국장학재단 학자금 지원구간 70% + 가산점',
      Col16: '50명',
      Col17: '휴학 및 퇴학 등 징계 처분을 받은 자부모가 직장으로부터 학비(등록금 전액)을 지원 받는 경우2학기 등록금 전액 면제자 및 본인 부담금 50만원 미만인 자서울 포항학사 입사생학점은행제/ 직업학교 재학생1인당 1종류/ 1세대 1명 지원 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '장학생 신청서재학증명서성적증명서주민등록등본소득증빙서류(택1)다자녀 가정 증명서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '포항시장학회',
      Col2: '고액기부자 추천 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '해당없음',
      Col13: '대학교 재학생으로 본인 또는 보호자가 선발 공고일 현재 1년 이상 계속하여 포항시에 주민등록이 되어 있는 자',
      Col14: '2022-01-03~2022-01-17',
      Col15: '대학성적 평가 + 소득 평가',
      Col16: '해당없음',
      Col17: '퇴학/ 휴학/ 군 입대/ 질병/ 졸업 등 기타 사유로 장기간 학업을 계속할 수 없는 경우',
      Col18: '해당없음',
      Col19: '장학생신청서재학증명서성적증명서주민등록 등본(최근 5년 주소변동 사항 포함)  * 부모와 주소지가 다를 경우 가족관계증명서(상세) 제출사회참여서약서신청인 서약서개인정보 수집/이용 및 제공/조회 동의서 (본인과 부/모)추천서통장사본'
    },
    {
      Col1: '재단법인 종로구장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 학점이 2.5이상(4.5만점)',
      Col10: '부모(가족)의 2021년도 재산세과세금액이 200만원 이하인 가정환경이 어려운 자',
      Col11: '대학생 2000000원 이내 * 연 2회 지급 2학기에도 거주지 성적 유지',
      Col12: '전문대/ 대학교 2학기 이상 재학생',
      Col13: '신청기준일(2022.1.1.) 현재 1년 이상 종로구에 주민등록을 두고 거주하는 자',
      Col14: '2022-07-01~2022-07-27',
      Col15: '해당없음',
      Col16: '대학생 85명',
      Col17: '최근 2년 이내 본인 또는 가족이 (재)종로구장학회의 장학금 받은 경우 심사에서 제외신입생 제외',
      Col18: '동장 추천',
      Col19: '신청(추천)서자기소개서개인정보 동의서재학증명서성적증명서주민등록초본(전입일자 포함 발급)재산세과세증명서(양쪽부모) 각 1부 (한부모인 경우 : 한부모 증명서/ 또는 가족관계증명서) * 자세한 사항은 홈페이지 또는 첨부파일 참고'
    },
    {
      Col1: '성련장학재단',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기',
      Col8: '공학계열/사회계열/인문계열/특정학과',
      Col9: '학업 성적이 평점평균 3.50이상 (4.5만점 기준) / 평점평균 3.30이상 (4.3만점 기준)',
      Col10: ' * 아래 조건 모두 충족부/모 연간 소득 합산 60000000원 이하이면서 월 건강보험료 합산 160000원 이하부/모 연간 순 재산세 합산 450000원 이하',
      Col11: '한 학기 등록금 전액',
      Col12: '2022학년도 2학기 2.3학년',
      Col13: '해당없음',
      Col14: '2022-04-11~2022-05-02',
      Col15: ' * 각 대학에 추천 의뢰→서류심사→합격자 발표→학교에 장학금 지급',
      Col16: '해당없음',
      Col17: '8학기를 초과한 경우12학점 미만을 이수한 학기가 있는 경우기초생활수급자 또는 다음학기에 해외 교환학생 프로그램에 참가하거나 휴학 등의 계획이 있는 경우 성련장학금을 수여한 해당 학기의 성적이 장학금 수여 직전 학기보다 하락한 경우 ',
      Col18: '지도교수 또는 강의 수강했던 교수의 추천',
      Col19: '장학생 지원서장학생 추천서장학금 신청서개인정보 수집·이용 동의서에세이전 학년 성적증명서 주민등록등본가족관계증명서부/모의 2021년도 소득 증빙자료 부/모의 최근 2년간 지방세 세목별 과세 증명서부/모의 건강보험증 사본 및 2021년도 1년간 건강보험료 납부 확인서 * 재단에서 학교로 추천을 의뢰하는 장학금으로/ 재학하는 학교의 장학부서로 문의 요망'
    },
    {
      Col1: '재)화성시인재육성재단',
      Col2: '진학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학수학능력평가결과 국어/ 영어/ 수학등급의 합이 7등급 이내고등학교 3학년 성적과목별 등급평균(과목별 등급의 합/과목수)이 2.5등급 이내  * 위 두가지 중 하나 이상의 조건 만족',
      Col10: '해당없음',
      Col11: '1인당 2000000원',
      Col12: '국내에 소재한 1학년 신입생',
      Col13: '공고일 현재/ 본인 또는 부모/ 친권자의 주민등록이 화성시 관내 1년 이상국내에 소재한 2~4년제 학교에 재학 중인 학생화성시 관내 고등학교 출신 우선 선발',
      Col14: '해당없음',
      Col15: '생활정도(30) + 성적(50(성적배점*5) + 장기거주(20)',
      Col16: '소득분위 별 차등지급으로 지급 총액 내에서 지원 가능인원 선발',
      Col17: '자격요건에 결격사유가 발생하였을 경우(거주/ 성적/ 학적 등)퇴학/ 정학처분 및 휴학 시장학금을 받는 학생이 타 장학금을 받아 1년 등록금의 총액을 상회하는 경우/ 다만/ 기 수령한 타 장학금 총액을 비교하여 1년 등록금의 차액만큼 중복지원 가능  **자세한 사항은 홈페이지 공고 확인필수',
      Col18: '추천권자(학교장 또는 대학총장) 추천천',
      Col19: '장학금 지원 신청서신청인 서약서개인신용정보 동의 제공/활용 동의서신청자 또는 부모/친권자의 주민등록 초본신청자 기준의 가족관계증명서재학증명서등록금 납부 내역서고등학교 성적증명서 / 수능성적표부/모 2021년 4분기 3개월분 건강보험료 납부확인서부/모 각 건강보험자격득실 확인서관내 고등학교 졸업증명서(해당자)저소득층확인서(해당자) * 자세한 사항은 홈페이지 공고 참고'
    },
    {
      Col1: '재)화성시인재육성재단',
      Col2: '꿈드림/ 우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '우수: 직전 2개 학기 학업성적이 평점평균 3.0이상(4.5만점)인 자꿈드림 : 직전 2개 학기 학업성적이 2.5이상(4.5만점) 인 자직전학기 12학점 이상 이수',
      Col10: '해당없음',
      Col11: '1인당 최대 2000000원',
      Col12: '국내에 소재한 2/4년제 학교에 2학년 이상 재학중인 자',
      Col13: '공고일 현재/ 본인 또는 부모/ 친권자의 주민등록이 화성시 관내 1년 이상국내에 소재한 2~4년제 학교에 재학 중인 학생화성시 관내 고등학교 출신 우선 선발',
      Col14: '2022-03-08~2022-03-31',
      Col15: '꿈드림: 생활정도(60) + 성적(30(성적배점*3)) + 장기거주(10)우수: 생활정도(30) + 성적(50(성적배점*5)) + 장기거주(20)',
      Col16: '해당없음',
      Col17: '장학금을 받는 학생이 타 장학금을 받았다는 사실이 통보될 시※ 단/ 기 수령한 타장학금이 1년 수업료의 50%에 미달할  때는 중복지원이 가능하다.',
      Col18: '추천권자(학교장 또는 대학총장) 추천',
      Col19: '장학금 지원 신청서신청인 서약서개인신용정보 등의 제공/활용 동의서신청자 또는 부모.친권자의 주민등록 초본신청자 기준의 가족관계증명서재학증명서등록금 납부 내역서성적증명서학자금 지원구간 통지서(우수장학생의 경우 필수제출 아님)관내 고등학교 졸업증명서(해당자)저소득층확인서(해당자) * 자세한 사항은 홈페이지 공고 참고'
    },
    {
      Col1: '(재)한국태양유전교통사고유자녀장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '월등하게 학업성적이 우수하여 장래가 촉망되는 자(평균 성적이 우수한 자)',
      Col10: '가정이 곤궁하여 학업이 어려운 자지방세 세목별 과세증명서에 의하여 1)비과세자 2)미과세자 3)과세액이 소액인자 부터 선발',
      Col11: ' * 공통: 상반기(4월경) 하반기(9월경) 나누어 1년에 2회 지급.전문대학: 연간 3000000대 학 교  : 연간 4000000',
      Col12: '( 단순 교통사고 경험자 는 선발되지 않습니다. 학생본인사고 해당 안 됨. )교통사고라 함은 자동차사고/철도사고/여객기사고/해상 연락선사고를 말함.\t',
      Col13: '경상남도 내 소재 전문대학/ 대학교 재적',
      Col14: '2022-08-01~2022-08-04',
      Col15: ' 서류심사 및 선발결정은 본 장학회에서 직접 선발한다.전년도 기수혜자 우선 선발 교통사고 사망 및 중증자애인 우선 선발 지방세 세목별과세증명서에 의하여 과세액이 소액인자부터 우선 선발서류 미비자의 경우/ 최종으로 미루어 신청자가 예정 인원에 미달 시 선발 대상에 넣는다.',
      Col16: '해당없음',
      Col17: '단순 교통사고 또는 학생본인사고',
      Col18: '해당없음',
      Col19: '* 신청시 학교 담당자에게 문의 필수.장학금지급신청서교통사고사실확인원가족관계증명서장애인증명서(해당자)재학증명서(요청시)지방세세목별 과세증명서(요청시)학생본인통장사본* 기수혜자는 장학금 지급 신청서만 제출'
    },
    {
      Col1: '(재)정헌재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '해당없음',
      Col8: '특정학과',
      Col9: '직전학기 성적 평점이 3.8/4.3 이상',
      Col10: '해당없음',
      Col11: '등록금 전액 (매학기 심사 후 계속 지원여부 결정)',
      Col12: '2022학년도 2학기 서울대학교 경영대학 재학예정자 * 20222학기 기준 학부 3학년 재학생동 재단의 장학금 수여식 참석 가능자',
      Col13: '해당없음',
      Col14: '2021-11-08~2021-11-19',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '타 장학금 수혜자',
      Col18: '추천서 (학교장 직인 날인 생략) * 조사자 추천의견 및 서명은 지도교수님께 의뢰할 것',
      Col19: '추천서(학교장 직인 날인 생략)성적증명서개인정보 수집·이용 및 제공 동의서(재단 제출용 및 장학복지과 제출용 모두)자기소개서'
    },
    {
      Col1: '전기공사공제조합장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '최근 이수학기의 평균성적이 B+ 또는 백분율 환산점수 85점 이상인 자 최근 이수학기의 이수학점이 최소 15학점 이상인 자',
      Col10: '해당없음',
      Col11: '학기당 등록금 최대 2500000원 * 단 등록금에서 교내 및 국가장학금을 제한 금액을 학기당 최대 250만원 한도 내에서 지급',
      Col12: '전기관련학과에 재학중인 자혹은 전기공사공제조합에 가입되어있는 조합원과 그 임직원 및 자녀(전공무관/ 단 전기관련학과 우선선발)',
      Col13: '해당없음',
      Col14: '2022-06-27~2022-07-18',
      Col15: '서류심사(성정 50%/ 가정형편 50%)',
      Col16: '00명(단/ 전형별 1학교 1인 선발이 원칙)',
      Col17: '타기관으로부터 등록금(일부 포함)을 장학금으로 지급받고 있는 자(단/ 교내 및 국가장학금 제외)휴학/ 군휴학 예정자 및 초과학기 이수예정자  * 장학생으로 선발된 후 휴학시 선발 취소 또는 지급 중지징계 처분을 받은 자장학회 설립취지에 위배된다고 인정되는 자입학예정자',
      Col18: '학교장 또는 학과장 추천',
      Col19: '체크리스트 1부자기소개서 1부성적증명서 1부지원자 가족관계증명서 1부(편모(부)의 경우 보호자의 가족관계증명서 제출)재직증명서 재정상황 증빙서류 '
    },
    {
      Col1: 'ok배정장학재단',
      Col2: 'OK배정장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체 평점 4.0/4.5(3.7/4.3) 이상 * 본인이 계산한 환산점수/ 반올림불가 ※ 재학중인 학위 별로 상이하므로 홈페이지 공고 확인 필수',
      Col10: '소득분위 8분위 이내',
      Col11: '221학기 등록금 전액 교내.외 장학금으로 해결 ',
      Col12: '국내/외 정규 4년제 대학 대학생 중 2개 학기 이상 성적증명서 제출가능한 자 ',
      Col13: '해당없음',
      Col14: '2022-02-16~2022-02-18',
      Col15: '서류심사면접최종선발',
      Col16: 'OO명',
      Col17: '20222학기 입학예정자/ 편입예정자/ 휴학예정자졸업유예/ 복수전공 등 추가학기는 정규학기로 인정불가',
      Col18: '해당없음',
      Col19: ' ※ 재학중인 학위 별로 상이하므로 홈페이지 공고 확인 필수'
    },
    {
      Col1: '재단법인우파장학회',
      Col2: '대학장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 연간 5000000 (학기별 250만원)',
      Col12: '우수대학 합격(등록)자 (2022학년도 신입생)',
      Col13: '창원시 소재 고등학교 졸업자',
      Col14: '2022-06-28~2022-08-16',
      Col15: '합격대학/ 수능성적/ 고교 내신성적/ 가정형편/ 서류 및 면접결과를 종합적으로 고려하여 선발함',
      Col16: '45명 이내',
      Col17: '등록금 전액 국가지원학교 및 타 장학금 등록금전액 수혜자는 대상에서 제외',
      Col18: '출신고등학교장 추천서',
      Col19: '장학생지원서(출신고등학교장 추천서 겸용) 1부자기소개서 1부. 고등학교 학교생활기록부 사본 1부.수능성적표 사본 1부.(대학교)신입생 입학금 및 등록금 영수증 사본 1부 * 자세한 사항은 홈페이지 공지사항 선발공고 참고'
    },
    {
      Col1: '재단법인신양문화재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체학년 평균 B학점 이상자수강및 신청학점: 학기별 10학점 이상/ 대학원 4학점 이상',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '2022년도 1학기 선발 장학생 / 1학기 선발자 결원에 대한 대체 선발자학부생초과학기자: 10학기까지 지원가능(최종학기 수강학점 5학점 이상) * 자세한 사항은 장학재단 홈페이지 공고 확인',
      Col13: '해당없음',
      Col14: '2021-06-07~2021-06-18',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원및 추천서 전체학년 성적증명서 개인정보제공동의서 (신규신청자)본인통장사본 (신규신청자)학비장학생: 등록금고지서 사본/등록금 확인서 (대학발행)생활비장학생: 국가장학금 소득분위확인서(2022년도 2학기 학자금지원구간 통지서)'
    },
    {
      Col1: '시흥시인재양성재단',
      Col2: '재능장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 3000000원',
      Col12: '대한체육회 등 공인된 전국대회(국제대회 포함)에서 개인분야 3위 이내 입상자도 단위 대회에서 개인분야 3위 이내 입상자',
      Col13: '공고일 현재 본인 또는 부모/친권자의 주민등록이 시흥시에 1년이상 되어 있는 자 * 대학생 : 관내고등학교 졸업자(졸업예정자 포함)',
      Col14: '2021-06-07~2021-06-18',
      Col15: '해당없음',
      Col16: '10명',
      Col17: ' * 방송대학/ 통신대학/ 방송통신대학/ 사이버대학/ 학점은행제는 선발 제외 * 본재단의 장학생으로 선발된자가 국가/지방자치단체/공공단체 및 민간(단체) 등으로부터 별도의 장학금(수업료)을 지급받아 장학금 총액이 초과하는 경우 장학금 지급중지',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록 등본 및 초본 (신청자 본인)재학증명서수상실적 증명서직전학년 성적증명서 (학기별 최소 8학점 이상 이수) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '시흥시인재양성재단',
      Col2: '시흥인재육성장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '관내 고등학교 졸업 예정자 : 직전학년 내신 전과목 점수가 2등급(B등급)이상인자 대학교(전문대 포함) 재학생 : 직전학년 취득 평균 평점이 4.0 이상인 자 (4.3 만점의 경우 3.7 이상인 자)',
      Col10: '해당없음',
      Col11: '대학생 3000000원',
      Col12: '해당없음',
      Col13: '공고일 현재 본인 또는 부모/친권자의 주민등록이 시흥시에 1년이상 되어 있는 자 * 대학생 : 관내고등학교 졸업자(졸업예정자 포함)',
      Col14: '2022-06-10~2022-07-08',
      Col15: '해당없음',
      Col16: '25명',
      Col17: '방송대학/ 통신대학/ 방송통신대학/ 사이버대학/ 학점은행제는 선발 제외본재단의 장학생으로 선발된자가 국가/지방자치단체/공공단체 및 민간(단체) 등으로부터 별도의 장학금(수업료)을 지급받아 장학금 총액이 초과하는 경우 장학금 지급중지',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록 등본 및 초본 (신청자 본인)재학증명서직전학년 성적증명서공인된 기관의 봉사활동 인증서 또는 확인서 * 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '시흥시인재양성재단',
      Col2: '다함장학생(미래)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학생은 2.0이상(4.3만점의 경우 1.8이상)',
      Col10: '부모 모두의 2021년도(1월12월) 건강보험 고지료 총액이 적은 자자',
      Col11: '대학생 2000000원',
      Col12: '해당없음',
      Col13: '공고일 현재 본인 또는 부모/친권자의 주민등록이 시흥시에 1년이상 되어 있는 자 ',
      Col14: '2022-06-10~2022-07-08',
      Col15: '해당없음',
      Col16: '250명',
      Col17: '방송대학/ 통신대학/ 방송통신대학/ 사이버대학/ 학점은행제는 선발 제외본재단의 장학생으로 선발된자가 국가/지방자치단체/공공단체 및 민간(단체) 등으로부터 별도의 장학금(수업료)을 지급받아 장학금 총액이 초과하는 경우 장학금 지급중지',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록 등본 및 초본 (신청자 본인)재학증명서직전학년 성적증명서지원자 부모 양측의 건강보험료 납부확인서와 자격득실확인서기타 가정 사정을 증명할 수 있는 서류 (해당자)한 부모가정의 경우 보호자 명의로 가족관계증명서 제출 요망 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '시흥시인재양성재단',
      Col2: '다함장학생(시흥산업단지재직자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 2000000원',
      Col12: '공고일로부터 1년 이상 시흥시 산업단지에 위치하는 기업체에 재직중인 가정의 자녀 중 성적우수자 * 동점자의 경우/ 시흥 산업단지에 재직 중인 부 또는 모의 재직연수가 오래된 가정의 자녀를 우선선',
      Col13: '공고일 현재 본인 또는 부모/친권자의 주민등록이 시흥시에 1년이상 되어 있는 자 * 대학생 : 관내고등학교 졸업자(졸업예정자 포함)',
      Col14: '2021-06-07~2021-06-18',
      Col15: '해당없음',
      Col16: '20명',
      Col17: ' * 방송대학/ 통신대학/ 방송통신대학/ 사이버대학/ 학점은행제는 선발 제외 * 본재단의 장학생으로 선발된자가 국가/지방자치단체/공공단체 및 민간(단체) 등으로부터 별도의 장학금(수업료)을 지급받아 장학금 총액이 초과하는 경우 장학금 지급중지',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록 등본 및 초본 (신청자 본인)재학증명서직전학년 성적증명서사업장의 수업료 ㅁ지원 확인서공고일 이후 발급한 부모 또는 부양의무자의 재직증명서 또는 기타 취업을 증명할 수 있는 서류 * 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '시흥시인재양성재단',
      Col2: '선행장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 3000000원',
      Col12: '지원 자격을 만족하며 효·선행·자원봉사 활동으로 타인의 귀감이 되는 학생2020년도 자원봉사 실적이 우수한 학생 (60시간 이상)',
      Col13: '공고일 현재 본인 또는 부모/친권자의 주민등록이 시흥시에 1년이상 되어 있는 자 * 대학생 : 관내고등학교 졸업자(졸업예정자 포함)',
      Col14: '2022-02-21~2022-03-13',
      Col15: '해당없음',
      Col16: '12명',
      Col17: ' * 방송대학/ 통신대학/ 방송통신대학/ 사이버대학/ 학점은행제는 선발 제외 * 본재단의 장학생으로 선발된자가 국가/지방자치단체/공공단체 및 민간(단체) 등으로부터 별도의 장학금(수업료)을 지급받아 장학금 총액이 초과하는 경우 장학금 지급중지',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록 등본 및 초본(신청자 보인)재학증명서공인된 기관의 봉사활동 인증서 또는 확인서상장/ 표창장 등 언론보도내용 (해당자)직전학년 성적증명서 * 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '시흥시인재양성재단',
      Col2: '수능성적우수자',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2021년도 시행 대학수학능력시험 평균성적이(언어/ 수학/ 탐구) 1.5등급 이내인 자',
      Col10: '해당없음',
      Col11: '3000000원 (교육지원비성 장학금)',
      Col12: '시흥시 관내 고등학교 졸업자자',
      Col13: '공고일 현재 본인 또는 부모/친권자의 주민등록이 시흥시에 1년 이상 되어 있는 자',
      Col14: '2021-06-07~2021-06-18',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '방송대학/ 통신대학/ 방송통신대학/ 사이버대학/ 학점은행제는 선발제외',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록 등본 및 초본(신청자 본인)재학증명서2021년도 시행 수능성적통지표(본인사항 증빙)관내 고교 졸업장 사본 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '시흥시인재양성재단',
      Col2: '동행장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학생 3000000원',
      Col12: ' * 북한이탈주민의 경우 하나원에서 발급하는 「북한이탈주민 등록확인서」에 해당되는 사람에 한함 * 다문화가정의 경우 부·모의 국적이 대한민국과 외국으로 구성된 경우에 한함',
      Col13: '시흥시에 거주중인 북한이탈주민 또는 북한이탈주민 가정의 학생시흥시에 거주중인 다문화가정의 학생시흥시에 거주하는 학교 밖 청소년',
      Col14: '2022-06-10~2022-07-08',
      Col15: '해당없음',
      Col16: '8명',
      Col17: ' * 방송대학/ 통신대학/ 방송통신대학/ 사이버대학/ 학점은행제는 선발 제외 * 본재단의 장학생으로 선발된자가 국가/지방자치단체/공공단체 및 민간(단체) 등으로부터 별도의 장학금(수업료)을 지급받아 장학금 총액이 초과하는 경우 장학금 지급중지',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록 등본 및 초본 (신청자 본인)재학증명서새터민 : 지원자 본인 또는 부모 명의의 북한이탈주민 등록확인서다문화 : 지원자 부모 중 1인의 기본증명서지원자 부모 양측의 건강보험료 납부확인서지원자 부모 양측의 건강보험료 자격득실확인서관련 사업 기관장 추천서 (가능한 경우만 제출)직전학년 성적증명서 (1학년은 고교3학년 성적증명서) * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '시흥시인재양성재단',
      Col2: '다함장학생(다자녀가정)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 평점 C학점 이상',
      Col10: '해당없음',
      Col11: '대학생 2000000원',
      Col12: '3자녀 이상 가정의 학생 중 자녀수와 가구의 학생수(미취학 아동 제외)를 합산한 점수가 높은 자동점일 경우 지원 학생의 시흥시 거주기간이 높은 순으로 선발',
      Col13: '공고일 현재 본인 또는 부모/친권자의 주민등록이 시흥시에 1년이상 되어 있는 자',
      Col14: '2022-03-21~2022-04-01',
      Col15: '해당없음',
      Col16: '대학생 20명',
      Col17: ' * 방송대학/ 통신대학/ 방송통신대학/ 사이버대학/ 학점은행제는 선발 제외 * 본재단의 장학생으로 선발된자가 국가/지방자치단체/공공단체 및 민간(단체) 등으로부터 별도의 장학금(수업료)을 지급받아 장학금 총액이 초과하는 경우 장학금 지급중지',
      Col18: '해당없음',
      Col19: '장학생 지원서주민등록 등본 및 초본(신청자 본인/시흥시 거주이력 전체)재학증명서직전학년 성적증명서부 또는 모 기준의 가족관계증명서형제자매 중 대학생이 있을 경우 대학생 재학증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인광주시민장학회',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2021년도 1/ 2학기 평점평균이 4.0점/4.5점 이상인 자 * 복학생의 경우/ 휴학 직전 두 학기 성적',
      Col10: '해당없음',
      Col11: '1인당 3000000원 / 지급기간 1년 (휴학퇴학졸업 등 제외)',
      Col12: '각 학교 재학생',
      Col13: '공고일 현재 주민등록상 부 또는 모가 2년 이상 연속하여 경기도 광주시 내에서 거주하고 있는 광주시민의 자녀',
      Col14: '2022-03-21~2022-04-01',
      Col15: '해당없음',
      Col16: '61명',
      Col17: '만30세 이상원격대학(방송통신대학/ 사이버대학 등) 재학생학점 은행제 대학재학생직업전문학교 재학생평가 대상 학기 및 신청일 현재 교환학생평가 대상 각 학기 12학점 미만 이수자정규학기를 초과한 학생입학예정자 신청불가',
      Col18: '해당없음',
      Col19: '장학생 지원신청서장학생 신청평가서자기소개서개인정보 수집/이용/제공 및 조회동의서주소이력을 포함한 주민등록 등본 또는 초본(부모기준 발급)성적증명서입학당시 치른 대학수학능력 성적표재학증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인광주시민장학회',
      Col2: '복지장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 두 학기 각각 12학점 이상 취득평점평균 3.0/(4.5)이상 ',
      Col10: '부모 합산 2021년 건강보험료 고지금액 132만원 이하',
      Col11: '1인당 3000000원 / 지급기간 1년 (휴학 퇴학 졸업 등 제외)',
      Col12: '해당없음',
      Col13: '공고일 현재 주민등록상 부 또는 모가 2년 이상 연속하여 경기도 광주시 내에서 거주하고 있는 광주시민의 자녀',
      Col14: '2022-03-21~2022-04-01',
      Col15: '해당없음',
      Col16: '61명',
      Col17: '만30세 이상원격대학(방송통신대학/ 사이버대학 등) 재학생학점 은행제 대학재학생직업전문학교 재학생평가 대상 학기 및 신청일 현재 교환학생평가 대상 각 학기 12학점 미만 이수자정규학기를 초과한 학생입학예정자 신청불가',
      Col18: '해당없음',
      Col19: '장학생 지원신청서장학생 신청평가서자기소개서개인정보 수집/이용/제공 및 조회동의서 (학생기준)주소이력을 포함한 주민등록등본 또는 초본(부모기준발급)성적증명서(2018년도 1/2학기 또는 직전 두 학기 성적 확인)지방세 세목별 과세증명서(부/모 모두 전체 세목기준발급)각종 가산점 관련 증명서류재학증명서 (2019년 신입생은 입학증명서류 제출) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인광주시민장학회',
      Col2: '진학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학수학능력시험 평균 2등급 이내고교 3년간 평균석차등급 2등급 이내',
      Col10: '해당없음',
      Col11: '1인당 3000000원 / 지급기간 1년 (휴학퇴학졸업 등 제외)',
      Col12: ' * 수석2022년도 대학교 입학예정자대학교 해당 학과 수석 입학',
      Col13: '공고일 현재 주민등록상 부 또는 모가 2년 이상 연속하여 경기도 광주시 내에서 거주하고 있는 광주시민의 자녀',
      Col14: '2022-03-21~2022-04-01',
      Col15: '해당없음',
      Col16: '15명',
      Col17: '만30세 이상원격대학(방송통신대학/ 사이버대학 등) 재학생학점 은행제 대학재학생직업전문학교 재학생평가 대상 학기 및 신청일 현재 교환학생평가 대상 각 학기 12학점 미만 이수자정규학기를 초과한 학생입학예정자 신청불가',
      Col18: '해당없음',
      Col19: '장학생 지원 신청서(반명함판 사진 부착)분야별 신청서 평가표(진학장학생은 제외)학생본인의 주민등록초본 1부(가족사항 및 주소이력 포함)주민등록등본 1부  재학증명서(※대학생에 한함)개인정보제공동의서*추가서류자기소개서수석 : 전체수석을 입증할 수 있는 입학성적 증명서다자녀  가족관계증명서 (부모 기준으로 발급)  생활기록부'
    },
    {
      Col1: '재단법인광주시민장학회',
      Col2: '예/체/기능/문학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1인당 3000000원 / 지급기간 1년 (휴학퇴학졸업 등 제외)',
      Col12: '2021년도 광역시/도 대회 3위 이상 입상한 대학생',
      Col13: '공고일 현재 주민등록상 부 또는 모가 2년 이상 연속하여 경기도 광주시 내에서 거주하고 있는 광주시민의 자녀',
      Col14: '2021-04-05~2021-04-16',
      Col15: '해당없음',
      Col16: '15명',
      Col17: '만30세 이상원격대학(방송통신대학/ 사이버대학 등) 재학생학점 은행제 대학재학생직업전문학교 재학생평가 대상 학기 및 신청일 현재 교환학생평가 대상 각 학기 12학점 미만 이수자정규학기를 초과한 학생입학예정자 신청불가',
      Col18: '해당없음',
      Col19: '장학생 지원신청서장학생 신청평가서자기소개서개인정보 수집/이용/제공 및 조회동의서 (학생기준 작성)주소이력을 포함한 주민등록 등본 또는 초본 (부모기준 발급)2020년도 해당 분야 상장 사본각종 가산점 관련 증명서류 (해당자)재학증명서(2019년 신입생은 입학증명서류 제출) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 광명시 인재육성재단',
      Col2: '희망장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 신입생은 고등학교 3학년 국/영/수 관련 전 과목 평균 60점 이내 이거나 대학수학능력시험 국/영/수 3개영역 평균 5등급이내재학생 : 직전 학기 C학점(4.5만점에 2.0)이상방송대학생 : 직전 학기 C학점 이상(신입생 제외)',
      Col10: '해당없음',
      Col11: '대학생 연간 1인당 50만원방송통신대 연간 1인당 20만원',
      Col12: '가정 형편이 어려운 복지사각지대에 있는 학생다양한 분야에서 꿈과 비전 등을 위해 노력하는 학생',
      Col13: '광명시에 주소를 두고 공고일 현재 연속하여 3년 이상 거주하고 있는 시민 또는 직계비속',
      Col14: '2022-03-23~2022-04-05',
      Col15: '서류 심사 (성적/ 거주기간/ 가세정도/ 미래비전기술서/ 자기소개서 등)',
      Col16: '대학생 150명방송통신대 5명',
      Col17: '사이버대학 및 전문학교/ 교환학생 제외',
      Col18: '해당없음',
      Col19: '체크리스트신청서신청서 서약서/ 개인정보 수집이용 제공 및 조회 동의서성적증명서주소 변동 사항이 표시된 신청자 본인 주민등록초본주민등록등본 또는 가족관계증명서부모 2020년 1월~12월 국민건강보험료 납부확인서부모 건강보험자격득실확인서고등학교 졸업증명서장학금 수혜(비수혜) 확인서 또는 2021년 1학기 등록금 납부고지서미래비전기술서자기소개서 * 자세한 내용은 첨부파일 참고'
    },
    {
      Col1: '경산시장학회',
      Col2: '진학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2년차부터는 직전학기 평점 C+ 이상',
      Col10: '대학교진학 기초수급자인 경우 학년별로 총 4회 지급 * 자세한 사항은 첨부파일 참고',
      Col11: '2000000원',
      Col12: '관내 고등학교 졸업자 중 서울대학교/ 연세대학교/ 고려대학교(본교에 한함)/ 카이스트/ 유니스트/ 포스텍/ 디지스트 입학생',
      Col13: '공고일 현재 지원대상자와 보호자가 계속해서 3년이상 경산시에 주민등록이 되어있는 내국인 및 공고일 현재 계속해서 1년이상 경산시에 외국인등록이 되어 있는 자  * 자세한 사항은 첨부자료 참고 필수',
      Col14: '2022-03-23~2022-04-05',
      Col15: '해당없음',
      Col16: '40명',
      Col17: '휴학생 지원 불가경산시장학회 직전년도 기 수혜자는 신청할 수 없음 ',
      Col18: '출신고교 학교장',
      Col19: '장학금 지원 신청서지원대상자 추천서재학증명서주민등록등본 또는 초본(신청자 본인과 보호자) (외국인의 경우 외국인등록증) * 주민등록 앞자리만 표시되도록 발급통장계좌 사본자기소개서(자유양식)개인정보제공·이용 동의서생계급여수급자 증명서(해당자에 한함)'
    },
    {
      Col1: '경산시장학회',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 B+이상',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '국내 대학 2/3/4학년 재학생으로 직전학기 성적 B+ 이상인 자',
      Col13: '공고일 현재 지원대상자와 보호자가 계속해서 3년이상 경산시에 주민등록이 되어있는 내국인 및 공고일 현재 계속해서 1년이상 경산시에 외국인등록이 되어 있는 자  * 자세한 사항은 첨부자료 참고 필수',
      Col14: '2022-03-23~2022-04-05',
      Col15: '해당없음',
      Col16: '40명명',
      Col17: '해당없음',
      Col18: '읍·면·동 장/ 학교장',
      Col19: '장학금 지원 신청서지원대상자 추천서재학증명서주민등록등본 또는 초본(신청자 본인과 보호자) ( 외국인의 경우 외국인 등록증) * 주민등록 앞자리만 표시되도록 발급통장계좌 사본자기소개서(자유양식)개인정보제공·이용 동의서성적증명서관내고교졸업증명서 또는 고졸검정고시 합격증 * 자세한 사항은 첨부자료 참고'
    },
    {
      Col1: '경산시장학회',
      Col2: '자립장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 C+이상인 자(대학교 2~4년에 한함)',
      Col10: '생계급여 의료급여 주거급여 교육급여 수급자 또는 지방세 20만원 이하 납부자의 보호자의 보호를 받는 자',
      Col11: '1000000원',
      Col12: '국내 대학 재학생 생계급여/ 의료급여/ 주거급여/ 교육급여 수급자 또는 지방세 20만원 이하 납부자의 보호자의 보호를 받는 자',
      Col13: '공고일 현재 지원대상자와 보호자가 계속해서 3년이상 경산시에 주민등록이 되어있는 내국인 및 공고일 현재 계속해서 1년이상 경산시에 외국인등록이 되어 있는 자  * 자세한 사항은 첨부자료 참고 필수',
      Col14: '2022-03-23~2022-04-05',
      Col15: '해당없음',
      Col16: '15명',
      Col17: '휴학생 지원 불가직전년도 기 수혜자자',
      Col18: '읍·면·동장 추천',
      Col19: '장학금 지원 신청서지원대상자 추천서재학증명서주민등록등본 또는 초본(신청자 본인과 보호자) (외국인의 경우 외국인 등록증) * 주민등록 앞자리만 표시되도록 발급통장계좌 사본자기소개서(자유양식)생계급여/ 의료급여/ 주거급여/ 교육급여 수급자 증명서 또는 지방세 20만원이하 증명서관내고교 졸업 증명서 또는 고졸검정고시 합격증개인정보제공·이용 동의서성적증명서(2~4학년에 한함)'
    },
    {
      Col1: '경산시장학회',
      Col2: '생계급여수급자대학진학장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전년도 학점이 C+ 이상인 자',
      Col10: '공고일 기준 생계급여 수급자인 자',
      Col11: '2000000원',
      Col12: '경산시장학회 장학생 선발 공통 및 진학장학금 기준에 부합하는자공고일 기준 생계급여 수급자인 자 ',
      Col13: '공고일 현재 계속해서 학생과 보호자가 3년이상 경산시에 주민등록이 되어있는 내국인 및 1년이상 경산시에 외국인등록이 되어 있는 자 * 자세한 사항은 첨부자료 참고 ',
      Col14: '2022-03-23~2022-04-05',
      Col15: '최초 신청하더라도 이듬해 장학금은 재신청하여야 수혜를 받을수 있음',
      Col16: '해당없음',
      Col17: '보호자와 본인 모두 주민등록이 경산시에 있지 아니할 경우생계급여 수급자 자격이 박탈된 경우전년도 평균 학점이 C+이상이 되지 않을 경우휴학한 경우(복학할 경우 재 지급함)제적/ 퇴학등의 불미스러운 사유가 있을 경우기타 장학금을 지급해서는 아니될 중대한 사유가 있어 이사회가 지급 중단을 의결할 때',
      Col18: '출신고교 학교장',
      Col19: '장학금 지원 신청서지원대상자 추천서재학 증명서주민등록본 또는 초본통장계좌 사본자기소개서개인정보제공·이용 동의서생계급여수급자 증명서 * 자세한 사항은 첨부자료 참고 '
    },
    {
      Col1: '경산시장학회',
      Col2: '외국인유학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/전문대학원/제한없음/학점은행제 대학/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '500000원',
      Col12: '경산시 관내 대학에 재학중인 외국인 유학생',
      Col13: '공고일 현재 계속해서 1년이상 경산시에 외국인등록이 되어 있는 자',
      Col14: '2021-03-15~2021-03-26',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '휴학생 지원 불가직전년도 기 수혜자',
      Col18: '총장 추천서',
      Col19: '장학금 지원 신청서지원대상자 추천서주민등록등본 또는 초본통장계좌 사본자기소개서개인정보제공·이용 동의서 * 자세한 사항은 기관 홈페이지 공고 및 첨부파일 참조'
    },
    {
      Col1: '경산시장학회',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/전문대(2~3년제)/제한없음/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '3자녀 이상 가정의 셋째 이상 학생',
      Col13: '공고일 현재 지원대상자와 보호자가 계속해서 3년이상 경산시에 주민등록이 되어있는 내국인 및 공고일 현재 계속해서 1년이상 경산시에 외국인등록이 되어 있는 자  * 자세한 사항은 첨부자료 참고 필수',
      Col14: '2022-03-23~2022-04-05',
      Col15: '해당없음',
      Col16: '2/100명 (초·중·고등학생 포함인원)',
      Col17: '해당없음',
      Col18: '읍·면·동장의 추천서 제출',
      Col19: '장학금 지원 신청서지원대상자 추천서재학증명서주민등록등본 또는 초본(신청자 본인과 보호자) * 주민등록 앞자리만 표시되도록 발급통장계좌 사본자기소개서(자유양식)개인정보제공·이용 동의서가족관계증명서(주민등록등본상 확인가능하면 생략)'
    },
    {
      Col1: '경산시장학회',
      Col2: '선행장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '지역과 사회에 선행을 행한 학생',
      Col13: '공고일 현재 지원대상자와 보호자가 계속해서 3년이상 경산시에 주민등록이 되어있는 내국인 및 공고일 현재 계속해서 1년이상 경산시에 외국인등록이 되어 있는 자  * 자세한 사항은 첨부자료 참고 필수',
      Col14: '2022-03-02~2022-03-31',
      Col15: '해당없음',
      Col16: '3명',
      Col17: '휴학생 지원 불가직전년도 기 수혜자',
      Col18: '읍·면·동장',
      Col19: '장학금 지원 신청서지원대상자 추천서재학증명서(대학생/ 근로자녀장학금/ 다자녀/ 선행)주민등록등본 또는 초본(신청자 본인과 보호자) * 주민등록 앞자리만 표시되도록 발급통장계좌 사본자기소개서(자유양식)공적조서 * 자세한 사항은 첨부파일 및 기관 홈페이지 참조'
    },
    {
      Col1: '여주시 인재육성장학회',
      Col2: '입학우수장학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 일반[4명(수능 2명/ 내신 2명)]수능 : 대학수학능력시험(2020년 12월) 성적 7등급 이내      * 국+영+수+탐구(중 3영역)≤7등급(합산 7등급)내신 : 고등학교 전 학년 내신 평균등급 2.5등급 이내 * 특기(1명) : 2021년도 광역자치단체(도) 단위 이상 공공기관이 주최(주관)하는 예술/ 체육/ 기능/ 문학 등의 대회(경연)에서 3위 이상 입상자로 학교장(대학교) 추천',
      Col10: '해당없음',
      Col11: '대학생 23년제 연간 : 3000000원대학생 4년제 연간 : 7000000원',
      Col12: '해당없음',
      Col13: '부모나 본인이 공고일현재 거주하고 있으며. 거주한 기간 합산이 총 3년 이상',
      Col14: '2022-03-02~2022-03-31',
      Col15: '해당없음',
      Col16: '9명',
      Col17: '대학생 장학금은 입학금+등록금 한도 내에서 타 장학금액 제외한 나머지 금액만 지급하여 이중지원을 제한장학금은 1세대당 1명에 한하여 지급함',
      Col18: '자립의 경우 고등학교장 추천',
      Col19: '장학금지원신청서  개인정보제공동의서주민등록초본가족관계증명서재학증명서성정 및 특기실적 증명서통장사본등록금납부확인서류'
    },
    {
      Col1: '여주시 인재육성장학회',
      Col2: '성적우수장학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '일반[18명(4년제 20명/ 2~3년제 3명)] : 직전학년 평균성적 3.5이상 (4.3만점인 경우 3.3이상)자립[7명(4년제 5명/ 2~3년제 2명)] : 생계곤란자 학생으로 직전학년 평균성적 3.5이상 (4.3만점인 경우 3.3이상)',
      Col10: '자립 :  생계곤란자 학생',
      Col11: '대학생 23년제 : 연간 3000000원대학생 4년제 : 연간 4000000원',
      Col12: '해당없음',
      Col13: '부모나 본인이 공고일현재 거주하고 있으며. 거주한 기간 합산이 총 3년 이상',
      Col14: '2022-09-05~2022-09-27',
      Col15: '해당없음',
      Col16: '30명',
      Col17: '입학금+등록금 한도 내에서 타 장학금액 제외한 나머지 금액만 지급하여 이중지원 제한 * 1세대당 1명에 한하여 지급',
      Col18: '단과대학장/ 총장 또는 그에 상응하는 직급의 장 추천 (해당자)',
      Col19: '장학금지원신청서개인정보제공동의서 주민등록초본가족관계증명서재학증명서성적 및 특기실적 증명서통장사본등록금납부확인서류 '
    },
    {
      Col1: '한국광산장학회',
      Col2: '우수장학생(성적우수자)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학점 3.5(4.5만점)이상 또는 수능 5과목 이상 평균 2등급 이내',
      Col10: '해당없음',
      Col11: '전문대: 1200000원종합대: 1500000원',
      Col12: '해당없음',
      Col13: '광산구에 주민등록을 두고 공고일 현재 2년 이상 계속 거주하고 있는 구민 또는 그 자녀 중 대학 재학생',
      Col14: '2022-09-05~2022-09-27',
      Col15: '성적: 100점 (대학 70 + 수능 30) * 자세한 사항은 첨부파일 참고',
      Col16: '전문대 : 4명종합대 : 33명',
      Col17: '1가구 1명만 신청할 수 있고/ 우수장학생과 일반장학생을 중복신청 불가국가/ 학교/ 단체/ 회사 등에서 등록금의 1/2이상 지원을 받는 자 제외',
      Col18: '해당없음',
      Col19: '장학생 지원신청서 개인정보 수집·이용·제공 및 조회동의서주민등록 초본가족관계증명서재학증명서성적증명서보통예금통장 사본신청인 서약서수능성적증명서장학금 수혜 확인서 * 자세한 사항은 첨부파일 또는 홈페이지 참고'
    },
    {
      Col1: '한국광산장학회',
      Col2: '일반장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학점3.0이상(4.5만점) 또는 수능 5과목 이상 평균 3등급이내',
      Col10: '신청자 직계가족의 6개월 평균 납입 국민건강보험료가 2020년도 기준 전국가구 중위소득 60% 이하인 2인 이상 가구',
      Col11: '전문대학: 1200000원종합대학: 1500000원',
      Col12: '신청자 직계가족의 6개월 평균 납입 국민건강보험료가 2020년도 기준 전국가구 중위소득 60% 이하인 2인 이상 가구',
      Col13: '광산구에 주민등록을 두고 공고일 현재 2년 이상 계속 거주하고 있는 구민 또는 그 자녀 중 대학 재학생',
      Col14: '2020-06-11~2020-06-26',
      Col15: ' 성적 50점 (대학40 + 수능10) + 소득 50점 * 자세한 사항은 첨부파일 또는 홈페이지 참고',
      Col16: '전문대학: 3명종합대학: 31명',
      Col17: '1가구 1명만 신청할 수 있고/ 우수장학생과 일반장학생을 중복신청 불가국가/ 학교/ 단체/ 회사 등에서 등록금의 1/2이상 지원을 받는 자 제외2020년도 휴학 예정인 자 제외반값등록금 정책이 적용되고 있는 대학의 학생은 신청대상에서 제외2020년도 [코로나19특별장학생]에 선발된 자 제외',
      Col18: '해당없음',
      Col19: '장학생 지원신청서 개인정보 수집·이용·제공 및 조회동의서주민등록 초본가족관계증명서재학증명서성적증명서보통예금통장 사본신청인 서약서수능성적증명서국민건강보험료 납부 확인서수급자증명서/ 차상위계층증명서 * 자세한 사항은 첨부파일 또는 홈페이지 참고'
    },
    {
      Col1: '한국광산장학회',
      Col2: '특별장학생(코로나19)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '소상공인 : 관내에 사업장을 두고 있으며 2019년 연매출액 1억원 이하농업인 : 광산구 소재 농지 등경작자 농업경영체 등록된 농업인아동복지시설 : 관내 아동복지시설 거주자다문화가정 : 국제결혼 가정으로 부모 중 한 쪽이 한국인인 가정',
      Col11: '1000000원',
      Col12: '광산구에 주민등록을 두고 공고일 현재 2년 이상 거주하고 있는 구민 또는 그 자녀로 소상공인/ 농업인/ 아동복지시설/ 다문화가정의 대학생 * 자세한 사항 첨부파일 참조',
      Col13: '광산구에 주민등록을 두고 공고일 현재 2년 이상 거주하고 있는 구민 또는 그 자녀',
      Col14: '2022-03-02~2022-03-18',
      Col15: '서류심사 ( * 한국장학재단 2020년 1학기 학자금 지원구간 값 낮은 순으로 선발)',
      Col16: '총 100명 ( * 소상공인 50명/ 농업인 37명/ 아동복지시설 10명/ 다문화가정 3명) ※ 선발인원은 내부 사정에 따라 조정될 수 있음',
      Col17: '전공대/ 대학원대/ 방송통신대/ 원격대/ 사이버대/ 기능대/ 평생교육원 재학생 선발 제외동일연도 내/ 광산장학회에서 지원하는 장학금 중복 지급 불가1세대 당 1명 지급',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보 수집·이용 동의서주민등록 초본 재학증명서보통예금통장 사본부모명의 가족관계증명서학자금 지원구간 통지서해당자 증빙서류 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '양주시 희망장학재단',
      Col2: '으뜸인재육성장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학수학능력시험 평가결과 및 고등학교 내신성적 우수자',
      Col10: '해당없음',
      Col11: '2500000원 (1학기 1000000원 2학기 1500000원 분할 지급)   (장학생 선발 후 학기별 성적이 3.0 미만 일 경우 장학생 자격취소)',
      Col12: '관내 고등학교 졸업자로 명문대학(서울대/ 카이스트/ 포항공대)에 입학한 자',
      Col13: '2020년 1월 1일부터 공고일 기준 주민등록상 양주시에 주소를 두고 거주하는 24세 이하 대학생',
      Col14: '2022-03-02~2022-03-18',
      Col15: '해당없음',
      Col16: '으뜸인재육성장학생 1명',
      Col17: '정규학기 외의 초과학기 학생조기졸업 및 한학기 수료 후 졸업예정자2022년 휴학 또는 입영예정자자',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서2022년 재학증명서고등학교 전학년 성적증명서 및 수학능력평가 성적표장학금 신청자 주민등록초본통장사본 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '양주시 희망장학재단',
      Col2: '성적우수장학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 : 택1수능 언어/ 수리/ 외국어 3개 영역 모두 2등급 이상인 자고등학교 3학년 내신이 1/2학기 국/영/수 과목 성취도 B점수 이상인 자실업계 고교 졸업자의 경우 1/2학기 전공과목 모두 B점수 이상인 자고졸 검정고시 출신 신입생의 경우 국/수/영 성적이 모두 90점 이상인 자 * 재학생2021년도 1학기 성적과 2학기 성적 모두 평점 4.5만점 기준 4.0학점 이상인 자복학생 및 교환학생은 최종직전 두개 학기 성적이 평점 4.5만점 기준 4.0학점 이상인 자 * 자세한 사항은 첨부파일 참고',
      Col10: '해당없음',
      Col11: '등록금 2500000원(12학기 분할지급)',
      Col12: '해당없음',
      Col13: '2020년 1월 1일부터 공고일 기준 주민등록상 양주시에 주소를 두고 거주하는 대학생   (단/ 원거리 학교생활을 위해 기숙사나 임대주택 등에 거주하고자 주소를 변경한 경우 거주요건 예외)',
      Col14: '2022-03-02~2022-03-18',
      Col15: '해당없음',
      Col16: '성적우수장학생 60명',
      Col17: '정규학기 외의 초과학기 학생조기졸업 및 한학기 수료 후 졸업예정자2022년 휴학 또는 입영예정자',
      Col18: '해당없음',
      Col19: '장학금 신청서신청자 주민등록등본 (최근 5년간 주소변동사항 포함)통장사본 2022 재학증명서직전학년 성적증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '양주시 희망장학재단',
      Col2: '면학장려장학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생 (택1)수능 언어/ 수리/ 외국어 3개 영역 모두 3등급 이상인 자고등학교 3학년 내신성적 1/2학기 국/영/수 과목 성취도 C점수 이상인 자실업계 고교 졸업자의 경우 1/2학기 전공과목 모두 C점수 이상인 자고졸 검정고시 출신 신입생의 경우 국/수/영 과목 성적이 모두 70점 이상인 자 * 재학생2021년도 1학기/ 2학기 성적이 모두 평점 4.5만점 기준 3.0학점 이상인 자복학생 및 교환학생은 최종직전 두개 학기 성적이 평점 4.5만점 기준 3.0학점 이상인 자',
      Col10: '학생가장 한부모 가정 장애등급 가산점 부여',
      Col11: '등록금 2500000원',
      Col12: '저소득층 가정의 대학생 또는 장애인(본인)인 대학생',
      Col13: '2020년 1월 1일부터 공고일 기준 주민등록상 양주시에 주소를 두고 거주하는 24세 이하 대학생',
      Col14: '2022-03-02~2022-03-18',
      Col15: '해당없음',
      Col16: '면학장려장학생 15명',
      Col17: '정규학기 외의 초과학기 학생조기졸업 및 한학기 수료 후 졸업예정자2022년 휴학 또는 입영예정자',
      Col18: '해당없음',
      Col19: '장학금 신청서신청자 주민등록등본 (최근 5년간 주소변동사항 포함)타 장학금 수혜(비수혜)확인서통장사본 2022 재학증명서직전학년 성적증명서 원본보호자의 재산제 과세증명서 원본(부/모 모두)국민건강보험료 납부영수증 사본(최근 3개월 납부분)국민건강보험증 사본(세대원 모두 제출)장애인증명서/ 각종 수급자증명서 사본(해당자)가족관계증명서 원본(보호자 기준)자기소개서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '양주시 희망장학재단',
      Col2: '특기장학생장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '논술/ 외국어/ 수학/ 과학분야 등 도단위 대회 3위 이내 입상자예능분야 : 도단위 대회 3위 이내 입상자각 대회별 수상실적에 따른 가산점 부여',
      Col10: '해당없음',
      Col11: '대학생 2500000원 (12학기 분할지급) * 생활비지원으로 국가장학금 교내장학금 등과 중복 가능함',
      Col12: ' * 국어/ 외국어/ 수학/ 과학 및 예능 등 교육과정 전반에 관련한 분야별 재능이 뛰어난 자 (체육특기생 제외)',
      Col13: '2020년 1월 1일부터 공고일 기준 주민등록상 양주시에 주소를 두고 거주하는 학생  * 단/ 원거리 학교생활을 위해 기숙사나 임대주택 등에 거주하는 경우에 한해서 공통사항을 예외로 함',
      Col14: '2022-03-02~2022-03-25',
      Col15: '해당없음',
      Col16: '특기장학생 4명',
      Col17: '정규학기 외의 초과학기 학생조기졸업 및 한학기 수료 후 졸업예정자2022년 휴학 또는 입영예정자',
      Col18: '소속 학교장 (총장/대학장)',
      Col19: '장학금 지원 신청서신청자 주민등록등본 (최근 5년간 주소변동사항 포함)타 장학금 수혜(비수혜)확인서통장사본 2022 재학증명서입상을 확인할 수 있는 상장 및 증명서 사본장학생 추천서 (소속 학교(총)장 직인) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재)달성장학재단',
      Col2: '일반장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '재학생 : 직전학기 평점 평균성적이 2.8이상인 자신입생 : 대학수학능력시험 평균 성적이 5등급 이내인자',
      Col10: '경제적 이유로 수학이 곤란한 자 ',
      Col11: '3000000원 한도',
      Col12: '대학교 재학생과 입학예정자 학업성적이 우수한 자 이사회에서 장학금을 지급하기로 결정된 자 ',
      Col13: '달성군에 등록기준지 또는 주소를 2년 이상 계속 두고 있는 군민 또는 그의 자녀',
      Col14: '2022-03-02~2022-03-25',
      Col15: '해당없음',
      Col16: '121명 (신입생 31명/ 재학생 90명)',
      Col17: '대학생 : 타 장학금 수혜자(2/000천원 이상 또는 등록금 전액) 읍/면장학회 장학금 선발자2022년도 2월 졸업예정자/ 유학중인자 * 대학생은 2022년도 타 장학금 수혜자 또는 감면2/000천원 미만자는 신청가능하나/ 타 수혜금액을 공제한 차액지급',
      Col18: ' * 학교장 추천서 작성시신입생 : 졸업예정학교장 또는 입학예정학교장 모두 가능대학교 : 총장 또는 학과장 모두 가능',
      Col19: '장학생 선발신청서읍/면장 추천서학교장추천서주민등록등/초본        개인(신용)정보 수집/이용/제공 및 조회 동의서신청인 서약서   건강보험료 납부증명서(2020년 12월분/ 부/모 모두)/전국단위 지방세 세목별 과세 증명서(부/모 모두/ 2020년 7/9월 토지/ 건축물/ 주택분) * 대학교신입생수능성적표/ 등록금고지서 및 교육비납입증명서(20211학기) * 대학생성적증명서(20202학기)/ 등록금고지서 및 교육비납입증명서(20211학기)'
    },
    {
      Col1: '(재)달성장학재단',
      Col2: '특별장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '성적우수 :5000000원다자녀 : 3000000원진학(고1) : 1000000원 ',
      Col12: '2022학년도 대학수학능력시험 우수자서울대학교 기회균형선발특별전형 사범대학 합격자다자녀가구의 셋째이상의 자녀',
      Col13: '달성군에 등록기준지 또는 주소를 2년 이상 계속 두고 있는 군민과 그의 자녀대구광역시 소재 고등학교 졸업자 중 4년제 대학 입학생',
      Col14: '2022-05-02~2022-05-09',
      Col15: '해당없음',
      Col16: '19명(수능우수 4/ 다자녀5/ 진학(고1)10)',
      Col17: '대학생 : 타 장학금 수혜자(2/000천원 이상 또는 등록금 전액) 읍/면장학회 장학금 선발자2022년도 2월 졸업예정자/ 유학중인자  * 대학생은 2020년도 타 장학금 수혜자 또는 감면 2/000천원 미만자는 신청이 가능하나/ 타 수혜금액을 공제한 차액 지급',
      Col18: '신입생 : 졸업예정학교장 또는 입학예정학교장 모두 가능대학교 : 총장 또는 학과장 모두 가능',
      Col19: '장학생 선발신청서읍/면장 추천서학교장추천서주민등록등/초본        개인(신용)정보 수집/이용/제공 및 조회 동의서신청인 서약서   건강보험료 납부증명서(2021년 12월분/ 부/모 모두)/전국단위 지방세 세목별 과세 증명서(부/모 모두/ 2020년 7/9월 토지/ 건축물/ 주택분) * 특별장학생 수능성적우수 : 수능성적표/ 등록금고지서 및 교육비납입증명서다자녀가정의 자녀 : 가족관계증명서 (부 또는 모의가족관계증명서)/ 수능성적표/ 등록금고지서 및 교육비납입증명서'
    },
    {
      Col1: '홍성사랑장학회',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(신입생) 대학 수학 능력 시험에서 2등급 이내가 2개 영역이상이고/ 전체평균 3등급 이내로 대학에 합격한 자(기 장학생 중 재학생) 성적우수 장학생으로 최근 3년간 기 선발된 자 중 직전 학년 성적이 평균 B+ 학점 이상인 자(일반재학생) 직전 학년 성적이 평균 B+ 학점 이상인 자',
      Col10: '해당없음',
      Col11: '최대 3000000원',
      Col12: '홍성군에 1년 이상 주민등록을 둔 대학교 입학·재학생 중 성적 우수자 * 일반 재학생 선발의 경우 수도권 지역 대학 10명/ 그 외 지역대학 10명 선발  * 자세한 사항은 첨부파일 참고',
      Col13: '공고일 이전부터 계속하여 홍성군에 1년 이상 주민등록을 둔 학생 또는 군민의 자녀 * 지역대학 외국인 학생은 홍성군에 거주지를 등록한 자',
      Col14: '2022-05-02~2022-05-09',
      Col15: '서류전형 및 홍성사랑장학회 장학생선발심의회 심의를 거쳐 선발',
      Col16: '(신입생) 10명(기 장학생 중 재학생) 6명(일반재학생) 20명 ',
      Col17: '등록금 전액 면제자2022년도 타 기관에서 등록금 이상의 장학금을 받은 경우단과대 학장 추천서 제출 불가 * 자세한 사항은 첨부파일 참고',
      Col18: '총·학장 추천서',
      Col19: '학교장(총·학장·총학생회장) 추천서성적증명서(입학성적확인서/대학입학수학능력시험 성적표 원본 등 성적 증빙자료)주민등록초본(주소이력사항 포함)부·모의 2021년 건강보험료 납부확인서기타 증빙서류(해당자)재학증명서/ 교육비납입증명서 * 자세한 사항은 첨부파일 참조'
    },
    {
      Col1: '홍성사랑장학회',
      Col2: '복지장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/원격대학/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '(신입생) 대학수학능력시험에서 전체평균 5등급 이내로 대학에 합격한 자 * 수시 합격자는 직전학년 내신 등급이 전체평균 5등급 이내인 자(재학생) 직전학년 성적이 C학점(2.0) 이상인 자',
      Col10: '국민기초생활보장수급자 차상위계층 한부모가정',
      Col11: '최대 3000000원 * 예산 범위 내 (잔액 내)',
      Col12: '성적요건을 만족하는 저소득 계층 대학 입학·재학자 * 복지장학생(1순위)는 예산잔액 발생시 추가선발됩니다.',
      Col13: '공고일 이전부터 계속하여 홍성군에 1년 이상 주민등록을 둔 학생 또는 군민의 자녀 (기준일 : 선발요강 공고일 현재)',
      Col14: '2022-05-02~2022-05-09',
      Col15: '서류전형 및 홍성사랑장학회 장학생선발심의회 심의를 거쳐 선발',
      Col16: '3명 이내',
      Col17: '등록금 전액 면제자2022년도 타기관에서 등록금 이상의 장학금을 받은 경우 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '학교장(총·학장·총학생회장) 추천서성적증명서(입학성적확인서/대학입학수학능력시험 성적표 원본 등 성적 증빙자료)주민등록초본(주소이력사항 포함)복지장학생 수급자증명서/ 차상위계층확인서/ 한부모가정증명서기타 증빙서류(해당자)재학증명서/ 교육비납입증명서 * 자세한 사항은 첨부파일 참고고'
    },
    {
      Col1: '홍성사랑장학회',
      Col2: '지역대학생(외국인)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/기술대학/원격대학/일반대학원/전문대(2~3년제)/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '[지역대학생:신입생] 중간고사(평균학점 2.75점 이상)/ 또는 입학성적이 상위 20% 이내인 자[지역대학생:재학생] 평균학점 2.75 이상인 자',
      Col10: '해당없음',
      Col11: '[지역대학생] 최대 3000000원[지역대학생(외국인)] 1000000원',
      Col12: '[지역대학생] 홍성군내 소재 대학에 재학 중으로 성적이 우수하여 총장이 추천한 학생[지역대학생(외국인)] 홍성군내 소재 대학에 재학 중인 외국인으로 성적이 우수하여 총장이 추천한 학생  * 자세한 사항은 첨부파일 참고',
      Col13: '공고일 이전부터 계속하여 홍성군에 1년 이상 주민등록을 둔 학생 또는 군민의 자녀 (기준일 : 선발요강 공고일 현재)',
      Col14: '2022-05-02~2022-05-09',
      Col15: '서류전형 및 홍성사랑장학회 장학생선발심의회 심의를 거쳐 선발',
      Col16: '[지역대학생] 19명[지역대학생(외국인)] 6명',
      Col17: '등록금 전액 면제자2022년도 타기관에서 등록금 이상의 장학금을 받은 경우단과대 학장 추천서 신청불가 * 자세한 사항은 첨부파일 참조',
      Col18: '총(학)장 추천',
      Col19: '학교장(총·학장·총학생회장) 추천서성적증명서(입학성적확인서/대학입학수학능력시험 성적표 원본 등 성적 증빙자료)주민등록초본(주소이력사항 포함) * 외국인의 경우 외국인 등록사실 증명원 1부부·모의 2021년 건강보험료 납부확인서기타 증빙서류(해당자)재학증명서/ 교육비납입증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '홍성사랑장학회',
      Col2: '특기장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)/학점은행제 대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년의 도단위 이상 예체능 대회에서 3위 이내 입상한 특기생중 성적 우수자',
      Col10: '해당없음',
      Col11: '최대 3000000원',
      Col12: '직전학년의 도단위 이상 예체능 대회에서 3위 이내 입상한 특기생중 성적 우수자 * 모집인원 미달시 전국단위 이상 예체능대회에서 1위 입상한 자 또는 단체 선발가능',
      Col13: '공고일 이전부터 계속하여 홍성군에 1년 이상 주민등록을 둔 학생 또는 군민의 자녀 (기준일 : 선발요강 공고일 현재)',
      Col14: '2022-05-02~2022-05-09',
      Col15: '서류전형 및 홍성사랑장학회 장학생선발심의회 심의를 거쳐 선발',
      Col16: '2명',
      Col17: '등록금 전액 면제자2022년도 타기관에서 등록금 이상의 장학금을 받은 경우 * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: '학교장(총·학장·총학생회장) 추천서각종 특기 관련 수상 증빙 자료주민등록초본(주소이력사항 포함)부·모의 2021년 건강보험료 납부확인서기타 증빙서류(해당자)재학증명서/ 교육비납입증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '홍성사랑장학회',
      Col2: '성적우수장학생(다자녀)',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/원격대학/전문대(2~3년제)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학년 성적이 B+ 이상인 자',
      Col10: '해당없음',
      Col11: '최대 3000000원',
      Col12: '다자녀(3자녀) 학생으로 직전학년 성적이 B+학점이상으로 성적이 우수한 자',
      Col13: '공고일 이전부터 계속하여 홍성군에 1년 이상 주민등록을 둔 학생 또는 군민의 자녀',
      Col14: '2022-02-14~2022-03-07',
      Col15: '서류전형 및 홍성사랑장학회 장학생선발심의회 심의를 거쳐 선발',
      Col16: '4명',
      Col17: '등록금 전액 면제자2022년도 타기관에서 등록금 이상의 장학금을 받은 경우 * 자세한 사항은 첨부파일 참고고',
      Col18: '학교장(총·학장/총학생회장) 추천 필요 * 단과대 학장 추천 불가 * 자세한 사항은 첨부파일 참고',
      Col19: '학교장(총·학장·총학생회장) 추천서성적증명서(입학성적확인서/대학입학수학능력시험 성적표 원본 등 성적 증빙자료)주민등록초본(주소이력사항 포함)부·모의 2021년 건강보험료 납부확인서기타 증빙서류(해당자)재학증명서/ 교육비납입증명서 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '울산광역시 남구장학재단',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생고등학교 3학년 1학기/ 2학기 평균 성적이 90점 이상인자 * 재학생 전학기 1학기/ 2학기 성적 평점평균 4.5만점인 경우 4.0점이상 (4.3만점인 경우 3.7점이상)인자학기당 12학점 이상 이수자(계절학기 미 포함)',
      Col10: '해당없음',
      Col11: '1인당 5000000원 (2회 분할지급)',
      Col12: '자원봉사 시간에 따른 가점 기준 있음',
      Col13: '공고일 현재 본인 또는 부모가 울산 남구에 1년 이상 거주초/ 중/ 고 중 한 개 학교를 울산남구 소재 학교에서 졸업한 학생(초/중/고 중 한 개 이상)',
      Col14: '2022-02-14~2022-03-07',
      Col15: '성적 70점 + 가정형편 30점 * 자세한 산정 점수 첨부파일 확인 바람',
      Col16: '36명',
      Col17: '본 재단의 장학금은 한국장학재단의 장학금 및 기타 장학금과 중복수혜(중복지원)시 일부 또는 전액 환수 될 수 있습니다.1세대 1명만 신청이 가능',
      Col18: '전(前 )담당(지도)교수 또는 담당교사',
      Col19: '장학금 지원 신청서장학생 추천서(전(前 )담당교수 작성 밀봉후 제출)주민등록등본(주소변동사항 기재) 1부 (공고일 이후 발급분) 개인(신용)정보 수집 이용 제공 및 조회 동의서학생명의 보통예금통장사본(장학금 지원 신청서에 기재한 계좌)자원봉사 활동 확인서 (해당자)가족관계증명서 (해당자)서약서등록금 납입영수증재학증명서성적증명서(전과목 표기)<신입생>고등학교 학교생활기록부(성적포함)재산세(미)과세 증명서 건강보험 납부확인서 또는 자격득실확인서 *  제출하는 각종 증명서의 주민등록번호 뒷자리는 지워서 제출 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '울산광역시 남구장학재단',
      Col2: '희망장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생고등학교 3학년 1학기/ 2학기 평균 성적이 70점 이상인자 * 재학생 전학기 1학기/ 2학기 성적 평점평균 4.5만점인 경우 3.0점이상 (4.3만점인 경우 2.7점이상)인자학기당 12학점 이상 이수자(계절학기 미 포함)',
      Col10: '기초생활 수급자 또는 차상위 계층',
      Col11: '5000000원(전/후반기 분할지급)',
      Col12: '자원봉사 시간에 따른 가점 기준 있음',
      Col13: '공고일 현재 본인 또는 부모가 울산 남구에 1년 이상 거주초/ 중/ 고 중 한 개 학교를 울산남구 소재 학교에서 졸업한 학생(초/중/고 중 한 개 이상)',
      Col14: '2022-03-02~2022-03-25',
      Col15: '성적 70점 + 가정형편 30점 * 자세한 산정 점수 첨부파일 확인 바람',
      Col16: '25명 * 희망(저소득)장학생은 전체선발인원 중 40%이내 선발예정이며/ 최종 선발인원은 접수인원에 따라 변경될 수 있음',
      Col17: '본 재단의 장학금은 한국장학재단의 장학금 및 기타 장학금과 중복수혜(중복지원)시 일부 또는 전액 환수될 수 있습니다.1세대 1명만 신청이 가능',
      Col18: '전(前 )담당(지도)교수 또는 담당교사',
      Col19: '장학금 지원 신청서장학생 추천서(전(前 )담당교수 작성 밀봉후 제출)주민등록등본(주소변동사항 기재) 1부 (공고일 이후 발급분) 개인(신용)정보 수집 이용 제공 및 조회 동의서학생명의 보통예금통장사본(장학금 지원 신청서에 기재한 계좌)자원봉사 활동 확인서 (해당자)가족관계증명서 (해당자)서약서등록금 납입영수증재학증명서성적증명서(전과목 표기)<신입생>고등학교 학교생활기록부(성적포함)기초생활 수급자 증명서 또는 차상위 계층 증명서 * 제출하는 각종 증명서의 주민등록번호 뒷자리는 지워서 제출 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '(재) 창원시장학회',
      Col2: '성적우수장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전년도(2021)학년 평균 학점이 3.5 이상인 자 (성적우선)',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '창원시 소재 고등학교 출신자 중/ 국내 대학 재학생전년도(2021)학년 평균 학점이 3.5 이상인 자 (성적우선)',
      Col13: '공고일 기준 본인과 부모님이 창원시에 주소가 등록된 자창원시 소재 고등학교 출신자',
      Col14: '2021-12-20~2022-02-04',
      Col15: '성적 75점/ 생활정도 5점/ 타장학금 10점',
      Col16: '85명',
      Col17: '타 장학금 400만원 이상인 자한 학기 이수학점이 12학점 미만한 학기 패스 점수는 인정하지 않음방송통신고 졸업자/ 검정고시 출신자/ 무시험 대학입학자휴학생/ 대학원생이나 해외 유학쟁 제외',
      Col18: '해당없음',
      Col19: '장학금 지원 신청서재학증명서성적증명서(자세한 사항 첨부파일 참고)주민등록등본(부모님 창원 거주지 주소 등본)가족관계증명서 (다자녀 신청자에 한함)부모 명의의 통장사본타 장학금 수혜여부 확인서 기초생활수급/ 차상위/ 기타 소외계층 대상자는 증명서개인정보 동의서한국장학재단 소득분위표 1부 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '국립국제교육원',
      Col2: '중국정부초청장학생',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원/전문대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '석사과정 : 학부과정 평균 80점 이상박사과정 : 학부 및 석사과정별 평균 80점 이상 * 공통 : 신HSK 5급 210이상을 취득한 자',
      Col10: '해당없음',
      Col11: '학비면제 종합의료보험 지원 등생활비 : 석사과정 월 3000위안 박사과정 월 3500위안  * 기타 : 기숙사는 단위 대학별 사정에 따라 다르며 항공료는 개인부담',
      Col12: '대학원(석사 또는 박사)과정취득한 학위의 전고왁 밀접한 관련이 있는 전공/계열로 지원중국정부장학금을 받은적이 없는자(어학연수제외) * 한국사 능력 검정시험 3급 이상자 우대',
      Col13: '한국국적자',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '27명/ 예비후보 3명 별도',
      Col17: '지원자격상의 학위가 없는 자 (학위취득예정자 포함)중국소재 대학/ 대학원석/박사 과정 재학 중인 자(휴학포함)중국 및 외국소재 대학/ 대학원석/박사과정을 수료한 자금년도 대만정부초청장학생 지원자(즉/ 같은해 대만과 중국 이중지원 불가)',
      Col18: '해당없음',
      Col19: ' * 신청 홈페이지 주소 : www.csc.edu.cn/laihua * 온라인지원(관련자료 업로드)완료 후 자료 이메일 송부중국정부초청 장학생 지원서 A학업(연구)계획서중국 정부 초청 장학생 지원자 명단 엑셀 양식중국 정부 초청 온라인 지원서B(영어 또는 중문)공증받은 최종 학교 졸업증명서 또는 학위취득증명서공증받은 대학(원) 성적증명서추천서 2부(2명)신HSK 증서공인영어성적표여권사본한국사 능력 검정시험 성적표(해당자)음악 또는 미술작품 파일(해당자)(예비)입학 확인서외국인 신체검사서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고 '
    },
    {
      Col1: '국립국제교육원',
      Col2: '핀란드정부초청장학생',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원',
      Col7: '박사과정',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '생활비 : 매월 1500유로 (3~9개월)',
      Col12: '대한민국 국적자로서 건강/병역 등 해외유학에 결격사유 없는 자석사학위 소지자 * 핀란드 소재 대학원 또는 고등교육/연구기관으로부터 다음 자격으로 초청장 또는 추천을 받은자  대학원 박사과정 입학생  연구생 혹은 대학상사로 초청받은 경우대학원 수학/연구 수행에 필요한 충분한 언어능력을 입증할 수 있는 자',
      Col13: '해당없음',
      Col14: '2022-02-03~2022-03-31',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '장학금 기간이 시작되는 시점을 기준으로 핀란드 대학원/연구기관에 1년이상 체류한 경력이 있으면 지원할 수 없음',
      Col18: '해당없음',
      Col19: '20202021 핀란드 정부초청 장학생 명단Application form : 지원서 작성 후 출력/ 서명이력서(영문)학위증 사본(영어/ 핀란드어/ 스웨덴어 외 언어는 번역 공증)석사과정 전과정 성적증명서(영문)지도교수 2명의 추천서(영문)수학/연구계획서(2~5쪽/ 영문)핀란드의 대학/ 고등교육 연구기관/ 지도교수 등의 초청장TOEFL/ IELTS 어학증명서(최근 2년 이내 성적만 유효)핀란드어/ 스웨덴어 증명서 (해당자에 한함) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '국립국제교육원',
      Col2: '대만 화어문장학생',
      Col3: '관계부처',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '매월 NT$25000 ※ 수업료 기타 납입금 숙식비 보험료를 비롯한 기타 경비를 포함한 금액 * 장학 수혜기간2022년 9월 1일(목) ~ 2023년 2월 28일(화) (6개월)',
      Col12: '만 18세 이상으로 신청일 당시 한국 소재 대학에 재학 중인 자로서 학업성적이 우수하고 품행이 단정한 대한민국 국적 대학생',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '12명 ',
      Col17: '대만 국적 소유자 또는 화교 신분현재 대만에서 화어문(중국어) 어학연수 중인 자과거 대만에서 학위 과정을 수학한 자과거 화어문장학금 도는 대만장학금 수혜 이력이 있는 자수혜기간 동안 대만 소재 대학과 해외 대학 간의 학술협력협정 등에 의거하여 모집된 교환학생 신분인 자 * 자세한 사항은 첨부파일 참고',
      Col18: '재학하는 학교의 추천 필요',
      Col19: '지원서 및 재학 대학 동의서화어문장학금 신청서재학증명서(영문)성적증명서(영문)여권 사본 DB 엑셀 파일개인정보 수집·이용 및 제3자 제공동의서 * 파일 혹은 스캔하여 압축 파일로 공문 송부 / 자세한 사항은 첨부파일 참고 '
    },
    {
      Col1: '아셈듀오장학재단',
      Col2: '듀오코리아장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '최대 4개월(1학기)교류시 1인당 4000유로 지원(1000유로/1월) * 교류기간이 4개월보다 줄어든 경우 줄어든 기간과 비례하여 줄어든 장학금을 지원함',
      Col12: '교류를 원하는 한국과 유럽교육기관 사이에 교류협정을 체결해야 함한국의 교육기관이 교류예정자(한국국적학생)을 미리 선정하고/ 교류에 대해 유럽교육기관이 사전에 동의해야 함교류예정자를 미리 선정하고/ 양측 교육기관이 해당 교류예정자들의 맞교환에 합의한 경우',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '듀오코리아 2021 장학생은 대한민국 교육부에서 위촉한 국내외 인적 교류관련 인사들로 구성된 선정위원회에서 선발2022년 가을 교류 예정 지원서에 선정 우선권 부여아셈 듀오 프로그램으로 지원 받은 적 없는 대학 (신규 프로젝트) 지원서에 선정 우선권 부여 * 자세한 사항은 첨부파일 참고',
      Col16: '100명 내외(한국 학생/유럽학생 1조(2명) 기준 50조 내외 선발)',
      Col17: '듀오코리아 2021 지원 기간 이전에 이미 한국 학생이 해외로 출국해 있거나 유럽학생이 한국에 체류중인 경우 지원할 수 없음지원기간 이전에 이미 상대 교육기관에서 교류를 시작하고 교류중인 학생은 지원불가신청학점이 어학/스포츠 과목제외 10학점(20ECTS)미만신청서에 기재한 학점이 선정 후 제출하는 성적표의 학점과 다른경우',
      Col18: '대학추천',
      Col19: '* 한국대학의 국제교류담당자 및 관련부서담당자를 통하여 듀오코리아 장학금을 신청온라인신청서(한국대학담당자만 온라인 작성가능)교류협정서여권사본성적표지원동기서 * 자세한사항은 첨부자료 참고 필수'
    },
    {
      Col1: '아셈듀오장학재단',
      Col2: '듀오스웨덴장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '한 학기(4개월) 교류 시 1인당 3500유로 지급',
      Col12: '대학학기 규정이 최소 24ETCS/16주인 과정부터 지원가능스웨덴 대학(원)생(EU국적) + 국내 대학(원)생(아시아국적) 2인 1조대학 간 교류 협정 체결 필수',
      Col13: '해당없음',
      Col14: '2022-04-05~2022-05-31',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '교류기간동안 학교에 등록이 되있어야 함1학기 미만의 교류는 허용되지 않음',
      Col18: '해당없음',
      Col19: '지원자의 여권 사본지원서유효한 교류협정서영문 성적표(2021년도 가을학기 성적 포함) * 온라인접수 * 자세한 사항은 첨부자료 및 홈페이지 참고'
    },
    {
      Col1: '한미교육위원단',
      Col2: '대학원장학프로그램',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '일반대학원/전문대학원/해외대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전 학년 학부 평균학점 3.375/4.5 이상인 자 (3.0/4.0/ 3.225/4.3)일정한 수준의 영어실력을 갖춘 지원자 (영문학과 언어학 전공자 : TOEFL  IBT 100점/ IELTS 7점이상/ 그 외의 분야는 TOEFL IBT 88점/ IELTS 6.5점 이상) * 자세한 사항은 홈페이지 공고 참고',
      Col10: '해당없음',
      Col11: '학비 및 생활비 * 1년차 최대 $40000 * 2년차 최대 $40000 * 생활비: 월 $1300$2410 지급 ※ 자세한 사항은 홈페이지 공고 참고',
      Col12: ' 합격자 오리엔테이션부터 장학금 개시시점인 2023년 8월까지 한국에 거주할 수 있는 지원자남성의 경우 군복무를 필하거나 면제를 받은 자4년제 대학 기졸업자 또는 2023년 2월 졸업예정자 * 자세한 사항은 홈페이지 공고 참고',
      Col13: '대한민국 국민으로 미국 이중국적자 혹은 미국영주권 소유자가 아닌 지원자',
      Col14: '2022-05-03~2022-07-15',
      Col15: '서류전형서류 전형 합격자에 한 해 영어면접 실시',
      Col16: 'OO명',
      Col17: '한미교육위원단/ 미대사관/ 미국무부 직원 및 직계가족족과거 5년 동안 미국 정부 장학금을 수혜한 경험이 있는 자지원하는 학위 과정과 동일한 과정을 한국 및 외국대학에서 2학기 초과 이수한 자최근 6년간 미국에 5년 이상 연속적으로 체류한 자 * 자세한 사항은  홈페이지 공고 참고',
      Col18: '해당없음',
      Col19: '폴브라이트 온라인 지원서 및 한미교육위원단 지원서영문 성적증명서영문 추천서영문 재학/졸업/재적증명서영어 성적 증명서(택1)영문 포트폴리오 4세트(해당자)재직 증빙서류(해당자)북한이탈주민등등록확인서(해당자)국영문 병기 출입국 사실증명서 Department of Homeland Security Arrival and Departure Date Record  * 자세한 사항은 홈페이지 공고 참고'
    },
    {
      Col1: '영국문화원',
      Col2: 'IELTS Prize 장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '올해 국내외 대학에서 학부 혹은 대학원 학위 과정을 시작하고/ 입학요건으로 IELTS 점수를 인정하는 고등교육기관에 진학할 예정인 학생',
      Col13: '해당없음',
      Col14: '2022-06-07~2022-07-06',
      Col15: '서류심사면접',
      Col16: '3명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '온라인 신청지원 학교의 합격 증명서 사본IELTS 시험 성적표 사본 *  IELTS 인정학교 리스트에 없는 대학/대학원의 경우:     입학담당자의 IELTS점수 인정확인서 필요'
    },
    {
      Col1: '한국백혈병어린이재단',
      Col2: '희망장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)/전문대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '대학(원)등록금 및 취업기술교육비 : 2000000원',
      Col12: ' * 19세 이하에 소아암 및 이에 준하는 희귀난치성질환을 진단받고 치료를 종결한 자로서대학(원)에 재학중인 자취업기술교육을 받고 있거나 예정인 자 * 기존 희망장학금 선정자는 신청할 수 없음',
      Col13: '해당없음',
      Col14: '2022-03-25~2022-04-15',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '기존 희망장학금 선정자와 유관기관 장학금을 당해연도에 지원받은 자는 신청 불가휴학 또는 등록을 포기한 자재단의 승인없이 장학금 전달식에 불참할 경우 선발 취소제출서류를 미제출 한 자',
      Col18: '해당없음',
      Col19: ' * 이메일 접수로 아래 세가지 서류를 모두 접수해야함 [ 1차 접수 서류 ] 희망장학금 신청서대학(원) 재학증명서 또는 기술교육 이력 증빙서류주제('
    },
    {
      Col1: '현대차 정몽구 재단',
      Col2: '문화예술인재학부장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학신입생',
      Col8: '예체능계열',
      Col9: '해당없음',
      Col10: '소득기준 중위소득 150%이하인 가구의 자녀 * 재단 선발기준 홈페이지 참조',
      Col11: '등록금 전액 및 학습지원 1800000원(학기)해외 문화예술 국제대회 참가비 지원해외 우수 대학 및 연주단체 진출 장학생 체재비 지원마스터 클래스 및 연주 기회 제공(온드림 앙상블)여름캠프 학술세미나 우수활동 장학생 시상 등',
      Col12: '학부 1/2/3학년문화예술 전공 국내 대학 재학생 및 휴학생생',
      Col13: '해당없음',
      Col14: '2022-04-12~2022-05-03',
      Col15: '1차 : 서류심사2차 : 오디션심사',
      Col16: '20명',
      Col17: '해당 전공자 외 지원불가',
      Col18: '해당없음',
      Col19: '자기소개서 및 소득수준 심사 증빙서류최근 3개월 이내내 연주영상(10분이내) * 사이트 내에서 지원'
    },
    {
      Col1: '현대차 정몽구 재단',
      Col2: '미래산업 인재 대학원 장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '전체학기 3.7/4.5 / 3.5/4.3 이상 * 신입생 : 학부/ 석사 졸업 평점 * 재학생 : 재학 전체 평점영어성적 : TOEIC 850점 또는  TOEIC Speaking 150점 또는 OPIc IM3 또는 이에 준하는 공인인증 영어성적',
      Col10: '가구 중위소득 150% 이하 (한국장학재단 소득구간: 7구간 이하)',
      Col11: '등록금 전액 및 학습지원비 1800000원(학기)국제 학술대회 장학금해외 진출 장학생 장학금온드림 글로벌 우수 장학금재단 장학생 네트워킹 프로그램',
      Col12: '재단 지정대학 석사/박사/석박사 통합과정 신입생 및 재학생 (※ 지정대학 목록은 홈페이지 참고)전일제 미취업 일반 대학원생(특수 및 전문대학원 제외)만 지원가능선발분야 : 지능정보기술 / 바이오헬스 / 에너지 신산업 * 자세한 사항 홈페이지 참고 필수',
      Col13: '해당없음',
      Col14: '2022-02-07~2022-02-28',
      Col15: '서류심사온라인 인적성 검사전공 면접(1차 합격자만 해당)인성 면접(2차 합격자만 해당)',
      Col16: '해당없음',
      Col17: '당해학기 기준 마지막 학기 재학생 제외* 자세한 사항은 홈페이지 참고',
      Col18: '지도교수의 추천 필요',
      Col19: '지원서/자기소개서가족관계증명서소득수준 심사 증빙서류성적증명서어학성적증명서학업/연구계획서 교수추천서실적 증빙 자료 '
    },
    {
      Col1: '재단법인 화원장학회',
      Col2: '장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '1. 재학생 직전학기 성적이 2.8(4.5기준) 이상인 자 2. 신입생대학수학능력시험 평균성적(제2외국어 제외)이 5등급 이내인 자 ',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '해당없음',
      Col13: '(2022.02.03) 선발공고일 현재 대구 달성군 화원읍에 등록기준지를 2년 이상 두고 있는 자 또는 화원읍에 주소를 3년 이상 계속 두고 거주하고 있는 읍민과 그의 자녀',
      Col14: '2022-02-07~2022-02-28',
      Col15: '해당없음',
      Col16: '8명 ',
      Col17: '무상교육 대상자 및 자사고·특목고 재학생방송통신대 및 사이버대학 재학생2022년 2월 대학졸업자동일 교육과정 내 화원장학생으로 선발된 적이 있는 자 ',
      Col18: '해당없음',
      Col19: '장학생 선발 신청서주민등록초본 또는 기본증명서학교장 추천서개인정보 수집이용제공 및 조회 동의서서약서2021년 1월 건강보험료 납부확인서최근 1년간 전국단위 지방세 세목별 과세증명서2021년 2학기 교육비납입증명서2021년 2학기 성적증명서 수능성적표재학증명서가족관계증명서농지원부 (가산점)'
    },
    {
      Col1: '재단법인 화원장학회',
      Col2: '예체능특기자',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '시/도 단위 대회에서의 우승자나 전국대회에서의 3위 이내의 입상자 또는 국가대표선수로 선발된 실적이 있는 자',
      Col10: '해당없음',
      Col11: '1000000원',
      Col12: '해당없음',
      Col13: '(2022.02.03)선발공고일 현재 대구 달성군 화원읍에 등록기준지를 2년 이상 두고 있는 자 또는 화원읍에 주소를 3년 이상 계속 두고 거주하고 있는 읍민과 그의 자녀',
      Col14: '2020-06-17~2020-06-30',
      Col15: '해당없음',
      Col16: '2명',
      Col17: '무상교육 대상자 및 자사고·특목고 재학생방송통신대 및 사이버대학 재학생2022년 2월 대학졸업자동일 교육과정 내 화원장학생으로 선발된 적이 있는 자 ',
      Col18: '해당없음',
      Col19: '장학생 선발 신청서주민등록초본 또는 기본증명서학교장 추천서개인정보 수집이용제공 및 조회 동의서서약서2021년 건강보험료 납부확인서최근 1년간 전국단위 지방세 세목별 과세증명서2021년 2하기 교육비납입증명서2021년 2학기 성적증명서수능성적표 (신입생)예·체능 특기자의 입증서류재학증명서농지원부 '
    },
    {
      Col1: '원모평애재단',
      Col2: '효정평화장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학4학기',
      Col8: '공학계열/교육계열/사회계열/인문계열/자연계열/제한없음',
      Col9: '1학기 평균학점 (계절학기 성적 포함)을 4.5점 만점 기준 3.7점 이상/ 4.3점 만점 기준 3.5점 이상 취득한 자',
      Col10: '해당없음',
      Col11: '(등록금) 4학기 부터 졸업시 까지의 최대 5학기 동안의 등록금 전액(면학보조금) 4학기부터 졸업시 까지 매월 400000원(기타) 장학생들간의 커뮤니티 활동 및 활동비 지원',
      Col12: '2020년 9월 기준으로 국내 4년제 정규대학교의 2학년 2학기에 재학 예정인 자(복학예정자 포함) ',
      Col13: '해당없음',
      Col14: '2020-06-29~2020-07-07',
      Col15: '서류전형면접전형',
      Col16: '해당없음',
      Col17: '의학·보건계열 또는 예·체능계열 전공자는 제외타 기관의 장학금을 중복수혜 금지장학생 의무사항을 수행하지 않을 시 선발 취소 * 자세한 사항은 첨부파일 참조',
      Col18: '해당없음',
      Col19: '1학기 전체 학기 성적증명서재학(또는 휴학) 증명서지도교수 추천서경제상황증명서외국어능력 증빙자료 사본(해당자)전국규모 경시대회 입상 증빙자료 사본(해당자) * 자세한 사항은 원모평애재단 홈페이지에서 참고 * 온라인신청'
    },
    {
      Col1: '원모평애재단',
      Col2: '인재육성장학생(해외부문)',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대학원/해외대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '5000000원',
      Col12: '학부 및 대학원 석·박사과정 신입생으로/ 2020년 해외 유학예정자한국 국적 소유자 또는 최근(또는 유학가기 직전) 6년 이상 한국에서 거주한 자가정연합 목회자의 추천을 받은 자재단에서 요구하는 과제물 성실 이행 필수',
      Col13: '해당없음',
      Col14: '2021-01-05~2021-01-18',
      Col15: '(1차) 서류심사(2차) 면접심사',
      Col16: '5명',
      Col17: ' * 자세한 사항은 기관으로 문의',
      Col18: '가정연합 목회자의 추천을 받은 자',
      Col19: ' * 온라인 신청으로/ 홈페이지 접속지원신청원모장학온라인신청신청서(장학신청서+꿈소개서) 작성 및 제출목회자 추천서서약서해당학교 합격통지서가족관계증명서최종학력 성적증명서경제상황증명서'
    },
    {
      Col1: '원모평애재단',
      Col2: '인재육성장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원/전문대학원/해외대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '5000000원 (2회분할지급)',
      Col12: '한국국적 소지자(이중국적자포함)로 2021년도 석사 및 박사과정 재학생장학기간(2021년)휴학을 하지 않을 학생재단에서 실시하는 의무교육에 모두 참석이 가능한자',
      Col13: '해당없음',
      Col14: '해당없음',
      Col15: '해당없음',
      Col16: '10명',
      Col17: '해당없음',
      Col18: '가정연합 목회자의 추천을 받은 자',
      Col19: ' * 우편접수 서류가족관계증명서 (부모기준으로 발급/ 주민번호 명시)/사본제출가능재학증명서 또는 입학허가서본인통장 사본분야별 추가서류(멘토링관련 경력서/ 제안서)'
    },
    {
      Col1: '원모평애재단',
      Col2: '글로벌장학생(PreHJPA과정 프로그램)',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '특정대학',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: 'PreHJPA : 선문대학교 한국어교육원의 1년 간 수업료 전액 ( 약 5380000원 )HJPA : 선문대학교 학부과정 4년간 등록금 전액 ( 약 7500000원 ~ 8500000원 ) * 대한민국 국적 보유자는 70% 지원/기숙사비 포함 나머지 유학 경비는 장학생 자비부담',
      Col12: '선문대학교 학부 외국인/ 재외국민 전형으로 입학이 가능한 자정규 고등학교를 졸업했거나 졸업예정인 자/ 기타 학력자 중 선문대학교 입학자격을 갖춘 자졸업 후 대륙본부에서 정하는 공적헌신을 서약한 자',
      Col13: '해당없음',
      Col14: '2020-06-08~2020-06-12',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '입교 후 1년 미만 자한국어교육원의 입학이 취소된 경우 선발 취소한국어능력시험 4급 미획득자',
      Col18: '국가회장과 권역 청년학생국장의 추천을 받은 자대륙회장의 승인을 받은 자',
      Col19: '지원서자기소개서 수학계획서추천서서약서학붑모 지원 서약서에세이의료진단서건강증명서개인경비 체크리스트원리수련(7일이상) 수료증입회원서 사본고교졸업증명서 및 성적증명서(사본)여권사본 * 자세한 사항 홈페이지 참조'
    },
    {
      Col1: '재단법인광주시민장학회',
      Col2: '특별장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '한국장학재단 학자금 지원구간 5구간 이내인 학생',
      Col11: '500000원',
      Col12: '2020. 2. 23(감염병 위기단계「심각」) ~ 공고 개시 이전일까지의 기간 동안에 코로나19로 인해 비자발적으로 아르바이트 일자리를 잃은 학생',
      Col13: '공고일 기준 부모가 광주시에 2년 이상 계속 거주하고 있는 대학교 재학생',
      Col14: '2022-01-21~2022-02-10',
      Col15: '한국장학재단 학자금 지원구간 (50점)아르바이트 일자리 근무기간 (30점)아르바이트 일자리 근무기간 중 월 평균 소득금액 (20점)',
      Col16: '100명',
      Col17: '불법 과외자/ 유흥업소 등 취업자휴학/ 휴학 예정자/2년 미만 교육과정의 학교원격대학(방송통신대학교/ 통신대학/ 사이버대학)만 30세 이상인 경우국내 학교가 아닌 경우',
      Col18: '해당없음',
      Col19: '코로나 특별장학금 신청서주민등록등본학자금 지원구간 통지서 재학증명서사업주 확인서근로계약서최근 1년 이내 급여입금내역 또는 통장사본 등 급여 수령을 입증할 수 있는 서류개인정보제공동의서 * 자세한 사항은 홈페이지 공고 또는 첨부파일 참조'
    },
    {
      Col1: '동암장학회',
      Col2: '성적우수장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '누적학점과 직전학기 성적 B+학점 이상인 학생 ',
      Col10: '경제적환경이 어려운 자',
      Col11: '연간 4000000원 (2회 분할지급 한학기 200만원)',
      Col12: '국내/외 4년제 대학교의 재학생 및 신입생으로 품행이 바르며 경제적 환경이 어렵고 성적이 우수한 학생',
      Col13: '경주시에 거주하거나 원적이 경주시 강동면인 자',
      Col14: '2022-01-21~2022-02-10',
      Col15: '1차 : 서류심사 (장학위원회 개최)2차 : 장학위원 면접실시 (장학위원회 개최)',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금 수혜지원서 및 개인정보 수집/활용 및 제3자 제공 동의서본인의 주민등록등본 및 초본재학증명서대학교 전 학기 성적증명서 (신입생은 20019학년도 대학수학능력시험 성적통지표)(해당자)원적이 경주시 강동면인 학생인경우 가족관계증명서 추가  * 자세한 사항은 첨부파일 참고 '
    },
    {
      Col1: '동암장학회',
      Col2: '생활장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '누적학점과 직전학기 성적이 B학점 이상인 학생 ',
      Col10: ' * 부모나 본인이 아래항목 중 1개 이상에 해당하는 자기초생활수급자 또는 차상위계층 세대 건강보험료 월간 납부 금액이 100000원 이하인 자 직전년도 부모합산 연간 재산세 납부금액이 70000원 이하인 자 ',
      Col11: '연간 4000000원(한 학기 200만원)',
      Col12: '국내/외 4년제 대학교의 재학생 및 신입생으로 품행이 바르며 경제적 환경이 어렵고 성적이 우수한 학생으로 지원 요건에 해당하는 자',
      Col13: '경주시에 거주하거나 원적이 경주시 강동면인 자',
      Col14: '2022-03-28~2022-04-08',
      Col15: '1차 : 서류 심사 (장학위원회 개최) 2차 : 장학위원 면접 심사 (장학위원회 개최최) ',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학금수혜지원서 및 개인정보 수집/활용 및 제3자 제공동의서본인의 주민등록등본 및 초본재학증명서 (원본)대학교 전 학기 성적증명서 (신입생은 2019학년도 수능 성적통지표)원적이 경주시 강동면인 학생은 가족관계증명서 추가 (해당자)기초생활수급자 및 차상위계층 대상자는 해당 증빙서류부모 건강보험료 (월간)납부 확인서직전년도 부/모 세목별 과세(납세)증명서(재산세_건강보험료 (월간)납부확인서와 부/모 세목별 과세(납세)증명서를 모두 제출해야함재산세 납세증명서는 부/모 2명 모두의 증명서를 제출할 것 * 자세한 사항은 첨부파일 참고'
    },
    {
      Col1: '재단법인 안성시민장학회',
      Col2: '우수장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '대학 1학년: 직전1년 성적이 학년 11% 이내인 학생 (과목 평균 적용)대학생 : 직전1년 성적이 평점 B+(3.5) 이상인 재학생',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '국내 대학에 재학중인 학생',
      Col13: '관내에 5년 이상 계속 거주한 자(부모기준) 중 국내대학 재학생',
      Col14: '2022-03-28~2021-04-08',
      Col15: '선발기준 평가점수 90% 반영 + 기타사항 평가점수 10% 반영의 상대평가 선발   * 기타사항: 가정환경5%/ 자기소개서3%/ 장학금수혜여부2% ',
      Col16: '25명',
      Col17: '현학기 등록금의 50% 이상 타 장학금을 받은 자는 신청자격 미달. (단/ 기초생계수급자 등 발전장학금 예외)1인 2개 분야 및 1가구 2자녀 동시수혜 불가',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보제공동의서타장학금수혜확인서 (등록금/ 장학금 등을 명확히 기재)직전 학년 성적표 재학증명서 주민등록 등본 (주소변동 포함)자기소개서 ( 글자크기 13point/ A4용지 2장 이내 )'
    },
    {
      Col1: '재단법인 안성시민장학회',
      Col2: '특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '과학기술/ 예술/ 체육/ 환경/ 생태/ 역사문화 등에서 우수한 학생특기분야의 도대회/ 전국대회 입상실적 ※ 특기 성적자료는 직전학년 1년이내 자료만 유효함',
      Col13: '관내에 5년 이상 계속 거주한 자(부모기준) 중 국내대학 재학생',
      Col14: '2022-03-28~2022-04-08',
      Col15: '선발기준 평가점수 90% 반영 + 기타사항 평가점수 10% 반영의 상대평가 선발   * 기타사항: 가정환경5%/ 자기소개서3%/ 장학금수혜여부2%',
      Col16: '5명',
      Col17: '현학기 등록금의 50% 이상 타 장학금을 받은 자는 신청자격 미달. (단/ 기초생계수급자 등 발전장학금 예외)1인 2개 분야 및 1가구 2자녀 동시수혜 불가',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보제공동의서타장학금수혜확인서 (등록금/ 장학금 등을 명확히 기재)재학증명서 주민등록 등본 (주소변동 포함)직전 1년간 특기(성적)자료 (과학기술/ 예술체육/ 환경생태/ 역사문화/ 자원봉사 등의 수상실적 및 공적사항 확인서 (수상실적 : 도대회 1위 또는 전국대회 3위 이상 입상실적 )자기소개서 ( 글자크기 13point/ A4용지 2장 이내 )'
    },
    {
      Col1: '재단법인 안성시민장학회',
      Col2: '발전장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: ' 기초생계수급자 및 차상위계층 등 가정형편이 어려운 자',
      Col11: '2000000원',
      Col12: '해당없음',
      Col13: '관내에 5년 이상 계속 거주한 자 중 국내대학 재학생',
      Col14: '2022-03-28~2022-04-08',
      Col15: '선발기준 평가점수 90% 반영 + 기타사항 평가점수 10% 반영의 상대평가 선발   * 기타사항: 가정환경5%/ 자기소개서3%/ 장학금수혜여부2%',
      Col16: '21명',
      Col17: '현학기 등록금의 50% 이상 타 장학금을 받은 자는 신청자격 미달. (단/ 기초생계수급자 예외)1가구 2자녀 동시수혜 불가',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보제공동의서타장학금수혜확인서 (등록금/ 장학금 등을 명확히 기재)재학증명서 학생본인 기초생활수급자증명서 또는 차상위본인부담 경감대상자 증명서전년도 세목별 과세증명서   * 세목 : 재산세 / 자동차세(가족관계증명서 상 보호자 모두 제출/ 납세액이 없을 경우 미과세 증명서 제출)가족관계증명서 (부모기준) 한부모가족 증명서 (해당자만)주민등록 등본 (주소변동 포함)자기소개서 ( 글자크기 13point/ A4용지 2장 이내 )'
    },
    {
      Col1: '재단법인 안성시민장학회',
      Col2: '다자녀장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '가정형편이 어렵고 친부모 슬하 세 자녀 이상 가정의 세 학생 중 1명',
      Col13: '관내에 5년 이상 계속 거주한 자(부모기준) 중 국내대학 재학생',
      Col14: '2022-06-20~2022-07-21',
      Col15: '선발기준 평가점수 90% 반영 + 기타사항 평가점수 10% 반영의 상대평가 선발   * 기타사항: 가정환경5%/ 자기소개서3%/ 장학금수혜여부2%',
      Col16: '10명',
      Col17: '현학기 등록금의 50% 이상 타 장학금을 받은 자는 신청자격 미달. (단/ 기초생계수급자 등 발전장학금 예외)1인 2개 분야 및 1가구 2자녀 동시수혜 불가',
      Col18: '해당없음',
      Col19: '장학금지원신청서개인정보제공동의서타장학금수혜확인서 (등록금/ 장학금 등을 명확히 기재)3자녀 모두 재학증명서주민등록 등본 (주소변동 포함)가족관계증명서 (부모기준)전년도 세목별 과세증명서   * 세목 : 재산세 / 자동차세 (주민등록등본 상 보호자 모두 제출/ 납세액이 없을 경우 미과세 증명서 제출)자기소개서 ( 글자크기 13point/ A4용지 2장 이내 )'
    },
    {
      Col1: '선재장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 전 과목 B학점 이상',
      Col10: '해당없음',
      Col11: '2000000원 이상',
      Col12: ' * 학업성적이 우수하고 품행이 단정하며/ 타의 모범이 되는 학생으로 학과장 또는 지도교수의 추천을 받은 자국내 2년제/ 4년제 대학교 재학생대학원생의 경우 학부때 2회 이상 선재장학생으로 선발된 자 중 대학원에 진학(재학)한 자',
      Col13: '해당없음',
      Col14: '2021-11-08~2021-11-23',
      Col15: '해당없음',
      Col16: '대학(원)생 40명 이상',
      Col17: '장학회 워크숍 및 장학증서 수여식 불참자는 수혜 취소',
      Col18: '학과장 또는 지도교수의 추천',
      Col19: '개인정보 이용·제공 동의서장학생 지원서장학생 추천서자기소개서반명함판 사진전학년 성적증명서재학 증명서부모기준 가족관계 증명원의료보험료 납부영수증 사본재산세 과세증명원소득금액 증명원 * 자세한 사항 기관 홈페이지 참조'
    },
    {
      Col1: '백산장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '국내외 정규 교육기관 재학생',
      Col13: '해당없음',
      Col14: '2022-01-10~2022-01-21',
      Col15: '백산장학회(재) 이사회의 결의로 선발',
      Col16: '대학생 또는 대학입학 예정자 : 00명',
      Col17: '방송통신대학/ 사이버대학 재학생은 제외복수의 장학금 지급 대상자는 제외지난 3년 내에 백산장학재단의 장학금을 수급한 사실이 없어야 함',
      Col18: '해당없음',
      Col19: '자기소개서 (1200자 내외)장학생 추천서성적증명서장학생 선발에 참고가 될 만한 기타 서류 통장사본 * 우편접수 또는 이메일 접수로 자세한 사항은 홈페이지 참고'
    },
    {
      Col1: '재단법인문숙장학재단',
      Col2: '문숙장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/자연계열',
      Col9: '직전 학기 성적이 3.5 이상인 학생이며/ 정규학기 계속 등록자(직전학기 휴학자 제외)',
      Col10: '국가장학금지급대상자 중 0분위 ~ 6분위에 속한 학생가정의 총 월 건강보험료가 30만원을 넘지 않는 학생',
      Col11: '2년제 대학생: 1200000원4년제 대학생: 1500000원 ',
      Col12: ' * 본 재단으로부터 장학생 추천 의뢰를 받은 대학교에서 추천한 학생이공계열의 대학생  ',
      Col13: '해당없음',
      Col14: '2022-02-14~2022-02-25',
      Col15: '해당없음',
      Col16: '30명 내외 ',
      Col17: '전 학기 휴학 등은 제외문숙장학금을 포함한 모든 장학금 수혜금액이 등록금을 초과하는 학생 (초과될 경우 반환처리)초과학기 등록학생',
      Col18: '학교장/ 학장/ 지도교수 등의 추천서 제출',
      Col19: ' * 장학재단이 각 학교에 의뢰를 넣어 선발하는 장학금으로/ 신청 및 문의를 하기 전에 학교 공지사항 확인 및 장학부서에 문의 필수장학금 지원 신청서장학생 추천서자기소개서서약서와 조회 동의서직전학기 성적증명서부/모의 건강보험료 납부확인서건강보험료 자격확인서'
    },
    {
      Col1: '재단법인 동해농협장학회',
      Col2: '조합원자녀 장학금',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1500000원',
      Col12: '동해농협 조합원 본인과 직계비속   (조합원 자녀 선발을 우선으로 하고 미달 시 손자녀을 선발한다.)1회에/ 한 해 1자녀만 선발한다.영농형태가 직계존속 모두 전업농가의 대상자재산 및 연소득이 낮아 가정형편이 어려운 농가전년도 이용고점수가 높은 조합원 본인 및 직계비속상급생인자 ',
      Col13: '선발대상자와 학부모는 동일세대에 1년 이상 동해농협 구역안에 거주하는 자(단/ 유학의 경우 예외)조부모가 조합원인 경우 선발대상자의 학부모는 1년 이상 동해농협의 구역 안에 거주하는 자로 한다.',
      Col14: '모집 기간 종료(추후 모집)',
      Col15: '해당없음',
      Col16: '대학생 20명',
      Col17: '타 장학금을 받거나 면제받는 대학생 단/ 납부고지서의 50% 이하인 대학생은 예외2020년 1월 1일 이후 우리농협 조합원으로 가입한 자 (단/ 상속 또는 양도의 경우는 가능)선발대상자의 직계존속 중 연 근로소득금액 7/000만원이 초과되는 경우최근 1년간간 동해농협 사업이용이 전혀 없는 조합원',
      Col18: '해당없음',
      Col19: '(재)동해농협장학회 장학생 지원서주민등록등본등록금영수증기타 본회가 요구하는 서류 * 자세한 사항은 첨부파일 확인필수수'
    },
    {
      Col1: '전라북도인재평생교육진흥원',
      Col2: '산업인재장학생',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 소속 대학의 최저 이수학점을 이수하고 100점 만점의 70점 이상 성적을 획득한 재학생(*한국폴리텍대학은 2년제 학과(학사학위 과정)만 해당)',
      Col10: '해당없음',
      Col11: '1인당 연간 최대 200만원(등록금 범위 내) * 본인부담등록금을 최대 200만원까지 기업규모에 따라 차등 지원',
      Col12: '전라북도 대학 야간학과 재학 중인 1학년생과 2012∼2017년 산업인재 장학생으로 선발되었던 학생',
      Col13: '최종 학력이 전라북도 내 고등학교 졸업공고일(2019. 7. 22)이전부터 전라북도 내 제조업체에 재직 중인 자',
      Col14: '2021-08-13~2021-09-15',
      Col15: '우대분야 : 전라북도 지역산업 * 우선순위 적용 선발1순위 : 우대분야 재직자로 우대분야 학과 전공자2순위 : 우대분야 재직자로 우대분야와 관계없는 학과 전공자3순위 : 우대분야와 관계없는 분야 재직자로 우대분야 학과 전공자',
      Col16: '15명 내외(예산범위 내)',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 지원서 (소정양식)재직증명서재학증명서고등학교 졸업증명서성적증명서서약서 (소정양식) * 접수처 : 소속대학 장학지원실'
    },
    {
      Col1: '(재)관우장학회(서울)',
      Col2: '관우장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '기준학점 : 각 학기마다 평점 B0이상인 자',
      Col10: '해당없음',
      Col11: ' * 1인당 구체적 지급액은 선정위원회에서 추후 결정',
      Col12: '관세 공무원으로 5년 이상 근속한(전직은 10년 이상) 최종직급 5급 이하의 1인 1자녀 관세 행정발전에 기여한 학교의 학생(5인 이하)대학교 및 전문대학 학생(교환학생 포함) * 자세한 사항은 첨부파일 참고',
      Col13: '해당없음',
      Col14: '2022-04-11~2022-04-21',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '학사 경고를 받은 자타 장학금 수혜 사실이 있는 자제출 성적 미달자2학기 미등록 및 휴학졸업생(초과학기자 포함)  * 자세한 사항은 첨부파일 참고',
      Col18: '해당없음',
      Col19: ' * 현직관우장학금 지급 대상자 명단관우장학금 지급신청서 및 학교장 추천서직전 2학기 성적증명서복학증명서류 및 성적증명서(해당자)가족관계등록부개인정보이용동의서계좌사본 * 전직관우장학금 지급신청서 및 학교장 추천서직전 2학기 성적증명서복학증명서류 및 성적증명서(해당자)가족관계등록부개인정보이용동의서경력증명서계좌사본'
    },
    {
      Col1: '삼척시도계장학재단',
      Col2: '삼척시도계장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: ' * 신입생졸업학교 고3 평균교과등급이 4등급 이상인 자 또는 검정고시 평균 70점 이상인자자 * 재학생전학년 평균성적이 B학점 이상인 자',
      Col10: ' * 성적과 관계없이 신청 가능한 자저소득가정을 20% 선발하고 장학생 선발인원이 미달될 경우에는 저소득가정을 우선선발 / 나머지는 성적순1. 기초생활수급자2. 장애인의 자녀3. 한부모 가정4. 진규폐환자의 자녀',
      Col11: '1인당 1000000원 * 학업수행 과정 중 학자금 및 생활에 필요한 자금',
      Col12: '전문대학 및 4년제 대학교 학생',
      Col13: '본인 또는 친권자(후견인)의 주소가 2020년 4월 11일 이전부터 접수일 현재까지 삼척시 도계읍으로 등록되고/ 실제 거주하고 있는 자(2년 이상) ',
      Col14: '2022-08-29~2022-09-16',
      Col15: '해당없음',
      Col16: '대학생(전문대생 포함) 40명',
      Col17: '타기관/단체의 장학재단에서 장학금을 받는 학생 신청 불가',
      Col18: '해당없음',
      Col19: '장학금신청서 및 추천서개인정보 수집이용 및 제3자 제공 동의서주민등록등본 (가족관계 확인 불가 시 가족관계증명서 첨부)통장사본 (본인 또는 부모) * 접수장소(도계읍  행정복지센터 총무부서직접 또는 우편) * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 서동이장학회',
      Col2: '학업우수 장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '2022년 1학기 성적이 평점평균 4.5만점 기준 A(4.0) 이상 * 4.5만점으로 환산하여 제출',
      Col10: '해당없음',
      Col11: '2000000원',
      Col12: '해당없음',
      Col13: '공고일 기준 본인 또는 보호자가 인천광역시 서구에 3년 이상 주민등록 주소지를 두고 거주하고 있는 대학교 재학생 (전문대학 포함)',
      Col14: '2022-08-29~2022-09-16',
      Col15: '선발심사위원회 1차 심사장학회 이사회 의결선발',
      Col16: '32명',
      Col17: '방송통신대학/ 사이버대학/ 학점은행제 대학 재학생 및 국외 유학생 등은 제외징계(정학/ 제적 등) 처분 받은 학생서동이장학금 기수혜자한가구 내 2인 이상 지원 시 1인만을 지원적격자로 판단하여 심사 * 자세한 사항은 첨부파일 참고',
      Col18: '총장(학장) 추천',
      Col19: '장학생 신청서장학생 추천서 : 총장(학장)추천타 장학금 수혜사실 확인서2022학년도 2학기 등록금 고지서 또는 납부영수증 사본성적증명서건강보험료납부확인서주민등록 초본가조관계증명서(상세)개인정보 수집·이용·조회·제공 등에 대한 동의서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 서동이장학회',
      Col2: '복지장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적이 평점평균 4.5만점 기준 B(3.0) 이상',
      Col10: '가정형편이 어려운 학생',
      Col11: '2000000원 * 학업장려금',
      Col12: '공고일 기준 본인 또는 보호자가 인천광역시 서구에 3년 이상 주민등록 주소지를 두고 거주하고 있는 대학 재학생 중 가정형편이 어려운 학생',
      Col13: '공고일 기준 본인 또는 보호자가 인천광역시 서구에 3년 이상 주민등록 주소지를 두고 거주하고 있는 대학 재학생 ',
      Col14: '2022-08-29~2022-09-16',
      Col15: '해당없음',
      Col16: '23명',
      Col17: '방송통신대학/ 사이버대학/ 학점은행제 대학 재학생 및 국외 유학생 등은 제외징계(정학/ 제적 등) 처분 받은 학생서동이장학금 기수혜자한가구 내 2인 이상 지원 시 1인만을 지원적격자로 판단하여 심사 * 자세한 사항은 첨부파일 참고',
      Col18: '총장(학장) 또는 거주지 동장 추천',
      Col19: '장학생 신청서장학생 추천서 : 총장(학장) 또는 거주지 동장 추천타장학금 수혜사실 확인서등록금 고지서 또는 납부영수증 사본성적증명서건강보험료납부확인서복지대상자 가정임을 증명하는 서류 (국민기초생활수급자/ 차상위계층/ 한부모가족 증명서 등)주민등록 초본가족관계등록부 (상세)개인정보 수집·이용·조회·제공 등에 대한 동의서  * 자세한 내용은 첨부파일 또는 홈페이지 공지사항 참고'
    },
    {
      Col1: '재단법인 서동이장학회',
      Col2: '예·체·기능 특기장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '특기자',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '1000000원 ( * 서동이 유망주 장학생으로 선발될 시 5백만원 이내 차등 지급 계속 선발 가능 )',
      Col12: '공고일 기준 1년이내(2021.8.27. ~ 2022.8.28) 전국규모 이상 대회에서 3위 이상 입상자서동이 유망주 : 인천 서구의 명성을 떨칠 발전 가능성이 많아 육성 지원이 타당하다 판단되는 특기 우수학생 (예·체·기능 장학생 선발자 중 0~5명 선발)',
      Col13: '공고일 기준 본인 또는 보호자가 인천광역시 서구에 3년 이상 주민등록 주소지를 두고 거주하고 있는 대학교 재학생',
      Col14: '2022-03-28~2022-04-04',
      Col15: '해당없음',
      Col16: '24명(초/중/고/대학생 포함) * 특기장학생 중 서동이 유망주 0~5명 별도 선정/ 자세한 사항은 첨부파일 참조',
      Col17: '방송통신대학/ 사이버대학/ 학점은행제 대학 재학생 및 국외 유학생 등은 제외징계(정학/ 제적 등) 처분 받은 학생서동이장학금 기수혜자한가구 내 2인 이상 지원 시 1인만을 지원적격자로 판단하여 심사 * 자세한 사항은 첨부파일 참고',
      Col18: '학교장(총장) 추천',
      Col19: '장학생 신청서장학생 추천서 (학교장(총장)추천)타 장학금 수혜사실 확인서등록금 고지서 또는 납부영수증 사본입상을 증명하는 서류주민등록초본 (최근5년간 주소변동사항 포함)가족관계증명서(상세)개인정보 수집·이용·조회·제공 등에 대한 동의서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고 '
    },
    {
      Col1: '재단법인 새얼문화재단',
      Col2: '새얼장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업석차가 25%이내인 학생',
      Col10: '중위소득 100% 이하인 학생 * 자세한 사항은 학교 홈페이지 장학게시판 참고',
      Col11: '2000000원 (등록금 내 지원) * 최대 2개 학기 지급',
      Col12: '품행이 단정하고 학교생활에 모범이 되고 있는 학생(재학생)직전 학기 성적이 있는 1학년 2학기 이상 정규 학기 재학생',
      Col13: '인천에서 중학교와 고등학교를 모두 졸업한 학생',
      Col14: '2021-10-01~2021-10-12',
      Col15: '해당없음',
      Col16: '학교별로 추천 인원이 상이하므로 학교 홈페이지 장학게시판 확인 필수',
      Col17: '타장학금 수혜자 추천 불가 ',
      Col18: '해당없음',
      Col19: '장학금 지급 원서성적 증명서주민등록등본부모님(주 소득자) 건강보험 납입 확인서(최근 3개월)중·고등학교 졸업 증명서한국장학재단 학자금 지원 구간 통지서 * 자세한 사항은 학교 홈페이지 장학 게시판 확인'
    },
    {
      Col1: '재단법인 송화재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '평점평균 3.6 이상 ',
      Col10: '2021학년도 2학기 한국장학재단 소득분위 0~8분위 대상자',
      Col11: '2000000원 * 등록금성',
      Col12: '3학년 2학기 이상 재학중이며 전체(최소 5개학기) 평점 3.6이상인 학생본교에서 5학기 이상 수료한 학생2021학년도 2학기 등록금 자비 납부액이 2/000/000원 이상인 학생장학증서수여식에 참석 가능한 자 ',
      Col13: '해당없음',
      Col14: '2022-03-28~2022-04-08',
      Col15: '서류접수/학교심사재단추천재단심사최종선발장학증서수여식',
      Col16: '4명',
      Col17: '편입생 제외초과학기자등록금 자비 납부액이 200만원 이하인 자',
      Col18: '해당없음',
      Col19: '장학생 신상기록부장학생 추천서성적증명서주민등록등본 ※ 재단 측에서 대학교로 공문을 통해 장학생 추천을 의뢰하는 장학금이므로/ 소속 대학 장학팀을 통해 선발 여부를 확인해주시기 바랍니다.'
    },
    {
      Col1: '재단법인 포천시교육재단',
      Col2: '성적우수',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 출신 고교 3학년 국어/영어/수학(취업계열은 전공과목)의 내신등급 평점이 상위 11%(2등급) 이내이거나 대학수학능력평가 국/수/영 영역 등급평점이 2등급 이내재학생 : 직전학년 성적이 4.5점 기준 A(4.0)학점 이상 (대학 학점제가 4.3제인 경우 4.5제로 환산적용)',
      Col10: '해당없음',
      Col11: '최대 2500000원',
      Col12: '공고일 현재 국내 학교에 입학 또는 재학 중인 학생',
      Col13: '공고일 현재 본인 또는 부모(조손가정은 실부양자)가 포천시에 2년 이상 거주하고 있는 학생',
      Col14: '2022-03-28~2022-04-08',
      Col15: '성적 100%',
      Col16: '신입생: 4년제(11)/ 전문대(2)재학생: 4년제(8)/ 전문대(3)',
      Col17: '휴학생/ 졸업생(2018년 2월)/ 대학원생 등은 신청불가성적 비교산출이 곤란하거나 또는 국비로 수업료가 지원되는 검정고시/ 대안학교/ 학점은행제/ 사이버(원격)대학/ 방송통신학교/ 평생교육원/ 사관학교/ 경찰대학교/ 아세아항공전문학교/ 계약학과 등의 재학생은 신청불가',
      Col18: '해당없음',
      Col19: '장학금 지원신청서개인정보 수집이용 및 조회 동의서성적증명서   (대학교 재학생 : 직전학년 1년치(1년미만 재학생 신청불가)   (대학교 신입생 : 고3 내신 또는 수능(본인에게 유리한 성적)재학증명서 (신입생은 합격증명서 또는 입학예정서) 2021년 1학기 등록금고지서 또는 납부영수증 사본주민등록 초본 (주소변동 포함/ 부모 중 거주기간이 가장 긴 1명 초본만 제출)2019년도 건강보험료 납부확인서 (부/ 모 모두 각 1통)   (미가입자(외벌이/ 자영업자 등)는 건강보험자격득실확인서)본인명의 보통예금 통장사본 (정기 예·적금 불가/ 인터넷뱅킹 통장사본 가능)  * 가점다자녀/ 다문화의 경우 가족관계증명서 (부모명의)   (가족관계증명서로 확인 불가 시 기본증명서 제출)장애인/ 급여대상자(수급자) 등 해당증명서'
    },
    {
      Col1: '재단법인 포천시교육재단',
      Col2: '일반',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '신입생 : 출신 고교 3학년 국어/영어/수학(취업계열은 전공과목)의 내신등급 평점이 상위 40%(4등급) 이내이거나 대학 수학능력평가 국어/영어/수학 영역 등급평점이 4등급 이내재학생 : 출신고교 직전학년 24학점 이상 이수 및 성적이 4.5점 기준 3.0학점 이상   (대학 학점제 4.3인 경우/ 4.5로 환산적용)',
      Col10: '해당없음',
      Col11: '1인당 최대 2500000원',
      Col12: '공고일 현재 국내 학교에 입학 또는 재학 중인 학생',
      Col13: '공고일 현재 본인 또는 부모(조손가정은 실부양자)가 포천시에 2년 이상 거주하고 있는 학생신청자 본인 또는 보호자의 거주기간을 반영하며 포천시 거주기간이 가장 긴 가족 구성원 1명의 기간을 반영',
      Col14: '2022-02-28~2022-03-04',
      Col15: '성적30% + 소득70%',
      Col16: '신입생: 4년제(18)/ 전문대(2)재학생: 4년제(22)/ 전문대(4)',
      Col17: '휴학생/ 졸업생(2021년 2월)/ 대학원생 등은 신청불가성적 비교산출이 곤란하거나 또는 국비로 수업료가 지원되는 검정고시/ 대안학교/ 학점은행제/ 사이버(원격)대학/ 방송통신학교/ 평생교육원/ 사관학교/ 경찰대학교/ 아세아항공전문학교/ 계약학과 등의 재학생은 신청불가',
      Col18: '해당없음',
      Col19: '장학금 지원신청서개인정보 수집이용 및 조회 동의서성적증명서   (대학교 재학생 : 직전학년 1년치(1년미만 재학생 신청불가)   (대학교 신입생 : 고3 내신 또는 수능(본인에게 유리한 성적)재학증명서 (신입생은 합격증명서 또는 입학예정서) 2020년 1학기 등록금고지서 또는 납부영수증 사본주민등록 초본 (주소변동 포함/ 부모 중 거주기간이 가장 긴 1명 초본만 제출)2019년도 건강보험료 납부확인서 (부/ 모 모두 각 1통)   (미가입자(외벌이/ 자영업자 등)는 건강보험자격득실확인서)본인명의 보통예금 통장사본 (정기 예·적금 불가/ 인터넷뱅킹 통장사본 가능)  * 가점다자녀/ 다문화의 경우 가족관계증명서 (부모명의)   (가족관계증명서로 확인 불가 시 기본증명서 제출)장애인/ 급여대상자(수급자) 등 해당증명서'
    },
    {
      Col1: '(재)선학장학재단',
      Col2: '장학생',
      Col3: '민간(기업)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '해당없음',
      Col10: '해당없음',
      Col11: '해당없음',
      Col12: '1. 각 도·광역시·권 지부장이 추천한 학생2. 품행이 타의 모범이 되고/ 학업성적이 우수한 대학생3. 품행이 타의 모범이 되나 가정형편이 어려워 학업을 계속하기가 곤란한 모든 학생 *(위 항목 중 하나이상의 항목에 충족되는 대학생)',
      Col13: '해당없음',
      Col14: '2022-01-03~2022-01-10',
      Col15: '해당없음',
      Col16: '각 구/도/광역시 1명 내외',
      Col17: '장학생 선발위원회 심사를 거쳐 부적합 할 경우 제외 가능',
      Col18: '각 구/도/광역시 지부장이 추천',
      Col19: '장학생 지원서 및 자기 소개서(소정양식)장학생 추천서 및 확인서 (추천소견이 반드시 기재되어야 함)본인 명의 통장사본(장학금 지급받을 본인명의 계좌)개인정보 수집·이용·제공 및 조회 동의서여권사진 2매기타(성적증명서/ 등록금납입영수증/ 건강보험료 납부확인서/ 기초생활수급자 증명서 외 해당 관련 서류)우편/ 이메일/ 방문접수우)140869  서울시 용산구 청파로 319 (청파빌딩 4층)                    재단법인 선학장학재단 담당자 앞 J2sunhak@hanmail.net '
    },
    {
      Col1: '(재)용복장학회',
      Col2: '월정김용복장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 최소 이수학점 기준 12학점 이상직전학기 학점 3.7(4.5기준) 이상 * 신입생 성적기준 제외/ 계절학기 성적 기준 범위 포함 X',
      Col10: '해당없음',
      Col11: '선발시점부터 대학교 졸업까지 등록금 전액',
      Col12: '학업 성적이 우수하나 가정 형편이 어려운 대학생 또는 농촌 출신이거나 농업관련 학과 전공자로 농업 발전에 관심있는 자',
      Col13: '해당없음',
      Col14: '2021-11-10~2021-11-15',
      Col15: '(1차) 서류심사(2차) 면접심사',
      Col16: 'O명',
      Col17: '해당없음',
      Col18: '국·공립 및 사립 대학교 총(학)장 및 지도교수각급 단체장 등 사회 지도층 인사',
      Col19: '장학생 지원서추천서자기소개서 서약서신청인 서약서개인정보 활용 동의서 재학증명서성적증명서학생 및 보호자의 주민등록등본경제상황 증빙서류 * 자세한 사항은 기관 홈페이지 참조'
    },
    {
      Col1: '(재)심명문화재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '4년제(5~6년제포함)/일반대학원/전문대(2~3년제)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 성적 평점 3.0(4.5만점) 이상인 학생',
      Col10: '경제적 사정으로 어려움을 격고 있는 학생',
      Col11: '2000000원',
      Col12: '수도권 소재 대학교에 재학 중이며 교내에서 학자금 대출을 받은 학생 또는 한국장학재단에서 학자금 대출을 받은 학생한국장학재단 소득분위 대상자',
      Col13: '수도권 소재 대학교 재학생 ',
      Col14: '2022-07-11~2022-07-29',
      Col15: '재단에서 추천서 수령 후 접수>당 재단 사무국 심의 후 이사회 심사로 선정>개별 지급',
      Col16: '단과 대학별 추천인원 1명 최종 6명 ',
      Col17: '2021년도 2학기 기준 휴학생2021년도 2학기 등록금 실납입액 0원인 자 ',
      Col18: '학생 처장 ',
      Col19: '장학생신청서 1부(재단소정양식)반명함 사진 1매자기신고서 1부(재단소정양식)학업계획서 1부(재단소정양식)등록금 납부확인서(학교소정양식)미납부시 고지서 사본서약서 1부(재단소정양식)개인정보 수집이용제공 동의서(재단소정양식)주민등록등본 1부성적증명서(학생기록부 포함) 1부(학교소정양식)추천서(재단소정양식) 생활보호대상자 및 가계 곤란 대상자는 증명서 또는 재산세 확인서장학생 본인 통장 사본'
    },
    {
      Col1: '서울상대향상장학회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '특정학과',
      Col9: '직전학기 성적 2.4이상/ 10학점 이상 이수자',
      Col10: '20222 한국장학재단 소득분위 3분위~6분위 재학생 중 가정형편이 어려운 학생',
      Col11: '120만원 / 1학기',
      Col12: '인성/ 품행이 단정한 학생현재학기 교내장학금 혹은 국가장학금을 신청한 학생2022학년도 2학기 교내장학금 또는 국가장학금을 신청한 학생',
      Col13: '해당없음',
      Col14: '2022-04-22~2022-05-12',
      Col15: '해당없음',
      Col16: '신규자 2명',
      Col17: '규정학기 초과자타 장학금 수혜자해외수학의 경우',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 장학선정신청서성적증명서2022년 2학기 한국장학재단 소득분위 확인서본인 통장사본주민등록증 앞면 사본(주민등록번호 뒷자리 필히 삭제 요망)개인정보 수집 동의서 * 자세한 사항은 서울대학교 장학공지사항 참고'
    },
    {
      Col1: '우월김활란장학회',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '성적이 우수한 학생',
      Col10: '가정형편이 어려운 학생',
      Col11: '2000000원',
      Col12: '20221학기 정규등록 학부 학생북한이탈주민 본인 또는 자녀인 학생학업성적이 우수하고/ 품행이 단정하며 다른 사람에게 모범을 보이는 학생경제적 사정이 어려운 자 ',
      Col13: '해당없음',
      Col14: '기관문의(3월)',
      Col15: '해당없음',
      Col16: '1명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 성적증명서신청서서약서자기소개서개인정보이용제공동의서'
    },
    {
      Col1: '(재)경방육영회',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '4년제(5~6년제포함)',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/연령제한/제한없음',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전학기 평점평균 3.5(4.5만점) 이상인 학생',
      Col10: '해당없음',
      Col11: '학기당 150만원씩 3월 및 8월에 지급',
      Col12: ' 가정형편이 어려운 학생 등록금 범위 타장학금 중복 가능  *각 대학교 별로 상이하므로 각 홈페이지 참조',
      Col13: '해당없음',
      Col14: '2022-01-06~2022-01-12',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: ' * 각 대학교 별 내용 상이하므로 홈페이지 참조',
      Col18: '해당없음',
      Col19: ' * 학교 추천 방식으로/ 신청시 각 학교 장학부서에 문의 필수. 추천서 장학금 지급원서보호자의 2021년 지방세 세목별 과세증명서보호자의 2021년 건강보험료 납부확인서 및 건강보험증 사본 각1부 서약서성적증명서 1부개인정보이용제공동의서 1부  * 각 대학별로 상이하므로 홈페이지 참조 바람'
    },
    {
      Col1: '재단법인 서울대학교전자전기정보장학재단',
      Col2: '장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '성적우수',
      Col6: '일반대학원/특정대학',
      Col7: '박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/특정학과',
      Col9: '성적 3.0 이상인 자 ( * 신입생의 경우 학부 성적 기재)',
      Col10: '가계 곤란자',
      Col11: '해당없음',
      Col12: '서울대학교 전기정보공학부 대학원 석/박/통합 과정생학기 초 후배사랑 장학생 간담회 및 수여식 등 재단 행사에 적극적으로 협조 가능한 자',
      Col13: '해당없음',
      Col14: '2022-01-26~2022-02-08',
      Col15: '해당없음',
      Col16: '해당없음',
      Col17: '해당없음',
      Col18: '지도교수의 추천을 받은 자 ',
      Col19: '장학생 지원서/ 자기소개서/ 추천서성적증명서건강보험료 납부확인서부모가 의료급여수급권자인 경우 의료급여증명서 1부 및 의료급여증 사본(해당자)지방세 세목별 납세 증명서 * 양식 다운로드 및 자세한 사항 확인은 홈페이지 내 공고문 참조'
    },
    {
      Col1: '인하대동문장학회',
      Col2: '가계곤란장학생',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '소득구분',
      Col6: '특정대학',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '직전 학기 평점평균 2.0 이상 학생',
      Col10: '해당없음',
      Col11: '1000000원 ~ 2000000원',
      Col12: '인하대학교 재학생으로 가정형편이 어려운 자',
      Col13: '해당없음',
      Col14: '2022-01-20~2022-02-04',
      Col15: '해당없음',
      Col16: 'O명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '재학증명서 및 성적증명서 각 1부장학금 신청서 및 자기소개서 각 1부한국장학재단 소득분위확인서 1부가족관계증명서 1부우대사항 증빙서류 각 1부개인정보 수집이용동의서 1부'
    },
    {
      Col1: '의성김씨대종회웅대장학재단',
      Col2: '장학금',
      Col3: '민간(기타)',
      Col4: '장학금',
      Col5: '기타',
      Col6: '4년제(5~6년제포함)/일반대학원',
      Col7: '대학2학기/대학3학기/대학4학기/대학5학기/대학6학기/대학7학기/대학8학기이상/대학신입생/박사과정/석사2학기이상/석사신입생(1학기)',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '학업성적 우수자(평점 3.8이상/ 평균 85점 이상)',
      Col10: '사회배려(저소득층) 학생.',
      Col11: '2000000원',
      Col12: '전국 의성김문의 자녀품행이 방정하고 타의 모범이 되는 학생남다르게 효행/선행을 실천하는 학생기타 사회적 배려 대상인 학생 * 자세한 사항은 홈페이지 참고 ',
      Col13: '해당없음',
      Col14: '2022-03-04~2022-03-14',
      Col15: '해당없음',
      Col16: '25명',
      Col17: '해당없음',
      Col18: '해당없음',
      Col19: '장학생 신청서개인정보 수집이용 제공 동의서자기소개서주민등록등본등록금 납입고지서부모의 재산세 납입증명서입학허가통지서재학증명서성적증명서 * 자세한 사항은 홈페이지 참고 '
    },
    {
      Col1: '사단법인울릉군교육발전위원회',
      Col2: '진학장학금',
      Col3: '지자체',
      Col4: '장학금',
      Col5: '지역연고',
      Col6: '4년제(5~6년제포함)/전문대(2~3년제)',
      Col7: '대학신입생',
      Col8: '공학계열/교육계열/사회계열/예체능계열/의약계열/인문계열/자연계열/제한없음',
      Col9: '수능시험성적 중 2개 영역 합이 4등급 이내 또는 직전학기 내신 성적 석차등급 평균이 3등급 이내 (특성화과는 성취도평균 B등급이내)또는수능시험성적 중 2개 영역 합이 5등급 이내 또는 직전학기 내신 성적 석차등급 평균이 4등급 이내 (특성화과는 성취도평균 C등급이내)',
      Col10: '해당없음',
      Col11: '2000000원 ~ 3000000원 ※ 첨부파일 참고',
      Col12: '울릉고등학교를 졸업하고 대학교에 입학하는 자',
      Col13: '공고일 현재 부모 또는 보호자의 주민등록이 울릉군 내에 있는 울릉고등학교 졸업생 중 대학교 신입생울릉군 내 초등학교 또는 중학교를 졸업 후/ 타 지역 고등학교를 졸업하고 대학교에 재학 중인 학생생 ',
      Col14: '2022-03-04~2022-03-14',
      Col15: '해당없음',
      Col16: '00명',
      Col17: '국가/ 지방자치단체/ 공공단체/ 민간단체/ 학교 등으로부터 장학금을 받는 학생은 차액만 지급입학시 1회 지급저소득층 가정에 한하여 장학금과 별도로 생활안정자금 신청가능',
      Col18: '해당없음',
      Col19: '장학금 신청서주민등록초본(주소변동사항 포함)고등학교 졸업증명서장학신청자 명의의 통장사본성적증명서 재학증명서 * 자세한 사항은 첨부파일 또는 홈페이지 공지사항 참고'
    },